/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.util;

import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEConvertUtil;
import java.util.HashMap;
import java.util.Map;

public class TENeConvertor {
    private static TENeConvertor instance;
    private static Map<String[], String> NEVER_TO_RVER_MAP;

    private TENeConvertor() {
    }

    public static synchronized TENeConvertor getInstance() {
        if (null == instance) {
            instance = new TENeConvertor();
        }
        return instance;
    }

    public String getNeTypeNameByDevType(int devType) {
        int neType = TEGetNEDomainVersion.getInstance().getNeType(devType);
        return TEGetNEDomainVersion.getInstance().getNETypeName(neType);
    }

    public String getNeTypeNameByNeType(int neType) {
        return TEGetNEDomainVersion.getInstance().getNETypeName(neType);
    }

    public String getRVersion(long intVer) {
        for (String[] key : NEVER_TO_RVER_MAP.keySet()) {
            if (intVer < (long)TEConvertUtil.convertVerStrToInt((String)key[0]) || intVer > (long)TEConvertUtil.convertVerStrToInt((String)key[1])) continue;
            return NEVER_TO_RVER_MAP.get(key);
        }
        return null;
    }

    public String getRVersion(String strVer) {
        return this.getRVersion(TEConvertUtil.convertVerStrToInt((String)strVer));
    }

    public static void main(String[] args) {
        System.out.println(TENeConvertor.getInstance().getRVersion(88868362L));
        System.out.println(TENeConvertor.getInstance().getRVersion(88968372L));
        System.out.println(TENeConvertor.getInstance().getRVersion("5.76.01.20"));
        System.out.println(TENeConvertor.getInstance().getRVersion("5.76.06.13"));
    }

    static {
        NEVER_TO_RVER_MAP = new HashMap<String[], String>();
        NEVER_TO_RVER_MAP.put(new String[]{"5.76.06.10", "5.76.06.19"}, "V100R006C00");
        NEVER_TO_RVER_MAP.put(new String[]{"5.76.06.20", "5.76.99.99"}, "V100R006C10");
    }
}

