/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.session;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.netconfcmd.special.TESpicalActinForInterface;
import com.huawei.nglct.session.TEISpecialActionForNetConfXml;
import com.huawei.nglct.session.TESpecialActionForTpNextHop;
import com.huawei.trans.nglct.impl.TETransSwitchName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransNEDataTranslator {
    private static final String VMT_PORT_REG = "^.*Ethernet[0-9]+\\/[0-9]+\\/[0-9]+\\.?[0-9]*$";
    private static final String VMT_TUNNEL_REG = "^Tunnel[0-9]+$";
    private static final String NM_PORT_REG = "^[0-9]+\\-.+\\-.+$";
    private static final String NM_TUNNEL_REG = "^[0-9]+$";
    private static final String XML_HEAD_REG = "<\\?.*\\?>";
    public static final String XML_END_FLAG = "]]>]]>";
    private static final String TUNNEL_PRIX = "Tunnel";
    private static final String GE_PORT_PFIX = "GigabitEthernet";
    private static final String FE_PORT_PFIX = "Ethernet";
    private static final String XML_ENCODING = "UTF-8";
    private static final String FIRST_NODE_SEND = "rpc";
    private static final String FIRST_NODE_RECEIVE = "rpc-reply";
    private static final Set<String> transLatorNodesName = new HashSet<String>();
    private static TransNEDataTranslator instance = null;
    private static final String INTERFACE_CMD_REG = "<ifm xmlns=\"http://www.huawei.com/netconf/vrp\" [^>]*><interfaces>(<interface>.*<am4CfgAddr operation=\"((create)|(delete))\">.*</am4CfgAddr>.*</interface>)+</interfaces></ifm>";
    public static final int SEND = 0;
    public static final int RECEIVE = 1;
    private static final int VLAN_PORT_GAP = 10240;
    private static final int MAX_VLAN_PORT = 12287;
    private static final int NE_LEVEL_PTN_GE = 6;
    private static final Map<String, TEISpecialActionForNetConfXml> MONAME_TO_SPECIALACTIONIMPL_VMT = new HashMap<String, TEISpecialActionForNetConfXml>();
    private static final String STR_NULL0 = "NULL0";
    private static final Map<String, TEISpecialActionForNetConfXml> MONAME_TO_SPECIALACTIONIMPL_VMF = new HashMap<String, TEISpecialActionForNetConfXml>();

    public TransNEDataTranslator() {
        transLatorNodesName.add("ifName");
        transLatorNodesName.add("interfaceName");
        transLatorNodesName.add("outIfName");
        transLatorNodesName.add("inIfName");
        transLatorNodesName.add("tunnelName");
        transLatorNodesName.add("localIfName");
        transLatorNodesName.add("phyIfName");
        transLatorNodesName.add("sourceInterfaceName");
        transLatorNodesName.add("ifParentIfName");
        transLatorNodesName.add("ifTrunkIfName");
        transLatorNodesName.add("memberIfName");
        transLatorNodesName.add("unNumIfName");
        transLatorNodesName.add("xcOutIfName");
        transLatorNodesName.add("xcInIfName");
        transLatorNodesName.add("transportAddrInterface");
        transLatorNodesName.add("outIfaceName");
        transLatorNodesName.add("portIfName");
        transLatorNodesName.add("unnumberedIfName");
        transLatorNodesName.add("vrrpIfName");
        transLatorNodesName.add("efmIfName");
        transLatorNodesName.add("bakIfName");
        transLatorNodesName.add("interface-name");
        transLatorNodesName.add("trapSourceInterfaceName");
        transLatorNodesName.add("tnlIfname");
        transLatorNodesName.add("srcIfName");
        MONAME_TO_SPECIALACTIONIMPL_VMT.put("tpNexthop", new TESpecialActionForTpNextHop());
        MONAME_TO_SPECIALACTIONIMPL_VMF.put("interface", new TESpicalActinForInterface());
    }

    public static synchronized TransNEDataTranslator getInstance() {
        if (instance == null) {
            instance = new TransNEDataTranslator();
        }
        return instance;
    }

    private boolean isNeedTranslator(String content) {
        Iterator<String> itorator = transLatorNodesName.iterator();
        while (itorator.hasNext()) {
            if (content.indexOf("<" + itorator.next() + ">") <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isTranslatorNode(String nodename) {
        return transLatorNodesName.contains(nodename);
    }

    public String translatorReceive(int neid, String rpcReply, boolean isE2E) {
        if (rpcReply == null || !this.isNeedTranslator(rpcReply)) {
            return rpcReply;
        }
        String xmlStr = "";
        try {
            byte[] bytes;
            ByteArrayInputStream bais;
            Document doc;
            NodeList nodeList;
            if (rpcReply.endsWith(XML_END_FLAG)) {
                rpcReply = rpcReply.substring(0, rpcReply.length() - XML_END_FLAG.length());
            }
            if ((nodeList = (doc = TEParseXMLFile.parseFile((InputStream)(bais = new ByteArrayInputStream(bytes = rpcReply.getBytes())))).getElementsByTagName(FIRST_NODE_RECEIVE)).getLength() > 0) {
                Node node = nodeList.item(0);
                if (isE2E) {
                    this.refactorReceiveNetConfXml(neid, node);
                } else {
                    this.translatorReceiveNode(neid, node);
                }
            }
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", XML_ENCODING);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(doc), new StreamResult(bos));
            xmlStr = bos.toString();
            xmlStr = xmlStr.replaceAll(XML_HEAD_REG, "");
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("translatorReceive fail!", (Throwable)ex);
            xmlStr = rpcReply;
        }
        return xmlStr;
    }

    public String translatorSender(int neid, String rpcSend, boolean isE2E) {
        if (rpcSend == null || !this.isNeedTranslator(rpcSend)) {
            return rpcSend;
        }
        String xmlStr = "";
        try {
            byte[] bytes = rpcSend.getBytes();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            Document doc = TEParseXMLFile.parseFile((InputStream)bais);
            NodeList nodeList = doc.getElementsByTagName(FIRST_NODE_SEND);
            if (nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                if (isE2E) {
                    this.refactorSendNetConfXml(neid, node);
                } else {
                    this.translatorSenderNode(neid, node);
                }
            }
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", XML_ENCODING);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(doc), new StreamResult(bos));
            xmlStr = bos.toString();
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("translatorSender fail!", (Throwable)ex);
            xmlStr = rpcSend;
        }
        return xmlStr;
    }

    public void translatorSenderNode(int neid, Node node) {
        NodeList nodeList = node.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node childNode = nodeList.item(i);
            TEISpecialActionForNetConfXml specialObj = MONAME_TO_SPECIALACTIONIMPL_VMT.get(childNode.getNodeName());
            if (specialObj != null) {
                specialObj.actionOnSend(neid, childNode);
            }
            if (this.isTranslatorNode(childNode.getNodeName()) && !childNode.getTextContent().equals("")) {
                String[] splits;
                String content = childNode.getTextContent();
                if (content.matches(NM_TUNNEL_REG)) {
                    long ifNameNum;
                    content = childNode.getNodeName().equals("ifName") || childNode.getNodeName().equals("interfaceName") ? ("".equals(content = new TETransSwitchName().convertToVrpVlanSubPortName(neid, ifNameNum = Long.valueOf(content).longValue())) ? TUNNEL_PRIX + ifNameNum : content) : TUNNEL_PRIX + content;
                } else if (content.matches(NM_PORT_REG) && (splits = content.split("\\-")).length >= 3) {
                    String slotid = splits[0];
                    String portstr = splits[2];
                    Matcher matcher = Pattern.compile("[0-9]+").matcher(portstr);
                    int portid = -1;
                    if (matcher.find()) {
                        portid = Integer.parseInt(matcher.group(0));
                    }
                    content = this.isGEPortLevel(neid, Integer.parseInt(slotid), portid) ? GE_PORT_PFIX : FE_PORT_PFIX;
                    content = content + slotid + "/0/" + portid;
                    Matcher subportMatcher = Pattern.compile("\\.[0-9]+$").matcher(splits[splits.length - 1]);
                    if (subportMatcher.find()) {
                        content = content + subportMatcher.group(0);
                    }
                }
                childNode.setTextContent(content);
            }
            if (childNode.getChildNodes().getLength() <= 0) continue;
            this.translatorSenderNode(neid, childNode);
        }
    }

    public void refactorSendNetConfXml(int neid, Node node) {
        NodeList nodeList = node.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node childNode = nodeList.item(i);
            TEISpecialActionForNetConfXml specialObj = MONAME_TO_SPECIALACTIONIMPL_VMF.get(childNode.getNodeName());
            if (specialObj != null) {
                specialObj.actionOnSend(neid, childNode);
            }
            if (childNode.getChildNodes().getLength() <= 0) continue;
            this.refactorSendNetConfXml(neid, childNode);
        }
    }

    public void refactorReceiveNetConfXml(int neid, Node node) {
    }

    private boolean isGEPortLevel(int neid, int slotid, int portid) {
        int boardType;
        TEConfigurationDataMgr datamgr = TEConfigurationDataMgr.getInstance();
        if (datamgr.isIFboard(boardType = datamgr.getBoardType(neid, slotid))) {
            return true;
        }
        int level = -1;
        level = datamgr.isDynPort(neid, boardType, portid) ? datamgr.getCacheSpeed(neid, slotid, portid) : datamgr.getPortIterfaceLevel(neid, boardType, portid);
        return level == 16388 || level == 16388 || level == 6;
    }

    public void translatorReceiveNode(int neid, Node node) {
        NodeList nodeList = node.getChildNodes();
        TEConfigurationDataMgr datamgr = TEConfigurationDataMgr.getInstance();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node childNode = nodeList.item(i);
            if (this.isTranslatorNode(childNode.getNodeName()) && !childNode.getTextContent().equals("")) {
                String content = childNode.getTextContent();
                if (content.matches(VMT_TUNNEL_REG)) {
                    content = content.replaceAll(TUNNEL_PRIX, "");
                } else {
                    String[] splits;
                    if (STR_NULL0.equals(content) && "ifName".equals(childNode.getNodeName())) {
                        childNode.getParentNode().getParentNode().removeChild(childNode.getParentNode());
                        continue;
                    }
                    if (content.matches(VMT_PORT_REG) && (splits = content.split("\\/")).length >= 3) {
                        String slotidStr = splits[0];
                        Matcher matcher = Pattern.compile("[0-9]+").matcher(slotidStr);
                        matcher.find();
                        int slotid = Integer.parseInt(matcher.group(0));
                        if (slotid > 0) {
                            String[] port = splits[2].split("\\.");
                            int portid = Integer.parseInt(port[0]);
                            content = slotid + "-" + datamgr.getBoardName(neid, slotid) + "-" + this.getPortName(neid, slotid, portid);
                            if (port.length > 1) {
                                int vlanPort = Integer.valueOf(port[1]);
                                content = "" + (vlanPort < 12287 && vlanPort > 10240 ? vlanPort - 10240 : vlanPort);
                            }
                        }
                    }
                }
                childNode.setTextContent(content);
            }
            if (childNode.getChildNodes().getLength() <= 0) continue;
            this.translatorReceiveNode(neid, childNode);
        }
    }

    public String filterIPConfigCmd(String srcMsg) {
        String resMsg;
        Pattern pa = Pattern.compile(INTERFACE_CMD_REG);
        Matcher matcher = pa.matcher(srcMsg);
        if (matcher.find()) {
            TELogFactory.getNormalLogger().info("start filter ipconfig cmd. the src msg is:" + srcMsg);
            resMsg = srcMsg.replaceAll(INTERFACE_CMD_REG, "");
            TELogFactory.getNormalLogger().info("end filter ipconfig cmd. the final msg is:" + resMsg);
        } else {
            resMsg = srcMsg;
        }
        return resMsg;
    }

    public String refactFeatureName(int neid, String srcMsg, int direction) {
        if (!TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_NE_ATTRIBUTE", "NETCONF_CMD_SUPPORT_FEATURE_CONVERT")) {
            return srcMsg;
        }
        List strs = TESpecialAttrMgr.getInstance().getNEAttrListValue(neid, "TE_FUNC_CFG_NE_ATTRIBUTE", "NETCONF_CMD_SUPPORT_FEATURE_CONVERT");
        if (srcMsg.indexOf((String)strs.get(0)) < 0 && srcMsg.indexOf((String)strs.get(1)) < 0) {
            return srcMsg;
        }
        String srcName = "";
        String destName = "";
        if (direction == 0) {
            srcName = (String)strs.get(0);
            destName = (String)strs.get(1);
        } else if (direction == 1) {
            srcName = (String)strs.get(1);
            destName = (String)strs.get(0);
        }
        TELogFactory.getNormalLogger().info("start convert featurename, src msg is:" + srcMsg);
        String resStr = srcMsg.replaceAll("<" + srcName, "<" + destName);
        resStr = resStr.replaceAll(srcName + ">", destName + ">");
        TELogFactory.getNormalLogger().info("end convert featurename, dest msg is:" + resStr);
        return resStr;
    }

    private String getPortName(int neID, int slotID, int portID) {
        String defautName = portID + "(" + "PORT-" + portID + ")";
        return defautName;
    }
}

