/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.session;

import com.huawei.nglct.session.LCTSender;
import com.huawei.nglct.vmtacc.LctIpProvider;
import com.huawei.vmf.netconf.datadefination.CommunicateArg;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.IAsyncRpcHandler;
import com.huawei.vmf.netconf.service.IRpc;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.session.DefaultSession;
import com.huawei.vmf.netconf.session.ISession;
import com.huawei.vmf.netconf.session.MessageUnit;
import com.huawei.vmf.netconf.transport.ITransport;
import com.huawei.vmf.netconf.transport.ITransportListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public class LCTSession
extends DefaultSession
implements ISession,
ITransportListener {
    private int neid;
    private CommunicateArg arg;
    private boolean isE2E = false;
    private AtomicInteger messageID;

    public CommunicateArg getCommunicationArg() {
        return this.arg;
    }

    public LCTSession(String devIP) throws NetconfException {
        super(null, new Double(Math.random()).intValue(), null);
        this.arg = new CommunicateArg(devIP, "", "", "", "", 0);
        this.messageID = new AtomicInteger(0);
        this.neid = LctIpProvider.getInstance().getNeIdByIdentityIp(devIP);
        this.isE2E = true;
    }

    public LCTSession(int devID, String devIP) throws NetconfException {
        super(null, new Double(Math.random()).intValue(), null);
        this.arg = new CommunicateArg(devIP, "", "", "", "", 0);
        this.messageID = new AtomicInteger(0);
        this.neid = devID;
        this.isE2E = false;
    }

    public void setE2EFlg(boolean isE2E) {
        this.isE2E = isE2E;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LctSession [ip=");
        builder.append(this.arg.getIp());
        builder.append("]");
        return builder.toString();
    }

    public void aSynSend(IRpc reqCmd, IAsyncRpcHandler netconfHandle) throws NetconfException {
    }

    public boolean close() {
        this.setE2EFlg(false);
        return false;
    }

    public void createTransport() throws NetconfException {
    }

    public boolean hasCapability(int deviceCapability) {
        return false;
    }

    public boolean isConnected() {
        return true;
    }

    public Collection<IRpcReply> pSynSend(Collection<IRpc> reqCmds) throws NetconfException {
        ArrayList<IRpcReply> replys = new ArrayList<IRpcReply>(reqCmds.size());
        for (IRpc reqCmd : reqCmds) {
            IRpcReply reply = this.synSend(reqCmd);
            if (null == reply) continue;
            replys.add(reply);
        }
        return replys;
    }

    public IRpcReply synSend(IRpc reqCmd) throws NetconfException {
        if (reqCmd == null) {
            throw new NetconfException(-1, "can't send null rpc request.");
        }
        int msgID = this.messageID.incrementAndGet();
        MessageUnit unit = new MessageUnit((DefaultSession)this, reqCmd, msgID);
        LCTSender sender = new LCTSender();
        IRpcReply rsp = sender.sendCmd(this.neid, unit, this.isE2E);
        return rsp;
    }

    public void handleTransportClosed(ITransport transport, NetconfException e) {
        super.handleTransportClosed(transport, e);
    }
}

