/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.session;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.session.TransNEDataTranslator;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import com.huawei.vmf.netconf.datadefination.RspCmd;
import com.huawei.vmf.netconf.error.NetconfException;
import com.huawei.vmf.netconf.service.IRpcReply;
import com.huawei.vmf.netconf.session.MessageUnit;
import com.huawei.vmf.netconf.tool.PlatformCipherTool;
import java.util.ArrayList;

public class LCTSender
extends TENEExplorerBean {
    private static final String UN_LOGIN = "37889;37926;37126";
    private static final int CONTAIN_INVALID_CHAR = 1107427140;
    private static final int PWD_END_FLAG_LENGTH = "]]-]]--".length();
    private static final int PWD_START_FLAG_LENGTH = "++[[+[[".length();
    private static final int TIME_OUT = 60;

    public IRpcReply sendCmd(int lctNEID, MessageUnit unit, boolean isE2E) throws NetconfException {
        if (-1 != lctNEID) {
            TransNEDataTranslator translator = TransNEDataTranslator.getInstance();
            String messages = translator.translatorSender(lctNEID, unit.serialize(), isE2E);
            messages = translator.filterIPConfigCmd(messages);
            messages = translator.refactFeatureName(lctNEID, messages, 0);
            RspCmd rsp = null;
            Operation infectionOp = new Operation();
            infectionOp.setCmdid(45089);
            infectionOp.setName("NSCMD_VRP");
            infectionOp.setInput(new Input());
            Input input = infectionOp.getInput();
            input.addPart(new Part());
            Part part = input.getPart(0);
            part.setName("netconfxml");
            part.setValue(this.replacePwd(messages, lctNEID) + "]]>]]>");
            part.setType("var");
            infectionOp.addOutput(new Output());
            infectionOp.getOutput(0).addPart(new Part());
            infectionOp.getOutput(0).getPart(0).setName("content");
            infectionOp.getOutput(0).getPart(0).setType("var");
            Fault fault = new Fault();
            fault.setCode("0");
            infectionOp.getOutput(0).addFault(fault);
            this.operationList = new ArrayList();
            this.operationList.add(infectionOp);
            if (part.getValue().length() != part.getValue().getBytes().length) {
                TELogFactory.getNormalLogger().error("this netconf xml contain invalid charactor! " + unit.serialize());
                return new RspCmd(this.buildLctExceptionStringForVmtCallback(1107427140, TEErrorResourceUtil.getErrCodeResWithDot((int)lctNEID, (int)1107427140)));
            }
            int result = this.checkLogin(lctNEID);
            if (result == 0) {
                result = this.sendMessage(lctNEID, this.operationList);
            }
            if (result == 0) {
                Operation oper = (Operation)this.operationList.get(0);
                int errorCode = Integer.parseInt(oper.getOutput(0).getFault(0).getCode());
                if (0 == errorCode) {
                    Output output = null;
                    int m = oper.getOutputCount();
                    for (int i = 0; i < m; ++i) {
                        output = oper.getOutput(i);
                        String content = output.getPartValue("content");
                        content = translator.refactFeatureName(lctNEID, content, 1);
                        TELogFactory.getNormalLogger().info("neid:" + lctNEID + ", receive netconf message: " + content);
                        rsp = new RspCmd(translator.translatorReceive(lctNEID, content, isE2E));
                        unit.setResp((IRpcReply)rsp);
                    }
                } else {
                    rsp = new RspCmd(this.buildLctExceptionStringForVmtCallback(errorCode, TEErrorResourceUtil.getErrCodeResWithDot((int)lctNEID, (int)errorCode)));
                }
            } else {
                ErrorMessage em = TEErrorResourceUtil.getErrorMessage((int)result);
                rsp = new RspCmd(this.buildLctExceptionStringForVmtCallback(result, em.getErrorinfo()));
            }
            return rsp;
        }
        return null;
    }

    private String buildLctExceptionStringForVmtCallback(int errorCode, String erroInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append("<rpc-reply message-id=\"1\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><rpc-error>");
        sb.append("<error-app-tag>");
        sb.append(errorCode);
        sb.append("</error-app-tag>");
        sb.append("<error-message>");
        sb.append(erroInfo);
        sb.append("</error-message></rpc-error></rpc-reply>");
        return sb.toString();
    }

    private int checkLogin(int neid) {
        if (!TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neid)) {
            return 1090609665;
        }
        return 0;
    }

    private String replacePwd(String request, int neID) {
        int startIndex;
        StringBuilder byteInfo = new StringBuilder();
        if (null == request || request.isEmpty()) {
            return byteInfo.toString();
        }
        int endIndex = startIndex = 0;
        boolean finish = true;
        boolean isPwd = false;
        int length = request.length();
        while (startIndex < length) {
            if (finish) {
                endIndex = request.indexOf("++[[+[[", startIndex);
                if (endIndex < 0) break;
                byteInfo.append(request.substring(startIndex, endIndex));
                startIndex = endIndex + PWD_START_FLAG_LENGTH;
                finish = false;
                continue;
            }
            endIndex = request.indexOf("]]-]]--", startIndex);
            if (endIndex < 0) {
                TELogFactory.getNormalLogger().info("XML is not correct, has not end flag from index=" + startIndex);
                return "";
            }
            String tmpPwd = request.substring(startIndex, endIndex);
            byteInfo.append(new String(PlatformCipherTool.decrypt((String)tmpPwd)));
            startIndex = endIndex + PWD_END_FLAG_LENGTH;
            isPwd = true;
            finish = true;
        }
        byteInfo.append(request.substring(startIndex, request.length()));
        if (!isPwd) {
            TELogFactory.getNormalLogger().info("neid:" + neID + ", send netconf message: " + byteInfo.toString());
        } else {
            this.subfunc = new SubFunc();
            this.subfunc.setIsPwdNoLog(true);
            TELogFactory.getNormalLogger().info("neid:" + neID + ", send netconf message: filter message!");
        }
        return byteInfo.toString();
    }

    public int getTimeOut() {
        return 60;
    }
}

