/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.dao;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.po.embeddednemgrmo.TEEthGneMOPO;
import com.huawei.nglct.po.embeddednemgrmo.TENEMOPO;
import com.huawei.nglct.util.TENeConvertor;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevTypeInfo;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TETransInvMgr {
    public static boolean isTransMo(Class mo) {
        return mo.isAssignableFrom(DevSysInfo.class) || mo.isAssignableFrom(DevTypeInfo.class) || mo.isAssignableFrom(Interface.class);
    }

    public static <T> Collection<T> getTransInv(Class<T> moClazz) {
        if (moClazz.isAssignableFrom(DevSysInfo.class)) {
            return TETransInvMgr.getDevSysInfos(moClazz);
        }
        if (moClazz.isAssignableFrom(DevTypeInfo.class)) {
            return TETransInvMgr.getDevTypeInfos(moClazz);
        }
        return null;
    }

    public static <T> Collection<T> getDevSysInfos(Class<T> moClazz) {
        ArrayList<DevSysInfo> rs = new ArrayList<DevSysInfo>();
        try {
            TEDaoOperationResult drb = TECommonDaoService.findAll_NonLock(TENEMOPO.class);
            if (0 != drb.getResult()) {
                TELogFactory.getembededWnemgrLogger().error("Get all ne mo failed!");
            } else {
                List cmgrNEList = drb.getData();
                if (cmgrNEList.isEmpty()) {
                    TELogFactory.getembededWnemgrLogger().info("The size of neList is 0.");
                }
                for (Object obj : cmgrNEList) {
                    TENEMOPO nepo = (TENEMOPO)obj;
                    String devTypeName = TENeConvertor.getInstance().getNeTypeNameByDevType(nepo.getType());
                    String rVersion = TENeConvertor.getInstance().getRVersion(nepo.getVersion());
                    if (devTypeName == null || "".equals(devTypeName) || rVersion == null) {
                        TELogFactory.getNormalLogger().error("this ne mo can not be suite for adding to vmf devsysinfo cache!" + nepo.toString());
                        continue;
                    }
                    DevSysInfo devSysInfo = new DevSysInfo();
                    devSysInfo.setDevIP(TETransInvMgr.getIPFromTrans(nepo.getNEID()));
                    devSysInfo.setDevID(Integer.valueOf(Long.valueOf(nepo.getNEID()).intValue()));
                    devSysInfo.setDevProductName(devTypeName);
                    devSysInfo.setDevProductVersion(rVersion);
                    devSysInfo.setDevSysOID(String.valueOf(nepo.getPhyID()));
                    devSysInfo.setDevTypeID(Integer.valueOf(nepo.getType()));
                    devSysInfo.setDevRole(Integer.valueOf(0));
                    devSysInfo.setDevName(nepo.getName());
                    rs.add(devSysInfo);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("query dev inventory failed!", (Throwable)e);
        }
        return rs;
    }

    public static <T> Collection<T> getDevTypeInfos(Class<T> moClazz) {
        ArrayList<DevTypeInfo> rs = new ArrayList<DevTypeInfo>();
        try {
            TEDaoOperationResult drb = TECommonDaoService.findAll_NonLock(TENEMOPO.class);
            if (0 != drb.getResult()) {
                TELogFactory.getembededWnemgrLogger().error("Get all ne mo failed!");
            } else {
                List cmgrNEList = drb.getData();
                if (cmgrNEList.isEmpty()) {
                    TELogFactory.getembededWnemgrLogger().info("The size of neList is 0.");
                }
                for (Object obj : cmgrNEList) {
                    TENEMOPO nepo = (TENEMOPO)obj;
                    String devTypeName = TENeConvertor.getInstance().getNeTypeNameByDevType(nepo.getType());
                    String rVersion = TENeConvertor.getInstance().getRVersion(nepo.getVersion());
                    if (devTypeName == null || "".equals(devTypeName) || rVersion == null) {
                        TELogFactory.getNormalLogger().error("this ne mo can not be suite for adding to vmf ne devtypeinfo cache!" + nepo.toString());
                        continue;
                    }
                    DevTypeInfo devTypeInfo = new DevTypeInfo();
                    devTypeInfo.setDevTypeID(Integer.valueOf(nepo.getType()));
                    devTypeInfo.setDevVersionID(Integer.valueOf(6));
                    devTypeInfo.setDevTypeName(devTypeName);
                    devTypeInfo.setDevVersionName(rVersion);
                    devTypeInfo.setSupPortLic(Integer.valueOf(0));
                    devTypeInfo.setDevSysOID(String.valueOf(nepo.getPhyID()));
                    rs.add(devTypeInfo);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("query dev inventory failed!", (Throwable)e);
        }
        return rs;
    }

    private static String getIPFromTrans(long neid) {
        ArrayList<TEDaoNameValuePair> cr = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair p = new TEDaoNameValuePair();
        p.setName("LogicNeId");
        p.setValue(String.valueOf(neid));
        cr.add(p);
        TEDaoOperationResult drb = TECommonDaoService.findByID(TEEthGneMOPO.class, cr);
        if (drb.getResult() == 0 && !drb.getData().isEmpty()) {
            TEEthGneMOPO gne = (TEEthGneMOPO)drb.getData().get(0);
            return TEConvertUtil.ipToString((long)gne.getIp());
        }
        return "0.0.0.0";
    }
}

