/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.dao;

import com.huawei.nglct.cbb.log.TELogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;

public class TECommonDao {
    private StatelessSession session;

    public TECommonDao(StatelessSession session) {
        this.session = session;
    }

    public void save(Object obj) {
        ArrayList<Object> objLst = new ArrayList<Object>();
        objLst.add(obj);
        this.saveAll(objLst);
    }

    public void saveAll(Collection<Object> lstObj) {
        if (lstObj == null || lstObj.isEmpty()) {
            return;
        }
        Transaction tx = this.session.beginTransaction();
        try {
            for (Object obj : lstObj) {
                this.session.insert(obj);
            }
            tx.commit();
        }
        catch (HibernateException e) {
            tx.rollback();
            TELogFactory.getNormalLogger().error(e.toString());
        }
    }

    public void delete(Object obj) {
        ArrayList<Object> objLst = new ArrayList<Object>();
        objLst.add(obj);
        this.deleteObjLst(objLst);
    }

    public void deleteObjLst(Collection<Object> objLst) {
        if (objLst == null || objLst.isEmpty()) {
            return;
        }
        Transaction tx = this.session.beginTransaction();
        try {
            for (Object obj : objLst) {
                this.session.delete(obj);
            }
            tx.commit();
        }
        catch (HibernateException e) {
            tx.rollback();
            TELogFactory.getNormalLogger().error("deleteObjLst() error.", (Throwable)e);
        }
    }

    public List<Object> getListByHql(String hql, Map<String, Object> params) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            Query query = this.session.createQuery(hql);
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            list.addAll(query.setCacheable(true).list());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getListByHql() error", (Throwable)e);
        }
        return list;
    }
}

