 var sfidquery = TECMDCODE_OSN_GET_RSVP_IDENTIFY;//    sfid
var sfidset = TECMDCODE_OSN_SET_RSVP_IDENTIFY;//    sfid

var rsvpTable;

var urlObject = getNeProperty(self);// the URL object of this page
var neID = urlObject.neid; // network element id
var nmUsrID = urlObject.nmUser;// network manager userID, write operation log
var nmUserName = urlObject.nmUserName;// network manager userName
var btnRightArr = new Object();// save to button right

var CODE_FAULT = 2; // operation fault erroeCode
var CODE_PARTSUCC = 1;// part success errorCode
var CODE_SUCC = 0;// operation success errorCode

/**
 * initialize this page
 * 
 * @param data:
 *            NO
 * @return NO
 */
function initPage()
{
	initTable(); // initialize the rsvpTable
	initButton(); // initialize buttons

	var rightURL = "../../../../../securityServlet?neID=" + neID + "&nmUser="
			+ nmUsrID;
	getRightInfo(urlObject, btnRightArr);

	doQuery(); // run query
}

/**
 * initialize rsvpTable
 * 
 * @param data:NO
 * @return NO
 */
function initTable()
{
	rsvpTable = new SortTable();

	rsvpTable.setImage("../../../../../images/");

	createTableHead(rsvpTable, window.tableconf[0]);

	rsvpTable.setOnRowSelectHandler(rowSelectHandler);

	rsvpTable.setOnCellEditHandler(handleCellDbClickEvent);

	$("tablediv").appendChild(rsvpTable.getTable());

	$("tablediv").oncontextmenu = popupMenuHandler;

	rsvpTable.setBodyHeight(getComponetHeight($("tablediv"), 60) + "px");
	rsvpTable.setBodyWidth(window.tableconf[0].width,
			window.tableconf[0].percent, 0);
}

/**
 * initialize button enable status
 * 
 * @param data:NO
 * @return NO
 */
function initButton()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("newbtn").value = RESOURCE["newbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("deletebtn").value = RESOURCE["deletebutton"];
	$("printbtn").value = RESOURCE["printbutton"];
	$("totalrowsword").innerHTML = RESOURCE["totalrows"];
	$("selrowsword").innerHTML = RESOURCE["seleterows"];

	btnRightArr.querybtn = new BtnRightObj("querybtn", sfidquery);
	btnRightArr.newbtn = new BtnRightObj("newbtn", sfidset);
	btnRightArr.applybtn = new BtnRightObj("applybtn", sfidset);
	btnRightArr.deletebtn = new BtnRightObj("deletebtn", sfidset);

}

/**
 * enable the delete button  change sleceted rows
 * 
 * @param selectedNum
 * @return NO
 */
function rowSelectHandler(selectedNum)
{
	var rows = rsvpTable.getSelectedRowCount();
	$("deletebtn").disabled = (rows ? !btnRightArr.deletebtn.right : true);
	handleStatisticInfo(rows);
}

/**
 * applybtn enabled status
 */
function handleCellDbClickEvent()
{
	$("applybtn").disabled = !btnRightArr.applybtn.right;
}

/**
 * statistic how many rows be selected and total rows fo the rsvpTable
 * 
 * @param selectedNum
 * @return NO
 */
function handleStatisticInfo(selectedNum)
{
	var totalNum = rsvpTable.getDataRowLength();// get total rows
	$("totalrows").innerHTML = totalNum;// display total rows on page
	$("selrows").innerHTML = selectedNum;// display selected rows on page
}

/**
 * operate query
 * 
 * @param data:no
 * @return no
 */
function doQuery()
{
	if (!btnRightArr.querybtn.right)
	{
		return;
	}
	setBtnStatus( [ $("querybtn"), $("newbtn"), $("deletebtn"), $("applybtn"),
			$("printbtn") ], true);

	var queryURL = "../../../../../tl1NEExlorerServlet?sfid=" + sfidquery
			+ "&nmUser=" + nmUsrID;
	var xmlData = createQueryXMLInfo(neID);// construct query XML

	loadXMLdoc(queryURL, "POST", true, handleQueryBack, null, "inputdata="
			+ xmlData);// send query request

}

/**
 * handle callback function of query
 * 
 * @param doc
 * @return no
 */
function handleQueryBack(doc)
{
	var data = EncapsulateData(doc);

	if (CODE_FAULT != data.getSErrorCode())
	{
		rsvpTable.clearTableData();// clear rsvpTable data
		createTableBody(rsvpTable, window.tableconf[0], data, RESOURCE);
	}

	handleQueryErrInfo(data);// hanlde query error

	$("querybtn").disabled = !btnRightArr.querybtn.right;
	$("newbtn").disabled = !btnRightArr.newbtn.right;
	$("printbtn").disabled = !btnRightArr.querybtn.right;

	handleStatisticInfo(0);

	addListenser();
}

function addListenser()
{
	var cell;
	for ( var i = 0, len = rsvpTable.getDataRowLength(); i < len; i++)
	{
		cell = rsvpTable.getCell(i, "authenType");
		cell.element.editElement.element.onchange = function()
		{
			var index = this.parentNode.parentNode.rowIndex;
			var codecell = rsvpTable.getCell(index, "authenCode");

			if (this.value == "MD5")
			{
				rsvpTable.setCellValue(codecell, "authenCode", "AOSV100R002");
				rsvpTable.setAtomValue(rsvpTable.getCellShow(index,
						"authenCode"), "AOSV100R002");

				rsvpTable.setCellIsEdit(codecell, 1);
				codecell.element.disabled = false;
				codecell.element.style.backgroundColor = "#d0f946";
			}

			if (this.value == "TEXT")
			{
				rsvpTable.setCellValue(codecell, "authenCode", "");
				rsvpTable.setAtomValue(rsvpTable.getCellShow(index,
						"authenCode"), "");

				rsvpTable.setCellIsEdit(codecell, 1);
				codecell.element.disabled = false;
				codecell.element.style.backgroundColor = "#d0f946";

			}

			if (this.value == "NONE")
			{
				rsvpTable.setCellValue(codecell, "authenCode", "");

				rsvpTable.setCellIsEdit(codecell, 0);
				codecell.element.disabled = true;
				codecell.element.showElement.setValue("-");
				codecell.element.style.backgroundColor = "";
			}

			codecell.element.modify = true;
		}

		cell = rsvpTable.getCell(i, "authenCode");
		cell.element.editElement.element.maxLength = 64;
		cell.element.editElement.element.onkeyup = function()
		{
			return calStrSinoLen(this, 64);
		}
	}
}

/**
 * operate modify
 * 
 * @param no
 * @return no
 */
function doApply()
{
	if (!btnRightArr.applybtn.right)
	{
		return;
	}

	if (!confirm(RESOURCE["confirminfo"]))
	{
		return;
	}

	var xmlData = constructApplyXML();
	if (xmlData == null)
	{
		return;
	}

	setBtnStatus( [ $("querybtn"), $("newbtn"), $("deletebtn"), $("applybtn"),
			$("printbtn") ], true);

	var applyURL = "../../../../../tl1NEExlorerServlet?sfid=" + sfidset
			+ "&nmUser=" + nmUsrID;// come from macrores.js
	loadXMLdoc(applyURL, "POST", true, handleApplyBack, null, "inputdata="
			+ xmlData);// send modify request
}

/**
 * construct modify XML
 * 
 * @param data:
 *            no
 * @return xml
 */
function constructApplyXML()
{
	var root = new inputxml("datainterface");
	var firstLevel = new tagElement("bussiness-params");

	var secondLevel, thirdLevel;

	for ( var i = 0, size = rsvpTable.getDataRowLength(); i < size; i++)
	{
		if (rsvpTable.getModify(i))
		{
			secondLevel = new tagElement("row-params");

			thirdLevel = new tagElement("param");
			thirdLevel.setAttribute("name", "neid");
			thirdLevel.setAttribute("value", neID);
			secondLevel.appendChild(thirdLevel);

			thirdLevel = new tagElement("param");
			thirdLevel.setAttribute("name", "neighborNode");
			thirdLevel.setAttribute("value", rsvpTable.getCellStoreValue(i,
					"neighborNode", "neighborNode"));
			secondLevel.appendChild(thirdLevel);

			thirdLevel = new tagElement("param");
			thirdLevel.setAttribute("name", "authenType");
			var authenType = rsvpTable.getCellStoreValue(i, "authenType",
					"authenType");
			thirdLevel.setAttribute("value", authenType);
			secondLevel.appendChild(thirdLevel);

			thirdLevel = new tagElement("param");
			thirdLevel.setAttribute("name", "authenCode");
			var authCode = rsvpTable.getCellStoreValue(i, "authenCode",
					"authenCode");
			if (authenType != "NONE" && authCode.trim() == "")
			{
				alert(RESOURCE["authcodenull"]);
				return null;
			}
			thirdLevel.setAttribute("value", authCode);
			secondLevel.appendChild(thirdLevel);

			thirdLevel = new tagElement("param");
			thirdLevel.setAttribute("name", "operType");
			thirdLevel.setAttribute("value", "0");
			secondLevel.appendChild(thirdLevel);

			firstLevel.appendChild(secondLevel);
		}
	}

	root.getRoot().appendChild(firstLevel);

	return root.toString();
}

/**
 * handle callback function of modify
 * 
 * @param doc
 * @return no
 */
function handleApplyBack(doc)
{
	var data = EncapsulateData(doc);
	var applybtnStatus = !(CODE_SUCC != data.getSErrorCode());
	$("applybtn").disabled = applybtnStatus;

	refreshTableState(rsvpTable, window.tableconf[0], data);

	setBtnStatus( [ $("querybtn"), $("newbtn"), $("printbtn") ], false);

	rowSelectHandler();// change the applybtn status
	handleErrInfo(data);

}

/**
 * operate delete
 * 
 * @param no
 * @return no
 */
function doDelete()
{
	if (!btnRightArr.deletebtn.right)
	{
		return;
	}

	if (0 == rsvpTable.getSelectedRowCount())
	{
		alert(RESOURCE["noselected"]);
		return;
	}

	if (!confirm(RESOURCE["isconfirmdelete"]))
	{
		return;
	}

	setBtnStatus( [ $("querybtn"), $("newbtn"), $("deletebtn"), $("applybtn"),
			$("printbtn") ], true);

	var xmlData = constructDeleteXML();
	var deleteURL = "../../../../../tl1NEExlorerServlet?sfid=" + sfidset
			+ "&nmUser=" + nmUsrID;// come from macrores.js
	loadXMLdoc(deleteURL, "POST", true, handleDeleteBack, null, "inputdata="
			+ xmlData);// send delete request
}

/**
 * construct delete XML
 * 
 * @param data:
 *            no
 * @return xml
 */
function constructDeleteXML()
{
	var root = new inputxml("datainterface");
	var firstLevel = new tagElement("bussiness-params");
	var selectedRows = rsvpTable.getSelectedRows();

	var secondLevel, thirdLevel;

	for ( var i = 0, size = selectedRows.length; i < size; i++)
	{
		secondLevel = new tagElement("row-params");
		thirdLevel = new tagElement("param");
		thirdLevel.setAttribute("name", "neid");
		thirdLevel.setAttribute("value", neID);
		secondLevel.appendChild(thirdLevel);

		thirdLevel = new tagElement("param");
		thirdLevel.setAttribute("name", "neighborNode");
		thirdLevel.setAttribute("value", rsvpTable.getCellStoreValue(
				selectedRows[i], "neighborNode", "neighborNode"));
		secondLevel.appendChild(thirdLevel);

		thirdLevel = new tagElement("param");
		thirdLevel.setAttribute("name", "authenType");
		thirdLevel.setAttribute("value", "NONE");
		secondLevel.appendChild(thirdLevel);

		thirdLevel = new tagElement("param");
		thirdLevel.setAttribute("name", "authenCode");
		thirdLevel.setAttribute("value", "");
		secondLevel.appendChild(thirdLevel);

		thirdLevel = new tagElement("param");
		thirdLevel.setAttribute("name", "operType");
		thirdLevel.setAttribute("value", "2");
		secondLevel.appendChild(thirdLevel);

		firstLevel.appendChild(secondLevel);

	}

	root.getRoot().appendChild(firstLevel);

	return root.toString();
}

/**
 * handle callback function of delete
 * 
 * @param doc
 * @return no
 */
function handleDeleteBack(doc)
{
	var data = EncapsulateData(doc);
	var bigError = data.getSErrorCode();
	var selectedRows = rsvpTable.getSelectedRows();
	var neighborNode;

	if (CODE_PARTSUCC == bigError)// part of Success
	{
		for ( var i = 0, errLen = data.getError().getRowErrLength(); i < errLen; i++)
		{
			for ( var j = 0, size = selectedRows.length; j < size; j++)
			{
				neighborNode = rsvpTable.getCellStoreValue(selectedRows[j],
						"neighborNode", "neighborNode");
				if (neighborNode == data.getError()
						.getRowKey(i, "neighborNode"))
				{
					selectedRows.splice(j, 1);
					break;
				}
			}
		}
	}

	if ((CODE_PARTSUCC == bigError) || (CODE_SUCC == bigError))
	{
		for ( var k = selectedRows.length - 1; k >= 0; k--)
		{
			rsvpTable.deleteRow(selectedRows[k]);
		}

		rsvpTable.adjustDataRows();
		adjustTableLayout(rsvpTable, window.tableconf[0], rsvpTable
				.getDataRowLength());
	}

	handleErrInfo(data);
	handleStatisticInfo(rsvpTable.getSelectedRowCount());

	$("querybtn").disabled = !btnRightArr.querybtn.right;
	$("newbtn").disabled = !btnRightArr.newbtn.right;
	$("printbtn").disabled = !btnRightArr.querybtn.right;

	if (CODE_SUCC != bigError)
	{
		$("deletebtn").disabled = false;
	}
}

/**
 * operate create
 * 
 * @param no
 * @return no
 */
function doCreate()
{
	xshowModalDialog("rsvpcreatedlg.html", RESOURCE["rsvpcreatetitle"], 400,
			185, "../../../../../images/");
}

/**
 * handle query error
 * 
 * @param data
 * @return no
 */
function handleQueryErrInfo(data)
{
	var errArr = [];// define errors object
	errArr.push("nename");

	openErrPage("../../../../../page/", data.getError(), errArr);
}

/**
 * handle operate error
 */
function handleErrInfo(data)
{
	var errArr = [];// define errors object
	errArr.push("nename");
	errArr.push("NEIGHBORNODE");

	var errData = data.getError();
	var neightborNode;

	for ( var i = 0, len = errData.getRowErrLength(); i < len; i++)
	{
		neightborNode = errData.getRowKey(i, "neighborNode");
		errData.rowErrors[i].errorObj["neighborNode"] = neightborNode;
	}

	openErrPage("../../../../../page/", errData, errArr);
}

/**
 * print table data
 * 
 * @param data:no
 * @return no
 */
function doPrint()
{
	if (0 == rsvpTable.getDataRowLength())
	{
		alert(RESOURCE["nodata"]);//            
		return;
	}
	openPrintPage("../../../../../page/", RESOURCE["rsvp"], "rsvpTable", true,
			nmUserName);
}

/**
 * insert rsvp data created into the table
 */
function addCreatedRSVPData(datainterface, neighborNode)
{
	var neighborNodeExist;
	var exist = false;
	for ( var i = 0, len = rsvpTable.getDataRowLength(); i < len; i++)
	{
		neighborNodeExist = rsvpTable.getCellStoreValue(i, "neighborNode",
				"neighborNode");
		if (neighborNodeExist == neighborNode)
		{
			exist = true;
			rsvpTable.element.datarows[i].element.cols["authenType"].element.currentValue["authenType"] = datainterface.rows[0]["authenType"].value;
			rsvpTable.element.datarows[i].element.cols["authenType"].element.showElement
					.setValue(RESOURCE[datainterface.rows[0]["authenType"].value]);
			rsvpTable.element.datarows[i].element.cols["authenType"].element.storeValue["authenType"] = datainterface.rows[0]["authenType"].value;
			rsvpTable.element.datarows[i].element.cols["authenCode"].element.currentValue["authenCode"] = datainterface.rows[0]["authenCode"].value;
			rsvpTable.element.datarows[i].element.cols["authenCode"].element.showElement
					.setValue(datainterface.rows[0]["authenCode"].value);
			rsvpTable.element.datarows[i].element.cols["authenCode"].element.storeValue["authenCode"] = datainterface.rows[0]["authenCode"].value;
			break;
		}
	}

	if (!exist)
	{
		createTableBody(rsvpTable, window.tableconf[0], datainterface, RESOURCE);

		rsvpTable.sortRows(rsvpTable.getHeadCell("neighborNode").element, 1);
		handleStatisticInfo(0);
	}

}

/**
 * if this page size be changed, then change the rsvpTable size
 * 
 * @param data:no
 * @return no
 */
window.onresize = function()
{
	rsvpTable.setBodyHeight(getComponetHeight($("tablediv"), 75) + "px");
}

/**
 * evict table object
 * 
 * @param no
 * @return no
 */
window.onunload = function()
{
	clearSortTable(rsvpTable);// call this function of the table_new.js file
}
