 var sfidquery = TECMDCODE_QUERY_OSPF_PROTOCOL;//    sfid
var sfidset = TECMDCODE_SET_OSPF_PROTOCOL;//    sfid

var winobj = getNeProperty(self);
var ospfProtoMgrTable;
var countObj;
var hasQueryRight = true;
var hasSetRight = true;

/**
 *    OSPF      
 * 
 * @param  
 * @return  
 */
function initBody()
{

	initTable();
	initButton();
	if (SYSTEMCONF.getStatus() == 1)
	{
		queryOSPFProtocol(); //     OSPF  
	}
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	ospfProtoMgrTable = new SortTable();

	ospfProtoMgrTable.setImage("../../../../../images/");

	ospfProtoMgrTable.setOnCellEditHandler(cellEditHandler);

	ospfProtoMgrTable.setOnRowSelectHandler(rowSelectHandler);

	createTableHead(ospfProtoMgrTable, window.tableconf[0]);

	$("tablecomponent").appendChild(ospfProtoMgrTable.getTable());

	ospfProtoMgrTable.setBodyHeight(getComponetHeight($("tablecomponent"), 60)
			+ "px");

	$("tablecomponent").oncontextmenu = popupMenuHandler;

	countObj = new TableDataCount();
	$("dataCount").appendChild(countObj.getCountArea());
}

/**
 *               
 * 
 * @param data: 
 * @return  
 */
window.onresize = function()
{
	ospfProtoMgrTable.setBodyHeight(getComponetHeight($("tablecomponent"), 60)
			+ "px");
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initButton()
{
	$("queryBtn").value = RESOURCE["querybutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
	$("printBtn").value = RESOURCE["printbutton"];

	var url = "../../../../../securityServlet?neID=" + winobj["neid"]
			+ "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata="
			+ createQueryRightXMLInfo());
}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQueryRightXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	row = new tagElement("row-params");
	param = new tagElement("param");
	param.setAttribute("name", "sfid");
	param.setAttribute("value", sfidquery);
	row.appendChild(param);
	bussiness.appendChild(row);

	row = new tagElement("row-params");
	param = new tagElement("param");
	param.setAttribute("name", "sfid");
	param.setAttribute("value", sfidset);
	row.appendChild(param);
	bussiness.appendChild(row);

	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *             
 * 
 * @param doc:         
 * @return  
 */
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
	var right = data.getDataRowParam(0, "right");
	if (right == 1)
	{
		hasQueryRight = true;//        
	}
	else
	{
		hasQueryRight = false;//         
	}
	right = data.getDataRowParam(1, "right");
	if (right == 1)
	{
		hasSetRight = true;//        
	}
	else
	{
		hasSetRight = false;//         
		setTableDisabled(window.tableconf[0]);
	}

	$("queryBtn").disabled = !hasQueryRight;
	$("printBtn").disabled = !hasQueryRight;
	$("applyBtn").disabled = true;
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if (!hasSetRight)
	{
		return;
	}
	else
	{
		$("applyBtn").disabled = false; //         
	}
}

/**
 *              
 * 
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
	countObj.setSelectedCount(rows.length);
}

/**
 *       
 * 
 * @param  
 * @return  
 */
function queryOSPFProtocol()
{
	if (!hasQueryRight)
	{
		return;
	}
	setBtnStatus( [ $("queryBtn"), $("applyBtn"), $("printBtn") ], true);

	var url = "../../../../../tl1NEExlorerServlet?sfid=" + sfidquery
			+ "&nmUser=" + winobj["nmUser"];

	loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata="
			+ createQueryXMLInfo(winobj["neid"]));
}

/**
 *              
 * 
 * @param doc:          
 * @return  
 */
function queryCallBack(doc)
{
	var data = EncapsulateData(doc);

	if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		ospfProtoMgrTable.clearTableData();

		createTableBody(ospfProtoMgrTable, window.tableconf[0], data, RESOURCE);
		initTableSort(ospfProtoMgrTable, "port");
		setTableCellEdit();
		countObj.setTotalCount(ospfProtoMgrTable.getDataRowLength());
		countObj.setSelectedCount(0);
	}

	setBtnStatus( [ $("queryBtn"), $("printBtn") ], false);
	showOperResult(data);

}

/**
 *     OSPF  
 * 
 * @param  
 * @return  
 */
function setOSPFProtocol()
{
	if (!confirm(RESOURCE["setOSPFProtocol"]))
	{
		return;
	}

	var setXMLInfo = createSetXMLInfo();
	if (null == setXMLInfo)
	{
		setBtnStatus( [ $("applyBtn") ], true);
		return;
	}
	setBtnStatus( [ $("queryBtn"), $("applyBtn"), $("printBtn") ], true);

	var url = "../../../../../tl1NEExlorerServlet?sfid=" + sfidset + "&nmUser="
			+ winobj["nmUser"];

	loadXMLdoc(url, "POST", true, setCallBack, null, "inputdata=" + setXMLInfo);
}

/**
 *         OSPF   XML  
 * 
 * @param  
 * @return  
 */
function createSetXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var hasModify = false;

	for ( var i = 0; i < ospfProtoMgrTable.getDataRowLength(); i++)
	{
		if (!ospfProtoMgrTable.getModify(i))
		{
			continue;
		}
		hasModify = true;
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "AID");
		param.setAttribute("value", ospfProtoMgrTable.getCellStoreValue(i,
				"AID", "AID"));
		param.setAttribute("modifyFlag", "false");
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "iftype");
		param.setAttribute("value", ospfProtoMgrTable.getCellStoreValue(i,
				"iftype", "iftype"));
		param.setAttribute("modifyFlag", "false");
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "ospfStatus");
		param.setAttribute("value", ospfProtoMgrTable.getCellStoreValue(i,
				"ospfStatus", "ospfStatus"));
		param.setAttribute("modifyFlag", ospfProtoMgrTable.getCellModify(i,
				"ospfStatus"));
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	if (!hasModify)
	{
		return null;
	}
	root.getRoot().appendChild(bussiness);

	return root.toString();
}

/**
 *     OSPF         
 * 
 * @param doc:          
 * @return  
 */
function setCallBack(doc)
{
	var data = EncapsulateData(doc);

	refreshTableState(ospfProtoMgrTable, window.tableconf[0], data);

	showOperResult(data, [ "nename", "boardname", "portname",	"INTFTYPE" ]);

	if (0 != data.getSErrorCode())
	{
		setBtnStatus( [ $("applyBtn") ], false);
	}
	setBtnStatus( [ $("queryBtn"), $("printBtn") ], false); //       
}

/**
 *     OSPF    
 * 
 * @param  
 * @return  
 */
function printOSPFProtocol()
{
	if (0 == ospfProtoMgrTable.getDataRowLength())
	{
		alert(RESOURCE["nodata"]);
		return
	}
	openPrintPage("../../../../../page/", RESOURCE["asonOspfProtoMgr"],
			"ospfProtoMgrTable", true, winobj["nmUserName"]);
}

/**
 * Tab      
 * 
 * @param
 * @return  
 */
function tabSelectHandler()
{
	queryOSPFProtocol(); //     OSPF  
}

/**
 *           
 * 
 * @param
 * @return  
 */
function setTableCellEdit()
{
	for (i = 0, stlen = ospfProtoMgrTable.getDataRowLength(); i < stlen; i++)
	{
		if ("ENABLE" != ospfProtoMgrTable.getCellStoreValue(i, "ospfStatus",
				"ospfStatus")
				&& "DISABLE" != ospfProtoMgrTable.getCellStoreValue(i,
						"ospfStatus", "ospfStatus"))
		{
			ospfProtoMgrTable.setCellValue(ospfProtoMgrTable.getCell(i,
					"ospfStatus"), "ospfStatus", "-");
			ospfProtoMgrTable.getCellShow(i, "ospfStatus").setValue("-");
			ospfProtoMgrTable.setCellIsEdit(ospfProtoMgrTable.getCell(i,"ospfStatus"),0);
			lmpProtoMgrTable.getCellShow(i, "iftype").setValue("-");
		}
	}
}
