var obj, neid, st;
var btnRightArr = new Object(); // right object

window.onload = function()
{
	obj = getNeProperty(top);
	neid = obj["neid"];

	initTable();
	initButton();

}

function initTable()
{
	st = new SortTable();
	st.setImage("../../../../../images/");
	createTableHead(st, window.tableconf[0]);
	st.setOnRowSelectHandler(rowSelectHandler);
	st.setOnCellEditHandler(cellEditHandler);
	$("ipaddrtable").appendChild(st.getTable());
	$("ipaddrtable").oncontextmenu = popupMenuHandler;
	st.setBodyHeight(getTableHeight($("ipaddrtable"), st) + "px");
}

function initButton()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("printbtn").value = RESOURCE["printbutton"];

	btnRightArr.querybtn = new BtnRightObj("querybtn",
			TECMDCODE_OSN_QUEYT_ETHSNDIP);
	btnRightArr.printbtn = new BtnRightObj("printbtn",
			TECMDCODE_OSN_QUEYT_ETHSNDIP);

	getRightInfo(obj, btnRightArr);
	initrightbtn(btnRightArr);

	$("totalrow").innerHTML = RESOURCE["totalrows"];
	$("selrow").innerHTML = RESOURCE["seleterows"];
}

function tabSelectHandler()
{
	if (btnRightArr.querybtn.right)
	{
		getOspfIpAddr();
	}
}

function rowSelectHandler()
{
	$("totalrownum").innerHTML = st.getDataRowLength();
	$("selrownum").innerHTML = st.getSelectedRows().length;
}

function cellEditHandler()
{
	if(param.colid == "ip" && param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
	 	var index = param.rowindex;
	 	if (hexToTen(convertIpaddrToHexcode((param.value))) != 0)
	 	{
	 		var cell = st.getCell(index, "mask");
	 		cell.element.style.backgroundColor = "#d0f946";
	 		st.setCellIsEdit(cell, "1");
	 		st.getCellElement(index, "mask").ondblclick = cellondbclick;
			cell.element.modify = true;
	 	}
	 	else
	 	{
	 		var cell = st.getCell(index, "mask");
			cell.element.style.backgroundColor = "";
			st.setCellIsEdit(cell, "0");
			st.getCellElement(index, "mask").ondblclick = null;
			
			cell.element.modify = false;
			st.setCellValue(cell, "mask", "0.0.0.0");
			st.setAtomValue(st.getCellShow(index,"mask"),"0.0.0.0");
	 	}
	}
}

function getOspfIpAddr()
{
	setBtnStatus( [ $("querybtn"), $("printbtn") ], true);

	var xmldata = createGetXml();
	var urlstr = "../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_OSN_QUEYT_ETHSNDIP + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlstr, "POST", true, callbackGet, null, "inputdata=" + xmldata);
}

function createGetXml()
{
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");

	var keys = new Array("neid", "INTFTYPE","AID");
	var vals = new Array(neid, "ETH","ETH-1");

	business.appendChild(createRow(keys, vals));
	root.getRoot().appendChild(business);
	return root.toString();
}

function callbackGet(doc)
{
	var data = EncapsulateData(doc);

	if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
	{
		st.clearTableData();

		for ( var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			var ipVal = data.getDataRowParam(i, "ip");
			var maskVal = data.getDataRowParam(i, "mask");

			data.rows[i]["ip"].value = ipVal;
			data.rows[i]["mask"].value = maskVal;
		}

		createTableBody(st, window.tableconf[0], data, RESOURCE);
	}

	setBtnStatus( [ $("querybtn"), $("printbtn") ], false);

	$("totalrownum").innerHTML = st.getDataRowLength();
	$("selrownum").innerHTML = st.getSelectedRows().length;

	showErrorDialog(data);

	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		var ip = st.getCellStoreValue(i, "ip", "ip");
		if (ip == 0)
		{
			var cell = st.getCell(i, "mask");
			cell.element.style.backgroundColor = "";
			st.setCellIsEdit(cell, "0");
			st.getCellElement(i, "mask").ondblclick = null;
		}
		var ipCell = st.getCellEdit(i, "ip").element;
		var maskCell = st.getCellEdit(i, "mask").element;
		validateIp(ipCell, true);
		validateIp(maskCell, true);
	}
}

function setOspfIpAddr()
{
	setBtnStatus( [ $("querybtn"), $("printbtn") ], true);

	var xmldata = createSetXml();

	var urlstr = "../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_OSN_SET_ETHSNDIP + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlstr, "POST", false, callbackSet, null, "inputdata=" + xmldata);
}

function createSetXml()
{
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");

	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		if (!st.getModify(i))
		{
			continue;
		}
		var keys = new Array("neid");
		var vals = new Array(neid);
		if (st.getCellModify(i, "ip"))
		{
			var ip = st.getCellStoreValue(i, "ip", "ip");
			keys.push("ip");
			vals.push(ip);
		}
		if (st.getCellModify(i, "mask"))
		{
			var mask = st.getCellStoreValue(i, "mask", "mask");
			keys.push("mask");
			vals.push(mask);
		}

		business.appendChild(createRow(keys, vals));
	}

	root.getRoot().appendChild(business);
	return root.toString();
}

function callbackSet(doc)
{
	var data = EncapsulateData(doc);
	showErrorDialog(data);

	var errCode = data.getSErrorCode();
	if (errCode == 0)
	{
		refreshTableState(st, window.tableconf[0], data);
	}
	else if (errCode == 1)
	{
		for ( var i = 0, m = data.getBErrLength(); i < m; i++)
		{
			if (typeof (data.errObj.rowErrors[i].errorObj["ip"]) != "undefined")
			{
				data.errObj.rowErrors[i].errorObj["ip"] = data.getBErrParam(i,
						"ip");
			}
			if (typeof (data.errObj.rowErrors[i].errorObj["mask"]) != "undefined")
			{
				data.errObj.rowErrors[i].errorObj["mask"] = data.getBErrParam(
						i, "mask");
			}
		}
		refreshTableState(st, window.tableconf[0], data);
	}

	setBtnStatus( [ $("querybtn"), $("printbtn") ], false);

	if (errCode != 0)
	{
	}
}

function printIpAddr()
{
	if (st.getDataRowLength() <= 0)
	{
		alert(RESOURCE["nodata"]);
		return;
	}

	openPrintPage("../../../../../page/", RESOURCE["printIpAddr"], "st");
}

function createRow(keyParams, valParams)
{
	var row = new tagElement("row-params");
	var param;

	for ( var i = 0; i < keyParams.length; i++)
	{
		param = new tagElement("param");
		param.setAttribute("name", keyParams[i]);
		param.setAttribute("value", valParams[i]);
		row.appendChild(param);
	}

	return row;
}

function showErrorDialog(di)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../../page/", di.getError(), errArr);
	errArr = null;
}

window.onresize = function()
{
	if (document.body)
	{
		st.setBodyHeight(getTableHeight($("ipaddrtable"), st) + "px");
	}
}
