  
var obj,neid,st;
var btnRightArr = new Object(); // right object
var MD5_DEFAULT = "AOSV100R002"

window.onload = function()
{
	obj = getNeProperty(top);
	neid = obj["neid"];
		
	initTable();
	initRight();
	initButton();
		
}

function initTable()
{
	  st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    $("authtable").appendChild(st.getTable());
    $("authtable").oncontextmenu = popupMenuHandler;
    st.setBodyHeight(getTableHeight($("authtable"), st) + "px");
}

function initButton()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("printbtn").value = RESOURCE["printbutton"];
		
	$("applybtn").disabled = true;
		
	$("totalrow").innerHTML = RESOURCE["totalrows"];
	$("selrow").innerHTML = RESOURCE["seleterows"];
}

function initRight()
{
	btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_OSN_GET_OSPF_IDENTIFY);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_OSN_SET_OSPF_IDENTIFY);
    btnRightArr.printbtn = new BtnRightObj("printbtn", TECMDCODE_OSN_GET_OSPF_IDENTIFY);
    
    getRightInfo(obj, btnRightArr);
    initrightbtn(btnRightArr);
}

function tabSelectHandler()
{
    if(btnRightArr.querybtn.right)
    {
  	   getAuthentication();
    }
}

function rowSelectHandler()
{
   $("totalrownum").innerHTML = st.getDataRowLength();
   $("selrownum").innerHTML = st.getSelectedRows().length;
}

function cellEditHandler(param)
{
	$("applybtn").disabled = !btnRightArr.applybtn.right;		
}

function getAuthentication()
{
	setBtnStatus([$("querybtn"), $("applybtn"), $("printbtn")], true);
		
	var xmldata = createQueryXML();
	var urlstr = "../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_OSN_GET_OSPF_IDENTIFY+"&nmUser="+obj["nmUser"];
	loadXMLdoc(urlstr, "POST", true, callbackGet, null, "inputdata="+xmldata);
}

function createQueryXML()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","AID");
    param.setAttribute("value","");
    row.appendChild(param);
    
   
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}


function callbackGet(doc)
{
	var data = EncapsulateData(doc);
	st.clearTableData();
	if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
	{
		createTableBody(st, window.tableconf[0], data, RESOURCE);
	}
		
	for (var i=0,len=st.getDataRowLength(); i<len; i++)
	{			
		var authType = st.getCellStoreValue(i, "authType", "authType");
		var authCode = unescape(st.getCellStoreValue(i, "authCode", "authCode"));
		if (authCode == "undefined" || authCode == null)
		{
			authCode = "";
		}
		var typeCell = st.getCell(i, "authType");
		var codeCell = st.getCell(i, "authCode");
		st.setCellValue(codeCell, "authCode", authCode);
		st.getCellShow(i, "authCode").element.innerHTML = authCode;
		authCodeHandler(authType, typeCell, codeCell, false);
		st.getCellEdit(i, "authType").element.onchange = changeHandler;
	}
	
	initTableSort(st, "port");
		
	showErrorDialog(data,"GET");
		
	$("querybtn").disabled = !btnRightArr.querybtn;
	$("printbtn").disabled = !btnRightArr.printbtn;
		
	$("totalrownum").innerHTML = st.getDataRowLength();
	$("selrownum").innerHTML = 0;
		
}

function setAuthentication()
{	  
	var xmldata = createSetXml();
	if (xmldata != null && confirm(RESOURCE["confirminfo"]))
	{
	    setBtnStatus([$("querybtn"), $("applybtn"), $("printbtn")], true);
	  
		var urlstr = "../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_OSN_SET_OSPF_IDENTIFY+"&nmUser="+obj["nmUser"];
		loadXMLdoc(urlstr, "POST", true, callbackSet, null, "inputdata="+xmldata);

	}
}

function createSetXml()
{
	  var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    for (var i=0,len=st.getDataRowLength(); i<len; i++)
    {
    	if (!st.getModify(i))
    	{
    		continue;
    	}
    		
    	var AID = st.getCellStoreValue(i, "AID", "AID");
    	var INTFTYPE = st.getCellStoreValue(i, "INTFTYPE", "INTFTYPE");
    	var OSPFSTATE = st.getCellStoreValue(i, "OSPFSTATE", "OSPFSTATE");
    	var authType = st.getCellStoreValue(i, "authType", "authType");
    	var authCode = st.getCellStoreValue(i, "authCode", "authCode");

    	if (authType != "NONE" && authCode.trim() == "")
    	{
    		alert(RESOURCE["authcodenull"]);
    		return null;
    	}

    /*
		 * AU9D42594                 AU9D42940   OSPF MD5   ,    ,          
		 */
    	if ( authCode == "undefined" )
    	{
    		authCode = "";
    	}

    	var keys = new Array("neid", "AID", "INTFTYPE", "OSPFSTATE", "authType", "authCode");
    	var vals = new Array(neid, AID, INTFTYPE, OSPFSTATE, authType, escape(authCode));
    		
    	business.appendChild(createRow(keys, vals));
    }
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackSet(doc)
{
	var data = EncapsulateData(doc);
	var errCode = data.getSErrorCode();
	if (errCode == 0 || errCode == 1)
	{
	    refreshTableState(st, window.tableconf[0], data);
	}
		
	showErrorDialog(data,"SET");
		
	$("querybtn").disabled = !btnRightArr.querybtn;
	$("printbtn").disabled = !btnRightArr.printbtn;
	if (errCode != 0)
	{
		$("applybtn").disabled = !btnRightArr.applybtn;
	}
}

function printAuth()
{
    if (st.getDataRowLength() <= 0)
	{
		alert(RESOURCE["nodata"]);
		return;
	}
		
	openPrintPage("../../../../../page/", RESOURCE["printAuth"],"st");
}

function createRow(keyParams, valParams)
{
    var row = new tagElement("row-params");
    var param;
    
    for (var i=0; i<keyParams.length; i++)
    {
     	param = new tagElement("param");    
		  param.setAttribute("name", keyParams[i]);
		  param.setAttribute("value", valParams[i]);
		  row.appendChild(param);
    }
    
    return row;
}

function showErrorDialog(di,operType)
{
    var errArr = [];
    if(operType == "SET")
    {   
    	errArr[0] = "nename"
    	errArr[1] = "boardname"
    	errArr[2] = "portname"
    	errArr[3] = "INTFTYPE" //  3              ,          
    }
    else
    {
        errArr[0] = "nename";
    }
    openErrPage("../../../../../page/", di.getError(), errArr);
    errArr = null;
}

window.onresize = function()
{
	if (document.body)
	{
		st.setBodyHeight(getTableHeight($("authtable"), st) + "px");
	}
}

function changeHandler()
{
	var rowindex = this.parentNode.parentNode.rowIndex;
	var typeCell = st.getCell(rowindex, "authType");
	var codeCell = st.getCell(rowindex, "authCode")
	authCodeHandler(this.value, typeCell, codeCell, true);
}

function authCodeHandler(authType, typeCell, codeCell, isChange)
{
	if (isChange)
	{
		if(authType == "MD5")
		{
			codeCell.element.showElement.setValue(MD5_DEFAULT);
		  codeCell.element.storeValue["authCode"] = MD5_DEFAULT;
		  codeCell.element.currentValue["authCode"] = MD5_DEFAULT;
		}
		else
		{
		  codeCell.element.showElement.setValue("");
		  codeCell.element.storeValue["authCode"] = "";
		  codeCell.element.currentValue["authCode"] = "";
	  }
	}
	switch (authType)
	{
		case "NOT SUPPORTED": //    
		{
			st.setCellIsEdit(typeCell,0);
			typeCell.element.disabled = true;
			typeCell.element.style.backgroundColor = "";
			
			st.setCellIsEdit(codeCell,0);
			codeCell.element.disabled = true;
			codeCell.element.showElement.setValue("-");						
			codeCell.element.style.backgroundColor = "";
			break;
		}
		case "NONE": //    
		{
			st.setCellIsEdit(codeCell,0);
			codeCell.element.disabled = true;
			codeCell.element.showElement.setValue("-");						
			codeCell.element.style.backgroundColor = "";
			break;
	  }
		case "TEXT": //       
		{
			st.setCellIsEdit(codeCell,1);
			codeCell.element.disabled = false;
			codeCell.element.style.backgroundColor = "#FFFFFF";
			editelement = codeCell.element.editElement.element;
			editelement.maxLength = 8;
			editelement.onkeyup = function()
      {		
         return calStrSinoLen(this, 8);
      }												
			break;
		}
		case "MD5": // MD5    
		{
			st.setCellIsEdit(codeCell,1);
			codeCell.element.disabled = false;
			codeCell.element.style.backgroundColor = "#FFFFFF";
			editelement = codeCell.element.editElement.element;
			editelement.maxLength = 64;
			editelement.onkeyup = function()
      {			
         return calStrSinoLen(this, 64);
      }
			break;
		}
	}
}
