 var sfidquery = TECMDCODE_QUERY_ASON_PROTOCOL;//    sfid
var sfidset = TECMDCODE_SET_ASON_PROTOCOL;//    sfid

var winobj = getNeProperty(self);
var lmpProtoMgrTable;
var countObj;
var hasQueryRight = true;
var hasSetRight = true;

/**
 *            
 * 
 * @param  
 * @return  
 */
function initBody()
{
	initTable();
	initButton();
	if (SYSTEMCONF.getStatus() == 1)
	{
		queryLmpProtocol(); //         
	}
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	lmpProtoMgrTable = new SortTable();

	lmpProtoMgrTable.setImage("../../../../../images/");

	lmpProtoMgrTable.setOnCellEditHandler(cellEditHandler);

	lmpProtoMgrTable.setOnRowSelectHandler(rowSelectHandler);

	createTableHead(lmpProtoMgrTable, window.tableconf[0]);

	$("tablecomponent").appendChild(lmpProtoMgrTable.getTable());

	lmpProtoMgrTable.setBodyHeight(getComponetHeight($("tablecomponent"), 60)
			+ "px");

	$("tablecomponent").oncontextmenu = popupMenuHandler;

	countObj = new TableDataCount();
	$("dataCount").appendChild(countObj.getCountArea());
}

/**
 *               
 * 
 * @param data: 
 * @return  
 */
window.onresize = function()
{
	lmpProtoMgrTable.setBodyHeight(getComponetHeight($("tablecomponent"), 60)
			+ "px");
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initButton()
{
	$("queryBtn").value = RESOURCE["querybutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
	$("printBtn").value = RESOURCE["printbutton"];

	var url = "../../../../../securityServlet?neID=" + winobj["neid"]
			+ "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata="
			+ createQueryRightXMLInfo());
}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQueryRightXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	row = new tagElement("row-params");
	param = new tagElement("param");
	param.setAttribute("name", "sfid");
	param.setAttribute("value", sfidquery);
	row.appendChild(param);
	bussiness.appendChild(row);

	row = new tagElement("row-params");
	param = new tagElement("param");
	param.setAttribute("name", "sfid");
	param.setAttribute("value", sfidset);
	row.appendChild(param);
	bussiness.appendChild(row);

	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *             
 * 
 * @param doc:         
 * @return  
 */
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
	var right = data.getDataRowParam(0, "right");
	if (right == 1)
	{
		hasQueryRight = true;//        
	}
	else
	{
		hasQueryRight = false;//         
	}
	right = data.getDataRowParam(1, "right");
	if (right == 1)
	{
		hasSetRight = true;//        
	}
	else
	{
		hasSetRight = false;//         
		setTableDisabled(window.tableconf[0]);
	}

	$("queryBtn").disabled = !hasQueryRight;
	$("printBtn").disabled = !hasQueryRight;
	$("applyBtn").disabled = true;
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if (!hasSetRight)
	{
		return;
	}
	else
	{
		$("applyBtn").disabled = false; //         
	}
}

/**
 *              
 * 
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
	countObj.setSelectedCount(rows.length);
}

/**
 *       
 * 
 * @param  
 * @return  
 */
function queryLmpProtocol()
{
	if (!hasQueryRight)
	{
		return;
	}
	setBtnStatus( [ $("queryBtn"), $("applyBtn"), $("printBtn") ], true);

	var url = "../../../../../tl1NEExlorerServlet?sfid=" + sfidquery
			+ "&nmUser=" + winobj["nmUser"];

	loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata="
			+ createQueryXMLInfo(winobj["neid"]));
}

/**
 *     LMP         
 * 
 * @param doc:          
 * @return  
 */
function queryCallBack(doc)
{
	var data = EncapsulateData(doc);

	if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		lmpProtoMgrTable.clearTableData();

		createTableBody(lmpProtoMgrTable, window.tableconf[0], data, RESOURCE);
		initTableSort(lmpProtoMgrTable, "port");
		setTableCellEdit();
		countObj.setTotalCount(lmpProtoMgrTable.getDataRowLength());
		countObj.setSelectedCount(0);
	}

	setBtnStatus( [ $("queryBtn"), $("printBtn") ], false);
	showOperResult(data);

}

/**
 *     LMP  
 * 
 * @param  
 * @return  
 */
function setLmpProtocol()
{
	if (!confirm(RESOURCE["setLmpProtocol"]))
	{
		return;
	}
	var setXMLInfo = createSetXMLInfo();
	if (null == setXMLInfo)
	{
		setBtnStatus( [ $("applyBtn") ], true);
		return;
	}
	setBtnStatus( [ $("queryBtn"), $("applyBtn"), $("printBtn") ], true);

	var url = "../../../../../tl1NEExlorerServlet?sfid=" + sfidset + "&nmUser="
			+ winobj["nmUser"];

	loadXMLdoc(url, "POST", true, setCallBack, null, "inputdata=" + setXMLInfo);
}

/**
 *         LMP   XML  
 * 
 * @param  
 * @return  
 */
function createSetXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var hasModify = false;

	for ( var i = 0; i < lmpProtoMgrTable.getDataRowLength(); i++)
	{
		if (!lmpProtoMgrTable.getModify(i))
		{
			continue;
		}
		hasModify = true;
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "AID");
		param.setAttribute("value", lmpProtoMgrTable.getCellStoreValue(i,
				"AID", "AID"));
		param.setAttribute("modifyFlag", "false");
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "payloadtype");
		param.setAttribute("value", lmpProtoMgrTable.getCellStoreValue(i,
				"payloadtype", "payloadtype"));
		param.setAttribute("modifyFlag", "false");
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "lmpStatus");
		param.setAttribute("value", lmpProtoMgrTable.getCellStoreValue(i,
				"lmpStatus", "lmpStatus"));
		param.setAttribute("modifyFlag", lmpProtoMgrTable.getCellModify(i,
				"lmpStatus"));
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	if (!hasModify)
	{
		return null;
	}
	root.getRoot().appendChild(bussiness);

	return root.toString();
}

/**
 *     LMP         
 * 
 * @param doc:          
 * @return  
 */
function setCallBack(doc)
{
	var data = EncapsulateData(doc);

	refreshTableState(lmpProtoMgrTable, window.tableconf[0], data);

	showOperResult(data, [ "nename", "boardname", "portname", "PAYLOAD" ]);

	if (0 != data.getSErrorCode())
	{
		setBtnStatus( [ $("applyBtn") ], false);
	}
	setBtnStatus( [ $("queryBtn"), $("printBtn") ], false); //       
}

/**
 *     LMP    
 * 
 * @param  
 * @return  
 */
function printLmpProtocol()
{
	if (0 == lmpProtoMgrTable.getDataRowLength())
	{
		alert(RESOURCE["nodata"]);
		return
	}
	openPrintPage("../../../../../page/", RESOURCE["asonLmpProtoMgr"],
			"lmpProtoMgrTable", true, winobj["nmUserName"]);
}

/**
 * Tab      
 * 
 * @param
 * @return  
 */
function tabSelectHandler()
{
	queryLmpProtocol(); //       LMP  
}

/**
 *           
 * 
 * @param
 * @return  
 */
function setTableCellEdit()
{
	for (i = 0, stlen = lmpProtoMgrTable.getDataRowLength(); i < stlen; i++)
	{
		if ("ENABLE" != lmpProtoMgrTable.getCellStoreValue(i, "lmpStatus",
				"lmpStatus")
				&& "DISABLE" != lmpProtoMgrTable.getCellStoreValue(i,
						"lmpStatus", "lmpStatus"))
		{
			lmpProtoMgrTable.getCellShow(i, "lmpStatus").setValue("-");
			lmpProtoMgrTable.setCellIsEdit(lmpProtoMgrTable.getCell(i,"lmpStatus"),0);
			lmpProtoMgrTable.getCellShow(i, "payloadtype").setValue("-");
			lmpProtoMgrTable.getCellShow(i, "signaltype").setValue("-");
		}
	}
}
