 var sfidquery = TECMDCODE_QUERY_ASON_MPLS_XC;//    sfid
var sfiddowngrade = TECMDCODE_DOWNGRADE_ASON_MPLS_XC;//    sfid

var winobj = getNeProperty(self);
var signallingTable;
var countObj;
var hasQueryRight = true;
var hasDowngradeRight = true;
var allDegradeData = [];

/**
 *            
 * 
 * @param  
 * @return  
 */
function initBody()
{
	$("queryTypeTitle").appendChild(
			document.createTextNode(RESOURCE["queryType"]));
	var queryTypeSelect = document.createElement("select");
	queryTypeSelect.setAttribute("id", "queryType");
	if (isIE)
	{
		queryTypeSelect.style.width = "100%";
	}
	else
	{
		queryTypeSelect.style.width = "775px";
	}
	$("queryTypeArea").appendChild(queryTypeSelect);

	var quryIngress = new Option(RESOURCE["quryIngress"], "SRC");
	$("queryType").options[$("queryType").options.length] = quryIngress;

	var quryTransit = new Option(RESOURCE["quryTransit"], "MEDI");
	$("queryType").options[$("queryType").options.length] = quryTransit;

	var quryEgress = new Option(RESOURCE["quryEgress"], "DST");
	$("queryType").options[$("queryType").options.length] = quryEgress;

	var quryAll = new Option(RESOURCE["quryAll"], "ALL");
	$("queryType").options[$("queryType").options.length] = quryAll;
	quryAll.selected = true;
	queryTypeSelect.onchange = querySignalling;

	initTable();
	initButton();
	querySignalling();
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	signallingTable = new SortTable();

	signallingTable.setImage("../../../../../images/");

	createTableHead(signallingTable, window.tableconf[0]);

	$("tablecomponent").appendChild(signallingTable.getTable());

	signallingTable.setBodyHeight(getComponetHeight($("tablecomponent"), 80)
			+ "px");

	$("tablecomponent").oncontextmenu = popuMenuHandler;

	signallingTable.setOnRowSelectHandler(rowSelectHandler);

	countObj = new TableDataCount();
	$("dataCount").appendChild(countObj.getCountArea());

	signallingTable.setBodyWidth(window.tableconf[0].width,
			window.tableconf[0].percent, 0);
	adjustTableLayout(signallingTable, window.tableconf[0], 0);
}

/**
 *               
 * 
 * @param data: 
 * @return  
 */
window.onresize = function()
{
	signallingTable.setBodyHeight(getComponetHeight($("tablecomponent"), 80)
			+ "px");
}

/**
 *          
 * 
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
	countObj.setSelectedCount(rows.length);
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initButton()
{
	$("queryBtn").value = RESOURCE["querybutton"];
	$("printBtn").value = RESOURCE["printbutton"];

	var url = "../../../../../securityServlet?neID=" + winobj["neid"]
			+ "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", false, rightHandle, null, "inputdata="
			+ createQueryRightXMLInfo());

}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQueryRightXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	row = new tagElement("row-params");
	param = new tagElement("param");
	param.setAttribute("name", "sfid");
	param.setAttribute("value", sfidquery);
	row.appendChild(param);
	bussiness.appendChild(row);

	row = new tagElement("row-params");
	param = new tagElement("param");
	param.setAttribute("name", "sfid");
	param.setAttribute("value", sfiddowngrade);
	row.appendChild(param);
	bussiness.appendChild(row);

	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *             
 * 
 * @param doc:         
 * @return  
 */
function rightHandle(doc)
{
	var data = EncapsulateData(doc);
	var right = data.getDataRowParam(0, "right");
	if (right == 1)
	{
		hasQueryRight = true;//           
	}
	else
	{
		hasQueryRight = false;//         
	}
	right = data.getDataRowParam(1, "right");
	if (right == 1)
	{
		hasDowngradeRight = true;//           
	}
	else
	{
		hasDowngradeRight = false;//         
	}
}

/**
 *       
 * 
 * @param  
 * @return  
 */
function querySignalling()
{

	if (!hasQueryRight)
	{
		return;
	}
	setBtnStatus( [ $("queryBtn"), $("printBtn") ], true);

	var url = "../../../../../tl1NEExlorerServlet?sfid=" + sfidquery
			+ "&nmUser=" + winobj["nmUser"];

	loadXMLdoc(url, "POST", true, callbackQuerySignalling, null, "inputdata="
			+ createQuerySignallingXMLInfo());

}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQuerySignallingXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "location");
	param.setAttribute("value", $("queryType").value);
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *              
 * 
 * @param doc:          
 * @return  
 */
function callbackQuerySignalling(doc)
{
	var data = EncapsulateData(doc);

	signallingTable.clearTableData();
	if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		createTableBody(signallingTable, window.tableconf[0], data, RESOURCE);
		initTableSort(signallingTable, "trailName");
		countObj.setTotalCount(signallingTable.getDataRowLength());//          count
		countObj.setSelectedCount(0); //            0
	}

	setBtnStatus( [ $("queryBtn"), $("printBtn") ], false);
	showOperResult(data);

}

/**
 *       
 * 
 * @param  
 * @return  
 */
function downgradeSignalling()
{
	hideMenu();

	if (!confirm(RESOURCE["downgradeSign"]))
	{
		return;
	}

	if (!confirm(RESOURCE["makeTrueDowngradeSign"]))
	{
		return;
	}
	setBtnStatus( [ $("queryBtn"), $("printBtn") ], true);
	var url = "../../../../../tl1NEExlorerServlet?sfid=" + sfiddowngrade
			+ "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackDowngrade, null, "inputdata="
			+ createDowngradeXMLInfo());

}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createDowngradeXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var degradeData = null;

	var degradeRows = signallingTable.getSelectedRows();
	allDegradeData = [];

	for ( var i = 0; i < degradeRows.length; i++)
	{
		row = new tagElement("row-params");
		degradeData = new Object();
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "srcNode");
		param.setAttribute("value", signallingTable.getCellStoreValue(
				degradeRows[i], "srcNode", "srcNode"));
		row.appendChild(param);
		degradeData.srcNode = signallingTable.getCellStoreValue(degradeRows[i],
				"srcNode", "srcNode");

		param = new tagElement("param");
		param.setAttribute("name", "sinkNode");
		param.setAttribute("value", signallingTable.getCellStoreValue(
				degradeRows[i], "sinkNode", "sinkNode"));
		row.appendChild(param);
		degradeData.sinkNode = signallingTable.getCellStoreValue(
				degradeRows[i], "sinkNode", "sinkNode");

		param = new tagElement("param");
		param.setAttribute("name", "index");
		param.setAttribute("value", signallingTable.getCellStoreValue(
				degradeRows[i], "index", "index"));
		row.appendChild(param);
		degradeData.index = signallingTable.getCellStoreValue(
				degradeRows[i], "index", "index");

		bussiness.appendChild(row);
		allDegradeData.push(degradeData);
	}
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *              
 * 
 * @param doc:          
 * @return  
 */
function callbackDowngrade(doc)
{
	var data = EncapsulateData(doc);

	var allErrorInfo = [];

	for ( var i = data.getBErrLength() - 1; i >= 0; i--)
	{
		var errorInfo = new Object();
		errorInfo.srcNode = data.getBErrParam(i, "srcNode");
		errorInfo.sinkNode = data.getBErrParam(i, "sinkNode");
		errorInfo.index = data.getBErrParam(i, "index");
		allErrorInfo.push(errorInfo);
		data.getError().rowErrors[i].errorObj["srcNode"] = window.tableconf[0]
				.getColFromColId("srcNode").name
				+ ":" + data.getError().rowErrors[i].errorObj["srcNode"];
		data.getError().rowErrors[i].errorObj["sinkNode"] = window.tableconf[0]
				.getColFromColId("sinkNode").name
				+ ":" + data.getError().rowErrors[i].errorObj["sinkNode"];
		data.getError().rowErrors[i].errorObj["index"] = window.tableconf[0]
				.getColFromColId("index").name
				+ ":" + data.getError().rowErrors[i].errorObj["index"];
	}

	showOperResult(data, [ "srcNode", "sinkNode", "index" ]);

	if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
	{
		for ( var rowIndex = 0; rowIndex < signallingTable.getDataRowLength(); rowIndex++)
		{
			var errorInfo = new Object();
			errorInfo.srcNode = signallingTable.getCellStoreValue(rowIndex,
					"srcNode", "srcNode");
			errorInfo.sinkNode = signallingTable.getCellStoreValue(rowIndex,
					"sinkNode", "sinkNode");
			errorInfo.index = signallingTable.getCellStoreValue(rowIndex,
					"index", "index");

			if (allDegradeData.containsSlg(errorInfo)
					&& !allErrorInfo.containsSlg(errorInfo))
			{
				signallingTable.deleteRow(rowIndex);
			}
		}
		signallingTable.adjustDataRows();
	}
	countObj.setTotalCount(signallingTable.getDataRowLength());//          count
	countObj.setSelectedCount(signallingTable.getSelectedRowCount()); //           
	setBtnStatus( [ $("queryBtn"), $("printBtn") ], false); //       
}

/**
 *         
 * 
 * @param  
 * @return  
 */
function printSignallingInfo()
{
	if (0 == signallingTable.getDataRowLength())
	{
		alert(RESOURCE["nodata"]);
		return;
	}
	openPrintPage("../../../../../page/", RESOURCE["asonsignallingMg"],
			"signallingTable", true, winobj["nmUserName"]);
}

/**
 *          
 * 
 * @param evt      
 * @return  
 */
function popuMenuHandler(evt)
{

	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}
	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{

		return;
	}
	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	if (rows.contains(rowid))
	{
		createFuncPopupMenu(rows, evt);
	}
}

/**
 *           
 * 
 * @param rows:    
 *            evt      
 * @return  
 */
function createFuncPopupMenu(rows, evt)
{
	removejsDOMmenu();
	var cursorMenu1 = new jsDOMenu(210);
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["downgradeSignalling"], "",
			downgradeSignalling, null, hasDowngradeRight));
	setPopUpMenu(cursorMenu1);
	showMenu(evt);
}

/**
 * Tab      
 * 
 * @param
 * @return  
 */
function tabSelectHandler()
{
	querySignalling(); //         
}

/**
 *               
 * 
 * @param
 * @return  
 */
Array.prototype.containsSlg = function(obj)
{
	var tmpObj = null;
	for ( var i = 0, len = this.length; i < len; i++)
	{
		tmpObj = this[i];
		if (tmpObj.srcNode == obj.srcNode && tmpObj.sinkNode == obj.sinkNode
				&& tmpObj.index == obj.index)
		{
			return true;
		}
	}
	return false;
}
