/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.tl1ngwdm.ason;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEFuncTreeInterface;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TETL1AsonFuncTreeProcess
extends TETL1NEExplorerBean
implements TEFuncTreeInterface {
    private static final String ENABLE_ASON_FEATURE = "ENABLE";
    private static final String DISABLED_ASON_FEATURE = "DISABLE";
    private static final int NODE_ID_MGR_FUNC = 45093;
    private static final int ENABLE_ASON_MGR_FUNC = 45094;

    public boolean isSupportFunc(int neid, int funcId, String boardType, Element element) {
        this.neid = neid;
        String asonStatus = DISABLED_ASON_FEATURE;
        try {
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            asonStatus = ne.getStartAsonFlag();
        }
        catch (ClassCastException e) {
            asonStatus = "";
        }
        if (ENABLE_ASON_FEATURE.equalsIgnoreCase(asonStatus)) {
            return true;
        }
        if (DISABLED_ASON_FEATURE.equalsIgnoreCase(asonStatus)) {
            this.fillterFuncTree(element);
            return true;
        }
        return false;
    }

    private String getNECurrAsonStatus() {
        ArrayList<TL1Operation> queryDetailOperList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation tl1Operation = definitions.getTL1Operation("RTRV-SYS");
            queryDetailOperList.add(tl1Operation);
            int result = this.sendMessage(this.neid, queryDetailOperList);
            if (result == 0) {
                tl1Operation = (TL1Operation)queryDetailOperList.get(0);
                for (OutMsg out : tl1Operation.getOutMsg()) {
                    HashMap operMap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
                    Part part = (Part)operMap.get("ASON");
                    if (part == null) continue;
                    return part.getValue();
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getNECurrAsonStatus fail!", (Throwable)e);
            return null;
        }
        return null;
    }

    private void fillterFuncTree(Element element) {
        NodeList funcItemList = element.getElementsByTagName("functionItem");
        for (int i = funcItemList.getLength() - 1; i >= 0; --i) {
            Element funcItem = (Element)funcItemList.item(i);
            int funcID = Integer.parseInt(funcItem.getAttribute("funID"));
            if (funcID == 45093 || funcID == 45094) continue;
            funcItem.getParentNode().removeChild(funcItem);
        }
    }
}

