/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.tl1ngwdm.ason;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.ason.tl1ngwdm.ason.TEAsonCommonUtil;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TEQueryXCInfo
extends TETL1NEExplorerBean {
    protected boolean convertPartValue(Part part, RowParams rowparams) {
        if (part.getName().equalsIgnoreCase("SNODEID")) {
            Param srcNodeParam = rowparams.getParam("srcNode");
            if (srcNodeParam == null) {
                return false;
            }
            part.setValue(srcNodeParam.getValue());
            return true;
        }
        if (part.getName().equalsIgnoreCase("DNODEID")) {
            Param sinkNodeParam = rowparams.getParam("sinkNode");
            if (sinkNodeParam == null) {
                return false;
            }
            part.setValue(sinkNodeParam.getValue());
            return true;
        }
        if (part.getName().equalsIgnoreCase("CONINDEX")) {
            Param indexParam = rowparams.getParam("index");
            if (indexParam == null) {
                return false;
            }
            part.setValue(indexParam.getValue());
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        RowParams rowparams = null;
        RowErrors errorRowparams = null;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        int n = tl1OperList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            OutMsg[] outs = tl1Operation.getOutMsg();
            int m = outs.length;
            for (int j = 0; j < m; ++j) {
                rowparams = new RowParams();
                OutMsg out = outs[j];
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
                if (out.getFault().getCompletionCode() != 0) {
                    String errorCode = out.getFault().getErrCode();
                    String errorinfo = out.getFault().getErrDesc();
                    ErrorMessage errorMessage = new ErrorMessage();
                    Param errorparam = null;
                    errorRowparams = new RowErrors();
                    errorMessage.setErrorcode(errorCode);
                    errorMessage.setErrorinfo(errorinfo);
                    errorRowparams.setErrorMessage(errorMessage);
                    TENE ne = TENEListUtils.getNEObj((int)neid);
                    errorparam = new Param("nename", ne.getNEName());
                    errorRowparams.addParam(errorparam);
                    errorDataList.add(errorRowparams);
                    rowparams.addRowErrors(errorRowparams);
                    tl1Operation.addCmdFault(out.getFault());
                    this.outputData.getBussinessParams().addRowParams(rowparams);
                    continue;
                }
                Part lsp = (Part)hm.get("ACTRTLIST");
                Part lspFlag = (Part)hm.get("LSPFLAG");
                if (lsp != null && lsp.getValue() != null && lspFlag != null && "FIRST".equals(lspFlag.getValue())) {
                    String[] nodeInfoStr = lsp.getValue().split("&");
                    ArrayList nodeInfoList = this.getNodeInfo(nodeInfoStr);
                    String srcPortName = "";
                    String sinkPortName = "";
                    TENE neObj = null;
                    int nn = nodeInfoList.size();
                    for (int k = 0; k < nn - 1; ++k) {
                        NodeInfo srcNode = (NodeInfo)nodeInfoList.get(k);
                        NodeInfo sinkNode = (NodeInfo)nodeInfoList.get(k + 1);
                        rowparams = new RowParams();
                        rowparams.addParam(new Param("srcNode", srcNode.getNode()));
                        neObj = TENEListMgr.getInstance().getNE(srcNode.getNode());
                        srcPortName = null == neObj ? "/" : TEAsonCommonUtil.handlePortName(srcNode.getAid(), neObj.getNEID());
                        rowparams.addParam(new Param("srcPortName", srcPortName));
                        rowparams.addParam(new Param("srcWavlen", srcNode.getWave()));
                        rowparams.addParam(new Param("sinkNode", sinkNode.getNode()));
                        neObj = TENEListMgr.getInstance().getNE(sinkNode.getNode());
                        sinkPortName = null == neObj ? "/" : TEAsonCommonUtil.handlePortName(sinkNode.getAid(), neObj.getNEID());
                        rowparams.addParam(new Param("sinkPortName", sinkPortName));
                        rowparams.addParam(new Param("sinkWavlen", sinkNode.getWave()));
                        this.outputData.getBussinessParams().addRowParams(rowparams);
                    }
                }
                this.outputData.setErrorMessage(new ErrorMessage());
                if (errorDataList.size() != 0) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
                    continue;
                }
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            }
        }
    }

    private ArrayList getNodeInfo(String[] nodeInfoStr) {
        ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
        int n = nodeInfoStr.length;
        for (int i = 0; i < n; ++i) {
            String[] nodes = nodeInfoStr[i].split("-");
            NodeInfo nodeInfo = new NodeInfo();
            nodeInfo.setNode(nodes[0]);
            nodeInfo.setIndex(nodes[1]);
            nodeInfo.setBand(nodes[2]);
            nodeInfo.setWave(nodes[3]);
            TENE neObj = null;
            neObj = TENEListMgr.getInstance().getNE(nodes[0]);
            if (neObj != null) {
                String aid = TEAsonCommonUtil.getAID(nodes[1], neObj.getNEID());
                nodeInfo.setAid(aid);
            }
            list.add(nodeInfo);
        }
        return list;
    }

    class NodeInfo {
        String node;
        String index;
        String band;
        String wave;
        String aid = "";

        NodeInfo() {
        }

        public String getAid() {
            return this.aid;
        }

        public void setAid(String aid) {
            this.aid = aid;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public String getBand() {
            return this.band;
        }

        public void setBand(String band) {
            this.band = band;
        }

        public String getWave() {
            return this.wave;
        }

        public void setWave(String wave) {
            this.wave = wave;
        }
    }
}

