/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ason.tl1ngwdm.ason;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEAsonCommonUtil {
    public static String getAID(String index, int neid) {
        String aid = "";
        ArrayList<TL1Operation> queryOperList = new ArrayList<TL1Operation>();
        int decimalIndex = 0;
        decimalIndex = index.indexOf("0X") != -1 || index.indexOf("0x") != -1 ? Integer.parseInt(index.substring(2), 16) : Integer.parseInt(index);
        try {
            OutMsg output;
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            TL1Operation tl1Operation = definitions.getTL1Operation("RTRV-INTFINDEX");
            InMsg input = tl1Operation.getInMsg();
            input.getPart("INDEX").setValue(String.valueOf(decimalIndex));
            queryOperList.add(tl1Operation);
            int result = TEAsonCommonUtil.sendMessages(neid, queryOperList);
            if (result == 0 && (output = tl1Operation.getOutMsg(0)).getFault().getCompletionCode() == 0) {
                aid = TEAsonCommonUtil.handleAidMessage(queryOperList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-INTFINDEX Failed!", (Throwable)e);
        }
        return aid;
    }

    public static int sendMessages(int neid, ArrayList tl1OperList) {
        int retCode = 0;
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, (List)tl1OperList, 30);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public static String handleAidMessage(ArrayList queryOperList) {
        String aid = "";
        HashMap hm = null;
        int n = queryOperList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation tl1Operation = (TL1Operation)queryOperList.get(i);
            for (OutMsg out : tl1Operation.getOutMsg()) {
                hm = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
                Part typePart = (Part)hm.get("PORTINFO");
                if (typePart == null || typePart.getValue() == null) continue;
                aid = typePart.getValue();
            }
        }
        return aid;
    }

    public static String handlePortName(String AID, int neID) {
        if (neID == -1) {
            return "/";
        }
        int slotid = 0;
        int portid = 0;
        int boardType = 0;
        String boardName = "UNKNOWN";
        String portName = "(UNKNOWN)";
        String[] aids = TETL1CommonUtil.parseAID((String)AID, (int)neID);
        slotid = TETL1CommonUtil.getNMSlotStr((String)AID, (int)neID);
        portid = TETL1CommonUtil.getNMPortNOFromNEPort((String)aids[0], (int)slotid, (int)Integer.parseInt(aids[3]), (int)neID);
        if (slotid != 0 && slotid != -1) {
            boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotid);
            boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
            if (portid != 0 && portid != -1) {
                portName = TEConfigurationDataMgr.getInstance().getPortName(neID, slotid, boardType, portid);
            } else {
                portid = TETL1CommonUtil.getNMPortNOFromNEPhyPort((String)aids[0], (int)slotid, (int)Integer.parseInt(aids[3]), (int)neID);
                portName = portid + "(UNKNOWN)";
            }
            String showSlot = TETL1CommonUtil.getShelfSlotName((int)neID, (int)slotid);
            return showSlot + "-" + boardName + "-" + portName;
        }
        return "/";
    }

    public static String convertTimeFormat(String timeStr) {
        String[] newTimeStr = timeStr.split("-");
        if (newTimeStr.length == 3) {
            return newTimeStr[0] + ":" + newTimeStr[1] + ":" + newTimeStr[2];
        }
        return "";
    }
}

