/**
 * VLAN        js  
 *   : c00104334
 *   : 2008-08-28
 */
 
var MAX_VLAN_SNCP_ID = 0xffff;
var MIN_VLAN_SNCP_ID = 1;

var sncpIDsOfUsed = []; 

var DIRECTION_BI = "2WAY"; //  

var MAX_VALUE_LINK = 0xfffe;//   linkID 4095
var MIN_VALUE_LINK = 1;//   linkID 0                               

linkIDsOfUsed = [];

var evplWin = getEVPLPage(window);

var workTable;
var protectTable;

var btnRightArr = new Object();

var modifiedData = new Array();

var winobj1 = getNeProperty(parent);
var nmUser = winobj1["nmUser"];

var winobj = parseURLStr(parent);
var neID = winobj["neid"];

var slotID = winobj["slotid"];

var selFlag = false;

var ALL_FLAG = "ALL";
/*
 *   tab   
 */
function tabSelectHandler()
{
	if(!selFlag)
	{
		
		var tableHeight = getComponetHeight($("ttbody"),169)*0.4;
	    tableHeight = tableHeight<100?100:tableHeight;
		workTable.setBodyHeight(tableHeight+"px");
	    protectTable.setBodyHeight(tableHeight+"px");
	    $("workTable").style.height = (tableHeight + 60)+"px" ;
	    $("protectTable").style.height = (tableHeight + 60)+"px" ;    
	    selFlag = true;
	}
	
	getLinkIDsOfUsed();
	refreshData();
}

window.onresize=function()
{		
	var tableHeight = getComponetHeight($("ttbody"),169)*0.4;
    tableHeight = tableHeight<100?100:tableHeight;
	workTable.setBodyHeight(tableHeight+"px");
    protectTable.setBodyHeight(tableHeight+"px");
    $("workTable").style.height = (tableHeight + 60)+"px" ;
    $("protectTable").style.height = (tableHeight + 60)+"px" ;
}

/*
 *        
 */
function initPage()
{ 
    initTable();
    
    initTblInfo();

    initButton();
    
    
    
    
    document.oncontextmenu = "return false";
}
/*
 *            
 */
function initTable()
{
    workTable = new SortTable();
    workTable.setImage("../../../../../../images/");  
    createTableHead(workTable, window.tableconf[0]);
    workTable.setBodyHeight(130);

    $("workTable").appendChild(workTable.getTable());
    
    workTable.setOnRowSelectHandler(handleWTabSelected);
    $("workTable").firstChild.childNodes[1].oncontextmenu = popupMenuHandler;
    
    
    protectTable = new SortTable();
    protectTable.setImage("../../../../../../images/");  
    createTableHead(protectTable, window.tableconf[1]);
    protectTable.setBodyHeight(130);    

    $("protectTable").appendChild(protectTable.getTable());
    
    protectTable.setOnRowSelectHandler(handlePTabSelected);
    workTable.setOnCellEditHandler(cellEditHandler);

}

/*
 *         
 */
function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
   	$("functionMenus").value = RESOURCE["functionbutton"];
   	
   	$("cnvtnorbtn").value = RESOURCE["cnvtnorbutton"];
   	$("crtsncpbtn").value = RESOURCE["crtsncpbutton"];
   	
   	btnRightArr.querybtn = new BtnRightObj("querybtn",TE_IP_VLANSNCP_MANAGE); 
   	btnRightArr.applybtn = new BtnRightObj("applybtn",TE_IP_VLANSNCPATTR_MODIFY);
   	
   	btnRightArr.functionMenus = new BtnRightObj("functionMenus",TE_IP_VLANSNCP_SWITCHSTATUS_QUERY);
   	btnRightArr.activatebtn = new BtnRightObj("activatebtn",TE_IP_VLAN_OAMENABLE);
   	btnRightArr.cnvtnorbtn = new BtnRightObj("cnvtnorbtn",TE_IP_SNCPNORMAL_CONVERT);
   	btnRightArr.crtsncpbtn = new BtnRightObj("crtsncpbtn",TE_IP_VLANSNCP_CREATE);
   	
    sendRightInfo(btnRightArr); 
}

/*
 *                  
 */
function initTblInfo()
{
	var workCount = workTable.getDataRowLength();;
	
	var protectCount = protectTable.getDataRowLength();
	
	var selectedWCount = workTable.getSelectedRowCount();
	
	var selectedPCount = protectTable.getSelectedRowCount();
	
	$("workTblName").innerHTML = RESOURCE["workplayload"];
	$("workTblInfo1").innerHTML = RESOURCE["totalpayload"] + workCount;
	$("protectTblName").innerHTML = RESOURCE["protectpayload"];
	$("protectTblInfo1").innerHTML = RESOURCE["totalpayload"] + protectCount;
	$("workTblInfo2").innerHTML = RESOURCE["selectedpayload"] + selectedWCount;
	$("protectTblInfo2").innerHTML = RESOURCE["selectedpayload"] + selectedPCount;
}

/*
 *     
 */
function refreshData()
{		
	doQuery();	
	
    getVlanSNCPIDOfUsed();
}

/*
 *        onclick  
 */
function doQuery()
{	
	$("crtsncpbtn").disabled = !btnRightArr.crtsncpbtn.right;
	$("querybtn").disabled = !btnRightArr.querybtn.right;
	
	$("applybtn").disabled = true;
	$("functionMenus").disabled = true;
	$("cnvtnorbtn").disabled = true;	
	
	if(!btnRightArr.querybtn.right)
	{
		return;
	}
	
	$("querybtn").disabled = true;
	var xmlData = createQueryXmlInfo();
	var queryURL = "../../../../../../tl1NEExlorerServlet?sfid="+TE_IP_VLANSNCP_MANAGE+"&flag=1&nmUser="+winobj1["nmUser"];
	loadXMLdoc(queryURL, "POST", false, callbackQuery, null, "inputdata="+xmlData);
}

/*
 *     vlansncp   XML   
 */
function createQueryXmlInfo()
{
 	var root = new inputxml("datainterface");
 	var business = new tagElement("bussiness-params");
 	var row = new tagElement("row-params");
 	var param = new tagElement("param");
 	
 	param.setAttribute("name", "neID");
 	param.setAttribute("value", neID);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "slotid");
 	param.setAttribute("value", slotID);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "srcPort");
 	param.setAttribute("value", ALL_FLAG);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "snkPort");
 	param.setAttribute("value", ALL_FLAG);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "INTAG");
 	param.setAttribute("value", ALL_FLAG);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "INSTAG");
 	param.setAttribute("value", ALL_FLAG);
 	row.appendChild(param);
 	 	
 	business.appendChild(row);
 	
 	root.getRoot().appendChild(business);
 	return root.toString();
}

/*
 *       
 */
function clearTable()
{
	workTable.clearTableData();
	
	protectTable.clearTableData();
}

/*
 *   vlansncp     ,        
 */
function callbackQuery(doc)
{       
    var datainterface = EncapsulateData(doc);
    
    showErrorDialog(datainterface);
    
    if( OPRFAIL != datainterface.getSErrorCode() )
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neID,false);
    	
	    clearTable();
	    
	    datainterface = encapsulateSNCPData(datainterface);
        
        createTableBody(workTable, window.tableconf[0], datainterface, RESOURCE);
	    
	    sncpIDsOfUsed = [];
	    for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	    {	    	
	    	var vlansncpID = workTable.getCellStoreValue(i, "vlansncpID", "vlansncpID");
		    sncpIDsOfUsed.push(vlansncpID);
	    	
	    	var wrtTimeCell = workTable.getCell(i, "wrtTime");
	    	
	    	if(WRTTIME_NO_RESUME_DEFAULT == wrtTimeCell.element.storeValue.wrtTime)
	    	{
	    		setCellEditDisable(workTable, i, "wrtTime");
	    	}
	    }

	   if(!workTable.element.colsArray.selectedId)
	    {
	  	   workTable.element.colsArray.selectedId = "srcVlan";
	  	   workTable.element.colsArray.imgflag = 1;
	    }
	    var td=workTable.element.headRow.element.cols[workTable.element.colsArray.selectedId].element; 
	    workTable.sortRows(td,workTable.element.colsArray.imgflag);
	    workTable.element.colsArray.selectedId = null;
	    workTable.element.colsArray.imgflag = null;
	    
	    createTableBody(protectTable, window.tableconf[1], datainterface, RESOURCE);
	    
	    if(!protectTable.element.colsArray.selectedId)
	    {
	  	   protectTable.element.colsArray.selectedId = "psrcVlan";
	  	   protectTable.element.colsArray.imgflag = 1;
	    }
	    var td=protectTable.element.headRow.element.cols[protectTable.element.colsArray.selectedId].element; 
	    protectTable.sortRows(td,protectTable.element.colsArray.imgflag);
	    protectTable.element.colsArray.selectedId = null;
	  	protectTable.element.colsArray.imgflag = null;
	    
	    registerHoldTimeEvent();
	    
	    registerWrtModeEvent();
	    
	    
	    initTblInfo();
    }

    $("querybtn").disabled = false;
}

/*
 *            
 * 
 */
function registerWrtTimeEvent()
{
	var atom;
	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	{
		atom = workTable.getCellEdit(i, "wrtTime");
		
		atom.element.style.imeMode = "disabled";
		
		atom.element.onpaste = function()
		{
			return false;
		};
		
		textCheck(atom.element, WRTTIME_MIN, WRTTIME_MAX);
		
        atom.element.onblur = function()
        {
		    
		    
		    var pnode = this.parentNode;
            var hc = this.parentNode.parent.getHeadCell(this.parentNode.colid);
			
			this.parentNode.showElement.setValue(this.value);
		    this.parentNode.parent.setTdCellValue(this.parentNode, hc.element.keys[0], this.value);
			
		    this.parentNode.showElement.element.style.display = "";
		    
		    this.style.position="static";
		    this.style.border="1px solid #999999";
		    this.style.width=this.parentNode.offsetWidth;    
			var rows= this.parentNode.parent.getSelectedRows();
			for(var j=0; j<rows.length; j++)
	        {
	            var cell=  this.parentNode.parent.getCell(rows[j],this.parentNode.colid);	
	            if(null == cell.element.editElement || cell.element.isEdit == 0)
	            {
	          	    continue;
	            }	  	
	            cell.element.showElement.setValue(this.value);
	          
	            cell.element.modify = true;
	            cell.element.parentNode.modify = true;
	            cell.element.style.backgroundColor="#d0f946";
	            cell.element.parent.setTdCellValue(cell.element, this.parentNode.colid, this.value);          
	            cell.element.showElement.element.style.display	=	"";
	            handleCellEdit(cell.element,TABLE_CONSTANT.AFTEREDIT); 
	        }  
	        pnode.removeChild(pnode.lastChild);  
		}
	}
}

/*
 *            
 * onchange  
 *                      
 *                  
 */
function registerWrtModeEvent()
{
	var atom;
	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	{		
		atom = workTable.getCellEdit(i, "wrtMode");
		
		atom.element.onchange = function()
		{
		    if(this.value == WRTMODE_VALUE_N)
		    {
		    	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
			    {
					if(workTable.getRowSelFlag(i))
					{
						var wrtTimeShowAtom = workTable.getCellShow(i, "wrtTime");
						var wrtTimeEditAtom = workTable.getCellEdit(i, "wrtTime");
						var wrtTimeCell = workTable.getCell(i, "wrtTime");
											    			
	    				setCellEditDisable(workTable, i, "wrtTime");
	    				workTable.setAtomValue(wrtTimeShowAtom, wrtTimeFormat(WRTTIME_NO_RESUME_DEFAULT));
	    				workTable.setAtomValue(wrtTimeEditAtom, WRTTIME_NO_RESUME_DEFAULT);
	    				workTable.setCellValue(wrtTimeCell, "wrtTime", WRTTIME_NO_RESUME_DEFAULT);
		            }
		            		            
		        }
				for(var j = 0, jLen = protectTable.getDataRowLength(); j < jLen; j++)
        		{
        			if(protectTable.getRowSelFlag(j))
        			{
        				var wrtModeShowAtom = protectTable.getCellShow(j, "wrtMode");
        				var wrtModeCell = protectTable.getCell(j, "wrtMode");
        				var wrtTimeShowAtom = protectTable.getCellShow(j, "wrtTime");
        				
        				protectTable.setAtomValue(wrtModeShowAtom, RESOURCE[WrtMode["N"]]);		        				
        				protectTable.setAtomValue(wrtTimeShowAtom, wrtTimeFormat(WRTTIME_NO_RESUME_DEFAULT));
        				protectTable.setCellValue(wrtModeCell, "wrtMode", WRTMODE_VALUE_N);
        			}
        		}
			}
	    	else if(this.value == WRTMODE_VALUE_Y)
	    	{
				for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
				{
					if(workTable.getRowSelFlag(i))
					{
						var wrtTimeShowAtom = workTable.getCellShow(i, "wrtTime");
						var wrtTimeEditAtom = workTable.getCellEdit(i, "wrtTime");
						var wrtTimeCell = workTable.getCell(i, "wrtTime");
				    			
        				workTable.setCellIsEdit(wrtTimeCell,1);
        				workTable.setAtomValue(wrtTimeShowAtom, wrtTimeFormat(WRTTIME_DBCLICK_DEFAULT));
        				workTable.setAtomValue(wrtTimeEditAtom, WRTTIME_DBCLICK_DEFAULT);
        				workTable.setCellValue(wrtTimeCell, "wrtTime", WRTTIME_DBCLICK_DEFAULT);
		    	        
		    		}
		    	}
				for(var j = 0, jLen = protectTable.getDataRowLength(); j < jLen; j++)
        		{
        			if(protectTable.getRowSelFlag(j))
        			{
        				var wrtModeShowAtom = protectTable.getCellShow(j, "wrtMode");
        				var wrtModeCell = protectTable.getCell(j, "wrtMode");
        				var wrtTimeShowAtom = protectTable.getCellShow(j, "wrtTime");
        				protectTable.setAtomValue(wrtModeShowAtom, RESOURCE[WrtMode["Y"]]);
        				protectTable.setAtomValue(wrtTimeShowAtom, wrtTimeFormat(WRTTIME_DBCLICK_DEFAULT));
        				protectTable.setCellValue(wrtModeCell, "wrtMode", WRTMODE_VALUE_Y);
        			}
        		}
		    	
	    	}
        }		        
	}
	
}

/*
 *             
 * onkeydown                 
 * onkeyup               
 */
function registerHoldTimeEvent()
{
	var atom;
	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	{
		atom = workTable.getCellEdit(i, "holdTime");		
		textCheck(atom.element, HOLDTIME_MIN, HOLDTIME_MAX);
        atom.element.onblur = function()
        {
            if(parseInt(this.value) < HOLDTIME_MIN || "" == this.value)
		    {
		        alert(RESOURCE["holdTimeinvalidrange"]);
		        this.value = HOLDTIME_MIN;		        
		    }
		    else if (parseInt(this.value) > HOLDTIME_MAX)
		    {
		        alert(RESOURCE["holdTimeinvalidrange"]);
		        this.value = HOLDTIME_MAX;	
		    }
		    		    
		    for(var i = 0, len = protectTable.getDataRowLength(); i < len; i++)		    
		    {
		    	if(protectTable.getRowSelFlag(i))
		    	{
		    		var wrtTimeShowAtom = protectTable.getCellShow(i, "holdTime");
		    		
		    		protectTable.setAtomValue(wrtTimeShowAtom, this.value);
		    	}
		    }
		    var pnode = this.parentNode;
            var hc = this.parentNode.parent.getHeadCell(this.parentNode.colid);
			
			this.parentNode.showElement.setValue(this.value);
		    this.parentNode.parent.setTdCellValue(this.parentNode, hc.element.keys[0], this.value);
			
		    this.parentNode.showElement.element.style.display = "";
		    
		    this.style.position="static";
		    this.style.border="1px solid #999999";
		    this.style.width=this.parentNode.offsetWidth;    
			var rows= this.parentNode.parent.getSelectedRows();
			for(var j=0; j<rows.length; j++)
	        {
	            var cell=  this.parentNode.parent.getCell(rows[j],this.parentNode.colid);	
	            if(null == cell.element.editElement || cell.element.isEdit == 0)
	            {
	          	    continue;
	            }	  	
	            cell.element.showElement.setValue(this.value);
	          
	            cell.element.modify = true;
	            cell.element.parentNode.modify = true;
	            cell.element.style.backgroundColor="#d0f946";
	            cell.element.parent.setTdCellValue(cell.element, this.parentNode.colid, this.value);          
	            cell.element.showElement.element.style.display = "";
	            handleCellEdit(cell.element,TABLE_CONSTANT.AFTEREDIT); 
	        }
	        pnode.removeChild(pnode.lastChild);     
        }
	}
}

/*                  convert   
 *                       
 */
function encapsulateSNCPData(datainterface)
{
	sncpData = new DataInterface();
	
	for(var i = 0, len = datainterface.getDataRowLength(); i < len; i++)
	{
	    var diObj = datainterface.rows[i];
	    
	    var ptag = new ParamTag();
	    ptag.value = diObj["wrtMode"].value;
	    diObj["hideWrtMode"] = ptag;
	    
	    
	    sncpData.rows[sncpData.rows.length] = diObj;
	    
	    diObj = null;
	}
	return sncpData;
}

/*
 *            
 *                  vlansncpID    
 *            
 */
function handleWTabSelected()
{
	var isSelected = false;
	var tempFlag = 0; //                    
	for(var k = 0, len = protectTable.getDataRowLength(); k < len; k++)
	{
		if(protectTable.getRowSelFlag(k))
	    {	
	        protectTable.setRowNoneSelect(k);
		}
	}
    for(var i = 0, wTLen = workTable.getDataRowLength(); i < wTLen; i++)
    {
        if(workTable.getRowSelFlag(i))
        {
            isSelected = true;
            var vlansncpID = workTable.getCellStoreValue(i,"vlansncpID", "vlansncpID");	
            var scrollheight = 0;
            for(var j = 0, pTLen = protectTable.getDataRowLength(); j < pTLen; j++)
            {
                if(vlansncpID == protectTable.getCellStoreValue(j, "vlansncpID", "vlansncpID"))
                {
                	var cellEle = protectTable.getHeadCell("vlansncpID").element;
                	protectTable.sortSpelRows(cellEle,vlansncpID,tempFlag);
                	protectTable.setRowSelect(tempFlag);
                	
                	protectTable.bodyPack.scrollTop = scrollheight;

					               	
                	tempFlag++;
                	
                    
                }	
            }
        }
    }
    
    if(isSelected)
    {    	
		$("functionMenus").disabled = !btnRightArr.functionMenus.right;
		$("cnvtnorbtn").disabled = !btnRightArr.cnvtnorbtn.right;
    }
    else
    {
    	$("functionMenus").disabled = true;
		$("cnvtnorbtn").disabled = true;
    }
    
    initTblInfo();
}

/*
 *              
 *                  vlansncpID    
 *            
 */
function handlePTabSelected()
{    
	var isSelected = false;
	var tempFlag = 0; //                    
	for(var k = 0, len = workTable.getDataRowLength(); k < len; k++)
	{
		if(workTable.getRowSelFlag(k))
	    {	
	        workTable.setRowNoneSelect(k);
		}
	}
    for(var i = 0, pTLen = protectTable.getDataRowLength(); i < pTLen; i++)
    {
        if(protectTable.getRowSelFlag(i))
        {
            isSelected = true;
            var vlansncpID = protectTable.getCellStoreValue(i,"vlansncpID", "vlansncpID");	
     		var scrollheight = 0;
            for(var j = 0, wTLen = workTable.getDataRowLength(); j < wTLen; j++)
            {
                if(vlansncpID == workTable.getCellStoreValue(j, "vlansncpID", "vlansncpID"))
                {
                	var cellEle = workTable.getHeadCell("vlansncpID").element;
                	workTable.sortSpelRows(cellEle,vlansncpID,tempFlag);
                	workTable.setRowSelect(tempFlag);
                	
                	workTable.bodyPack.scrollTop = scrollheight;

					               	
                	tempFlag++;
                }	
            }
        }
    }
    if(isSelected)
    {    	
		$("functionMenus").disabled = !btnRightArr.functionMenus.right;
		$("cnvtnorbtn").disabled = !btnRightArr.cnvtnorbtn.right;
    }
    else
    {
    	$("functionMenus").disabled = true;
		$("cnvtnorbtn").disabled = true;
    }
    
    initTblInfo();	
}

/*
 *               
 */
function isValidateHTime()
{
	var editElement;
	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	{
		editElement = workTable.getCellEdit(i, "holdTime");
		editElement.element.style.imeMode = "disabled";
		editElement.element["onkeydown"] = function() { return digitalTag_checkDown(this, 16) }
	}
}

/*
 *       onclick  
 */
function doApply()
{
	getModifiedData();
	
	if(0 == modifiedData.length)
	{
		alert(RESOURCE["nodatamodifide"]);		
	}
	else
	{
		$("applybtn").disabled = true;
		
		var xmlData = createApplyXmlInfo();
	    var applyURL = "../../../../../../tl1NEExlorerServlet?sfid="+TE_IP_VLANSNCPATTR_MODIFY+"&flag=1&nmUser="+winobj1["nmUser"];
	    loadXMLdoc(applyURL, "POST", true, callbackApply, null, "inputdata="+xmlData);
	    
	    dataModify = [];
	}
	
}
/*
 *          
 */
function callbackApply(doc)
{
    var datainterface = EncapsulateData(doc);	
    showErrorDialog(datainterface);
    
    if(0 != datainterface.getSErrorCode())
	{
	    $("applybtn").disabled = false;
	}
	else
	{
		setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neID,false);
	}
	  
	refreshTableState(workTable,window.tableconf[0],datainterface);	
		
}

/**
 * refresh Table State
 * @param st:sortTable tc:tableConf data:DataInterface
 * @return null
 */
function refreshTableState(st,tc,data)
{

	if(0 != data.getSErrorCode() && 1 != data.getSErrorCode())
	{
		return;    		
	}
    	
	var allError = data.getError();
	var errColidArr = new Array();
	var errObjArr = new Array();
	var errDataArr = new Array();
	
	for(var i = 0, len = allError.getRowErrLength(); i < len; i++)
	{
		var colids = new Array();
	    var keys = new Array();
		for(var data in allError.rowErrors[i].errorObj)
		{
			if(null != tc.getColIdFromKey(data))
			{
				colids.push(tc.getColIdFromKey(data));
				keys.push(data);	
			}					
		}
		errColidArr.push(colids);
		errObjArr.push(keys);	
		errDataArr.push(allError.rowErrors[i]);		
	}	
	
	var errorCount = 0;
	var tmpValue = "";
	var convert = "";
	var col = null;
	var tmpflag = false;
	for(var i = 0, len = st.getDataRowLength(); i < len; i++)
    {
		if(!st.getModify(i))
		{
			continue;
		}
		for(var j = 0, size = tc.getColsLength(); j < size; j++)
		{		
			if(st.getCellModify(i,tc.getColId(j)))
			{
				errorCount = 0;
				tmpflag = false;
				for(var index = 0; index < errColidArr.length; index++)
				{	
					if(errColidArr[index].contains(tc.getColId(j)))
					{
						tmpflag = true;
						for(var m = 0; m < errColidArr[index].length; m ++)
						{
							tmpValue = st.getCellStoreValue(i,errColidArr[index][m],errObjArr[index][m]);
							col = tc.getColFromColId(errColidArr[index][m]);
							if(col.cell.isEdit == false)
							{
								convert = col.keyArray[getKeyIndex(col.keyArray,errObjArr[index][m])].convert;
								if(convert)
								{
									tmpValue = convertValue(eval(convert),tmpValue);
								}
							}
							if(null != tmpValue && tmpValue != errDataArr[index].errorObj[errObjArr[index][m]])
							{
								errorCount++;
								break;
							}
						}						
					}
				}				
				
				if( !tmpflag || errorCount == errColidArr.length)
				{
					if("wrtMode" == tc.getColId(j))
					{
						var hWrtModeCell = st.getCell(i, "hideWrtMode");
						hWrtModeCell.element.storeValue["hideWrtMode"] = st.getCellStoreValue(i, "wrtMode", "wrtMode");
					}
					st.getCellElement(i,tc.getColId(j)).modify = false;
	
					st.getCellElement(i,tc.getColId(j)).style.background = "#ffffff";
					
					errColidArr.removeAt(index);
					errObjArr.removeAt(index);	
					errDataArr.removeAt(index);	
				}				
			}
		}	
		
		var rowModify = false;
		for(var j = 0, size = tc.getColsLength(); j < size; j++)
		{
			if(st.getCellModify(i,tc.getColId(j)))
			{
			   rowModify = true;
			   break;
			}	
		}	
		if(false == rowModify)
		{
			st.getRow(i).element.modify = false;
		}	
    }
}
 
/*
 *          
 */
function createApplyXmlInfo()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	
	for(var i = 0, len = modifiedData.length; i < len; i++)
	{
		var row = new tagElement("row-params");
		
		var param = new tagElement("param");
		param.setAttribute("name", "neID");
		param.setAttribute("value", neID);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param.setAttribute("value", slotID);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "vlansncpID");
		param.setAttribute("value", modifiedData[i].vlansncpID);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "HOLDOFFTIME");
		param.setAttribute("value", modifiedData[i].holdTime);
		param.setAttribute("modifyFlag", modifiedData[i].holdTimeModify);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "RVRTV");
		param.setAttribute("value", modifiedData[i].wrtMode);
		param.setAttribute("modifyFlag", modifiedData[i].wrtModeModify);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "RVTM");
		param.setAttribute("value", modifiedData[i].wrtTime);
		param.setAttribute("modifyFlag", modifiedData[i].wrtTimeModify);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "srcPort");
		param.setAttribute("value", modifiedData[i].srcPort);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "snkPort");
		param.setAttribute("value", modifiedData[i].snkPort);
		row.appendChild(param);
		
		if (modifiedData[i].LINKINTAG != "-" && modifiedData[i].LINKINTAG != "")
		{
    		param = new tagElement("param");
    		param.setAttribute("name", "LINKINTAG");
    		param.setAttribute("value", modifiedData[i].LINKINTAG);
    		row.appendChild(param);
    	}
		
		if (modifiedData[i].LINKINSTAG != "-" && modifiedData[i].LINKINSTAG != "")
		{
    		param = new tagElement("param");
    		param.setAttribute("name", "LINKINSTAG");
    		param.setAttribute("value", modifiedData[i].LINKINSTAG);
    		row.appendChild(param);
    	}
		
		bussiness.appendChild(row);
	}
	
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}


/*
 *       
 */
function getModifiedData()
{
	modifiedData = [];
	
    for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
    {
    	if(workTable.getModify(i))
    	{
    		var obj = new Object();   	
    
    		
    		cellModifyFlag = workTable.getCellModify(i,"vlansncpID");
            
    		obj.vlansncpID = workTable.getCellStoreValue(i, "vlansncpID", "vlansncpID");
    		
    		obj.holdTime = workTable.getCellStoreValue(i, "holdTime", "holdTime");
    		obj.holdTimeModify = workTable.getCellModify(i,"holdTime");
    		
    		obj.wrtMode = workTable.getCellStoreValue(i, "wrtMode", "wrtMode");
    		obj.wrtModeModify = workTable.getCellModify(i,"wrtMode");

			var wrtShowtime = workTable.getCellShow(i, "wrtTime").getValue();
    		obj.wrtTime = convertWrtTime(wrtShowtime)
    		obj.wrtTimeModify = workTable.getCellModify(i,"wrtTime");
    		
    		obj.srcPort = workTable.getCellStoreValue(i, "srcPort", "srcPort");
    		obj.snkPort = workTable.getCellStoreValue(i, "snkPort", "snkPort");
    		
    		obj.LINKINTAG = workTable.getCellStoreValue(i, "srcVlan", "srcVlan");
    		obj.LINKINSTAG = workTable.getCellStoreValue(i, "srcSVlan", "srcSVlan");
    		
    		modifiedData[modifiedData.length] = obj;
    	}
    }
}

function convertWrtTime(wrttime)
{
	var temparr = wrttime.split(":");
	var min = parseInt(temparr[0],10);
	var sec = parseInt(temparr[1],10);
	
	return (min * 60) + sec;
}

/*
 *   sncp           
 *         vlan        vlan    
 *                     
 */
function doConvertNormal()
{
	removejsDOMmenu();
	if(0 == workTable.getSelectedRowCount())
	{
		alert(RESOURCE["noselected"]);
		return;
	}
	
    if(confirm(RESOURCE["isconvertnor"]))
    {
		$("cnvtnorbtn").disabled = true;
		
		var xmlData =  createConvertNormalXml();
		
		var convertURL = "../../../../../../tl1NEExlorerServlet?sfid="+TE_IP_SNCPNORMAL_CONVERT+"&flag=1&nmUser="+winobj1["nmUser"];
		loadXMLdoc(convertURL, "POST", true, callbackConvert, null, "inputdata="+xmlData);
	}
}

/*
 *    vlan               xml
 */
function createConvertNormalXml()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	
	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	{
		if(workTable.getRowSelFlag(i))
		{
			var row = new tagElement("row-params");
			
			var param = new tagElement("param");
			param.setAttribute("name", "neID");
			param.setAttribute("value", neID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", slotID);
			row.appendChild(param);
			
			var vlansncpID = workTable.getCellStoreValue(i, "vlansncpID", "vlansncpID");
			param = new tagElement("param");
			param.setAttribute("name", "vlansncpID");
			param.setAttribute("value", vlansncpID);
			row.appendChild(param);
			
			var srcPort = workTable.getCellStoreValue(i, "srcPort", "srcPort");
			param = new tagElement("param");
			param.setAttribute("name", "srcPort");
			param.setAttribute("value", srcPort);
			row.appendChild(param);
			
			var snkPort = workTable.getCellStoreValue(i, "snkPort", "snkPort");
			param = new tagElement("param");
			param.setAttribute("name", "snkPort");
			param.setAttribute("value", snkPort);
			row.appendChild(param);
			
			var linkintag = workTable.getCellStoreValue(i, "srcVlan", "srcVlan");
			if (linkintag != "-" && linkintag != "")
    		{
    		    param = new tagElement("param");
	    		param.setAttribute("name", "LINKINTAG");
		    	param.setAttribute("value", linkintag);
			    row.appendChild(param);
			}
			
			var linkinstag = workTable.getCellStoreValue(i, "srcSVlan", "srcSVlan");
			if (linkinstag != "-" && linkinstag != "")
			{
    			param = new tagElement("param");
    			param.setAttribute("name", "LINKINSTAG");
    			param.setAttribute("value", linkinstag);
    			row.appendChild(param);
    		}
			bussiness.appendChild(row);
		}
	}
	
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}

/*
 * vlansncp                 
 */
function callbackConvert(doc)
{	
    var datainterface = EncapsulateData(doc);
    showErrorDialog(datainterface);
    
    if(OPRFAIL != datainterface.getSErrorCode())
    {
	    var isWNSucc = false;
	    
	    for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	    {
	    	if(workTable.getRowSelFlag(i))
	    	{
		    	for(var j = 0, jLen = datainterface.getBErrLength(); j < jLen; j++)
		    	{
		    	    if(datainterface.getBErrParam(j, "vlansncpID") == workTable.getCellStoreValue(i, "vlansncpID", "vlansncpID"))
		    	    {
		    	    	isWNSucc = true;
		    	    	break;
		    	    }	    	    
		    	}
		    	if(!isWNSucc)
		    	{
		    		workTable.deleteRow(i);	    		
		    	}
		    	isWNSucc = false;
		    }
	    }	    
	    workTable.adjustDataRows();
	    var num = workTable.getDataRowLength();
	    adjustTableLayout(workTable,window.tableconf[0],num);
	    
	    var isPNSucc = false;
	    for(var i = 0, len = protectTable.getDataRowLength(); i < len; i++)
	    {
	    	if(protectTable.getRowSelFlag(i))
	    	{
		    	for(var j = 0, jLen = datainterface.getBErrLength(); j < jLen; j++)
		    	{
		    	    if(datainterface.getBErrParam(j, "vlansncpID") == protectTable.getCellStoreValue(i, "vlansncpID", "vlansncpID"))
		    	    {
		    	    	isPNSucc = true;
		    	    	break;
		    	    }	    	    
		    	}
		    	if(!isPNSucc)
		    	{
		    		protectTable.deleteRow(i);	    		
		    	}
		    	isPNSucc = false;
		    }
	    }
	    protectTable.adjustDataRows();
	    var num = protectTable.getDataRowLength();
	    adjustTableLayout(protectTable,window.tableconf[1],num);
	    initTblInfo();
    }
    getVlanSNCPIDOfUsed();
	
	$("cnvtnorbtn").disabled = false;
}

/*
 * vlan sncp Link       
 * oamenFlag 0-     1-  
 */
function doActivateSNCP(oamenFlag)
{
	removejsDOMmenu();
	if( 0 == workTable.getSelectedRowCount())
	{
		alert(RESOURCE["noselected"]);
		return;
	}
	
	var xmlData = createActivateSNCPXmlInfo(oamenFlag);
	
	var activateURL = "../../../../../../tl1NEExlorerServlet?sfid="+TE_IP_VLAN_OAMENABLE+"&flag=1&nmUser="+winobj1["nmUser"];
	loadXMLdoc(activateURL, "POST", true, callbackActivate, oamenFlag, "inputdata="+xmlData);
	
}

/*
 *      sncp  link   xml
 *  oamenFlag 0-     1-  
 */
function createActivateSNCPXmlInfo(oamenFlag)
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	
	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	{
		if(workTable.getRowSelFlag(i))
		{
			var row = new tagElement("row-params");
			
			var param = new tagElement("param");
			param.setAttribute("name", "neID");
			param.setAttribute("value", neID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", slotID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "linkID");
			var linkID = workTable.getCellStoreValue(i, "linkID", "linkID");
			param.setAttribute("value", linkID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "oamEN");
			param.setAttribute("value", oamenFlag);
			row.appendChild(param);
			
			bussiness.appendChild(row);
		}
	}
	
	for(var i = 0, len = protectTable.getDataRowLength(); i < len; i++)
	{
		if(protectTable.getRowSelFlag(i))
		{
			var row = new tagElement("row-params");
			
			var param = new tagElement("param");
			param.setAttribute("name", "neID");
			param.setAttribute("value", neID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", slotID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "linkID");
			var linkID = protectTable.getCellStoreValue(i, "plinkID", "plinkID");
			param.setAttribute("value", linkID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "oamEN");
			param.setAttribute("value", oamenFlag);
			row.appendChild(param);
			
			bussiness.appendChild(row);
		}
	}
	
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
}

/*
 *   vlansncp  link       
 */
function callbackActivate(doc, oamenFlag)
{	
    var datainterface = EncapsulateData(doc);
    showErrorDialog(datainterface);
    
    
    var isNsucc = false;
    
    if(2 != datainterface.getSErrorCode())
    {
	    for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	    {
	    	if(workTable.getRowSelFlag(i))
	    	{
	    		for(var j = 0, jLen = datainterface.getBErrLength(); j < jLen; j++)
	    		{
		    		if(datainterface.getBErrParam(j, "linkID") == workTable.getCellStoreValue(i, "linkID", "linkID"))
		    		{
		    			isNsucc = true;
		    			break;
		    		}
	    	    }
	    	    
		    	if(!isNsucc)
		    	{
		    		var oamENCell = workTable.getCell(i, "oamEN");
	    			workTable.setAtomValue(oamENCell.element.showElement, RESOURCE[ActStatus[oamenFlag]]);
	    			oamENCell.element.storeValue["oamEN"] = oamenFlag;
	    			oamENCell.element.currentValue["oamEN"] = RESOURCE[ActStatus[oamenFlag]];	    				    			
		    	}
		    	
		    	isNsucc = false;
		    			    	
	    	}
	    	
	    }
	    
	    for(var i = 0, len = protectTable.getDataRowLength(); i < len; i++)
	    {
	    	if(protectTable.getRowSelFlag(i))
	    	{
	    		for(var j = 0, jLen = datainterface.getBErrLength(); j < jLen; j++)
	    		{
		    		if(datainterface.getBErrParam(j, "linkID") == protectTable.getCellStoreValue(i, "plinkID", "plinkID"))
		    		{
		    			isNsucc = true;
		    			break;
		    		}
	    	    }
	    	    
		    	if(!isNsucc)
		    	{
		    		var oamENCell = protectTable.getCell(i, "poamEN");
	    			protectTable.setAtomValue(oamENCell.element.showElement, RESOURCE[ActStatus[oamenFlag]]);
	    			oamENCell.element.storeValue["poamEN"] = oamenFlag;
	    			oamENCell.element.currentValue["poamEN"] = RESOURCE[ActStatus[oamenFlag]];	    				    			
		    	}
		    	
		    	isNsucc = false;		    	
	    	}
	    	
	    }
	}
    
        
}

/*
 *       
 * command     
 * 0.       
 * 1.   
 * 2.        
 * 3.        
 * 4.        
 * 5.        
 * 6.     
 */
function doVlanSncpSwitch(command)
{
	removejsDOMmenu();
	if(0 == workTable.getSelectedRowCount())
	{
		alert(RESOURCE["noselected"]);
		return;
	}
	
	$("functionMenus").disabled = true;
	
	var xmlData;
	
	if(SWSTATUS_QUERY == command)
	{
		xmlData = createQueryStatusXml();
		
		var urlreq ="../../../../../../tl1NEExlorerServlet?sfid="+TE_IP_VLANSNCP_SWITCHSTATUS_QUERY+"&flag=1&nmUser="+winobj1["nmUser"];
        loadXMLdoc(urlreq, "POST", true, callbackQueryStatus, null,"inputdata="+xmlData);
	}
	else
	{
		var swStatus;
		
		var workLink;
		
		switch(command)
		{
			case SWSTATUS_CLEAR:		    
			    swStatus = CLEARSWITCHCMD;
			    workLink = WORKPATH;
			    break;
			    
			case SWSTATUS_FRC_W_P:
			    swStatus = FORCESWITCHCMD;
			    workLink = PROTECTPATH;
			    break;
			    
			case SWSTATUS_FRC_P_W:			    
			    swStatus = FORCESWITCHCMD;
			    workLink = WORKPATH;
			    break;    
			    
			case SWSTATUS_MAN_W_P:			    
			    swStatus = MANUALSWITCHCMD;
			    workLink = PROTECTPATH;
			    break;    
			   
		    case SWSTATUS_MAN_P_W:		       
			    swStatus = MANUALSWITCHCMD;
			    workLink = WORKPATH;
			    break;    
			    
			case SWSTATUS_LOCKOUT:
			    swStatus = LOCKSWITCHCMD;
			    workLink = WORKPATH;
			    break;    
		}
		
		xmlData = createSwitchXml(swStatus, workLink, command);
		
		if(null != xmlData)
		{
		    if (CLEARSWITCHCMD != swStatus)
		    {
    			var urlreq ="../../../../../../tl1NEExlorerServlet?sfid="+TE_IP_VLANSNCP_SWITCHSTATUS_SET+"&flag=1&nmUser="+winobj1["nmUser"];
    	        loadXMLdoc(urlreq, "POST", true, callbackSwitch, null, "inputdata="+xmlData);
    	    }
    	    else
    	    {
    	        var urlreq ="../../../../../../tl1NEExlorerServlet?sfid="+555555+"&flag=1&nmUser="+winobj1["nmUser"];
    	        loadXMLdoc(urlreq, "POST", true, callbackSwitch, null, "inputdata="+xmlData);
    	    }
	    }
	}
		
}

/*
 *            xml
 */
function createQueryStatusXml()
{
	 var root = new inputxml("datainterface");
	 var bussiness = new tagElement("bussiness-params");
	 
	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	{
		if(workTable.getRowSelFlag(i))
		{
			var row = new tagElement("row-params");
			
			var param = new tagElement("param");
			param.setAttribute("name", "neID");
			param.setAttribute("value", neID); 
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", slotID);
			row.appendChild(param);
			
			var srcPort = workTable.getCellStoreValue(i, "srcPort", "srcPort");
			param = new tagElement("param");
			param.setAttribute("name", "srcPort");
			param.setAttribute("value", srcPort);
			row.appendChild(param);
			
			var snkPort = workTable.getCellStoreValue(i, "snkPort", "snkPort");
			param = new tagElement("param");
			param.setAttribute("name", "snkPort");
			param.setAttribute("value", snkPort);
			row.appendChild(param);
			
			var srcVlan = workTable.getCellStoreValue(i, "srcVlan", "srcVlan");
			if ("-" != srcVlan)
			{
    			param = new tagElement("param");
    			param.setAttribute("name", "LINKINTAG");
    			param.setAttribute("value", srcVlan);
    			row.appendChild(param);
    		}
			
			var srcSVlan = workTable.getCellStoreValue(i, "srcSVlan", "srcSVlan");
			if ("-" != srcSVlan)
			{
			    param = new tagElement("param");
    			param.setAttribute("name", "LINKINSTAG");
    			param.setAttribute("value", srcSVlan);
    			row.appendChild(param);
			}
			
			bussiness.appendChild(row);
		}
    }
    
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}

/*
 *            
 */
function callbackQueryStatus(doc)
{
    var datainterface = EncapsulateData(doc);
    showErrorDialog(datainterface);
    
    for(var i = 0, len = datainterface.getDataRowLength(); i < len; i++)
    {
    	var obj = datainterface.rows[i];
    	
    	for(var j = 0, wLen = workTable.getDataRowLength(); j < wLen; j++)
    	{
    		if(workTable.getRowSelFlag(j))
    		{
	    		if(obj["WORKLINKFROM"].value == workTable.getCellStoreValue(j, "WORKLINKFROM", "WORKLINKFROM")
	    		   && obj["WORKLINKTO"].value == workTable.getCellStoreValue(j, "WORKLINKTO", "WORKLINKTO")
	    		   && obj["WORKLINKINTAG"].value == workTable.getCellStoreValue(j, "srcVlan", "srcVlan")
	    		   && obj["WORKLINKINSTAG"].value == workTable.getCellStoreValue(j, "srcSVlan", "srcSVlan"))
	    		{
	    			var swStatusShow; 
	    			var swStatus = obj["swStatus"].value;
	    			var curWorkLink = obj["curWorkLink"].value;
	    			var workLinkStatus = obj["workLinkStatus"].value;
	    			
	    			var swCell = workTable.getCell(j, "swStatus");
	    			
	    			var wLStatusCell = workTable.getCell(j, "workLinkStatus");
	    			
	    			var curWLCell = workTable.getCell(j, "curWorkLink");
	    			
	    			if(FORCESWITCHSTATUS == swStatus || MANUALSWITCHCMD == swStatus)
	    			{
	    			    swStatusShow = RESOURCE[swStatusObj[swStatus+curWorkLink]]
	    			    swStatus = swStatus+curWorkLink;
	    			}
	    			else
	    			{
	    				swStatusShow = RESOURCE[swStatusObj[swStatus]];
	    			}
	    			
	    			workTable.setAtomValue(swCell.element.showElement, swStatusShow);
	    			swCell.element.storeValue["swStatus"] = swStatus;
	    			swCell.element.currentValue["swStatus"] = swStatusShow;
	    			
	    			workTable.setAtomValue(wLStatusCell.element.showElement, RESOURCE[linkStatus[workLinkStatus]]);
	    			wLStatusCell.element.storeValue["workLinkStatus"] = workLinkStatus;
	    			wLStatusCell.element.currentValue["workLinkStatus"] = RESOURCE[linkStatus[workLinkStatus]];
	    			
	    			workTable.setAtomValue(curWLCell.element.showElement, RESOURCE[curWorkLinkObj[curWorkLink]]);
	    			curWLCell.element.storeValue["workLinkStatus"] = curWorkLink;
	    			curWLCell.element.currentValue["workLinkStatus"] = RESOURCE[curWorkLinkObj[curWorkLink]];
	    			
	    			break;
	    		}
	    	}
    	}
    	
    	for(var k = 0, pLen = protectTable.getDataRowLength(); k < pLen; k++)
    	{
    		if(protectTable.getRowSelFlag(k))
    		{
	    		if(obj["BACKUPLINKFROM"].value == protectTable.getCellStoreValue(k, "BACKUPLINKFROM", "BACKUPLINKFROM")
	    		   && obj["BACKUPLINKTO"].value == protectTable.getCellStoreValue(k, "BACKUPLINKTO", "BACKUPLINKTO")
	    		   && obj["BACKUPLINKINTAG"].value == protectTable.getCellStoreValue(k, "psrcVlan", "psrcVlan")
	    		   && obj["BACKUPLINKINSTAG"].value == protectTable.getCellStoreValue(k, "psrcSVlan", "psrcSVlan"))
	    		{
	    			var swStatusShow; 
	    			var swStatus = obj["swStatus"].value;
	    			var curWorkLink = obj["curWorkLink"].value;
	    			var protectLinkStatus = obj["protectLinkStatus"].value;
	    			
	    			var swCell = protectTable.getCell(k, "swStatus");
	    			
	    			var pLStatusCell = protectTable.getCell(k, "protectLinkStatus");
	    			
	    			var curWLCell = protectTable.getCell(k, "curWorkLink");
	    			
	    			if(FORCESWITCHSTATUS == swStatus || MANUALSWITCHCMD == swStatus)
	    			{
	    			    swStatusShow = RESOURCE[swStatusObj[swStatus+curWorkLink]]
	    			    swStatus = swStatus+curWorkLink;
	    			}
	    			else
	    			{
	    				swStatusShow = RESOURCE[swStatusObj[swStatus]];
	    			}
	    			
	    			protectTable.setAtomValue(swCell.element.showElement, swStatusShow);
	    			swCell.element.storeValue["swStatus"] = swStatus;
	    			swCell.element.currentValue["swStatus"] = swStatusShow;
	    			
	    			protectTable.setAtomValue(pLStatusCell.element.showElement, RESOURCE[linkStatus[protectLinkStatus]]);
	    			pLStatusCell.element.storeValue["workLinkStatus"] = protectLinkStatus;
	    			pLStatusCell.element.currentValue["workLinkStatus"] = RESOURCE[linkStatus[protectLinkStatus]];
	    			
	    			protectTable.setAtomValue(curWLCell.element.showElement, RESOURCE[curWorkLinkObj[curWorkLink]]);
	    			curWLCell.element.storeValue["workLinkStatus"] = curWorkLink;
	    			curWLCell.element.currentValue["workLinkStatus"] = RESOURCE[curWorkLinkObj[curWorkLink]];
	    			
	    			break;
	    		}
	    	}
    	}
    }
    
	var errCode = datainterface.getSErrorCode();
    if(errCode != 2)
    {

	     if(!workTable.element.colsArray.selectedId)
		    {
		  	   workTable.element.colsArray.selectedId = "vlansncpID";
		  	   workTable.element.colsArray.imgflag = 1;
		    }
		    var td=workTable.element.headRow.element.cols[workTable.element.colsArray.selectedId].element; 
		    workTable.sortRows(td,workTable.element.colsArray.imgflag);
	     if(!protectTable.element.colsArray.selectedId)
		    {
		  	   protectTable.element.colsArray.selectedId = "vlansncpID";
		  	   protectTable.element.colsArray.imgflag = 1;
		    }
		    var td=protectTable.element.headRow.element.cols[protectTable.element.colsArray.selectedId].element; 
		    protectTable.sortRows(td,protectTable.element.colsArray.imgflag);

    }
    
    $("functionMenus").disabled = false;
        
}

/*
 *          xml
 * swStatus     
 * 1 -     
 * 2 -     
 * 3 -     
 * 4 -     
 * workLink     link
 * 1 -  link
 * 2 -  link
 */
function createSwitchXml(swStatus, workLink, command)
{
	var isSwichWork = false;
	
	var isSwichProtect = false;
	
	var srcPort = null;
	var snkPort = null;
	var srcVlan = null;
	var srcSVlan = null;
	
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	
	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	{
		if(workTable.getRowSelFlag(i))
		{
			var wtrMode = workTable.getCellStoreValue(i, "hideWrtMode", "hideWrtMode");
			
			if(WRTMODE_VALUE_Y == wtrMode)
			{
				if((workLink == WORKPATH) && ( FORCESWITCHCMD == swStatus || MANUALSWITCHCMD == swStatus))
				{
					alert(RESOURCE["noswitchwork"]);
					$("functionMenus").disabled = false;
					return;
				}
		    }
		    
		    if((FORCESWITCHCMD == swStatus || MANUALSWITCHCMD == swStatus) && workLink == PROTECTPATH)
		    {
		    	isSwichProtect = true;
		    }
		    
		    else if((FORCESWITCHCMD == swStatus || MANUALSWITCHCMD == swStatus) && workLink == WORKPATH)
		    {
		    	isSwichWork = true;
		    }
            
            if (SWSTATUS_FRC_W_P == command || SWSTATUS_MAN_W_P == command)
            {
                srcPort = protectTable.getCellStoreValue(i, "psrcPort", "psrcPort");
                snkPort = protectTable.getCellStoreValue(i, "psnkPort", "psnkPort");
                srcVlan = protectTable.getCellStoreValue(i, "psrcVlan", "psrcVlan");
                srcSVlan = protectTable.getCellStoreValue(i, "psrcSVlan", "psrcSVlan");
            }
            else
            {
                srcPort = workTable.getCellStoreValue(i, "srcPort", "srcPort");
                snkPort = workTable.getCellStoreValue(i, "snkPort", "snkPort");
                srcVlan = workTable.getCellStoreValue(i, "srcVlan", "srcVlan");
                srcSVlan = workTable.getCellStoreValue(i, "srcSVlan", "srcSVlan");
            }
            
		    var row = new tagElement("row-params");
		    
		    var param = new tagElement("param");
		    param.setAttribute("name", "neID")
		    param.setAttribute("value", neID);
		    row.appendChild(param);
		    
		    param = new tagElement("param");
		    param.setAttribute("name", "slotid");
		    param.setAttribute("value", slotID);
		    row.appendChild(param);
		    
		    param = new tagElement("param");
		    param.setAttribute("name", "srcPort");
		    param.setAttribute("value", srcPort);
		    row.appendChild(param);
		    
		    param = new tagElement("param");
		    param.setAttribute("name", "snkPort");
		    param.setAttribute("value", snkPort);
		    row.appendChild(param);  
		    
		    if (srcVlan != "-" && srcVlan != "")
		    {
		        param = new tagElement("param");
    		    param.setAttribute("name", "LINKINTAG");
    		    param.setAttribute("value", srcVlan);
    		    row.appendChild(param);
		    }
		    
		    if (srcSVlan != "-" && srcSVlan != "")
		    {
		        param = new tagElement("param");
    		    param.setAttribute("name", "LINKINSTAG");
    		    param.setAttribute("value", srcSVlan);
    		    row.appendChild(param);
		    }
		    
		    param = new tagElement("param");
		    param.setAttribute("name", "SC");
		    param.setAttribute("value", swStatus);
		    row.appendChild(param);
    
		    
		    param = new tagElement("param");
		    param.setAttribute("name", "swStatus");
		    param.setAttribute("value", swStatus);
		    row.appendChild(param);
		    
		    param = new tagElement("param");
		    param.setAttribute("name", "curWorkLink");
		    param.setAttribute("value", workLink);
		    row.appendChild(param);
		    
		    bussiness.appendChild(row);
		}
	}
	
	if(isSwichProtect)
	{
    	if(!confirm(RESOURCE["isswitchprotect"]))
    	{
    		$("functionMenus").disabled = false;
    		return; 
    	}
	}
	
	if(isSwichWork)
	{
    	if(!confirm(RESOURCE["isswitchwork"]))
    	{
    		$("functionMenus").disabled = false;
    		return; 
    	}
	}
	
	root.getRoot().appendChild(bussiness);
	
	return root.toString();
	
}

/*
 *           
 */
function callbackSwitch(doc)
{
    var datainterface = EncapsulateData(doc);
    showErrorDialog(datainterface);

    if(OPRSUCC == datainterface.getSErrorCode())
    {
        alert(RESOURCE["queryswitchstatus2"]);
    }
    else if(OPR_PART_SUCCESS == datainterface.getSErrorCode()) 
    {
    	datainterface.errObj.s_error.info = datainterface.errObj.s_error.info + RESOURCE["queryswitchstatus1"];
    }

    errArr = null;
    
	$("functionMenus").disabled = false;
}

/*
 *     vlansncp       
 */
function doCreateSNCP()
{
	xshowModalDialog("vlansncpcreate.html", RESOURCE["createtitle"], 680, 480, "../../../../../../images/");
}


/*
 *      vlansncpID
 * return Array,
 * @param count, vlansncpID   
 */
function getVlanSNCPIDOfUse(count)
{
	var vlansncpIDs = getRangeNumber(sncpIDsOfUsed, MIN_VLAN_SNCP_ID, MAX_VLAN_SNCP_ID, count);
	
	sncpIDsOfUsed = sncpIDsOfUsed.concat(vlansncpIDs);
	return vlansncpIDs;
}

/*
 *      vlansncpID
 *                  
 *        vlansncp         sncpIDsOfUsed  
 *                   
 */
function getVlanSNCPIDOfUsed()
{
	sncpIDsOfUsed = [];

	for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	{
		var vlansncpID = workTable.getCellStoreValue(i, "vlansncpID", "vlansncpID");
		sncpIDsOfUsed.push(vlansncpID);
	}
}
/*
   :
         
*/
function showErrorDialog(data)
{
	var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}


/*
 *         
 */
function popupMenuHandler(evt)
{
	if (btnRightArr.cnvtnorbtn.right)
	{
		if(!evt){
	  	  evt= window.event;	
	  	}
	  	 
	    var elem = (evt.target) ? evt.target : evt.srcElement;   
	
	    if(elem!= null&&elem.blur)
	    {
	    	elem.blur();	  	
	    }
	   
	   while(elem!=null)
		 {
		    if(elem.tagName == 'TD')
		    {
		        break;	
		    }
		    else
		    {
			    elem =elem.parentNode;	  	
		    }	
	   } 
	  
		if(elem == null || elem.tagName != 'TD' || null == elem.parent)
		{
			  return;
		}  
		
		var rowid= elem.parentNode.rowIndex;
	    var rows =elem.parent.getSelectedRows();
	    
	    var colid = elem.colid;
	    if(rows.contains(rowid))
	    {
	    	for(var i = 0; i < rows.length; i++)
	    	{
	    		var tmpElem = elem.parent.getCellElement(rows[i],colid);
	    		if(null != tmpElem.editElement && tmpElem.isEdit == 1)
	    		{
	    			 createTablePopupMenu(tmpElem,evt);
	    			 return;
	    		}
	    	}
	    	if("swStatus" == colid)
	    	{
	    	    createSwitchPopupMenu(evt);
	    	    return;
	    	}
	    	if("wrtTime" != colid)
	    	{
	    	    createFuncPopupMenu(rows,evt);
	    	}
	    }  
	}  
}

/*
 *     "         
 */
function createSwitchPopupMenu(evt)
{
     createjsDOMenu("functionMenus");
     showMenu(evt); 	
}

/*
 *           
 */
function createFuncPopupMenu(rows, evt)
{
     
     removejsDOMmenu();
     
	  var isOAMEN = false;
	  var isOAMDIS = false;
	
	  for(var i = 0, len = workTable.getDataRowLength(); i < len; i++)
	  {
	      if(workTable.getRowSelFlag(i))
	      {
	    	  var oamEN = workTable.getCellStoreValue(i, "oamEN", "oamEN");
	    	  if( "1" == oamEN )
	    	  {
	    		  isOAMEN = true;
	    	  }
	    	  if( "0" == oamEN )
	    	  {
	    		  isOAMDIS = true;
	    	  }
	      }	
	 }
     var cursorMenu1 = new jsDOMenu(200); 
     cursorMenu1.addMenuItem(new menuItem(RESOURCE["cnvtnorbutton"],"",doConvertNormal));      	
     setPopUpMenu(cursorMenu1);
     showMenu(evt);  	
}

/*
 *          
 */
function cellEditHandler(param)
{
	if ((param.colid == "wrtTime") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
	{
		var textview = workTable.getCellEdit(param.rowindex, param.colid).element;
		
		tenCellEvent(textview,":");
		textview.style.imeMode = "disabled";
		textview.maxLength = 5;
		
		textview.onblur = function()
	    {
	    	var textvar = this.value;
			var finalvar = textvar;
			var STARTVAR = "00:06";
			var STARTTIME = 6;
			var ERRORSTR ="of 00:06 to 12:00";

			var conflag = false;
			if ((textvar == "") || (textvar.length != 5) || (textvar.indexOf(":") == -1))
			{
				finalvar = STARTVAR;//"00-03";
				conflag = true;
				alert(RESOURCE["errSignalTimer"]+ERRORSTR);
				this.value = STARTVAR;//"00-03";
			}

			
			var temparr = textvar.split(":");
			var hourvar = parseInt(temparr[0],10);
			var minutes = parseInt(temparr[1],10);
			
			var timevar = (hourvar * 60)+minutes;
			if (conflag == false)
			{
				if (timevar < STARTTIME || timevar > 720 || minutes > 59)
				{
					
					alert(RESOURCE["errWtrTimeIP"]+ERRORSTR);
					textview.value = STARTVAR;//"00-03";
				}
			}
			
		    for(var i = 0, len = protectTable.getDataRowLength(); i < len; i++)		    
		    {
		    	if(protectTable.getRowSelFlag(i) && WRTMODE_VALUE_Y == protectTable.getCellStoreValue(i, "wrtMode", "wrtMode"))
		    	{
		    		var wrtTimeShowAtom = protectTable.getCellShow(i, "wrtTime");
		    		protectTable.setAtomValue(wrtTimeShowAtom, this.value);
		    	}
		    }
			
			cellonblur(this);
	    }
	}
	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neID,true);
   $("applybtn").disabled = false||!btnRightArr.applybtn.right;
}

/*
 *      linkID
 *       vlansncp       
 */
function getLinkIDsOfUsed()
{
    
    linkIDsOfUsed = [];
	for(var i = 0, len = evplWin.st.getDataRowLength(); i < len; i++)
	{
		var direction = evplWin.st.getCellStoreValue(i, "direction", "direction");
		var linkId;
		
		if(DIRECTION_BI == direction)
		{
			linkId = evplWin.st.getCellStoreValue(i, "downLinkID", "downLinkID");
			linkIDsOfUsed.push(linkId);
		}
		
		linkId = evplWin.st.getCellStoreValue(i, "upLinkID", "upLinkID");
		
		linkIDsOfUsed.push(linkId);
		
	}	
}

/*
 *      linkID
 * @param count - linkID   
 */
function getLinkIDsOfUse(count)
{
	var linkIDs = getRangeNumber(linkIDsOfUsed, MIN_VALUE_LINK, MAX_VALUE_LINK, count);
	linkIDsOfUsed = linkIDsOfUsed.concat(linkIDs);
	return linkIDs;
}

function setCellEditDisable(st, rowId, colId)
{
    var cell = st.getCell(rowId, colId);
    st.setCellIsEdit(cell,0);
} 
