 /**
 * VLAN       js  
 *       
 *   : c00104334
 *   : 2008-08-28
 */

var MAX_VALUE_LINK = 0xfffe;//   linkID 4095
var MIN_VALUE_LINK = 1;//   linkID 0

var ct = null;
var portAttrTable = null;////        
var direction = null;//       
var serviceType = null;//    
var operationType = null;//    
var linkID = null;//     LinkID
var srcVlan = null;//      vlan
var srcSVlan = null;
var snkVlan = null;//      vlan
var snkSVlan = null;
var snkPort = null;//        
linkIDsOfUsed = [];//    linkID  

var isChangePortAttr = false;

var win = getParentWindow();
var winurlobj = getNeProperty(win.parent); 

var nmUser = winurlobj["nmUser"];//  
    
var sncpWin = getSNCPMainPage(win);

var UNI = "UNI";
var CAWARE = "CAWARE";
var SAWARE = "SAWARE";

var EPL_SERVICE = "EPL";
var VCTRUNK_NUMBER = 0x8000;
/*
 *       
 */
function initConvertButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

/*
 *        
 */
function initPortAttr()
{
    portAttrTable = new SortTable();
    portAttrTable.setImage("../../../../../../images/");
    createTableHead(portAttrTable, window.tableconf[0]);
    portAttrTable.setBodyHeight(100);
    $("portAttr").appendChild(portAttrTable.getTable());
}

/*
 *              
 */
function initPortTblInfo()
{    
    $("portTableName").innerHTML = RESOURCE["portTblName"];
}

/*
 *       
 */
function initConvertPage()
{       
    getSupportPorts(winurlobj.neid, winurlobj.slotid);
    getLinkIDsOfUsed();
    
    initConvertTable();
    initPortAttr();
    initPortTblInfo();
    initConvertButton();
    
    refreshPortTable();
}

/*
 *         
 */
function refreshPortTable()
{
    portAttrTable.clearTableData();
    
    
    var srcPortElement = ct.getAtom("srcPort").element;
    var srcport = srcPortElement.options[srcPortElement.selectedIndex].value;
    
    var ports = new Object();
    ports[srcPortsOfUse[srcport].portno] = srcPortsOfUse[srcport];   
    
    var portData = createPortData(ports);    
    createTableBody(portAttrTable, window.tableconf[0], portData, RESOURCE);

    var portTypeFlag = portAttrTable.getCellStoreValue(0, "portTypeFlag", "portTypeFlag");
    portEnableCell = portAttrTable.getCell(0, "portDisabled");
    if (portTypeFlag == "1")
    {
        portEnableCell.element.modify = false;
        portAttrTable.setCellIsEdit(portEnableCell, 0);
        portEnableCell.element.ondblclick = null;
        portEnableCell.element.style.cursor = "";
        portEnableCell.element.style.backgroundColor = "";
        portAttrTable.setAtomValue(portEnableCell.element.showElement, "-");
    }
    
    var tagTypeCell = portAttrTable.getCell(0, "tagIdentifier");
    if (EPL_SERVICE != serviceType)
    { 
        tagTypeCell.element.modify = false;
        portAttrTable.setCellIsEdit(tagTypeCell, 0);
        tagTypeCell.element.style.cursor = "";
        tagTypeCell.element.style.background = "#C8C8C8";
        tagTypeCell.element.ondblclick = null;
        portAttrTable.setAtomValue(tagTypeCell.element.showElement, "-");
    }
    
    if(!portAttrTable.element.colsArray.selectedId)
    {
        portAttrTable.element.colsArray.selectedId = "port";
        portAttrTable.element.colsArray.imgflag = 1;
    }
    var td=portAttrTable.element.headRow.element.cols[portAttrTable.element.colsArray.selectedId].element; 
    portAttrTable.sortRows(td,portAttrTable.element.colsArray.imgflag);
    
    setStatus(false);
}

/*
 *               datainterface
 * @param ports Object   portno   TEPort  
 * @return Datainterface
 */
function createPortData(ports)
{
    var datainterface = new DataInterface();
    for(var key in ports)
    {
        queryPortAttr(ports[key]);
        var obj = new Object();
        var ptag1 = new ParamTag();
        
        ptag1.value = ports[key].portName;      
        obj["port"] = ptag1;
        
        var ptag5 = new ParamTag();
        ptag5.value = ports[key].portno;
        obj["portno"] = ptag5;
        
        var ptag6 = new ParamTag();
        ptag6.value = ports[key].portTypeFlag;
        obj["portTypeFlag"] = ptag6;
        
        var ptag2 = new ParamTag();
        if(EPL_SERVICE == serviceType)
        {
            ptag2.value = UNI;
        }
        else if(OPERATION_ADD_SVAN_VALUE == operationType)
        {
            ptag2.value = CAWARE;
        }
        else
        {
            ptag2.value = SAWARE;
        }
        obj["portType"] = ptag2;

        var ptag3 = new ParamTag();
        ptag3.value = ports[key].portEnable;
        obj["portDisabled"] = ptag3;
        
        var ptag4 = new ParamTag();
        ptag4.value = ports[key].portTag;       
        if(EPL_SERVICE == serviceType)
        {
            ptag4.value = ports[key].portTag;
        }
        else
        {
            ptag4.value = "";
        }
        obj["tagIdentifier"] = ptag4;
                        
        datainterface.rows[datainterface.rows.length] = obj; 
    }
    
    return datainterface;
}

/*
         
 */
function queryPortAtrrXml(port)
{
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row=new tagElement("row-params");

    var param=new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj.neid);
    row.appendChild(param);

    var param=new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",winurlobj.slotid);
    row.appendChild(param);
    
    var param=new tagElement("param");
    param.setAttribute("name","portid");
    param.setAttribute("value",port.portno);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}

/*
 *            
 */
function callbackQueryPortAttr(doc, port)
{
    var portAttrData = EncapsulateData(doc);
	var boardName = portAttrData.getDataRowParam(0, "shelfName") + "-"
	+ portData.getDataRowParam(0, "boardName");
	ct.getAtom("board").setValue(boardName);
    showErrorDialog(portAttrData);
    if (0 == portAttrData.getSErrorCode() && 0 < portAttrData.getDataRowLength()) 
    {    
          if ( 0 == port.portTypeFlag )
          {
              port.portType = portAttrData.getDataRowParam(0,"PORTTYPE");
              port.portEnable = portAttrData.getDataRowParam(0,"PORTENABLE"); 
              port.portTag = portAttrData.getDataRowParam(0,"TAGTYPE");         
          }    
          else
          {
              port.portType = portAttrData.getDataRowParam(0,"PORTTYPE"); 
              
              port.portTag = portAttrData.getDataRowParam(0,"TAGTYPE");         
          }
     }
}

/*
 *       
 */
function queryPortAttr(port)
{
    var xmlData = queryPortAtrrXml(port);

    var URL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&nmUser="+nmUser; 
    loadXMLdoc(URL,"POST",false,callbackQueryPortAttr,port,"inputdata="+xmlData);
}

/*
 *       SNCP     
 *    ID   ID,              
 *   VLANID      VLANID      opener     
 */
function initConvertTable()
{
    getLinkInfo();
    
    ct = new CTable();
    ct.addHead(RESOURCE["ID00_ATTRIBUTE"],RESOURCE["ID00_VALUE"]);
    
    var atom = new Atom("span");
    
    
    ct.addAttrRow("board", RESOURCE["boardName"], atom);
    
    atom = new Atom("span");
    if (EPL_SERVICE == serviceType)
    {    
        atom.setValue("EPL");
    }
    else
    {
          atom.setValue("EVPL(QinQ)");
          window.dialogHeight="520px";
    }
    ct.addAttrRow("serviceType", RESOURCE["linkType"], atom);
    
    atom = new Atom("span");    
    if(DIRECTION_BI == direction)
    {    
        atom.setValue(RESOURCE["bidirectional"]);
    }
    else if(DIRECTION_UNI == direction)
    {
        atom.setValue(RESOURCE["sidirectional"]);
    }
    ct.addAttrRow("serviceDirection", RESOURCE["linkdirection"], atom);
    
    if(EPL_SERVICE != serviceType)
    {
        atom = new Atom("span");
        atom.setValue(operTypeConvert[operationType]);
        ct.addAttrRow("operationType", RESOURCE["operationType"], atom);
    }        
     
    atom = new Atom("select");
     for(var i = 0, len1 = srcPortsOfUse.length; i < len1; i++)
    {
        atom.addOption(srcPortsOfUse[i].portName, i);
    }
    ct.addAttrRow("srcPort", RESOURCE["srcport"], atom);
    atom.element.onchange = refreshPortTable;
    
        
    atom = new Atom("span");
    if("65535" == srcVlan)
    {
        atom.setValue("-");
    }
    else
    {
        atom.setValue(srcVlan);
    }
 
    ct.addAttrRow("sourceVlan", RESOURCE["srccvlan"], atom);
    
    if(EPL_SERVICE != serviceType)
    {
        atom = new Atom("span"); 
      if("65535" == srcSVlan)
      {
        atom.setValue("-");
      }
      else
      {
          atom.setValue(srcSVlan);
      }
      
      ct.addAttrRow("srcSVlan", RESOURCE["sourceS-VLAN"], atom);
    }     
    
    atom = new Atom("span");
    if (VCTRUNK_NUMBER > snkPort)
    {
    	 atom.setValue("PORT" + snkPort);
    }
    else
    {
    	 atom.setValue("VCTRUNK" + (snkPort - VCTRUNK_NUMBER));
    }
    ct.addAttrRow("sinkPort", RESOURCE["snkport"], atom);
    
    atom = new Atom("span");
    
    if("65535" == snkVlan)
    {
        atom.setValue("-");
    }
    else
    {
        atom.setValue(snkVlan);
    }
    ct.addAttrRow("sinkVlan", RESOURCE["snkcvlan"], atom);
    
    if(EPL_SERVICE != serviceType)
    {
        atom = new Atom("span"); 
      if("65535" == snkSVlan)
      {
        atom.setValue("-");
      }
      else
      {
          atom.setValue(snkSVlan);
      }
      
      ct.addAttrRow("snkSVlan", RESOURCE["snkS-VLAN"], atom);
    }     
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
}

/*
 *      SNCP          
 */
function setStatus(state)
{
    $("okbtn").disabled = state;
    $("applybtn").disabled = state;
}

/*
 *         SNCP    
 *              onclick  
 */
function doConvertSNCP(btnFlag)
{
    if (btnFlag && $("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }
    
    var srcPortElement = ct.getAtom("srcPort").element;
    var srcPort = srcPortElement.options[srcPortElement.selectedIndex].value;
    srcPort = srcPortsOfUse[srcPort].portName;
    
    if(snkPort == srcPort)
    {
        alert(RESOURCE["protectsrcsnkport"]);
        return;
    }
    
    setStatus(true);
    
    var portArrXml = createPortArrXmlInfo();
    var portArrURL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_SET_ETHPORTATTRIB+"&nmUser="+nmUser;
    
    loadXMLdoc(portArrURL, "POST", false, callbackSetPortArr, btnFlag, "inputdata="+portArrXml);           
}

/*
 *        vlansncp  
 */
function convertVLANSNCP(btnFlag)
{
    var xmlData = createSNCPCntXmlInfo();    
    var createURL = "../../../../../../tl1NEExlorerServlet?sfid="+TE_IP_NORMALSNCP_CONVERT+"&nmUser="+nmUser;
    
    loadXMLdoc(createURL, "POST", true, callbackConvert, btnFlag, "inputdata="+xmlData);    
}

/*
 *            xml
 */
function createPortArrXmlInfo()
{    
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
    {
            isChangePortAttr = true;
            var row = new tagElement("row-params");
            
            var param = new tagElement("param");
            param.setAttribute("name", "neID");
            param.setAttribute("value", winurlobj.neid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "slotid");
            param.setAttribute("value", winurlobj.slotid);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "portid");
            var portno = portAttrTable.getCellStoreValue(i, "portno", "portno");
            param.setAttribute("value", portno);
            row.appendChild(param);
            
            var portTypeFlag = portAttrTable.getCellStoreValue(i, "portTypeFlag", "portTypeFlag");
            if("0" == portTypeFlag)
            {
                param = new tagElement("param");
                param.setAttribute("name", "PORTTYPE")
                param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portType", "portType"));
                param.setAttribute("modifyFlag", "true");
                row.appendChild(param);
                
                var portEnable = portAttrTable.getCellStoreValue(i, "portDisabled", "portDisabled");
                if (portEnable != "undefined" && portEnable != "-")
                {
                	param = new tagElement("param");
	                param.setAttribute("name", "PORTENABLE");
	                param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portDisabled", "portDisabled"));	                
	                row.appendChild(param);
                }
                
                var tagIden = portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier");
                if (tagIden != undefined && tagIden != "-")
                {
	                param = new tagElement("param");
	                param.setAttribute("name", "TAGTYPE");
	                param.setAttribute("value", portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier"));	               
	                row.appendChild(param);
                }
            }
            else
            {
                param = new tagElement("param");
                param.setAttribute("name", "PORTTYPE");
                param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portType", "portType"));                
                param.setAttribute("modifyFlag", "true");
                row.appendChild(param);
                
                var tagIden = portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier");
                if (tagIden != undefined && tagIden != "-")
                {
	                param = new tagElement("param");
	                param.setAttribute("name", "TAGTYPE");
	                param.setAttribute("value", portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier"));              
	                row.appendChild(param);
                }
            }
            
            business.appendChild(row);
            
    }
    
    root.getRoot().appendChild(business);
    return root.toString();
}

/*
 *            
 */
function callbackSetPortArr(doc, btnFlag)
{   
    var datainterface = EncapsulateData(doc);
    
    if(0 != datainterface.getSErrorCode())
    {
        showErrorDialog(datainterface);
        setStatus(false);
        return;
    }
    createEthlink(btnFlag);
}

function createEthlink(btnFlag)
{
    var xmlData = createEthlinkXML();
    var createURL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_EVPL_CREATE+"&nmUser="+nmUser;

    loadXMLdoc(createURL, "POST", true, createEthlinkBack, btnFlag, "inputdata="+xmlData); 
}
/*
 *     
 */
function createEthlinkBack(doc, btnFlag)
{
    var isSetArr = false;
    
    var data = EncapsulateData(doc);
    if(data.getSErrorCode() == 0)
    {
        convertVLANSNCP(btnFlag);
    }
    else
    {
        setStatus(false);
        showErrorDialog(data);
    }
}
/*
 *       SNCP xml   
 */
function createEthlinkXML()
{       
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neID");
    param.setAttribute("value", winurlobj.neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj.slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "direction");
    param.setAttribute("value", direction);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "srcPort");
    var srcPortElement = ct.getAtom("srcPort").element;
    var srcPort = srcPortElement.options[srcPortElement.selectedIndex].value;
    srcPort = srcPortsOfUse[srcPort].portno
    param.setAttribute("value", srcPort);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "snkPort");
    param.setAttribute("value", getPortNo(snkPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "srcCVlan");//   snkCVlan
    param.setAttribute("value", srcVlan);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "snkCVlan");//   snkCVlan
    param.setAttribute("value", snkVlan);
    row.appendChild(param);
    
    if (EPL_SERVICE != serviceType)
    {
        param = new tagElement("param");
        param.setAttribute("name", "srcSVlan");
        param.setAttribute("value", srcSVlan);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "snkSVlan");
        param.setAttribute("value", snkSVlan);
        row.appendChild(param);
    }
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/*
 *           xml   
 */
function createSNCPCntXmlInfo()
{
    var slctRows = win.st.getSelectedRows();
    var workSrcPort = win.st.getCellStoreValue(slctRows[0], "srcPort", "srcPort");
    var workSnkPort = win.st.getCellStoreValue(slctRows[0], "snkPort", "snkPort");
    
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neID");
    param.setAttribute("value", winurlobj.neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj.slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "direction");
    param.setAttribute("value", direction);
    row.appendChild(param);   

    param = new tagElement("param");
    param.setAttribute("name", "workSrcPort");
    param.setAttribute("value", workSrcPort);
    row.appendChild(param);  
    
    param = new tagElement("param");
    param.setAttribute("name", "protectSrcPort");
    var srcPortElement = ct.getAtom("srcPort").element;
    var srcPort = srcPortElement.options[srcPortElement.selectedIndex].value;
    srcPort = srcPortsOfUse[srcPort].portno
    param.setAttribute("value", srcPort);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "workSrcVlan");
    param.setAttribute("value", srcVlan);
    row.appendChild(param);  
    
    param = new tagElement("param");
    param.setAttribute("name", "protectSrcVlan");
    param.setAttribute("value", srcVlan);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "workSnkPort");
    param.setAttribute("value", workSnkPort);
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name", "protectSnkPort");
    param.setAttribute("value", getPortNo(snkPort));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "workSnkVlan");
    param.setAttribute("value", snkVlan);
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name", "protectSnkVlan");
    param.setAttribute("value", snkVlan);
    row.appendChild(param);
    
    if (EPL_SERVICE != serviceType)
    {
        param = new tagElement("param");
      param.setAttribute("name", "srcSVlan");
      param.setAttribute("value", srcSVlan);
      row.appendChild(param);
        
      param = new tagElement("param");
      param.setAttribute("name", "snkSVlan");
      param.setAttribute("value", snkSVlan);
      row.appendChild(param);
    }
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/*
 *         SNCP          
 *                    evplmain.html         
 */
/*
 *   VLAN SNCP         
 */
function callbackConvert(doc, btnFlag)
{
    
    var datainterface = EncapsulateData(doc);
    showErrorDialog(datainterface);
    
    win.doQuery(true);
    if( 0 == datainterface.getSErrorCode())
    {
    }
    
    setStatus(false);
    if(0 != datainterface.getSErrorCode())
    {
        setStatus(false);
    }
    else
    {
        setStatus(true);
        $("okbtn").disabled = false;
        if (btnFlag)
        {
            xcloseDialog();
            return;
        }
    }        
    return;
}

/*
   :
         
*/
function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    if (isIE)
    {
        openErrPage("../../../../../../page/", data.getError(), errArr);//????????
    }
    else
    {
        openErrPage("../../../../../../page/", data.getError(), errArr);//????????
    }
}

/*
 *     vlansncp           vlanID 
 *          
 */
function getLinkInfo()
{
    for(var i = 0, len = win.st.getDataRowLength(); i < len; i++)
    {
        if(win.st.getRowSelFlag(i))
        {
            direction = win.st.getCellStoreValue(i, "direction", "direction");
            
            serviceType = win.st.getCellStoreValue(i, "linkType", "linkType");
            
            operationType = win.st.getCellStoreValue(i, "operationType", "operationType");
            
            linkID = win.st.getCellStoreValue(i, "upLinkID", "upLinkID");
            
            srcVlan = win.st.getCellStoreValue(i, "srcVlan", "srcVlan");
            
            snkVlan = win.st.getCellStoreValue(i, "snkVlan", "snkVlan");
            
            snkPort = win.st.getCellStoreValue(i, "snkPort", "snkPort");
            
            if (EPL_SERVICE != serviceType)
            {
                 srcSVlan = win.st.getCellStoreValue(i, "srcSVlan", "srcSVlan");
                 snkSVlan = win.st.getCellStoreValue(i, "snkSVlan", "snkSVlan");
            }
            
            break;
        }
    }
}

/*
 *      linkID
 * @param count - linkID   
 */
function getLinkIDsOfUse(count)
{
    var linkIDs = getRangeNumber(linkIDsOfUsed, MIN_VALUE_LINK, MAX_VALUE_LINK, count);
    linkIDsOfUsed = linkIDsOfUsed.concat(linkIDs);
    return linkIDs;
}

/*
 *      linkID
 *       vlansncp       
 */
function getLinkIDsOfUsed()
{
    linkIDsOfUsed = [];
    for(var i = 0, len = win.st.getDataRowLength(); i < len; i++)
    {
        var direction = win.st.getCellStoreValue(i, "direction", "direction");
        var linkId;
        
        if(DIRECTION_BI == direction)
        {
            linkId = win.st.getCellStoreValue(i, "downLinkID", "downLinkID");
            linkIDsOfUsed.push(linkId);
        }
        
        linkId = win.st.getCellStoreValue(i, "upLinkID", "upLinkID");
        
        linkIDsOfUsed.push(linkId);
        
    }   
}
