 //      

var MAX_VALUE_LINK = 0xfffe;//   linkID 4095
var MIN_VALUE_LINK = 1;//   linkID 0

var ct;
var portAttrTable;

var direction;

var serviceType

var linkID;

var srcVlan;

var srcSVlan;

var snkVlan;

var snkSVlan;

var snkPort;

linkIDsOfUsed = [];

var PortType = new Object();
PortType["0"] = "PE";
PortType["1"] = "P";
PortType["2"] = "UNI";
PortType["3"] = "N-UNI";
PortType["4"] = "NNI";
PortType["5"] = "C-Aware";
PortType["6"] = "S-Aware";
PortType["255"] = "-";

var PortDisabled = new Object();
PortDisabled["N"] = RESOURCE["disabled"];
PortDisabled["Y"] = RESOURCE["enabled"];
PortDisabled["255"] = "-";

var TagIdentifier = new Object();
TagIdentifier["ACCESS"] = "Access";
TagIdentifier["1"] = "Tag Aware";
TagIdentifier["2"] = "Hybrid";
TagIdentifier["3"] = "No Tag Aware";

TagIdentifier["255"] = "-";

var isChangePortAttr = false;

var win = getParentWindow();
 
var nmUser = win["nmUser"];

var sncpWin = getSNCPMainPage(win);

var UNI = 2;
var CAWARE = 5;
var SAWARE = 6;

var EPL_SERVICE = "EPL";
var ADD_SERVICE = 6;
var STRIP_SERVICE = 8;
var TRANSLAT_SERVICE = 10;
var VCTRUNK_NUMBER = 0x8000;
/*
 *       
 */
function initConvertButton()
{
    document.getElementById("okbtn").value = RESOURCE["okbutton"];
    document.getElementById("cancelbtn").value = RESOURCE["cancelbutton"];
    document.getElementById("applybtn").value = RESOURCE["applybutton"];
}

/*
 *        
 */
function initPortAttr()
{
    portAttrTable = new SortTable();
    portAttrTable.setImage("../../../../../../images/");
    createTableHead(portAttrTable, window.tableconf[0]);
    portAttrTable.setBodyHeight(100);
    document.getElementById("portAttr").appendChild(portAttrTable.getTable());
}

/*
 *              
 */
function initPortTblInfo()
{    
    document.getElementById("portTableName").innerHTML = RESOURCE["portTblName"];
}

/*
 *       
 */
function initConvertPage()
{       
    
    getSupportPorts(win.neID, win.slotID);
    getLinkIDsOfUsed();
    
    initConvertTable();
    initPortAttr();
    initPortTblInfo();
    initConvertButton();
    
    refreshPortTable();
}

/*
 *         
 */
function refreshPortTable()
{
	portAttrTable.clearTableData();
	
    
    var srcPortElement = ct.getAtom("srcPort").element;
    var srcport = srcPortElement.options[srcPortElement.selectedIndex].value;
    
    var ports = new Object();
    ports[srcPortsOfUse[srcport].portno] = srcPortsOfUse[srcport];   
    
    var portData = createPortData(ports);    
    createGenCfgTableBody(portAttrTable, window.tableconf[0], portData);  
 
	  if (EPL_SERVICE != serviceType)
    { 
    	portAttrTable.setCellIsEdit(portAttrTable.getCell(0,"tagIdentifier"),0); 
    }
    
    if(!portAttrTable.element.colsArray.selectedId)
	  {
	  	 portAttrTable.element.colsArray.selectedId = "port";
	  	 portAttrTable.element.colsArray.imgflag = 1;
	  }
	  var td=portAttrTable.element.headRow.element.cols[portAttrTable.element.colsArray.selectedId].element; 
	  portAttrTable.sortRows(td,portAttrTable.element.colsArray.imgflag);
}

/*
* Create sort table body
* st SortTable Object
* tc TableConf Object
* di DataInterface Object
* res RESOUCE object
*/
function createTableST(st, tc, di, res)
{
	  for(var i = 0; i < di.getDataRowLength(); i++)
    {
        var row = st.createRow();
        for(var j = 0; j < tc.getColsLength(); j++)
        {            
            var cell = st.createCell(tc.getColWidth(j));
            cell.colid=tc.getColId(j);
            st.setCellIsEdit(cell, tc.getIsEdit(j));
            var atom = st.createAtom(tc.getColShowType(j))
            var options = tc.getColShowOptions(j);
            if(null != options && "" != options)
            {
                for(var k = 0; k < options.length; k++)
                {
                    atom.addOption(options[k].getName(), options[k].getValue());
                }
                atom.element.disabled = true;
            } 
            var showvalue = "";
            if(tc.getColKeyArray(j).length > 0)
            {   
                for(var k = 0; k <tc.getColKeyArray(j).length; k++)
                {
                    if(di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()))
                    {
                        st.setCellValue(cell, tc.getColKeyArray(j)[k].getName(), di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()));
                        if(tc.getColKeyArray(j)[k].getConvert())
                        {
                            showvalue += convertMsg(res, eval(tc.getColKeyArray(j)[k].getConvert()), 
                                                        di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()))+"-";
                        }
                        else
                        {
                            showvalue += di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()) + "-";
                        }   
                    }
                }
            }
            
            if(showvalue && showvalue.length > 0)
            {
                atom.setValue(showvalue.substring(0, showvalue.length-1));
            }
            else
            {
                atom.setValue("-");
            }
            var cellID = tc.getColId(j);
            if("portDisabled" == cellID && "-" == atom.getValue())
            {
                st.setCellIsEdit(cell, 0);    
            }
            st.addCellShow(cell, atom);
            
            if(tc.getIsEdit(j) == 1)
            {
                var ops = di.getDataRowOptions(i, tc.getColKeyArray(j)[0].getName());
                var atom = st.createAtom(tc.getColEditType(j));
                var options = tc.getColEditOptions(j)
                if(options.length > 0)
                {
                    for(var k = 0; k < options.length; k++)
                    {
                        atom.addOption(options[k].getName(), options[k].getValue());
                    }
                }  
                else if(ops)
                {
                    var convert = tc.getColKeyArray(j)[0].getConvert(); 
                    if(convert)
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            var conv = eval(convert);
                            atom.addOption(convertMsg(res, conv, ops[k]), ops[k]); 
                        }
                    }
                    else
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(ops[k], ops[k]); 
                        }
                    }   
                }
                st.addCellEdit(cell, atom);                    
            }
            else if(tc.hasEditElement(j))
            {
                var convert = tc.getColKeyArray(j)[0].getConvert();                 
                var atom = st.createAtom(tc.getColEditType(j));
                var ops = di.getDataRowOptions(i, tc.getColKeyArray(j)[0].getName()); 
                if(ops)
                {
                    if(convert)
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(convertMsg(res, eval(convert), ops[k]), ops[k]); 
                        }
                    }
                    else
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(ops[k], ops[k]); 
                        }
                    }   
                }
                st.addCellEdit(cell, atom);     
            }

            st.addCell(row, tc.getColId(j), cell);
            var cellwidth = tc.getColWidth(j);
            if(cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%")
            {
                cell.element.style.display = "none";    
            }
        }
        st.addRow(row)
    }
}

/*
 *               datainterface
 * @param ports Object   portno   TEPort  
 * @return Datainterface
 */
function createPortData(ports)
{
    var datainterface = new DataInterface();
    for(var key in ports)
    {
    	
    	queryPortAttr(ports[key]);
    	
    	var obj = new Object();
    	var ptag1 = new ParamTag();
    	
    	ptag1.value = ports[key].portName;    	
    	obj["port"] = ptag1;
    	
    	var ptag5 = new ParamTag();
    	ptag5.value = ports[key].portno;
    	obj["portno"] = ptag5;
    	
    	var ptag6 = new ParamTag();
    	ptag6.value = ports[key].portTypeFlag;
    	obj["portTypeFlag"] = ptag6;
    	
    	var ptag2 = new ParamTag();
    	if(EPL_SERVICE == serviceType)
    	{
    		ptag2.value = UNI;
    	}
    	else if(ADD_SERVICE == serviceType)
    	{
    		ptag2.value = CAWARE;
    	}
    	else
    	{
    		ptag2.value = SAWARE;
    	}
    	obj["portType"] = ptag2;

    	var ptag3 = new ParamTag();
    	ptag3.value = ports[key].portEnable;
    	obj["portDisabled"] = ptag3;
    	
    	var ptag4 = new ParamTag();
    	ptag4.value = ports[key].portTag;    	
    	if(EPL_SERVICE == serviceType)
    	{
    		ptag4.value = ports[key].portTag;
    	}
    	else
    	{
    		ptag4.value = "";
    	}
    	obj["tagIdentifier"] = ptag4;
    	    	    	
    	datainterface.rows[datainterface.rows.length] = obj; 
    }
    
    return datainterface;
}

/*
         
 */
function queryPortAtrrXml(port)
{
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row=new tagElement("row-params");

    var param=new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",win.neID);
    row.appendChild(param);

    param=new tagElement("param");
    param.setAttribute("name","AID");
    param.setAttribute("value", "FAC" + "-" + win.slotID + "-" + port.portno);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}

/*
 *            
 */
function callbackQueryPortAttr(doc, port)
{
    var portAttrData = EncapsulateData(doc);
    showErrorDialog(portAttrData);
	var boardName = portAttrData.getDataRowParam(0, "shelfName") + "-"
	+ portData.getDataRowParam(0, "boardName");
	ct.getAtom("board").setValue(boardName);
    if (0 == portAttrData.getError().getGlobleECode()
        && null != portAttrData 
        && 0 < portAttrData.getDataRowLength()) 
    {    
        
	      if ( "0" == port.portTypeFlag )
	      {
	          port.portType = portAttrData.getDataRowParam(0,"PORTTYPE");
	          port.portEnable = portAttrData.getDataRowParam(0,"PORTENABLE"); 
	          port.portTag = portAttrData.getDataRowParam(0,"TAGTYPE");         
	      }    
	      else
	      {
	          port.portType = portAttrData.getDataRowParam(0,"PORTTYPE"); 
	          port.portTag = portAttrData.getDataRowParam(0,"TAGTYPE");         
	      }
	 }
}

/*
 *       
 */
function queryPortAttr(port)
{
    var xmlData = queryPortAtrrXml(port);
    var URL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&nmUser="+win["nmUser"]; 
    loadXMLdoc(URL,"POST",false,callbackQueryPortAttr,port,"inputdata="+xmlData);
}

/*
 *       SNCP     
 *    ID   ID,              
 *   VLANID      VLANID      opener     
 */
function initConvertTable()
{
    getLinkInfo();
    
    ct = new CTable();
    ct.addHead(RESOURCE["ID00_ATTRIBUTE"],RESOURCE["ID00_VALUE"]);
    
    var atom = new Atom("span");
    atom.setValue( win.slotID + "-" + portData.getDataRowParam(0,"boardName"));
    ct.addAttrRow("board", RESOURCE["boardName"], atom);
    
    atom = new Atom("span");
    if (EPL_SERVICE == serviceType)
    {    
        atom.setValue("EPL");
    }
    else
    {
    	  atom.setValue("EVPL(QinQ)");
    	  window.dialogHeight="520px";
    }
    ct.addAttrRow("serviceType", RESOURCE["linkType"], atom);
    
    atom = new Atom("span");    
    if(DIRECTION_BI == direction)
    {    
        atom.setValue(RESOURCE["bidirectional"]);
    }
    else if(DIRECTION_UNI == direction)
    {
    	atom.setValue(RESOURCE["sidirectional"]);
    }
    ct.addAttrRow("serviceDirection", RESOURCE["linkdirection"], atom);
    
    if(EPL_SERVICE != serviceType)
    {
    	atom = new Atom("span"); 
      if(ADD_SERVICE == serviceType)
      {    
          atom.setValue("Add S-VLAN");
      }
      else if(STRIP_SERVICE == serviceType)
      {
      	atom.setValue("Strip S-VLAN");
      }
      else if(TRANSLAT_SERVICE == serviceType)
      {
      	if(srcSVlan == snkSVlan)
      	{
      		atom.setValue("Transparently transmit S-VLAN");
      	}
      	else
      	{
      		atom.setValue("Translate S-VLAN");
      	}
      }
      ct.addAttrRow("operationType", RESOURCE["operationType"], atom);
    }        
     
    atom = new Atom("select");
     for(var i = 0, len1 = srcPortsOfUse.length; i < len1; i++)
    {
    	atom.addOption(srcPortsOfUse[i].portName, i);
    }
    ct.addAttrRow("srcPort", RESOURCE["srcport"], atom);
    atom.element.onchange = refreshPortTable;
    
        
    atom = new Atom("span");
    if("65535" == srcVlan)
    {
    	atom.setValue("-");
    }
    else
    {
        atom.setValue(srcVlan);
    }
 
    ct.addAttrRow("sourceVlan", RESOURCE["srccvlan"], atom);
    
    if(EPL_SERVICE != serviceType)
    {
    	atom = new Atom("span"); 
      if("65535" == srcSVlan)
      {
      	atom.setValue("-");
      }
      else
      {
          atom.setValue(srcSVlan);
      }
      
      ct.addAttrRow("srcSVlan", RESOURCE["sourceS-VLAN"], atom);
    }     
    
    atom = new Atom("span");
    if (VCTRUNK_NUMBER > snkPort)
    {
    	 atom.setValue("PORT" + snkPort);
    }
    else
    {
    	 atom.setValue("VCTRUNK" + (snkPort - VCTRUNK_NUMBER));
    }

    ct.addAttrRow("sinkPort", RESOURCE["snkport"], atom);
    
    atom = new Atom("span");
    if("65535" == snkVlan)
    {
    	atom.setValue("-");
    }
    else
    {
        atom.setValue(snkVlan);
    }
    ct.addAttrRow("sinkVlan", RESOURCE["snkcvlan"], atom);
    
    if(EPL_SERVICE != serviceType)
    {
    	atom = new Atom("span"); 
      if("65535" == snkSVlan)
      {
      	atom.setValue("-");
      }
      else
      {
          atom.setValue(snkSVlan);
      }
      
      ct.addAttrRow("snkSVlan", RESOURCE["snkS-VLAN"], atom);
    }     
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
}

/*
 *      SNCP          
 */
function setStatus(state)
{
    $("okbtn").disabled = state;
    $("applybtn").disabled = state;
}

/*
 *         SNCP    
 *              onclick  
 */
function doConvertSNCP(btnFlag)
{
	var srcPortElement = ct.getAtom("srcPort").element;
    var srcPort = srcPortElement.options[srcPortElement.selectedIndex].value;
    srcPort = srcPortsOfUse[srcPort].portName
    
    if(snkPort == srcPort)
    {
    	alert(RESOURCE["protectsrcsnkport"]);
    	return;
    }
	
	setStatus(true);
	
    var portArrXml = createPortArrXmlInfo();
    var portArrURL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_SET_SDHETHPORTATTRIB+"&nmUser="+win["nmUser"];
    
    
	    loadXMLdoc(portArrURL, "POST", false, callbackSetPortArr, btnFlag, "inputdata="+portArrXml);
        
}

/*
 *        vlansncp  
 */
function convertVLANSNCP(btnFlag)
{
    var xmlData = createSNCPCntXmlInfo();
    
    
    var createURL = "../../../../../../tl1NEExlorerServlet?sfid="+TE_IP_NORMALSNCP_CONVERT+"&nmUser="+win["nmUser"];
    
    loadXMLdoc(createURL, "POST", true, callbackConvert, btnFlag, "inputdata="+xmlData);	
}

/*
 *            xml
 */
function createPortArrXmlInfo()
{    
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	
	for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	{
			isChangePortAttr = true;
			var row = new tagElement("row-params");
			
			var param = new tagElement("param");
			param.setAttribute("name", "neID");
			param.setAttribute("value", win.neID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "slotid");
			param.setAttribute("value", win.slotID);
			row.appendChild(param);
			
			param = new tagElement("param");
			param.setAttribute("name", "port");
			var portno = portAttrTable.getCellStoreValue(i, "portno", "portno");
			param.setAttribute("value", portno);
			row.appendChild(param);
			
			var portTypeFlag = portAttrTable.getCellStoreValue(i, "portTypeFlag", "portTypeFlag");
			
			if("0" == portTypeFlag)
			{
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_MAC_PE_TYPE")
				
				
					  param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portType", "portType"));

				param.setAttribute("modifyFlag", "true");
				row.appendChild(param);
				
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_MAC_ENABLE");
				param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portDisabled", "portDisabled"));
				param.setAttribute("modifyFlag", portAttrTable.getCellModify(i, "portDisabled"));
				row.appendChild(param);
				
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_MAC_TAG");
				param.setAttribute("value", portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier"));
				param.setAttribute("modifyFlag", portAttrTable.getCellModify(i, "tagIdentifier"));
				row.appendChild(param);
			}
			else
			{
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_VCG_PE_TYPE");
				
					  param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portType", "portType"));
				

				param.setAttribute("modifyFlag", "true");
				row.appendChild(param);
				
				param = new tagElement("param");
				param.setAttribute("name", "ATTR_ETHOVERSDH_VCG_TAG");
				param.setAttribute("value", portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier"));
				param.setAttribute("modifyFlag", portAttrTable.getCellModify(i, "tagIdentifier"));
				row.appendChild(param);
			}
			
			business.appendChild(row);
			
	}
	
	root.getRoot().appendChild(business);
	
	return root.toString();
}

/*
 *            
 */
function callbackSetPortArr(doc, btnFlag)
{	
	var isSetArr = false;
	
    var datainterface = EncapsulateData(doc);
    showErrorDialog(datainterface);
    
	if(0 == datainterface.getSErrorCode())
	{
		isSetArr = true;
	}
    
    
    
    if(!isSetArr)
    {
    	  $("okbtn").disabled = false;
			  $("applybtn").disabled = false;
        return;
    }
    
    convertVLANSNCP(btnFlag);
}

/*
 *           xml   
 */
function createSNCPCntXmlInfo()
{
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	
 	param.setAttribute("name", "neID");
 	param.setAttribute("value", win.neID);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "slotID");
 	param.setAttribute("value", win.slotID);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "serviceType");
 	param.setAttribute("value", serviceType);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "vlansncpID");
	var vlansncpIDs = sncpWin.getVlanSNCPIDOfUse(1);
 	param.setAttribute("value", vlansncpIDs[0]);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "direction");
 	param.setAttribute("value", direction);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "workLinkID");
 	param.setAttribute("value", linkID);
 	row.appendChild(param);
 	
 	
 	var linkIDs = getLinkIDsOfUse(parseInt(direction)+1);
 	param = new tagElement("param");
 	param.setAttribute("name", "linkID");
 	param.setAttribute("value", linkIDs.toString());
 	row.appendChild(param)
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "srcPort");
    var srcPortElement = ct.getAtom("srcPort").element;
    var srcPort = srcPortElement.options[srcPortElement.selectedIndex].value;
    srcPort = srcPortsOfUse[srcPort].portno
 	param.setAttribute("value", srcPort);
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "srcVlan");
 	if ("-" == srcVlan)
 	{
 		  srcVlan = 0xFFFF;
 	}
 	param.setAttribute("value", srcVlan);
 	row.appendChild(param);

 	param = new tagElement("param");
 	param.setAttribute("name", "snkPort");
 	 	
 	param.setAttribute("value", getPortNo(snkPort));
 	row.appendChild(param);
 	
 	param = new tagElement("param");
 	param.setAttribute("name", "snkVlan");
 	
 	if ("-" == snkVlan)
 	{
 		  snkVlan = 0xFFFF;
 	}
 	param.setAttribute("value", snkVlan);
 	row.appendChild(param);
 	
 	if (EPL_SERVICE != serviceType)
 	{
 		param = new tagElement("param");
 	  param.setAttribute("name", "srcSVlan");
 	  if ("-" == srcSVlan)
 	  {
 	  	  srcSVlan = 0xFFFF;
 	  }
 	  param.setAttribute("value", srcSVlan);
 	  row.appendChild(param);
 		
 		param = new tagElement("param");
 	  param.setAttribute("name", "snkSVlan");
 	  if ("-" == snkSVlan)
 	  {
 	  	  snkSVlan = 0xFFFF;
 	  }
 	  param.setAttribute("value", snkSVlan);
 	  row.appendChild(param);
 	}
 	
	var ipLong = convertIPStrToLong("192.168.0.1");
 	param = new tagElement("param");
 	param.setAttribute("name", "sncpIndentifier");
 	param.setAttribute("value", ipLong);
 	row.appendChild(param);
 	
 	business.appendChild(row);
 	root.getRoot().appendChild(business);
 	
 	return root.toString();
}

/*
 *         SNCP          
 *                    evplmain.html         
 */
/*
 *   VLAN SNCP         
 */
function callbackConvert(doc, btnFlag)
{
    
    var datainterface = EncapsulateData(doc);
        if(datainterface.getError().rowErrors[0] && (0 != datainterface.getSErrorCode()))
	  {
		  var neName = datainterface.getDataRowParam(0,"neName");

			var size = datainterface.getBErrLength();
			for(var i = 0;i < size;i++)
			{
				var tempObj = datainterface.getError().rowErrors[i].errorObj;
  			tempObj["neName"] = neName + "-" + win.slotID + "-" + portData.getDataRowParam(0,"boardName")
			}
		}
	var errArr = [];
  errArr[0] = "neName";
  
  openErrPage("../../../../../../page/", datainterface.getError(), errArr);//????????
  
    
    
    
    win.doQuery(true);
    if( 0 == datainterface.getSErrorCode())
    {
        
        sncpWin.refreshData();
    }
    
    setStatus(false);
    if( (1 == btnFlag ) && ( 0 == datainterface.getSErrorCode()))
    {
    	xcloseDialog();
    }
    return;
}

/*
   :
         
*/
function showErrorDialog(data)
{
    if(data.getError().rowErrors[0] && (0 != data.getSErrorCode()))
	  {
		  var neName = "";//data.getDataRowParam(0,"neName");

			var size = data.getBErrLength();
			for(var i = 0;i < size;i++)
			{
				var tempObj = data.getError().rowErrors[i].errorObj;
				neName = data.getError().rowErrors[i].errorObj["nename"];
  			tempObj["neName"] = neName + "-" + win.slotID + "-" + portData.getDataRowParam(0,"boardName")
			}
		}
	var errArr = [];
  errArr[0] = "neName";
  
  openErrPage("../../../../../../page/", data.getError(), errArr);//???????? 
}

/*
 *     vlansncp           vlanID 
 *          
 */
function getLinkInfo()
{
	for(var i = 0, len = win.st.getDataRowLength(); i < len; i++)
	{
		if(win.st.getRowSelFlag(i))
		{
			direction = win.st.getCellStoreValue(i, "direction", "direction");
			
			serviceType = win.st.getCellStoreValue(i, "linkType", "linkType");
			
			linkID = win.st.getCellStoreValue(i, "upLinkID", "upLinkID");
			
			srcVlan = win.st.getCellStoreValue(i, "srcVlan", "srcVlan");
			
			snkVlan = win.st.getCellStoreValue(i, "snkVlan", "snkVlan");
			
			snkPort = win.st.getCellStoreValue(i, "snkPort", "snkPort");
			
			if (EPL_SERVICE != serviceType)
			{
				 srcSVlan = win.st.getCellStoreValue(i, "srcSVlan", "srcSVlan");
				 snkSVlan = win.st.getCellStoreValue(i, "snkSVlan", "snkSVlan");
			}
			
			break;
		}
	}
}

/*
 *      linkID
 * @param count - linkID   
 */
function getLinkIDsOfUse(count)
{
	var linkIDs = getRangeNumber(linkIDsOfUsed, MIN_VALUE_LINK, MAX_VALUE_LINK, count);
	linkIDsOfUsed = linkIDsOfUsed.concat(linkIDs);
	return linkIDs;
}

/*
 *      linkID
 *       vlansncp       
 */
function getLinkIDsOfUsed()
{
	linkIDsOfUsed = [];
	for(var i = 0, len = win.st.getDataRowLength(); i < len; i++)
	{
		var direction = win.st.getCellStoreValue(i, "direction", "direction");
		var linkId;
		
		if(DIRECTION_BI == direction)
		{
			linkId = win.st.getCellStoreValue(i, "downLinkID", "downLinkID");
			linkIDsOfUsed.push(linkId);
		}
		
		linkId = win.st.getCellStoreValue(i, "upLinkID", "upLinkID");
		
		linkIDsOfUsed.push(linkId);
		
	}	
}
