 /**
 * VLAN        js  
 *   : c00104334
 *   : 2008-08-28
 *      vlansncpcreate.js 
 */
 
var isChangePortAttr = false; 

var win = getParentWindow();
var winurlobj = win.winobj;

var nmUser = win["nmUser"];

var MININPUT = 1;
var MAXINPUT = 4094;
if(win.winobj["boardType"] == TN11TBE) 
{
    MAXINPUT =4095;
}
    
/*
 *     
 */
function initCreateTable()
{
    var element = document.createElement("span");
    element.innerHTML = RESOURCE["attrValue"];
    $("attrHead").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["workAttr"];
    $("workAttrHead").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["protectAttr"];
    $("protectAttrHead").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["boardName"];
    $("board").appendChild(element);
    
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["linkType"];
    $("serviceType").appendChild(element);
    
    element = document.createElement("select");    
    element.options[0] = new Option(SERVICE_TYPE_EPL, SERVICE_TYPE_EPL_VALUE);     
    element.options[1] = new Option(SERVICE_TYPE_EVPL, SERVICE_TYPE_EVPL_VALUE);
    $("workType").appendChild(element);
    element.onchange = changeServiceType;
    
    element = document.createElement("span");
    element.innerHTML = SERVICE_TYPE_EPL;
    $("protectType").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["linkdirection"];
    $("serviceDeriction").appendChild(element);
    
    element = document.createElement("select");    
    element.options[0] = new Option(RESOURCE[DIRECTION_UNILATERALISM], DIRECTION_UNILATERALISM_VALUE);    
    $("workDeriction").appendChild(element);
    element.onchange = changePDeriction;
    
    element = document.createElement("span");    
    element.innerHTML = RESOURCE["sidirectional"];
    $("protectDeriction").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["srcport"];
    $("source").appendChild(element);
    
    
    var source = document.createElement("select");
    for(var i = 0, len1 = srcPortsOfUse.length; i < len1; i++)
    {
        source.options[i] = new Option(srcPortsOfUse[i].portName, i);
    }
    $("workSource").appendChild(source);
    source["onchange"] = refreshPortTable;
    
    var source = document.createElement("select");
    for(var j = 0, len2 = srcPortsOfUse.length; j < len2; j++)
    {
        source.options[j] = new Option(srcPortsOfUse[j].portName, j);
    }
    $("protectSource").appendChild(source);
    source["onchange"] = refreshPortTable;
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["srccvlan"];
    $("sourceVlanId").appendChild(element);
    
    element = document.createElement("input");
    element.className = "textInput";
    element.setAttribute("type", "text");
    element.style.imeMode = "disabled";
    $("workSVlanId").appendChild(element);
    element.style.imeMode = "disabled"
    element["onkeypress"] = isValidateVlanID;
    element["onblur"] = function() { changePVlan(0); };    
    
    element = document.createElement("span");
    $("protectSVlanId").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["snkport"];
    $("sink").appendChild(element);
    
    var sink = document.createElement("select");
    for(var k = 0, len3 = snkPortsOfUse.length; k < len3; k++)
    {
        sink.options[k] = new Option(snkPortsOfUse[k].portName, k);
    }
    $("workSink").appendChild(sink);
    sink["onchange"] = changePSnkPort;
    
    element = document.createElement("span");
    element.innerHTML = sink.options[0].text;
    $("protectSink").appendChild(element);
    
    element = document.createElement("span");
    element.innerHTML = RESOURCE["snkcvlan"];
    $("sinkVlanId").appendChild(element);
    
    element = document.createElement("input");
    element.className = "textInput";
    element.setAttribute("type", "text");
    element.style.imeMode = "disabled";
    $("workSinkVlanId").appendChild(element);
    element["onkeypress"] = isValidateVlanID;
    element["onblur"] = function() { changePVlan(1); };
    
    element = document.createElement("span");    
    $("protectSinkVlanId").appendChild(element);
    
}
/*
 *        
 */
function initPortAttr()
{
    portAttrTable = new SortTable();
    portAttrTable.setImage("../../../../../../images/");    
    createTableHead(portAttrTable, window.tableconf[0]);
    portAttrTable.setBodyHeight(100);
    $("portAttr").appendChild(portAttrTable.getTable());
}

/*
 *        
 */
function initCreateButton()
{
    $("okbtn").value = RESOURCE["okbutton"];  
    $("cancelbtn").value = RESOURCE["cancelbutton"];  
    $("applybtn").value = RESOURCE["applybutton"];    
}

/*
 *              
 */
function initPortTblInfo()
{
    $("portTableName").innerHTML = RESOURCE["portTblName"];
}

/*
 *      
 */ 
function initCreatePage()
{        
    
    getSupportPorts(winurlobj.neid, winurlobj.slotid);

    initCreateTable();

    initPortTblInfo();

    initPortAttr();

    initCreateButton();

    refreshPortTable();
}

/*
 *               onclick  
 *                  vlanSNCP
 * @param btnFlag 0        1       
 */
function doCreateSNCP(btnFlag)
{
    if(btnFlag == 1 && $("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }       
    var workSVlanId = $("workSVlanId").firstChild.value;
    
    if(!isValidateVlan(workSVlanId))
    {
        alert(RESOURCE["invalidatesrcvlanid"]);
        return;
    }
    
    var workSinkVlanId = $("workSinkVlanId").firstChild.value;

    if(!isValidateVlan(workSinkVlanId))
    {
        alert(RESOURCE["invalidatesnkvlan"]);
        return;
    }
    
    var serviceTypeSelect = $("workType").firstChild;
    if (SERVICE_TYPE_EVPL_VALUE == serviceTypeSelect.options[serviceTypeSelect.selectedIndex].value)
    {
        var srcSVlan = $("workSrcSVlan").firstChild.value;
        if (!isValidateSVlan(srcSVlan))
        {
            alert(RESOURCE["invalidatesrcsvlan"]);
            return;
        }
        var snkSVlan = $("workSnkSVlan").firstChild.value;
        if (!isValidateSVlan(snkSVlan))
        {
            alert(RESOURCE["invalidatesnksvlan"]);
            return;
        }
          
        var element = $("workOperation").firstChild;
        if (OPERATION_TRANSLATE_SVLAN_VALUE == element.options[element.selectedIndex].value
            && snkSVlan == srcSVlan)
        {
            alert(RESOURCE["srcSVlansnk"]);
            return;
        }
    }
    
    if(!validateCreateForm())
    {
        return;
    }    
    
    var vlannums = splitVlanID(workSVlanId).length;
    if (vlannums > 8)
    {
    	alert(RESOURCE["maxCount"]);
    	return;
    }
    
    setStatus(true);
    
    var portArrXml = createPortArrXmlInfo();
    var portArrURL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_SET_ETHPORTATTRIB+"&nmUser="+win["nmUser"];
    
    if(isChangePortAttr)
    {
        loadXMLdoc(portArrURL, "POST", false, callbackSetPortArr, btnFlag, "inputdata="+portArrXml);
    }
    else
    {
        createEthlink(btnFlag);
    }        
}

function isValidateSVlan(vlanID)
{
    if(vlanID == "")
    {
       return false;
    }
    return true;
}

/*
 *            xml
 */
function createPortArrXmlInfo()
{    
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    isChangePortAttr = false;
    var portTag = null;
    for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
    {
          isChangePortAttr = true;
          var row = new tagElement("row-params");
            
          var param = new tagElement("param");
          param.setAttribute("name", "neID");
          param.setAttribute("value", winurlobj.neid);
          row.appendChild(param);
            
          param = new tagElement("param");
          param.setAttribute("name", "slotid");
          param.setAttribute("value", winurlobj.slotid);
          row.appendChild(param);
            
          param = new tagElement("param");
          param.setAttribute("name", "portid");
          var portno = portAttrTable.getCellStoreValue(i, "portno", "portno");
          param.setAttribute("value", portno);
          row.appendChild(param);
          
          var portTypeFlag = portAttrTable.getCellStoreValue(i, "portTypeFlag", "portTypeFlag");
            
          if("0" == portTypeFlag)
          {
              param = new tagElement("param");
              param.setAttribute("name", "PORTTYPE")
              param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portType", "portType"));
              row.appendChild(param);
                
              param = new tagElement("param");
              param.setAttribute("name", "PORTENABLE");
              param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portDisabled", "portDisabled"));
              row.appendChild(param);
              
              portTag = portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier");
              if ("-" != portTag)
              {
                  param = new tagElement("param");
                  param.setAttribute("name", "TAGTYPE");
                  param.setAttribute("value", portTag);
                  row.appendChild(param);
              }
          }
          else
          {
              param = new tagElement("param");
              param.setAttribute("name", "PORTTYPE");
              param.setAttribute("value", portAttrTable.getCellStoreValue(i, "portType", "portType"));
              row.appendChild(param);
                
              portTag = portAttrTable.getCellStoreValue(i, "tagIdentifier", "tagIdentifier");
              if ("-" != portTag)
              {
                  param = new tagElement("param");
                  param.setAttribute("name", "TAGTYPE");
                  param.setAttribute("value", portTag);
                  row.appendChild(param);
              }
          }
            
          bussiness.appendChild(row);
            
    }
    
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}

/*
 *            
 */
function callbackSetPortArr(doc, btnFlag)
{
    var isSetArr = false;
    
    var datainterface = EncapsulateData(doc); 
    if (OPRSUCC != datainterface.getSErrorCode())  
    {
        showErrorDialog(datainterface);
    }  
    
    if(0 == datainterface.getSErrorCode())
    {
        isSetArr = true;
    }
    else
    {
        setStatus(false);
        
         setVlanTextStatus();
         
        return;  
    }
    
    refreshTableState(portAttrTable,window.tableconf[0],datainterface);
    
    createEthlink(btnFlag);
}

/**
 * btnFlag     
*/
function createEthlink(btnFlag)
{
    var xmlData = createEthlinkXML();
    var createURL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_EVPL_CREATE+"&nmUser="+win["nmUser"];
    
    loadXMLdoc(createURL, "POST", true, createEthlinkBack, btnFlag, "inputdata="+xmlData); 
}

/*
 * ENT-ETHLINK     
 */
function createEthlinkBack(doc, btnFlag)
{
    var data = EncapsulateData(doc);
    if(OPRSUCC == data.getSErrorCode())
    {
        createVLANSNCP(btnFlag);
    }
    else
    {
        setStatus(false);
        
         setVlanTextStatus();
        
        showErrorDialog(data);
    }
}

/**
 *           C-VLAN, S-VLAN          
 */
function  setVlanTextStatus()
{
    var serviceTypeSelect = $("workType").firstChild;
    var serviceType = serviceTypeSelect.options[serviceTypeSelect.selectedIndex].value;
    var operationTypeSelect = null;
    var operationType = null;
    if (SERVICE_TYPE_EVPL_VALUE == serviceType)
    {
        var workSVlanText = $("workSVlanId").firstChild;
        var workSnkVlanText = $("workSinkVlanId").firstChild;
        var workSrcSVlanText = $("workSrcSVlan").firstChild;
        var workSnkSVlanText = $("workSnkSVlan").firstChild; 
            
        operationTypeSelect = $("workOperation").firstChild;
        operationType = operationTypeSelect.options[operationTypeSelect.selectedIndex].value;
        if (OPERATION_TRANSMIT_SVLAN_VALUE == operationType || OPERATION_TRANSLATE_SVLAN_VALUE == operationType)
        {
            workSVlanText.value = "-"
            workSVlanText.disabled = true;
            
            workSnkVlanText.value= "-";
            workSnkVlanText.disabled = true;
        }
        else if (OPERATION_STRIP_SVLAN_VALUE == operationType)
        {
            workSVlanText.value = "-"
            workSVlanText.disabled = true;
            
            workSnkVlanText.value= "-";
            workSnkVlanText.disabled = true;
            
            workSnkSVlanText.value = "-";
            workSnkSVlanText.disabled = true;
        }
    }
}

/*
 *       SNCP xml   
 */
function createEthlinkXML()
{
    var ethlinkInfo = new EthlinkInfo();
    var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params"); 
           
    var wSourVlanIds = splitVlanID($("workSVlanId").firstChild.value);//   vlanID
    var wSinkVlanIds = splitVlanID($("workSinkVlanId").firstChild.value);//   vlanID
    
    if(0 == wSourVlanIds.length)
    {
        wSourVlanIds[wSourVlanIds.length] = "-";
        wSinkVlanIds[wSinkVlanIds.length] = "-";
    }
    
    ethlinkInfo.srcCVlan = wSourVlanIds;
    ethlinkInfo.snkCVlan = wSinkVlanIds;
    
    ethlinkInfo.neid = winurlobj.neid;
    ethlinkInfo.slotid = winurlobj.slotid;
    
    var direction = $("workDeriction").firstChild.value;
    ethlinkInfo.servDir = direction;
    
    var element = $("workSource").firstChild;
    var workSrcPort = element.options[element.selectedIndex].value;
    workSrcPort = srcPortsOfUse[workSrcPort].portno;
    ethlinkInfo.srcPort = workSrcPort;   
    
    element = $("workSink").firstChild;
    var workSnkPort = element.options[element.selectedIndex].value;
    workSnkPort = snkPortsOfUse[workSnkPort].portno;    
    ethlinkInfo.snkPort = workSnkPort;   
    
    element = $("workType").firstChild;
    var serviceType = element.options[element.selectedIndex].value;
    ethlinkInfo.servType = serviceType;
    
    if (SERVICE_TYPE_EVPL_VALUE == serviceType)
    {  
        ethlinkInfo.srcSVlan = $("workSrcSVlan").firstChild.value;
        ethlinkInfo.snkSVlan = $("workSnkSVlan").firstChild.value;  
    }
    else
    {
        ethlinkInfo.srcSVlan = "-";
        ethlinkInfo.snkSVlan = "-"; 
    }
    
    var rowArray = ethlinkInfo.toCreateEthlinkRows();;
    for (var i = 0, len = rowArray.length; i < len; i ++)
    {
        bussiness.appendChild(rowArray[i]);
    }

    ethlinkInfo = new EthlinkInfo();
    
    ethlinkInfo.srcCVlan = wSourVlanIds;
    ethlinkInfo.snkCVlan = wSinkVlanIds;
    
    ethlinkInfo.neid = winurlobj.neid;
    ethlinkInfo.slotid = winurlobj.slotid; 
    
    var direction = $("workDeriction").firstChild.value;
    ethlinkInfo.servDir = direction;
    
    element = $("protectSource").firstChild;
    var protectSrcPort = element.options[element.selectedIndex].value;
    protectSrcPort = srcPortsOfUse[protectSrcPort].portno; 
    ethlinkInfo.srcPort = protectSrcPort;
    ethlinkInfo.srcCVlan = wSourVlanIds; 
    ethlinkInfo.snkPort = workSnkPort;
    ethlinkInfo.snkCVlan = wSinkVlanIds;
    
    element = $("workType").firstChild;
    var serviceType = element.options[element.selectedIndex].value;
    ethlinkInfo.servType = serviceType;
    
    if (SERVICE_TYPE_EVPL_VALUE == serviceType)
    {
        ethlinkInfo.srcSVlan = $("workSrcSVlan").firstChild.value;
        ethlinkInfo.snkSVlan = $("workSnkSVlan").firstChild.value;  
    }
    else
    {
        ethlinkInfo.srcSVlan = "-";
        ethlinkInfo.snkSVlan = "-"; 
    }

    rowArray = ethlinkInfo.toCreateEthlinkRows();;
    for (var i = 0, len = rowArray.length; i < len; i ++)
    {
        bussiness.appendChild(rowArray[i]);
    }
    root.getRoot().appendChild(bussiness);
    return root.toString();     
}

/*
       
 */
function EthlinkInfo()
{ 
    this.neid = null;  //  ID
    this.slotid = null; //  ID    
    this.servType = null; //        
    this.servDir = null; //        
    this.oprType = null;  //       
    this.srcPort = null;   //     
    this.srcCVlan = []; // CVlan    
    this.srcSVlan = null; // SVlan 
    this.snkPort = null; //       
    this.snkCVlan = [];  // CVlan  
    this.snkSVlan = null; // SVlan
    this.toCreateEthlinkRows = function()
    {
        if (this.srcCVlan.length == 0)
        {
             this.srcCVlan[this.srcCVlan.length] = "-";
        }
        
        var bussiness = [];
        var row = null;
        for(var i = 0, len = this.srcCVlan.length; i < len; i ++)
        {
            row = new tagElement("row-params"); 
            this.addParam(row, "neID", this.neid)
            this.addParam(row, "slotid", this.slotid);
            this.addParam(row, "srcPort", this.srcPort);
            this.addParam(row, "srcCVlan", this.srcCVlan[i]);
            this.addParam(row, "snkPort", this.snkPort);
            this.addParam(row, "snkCVlan", this.snkCVlan[i]);
            this.addParam(row, "direction", DIRECTION_UNILATERALISM_VALUE);
            if (this.servType == SERVICE_TYPE_EVPL_VALUE)
            {
                this.addParam(row, "srcSVlan", this.srcSVlan);
                this.addParam(row, "snkSVlan", this.snkSVlan);
            }
            bussiness.push(row);
            
            if (this.servDir == DIRECTION_BIDIRECTION_VALUE)
            {
                row = new tagElement("row-params"); 
                this.addParam(row, "neID", this.neid)
                this.addParam(row, "slotid", this.slotid);
                this.addParam(row, "srcPort", this.snkPort);
                this.addParam(row, "srcCVlan", this.snkCVlan[i]);
                this.addParam(row, "snkPort", this.srcPort);
                this.addParam(row, "snkCVlan", this.srcCVlan[i]);
                this.addParam(row, "direction", DIRECTION_UNILATERALISM_VALUE);
                if (this.servType == SERVICE_TYPE_EVPL_VALUE)
                {
                    this.addParam(row, "srcSVlan", this.snkSVlan);
                    this.addParam(row, "snkSVlan", this.srcSVlan);
                }
                bussiness.push(row);
            }
        }
        return bussiness;
    }
    
    this.addParam = function(rowparams, name, value)
    {
       if (value == "-" || value == "65535")
        {
            return;
        }
    
        var param = new tagElement("param");
        param.setAttribute("name", name);
        param.setAttribute("value", value);
        rowparams.appendChild(param); 
    }
}

function addParam(rowparams, name, value)
{      
    var param = new tagElement("param");
    param.setAttribute("name", name);
    param.setAttribute("value", value);
    rowparams.appendChild(param);
}

/*
 *   vlansncp  
 */
function createVLANSNCP(btnFlag)
{
    var xmlData = createSNCPCrtXmlInfo();
    
    var createURL = "../../../../../../tl1NEExlorerServlet?sfid="+TE_IP_VLANSNCP_CREATE+"&nmUser="+win["nmUser"];
    
    loadXMLdoc(createURL, "POST", true, callbackCreate, btnFlag, "inputdata="+xmlData); 
}

/*
 *       SNCP xml   
 */
function createSNCPCrtXmlInfo()
{   
    var sncpInfo = new VLANSNCPInfo();     
    
    var wSourVlanIds = splitVlanID($("workSVlanId").firstChild.value);//   vlanID
    var wSinkVlanIds = splitVlanID($("workSinkVlanId").firstChild.value);//   vlanID
    
    if(0 == wSourVlanIds.length)
    {
        wSourVlanIds[wSourVlanIds.length] = "-";
        wSinkVlanIds[wSinkVlanIds.length] = "-";
    }
    sncpInfo.workSrcCVlan = wSourVlanIds;
    sncpInfo.protectSrcCVlan = wSourVlanIds;
    sncpInfo.workSnkVlan = wSinkVlanIds;
    sncpInfo.protectSnkVlan = wSinkVlanIds;
    
    var direction = $("workDeriction").firstChild.value;
    sncpInfo.direction = direction;
    
    sncpInfo.neid = winurlobj.neid;
    sncpInfo.slotid = winurlobj.slotid;
    
    var element = $("workType").firstChild;
    var serviceType = element.options[element.selectedIndex].value;
    sncpInfo.servType =  serviceType;
       
    element = $("workSource").firstChild;
    var workSrcPort = element.options[element.selectedIndex].value;
    workSrcPort = srcPortsOfUse[workSrcPort].portno;
    sncpInfo.workSrcPort = workSrcPort;
    
    element = $("protectSource").firstChild;
    var protectSrcPort = element.options[element.selectedIndex].value;
    protectSrcPort = srcPortsOfUse[protectSrcPort].portno;
    sncpInfo.protectSrcPort = protectSrcPort;
    
    element = $("workSink").firstChild;
    var workSnkPort = element.options[element.selectedIndex].value;
    workSnkPort = snkPortsOfUse[workSnkPort].portno;
    sncpInfo.workSnkPort = workSnkPort;
    sncpInfo.protectSnkPort = workSnkPort;
   
    if (SERVICE_TYPE_EVPL_VALUE == serviceType)
    {
        sncpInfo.srcSVlan = $("workSrcSVlan").firstChild.value;//    SVlan    
        sncpInfo.snkSVlan = $("workSnkSVlan").firstChild.value;//    SVlan    
    }
    
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params"); 
    var rowArray = sncpInfo.toCreateVLANSNCPRows();   
    for (var i = 0, len = rowArray.length; i < len; i ++)
    {
        bussiness.appendChild(rowArray[i]);
    } 
    
    root.getRoot().appendChild(bussiness);
    return root.toString();     
}

/*
       
 */
function VLANSNCPInfo()
{ 
    this.neid = null;  //  ID
    this.slotid = null; //  ID    
    this.servType = null; //        
    this.servDir = null; //        
    this.oprType = null;  //       
    this.workSrcPort = null;
    this.protectSrcPort = null;
    this.workSrcCVlan = [];
    this.protectSrcCVlan = [];
    this.workSnkPort = null;
    this.protectSnkPort = null;
    this.workSnkCVlan = [];
    this.protectSnkCVlan = [];
    this.srcSVlan = null;
    this.snkSVlan = null;
    this.toCreateVLANSNCPRows = function()
    {
        if (this.workSrcCVlan.length == 0)
        {
             this.workSrcCVlan[this.workSrcCVlan.length] = "-";
             this.protectSrcCVlan[this.protectSrcCVlan.length] = "-";
        }

        if (this.workSnkCVlan.length == 0)
        {
             this.workSnkCVlan[this.workSnkCVlan.length] = "-";
             this.protectSnkCVlan[this.protectSnkCVlan.length] = "-";
        }
        
        var bussiness = [];
        var row = null;
        for(var i = 0, len = this.workSrcCVlan.length; i < len; i ++)
        {
            row = new tagElement("row-params"); 
            this.addParam(row, "neID", this.neid)
            this.addParam(row, "slotid", this.slotid);
            this.addParam(row, "direction", DIRECTION_UNILATERALISM_VALUE);
            this.addParam(row, "workSrcPort", this.workSrcPort);
            this.addParam(row, "protectSrcPort", this.protectSrcPort);
            this.addParam(row, "workSrcVlan", this.workSrcCVlan[i]);
            this.addParam(row, "protectSrcVlan", this.protectSrcCVlan[i]);
            this.addParam(row, "workSnkPort", this.workSnkPort);
            this.addParam(row, "protectSnkPort", this.protectSnkPort);
            if (this.servType == SERVICE_TYPE_EVPL_VALUE)
            {
                this.addParam(row, "srcSVlan", this.srcSVlan);
                this.addParam(row, "srcSVlan", this.srcSVlan);
            }
            bussiness.push(row);
            
        }
        return bussiness;
    }
    
    this.addParam = function(rowparams, name, value)
    {
       if (value == "-" || value == "65535")
        {
            return;
        }
    
        var param = new tagElement("param");
        param.setAttribute("name", name);
        param.setAttribute("value", value);
        rowparams.appendChild(param); 
    }
}

/*
 *   VLAN SNCP         
 */
function callbackCreate(doc, btnFlag)
{ 
    var datainterface = EncapsulateData(doc);
    if (OPRSUCC != datainterface.getSErrorCode())
    {
        showErrorDialog(datainterface);
    }
    
    setStatus(false);
    var element = $("workType").firstChild;
    var serviceType = element.options[element.selectedIndex].value;
    if(SERVICE_TYPE_EVPL_VALUE == serviceType)
    {
        $("workSVlanId").firstChild.disabled = true;
        $("workSinkVlanId").firstChild.disabled = true;
    }
    
    if(OPRFAIL != datainterface.getSErrorCode())
    {
        $("applybtn").disabled = true;
        win.doQuery();
    }
    
    if( (1 == btnFlag ) && ( 0 == datainterface.getSErrorCode()))
    {
        xcloseDialog();
    }
    return;
}

/*
   :
         
*/
function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

/*
 *                       
 */
function changePDeriction()
{
    $("applybtn").disabled = false;
    
    var targetElm = getEventSrc();
    
    $("protectDeriction").firstChild.innerHTML = targetElm.options[targetElm.selectedIndex].text;
    
    var serviceTypeSelect = $("workType").firstChild;
    var serviceType = serviceTypeSelect.options[serviceTypeSelect.selectedIndex].value;
    var element = null;
    var operationType = null;
    if (SERVICE_TYPE_EVPL_VALUE == serviceType)
    {
        element = $("workDeriction").firstChild;
        operationType = element.options[element.selectedIndex].value;
        element = $("workOperation").firstChild;
        if (DIRECTION_UNILATERALISM_VALUE == operationType)
        {          
            element.options.length = 0;    
            element.options[0] = new Option(operTypeConvert[OPERATION_TRANSMIT_SVLAN_VALUE], OPERATION_TRANSMIT_SVLAN_VALUE);     
            
            element.options[1] = new Option(operTypeConvert[OPERATION_STRIP_SVLAN_VALUE], OPERATION_STRIP_SVLAN_VALUE); 
            
            $("protectOperation").firstChild.innerHTML = operTypeConvert[OPERATION_TRANSMIT_SVLAN_VALUE];        
            
        } 
        else
        {
            element.options.length = 0;    
            element.options[0] = new Option(operTypeConvert[OPERATION_TRANSMIT_SVLAN_VALUE], OPERATION_TRANSMIT_SVLAN_VALUE);     
            
        
            $("protectOperation").firstChild.innerHTML = operTypeConvert[OPERATION_TRANSMIT_SVLAN_VALUE];   
            
            $("workSrcSVlan").firstChild.disabled = false;
            $("workSrcSVlan").firstChild.value = "";
            $("protectSrcSVlan").firstChild.innerHTML = "";
            
            $("workSnkSVlan").firstChild.disabled = false;
            $("workSnkSVlan").firstChild.value = "";
            $("protectSnkSVlan").firstChild.innerHTML = ""; 
        }
    }    
}

/*
 *                     
 */
function changePSnkPort()
{  
    $("applybtn").disabled = false;
    var targetElm = getEventSrc();
    
    $("protectSink").firstChild.innerHTML = targetElm.options[targetElm.selectedIndex].text;
    
    refreshPortTable();
}

/*
 *       
 */
function changeServiceType()
{        
    var childIndex = 0;
    for (var i = 0, len = $("table").childNodes.length; i < len; i++)
    {
          if ("TBODY" == $("table").childNodes[i].tagName)
          {
              childIndex = i;
          }
    }
    
    $("applybtn").disabled = false;
    var selectedIndex = this.selectedIndex;
    $("protectType").firstChild.innerHTML = this.options[selectedIndex].text;
    
    if (SERVICE_TYPE_EPL_VALUE == this.options[selectedIndex].value)
    {
        window.dialogHeight="480px";
        $("table").childNodes[childIndex].removeChild($("operationTypeRow"));
        $("table").childNodes[childIndex].removeChild($("srcSVlanRow"));
        $("table").childNodes[childIndex].removeChild($("snkSVlanRow"));
                  
        $("workDeriction").firstChild.value = DIRECTION_UNILATERALISM_VALUE;
        $("protectDeriction").firstChild.innerHTML = RESOURCE["sidirectional"];
          
        $("workSVlanId").firstChild.disabled = false;
        $("workSVlanId").firstChild.value = "";
        $("protectSVlanId").firstChild.innerHTML = "";
          
        $("workSinkVlanId").firstChild.disabled = false;
        $("workSinkVlanId").firstChild.value = "";
        $("protectSinkVlanId").firstChild.innerHTML = "";
                
        for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
        {
            var cell = portAttrTable.getCell(i,"portType");
            portAttrTable.setCellValue(cell,"portType",PORT_TYPE_UNI_VALUE);
            portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_UNI);
        }
        setTagCellEdit();             
    }
    else
    {
        window.dialogHeight="560px";
        $("workDeriction").firstChild.value = DIRECTION_UNILATERALISM_VALUE;
        $("protectDeriction").firstChild.innerHTML = RESOURCE["sidirectional"];
          
        var tr = document.createElement("tr");
        tr.setAttribute("id", "operationTypeRow");
         
        var td1 = document.createElement("td");
        td1.setAttribute("id", "operationType");
        element = document.createElement("span");
        element.innerHTML = RESOURCE["operationType"];
        td1.appendChild(element);
            
        var td2 = document.createElement("td");
        td2.setAttribute("id", "workOperation");
        element = document.createElement("select");    
        element.options[0] = new Option(operTypeConvert[OPERATION_TRANSMIT_SVLAN_VALUE], OPERATION_TRANSMIT_SVLAN_VALUE);     
        
        element.options[1] = new Option(operTypeConvert[OPERATION_STRIP_SVLAN_VALUE], OPERATION_STRIP_SVLAN_VALUE);
        element.onchange = changeOperationType;
        td2.appendChild(element);
        
        var td3 = document.createElement("td");
        td3.setAttribute("id", "protectOperation");
        element = document.createElement("span");
        element.innerHTML = operTypeConvert[OPERATION_TRANSMIT_SVLAN_VALUE];
        td3.appendChild(element); 
        
        tr.appendChild(td1);
        tr.appendChild(td2);
        tr.appendChild(td3);
        
        $("table").childNodes[childIndex].insertBefore(tr, $("srcPort"));
          
        var tr = document.createElement("tr");
        tr.setAttribute("id", "srcSVlanRow");
          
        var td1 = document.createElement("td");
        td1.setAttribute("id", "srcSVlan");
        element = document.createElement("span");
        element.innerHTML = RESOURCE["sourceS-VLAN"];
        td1.appendChild(element);
            
        var td2 = document.createElement("td");
        td2.setAttribute("id", "workSrcSVlan");
        element = document.createElement("input");
        element.className = "textInput";
        element.setAttribute("type", "text");
        element.style.imeMode = "disabled";
        element.value = "";
        element.disabled = false;
        checkDataCellEvent(element,MININPUT,MAXINPUT);
        element["onblur"]=changeSrcSVlan;
        td2.appendChild(element);     
        
        var td3 = document.createElement("td");
        td3.setAttribute("id", "protectSrcSVlan");
        element = document.createElement("span");
        td3.appendChild(element); 
        
        tr.appendChild(td1);
        tr.appendChild(td2);
        tr.appendChild(td3);
            
        $("table").childNodes[childIndex].insertBefore(tr, $("snkPort"));
            
        var tr = document.createElement("tr");
        tr.setAttribute("id", "snkSVlanRow");
          
        var td1 = document.createElement("td");
        td1.setAttribute("id", "svlan");
        element = document.createElement("span");
        element.innerHTML = RESOURCE["snkS-VLAN"];
        td1.appendChild(element);
            
        var td2 = document.createElement("td");
        td2.setAttribute("id", "workSnkSVlan");
        element = document.createElement("input");
        element.className = "textInput";
        element.setAttribute("type", "text");
        checkDataCellEvent(element,MININPUT,MAXINPUT);
        element["onblur"]=changeSnkSVlan;
        td2.appendChild(element);     
        
        var td3 = document.createElement("td");
        td3.setAttribute("id", "protectSnkSVlan");
        element = document.createElement("span");
        td3.appendChild(element); 
        
        tr.appendChild(td1);
        tr.appendChild(td2);
        tr.appendChild(td3);
            
        $("table").childNodes[childIndex].appendChild(tr);                
          
        $("workSVlanId").firstChild.disabled = true;
        $("workSVlanId").firstChild.value = "-";
        $("protectSVlanId").firstChild.innerHTML = "-";
          
        $("workSinkVlanId").firstChild.disabled = true;
        $("workSinkVlanId").firstChild.value = "-";
        $("protectSinkVlanId").firstChild.innerHTML = "-";                  
                
        var wsnpElement = $("workSink").firstChild;
        var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
        var snkPortNO = srcPortsOfUse[workSnkPort].portno;
        
        for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
        {
            if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
            {
                cell = portAttrTable.getCell(i,"portType");
                portAttrTable.setCellValue(cell,"portType",PORT_TYPE_S_AWARE_VALUE);
                portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_S_AWARE);
            }
            else
            {
                cell = portAttrTable.getCell(i,"portType");
                portAttrTable.setCellValue(cell,"portType",PORT_TYPE_S_AWARE_VALUE);
                portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_S_AWARE);
            }
        }
        setTagCellEdit();  
    }   
}       
        
function changeOperationType()
{
    $("applybtn").disabled = false;
    
    var operationTypeSelect = $("workOperation").firstChild;
    var operationType = operationTypeSelect.options[operationTypeSelect.selectedIndex].value;   
    
    $("protectOperation").firstChild.innerHTML = operationTypeSelect.options[operationTypeSelect.selectedIndex].text;
    var workDerictionElement = $("workDeriction").firstChild;
    var workDerictionValue = workDerictionElement.options[workDerictionElement.selectedIndex].value;
    if(workDerictionValue == DIRECTION_UNILATERALISM_VALUE)
    {
        if (OPERATION_ADD_SVAN_VALUE == operationType)
        {
            $("workSrcSVlan").firstChild.disabled = true;
            $("workSrcSVlan").firstChild.value = "-";
            $("protectSrcSVlan").firstChild.innerHTML = "-";
        
            $("workSnkSVlan").firstChild.disabled = false;
            $("workSnkSVlan").firstChild.value = "";
            $("protectSnkSVlan").firstChild.innerHTML = "";
                        
            var wsnpElement = $("workSink").firstChild;
            var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
            var snkPortNO = srcPortsOfUse[workSnkPort].portno;
           
            for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
            {
                if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
                {
                    cell = portAttrTable.getCell(i,"portType");
                    portAttrTable.setCellValue(cell,"portType",PORT_TYPE_S_AWARE_VALUE);
                    portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_S_AWARE);
                }
                else
                {
                    cell = portAttrTable.getCell(i,"portType");
                    portAttrTable.setCellValue(cell,"portType",PORT_TYPE_C_AWARE_VALUE);
                    portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_C_AWARE);
                }
            }  
        }
        else if (OPERATION_TRANSMIT_SVLAN_VALUE == operationType || OPERATION_TRANSLATE_SVLAN_VALUE == operationType)
        {
            $("workSrcSVlan").firstChild.disabled = false;
            $("workSrcSVlan").firstChild.value = "";
            $("protectSrcSVlan").firstChild.innerHTML = "";
        
            $("workSnkSVlan").firstChild.disabled = false;
            $("workSnkSVlan").firstChild.value = "";
            $("protectSnkSVlan").firstChild.innerHTML = ""; 
            
            for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
            {            
                cell = portAttrTable.getCell(i,"portType");
                portAttrTable.setCellValue(cell,"portType",PORT_TYPE_S_AWARE_VALUE);
                portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_S_AWARE);            
            }  
        }
        else
        {
            $("workSrcSVlan").firstChild.disabled = false;
            $("workSrcSVlan").firstChild.value = "";
            $("protectSrcSVlan").firstChild.innerHTML = "";
        
            $("workSnkSVlan").firstChild.disabled = true;
            $("workSnkSVlan").firstChild.value = "-";
            $("protectSnkSVlan").firstChild.innerHTML = "-";                  
                
            var wsnpElement = $("workSink").firstChild;
            var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
            var snkPortNO = srcPortsOfUse[workSnkPort].portno;
           
            for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
            {
                if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
                {
                    cell = portAttrTable.getCell(i,"portType");
                    portAttrTable.setCellValue(cell,"portType",PORT_TYPE_C_AWARE_VALUE);
                    portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_C_AWARE);
                }
                else
                {
                    cell = portAttrTable.getCell(i,"portType");
                    portAttrTable.setCellValue(cell,"portType",PORT_TYPE_S_AWARE_VALUE);
                    portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_S_AWARE);
                }
            }  
        }
    }
    else
    {
        if (OPERATION_TRANSMIT_SVLAN_VALUE == operationType || OPERATION_TRANSLATE_SVLAN_VALUE == operationType)
        {
            $("workSrcSVlan").firstChild.disabled = false;
            $("workSrcSVlan").firstChild.value = "";
            $("protectSrcSVlan").firstChild.innerHTML = "";
        
            $("workSnkSVlan").firstChild.disabled = false;
            $("workSnkSVlan").firstChild.value = "";
            $("protectSnkSVlan").firstChild.innerHTML = ""; 
            
            for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
            {           
                cell = portAttrTable.getCell(i,"portType");
                portAttrTable.setCellValue(cell,"portType",PORT_TYPE_S_AWARE_VALUE);
                portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_S_AWARE);           
            }  
        }
        else
        {   //      Strip S-VLAN
            $("workSrcSVlan").firstChild.disabled = false;
            $("workSrcSVlan").firstChild.value = "";
            $("protectSrcSVlan").firstChild.innerHTML = "";
        
            $("workSnkSVlan").firstChild.disabled = true;
            $("workSnkSVlan").firstChild.value = "-";
            $("protectSnkSVlan").firstChild.innerHTML = "-";                  
                
            var wsnpElement = $("workSink").firstChild;
            var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
            var snkPortNO = srcPortsOfUse[workSnkPort].portno;
        
            for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
            {
                if (snkPortNO == portAttrTable.getCellStoreValue(i, "portno", "portno"))
                {
                    cell = portAttrTable.getCell(i,"portType");
                    portAttrTable.setCellValue(cell,"portType",PORT_TYPE_C_AWARE_VALUE);
                  portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_C_AWARE);
                }
                else
                {
                    cell = portAttrTable.getCell(i,"portType");
                    portAttrTable.setCellValue(cell,"portType",PORT_TYPE_S_AWARE_VALUE);
                    portAttrTable.setAtomValue(cell.element.showElement,PORT_TYPE_S_AWARE);
                }
            }  
        }
    }
}

function changeSrcSVlan()
{
    $("applybtn").disabled = false;
    var svlan = this.value;
    $("protectSrcSVlan").firstChild.innerHTML = svlan;
    
    var element = $("workOperation").firstChild;
    if (OPERATION_TRANSMIT_SVLAN_VALUE == element.options[element.selectedIndex].value)
    {
        $("workSnkSVlan").firstChild.value = svlan;
        $("protectSnkSVlan").firstChild.innerHTML = svlan;
    }
}

function changeSnkSVlan()
{
    $("applybtn").disabled = false;
    var svlan = this.value;
    $("protectSnkSVlan").firstChild.innerHTML = svlan;
    
    var element = $("workOperation").firstChild;
    if (OPERATION_TRANSMIT_SVLAN_VALUE == element.options[element.selectedIndex].value)
    {
        $("workSrcSVlan").firstChild.value = svlan;
        $("protectSrcSVlan").firstChild.innerHTML = svlan;
    }
}

/*
 *        VLan       VLAN
 * isSrcVlan 0    1   
 */
function changePVlan(isSrcVlan)
{
    $("applybtn").disabled = false;
    var targetElm = getEventSrc();
    
    if(!isSrcVlan)
    {        
        $("workSinkVlanId").firstChild.value = targetElm.value;
    }
    else
    {       
        $("workSVlanId").firstChild.value = targetElm.value;
    }
    $("protectSVlanId").firstChild.innerHTML = targetElm.value;
    $("protectSinkVlanId").firstChild.innerHTML = targetElm.value;
}

/*
 *         
 */
function getEventSrc()
{
    var e = window.event;
    
    var targetElm = (e.target) ? e.target : e.srcElement;
    
    return targetElm;
}

/*
 *      SNCP          
 */
function setStatus(state)
{
    $("workDeriction").firstChild.disabled = state;
    
    $("workSource").firstChild.disabled = state;
    
    $("protectSource").firstChild.disabled = state;
    
    $("workSVlanId").firstChild.disabled = state;
    
    $("workSink").firstChild.disabled = state;
    
    $("workSinkVlanId").firstChild.disabled = state;
    
    $("okbtn").disabled = state;
    
    $("applybtn").disabled = state;
    
}
/*
 *      vlanid    
 */
function isValidateVlanID()
{               
    var key,keychar;    
    var key=(event.keyCode!=0?event.keyCode:event.charCode);
    
    keychar = convertChar(key);
    
    if((key == null) || (key == 0) || (key == 9) || (key == 13) || (key == 27))
    { 
        return true;
    }
    else if(isValidateInput(key))
    {
        return true;
    }
    else if((isValidateChar(key))&& restrictVlanID(this, keychar))
    {       
        return true;
    }
    else
    {
        return false;
    }
}

/*
 * 
 */
function isValidateInput(code)
{   
        
    if(code > 34 && code < 41)
    {
        return true;        //   ,home,end
    }

    if(event.shiftKey || event.ctrlKey)
    {
        return false;
    }
    if(code < 48 || code > 57 )
    {
        
        return false;  //   
    }
}

/*
 *       "0123456789,-"
 */
function isValidateChar(code)
{
     if( (47 < code && 58 > code ) || (44 == code) || (45 == code) )
     {
        
        return true;  //  
     }
     if(code == 8 || code == 46 || code == 9)
     {
        return true;   //DEL   
     }
     return false;
     
}

/*
 *  key       
 */
function convertChar(code)
{
    var keyChar;
    
    if(45 == code)
    {
        keyChar = '-';
    }
    else if(44 == code)
    {
        keyChar = ',';
    }
    else if(47 < code && 58 > code)
    {
        keyChar = code - 48;
    }
    else if(95 < code && 106 > code)
    {
        keyChar = code - 96;
    }
    else
    {
        keyChar = "ch" + code;
    }
    return keyChar;
}

/*
 * vlanID      
 *         
 */
function restrictVlanID(obj, ch)
{
    
    var posStart;
    var posEnd;
    
    if(isIE)
    {
        var selectRng = document.selection.createRange();
        selectRng.text = "";
        var pos = digitalTag_getPos(obj);
        posStart = pos;
        posEnd = pos;
    }
    else
    {
        posStart = obj.selectionStart;
        posEnd = obj.selectionEnd;
    }
    

    
    
    
    
    
    
   
    
    if("," == ch || "-" == ch)
    {
        
        if(0 == posStart)
        {
            return false;
        }
        else if("," == obj.value.charAt(posStart-1) || "-" == obj.value.charAt(posStart-1)
            || "," == obj.value.charAt(posStart) || "-" == obj.value.charAt(posStart))
        {
            return false;
        }
    }
    if("0" == ch)
    {
        if( (obj.value.substring(posEnd).length > 0) && ((posStart == 0) || "-" == obj.value.charAt(posStart-1) || "," == obj.value.charAt(posStart-1)))
        {
            return false;
        }
        else
        {
            var v1 = obj.value.substring(0,posStart);
            var v2 = obj.value.substring(posEnd);
            
            var str1 = "";
            var str2 = "";
            
            if(v1.length >= 1)
            {
                if(v1.lastIndexOf("-") >= 0)
                {
                    var v3 = v1.substring(v1.lastIndexOf("-")+1);
                    if(v3.length >= 1)
                    {
                        if(v3.lastIndexOf(",") >= 0 )
                        {
                            str1 = v3.substring(v3.lastIndexOf(",")+1);
                        }
                        else
                        {
                            str1 = v3;
                        }
                    }
                }
                else if(v1.lastIndexOf(",") >= 0)
                {
                    str1 = v1.substring(v1.lastIndexOf(",")+1);
                }
                else
                {
                    str1 = v1;              
                }
            }
            
            if(str1.indexOf("0") == 0)
            {
                return false;
            }
            
            
        }
    }
    if("123456789".indexOf(ch) >= 0 )
    {
        var v1 = obj.value.substring(0,posStart);
        var v2 = obj.value.substring(posEnd);
        if(v1.length >= 1)
        {
            if(v1.lastIndexOf("-") >= 0 )
            {
                var v3 = v1.substring(v1.lastIndexOf("-")+1);
                if(v3.length == 1 && v3 == "0")
                {
                    obj.value = obj.value.substring(0, posStart-1) + obj.value.substring(posEnd);
                }
            }
            else if(v1.lastIndexOf(",") >= 0)
            {
                var v4 = v1.substring(v1.lastIndexOf(",")+1);
                if(v4.length == 1 && v4 == "0")
                {
                    obj.value = obj.value.substring(0, posStart-1) + obj.value.substring(posEnd);
                }
            }
            else if(v1.length == 1 && v1 == "0")
            {
                obj.value = obj.value.substring(posEnd);
                return true;
            }
        }
    }
    if("0123456789".indexOf(ch) >= 0 || "ch8" == ch || "ch9" == ch || "ch46" ==ch)
    {
        var v1 = obj.value.substring(0,posStart);
        var v2 = obj.value.substring(posEnd);
        
        var str1 = "";
        var str2 = "";
        if(v1.length >= 1)
        {
            if(v1.lastIndexOf("-") >= 0)
            {
                var v3 = v1.substring(v1.lastIndexOf("-")+1);
                if(v3.length >= 1)
                {
                    if(v3.lastIndexOf(",") >= 0 )
                    {
                        str1 = v3.substring(v3.lastIndexOf(",")+1);
                    }
                    else
                    {
                        str1 = v3;
                    }
                }
            }
            else if(v1.lastIndexOf(",") >= 0)
            {
                str1 = v1.substring(v1.lastIndexOf(",")+1);
            }
            else
            {
                str1 = v1;              
            }
        }
        if(v2.length >= 1)
        {
            if(v2.indexOf("-") >= 0)
            {
                var v4 = v2.substring(0, v2.indexOf("-"));
                if(v4.length >= 1)
                {
                    if(v4.indexOf(",") >= 0 )
                    {
                        str2 = v4.substring(0, v4.indexOf(","));
                    }
                    else
                    {
                        str2 = v4;
                    }
                }
            }
            else if(v2.indexOf(",") >= 0)
            {
                str2 = v2.substring(v2.indexOf(",")+1);
            }
            else
            {
                str2 = v2;
            }
        }

        if((parseInt(str1 + ch + str2) > MAXINPUT)||(parseInt(str1 + ch + str2)==0))
        {
            
            alert(RESOURCE["ID_NUMLEFT"]+MININPUT+RESOURCE["ID_NUMMIDDLE"]+MAXINPUT+RESOURCE["ID_NUMRIGHT"]);
            return false;
        }
    }
    return true;
}

/*
 *       
 */
function clearPortTable()
{
    for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
    {
        portAttrTable.deleteRow(i);
    }
    portAttrTable.adjustDataRows();
}

/*
 *          
 *                
 *            
 */
function refreshPortTable()
{
    $("applybtn").disabled = false;
    
    clearPortTable();

    var wspElement = $("workSource").firstChild;
    var workSrcPort = wspElement.options[wspElement.selectedIndex].value;
    
    var pspElement = $("protectSource").firstChild;
    var protectSrcPort = pspElement.options[pspElement.selectedIndex].value;
    
    var wsnpElement = $("workSink").firstChild;
    var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
    
    var ports = new Object();
    ports[srcPortsOfUse[workSrcPort].portno] = srcPortsOfUse[workSrcPort];
    ports[srcPortsOfUse[protectSrcPort].portno] = srcPortsOfUse[protectSrcPort];
    ports[snkPortsOfUse[workSnkPort].portno] = snkPortsOfUse[workSnkPort];

    var portData = createPortData(ports); 

    createGenCfgTableBody(portAttrTable, window.tableconf[0], portData);  
    
    
    if(!portAttrTable.element.colsArray.selectedId)
      {
         portAttrTable.element.colsArray.selectedId = "port";
         portAttrTable.element.colsArray.imgflag = 1;
      }
      var td=portAttrTable.element.headRow.element.cols[portAttrTable.element.colsArray.selectedId].element; 
      portAttrTable.sortRows(td,portAttrTable.element.colsArray.imgflag);
      
      setTagCellEdit();
}

function setTagCellEdit()
{
    for(var i = 0,len = portAttrTable.getDataRowLength();i < len; i++)
    {
        var portType = portAttrTable.getCellStoreValue(i,"portType","portType");
        var tagCell = portAttrTable.getCell(i,"tagIdentifier");
        if(portType == PORT_TYPE_UNI_VALUE)
        {
            tagCell.element.disabled = false;
            tagCell.element.style.backgroundColor = "#ffffff";
            portAttrTable.setCellValue(tagCell, "tagIdentifier", PORT_TAG_TAG_AWARE_VALUE);
            portAttrTable.setAtomValue(tagCell.element.showElement, TagIdentifier["TAGAWARE"]);
        }
        else
        {
            tagCell.element.modify = false;
            portAttrTable.setCellIsEdit(tagCell, 0);
            tagCell.element.ondblclick = null;
            tagCell.element.style.cursor = "";
            tagCell.element.style.backgroundColor = "";
            portAttrTable.setCellValue(tagCell, "tagIdentifier", "-");
            portAttrTable.setAtomValue(tagCell.element.showElement,"-");
        }
    }
}

/*
 *         onchange  
 */
function registerPortTypeEvent()
{
    for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
    {
        var pTypeAtom = portAttrTable.getCellEdit(i, "portType");
        pTypeAtom.element.onchange = function()
        {
            this.style.display = "none";
            this.parentNode.showElement.element.style.display   =   "";
            
            for( var j = 0, jLen = portAttrTable.getDataRowLength(); j < jLen; j++)
            {
                var pTypeCell = portAttrTable.getCell(j, "portType");   
                
                pTypeCell.element.showElement.setValue(PortType[this.value]);
                pTypeCell.element.modify = true;
                pTypeCell.element.parentNode.modify = true;
                pTypeCell.element.style.backgroundColor="#d0f946";
                pTypeCell.element.parent.setTdCellValue(pTypeCell.element, this.parentNode.colid, this.value);          
                pTypeCell.element.showElement.element.style.display =   "";
                handleCellEdit(pTypeCell.element,TABLE_CONSTANT.AFTEREDIT); 
            }
        }
    }
} 

/*
 *               datainterface
 * @param ports Object   portno   TEPort  
 * @return Datainterface
 */
function createPortData(ports)
{
    var datainterface = new DataInterface();
    
    for(var key in ports)
    {
        
        queryPortAttr(ports[key]);
        
        var obj = new Object();
                
        var ptag1 = new ParamTag();
        ptag1.value = ports[key].portName;      
        obj["port"] = ptag1;
        
        var ptag5 = new ParamTag();
        ptag5.value = ports[key].portno;
        obj["portno"] = ptag5;
        
        var ptag6 = new ParamTag();
        ptag6.value = ports[key].portTypeFlag;
        obj["portTypeFlag"] = ptag6;
        
        var ptag2 = new ParamTag();
        ptag2.value = ports[key].portType;
        var serviceTypeSelect = $("workType").firstChild;
        var serviceType = serviceTypeSelect.options[serviceTypeSelect.selectedIndex].value;
        var operationType = null;
        
        var wsnpElement = $("workSink").firstChild;
        var workSnkPort = wsnpElement.options[wsnpElement.selectedIndex].value;
        var snkPortNO = snkPortsOfUse[workSnkPort].portno;
        if(SERVICE_TYPE_EPL == serviceType)
        {
            ptag2.value = PORT_TYPE_UNI_VALUE;
        }
        else if(key == snkPortNO)
        {
            var element = $("workOperation").firstChild;
            operationType = element.options[element.selectedIndex].value;
          
            if(OPERATION_STRIP_SVLAN_VALUE == operationType)
            {
                ptag2.value = PORT_TYPE_C_AWARE_VALUE;
            }
            else
            {
                ptag2.value = PORT_TYPE_S_AWARE_VALUE;
            }       
        }
        else
        {
            var element = $("workOperation").firstChild;
            operationType = element.options[element.selectedIndex].value;
            if(OPERATION_ADD_SVAN_VALUE == operationType)
            {
                ptag2.value = PORT_TYPE_C_AWARE_VALUE;
            }
            else
            {
                ptag2.value = PORT_TYPE_S_AWARE_VALUE;
            }
        }
        obj["portType"] = ptag2;
        var ptag3 = new ParamTag();
        ptag3.value = ports[key].portEnable;
        obj["portDisabled"] = ptag3;
        
        var ptag4 = new ParamTag();
        ptag4.value = ports[key].portTag;
        obj["tagIdentifier"] = ptag4;                       
                        
        datainterface.rows[datainterface.rows.length] = obj; 
    }
    return datainterface;
}

/*
 *       
 */
function queryPortAttr(port)
{
    var xmlData = queryPortAtrrXml(port);
    var URL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&nmUser="+win["nmUser"]; 
    loadXMLdoc(URL,"POST",false,callbackQueryPortAttr,port,"inputdata="+xmlData);
}

/*
 *            
 */
function callbackQueryPortAttr(doc, port)
{
    var portAttrData = EncapsulateData(doc);
    showErrorDialog(portAttrData);
	var boardName = portAttrData.getDataRowParam(0, "shelfName") + "-"
			+ portData.getDataRowParam(0, "boardName");
	$("workBoard").innerHTML = boardName;
	$("workBoard").style.color = "000000";
	$("protectBoard").innerHTML = boardName;
	$("protectBoard").style.color = "000000";
    if (0 == portAttrData.getSErrorCode() && 0 < portAttrData.getDataRowLength()) 
    {    
          if ( "0" == port.portTypeFlag )
          {
              port.portType = PORT_TYPE_UNI_VALUE;//2
              port.portEnable = portAttrData.getDataRowParam(0, "PORTENABLE"); 
              port.portTag = portAttrData.getDataRowParam(0, "TAGTYPE");         
          }    
          else
          {
              port.portType = PORT_TYPE_UNI_VALUE;//2
              port.portTag = portAttrData.getDataRowParam(0, "TAGTYPE");         
          }
     }
}

/*
         
 */
function queryPortAtrrXml(port)
{
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row=new tagElement("row-params");

    var param=new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj.neid);
    row.appendChild(param);
   
    param=new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",winurlobj.slotid);
    row.appendChild(param);
    
    param=new tagElement("param");
    param.setAttribute("name","portid");
    param.setAttribute("value",port.portno);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    
    return root.toString();
}
