 /**
 * VLAN     convert    ,      
 *   : c00104334
 *   : 2008-08-28
 */
 
var FORCESWITCHCMD = "FRCD"; //    14
var MANUALSWITCHCMD = "MAN"; //    7
var LOCKSWITCHCMD = "LOCKOUT"; //    15
var CLEARSWITCHCMD = "16"; //    16

var NORSTATUS = "0";  //    
var LOCKSWITCHSTATUS = "15"; //      
var FORCESWITCHSTATUS = "14"; //      
var MANUALSWITCHSTATUS = "7"; //      
var WTRSTATUS = "5";  //      
var SFSWITCHSTATUS = "12"; //SF  

var WORKPATH = "master";
var PROTECTPATH = "slave";


var ActStatus = new Object();
ActStatus["DISABLE"] = "deactivated";
ActStatus["ENABLE"] = "activated";

var WrtMode = new Object();
WrtMode["N"] = "nonresume";
WrtMode["Y"] = "resume";
var WRTMODE_VALUE_N = "N";//     
var WRTMODE_VALUE_Y = "Y";//    

var WRTTIME_DBCLICK_DEFAULT = "6";
var WRTTIME_NO_RESUME_DEFAULT = "0";

var WRTTIME_MAX = "720";
var WRTTIME_MIN = "6";

HOLDTIME_MAX = "100";
HOLDTIME_MIN = "0";

/**
  vlan sncp    
IDLE	Idle
WTR	Wait to restore
AUTO_SW	Automatic switch
MAN_P_W	Manually switch to the working unit
MAN_W_P	Manually switch to the protecting unit
FRC_P_W	Forced switch to the working unit
FRC_W_P	Forced switch to the protecting unit
LOCKOUT	Lock to the working unit
CLEAR	Clear
INVALID	Invalid
*/
var swStatusObj = new Object();
swStatusObj["IDLE"] = "norStatus";//    
swStatusObj["WTR"] = "wtrStatus";//      
swStatusObj["AUTO_SW"] = "autoStatus";//      
swStatusObj["MAN_P_W"] = "manualStoA";//  (     )    
swStatusObj["MAN_W_P"] = "manualAtoS";//  (     )    
swStatusObj["FRC_P_W"] = "forceStoA";//  (     )    
swStatusObj["FRC_W_P"] = "forceAtoS";//  (     )    
swStatusObj["LOCKOUT"] = "lockStatus";//      
swStatusObj["CLEAR"] = "clear";//  
swStatusObj["INVALID"] = "unknown";//    

var SWSTATUS_QUERY = "QUERY";
var SWSTATUS_AUTO_SW = "AUTO_SW";
var SWSTATUS_MAN_P_W = "MAN_P_W";
var SWSTATUS_MAN_W_P = "MAN_W_P";
var SWSTATUS_FRC_P_W = "FRC_P_W";
var SWSTATUS_FRC_W_P = "FRC_W_P";
var SWSTATUS_LOCKOUT = "LOCKOUT";
var SWSTATUS_CLEAR = "CLEAR";



var linkStatus = new Object();
linkStatus["normal"] = "normallink";
linkStatus["SF"] = "sflink";
linkStatus["UNKNOWN"] = "unknown";

var curWorkLinkObj = new Object();
curWorkLinkObj["master"] = "workpath";//1
curWorkLinkObj["slave"] = "protectpath";//2
curWorkLinkObj["UNKNOWN"] = "unknown";//255

var LinkType = new Object();
LinkType["EPL"] = "EPL";
LinkType["EVPL"] = "EVPL(QinQ)";

var SERVICE_TYPE_EPL = "EPL";
var SERVICE_TYPE_EVPL = "EVPL(QinQ)";

var SERVICE_TYPE_EPL_VALUE = "EPL";
var SERVICE_TYPE_EVPL_VALUE = "EVPL";

var DIRECTION_BIDIRECTION = "Bidirectional";//1
var DIRECTION_UNILATERALISM = "Unidirectional";//0

var DIRECTION_BIDIRECTION_VALUE = "2WAY";
var DIRECTION_UNILATERALISM_VALUE = "1WAY";

var OPERATION_TRANSMIT_SVLAN_VALUE = 1;
var OPERATION_TRANSLATE_SVLAN_VALUE = 2;
var OPERATION_STRIP_SVLAN_VALUE = 3;
var OPERATION_ADD_SVAN_VALUE = "Add S-VLAN";
var OPERATION_TRANSMIT_CVLAN_VALUE = "Transparently transmit C-VLAN";

var operTypeConvert = [];
operTypeConvert[OPERATION_TRANSMIT_SVLAN_VALUE] = RESOURCE["TransparentlyTransmitSVLAN"];
operTypeConvert[OPERATION_TRANSLATE_SVLAN_VALUE] = RESOURCE["TranslateSVLAN"];
operTypeConvert[OPERATION_STRIP_SVLAN_VALUE] = RESOURCE["StripSVLAN"];
operTypeConvert[OPERATION_TRANSMIT_CVLAN_VALUE] = RESOURCE["TransparentlyTransmitCVLAN"];
operTypeConvert[OPERATION_ADD_SVAN_VALUE] = RESOURCE["AddSVLAN"];

var OPRSUCC = 0;//    
var OPRFAIL = 2;//    
var OPR_PART_SUCCESS = 1;//    

var TagIdentifier = new Object();
TagIdentifier["ACCESS"] = "Access";//   //0
TagIdentifier["TAGAWARE"] = "Tag Aware";//10M   //1
TagIdentifier["HYBRID"] = "Hybrid";//10M   //2
TagIdentifier["3"] = "No Tag Aware";//100M   //3
TagIdentifier["-"] = "-";//   

var PORT_TAG_ACCESS_VALUE = "ACCESS";
var PORT_TAG_TAG_AWARE_VALUE= "TAGAWARE";
var PORT_TAG_HYBRID_VALUE = "HYBRID";//2
var PORT_TAG_UNVAID_VALUE = "-";

var PortType = new Object();
PortType["UNI"] = "UNI";//2
PortType["CAWARE"] = "C-Aware";//5
PortType["SAWARE"] = "S-Aware";//6
PortType["255"] = "-";

var PORT_TYPE_UNI = "UNI";
var PORT_TYPE_C_AWARE = "C-Aware";
var PORT_TYPE_S_AWARE = "S-Aware";

var PORT_TYPE_UNI_VALUE = "UNI";//2
var PORT_TYPE_C_AWARE_VALUE = "CAWARE";//5
var PORT_TYPE_S_AWARE_VALUE = "SAWARE";//6

var PortDisabled = new Object();
PortDisabled["N"] = RESOURCE["disabled"];
PortDisabled["Y"] = RESOURCE["enabled"];
PortDisabled["-"] = "-";

var PORT_ENABLE_Y = RESOURCE["enable"];
var PORT_ENABLE_N = RESOURCE["disabled"];

var PORT_ENABLE_Y_VALUE = "Y";
var PORT_ENABLE_N_VALUE = "N";

function wrtTimeFormat(wtrTime)
{
	if (isNaN(wtrTime) || wtrTime == "" || wtrTime == null || wtrTime == undefined
		|| wtrTime == "0")
    {
        return "-";
    }
    else
    {
        var curtime = parseInt(wtrTime,10);
        
        var mins = parseInt((curtime / 60) , 10);
        var secs = curtime % 60;
        
        mins = mins.toString();
        secs = secs.toString();
        
        if (mins.length < 2)
        {
        	mins = "0" + mins;
        }
        
        if (secs.length < 2)
        {
        	secs = "0" + secs;
        }
        
        return mins + ":" + secs;
    }
}
