var win = getParentWindow(); 
var neid = win["neid"];
var slot = win["slotid"];
var nmUser = win["nmUser"];
var defaultMac = "00-00-00-00-00-00";
var st;

function initPage()
{
	
	$("startlbbtn").value = RESOURCE["startlbbutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	initTable();
	initData();
}

function initTable()
{
	st = new SortTable();
	
    st.setImage("../../../../../../images/");
    
    createTableHead(st, window.tableconf[0]);   
    
    $("tablecomponent").appendChild(st.getTable());
    
    st.setBodyHeight(getComponetHeight($("tablecomponent"),100)+"px");
    $("srcmp").onkeypress = function(){
       return restrict("", window.event, "0123456789");            
    }
    $("snkmp").onkeypress = function(){
       return restrict("", window.event, "0123456789");            
    }
}

function initData()
{
	
	var rowIndex = win.st.getSelectedRows()[0];
	var srcmpid = win.st.getCellStoreValue(rowIndex, "mpid", "mpid");
	var mdid = win.st.getCellStoreValue(rowIndex, "mdid", "mdid");
	if(mdid == 0||mdid==null||mdid=="NULL")
	{
		$("bymac").disabled = true;
	}
	
	$("srcmp").value = srcmpid;
	$("snkmp").value = "00-00-0000";

	checkFormat($("srcmp"));	
	checkFormat($("snkmp"));
}

function createLBTestXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel = new tagElement("row-params");	
	var	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "slotid");
	thirdlevel.setAttribute("value", slot);
	secondlevel.appendChild(thirdlevel);
	
	var snkmp = $("snkmp").value;
	var snkmpArr = snkmp;
	var snkmpStr = "";
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "byMac");
	if($("bymac").checked)
	{
		snkmpStr = snkmpArr;
		thirdlevel.setAttribute("value", "MACADDR");
		secondlevel.appendChild(thirdlevel);
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "snkmp");
		thirdlevel.setAttribute("value", snkmpStr);
		secondlevel.appendChild(thirdlevel);
	}
	else
	{
		snkmpStr = snkmpArr;
		thirdlevel.setAttribute("value", "MP");
		secondlevel.appendChild(thirdlevel);
		mpids = snkmpStr.split("-");
		thirdlevel = new tagElement("param");	
		thirdlevel.setAttribute("name", "snkmp");
		thirdlevel.setAttribute("value", mpids[0] + mpids[1] + mpids[2]);
		secondlevel.appendChild(thirdlevel);
	}
	
	
	var srcmp = $("srcmp").value;
	var mpids = srcmp.split("-");
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "srcmp");
	thirdlevel.setAttribute("value", mpids[0] + mpids[1] + mpids[2]);
	secondlevel.appendChild(thirdlevel);
	
	var snkmp = $("snkmp").value;

		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function startLBTest()
{
	if(!checkSubmit($("srcmp").value))
	{
		return;
	}
	
	if(!$("bymac").checked && !checkSubmit($("snkmp").value))
	{
		return;
	}
	else if($("bymac").checked && !checkUniCastMAC($("snkmp").value))
	{
		$("snkmp").value = defaultMac;
		return;
	}
	
	$("startlbbtn").disabled = true;	
	
	var xml = createLBTestXML();
	var url = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_SET_LBTEST+"&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", true, callBackHandler, null, "inputdata=" + xml);
}

function callBackHandler(doc)
{
	var data = EncapsulateData(doc);
    showErrorDialog(data);

    if (0 == data.getSErrorCode())
    {
		st.clearTableData();		
		createTableBody(st, window.tableconf[0], data, RESOURCE);
		for (var i = 0; i < st.getDataRowLength(); i++)
		{			
			var result = st.getCellStoreValue(i, "testresult", "testresult");
			if (result != "SUCCESS")
			{
				var cell = st.getCell(i, "testresult");
				cell.element.style.backgroundColor = "red";
			}
		}
    }
    $("startlbbtn").disabled = false; 
}

function showErrorDialog(data)
{
	var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}



function testByMac()
{
	if($("bymac").checked)
	{
		$("sink").innerHTML = RESOURCE["lttestsnkmac"];
		checkMACAddEvent($("snkmp"));
		$("snkmp").value = defaultMac;
		st.clearTableData();
		st.getHeadCell("lsnkmp").element.innerHTML="<span>" + RESOURCE["snkMPMACTitle"] + "</span>";
	}
	else
	{
		$("sink").innerHTML = RESOURCE["lbtestsnkmp"];
		checkFormat($("snkmp"));
		$("snkmp").value = "00-00-0000";
		st.clearTableData();
		st.getHeadCell("lsnkmp").element.innerHTML="<span>" + RESOURCE["snkMPIDTitle"]  + "</span>";
	}
}


function checkUniCastMAC(macStr)
{
	var firstMac = macStr.toUpperCase().split("-")[0];
	firstMac = parseInt(firstMac,16);
	if (firstMac%2 == 1)
	{
		alert(RESOURCE["unicasterralert"]);
		return false;
	}	
	return true;
}
