 var winurlobj = new Object();
winurlobj = getNeProperty(self);

var st = new SortTable();
var flowobjs = new Array();

/**
 * initialize this page
 * 
 * @param data:
 *            NO
 * @return NO
 */
function init()
{
	initCalendarRes();
	initCalendar();
	initTime();
	initButton();

	var xmlstr = createInitFlowListXML();
	loadXMLdoc("../../../../../../tl1NEExlorerServlet?sfid="
			+ TE_ETHER_QUERY_FLOW_RES, "POST", false, initFlowList, null,
			"inputdata=" + xmlstr);

	initTable();
	sendQueryRequest();
}

function initCalendarRes()
{
	var script = document.createElement("script");
	script.src = "../../../../../../script/thirdparty/calendar-"
			+ SYSTEMCONF.getLanguage() + ".js"
	document.body.appendChild(script);
}

function initCalendar()
{
	Calendar.setup( {
		inputField :"begintime",
		showsTime :true,
		timeFormat :"24",
		button :"btn_begintime",
		singleClick :true,
		dstField :"begintimedst"
	});
	Calendar.setup( {
		inputField :"endtime",
		showsTime :true,
		timeFormat :"24",
		button :"btn_endtime",
		singleClick :true,
		dstField :"endtimedst"
	});
}

function initTime()
{
        var tmpDate = new Date();
	tmpDate.setHours(0, 0, 0);
	
	var beginTime = new Date(tmpDate.getTime() - 1000 * 60 * 60 * 24);
	$("begintime").value = createTime(beginTime);
	Calendar.refreshDST($("begintimedst"), beginTime);
	
	var endTime = tmpDate;
	$("endtime").value = createTime(endTime);
	Calendar.refreshDST($("endtimedst"), endTime);
}

function initTable()
{
	st = new SortTable();
	st.setImage("../../../../../../images/");

	createTableHead(st, window.tableconf[0]);

	st.setBodyHeight(360);
	st.setWidth(800);
	st.setSingleChoiceFlg(true);

	$("flowtable").appendChild(st.getTable());
	if(dataTotal != null)
	{
		createTableBody(st, window.tableconf[0], dataTotal, RESOURCE);
	}
}

function initButton()
{
	$("queryBtn").value = RESOURCE["querybutton"];
	$("printBtn").value = RESOURCE["printbutton"];
	$("saveAsFileBtn").value = RESOURCE["saveasfilebtn"];


}

function refreshImage()
{
	var neid = winurlobj["neid"];
	var slotid = winurlobj["slotid"];
	var portid = winurlobj["portid"];

	var urlreq = "../../../../../../specialAppServlet?sfid="
			+ TE_ETHER_QUERY_FLOW_HISDATA_PIC + "&neid=" + neid + "&slotid="
			+ slotid + "&portid=" + portid + "&timeStamp="
			+ new Date().getTime();

	var image = $("flowgraph");

	image.src = urlreq;
}

function createInitFlowListXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	addParam(row, newParam("neid", winurlobj["neid"]));
	addParam(row, newParam("slotid", winurlobj["slotid"]));
	addParam(row, newParam("flowid", "ALL"));
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function initFlowList(doc)
{
	var dinterface = EncapsulateData(doc);

	if (0 != dinterface.getSErrorCode())
	{

		if (dinterface.getSErrorCode() != -1)
		{
		}

		return;
	}

	var sel = $("flowobject");
	var newObj;

	for ( var i = 0; i < dinterface.getDataRowLength(); i++)
	{
		var obj = dinterface.rows[i];
		if(obj["monitorstatus"] != null && obj["monitorstatus"].value == "0")
		{
			continue;
		}
		newObj = document.createElement("option");
		sel.options.add(newObj);

		
		newObj.innerText = obj["monObject"].value;
		newObj.value = obj["flowid"].value;
	}
	if(sel.options.length == 0)
	{
		newObj = document.createElement("option");
		sel.options.add(newObj);
		newObj.innerText = "No FlowID";
		newObj.value = -1;
	}
}

window.onresize = function()
{
	st.setBodyHeight(getComponetHeight($("flowtable"), 20) + "px");
}

function refreshView()
{

	if (document.getElementById("list").checked)
	{
		$("flowimg").style.display="none";
		$("flowtable").style.display="";
		$("printbtn").disabled = false;
		$("saveasfilebtn").disabled = false;
	}
	else
	{
		$("flowimg").style.display="";
		$("flowtable").style.display="none";
		$("printbtn").disabled = true;
		$("saveasfilebtn").disabled = true;
		refreshImage();
	}

}

function printAll()
{
	if (st.getDataRowLength() <= 0)
	{
		alert(RESOURCE["nodata"]);
		return;
	}
	openPrintPage("../../../../../../page/", RESOURCE["sttitle"],"st");
}

function saveAs()
{
	if (st.getDataRowLength() <= 0)
	{
		alert(RESOURCE["nodata"]);
		return;
	}
	openSaveAsPage("../../../../../../page/", RESOURCE["sttitle"],"st");
}

/**
 * operate query
 * 
 * @param data:no
 * @return no
 */
function sendQueryRequest()
{
	if($("flowobject").options[$("flowobject").selectedIndex].value == "-1")
	{
		return;
	}
	var fromDate = getTimeFromString(document.getElementById("begintime").value);
	var toDate = getTimeFromString(document.getElementById("endtime").value);
	if(fromDate > toDate)
	{
	    alert(RESOURCE["timeorderwrong"]);
	    return;
	}
	
	if(toDate - fromDate > 2592000000)
	{
	    alert(RESOURCE["timeErr"]);
	    return;
	}
	
        if($('flowobject').options.length == 0)
        {
            return;
        }
        
	var xmlstr = createQueryTableXML();

	var urlreq = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TE_ETHER_QUERY_FLOW_HISDATA + "&timeStamp="
			+ new Date().getTime();
	loadXMLdoc(urlreq, "POST", true, updateTable, null, "inputdata=" + xmlstr);
}

function createQueryTableXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	addParam(row, newParam("neid", winurlobj["neid"]));
	addParam(row, newParam("slotid", winurlobj["slotid"]));

	var sel = $("flowobject");
	addParam(row, newParam("flowid", sel.options[sel.selectedIndex].value));

	var date = $("begintime").value;
	addParam(row, newParam("begindate", date));

	date = $("endtime").value;
	addParam(row, newParam("enddate", date));
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}
var dataTotal = null;
function updateTable(doc)
{
	dataTotal = EncapsulateData(doc);
	if (0 != dataTotal.getSErrorCode())
	{
		if (dataTotal.getSErrorCode() != -1)
		{
			showErrorDialog(dataTotal);
		}

		return;
	}
	refreshImage();
	st.clearTableData();// clear rsvpTable data

	if(dataTotal != null)
	{
		createTableBody(st, window.tableconf[0], dataTotal, RESOURCE);
	}
}

function newParam(name, value)
{
	var param = new tagElement("param");
	param.setAttribute("name", name);
	param.setAttribute("value", value);
	return param;
}

function addParam(row, param)
{
	row.appendChild(param);
}

/**
 *       
 */
function showErrorDialog(data)
{
        var errArr = [];
        errArr[0] = "nename";
        errArr[1] = "slotID";
        errArr[2] = "boardname";
        errArr[3] = "opticalID";
        openErrPage("../../../../../../page/", data.getError(), errArr);
        errArr = null;
}
