 var protocolType = new Object();
protocolType[1] = "802.1agOAM";
protocolType[2] = "802.3ahOAM";
protocolType[3] = "LAG";
protocolType[4] = "DLAG";
protocolType[5] = "RSTP";
protocolType[6] = "IGMP Snooping";

var urlObject = getNeProperty(self);//the URL object of this page 
var neID = urlObject.neid; //network element id
var slotID = urlObject.slotid; //slot id
var nmUsrID = urlObject.nmUser ;//network manager userID, write operation log and check right
var nmUserName = urlObject.nmUserName ;//network manager userName

var btnRightArr = new Object();//save to button right

/**
 * initialize this page
 * @param no
 * @return no
 */
function initPage()
{	
	initButton();//initialize buttons
	
	document.getElementById("protocoltypelabel").innerHTML = RESOURCE["protocoltypelabel"];
	document.getElementById("faultlable").innerHTML = RESOURCE["faultlable"];
	
	initProtocolType();//initialize protocol type
	
	var rightURL = "../../../../../../securityServlet?neID=" + neID + "&nmUser=" + nmUsrID;
	getRightInfo(urlObject, btnRightArr);//call the function which come from the right.js file, get function right;
	
	document.getElementById("faultbtn").disabled = !btnRightArr.faultbtn.right;
	document.getElementById("resumebtn").disabled = !btnRightArr.resumebtn.right;
}

/**
 * initialize butons
 * @param no
 * @return no
 */
function initButton()
{
	document.getElementById("faultbtn").value = RESOURCE["faultbtn"];
	document.getElementById("resumebtn").value = RESOURCE["resumebtn"];
	
    btnRightArr.faultbtn = new BtnRightObj("faultbtn",TECMDCODE_IP_PROTOCOL_DIAGNOSIS);//come form macrores.js
    btnRightArr.resumebtn = new BtnRightObj("resumebtn", TECMDCODE_IP_PROTOCOL_RESTORE);//come form macrores.js
}

/**
 * initialize protocol type
 * @param no
 * @return no
 */
function initProtocolType()
{
	var protocolTypeEle = document.getElementById("protocolType");
	
	for(i in protocolType)
	{
		protocolTypeEle.options[protocolTypeEle.options.length] = new Option(protocolType[i], i);
	}
}

/**
 * click to resumebtn
 * @param no
 * @return no
 */
function doProtocolResume()
{
	setButtonStatus(false);
	
	var xmlData = constructProtocolResumeXML();//construct the xml of protocol resume 
	var resumeURL = "../../../../../tl1NEExlorerServlet?sfid=" + TECMDCODE_IP_PROTOCOL_RESTORE +"&nmUser="+nmUsrID;//? come form macrores.js
	loadXMLdoc(resumeURL, "POST", true, handleProtocolResumeBack, null, "inputdata="+xmlData);//send protocol resume request      	
}

/**
 * construct the xml of protocol resume 
 * @param no
 * return xml
 */
function constructProtocolResumeXML()
{
	var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");  
    
    var thirdlevel = new tagElement("param");              
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",neID);
    secondlevel.appendChild(thirdlevel); 
    
    var faultaid = "SLOT-"+slotID;
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "AID");
    thirdlevel.setAttribute("value", faultaid);
    secondlevel.appendChild(thirdlevel);
    
    var protocolTypeEle = document.getElementById("protocolType");
    var protocolTypeValue = protocolTypeEle.options[protocolTypeEle.selectedIndex].value
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "PROTTYPE");
    thirdlevel.setAttribute("value", protocolType[protocolTypeValue]);      
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
}

/**
 * handle protocol resume callback
 * @param doc
 * @return no
 */
function handleProtocolResumeBack(doc)
{
	var data = EncapsulateData(doc);
	
	setButtonStatus(true);
	
	if( 0 == data.getSErrorCode() )
	{
	    var error = new AllError();
		var eTag = new ErrorTag();
		eTag.code = "succ";
		eTag.info = RESOURCE["optSucc"];
		error.s_error = eTag;
		openErrPage("../../../../../page/", error, ""); 
	}
	else
	{
		handleErrInfo(data);
	}
}

/**
 * click to faultbtn
 * @param no
 * @return no
 */
function doFaultDiagnose()
{
	setButtonStatus(false);
	
	var xmlData = constructFaultDiagnoseXML();//construct the xml of protocol resume 
	var faultURL = "../../../../../tl1NEExlorerServlet?sfid=" + TECMDCODE_IP_PROTOCOL_DIAGNOSIS +"&nmUser="+nmUsrID;//? come form macrores.js
	loadXMLdoc(faultURL, "POST", true, handleFaultDiagnoseBack, null, "inputdata="+xmlData);//send fault diagnose request      	
}

/**
 * construct the xml of fault diagnose 
 * @param no
 * return xml
 */
function constructFaultDiagnoseXML()
{
	return constructProtocolResumeXML();
}

/**
 * handle fault diagnose callback
 * @param doc
 * @return no
 */
function handleFaultDiagnoseBack(doc)
{
	var data = EncapsulateData(doc);
	var faultContext = document.getElementById("faultcontext");
	faultContext.value = "";
	setButtonStatus(true);
	
	if( 0 != data.getSErrorCode() )
	{
		handleErrInfo(data);
	}
	else
	{
		var diObj;
		for(var i = 0, size = data.getDataRowLength(); i < size; i++)
		{
		    diObj = data.rows[i];
		
     		faultContext.value = faultContext.value+ '\n' + diObj["PROTCONTENT"].value;
     	}
	}
}

/**
 * handle operate error
 * @param datainterface data
 * @return no
 */
function handleErrInfo(data)
{
	var errArr = [];//define errors object
	errArr.push("nename");
	errArr.push("boardname");
	
	openErrPage("../../../../../page/", data.getError(), errArr);//open the error page
}

/**
 * set buttons status
 * @param btnStatus
 * @return no
 */
function setButtonStatus(btnStatus) 
{
	document.getElementById("faultbtn").disabled = !(btnStatus && btnRightArr.faultbtn.right);
	document.getElementById("resumebtn").disabled = !(btnStatus && btnRightArr.resumebtn.right);
}
