 
var obj = getNeProperty(self);
var winurlobj = obj;
var btnRight = null;

var portList = [];
function initpage()
{
    st = new SortTable();
    st.setImage("../../../../../../images/");  
    createTableHead(st, window.tableconf[0]);
    
    $("table").appendChild(st.getTable());  
    $("table").oncontextmenu = rightClickEvent;
    
    st.setBodyHeight(getTableHeight(document.getElementById("table"),st)+"px");    
    st.setOnRowSelectHandler(btnStatus);
    
    st.setOnCellEditHandler(cellEditHandler);
    
    $("querybutton").value = RESOURCE["querybutton"];
    $("newbutton").value = RESOURCE["newbutton"];
    $("deletebutton").value = RESOURCE["deletebutton"];
    $("applybutton").value = RESOURCE["applybutton"];

    getAllBtnRight();
    sendQueryInfo();
    btnStatus();
}

/**
 *         
 */
function getAllBtnRight()
{
    btnRight = new Object;
    
    btnRight.querybutton = new BtnRightObj("querybutton", TE_FUNC_CFG_GET_PORTMIRROR);    
    btnRight.newbutton = new BtnRightObj("newbutton", TE_FUNC_CFG_SET_PORTMIRROR);
    btnRight.deletebutton = new BtnRightObj("deletebutton", TE_FUNC_CFG_DEL_PORTMIRROR);
    btnRight.applybutton = new BtnRightObj("applybutton", TE_FUNC_CFG_SET_PORTMIRROR);
    
    getRightInfo(winurlobj, btnRight);      
    
    initrightbtn(btnRight);
}

function createjsDOMenu()
{	
	var isSelected = false;
	for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		if(st.getRowSelFlag(i))
		{
			isSelected = true;
			break;
		}
	}
	
	if(!isSelected)
	{
		return;
	}
	
	if(!btnRight.deletebutton.right)
	{
      isSelected = false;
  }
    var cursorMenu = new jsDOMenu(120); //   120
   
    cursorMenu.addMenuItem(new menuItem(RESOURCE["deletebutton"], "",deleteData, "", isSelected));
    
    setPopUpMenu(cursorMenu);
    
    showMenu();
}

/**
 *   
 */
function rightClickEvent(evt)
{
    removejsDOMmenu();
    
    if(!evt){
      evt= window.event;    
    }
     
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null&&elem.blur)
    {
        elem.blur();        
    }
   
   while(elem!=null)
     {
        if(elem.tagName == 'TD')
        {
            break;  
        }
        else
        {
            elem =elem.parentNode;      
        }   
    } 
    
    if(elem == null || elem.tagName != 'TD' || null == elem.parent)
    {
          return;
    }
    
    var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    
    if(!rows.contains(rowid))
    {
        return;
    }
    
	createjsDOMenu();
}

function createQueryNeXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var PREFIX_FAC = "FAC";
    var PREFIX_ACC = "ACC";
    
    for (var i = 0, len = 2; i < len; i ++)
    {
        row = new tagElement("row-params");
    
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", obj.neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        if (0 == i)
        {
            param.setAttribute("name", "prefix");
            param.setAttribute("value", PREFIX_FAC);
        }
        else
        {
            param.setAttribute("name", "prefix");
            param.setAttribute("value", PREFIX_ACC);
        }
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name","slotid");
        param.setAttribute("value",obj.slotid); 
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portid");
        param.setAttribute("value", "ALL"); 
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "boardType");
        param.setAttribute("value", obj.boardType); 
        row.appendChild(param);
    
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function sendQueryInfo()
{  
    hideMenu();//     
	setButtonDisabled(true);//    
	
    if(!btnRight.querybutton.right)
    {
        btnStatus();
        return;
    }
    
    var xmlstr = createQueryNeXML();
    
    urlreq ="../../../../../../tl1NEExlorerServlet?sfid=" + TE_FUNC_CFG_GET_PORTMIRROR + "&nmUser="+obj["nmUser"];
    
    loadXMLdoc(urlreq, "POST", false, queryCallBack, null, "inputdata=" + xmlstr);
}

function queryCallBack(doc)
{
    var data = EncapsulateData(doc);
    
    var smallErrorCode = data.getSErrorCode();
    if(smallErrorCode != OPERATION_SUCCESS)
    {
        var errArr = [];
        errArr[0] = "nename";
        errArr[1] = "boardname";
    	showErrorDialog(data, errArr);
    }
    if (smallErrorCode != OPERATION_FAIL)
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+obj.neid,false);
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        adjustToCurrSortStatus();
        
        getSupportPort();
        for (var i = 0, len = st.getDataRowLength(); i < len; i ++)
        {
            var downPortIdCellEdit = st.getCellEdit(i, "downportid");
            var downPortIdCell = st.getCell(i, "downportid");
            var downPortEditShow = st.getCellShow(i, "downportid");
            var downPortId = st.getCellStoreValue(i, "downportid", "downportid");
            
            if (L4G == obj.boardType)
            {
                st.setCellValue(downPortIdCell, "downportid", "-");
    			downPortEditShow.setValue("-");
    			st.setCellIsEdit(downPortIdCell,0); 
            }
            else
            {
                if (STRING_NULL == downPortId)
                {
                    st.setCellValue(downPortIdCell, "downportid", "-");
                    st.setAtomValue(downPortEditShow, "-");
                }
				downPortIdCellEdit.clearOptions();
				downPortIdCellEdit.addOption("-", "-");
				for (var j = 0, size = portList.length; j < size; j ++)
                {
                    downPortIdCellEdit.addOption(getPortName(portList[j]), getPortName(portList[j]));
                }
            }
            
            var upPortIdCellEdit = st.getCellEdit(i, "upportid");
            var upPortIdCell = st.getCell(i, "upportid");
            var upPortEditShow = st.getCellShow(i, "upportid");
            var upPortId = st.getCellStoreValue(i, "upportid", "upportid");
            if (STRING_NULL == upPortId)
            {
                st.setCellValue(upPortIdCell, "upportid", "-");
                st.setAtomValue(upPortEditShow, "-");
            }
            upPortIdCellEdit.clearOptions();
            upPortIdCellEdit.addOption("-", "-");
			for (var j = 0, size = portList.length; j < size; j ++)
            {
                upPortIdCellEdit.addOption(getPortName(portList[j]), getPortName(portList[j]));
            }
        }
    }  
    
    btnStatus();
}

function deleteData()
{
    hideMenu();//     
    setButtonDisabled(true);//    

    if(!confirm(RESOURCE["deleteconfirm"]))
	{
	    btnStatus();
	    return;
	}
	
	if (st.getSelectedRowCount() <= 0)
	{
	    alert(RESOURCE["pleaseSelect"]);
	    btnStatus();
	    return;
	}
	
	var xml = deleteDataXML();
    var URL = "../../../../../../tl1NEExlorerServlet?sfid=" + TE_FUNC_CFG_DEL_PORTMIRROR + "&flag=1&timestamp="+new Date().getTime()+"&nmUser="+obj["nmUser"];
    loadXMLdoc(URL,"POST", true, detelteCallBack, null, "inputdata=" + xml);
}

function deleteDataXML()
{
	var rowindex = st.getSelectedRows();
	var di = new inputxml("datainterface");
    var bp = new tagElement("bussiness-params");
    for(i = 0; i < st.getDataRowLength(); i++)
    {
        if(st.getRowSelFlag(i))
        {
            var row = new tagElement("row-params");                        
            var param = new tagElement("param");
            param.setAttribute("name", "neid");
            param.setAttribute("value", obj["neid"]);
            row.appendChild(param);
                                
            var param = new tagElement("param");
            param.setAttribute("name", "slotid");
            param.setAttribute("value", obj["slotid"]);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "mirrorport");
            var mirrorport = st.getCellStoreValue(i, "mirrorport", "mirrorport");               
            
            param.setAttribute("value", mirrorport);
            row.appendChild(param);
            bp.appendChild(row);
        }
    }
    di.getRoot().appendChild(bp);
    return di.toString();
}

function detelteCallBack(doc,rowindex)
{
    var selectedRows = [];
	var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    if (smallErrorCode != OPERATION_SUCCESS)
    {
    	showErrorDialog(data);
    }
    else
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+obj.neid,false);
    }
    if (smallErrorCode != OPERATION_FAIL)
    {
        selectedRows = st.getSelectedRows();
        for (var i = selectedRows.length - 1; i >= 0; i --)
        {
            st.deleteRow(selectedRows[i]);
        }
        st.adjustDataRows();
    }
    
    btnStatus();
}

function create()
{
    hideMenu();//     
    setButtonDisabled(true);//    
    
    if (!btnRight.newbutton.right)
    {
        btnStatus();
        return;
    }
    
    xshowModalDialog("creatportmirror.html", RESOURCE["portmirrormgr"], 350, 200, "../../../../../../images/");
    
    btnStatus();
}

function showErrorDialog(data, errArr)
{
    var STRING_PORT = "PORT";
    var STRING_VCTRUNK = "VCTRUNK";
    var tempObj = null;
    var aid = null;
    var tempStr = "";
    var tempErrArr = null;
    if (null == errArr)
    {
        tempErrArr = [];
        tempErrArr[0] = "nename";
        tempErrArr[1] = "boardname";
    }
    else
    {
        tempErrArr = errArr;
    }
    
    openErrPage("../../../../../../page/", data.getError(), tempErrArr); 
}

/**
 *      
 */
window.onresize=function()
{
	 st.setBodyHeight(getTableHeight($("table"),st)+"px");
}

function applyPortMirror()
{
    hideMenu();
    
    if (!btnRight.applybutton.right)
    {
        btnStatus();
        return;
    }
    
    for(var i = 0, len = st.getDataRowLength(); i < len; i ++)
    {
		if (st.getModify(i))
		{
        	var mirrorport = st.getCellStoreValue(i, "mirrorport", "mirrorport");
            var upportid = st.getCellStoreValue(i, "upportid", "upportid");
            var downportid = st.getCellStoreValue(i, "downportid", "downportid");

            if(mirrorport == upportid)
            {   
                alert(RESOURCE["upcantEqual"]);
                return;
            }
            if (mirrorport == downportid)
            {
                alert(RESOURCE["downcantEqual"]);
                return;
            }
            if (upportid == "-" && downportid == "-")
            {
                if (L4G == obj.boardType)
                {
                    alert(RESOURCE["selectUpPort"]);
                }
                else
                {
                    alert(RESOURCE["selectPort"]);
                }
                
                return;
            }
		}
	}
    
    setButtonDisabled(true);
    
    var xml = applyPortMirrorXML();
    if (null == xml)
    {
        btnStatus();
        return;
    }

    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + 400012 +"&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", true, applyPortMirrorBack, null, "inputdata=" + xml);  
}

function applyPortMirrorXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var board = null;
    var mirrorport = null;
    var upportid = null; 
    var downportid = null;
    
    for(var i = 0, len = st.getDataRowLength(); i < len; i ++)
    {
		if (!st.getModify(i))
		{
			continue;
		}
		isModified = true;
        row = new tagElement("row-params");
        param = null;
       
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        board = st.getCellStoreValue(i, "board", "board");
        param = new tagElement("param");
        param.setAttribute("name", "board");
        param.setAttribute("value", board);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", obj.slotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "boardType");
        param.setAttribute("value", obj.boardType);
        row.appendChild(param);
        
        mirrorport = st.getCellStoreValue(i, "mirrorport", "mirrorport");
        param = new tagElement("param");
        param.setAttribute("name", "mirrorport");
        param.setAttribute("value", mirrorport);
        row.appendChild(param);
        
        upportid = st.getCellStoreValue(i, "upportid", "upportid");
        if (upportid != "-")
        {
            param = new tagElement("param");
            param.setAttribute("name", "upportid");
            param.setAttribute("value", upportid);
            row.appendChild(param);
        }
        
        downportid = st.getCellStoreValue(i, "downportid", "downportid");
        if (downportid != "-")
        {
            param = new tagElement("param");
            param.setAttribute("name", "downportid");
            param.setAttribute("value", downportid);
            row.appendChild(param);
        }
        business.appendChild(row);
    }
    
    if (!isModified)
    {
        return null;
    }
    
    root.getRoot().appendChild(business);
    return root.toString();   
}

function applyPortMirrorBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATION_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+obj.neid,false);
    }
    if (OPERATION_FAIL != smallErrorCode)
    {
        refreshTableState(st, window.tableconf[0], data);
    }
    btnStatus();    
}

function btnStatus()
{
    var selectedRows = st.getSelectedRows(); 
    if (selectedRows.length > 0)
    {
        $("querybutton").disabled =  !btnRight.querybutton.right;
        $("newbutton").disabled = !btnRight.newbutton.right;
        $("deletebutton").disabled = !btnRight.deletebutton.right;
    } 
    else
    {
        $("querybutton").disabled =  !btnRight.querybutton.right;
	    $("newbutton").disabled = !btnRight.newbutton.right;
	    $("deletebutton").disabled = true;
    }

    var isModified = false;
    for(var i = 0, len = st.getDataRowLength(); i < len; i ++)
    {
		if (st.getModify(i))
		{
		    isModified = true;
			break;
		}
	}
	if (isModified)
	{
	    $("applybutton").disabled = !btnRight.applybutton.right;
	}
	else
	{
	    $("applybutton").disabled = true;
	}
    $("selrows").innerHTML = selectedRows.length;
	$("totalrows").innerHTML = st.getDataRowLength();  
}

/**
 *       
 */
function setButtonDisabled(isDisabled)
{
    $("querybutton").disabled = isDisabled;
    $("newbutton").disabled = isDisabled;
    $("deletebutton").disabled = isDisabled;
    $("applybutton").disabled = isDisabled;
}

function cellEditHandler()
{
	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+obj.neid,true);
    $("applybutton").disabled = !btnRight.applybutton.right;
}

function adjustToCurrSortStatus()
{
    if(!st.element.colsArray.selectedId)
    {
  	   st.element.colsArray.selectedId = "board";
  	   st.element.colsArray.imgflag = 1;
    }
    
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element; 
    st.sortRows(td, st.element.colsArray.imgflag);
}

function getSupportPort()
{
	var xml = creategetSupportPortXML();
	var URL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_PORTMIRROR_GETPORT+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(URL,"POST",false,getSupportPortBack,null,"inputdata="+xml);
	
}
function creategetSupportPortXML()
{
	var di =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    var neid = winurlobj["neid"];
    param.setAttribute("name","neid");
    param.setAttribute("value",obj.neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    var slotid = winurlobj["slotid"];
    param.setAttribute("name","slotid");
    param.setAttribute("value",obj.slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    var boardType = winurlobj["boardType"];
    param.setAttribute("name","boardType");
    param.setAttribute("value",obj.boardType);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function getSupportPortBack(doc)
{
	var data = EncapsulateData(doc);
	if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(data);
    	return;
    }
	var boardname = data.getDataRowParam(0, "boardname");
	for(var i = 0, len = data.getDataRowLength(); i < len; i ++)
	{
	    portList[i] = data.getDataRowParam(i, "portid");
		for (var j = portList[i].length; j < 5; j++)
		{
	        portList[i] = "0" + portList[i];
		}
	}
	if(portList.length != 0)
	{
        portList.sort();	
	}				 		
}

function getPortName(portID)
{
    var portName = null;
    var portid = parseInt(portID, 10);
    if(0x8000 < portid)
    {
    	portName = "VCTRUNK" + (portid - 0x8000);
    }
    else
    {
    	portName = "PORT" + portid;
    }
    
    return portName;
}
