/**
 *            ;
 *            ,          ;
 *       ,        ,                ,          
 */

language = SYSTEMCONF.getLanguage();
document.title = RESOURCE["portmirrormgr"];
var win = getParentWindow();
var winurlobj = getNeProperty(win.document);

var portList = new Array();
var tmpValue = "";
var boardname="";
var shelfName = "";
function initPage()
{
    getSupportPort();
    createButton();
    createTable();
}
function getSupportPort()
{
    var xml = getSupportPortXML();
    var URL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_PORTMIRROR_GETPORT+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(URL, "POST", false, getSupportPortBack, null, "inputdata=" + xml);
    
}
function getSupportPortXML()
{
    var di =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    var neid = winurlobj["neid"];
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    var slotid = winurlobj["slotid"];
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    var boardType = winurlobj["boardType"];
    param.setAttribute("name", "boardType");
    param.setAttribute("value", boardType);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function getSupportPortBack(doc)
{
	var data = EncapsulateData(doc);
    if(data.getSErrorCode() != 0)
    {
        showErrorDialog(data);
    }
    else
    {
        boardname = data.getDataRowParam(0, "boardname");
        shelfName = data.getDataRowParam(0, "shelfName");
        for(var i = 0, len = data.getDataRowLength(); i < len; i ++)
        {
            portList[i] = data.getDataRowParam(i, "portid");
            for (var j = portList[i].length; j < 5; j ++)
            {
                portList[i] = "0" + portList[i];
            }
        }
        if(portList.length != 0)
        {
            portList.sort();    
        }                   
    }
}

function createButton()
{   
    $("submitbtn").value=RESOURCE["okbutton"];
    $("cancel").value=RESOURCE["cancelbutton"];
    $("apply").value=RESOURCE["applybutton"];

}
function refreshOption(atom, portList)
{
    var mirrorPort = null;
    atom.clearOptions();
    if (winurlobj["boardType"] == TBE || winurlobj["boardType"] == TN11LEX4 
    	|| winurlobj["boardType"] == TN11LEM24 || winurlobj["boardType"] == TN54LEM28 || winurlobj["boardType"] == TNF1LEM18)
    {
       atom.addOption("/", INVALID_PORT_VALUE);
    }
    for (var i = 0, len = portList.length; i < len; i ++)
    {
        mirrorPort = ct.getAttrValue("mirrorport"); 
        if (portList[i] == mirrorPort)
        {
            continue;
        }
        atom.addOption(getPortName(portList[i]), getPortName(portList[i]));
    }
}

/**
 *          ,         ,         
 */
function createTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"],RESOURCE["value"]);
    
    var atom = new Atom("span");
    atom.setValue(shelfName + "-" + boardname);
    atom.element.style.width="100%";
    ct.addAttrRow("board",RESOURCE["board"],atom);
    
    atom = new Atom("select");
    var portList = getPortList();
    for(var i = 0,len = portList.length; i < len; i ++)
    {
       if((parseInt(portList[i]) > LOGIC_PORT_TAG) && (winurlobj["boardType"] != TBE) 
          && (winurlobj["boardType"] != TNF1LEM18) && (winurlobj["boardType"] != TN54LEM28))
       {
            continue;
       }
       atom.addOption(getPortName(portList[i]), getPortName(portList[i]));
    }
    atom.element["onchange"] = function()
    {
        $("apply").disabled = false;
        
        refreshOption(ct.getAtom("upmirrorport"), portList);
        if(winurlobj["boardType"] == TBE || winurlobj["boardType"] == TN11LEX4
    	|| winurlobj["boardType"] == TN11LEM24 || winurlobj["boardType"] == TN54LEM28 || winurlobj["boardType"] == TNF1LEM18)
        {
            refreshOption(ct.getAtom("downmirrorport"), portList);
        }
    }
    ct.addAttrRow("mirrorport",RESOURCE["mirrorport"],atom);
    
    atom = new Atom("select");
    if(winurlobj["boardType"] == TBE || winurlobj["boardType"] == TN11LEX4
    	|| winurlobj["boardType"] == TN11LEM24 || winurlobj["boardType"] == TN54LEM28 || winurlobj["boardType"] == TNF1LEM18)
    {
        atom.addOption("/", INVALID_PORT_VALUE);
    }
    for(var i=0,len=portList.length;i<len;i++)
    {
        atom.addOption(getPortName(portList[i]), getPortName(portList[i]));
    }
    atom.element["onchange"] = function()
    {
        $("apply").disabled = false;
    }
    ct.addAttrRow("upmirrorport", RESOURCE["upmirrorport"], atom);
    
    atom = new Atom("select");
    if(winurlobj["boardType"] == TBE || winurlobj["boardType"] == TN11LEX4
    	|| winurlobj["boardType"] == TN11LEM24 || winurlobj["boardType"] == TN54LEM28 || winurlobj["boardType"] == TNF1LEM18)
    {
        atom.addOption("/", INVALID_PORT_VALUE);
    }
    
    if(winurlobj["boardType"] == TBE || winurlobj["boardType"] == TN11LEX4
    	|| winurlobj["boardType"] == TN11LEM24 || winurlobj["boardType"] == TN54LEM28 || winurlobj["boardType"] == TNF1LEM18)
    {
        for(var i = 0, len = portList.length; i < len; i ++)
        {
         atom.addOption(getPortName(portList[i]), getPortName(portList[i]));
        } 
    }
    else
    {
        atom.addOption("-", INVALID_PORT_VALUE); 
        atom.element.disabled = true;
    }
    atom.element["onchange"] = function()
    {
        $("apply").disabled = false;
    }
    ct.addAttrRow("downmirrorport", RESOURCE["downmirrorport"], atom);
    

    $("tableDiv").appendChild(ct.getTable());
}

function getPortList()
{
   return portList;
}

function getPortName(portID)
{
    var portName;
    var portid = parseInt(portID, 10);
    if(0x8000 < portid)
    {
        portName = "VCTRUNK" + (portid - 0x8000);
    }
    else
    {
        portName = "PORT" + portid;
    }
    return portName;
}

function doCreateXML()
{
    var neid = winurlobj["neid"];
    var slotid = winurlobj["slotid"];
    var mirrorport = ct.getAttrValue("mirrorport");
    var upmirrorport = ct.getAttrValue("upmirrorport");
    var downmirrorport = ct.getAttrValue("downmirrorport");
    
    var di =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");

    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "mirrorport");
    param.setAttribute("value", mirrorport);
    row.appendChild(param);
    
    if (upmirrorport != INVALID_PORT_VALUE)
    {
        param = new tagElement("param");
        param.setAttribute("name", "upportid");
        param.setAttribute("value", upmirrorport);
        row.appendChild(param);
    }
    
    if (downmirrorport != INVALID_PORT_VALUE)
    {
        param = new tagElement("param");
        param.setAttribute("name", "downportid");
        param.setAttribute("value", downmirrorport);
        row.appendChild(param);
    }
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
        
    return di.toString();
}

function okToCreate()
{  
    if ($("apply").disabled)
    {
        xcloseDialog();
    } 
    
    setButtonDisabled(true);
    doCreate(true);
}

function applyToCreate()
{  
    setButtonDisabled(true);
    doCreate(false);
}

function doCreate(closeDialogFlag)
{
    var mirrorport = ct.getAttrValue("mirrorport");
    var upmirrorport = ct.getAttrValue("upmirrorport");
    var downmirrorport = ct.getAttrValue("downmirrorport");
    
    if(mirrorport == upmirrorport)
    {   
        alert(RESOURCE["upcantEqual"]);
        $("apply").disabled = false;
        $("submitbtn").disabled = false;
        $("cancel").disabled = false;
        return;
    }
    if (mirrorport == downmirrorport)
    {
        alert(RESOURCE["downcantEqual"]);
        $("apply").disabled = false;
        $("submitbtn").disabled = false;
        $("cancel").disabled = false;
        return;
    }
    if (upmirrorport == INVALID_PORT_VALUE && downmirrorport == INVALID_PORT_VALUE)
    {
        alert(RESOURCE["selectPort"]);
        $("apply").disabled = false;
        $("submitbtn").disabled = false;
        $("cancel").disabled = false;
        return;
    }   
    var xml = doCreateXML();
    var URL = "../../../../../../tl1NEExlorerServlet?sfid="+TE_FUNC_CFG_SET_PORTMIRROR+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(URL, "POST", true, doCreateBack, closeDialogFlag, "inputdata=" + xml);
}
function doCreateBack(doc, closeDialogFlag)
{
    var data = EncapsulateData(doc);
    if(data.getSErrorCode() != 0)
    {
        showErrorDialog(data);
        $("apply").disabled = false; 
    }
    else
    {
        win.sendQueryInfo();
        win.setButtonDisabled(true);
        if (closeDialogFlag)
        {
            xcloseDialog();
            return;
        }
        $("apply").disabled = true; 
    }
    $("submitbtn").disabled = false;
    $("cancel").disabled = false;
}

function showErrorDialog(data)
{
    var STRING_PORT = "PORT";
    var STRING_VCTRUNK = "VCTRUNK";
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "shelfName";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", data.getError(), errArr); 
}

/**
 *       
 */
function setButtonDisabled(isDisabled)
{
    $("submitbtn").disabled = isDisabled;
    $("cancel").disabled = isDisabled;
    $("apply").disabled = isDisabled;
}
