/**
 * MAC        js  
 *   : c00104334   R7C01B2
 *   : 2008-08-25
 */
var winobj = parseURLStr(self);          //  URL   
var neid = winobj.neid;                  //  ID
var nmUser = winobj.nmUser;              //  
var slotid = winobj.slotid;              //  ID
var boardname = winobj.boardname;        //    

var btnRightArr = new Object();          //      
var portTable = null;                    //    Table
var macTable = null;                     //Mac    Table

var OPRSUCC = 0;                         //    
var OPRFAIL = 2;                         //    
var VCTRUNK_BASIC = 32768;               //VCTUNK     

var orginRow = -1;
 
var isModified = false;

/**
 *        
 */
function init()
{
    initTitle();
    initPortTable();
    initMacTable();
    initRightData();
    if (btnRightArr.queryBtn.right)
    {
        queryPortList();
    }
}

/**
 *          
 */
function initPortTable()
{
    portTable = new SortTable();
    portTable.setImage("../../../../../../images/");
    createTableHead(portTable, window.tableconf[0]);
    portTable.setBodyHeight(getTableHeight($("porttable"),portTable)*0.45+"px");
    
    var hc = portTable.getHeadCell("portname");
    portTable.setHCAttribute(hc, 1, 0, compareUserLevel);
    
    portTable.setSingleChoiceFlg(true);
    portTable.setOnRowSelectHandler(rowSelectHandler_PortTable);

    $("porttable").appendChild(portTable.getTable()); 
}

function compareUserLevel(str1,str2)
{
    var str1s = str1.match(/\D+|\d+/g);
    var str2s = str2.match(/\D+|\d+/g);
    
    if(str1s.length != 2 || str2s.length != 2)
    {
        return compare(str1,str2);
    }
    
    if(str1s[0] == str2s[0])
    {
        return compare(parseInt(str1s[1]),parseInt(str2s[1]));
    }
    else
    {
        return compare(str1s[0],str2s[0]);
    }
}

/**
 *            
 *@param bl:      
 */
function disabledAllBtn(bl)
{
    if(bl)
    {
		$("queryBtn").disabled = bl ;
		$("addBtn").disabled = bl;
		$("deleteBtn").disabled = bl;
		$("applyBtn").disabled = bl;
    }
}

/**
 *             
 *@param row:      
 */
function rowSelectHandler_PortTable(row)
{
    if(row.length >= 1)
    {
		queryMacList();
    }
    else
    {
        macTable.clearTableData();
    }
    
    isModified = false;//            
    btnStatus();//      
}

/**
 *    Mac      
 */
function initMacTable()
{
    macTable = new SortTable();
    macTable.setImage("../../../../../../images/");
    createTableHead(macTable, window.tableconf[1]);
    macTable.setBodyHeight(getTableHeight($("mactable"),macTable)*0.3+"px");
    macTable.setOnRowSelectHandler(rowSelectHandler_MacTable);
    $("mactable").appendChild(macTable.getTable()); 
}

/**
 * Mac            
 *@param row:      
 */
function rowSelectHandler_MacTable(row)
{
    btnStatus();
}

/**
 *               
 */
function initTitle()
{
	$("portlist").innerText = RESOURCE["topLabel"];
	$("maclist").innerText = RESOURCE["bottomLabel"];
	
	$("queryBtn").value = RESOURCE["querybutton"];
	$("addBtn").value = RESOURCE["newbutton"];
	$("deleteBtn").value = RESOURCE["deletebutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
}

/**
 *       
 */
function initRightData()
{
    btnRightArr.queryBtn = new BtnRightObj("queryBtn", TECMDCODE_GET_ETH_MACFORBID);
    btnRightArr.addBtn = new BtnRightObj("addBtn", TECMDCODE_ADD_ETH_MACFORBID);
    btnRightArr.deleteBtn = new BtnRightObj("deleteBtn", TECMDCODE_DEL_ETH_MACFORBID);
    btnRightArr.applyBtn = new BtnRightObj("applyBtn", TECMDCODE_APPLY_ETH_MACFORBID);
    
    getRightInfo(winobj, btnRightArr);//           
    initrightbtn(btnRightArr);//       
}

/**
 *         XML
 */
function createQueryPortListXML()
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  			
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", neid);
   	secondlevel.appendChild(thirdlevel);   	
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "slotid");
   	thirdlevel.setAttribute("value", slotid);
   	secondlevel.appendChild(thirdlevel);
   		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);	
	return root.toString();
}

/**
 *   Mac  
 */
function queryPortList()
{
    disabledAllBtn(true);
    var xmldata = createQueryPortListXML();          
    var url="../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_GET_ETH_MACFORBID_AVAILPORT+"&flag=0&nmUser="+nmUser;
    loadXMLdoc(url,"POST", true, QueryPortBackHandler, null, "inputdata="+xmldata);
}

/** 
 *            
 *@param doc:      XML
 */
function QueryPortBackHandler(doc)
{
    var queryData = EncapsulateData(doc);
    
    portTable.clearTableData(); 
    if (OPRSUCC == queryData.getSErrorCode()) 
    { 
		createTableBody(portTable,window.tableconf[0],queryData,RESOURCE);
		portTable.sortRows(portTable.getHeadCell("portname").element,1);
        if(portTable.getDataRowLength() > 0)
        {
            portTable.setRowSelect(0);
            queryMacList();
        }
    }
    else
    {
        showErrorDialog(queryData);
    }
    
    var selectedRows = portTable.getSelectedRows();
    if (selectedRows[0] != orginRow)
    {
        isModified = false;//            
        orginRow = selectedRows[0];
    }
    isModified = false;
    btnStatus();//      
}

/**
 *         
 *@param data:        
 *@param macflg:   Mac       
 */
function showErrorDialog(data,macflg)
{
    var errArr = [];//                   neid slotid
	errArr.push("nename");
	errArr.push("boardname");
	
	var AID = null;
	var aidSplit = [];
	var RTRV_GETH_AID_PORTID_POS = 3;
	var portName = "";
	if(macflg)
	{
	    for (var i = 0, len = data.errObj.getRowErrLength(); i < len; i ++)
	    {
	        AID = data.errObj.rowErrors[i].errorObj.AID;
	        aidSplit = AID.split("-");
	        if ("ACC" == aidSplit[0])
	        {
	            portName = "VCTRUNK" + aidSplit[RTRV_GETH_AID_PORTID_POS];
	            data.errObj.rowErrors[i].errorObj.portname = portName;
	        } 
	    }
		errArr.push("portname");
	}
	openErrPage("../../../../../../page/", data.getError(), errArr);//         
}

/**
 *         port   Mac       XML
 *@param port:      
 */
function createQueryMacListXML(port)
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
    
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", neid);
   	secondlevel.appendChild(thirdlevel);   	
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "slotid");
   	thirdlevel.setAttribute("value", slotid);
   	secondlevel.appendChild(thirdlevel);
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "port");
   	thirdlevel.setAttribute("value", port[0]);
   	secondlevel.appendChild(thirdlevel);
   	
   	
   	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "boardType");
   	thirdlevel.setAttribute("value", winobj.boardType);
   	secondlevel.appendChild(thirdlevel);
   	
    thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "portname");
   	thirdlevel.setAttribute("value", port[1]);
   	secondlevel.appendChild(thirdlevel);
   		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);	
	
	return root.toString();
}

/**
 *          Mac    
 *@param blSys:      
 */
function queryMacList(blSys)
{
	var port = getSelectPort();
	if(port.length == 0)
	{
	    return;
	}
	disabledAllBtn(true);
	
    var xmldata = createQueryMacListXML(port);
    var url="../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_GET_ETH_MACFORBID+"&flag=0&nmUser="+nmUser;
    var blSendMode = true;
    if(typeof(blSys) != "undefined" && blSys)
    {
        blSendMode = false;
    }
    loadXMLdoc(url,"POST", blSendMode, QueryMacBackHandler, null, "inputdata="+xmldata);
}

/**
 *     Mac         
 *@param doc:      XML
 */
function QueryMacBackHandler(doc)
{
    var queryData = EncapsulateData(doc);
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    $("addBtn").disabled = !btnRightArr.addBtn.right;
    
    macTable.clearTableData(); 
    
    var macForbid = null;
    
    if (OPRSUCC != queryData.getSErrorCode()) 
    { 
        showErrorDialog(queryData, true);
    }
    else
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neid,false);
        for (var i = 0, len = queryData.getDataRowLength(); i < len; i ++)
        {
            macForbid = queryData.getDataRowParam(i, "macforbid");
            if (null == macForbid || "" == macForbid)
            {
                queryData.rows.removeAt(i);
            }
        }
        createTableBody(macTable, window.tableconf[1], queryData, RESOURCE);
    }
    isModified  = false;
    btnStatus();
}

/**
 *                             
 */
function getSelectPort()
{
    var selectPort = [];
	var selectPortRow = portTable.getSelectedRows();
	if(selectPortRow.length != 0)
	{
	    selectPort[0] = portTable.getCellStoreValue(selectPortRow[selectPortRow.length - 1],"port", "port");
	    selectPort[1] = portTable.getCellStoreValue(selectPortRow[selectPortRow.length - 1],"portname", "portname");
	}
	return selectPort;
}

/**
 *                             
 */
function getSelectMac()
{
    var selectMac = "";
	var selectPortRow = macTable.getSelectedRows();
	if(selectPortRow.length != 0)
	{
	    selectMac = macTable.getCellStoreValue(selectPortRow[selectPortRow.length - 1],"macforbid", "macforbid");
	}
	return selectMac;
}

/**
 *     Mac    
 */
function showAddMacFilter()
{
    var selectPortRow = portTable.getSelectedRows();

	if(selectPortRow.length > 0)
	{
	    xshowModalDialog('addmac.html', RESOURCE["addMacForbid"], 300, 150, '../../../../../../images/');//      VLAN  
	}
	else
	{
	    alert(RESOURCE["stSelect"]);
	}
}

/**
 *   Mac  
 */
function deleteMacFilter()
{
	var portSelectRow = portTable.getSelectedRows();
	if(portSelectRow.length <= 0)
	{
	    alert(RESOURCE["stSelect"]);
	    return;
	}
	var macSelectRow = macTable.getSelectedRows();
	if(macSelectRow.length <= 0)
	{
	    alert(RESOURCE["btSelect"]);
	    return;
	}
	disabledAllBtn(true);
	
    var selectedRows = macTable.getSelectedRows();
    for (var i = 0; i < selectedRows.length; i ++)
    {
        macTable.deleteRow(selectedRows[i]);
    }
    setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neid,false);
    macTable.adjustDataRows();
    
    isModified = true;
    btnStatus();
}


/**
 *   common.js               
 * @param res:     obj     /   key:     
 * @return String      
 */
function convertMsg(res,obj,key)
{
	if("function" == (typeof obj))	
	{
		return obj(key);
	}
	else //       
	{
		if(null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if(null == resValue)
		{
			resValue = key;
		}		
		return resValue;
	}
}

/**
 *   portid         
 * @param portid:    portid
 */
function getPortName(portid)
{
    var portname = portid;
    if(parseInt(portid) > VCTRUNK_BASIC)
    {
        portname = "VCTRUNK"+(portid - VCTRUNK_BASIC);
    }
    else
    {
        portname = "PORT" + portid;
    }
    return portname;
}

function applyMacFilter()
{
	disabledAllBtn(true);
    applyData();
}

function applyData()
{
    var xmldata = applyDataXML();
     
    var url="../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_APPLY_ETH_MACFORBID+"&flag=0&nmUser="+nmUser;
    loadXMLdoc(url,"POST", true, applyDataBack, null, "inputdata="+xmldata);
}

/**
 *     Mac     XML
 */
function applyDataXML(port,mac)
{
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
    
    var macStr = "";
    for(var i = 0, len = macTable.getDataRowLength();i < len; i++)
    {  
		if (i > 0)
		{
		    macStr += "&";
		}
		macStr += macTable.getCellStoreValue(i, "macforbid", "macforbid");
	}
	if(macStr == "")
	{
		macStr = "00-00-00-00-00-00";
	}
	var portId = 0;
	var selectedRows = portTable.getSelectedRows();
	portId = portTable.getCellStoreValue(selectedRows[0], "port", "port");
	
	var secondlevel = new tagElement("row-params");
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);   	
   	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "slotid");
	thirdlevel.setAttribute("value", slotid);
	secondlevel.appendChild(thirdlevel);
   	
   	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "boardType");
   	thirdlevel.setAttribute("value", winobj.boardType);
   	secondlevel.appendChild(thirdlevel);
   	
	var port = getSelectPort();
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "port");
	thirdlevel.setAttribute("value", portId);
	secondlevel.appendChild(thirdlevel);
	   	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "macforbid");
	thirdlevel.setAttribute("value", macStr);
	secondlevel.appendChild(thirdlevel);
	   	
    firstlevel.appendChild(secondlevel);
		
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *   Mac      
 * @param doc:     
 */
function applyDataBack(doc)
{
    var data = EncapsulateData(doc);

    if (OPRSUCC == data.getSErrorCode()) 
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neid,false);
        isModified = false;
    }
    else
    {
        showErrorDialog(data,true);
        isModified = true;
    }
    btnStatus();
}

function btnStatus()
{
    var selectedPortRows = portTable.getSelectedRows();
    var selectedMacRows = null;
    if (selectedPortRows.length <= 0)
    {
        $("addBtn").disabled = true;
        $("deleteBtn").disabled = true;
        $("applyBtn").disabled = true;
    }
    else
    {
        $("addBtn").disabled = !btnRightArr.addBtn.right;
        selectedMacRows = macTable.getSelectedRows();
        if (selectedMacRows.length <= 0)
        {
            $("deleteBtn").disabled = true;
        }
        else
        {
            $("deleteBtn").disabled = !btnRightArr.deleteBtn.right;
        }
        
        if (isModified)
        {
            $("applyBtn").disabled = false;
        }
        else
        {
            $("applyBtn").disabled = true;
        }
    }
    
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
}

/**
 *                      
 */
window.onresize = function()
{
    portTable.setBodyHeight(getTableHeight($("porttable"),portTable)*0.45+"px");
    macTable.setBodyHeight(getTableHeight($("mactable"),macTable)*0.3+"px");
}
