 //global variable
var obj = getNeProperty(self);
var parIndex = parseInt(obj.parIndex, 10);
var parObj = getParentWindow();
var neid = parObj.neid;
var slotId = parObj.slotId;
var nmUser = parObj.obj.nmUser;
var boardName = parObj.boardName;
var PORT_NUM_MAX = 10;
if (parObj.boardType == TN11TBE)
{
	PORT_NUM_MAX = 25;
}
if (parObj.boardType == 2272)//F1LEM18
{
	PORT_NUM_MAX = 20;
}
if (parObj.boardType == 2292)//TEM28
{
	PORT_NUM_MAX = 44;
}

var selectedVbList = null;
var ct;

var MIN_MAC_ID = 0x01005E000100;
var MAX_MAC_ID = 0x01005E7FFFFF;

window.onload = function()
{
	queryShelfType();
	initTable();
	initData();	
	initPortSelect();
	initButton();
}

function queryShelfType()
{
	var xmldata = createGetXMLData();//     XML  
    var url = "../../../../../../../tl1NEExlorerServlet?sfid=" + 7788001 + "&nmUser=" + nmUser;//            Servlet   
    loadXMLdoc(url, "POST", false, callBackQueryShelfName, null, "inputdata=" + xmldata);//      
}

function callBackQueryShelfName(doc)
{
	 var data = EncapsulateData(doc);
	 var shelfType = data.getDataRowParam(0, "shelfType");
	 if (parObj.boardType == 2110) //LEX4 6800 support 8, 8800 support 6
	 {
		if (shelfType == "SHELF8800T32" || shelfType == "SHELF8800T64")
		{
			PORT_NUM_MAX = 6;
		}
		else
		{
			PORT_NUM_MAX = 8;
		}
	 }
	if (parObj.boardType == 2109) //LEM24 6800 support 28, 8800 support 26
	{
		if (shelfType == "SHELF8800T32" || shelfType == "SHELF8800T64")
		{
			PORT_NUM_MAX = 26;
		}
		else
		{
			PORT_NUM_MAX = 28;
		}
	}
}

function initPortSelect()
{
	selectedVbList = [];
	if (parIndex >= 0)
	{
		var vbid = parObj.st0.getCellStoreValue(parIndex, "vbid", "vbid");
		var vlanid = parObj.st0.getCellStoreValue(parIndex, "vlanid", "vlanid");
		var macaddress = parObj.st0.getCellStoreValue(parIndex, "mac", "mac");
		selectedVbList = parObj.getSnoopingObj(vbid, vlanid, macaddress).portList;
	}

	var rightPortOption = $("rightport").options;
	for(var i = 0,size = selectedVbList.length; i < size; i++)
	{
		rightPortOption[rightPortOption.length] = new Option(selectedVbList[i],selectedVbList[i]);
	}

	var leftPortOption = $("leftport").options;
	for(var i = 1; i <= PORT_NUM_MAX; i++)//       
	{
		if(!selectedVbList.contains(i))
		{
			leftPortOption[leftPortOption.length] = new Option(i, i);	
		}			
	}	
}

function createGetXMLData()
{
    var root = new inputxml("datainterface"); //    datainterface    
      var firstlevel = new tagElement("bussiness-params"); //         
      var secondlevel = new tagElement("row-params"); //         
               
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);//        
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", slotId);
    secondlevel.appendChild(thirdlevel);//        
    
      firstlevel.appendChild(secondlevel);//               
      root.getRoot().appendChild(firstlevel);//               
    return root.toString();//    
}


function initTable()
{	
	ct = new CTable(); 
	ct.addHead(RESOURCE["ATTRIBUTE"],RESOURCE["VALUE"]);
	$("ctable").appendChild(ct.getTable());
	
	var atom = new Atom("select");
	atom.setValue("");
	atom.element.disabled = (parIndex >= 0);
	ct.addAttrRow("vbid", "VB ID", atom);
	
	var atom = new Atom("select");
	atom.setValue("");
	atom.element.onchange = function()
	{
	    $("applybtn").disabled = false;
	}
	ct.addAttrRow("vlanid", "VLAN ID", atom);
	
	var atom = new Atom("text");
	atom.setValue("01-00-5E-00-01-00");

	checkMACAddEvent(atom.element);
	
	EventUtil.addEventHandler(atom.element,"keydown",changeMacText)
	
	ct.addAttrRow("mac", RESOURCE["mac"], atom);
}
function changeMacText()
{
    $("applybtn").disabled = false;
}
function initData()
{
	var vbOpt = ct.getAtom("vbid").element;
	var vlanOpt = ct.getAtom("vlanid").element;
	if(parIndex >= 0)
	{
		var vbid = parObj.st0.getCellStoreValue(parIndex, "vbid","vbid");
		vbOpt.options[vbOpt.options.length] = new Option(vbid, vbid);
		var vlanid = parObj.st0.getCellStoreValue(parIndex, "vlanid","vlanid");
		if(vlanid=="/")
		{
			vlanid ="65534"
		}
		if (parseInt(vlanid) == 0xfffe)
		{
			vlanOpt.options[vlanOpt.options.length] = new Option("-", vlanid);
		}
		else
		{
			vlanOpt.options[vlanOpt.options.length] = new Option(vlanid, vlanid);
		}
		vlanOpt.disabled = true;
		var macAddr = parObj.st0.getCellStoreValue(parIndex, "mac","mac");
		ct.getAtom("mac").setValue(macAddr);
		ct.getAtom("mac").element.disabled = true;
	}
	else
	{
		var res = parObj.resource;
		var vbid = res.getDataRowParam(0, "vbid");
		vbOpt.options[vbOpt.options.length] = new Option(vbid, vbid);
		if (res.getDataRowLength() == 1)
		{
			var vlanid = res.getDataRowParam(0, "vlanid");
			if (parseInt(vlanid) == 0xfffe || parseInt(vlanid) == 0xffff)
			{
				vlanOpt.options[vlanOpt.options.length] = new Option("-", vlanid);
				vlanOpt.disabled = true;
				return;
			}
		}
		for (var i = 0, m = res.getDataRowLength(); i < m; i++)
		{
			var vlanid = res.getDataRowParam(i, "vlanid");
			vlanOpt.options[vlanOpt.options.length] = new Option(vlanid, vlanid);
		}
	}
}

function initButton()
{
	$("okbtn").value = RESOURCE["okbtn"];
	$("cancelbtn").value = RESOURCE["cancelbtn"];
	$("applybtn").value = RESOURCE["applybtn"];
}

function confirm(flag)
{
	if (parIndex >= 0)
	{
		doModify(flag);
	}
	else
	{
		doCreate(flag);
	}
}

function doCreate(flag)
{
    if ($("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }
    
	if (!checkSubmit(ct.getAtom("mac").getValue()))
	{
		return;
	}
	var xmldata = createNewXml();
	if(xmldata!="")
	{
		var urlstr = "../../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_STATICIGMP_CREATE+"&nmUser="+obj["nmUser"];
		loadXMLdoc(urlstr, "POST", false, callBackNew, flag, "inputdata="+xmldata);
	}
}

function createNewXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var vbid = ct.getAttrValue("vbid");
    var vlanid = parseInt(ct.getAttrValue("vlanid"));
    var mac = ct.getAttrValue("mac");
    var portStr = "";
    var portNum = 0;
    var rightPortOption = $("rightport").options;
    for (var i = 0, len = rightPortOption.length; i < len; i++)
    {    
    	portStr += rightPortOption[i].text + ",";
		portNum++;
	}
	var keys;
	var vals;
	if(vlanid==65534)
	{
		keys = new Array("neid", "slotid", "board", "vbid", "mac",  "portnum","portlist");
		vals = new Array(neid, slotId, slotId+"-"+boardName, vbid, mac, portNum,portStr);
	}
	else
	{
		keys = new Array("neid", "slotid", "board", "vbid", "vlanid", "mac",  "portnum","portlist");
		vals = new Array(neid, slotId, slotId+"-"+boardName, vbid, vlanid, mac, portNum,portStr);
	}
	
    
    business.appendChild(createRow(keys, vals));
    
    root.getRoot().appendChild(business);

    return root.toString();
}

function callBackNew(doc, flag)
{
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0 )
	{
	    $("applybtn").disabled = true;
	    
		parObj.staticBroadcastQuery();	
		if (flag)
		{
			xcloseDialog();
		}
	}
	showErrorDialog(data);
}

function doModify(flag)
{	
    if ($("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }
    
	var xmldata = createModifyXml();
	
	if (xmldata == null)
	{
		alert(RESOURCE["noModify"]);
		return;
	}
	if(xmldata!="")
	{
		var urlstr = "../../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_STATICIGMP_MODIFY+"&nmUser="+obj["nmUser"];
		loadXMLdoc(urlstr, "POST", false, callbackModify, flag, "inputdata="+xmldata);
	}
}

function createModifyXml()
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var vbid = ct.getAttrValue("vbid");
    var vlanid = ct.getAttrValue("vlanid");
    var mac = ct.getAttrValue("mac");
    var portStr = "";
    var portNum = 0;
    var rightPortOption = $("rightport").options;
    for (var i = 0, len = rightPortOption.length; i < len; i++)
    {    	
	   	portStr += rightPortOption[i].value + ",";
    	portNum++;
	}	
	var keys;
	var vals;
	if(vlanid==65534)
	{
		keys = new Array("neid", "slotid", "board", "vbid", "mac",  "portnum","portlist");
		vals = new Array(neid, slotId, slotId+"-"+boardName, vbid, mac, portNum,portStr);
	}
	else
	{
		keys = new Array("neid", "slotid", "board", "vbid", "vlanid", "mac",  "portnum","portlist");
		vals = new Array(neid, slotId, slotId+"-"+boardName, vbid, vlanid, mac, portNum,portStr);
	}business.appendChild(createRow(keys, vals));
    root.getRoot().appendChild(business);
    return root.toString();
} 

function callbackModify(doc, flag)
{
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
	{
	    $("applybtn").disabled = true;
	    
		parObj.staticBroadcastQuery();		
		if (data.getSErrorCode() == 0 && flag)
		{
			xcloseDialog();
		}	
	}
	showErrorDialog(data);
}

function checkSubmit(macStr)
{
    var pattern = /^[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]-[a-f,A-F,0-9][a-f,A-F,0-9]$/;
   	var checker = pattern.test(macStr);
   	if(!checker)
   	{
       	alert(RESOURCE["format"]);
       	return false;
   	}
   	else
   	{
   		var macArr = macStr.toUpperCase().split("-");
		var mac = hexToTen(macArr[0] + macArr[1] + macArr[2] + macArr[3] + macArr[4] +macArr[5]);
		if (mac < MIN_MAC_ID || mac > MAX_MAC_ID)
		{
			alert(RESOURCE["macrange"]);
			return false;
		}
   	}	
	return true;
}

function selectToLeft()
{
   selectTo($("rightport"), $("leftport"));  
}

function selectToRight()
{
   selectTo($("leftport"), $("rightport"));
}   

function selectTo(field1, field2)
{
	if (field1.options.selectedIndex < 0)
	{
		return;
	}
	var value = new Array();
	var text = new Array();
	var selectedValue = new Array();
	for(var i = field1.options.length - 1; i >= 0; i--)
	{
		if(field1.options[i].selected)
		{
			value[value.length] = field1.options[i].value;
			text[text.length] = field1.options[i].text;
			field1.remove(i);
		}
	}
	
	for(var n = field2.options.length - 1, m = 0; n >= 0; n--)
	{
		if (field2.options[n].selected)
		{
		    selectedValue[m++] = field2.options[n].value;
		}
		value[value.length] = field2.options[n].value;
		text[text.length] = field2.options[n].text;
		field2.remove(n);
	}

	value = value.sort(compareNum);
	text = text.sort(compareNum);
	
	for(k = 0; k < value.length; k++)
	{
		var oOption = document.createElement("OPTION");
		oOption.text = text[k];
		oOption.value = value[k];
		    
		for (t = 0; t < selectedValue.length; t++)
		{
		    if (value[k] == selectedValue[t])
		    {
		    	oOption.selected = "selected";
		    } 
		}		    
		field2.options.add(oOption);
	}	
	
	$("applybtn").disabled = false;
}
