 /**
 * TBE,ECOM                 js  
 *         R5C01
 *    : c00104334
 *   : 2008-08-18
 */

document.title = RESOURCE["servCrea"];
var parentWin = getParentWindow();
var winurlobj = getNeProperty(self);
var bdType = winurlobj.boardType;

var portAttrTable = parentWin.st1;

var evplCT = null;

var portList = new Array(); 

/**
 *         , changeSrcPort(),querySrcPortInfoBack(),
 *  changeSnkPort(),querySnkPortInfoBack()    
 */
var snkPortNameTD = null;

var portTypeAtom1 = null;
var portAbleAtom1 = null;
var tagAtom1 = null;

var portTypeAtom2 = null;
var portAbleAtom2 = null;
var tagAtom2 = null;

var MININPUT = 1;
var MAXINPUT = 4095;

var isPortModifySucc = true;

var BDTYPE_TNF1LEM18 = 2272;
/*
 *           onload     
 */
function initPage()
{  
    if(ECOMBoard == winurlobj.boardType)
    {
        $("portAttr").display = "none";
    }
    createButton(); 
    getAvailablePorts();
}

/*
     
 */
function createButton()
{
    $("submitbtn").value=RESOURCE["okbtn"];
    $("cancel").value=RESOURCE["cancelbtn"];
    $("apply").value=RESOURCE["applybtn"];
}

/*
 *         
 */
function getAvailablePorts()
{      
    var xmldata = getAvailablePortsXML();          
    
    var url="../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_NF_ETHER_TRAIL_GETPORTINFO+"&flag=1&nmUser="+winurlobj["nmUser"];
    
    loadXMLdoc(url,"POST", true, getAvailablePortsBack, null, "inputdata="+xmldata);
}

/*
            xml  
 */
function getAvailablePortsXML()
{   
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row=new tagElement("row-params");

    var paramNE=new tagElement("param");
    paramNE.setAttribute("name","neID");
    paramNE.setAttribute("value",winurlobj["neID"]);
    row.appendChild(paramNE);
   
    var paramBT=new tagElement("param");
    paramBT.setAttribute("name","slotID");
    paramBT.setAttribute("value",winurlobj["slotID"]);
    row.appendChild(paramBT);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/*
          
 @param doc        
 */
function getAvailablePortsBack(doc)
{
    data = EncapsulateData(doc);
    
    if (OPRSUCC == data.getSErrorCode()) 
    {
          createTable(data);
    }
    else
    {
        showErrorDialog(data);
        xcloseDialog();
    }
}

/*
   xml  
 @param xml       
 */
function sendXmlData(xml)
{    
    setButtonState(false); 
    var url = null;
    url = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_EVPL_CREATE+"&flag=1&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(url, "POST", true, PostCallBackHandler, null, "inputdata=" + xml);   
}

/*
   xml  
 @param xml       
 */
function sendXmlDataPort(xml)
{   
    setButtonState(false);      
    var URL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_SET_ETHPORTATTRIB+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(URL,"POST",false,PostCallBackPort,null,"inputdata="+xml); 
}

/*
          
 @param doc        
 */
function PostCallBackPort(doc)
{
	setButtonState(true);
    var portData = EncapsulateData(doc);
    isPortModifySucc = portData.getSErrorCode() == 0 ? true : false;
    if (!isPortModifySucc)
    {
        showQueryErrorDialog(portData);
    }
}

/*
        
 @param bEnable      
 */
function setButtonState(bEnable)
{   
    if($("submitbtn"))
    {       
        $("submitbtn").disabled = !bEnable;
        $("apply").disabled = !bEnable; 
    }   
}

/*
 *       
*/
function showErrorDialog(data)
{
    if(data.getError().rowErrors[0])
    {     
        for(var i = 0, size = data.getBErrLength(); i < size; i++)
        {
            tempObj = data.getError().rowErrors[i].errorObj;
			boardName = BoardNameConvert[winurlobj.boardType];
            tempObj["slotid"] = getSlotIDFromSlot(winurlobj.slotID);
            tempObj["boardname"] = boardName;
        }
    }       
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

function showQueryErrorDialog(data)
{
    if(data.getError().rowErrors[0])
    {     
        for(var i = 0, size = data.getBErrLength(); i < size; i++)
        {
            tempObj = data.getError().rowErrors[i].errorObj;
        }
    }       
    var errArr = [];
    errArr[0] = "nename";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

/*
          
 @param doc        
 */
function PostCallBackHandler(doc)
{
    setButtonState(true);
    
    var winEplData = EncapsulateData(doc);
    
    if (OPRSUCC != winEplData.getSErrorCode()) 
    {
        showQueryErrorDialog(winEplData);
        if (winEplData.getSErrorCode() == 1)
        {
            parentWin.doQuery(true);
        }
    }
    else
    {
        parentWin.doQuery(true);
        
        if("submitbtn" == window.actionid)
        {
            xcloseDialog();
        }
        else
        {   
            $("apply").disabled = true;
            
        }
    }
    
}

/*
     
 */
function TEPort()
{   
    this.portName = null;
        
    this.portno = null;
}

/*
     
 */
function getSupportPort(data)  
{    
    var portOption = new Array();
    
    for(var i = 1, size = data.getDataRowLength(); i < size; i++)
    {        
        var port = new TEPort();         
        
        port.portName = data.getDataRowParam(i,"portName");         
        
        port.portno = data.getDataRowParam(i,"portNO");
        
        portOption.push(port);
    }     
    return portOption;
}

/*
               
 */
function isValidateSrcCVlan()
{     
    if(!isValidateVlan("srcCVlan"))
    {
        return;
    }
    
    var srcCVlanText = evplCT.getAttrValue("srcCVlan");// C-VLAN
    var snkCVlanText = evplCT.getAttrValue("snkCVlan");// C-VLAN
    var operationType = null;
        
    var serviceType = evplCT.getAttrValue("servSort");
    if (SERVICE_TYPE_EPL_VALUE == serviceType)
    {
    	if (bdType != BDTYPE_TN11LEX4 && bdType != BDTYPE_TN11LEM24 && bdType != 2292 && bdType !=BDTYPE_TNF1LEM18)
    	{
    		evplCT.setAttrValue("snkCVlan", srcCVlanText);
    	}
        return;
    }
    else if (SERVICE_TYPE_EVPL_VALUE == serviceType)
    {
        operationType =  evplCT.getAttrValue("oprType");

        if (OPERATION_ADD_SVAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            evplCT.setAttrValue("snkCVlan", srcCVlanText);
            return;
        }  
        
        
        if (OPERATION_STRIP_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            evplCT.setAttrValue("snkCVlan", srcCVlanText);
            return;
        }  
        
        if (OPERATION_STRIP_SVLAN_CVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            if (srcCVlanText == null || srcCVlanText == "")
            {
                alert(RESOURCE["srcCVlanBlank"]);
                return;
            }
        }  
        
        if (OPERATION_TRANSMIT_CVLAN_VALUE == evplCT.getAttrValue("oprType")
        	|| OPERATION_TRANSLATE_SVLANCVLAN_VALUE == evplCT.getAttrValue("oprType")
        	|| OPERATION_TRANSLATE_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            evplCT.setAttrValue("snkCVlan", srcCVlanText);
            return;
        }
    }    
}

/*
               
 */
function isValidateSnkCVlan()
{       
    if(!isValidateVlan("snkCVlan"))
    {
        return;
    }  
    
    var srcCVlanText = evplCT.getAttrValue("srcCVlan");// C-VLAN
    var snkCVlanText = evplCT.getAttrValue("snkCVlan");// C-VLAN  
    var serviceType = evplCT.getAttrValue("servSort");
    if (SERVICE_TYPE_EPL_VALUE == serviceType)
    {
    	if (bdType != BDTYPE_TN11LEX4 && bdType != BDTYPE_TN11LEM24 && bdType != 2292 && bdType !=BDTYPE_TNF1LEM18)
    	{
			evplCT.setAttrValue("srcCVlan", snkCVlanText);
    	}
    }
    else if (SERVICE_TYPE_EVPL_VALUE == serviceType)
    {
        if (OPERATION_ADD_SVAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            evplCT.setAttrValue("srcCVlan", snkCVlanText);
            return;
        }  
        
        if (OPERATION_Add_SVLAN_CVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            if (snkCVlanText == null || snkCVlanText == "")
            {
                alert(RESOURCE["snkCVlanBlank"]);
                return;
            }
        } 
        
        if (OPERATION_STRIP_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            evplCT.setAttrValue("srcCVlan", snkCVlanText);
            return;
        }  
        
        
        if (OPERATION_TRANSMIT_CVLAN_VALUE == evplCT.getAttrValue("oprType")
        	|| OPERATION_TRANSLATE_SVLANCVLAN_VALUE == evplCT.getAttrValue("oprType")
        	|| OPERATION_TRANSLATE_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            evplCT.setAttrValue("srcCVlan", snkCVlanText);
            return;
        }
        
    } 
}

/*
               
 */
function isValidateSrcSVlan()
{
    var operationType =  evplCT.getAttrValue("oprType");
    var srcSVlanText = evplCT.getAttrValue("srcSVlan");;// S-VLAN
    var snkSVlanText = evplCT.getAttrValue("snkSVlan");;// S-VLAN
    if(!isValidateVlan("srcSVlan"))
    {
        return;
    }
    
    if(OPERATION_TRANSLATE_SVLANCVLAN_VALUE == evplCT.getAttrValue("oprType"))
    {
    	evplCT.setAttrValue("snkSVlan", srcSVlanText);
        if (srcSVlanText == null || srcSVlanText == "")
        {
            alert(RESOURCE["srcSVlanBlank"]);
            return;
        }
    }
    
    /*
    
    if (OPERATION_STRIP_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
    {
        if (srcSVlanText == null || srcSVlanText == "")
        {
            alert(RESOURCE["srcSVlanBlank"]);
            return;
        }
    }  
    
    if (OPERATION_STRIP_SVLAN_CVLAN_VALUE == evplCT.getAttrValue("oprType"))
    {
        if (srcSVlanText == null || srcSVlanText == "")
        {
            return;
        }
    }  
    
    if (OPERATION_TRANSMIT_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
    {
        evplCT.setAttrValue("snkSVlan", srcSVlanText);
        if (srcSVlanText == null || srcSVlanText == "")
        {
            alert(RESOURCE["srcSVlanBlank"]);
            return;
        }
    } 
    
    if (OPERATION_TRANSLATE_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
    {
        if (srcSVlanText == null || srcSVlanText == "")
        {
            alert(RESOURCE["srcSVlanBlank"]);
            return;
        }
        if (snkSVlanText != null && snkSVlanText != "" && srcSVlanText == snkSVlanText)
        {
            alert(RESOURCE["srcSVlansnk"]);
            return;
        }
    }    
    */
}

/*
               
 */
function isValidateSnkSVlan()
{
    var operationType =  evplCT.getAttrValue("oprType");
    var srcSVlanText = evplCT.getAttrValue("srcSVlan");;// S-VLAN
    var snkSVlanText = evplCT.getAttrValue("snkSVlan");;// S-VLAN
    if(!isValidateVlan("snkSVlan"))
    {
        return;
    }
    
    if(OPERATION_TRANSLATE_SVLANCVLAN_VALUE == evplCT.getAttrValue("oprType"))
    {
    	evplCT.setAttrValue("srcSVlan", snkSVlanText);
        if (snkSVlanText == null || snkSVlanText == "")
        {
            alert(RESOURCE["snkSVlanBlank"]);
            return;
        }
    }
    /*
    if (OPERATION_ADD_SVAN_VALUE == evplCT.getAttrValue("oprType"))
    {
        if (snkSVlanText == null || snkSVlanText == "")
        {
            alert(RESOURCE["snkSVlanBlank"]);
            return;
        }
    }  
    
    if (OPERATION_Add_SVLAN_CVLAN_VALUE == evplCT.getAttrValue("oprType"))
    {
        if (snkSVlanText == null || snkSVlanText == "")
        {
            alert(RESOURCE["snkSVlanBlank"]);
            return;
        }
    }  
    
    
    if (OPERATION_TRANSMIT_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
    {
        evplCT.setAttrValue("srcSVlan", snkSVlanText);
        if (snkSVlanText == null || snkSVlanText == "")
        {
            alert(RESOURCE["snkSVlanBlank"]);
            return;
        }
    } 
    
    if (OPERATION_TRANSLATE_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
    {
        if (snkSVlanText == null || snkSVlanText == "")
        {
            alert(RESOURCE["snkSVlanBlank"]);
            return;
        }
        if (snkSVlanText != null && snkSVlanText != "" && srcSVlanText == snkSVlanText)
        {
            alert(RESOURCE["srcSVlansnk"]);
            return;
        }
    }    
    */
}

/*
               
 */
function isValidateVlan(Vlan)
{         
    var text=evplCT.getAttrValue(Vlan);
    if(!text || "-" == text)
    {
        return true;
    }
    var str=text.split(",");
    var pattern1=new RegExp("^\\d+$","i");
    var pattern2=new RegExp("^\\d+-\\d+$","i");
 
    for(var i=0; i<str.length; i++)
    {        
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            if( !pattern2.test(str[i]))
            {    
                  alert(RESOURCE["vlanFormat"]);
                  evplCT.setAttrValue(Vlan,"");
            	evplCT.getAtom(Vlan).element.focus();
                return false;
            }
        }
        else
        {
            if(!pattern1.test(str[i]))
            {
                  alert(RESOURCE["vlanFormat"]);
                  evplCT.setAttrValue(Vlan,"");
            	evplCT.getAtom(Vlan).element.focus();
                return false;
            }
         }
    }
    var limitHigh = MAXINPUT;
    var limitLow = MININPUT;
    for(var i=0; i<str.length; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);
    
            if((rangeStart>limitHigh) || (rangeEnd>limitHigh)
                ||(rangeStart<limitLow) ||(rangeEnd<limitLow))
            {
                alert(RESOURCE["numberLimit2"]);
                return false;
            }
            if (rangeEnd <rangeStart)
            {
                  alert(RESOURCE["startEnd"]);
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>limitHigh || parseInt(str[i])<limitLow)
           {
                alert(RESOURCE["numberLimit2"]);
                return false;
           }
        }
    }
    return true;
}
 

function changeDirection()
{ 
    if ($("apply").disabled)
    {
        $("apply").disabled = false;
    }
    var selectvalue = evplCT.getAttrValue("servDir");
    
    /*     EVPL ,         .     EPL   .
     */  
    if (SERVICE_TYPE_EVPL_VALUE == evplCT.getAttrValue("servSort"))
    {
        var cVlanValue = "";
        var cVlanAtomDisabled = false;
        if(ECOMBoard == winurlobj.boardType)
        {
            cVlanValue = "-";
            cVlanAtomDisabled = true;
        }

        var operationAtom = evplCT.getAtom("oprType");
        
        if (DIRECTION_BIDIRECTION_VALUE == evplCT.getAttrValue("servDir"))
        {   
            operationAtom.clearOptions();
            operationAtom.addOption(OPERATION_ADD_SVAN, OPERATION_ADD_SVAN_VALUE);
            
            if (TN11LEX4 != winurlobj.boardType && TN11LEM24 != winurlobj.boardType && TNF1LEM18 != winurlobj.boardType)
            {
            	operationAtom.addOption(OPERATION_Add_SVLAN_CVLAN, OPERATION_Add_SVLAN_CVLAN_VALUE);
            }
            
            if(ECOMBoard != winurlobj.boardType)
            {
                operationAtom.addOption(OPERATION_TRANSMIT_CVLAN, OPERATION_TRANSMIT_CVLAN_VALUE);
                operationAtom.addOption(OPERATION_TRANSMIT_SVLAN, OPERATION_TRANSMIT_SVLAN_VALUE);
                operationAtom.addOption(OPERATION_TRANSLATE_SVLAN, OPERATION_TRANSLATE_SVLAN);                
            }
            
            if(2292 == winurlobj.boardType)
            {
            	operationAtom.addOption(OPERATION_TRANSLATE_CVLAN, OPERATION_TRANSLATE_CVLAN);
           }




        }
        
        if (DIRECTION_UNILATERALISM_VALUE == evplCT.getAttrValue("servDir"))
        {  
            operationAtom.clearOptions();
            operationAtom.addOption(OPERATION_ADD_SVAN, OPERATION_ADD_SVAN_VALUE);
            
            if(ECOMBoard != winurlobj.boardType && TN11LEX4 != winurlobj.boardType 
               && TN11LEM24 != winurlobj.boardType && TNF1LEM18 != winurlobj.boardType
               && winurlobj.boardType != 2292)
            {
                operationAtom.addOption(OPERATION_Add_SVLAN_CVLAN, OPERATION_Add_SVLAN_CVLAN_VALUE);
            }
            
            operationAtom.addOption(OPERATION_STRIP_SVLAN, OPERATION_STRIP_SVLAN_VALUE);
            
            if(ECOMBoard != winurlobj.boardType && TN11LEX4 != winurlobj.boardType 
               && TN11LEM24 != winurlobj.boardType && TNF1LEM18 != winurlobj.boardType
               && winurlobj.boardType != 2292)
            {
                operationAtom.addOption(OPERATION_STRIP_SVLAN_CVLAN, OPERATION_STRIP_SVLAN_CVLAN_VALUE);
            }
            
            if(ECOMBoard != winurlobj.boardType)
            {
                operationAtom.addOption(OPERATION_TRANSMIT_CVLAN, OPERATION_TRANSMIT_CVLAN_VALUE);
                operationAtom.addOption(OPERATION_TRANSMIT_SVLAN, OPERATION_TRANSMIT_SVLAN_VALUE);
            }
            if(winurlobj.boardType == 2292)
            {
            	operationAtom.addOption(OPERATION_TRANSLATE_SVLANCVLAN, OPERATION_TRANSLATE_SVLANCVLAN_VALUE);
            }
            if(winurlobj.boardType == BDTYPE_TN11LEX4 || winurlobj.boardType == BDTYPE_TN11LEM24 
               || winurlobj.boardType == TNF1LEM18 || winurlobj.boardType == 2292)
            {
               operationAtom.addOption(OPERATION_TRANSLATE_CVLAN, OPERATION_TRANSLATE_CVLAN_VALUE);
            }
            
            
            
            operationAtom.addOption(OPERATION_TRANSLATE_SVLAN, OPERATION_TRANSLATE_SVLAN_VALUE);
        }
        changeOperation();
    }
}

function changeOperation()
{
    if ($("apply").disabled)
    {
        $("apply").disabled = false;
    }
    
    var selectvalue = evplCT.getAttrValue("oprType");
    
    var cVlanValue = "";
    var cVlanAtomDisabled = false;
    if(ECOMBoard == winurlobj.boardType)
    {
        cVlanValue = "-";
        cVlanAtomDisabled = true;
    }

    var cvlanPriAtom = evplCT.getAtom("cvlanPri");
    var svlanPriAtom = evplCT.getAtom("svlanPri");
    
    if (OPERATION_ADD_SVAN_VALUE == selectvalue)
    {
        setVlanEnable(true, true, false,true, true, true);
        if (cvlanPriAtom != null && svlanPriAtom != null)
        {
	        cvlanPriAtom.element.length = 0; 
	        cvlanPriAtom.element.disabled = false;
	        svlanPriAtom.element.length = 0; 
	        svlanPriAtom.element.disabled = false;
	        
	        cvlanPriAtom.addOption(RESOURCE["automaticDistribute"], 0xFF);
	        svlanPriAtom.addOption(RESOURCE["automaticDistribute"], 0xFF);
	        
	        svlanPriAtom.addOption(RESOURCE["priority0"], 0);
	        svlanPriAtom.addOption(RESOURCE["priority1"], 1);
	        svlanPriAtom.addOption(RESOURCE["priority2"], 2);
	        svlanPriAtom.addOption(RESOURCE["priority3"], 3);
	        svlanPriAtom.addOption(RESOURCE["priority4"], 4);
	        svlanPriAtom.addOption(RESOURCE["priority5"], 5);
	        svlanPriAtom.addOption(RESOURCE["priority6"], 6);
	        svlanPriAtom.addOption(RESOURCE["priority7"], 7);
        }
        
        if(ECOMBoard != winurlobj.boardType)
        {
            portTypeAtom1.setValue(PORT_TYPE_C_AWARE_VALUE);
            
            if (portTypeAtom2)
            {
                portTypeAtom2.setValue(PORT_TYPE_S_AWARE_VALUE);
            }
        }
    }
    
    if(OPERATION_Add_SVLAN_CVLAN_VALUE == selectvalue)
    {    
        setVlanEnable(false, true, false, true, true, true);
        if (cvlanPriAtom != null && svlanPriAtom != null)  
        {
	        cvlanPriAtom.element.length = 0; 
	        cvlanPriAtom.element.disabled = false;
	        svlanPriAtom.element.length = 0; 
	        svlanPriAtom.element.disabled = false;
	
	        cvlanPriAtom.addOption(RESOURCE["priority0"], 0);
	        cvlanPriAtom.addOption(RESOURCE["priority1"], 1);
	        cvlanPriAtom.addOption(RESOURCE["priority2"], 2);
	        cvlanPriAtom.addOption(RESOURCE["priority3"], 3);
	        cvlanPriAtom.addOption(RESOURCE["priority4"], 4);
	        cvlanPriAtom.addOption(RESOURCE["priority5"], 5);
	        cvlanPriAtom.addOption(RESOURCE["priority6"], 6);
	        cvlanPriAtom.addOption(RESOURCE["priority7"], 7);
	                
	        svlanPriAtom.addOption(RESOURCE["priority0"], 0);
	        svlanPriAtom.addOption(RESOURCE["priority1"], 1);
	        svlanPriAtom.addOption(RESOURCE["priority2"], 2);
	        svlanPriAtom.addOption(RESOURCE["priority3"], 3);
	        svlanPriAtom.addOption(RESOURCE["priority4"], 4);
	        svlanPriAtom.addOption(RESOURCE["priority5"], 5);
	        svlanPriAtom.addOption(RESOURCE["priority6"], 6);
	        svlanPriAtom.addOption(RESOURCE["priority7"], 7);
        }

        if(ECOMBoard != winurlobj.boardType)
        {
            portTypeAtom1.setValue(PORT_TYPE_C_AWARE_VALUE);
            
            if (portTypeAtom2)
            {
                portTypeAtom2.setValue(PORT_TYPE_S_AWARE_VALUE);
            }
        }
    }  
    
    if (OPERATION_STRIP_SVLAN_VALUE == selectvalue)
    {
        setVlanEnable(true, true, true, false, false, false);

        if(ECOMBoard != winurlobj.boardType)
        {
            portTypeAtom1.setValue(PORT_TYPE_S_AWARE_VALUE);
        
            if (portTypeAtom2)
            {
                portTypeAtom2.setValue(PORT_TYPE_C_AWARE_VALUE);
            }
        }
    }
    
    if (OPERATION_STRIP_SVLAN_CVLAN_VALUE == selectvalue)
    {
        setVlanEnable(true, false, true, false, false, false);

        if(ECOMBoard != winurlobj.boardType)
        {
            portTypeAtom1.setValue(PORT_TYPE_S_AWARE_VALUE);
        
            if (portTypeAtom2)
            {
                portTypeAtom2.setValue(PORT_TYPE_C_AWARE_VALUE);
            }
        }
    }  
    
    if (OPERATION_TRANSMIT_CVLAN_VALUE == selectvalue)
    {
        setVlanEnable(true, true, false, false, false, false);

        portTypeAtom1.setValue(PORT_TYPE_C_AWARE_VALUE);
        
        if (portTypeAtom2)
        {
            portTypeAtom2.setValue(PORT_TYPE_C_AWARE_VALUE);
        }
    }
    
    if (OPERATION_TRANSMIT_SVLAN_VALUE == selectvalue)
    {
        setVlanEnable(false, false, true, true, false, false);
        
        portTypeAtom1.setValue(PORT_TYPE_S_AWARE_VALUE);
        
        if (portTypeAtom2)
        {
            portTypeAtom2.setValue(PORT_TYPE_S_AWARE_VALUE);
        }
    }
    
    if (OPERATION_TRANSLATE_SVLAN_VALUE == selectvalue)
    {
        setVlanEnable(true, true, true, true, false, false);
        
        portTypeAtom1.setValue(PORT_TYPE_S_AWARE_VALUE);
        
        if (portTypeAtom2)
        {
            portTypeAtom2.setValue(PORT_TYPE_S_AWARE_VALUE);
        }
    }  
    
    if (OPERATION_TRANSLATE_SVLANCVLAN_VALUE == selectvalue)
    {
        setVlanEnable(true, true, true, true, false, false);
        
        portTypeAtom1.setValue(PORT_TYPE_S_AWARE_VALUE);
        
        if (portTypeAtom2)
        {
            portTypeAtom2.setValue(PORT_TYPE_S_AWARE_VALUE);
        }
    }  
    
    if (OPERATION_TRANSLATE_CVLAN_VALUE == selectvalue)
    {
        setVlanEnable(true, true, false, false, false, false);
        
        portTypeAtom1.setValue(PORT_TYPE_C_AWARE_VALUE);
        
        if (portTypeAtom2)
        {
            portTypeAtom2.setValue(PORT_TYPE_C_AWARE_VALUE);
        }
    }  
}


function setVlanEnable(srcCVlanFlag, snkCVlanFlag, srcSVlanFlag, snkSVlanFlag, cvlanPriFlag, svlanPriFlag)
{
    var srcCVlanAtom = null;
    var srcCVlanAtom = null;
    var snkCVlanAtom = null;
    var snkSVlanAtom = null;
    var cvlanPriAtom = null;
    var svlanPriAtom = null;
    if (srcCVlanFlag)
    {
        srcCVlanAtom = evplCT.getAtom("srcCVlan");
        srcCVlanAtom.setValue("");
        srcCVlanAtom.element.disabled = false;
    }
    else
    {
        srcCVlanAtom = evplCT.getAtom("srcCVlan");
        srcCVlanAtom.setValue("-");
        srcCVlanAtom.element.disabled = true;
    }
    
    if (snkCVlanFlag)
    {
        snkCVlanAtom = evplCT.getAtom("snkCVlan");
        snkCVlanAtom.setValue("");
        snkCVlanAtom.element.disabled = false;
    }
    else
    {
        snkCVlanAtom = evplCT.getAtom("snkCVlan");
        snkCVlanAtom.setValue("-");
        snkCVlanAtom.element.disabled = true;
    }
    
    if (srcSVlanFlag)
    {
        srcSVlanAtom = evplCT.getAtom("srcSVlan");
        srcSVlanAtom.setValue("");
        srcSVlanAtom.element.disabled = false;
    }
    else
    {
        srcSVlanAtom = evplCT.getAtom("srcSVlan");
        srcSVlanAtom.setValue("-");
        srcSVlanAtom.element.disabled = true;
    }
    
    if (snkSVlanFlag)
    {
        snkSVlanAtom = evplCT.getAtom("snkSVlan");
        snkSVlanAtom.setValue("");
        snkSVlanAtom.element.disabled = false;
    }
    else
    {
        snkSVlanAtom = evplCT.getAtom("snkSVlan");
        snkSVlanAtom.setValue("-");
        snkSVlanAtom.element.disabled = true;
    }
    
    if (false == cvlanPriFlag)
    {
        cvlanPriAtom = evplCT.getAtom("cvlanPri");
        if (cvlanPriAtom != null)
        {
	        cvlanPriAtom.element.length = 0;       
	        cvlanPriAtom.addOption("-", "-");
	        cvlanPriAtom.element.disabled = true;
        }
    }
    if (false == svlanPriFlag)
    {   	
        svlanPriAtom = evplCT.getAtom("svlanPri");
        if (svlanPriAtom != null)
        {
	        svlanPriAtom.element.length = 0;       
	        svlanPriAtom.addOption("-", "-");
	        svlanPriAtom.element.disabled = true;
        }
    }
}
/*
 *      EPL  EVPL(QinQ)  EVPL(QinQ)  EPL         
 * @param selectSort        
 */
function changePage()
{   
    if ($("apply").disabled)
    {
        $("apply").disabled = false;
    }
    
    var evplCTTbodyNode = null;
    
    var selectvalue = evplCT.getAttrValue("servSort"); 
     
    var evplCTTbodyNode = evplCT.getTable().childNodes[1];
        
    if(SERVICE_TYPE_EPL_VALUE == selectvalue)
    {   
        window.dialogHeight = EPL_DIALOG_HEIGHT;
        
        if (portTypeAtom1 != null)
        {
            portTypeAtom1.element.options.length=0;
            portTypeAtom1.addOption(PORT_TYPE_UNI, PORT_TYPE_UNI_VALUE);
            portTypeAtom1.element.disabled = false;
        }
        
        if (portTypeAtom2 != null)
        {
            portAbleAtom2.element.options.length=0;
            portAbleAtom2.addOption(PORT_TYPE_UNI, PORT_TYPE_UNI_VALUE);
            portTypeAtom2.element.disabled = false;
        }
        
        
        if(evplCTTbodyNode.childNodes[11])
        {        	     	       
      	    evplCTTbodyNode.removeChild(evplCTTbodyNode.childNodes[11]);      	       
      	    evplCTTbodyNode.removeChild(evplCTTbodyNode.childNodes[10]);
      	}

        if(evplCTTbodyNode.childNodes[9])
        {                          
            evplCTTbodyNode.removeChild(evplCTTbodyNode.childNodes[9]);                
            
            evplCTTbodyNode.removeChild(evplCTTbodyNode.childNodes[6]);                
            
            evplCTTbodyNode.removeChild(evplCTTbodyNode.childNodes[3]);
            
            var directionAtom = evplCT.getAtom("srcCVlan");
            directionAtom.setValue(DIRECTION_UNILATERALISM_VALUE);
            
            var srcCVlanAtom = evplCT.getAtom("srcCVlan");
            srcCVlanAtom.setValue("");
            srcCVlanAtom.element.disabled = false;
            
            var snkCVlanAtom = evplCT.getAtom("snkCVlan");
            snkCVlanAtom.setValue("");
            snkCVlanAtom.element.disabled = false;
            
            var sourcePortAtom = evplCT.getAtom("sourcePort");
            sourcePortAtom.clearOptions();
            for(var i = 0, len1 = portList.length;i < len1; i++)
            {
                sourcePortAtom.addOption(portList[i].portName, portList[i].portno);
            }
            
            var snkPortAtom = evplCT.getAtom("snkPort");
            snkPortAtom.clearOptions();
            for(var i = 0, len1 = portList.length;i < len1; i++)
            {
                snkPortAtom.addOption(portList[i].portName, portList[i].portno);
            }        
        }
        portTypeAtom1.setValue(PORT_TYPE_UNI_VALUE);

        if (portTypeAtom2)
        {
            portTypeAtom2.setValue(PORT_TYPE_UNI_VALUE);
        }
        
        changeSrcPort();
        
        changeSnkPort();
    }
     
    if(SERVICE_TYPE_EVPL_VALUE == selectvalue)
    {       
        window.dialogHeight = EVPL_DIALOG_HEIGHT_520;
        
        if (portTypeAtom1 != null)
        {
        	portTypeAtom1.addOption(PORT_TYPE_C_AWARE, PORT_TYPE_C_AWARE_VALUE);
            portTypeAtom1.addOption(PORT_TYPE_S_AWARE, PORT_TYPE_S_AWARE_VALUE);
            portTypeAtom1.element.disabled = true;
        }
        
        if (portTypeAtom2 != null)
        {
        	portTypeAtom1.addOption(PORT_TYPE_C_AWARE, PORT_TYPE_C_AWARE_VALUE);
            portTypeAtom2.addOption(PORT_TYPE_S_AWARE, PORT_TYPE_S_AWARE_VALUE);
            portTypeAtom2.element.disabled = true;
        }
        
        
        if(!evplCTTbodyNode.childNodes[7])
        {               
            var oprTypeAtom = new Atom("select");
            
            oprTypeAtom.element.onchange = changeOperation;
      
            evplCT.insertAttrRow("oprType", RESOURCE["operSort"], oprTypeAtom, "sourcePort");
                
            var srcSVlanAtom = new Atom("text");
            
            srcSVlanAtom.element.onpaste = function()
            {
            }
              
            checkData(srcSVlanAtom.element, MININPUT, MAXINPUT);
   
            srcSVlanAtom.element["onblur"] = isValidateSrcSVlan;        
            srcSVlanAtom.element.onchange = function()
	        {	     	      
	            $("apply").disabled = false;
	        }    

            evplCT.insertAttrRow("srcSVlan", RESOURCE["sourceS-VLAN"], srcSVlanAtom, "snkPort");        
   
            var snkSVlanAtom = new Atom("text");
            
            snkSVlanAtom.element.onpaste = function()
            {
            }
            checkData(snkSVlanAtom.element, MININPUT, MAXINPUT);    

            snkSVlanAtom.element["onblur"] = isValidateSnkSVlan;
            snkSVlanAtom.element.onchange = function()
	        {	     	      
	           $("apply").disabled = false;
	        }    
            evplCT.addAttrRow("snkSVlan", RESOURCE["snkS-VLAN"], snkSVlanAtom);
            
            if (TBEBoard == winurlobj.boardType || ECOMBoard == winurlobj.boardType)
            {
                var cvlanPriAtom = new Atom("select");
                cvlanPriAtom.element["onchange"] = function()
                {
	                 $("apply").disabled = false; 
                }    
                evplCT.addAttrRow("cvlanPri", RESOURCE["CVLANpriority"], cvlanPriAtom);   
                          	
                var svlanPriAtom = new Atom("select");
                
                svlanPriAtom.element["onchange"] = function()
                {
	                $("apply").disabled = false; 
                }    
                evplCT.addAttrRow("svlanPri", RESOURCE["SVLANpriority"], svlanPriAtom);  
            } 
                      	
            var directionAtom = evplCT.getAtom("servDir");
            directionAtom.setValue(DIRECTION_UNILATERALISM_VALUE);
            changeDirection();
            
            var sourcePortAtom = evplCT.getAtom("sourcePort");
            sourcePortAtom.clearOptions();
            for(var i = 0, len1 = portList.length;i < len1; i++)
            {
                sourcePortAtom.addOption(portList[i].portName, portList[i].portno);  
            }
            
            var snkPortAtom = evplCT.getAtom("snkPort");
            snkPortAtom.clearOptions();
            for(var i = 0, len1 = portList.length;i < len1; i++)
            {
                snkPortAtom.addOption(portList[i].portName, portList[i].portno);
            }        
        }  

        changeSrcPort();
        
        changeSnkPort();     
    }    
}

function checkData(cell,low,high)
{
    if ($("apply").disabled)
    {
        $("apply").disabled = false;
    }
    checkDataCellEventForEVPL(cell,low,high);
}


function chkSvlan(obj,event)
{
    if ($("apply").disabled)
    {
        $("apply").disabled = false;
    }
    
    if(!restrict(obj, event, "0123456789"))
    {
        return false;
    }
    
    return true;
}

/**
 *               
 */ 
function restrict(field,event,strallow)
{
    var key,keychar;
    key=(event.keyCode!=0?event.keyCode:event.charCode);
      keychar = String.fromCharCode(key);
   
    if((key == null) || (key == 0) || (key == 8) || (key == 9) || (key == 13) || (key == 27))
    { 
        return true;
    }
    else if((strallow.indexOf(keychar) != -1))
    {
        return true;
    }
    else
    {
        return false;
    }
}
/*
              
                , querySrcPortInfo   .
 @param selectSort      
 */
function changeSrcPort()
{
    if ($("apply").disabled)
    {
        $("apply").disabled = false;
    }
   
   if(ECOMBoard == winurlobj.boardType)
   {
   	  return;
   }

    var portInfoTbodyNode = getPortInfoTbodyNode();
    
    var srcPortSelected = evplCT.getAttrValue("sourcePort");
    if ("" == srcPortSelected)
    { 
          alert(RESOURCE["srcPortEmpty"]);
          return;
    }
    
    var snkPortSelected = evplCT.getAttrValue("snkPort");
       
    if (srcPortSelected == snkPortSelected)
    {
        if (portInfoTbodyNode.children[1])
        {
            portInfoTbodyNode.removeChild(portInfoTbodyNode.children[1]);
        }
    }
    else
    {  
        changeSnkPort();
    } 
    querySrcPortInfo();
}

/*
               
 @param selectSort      
 */
function changeSnkPort()
{
    if ($("apply").disabled)
    {
        $("apply").disabled = false;
    }
    
    if(ECOMBoard == winurlobj.boardType)
    {
    	return;
    }

    var srcPortSelected = evplCT.getAttrValue("sourcePort");
    
    var snkPortSelected = evplCT.getAttrValue("snkPort");
    
    if ("" == snkPortSelected)
    { 
          alert(RESOURCE["snkPortEmpty"]);
          return;
    }
    var portInfoTbodyNode = getPortInfoTbodyNode();
    
    if (srcPortSelected == snkPortSelected)
    {
        if (portInfoTbodyNode.children[1])
        {
            portInfoTbodyNode.removeChild(portInfoTbodyNode.children[1]);
        }
    }
    else
    {
        if (!portInfoTbodyNode.children[1])
        {
            var tr = document.createElement("tr");             
            
            snkPortNameTD = document.createElement("td");
             
            var td2 = document.createElement("td");
            portTypeAtom2 = new Atom("select");
            portTypeAtom2.addOption(PORT_TYPE_UNI, PORT_TYPE_UNI_VALUE);
          
            var tmptype = evplCT.getAttrValue("servSort");
            if (tmptype != "EPL")
            {
            portTypeAtom2.addOption(PORT_TYPE_C_AWARE, PORT_TYPE_C_AWARE_VALUE);
            portTypeAtom2.addOption(PORT_TYPE_S_AWARE, PORT_TYPE_S_AWARE_VALUE);
            portTypeAtom2.element.disabled = true;
            }
            portTypeAtom2.element.onchange = changeSnkPortType;
            td2.appendChild(portTypeAtom2.element);
             
            var td3 = document.createElement("td");
            portAbleAtom2 = new Atom("select");
            portAbleAtom2.addOption(RESOURCE[PortEnable["Y"]], PORT_ENABLE_Y_VALUE);
            portAbleAtom2.addOption(RESOURCE[PortEnable["N"]], PORT_ENABLE_Y_VALUE);
            td3.appendChild(portAbleAtom2.element);
             
            var td4 = document.createElement("td");
            tagAtom2 = new Atom("select");
            tagAtom2.addOption(PORT_TAG_ACCESS, PORT_TAG_ACCESS_VALUE);
            tagAtom2.addOption(PORT_TAG_TAG_AWARE, PORT_TAG_TAG_AWARE_VALUE);
            tagAtom2.addOption(PORT_TAG_HYBRID, PORT_TAG_HYBRID_VALUE);
            td4.appendChild(tagAtom2.element);
             
            tr.appendChild(snkPortNameTD);
            tr.appendChild(td2);
            tr.appendChild(td3);
            tr.appendChild(td4);
            portInfoTbodyNode.appendChild(tr);
        } 
        
        var serviceType = evplCT.getAttrValue("servSort");
        var operationType = null;         
        if (SERVICE_TYPE_EPL_VALUE == serviceType)
        {            
            portTypeAtom2.setValue(PORT_TYPE_UNI_VALUE);
        }
        else
        {
            operationType = evplCT.getAttrValue("oprType");
            if (OPERATION_ADD_SVAN_VALUE == operationType ||OPERATION_Add_SVLAN_CVLAN_VALUE == operationType)
            {
                portTypeAtom2.setValue(PORT_TYPE_S_AWARE_VALUE);
            }
            else if (OPERATION_STRIP_SVLAN_VALUE == operationType || OPERATION_STRIP_SVLAN_CVLAN_VALUE == operationType)
            {
                portTypeAtom2.setValue(PORT_TYPE_C_AWARE_VALUE);
            }
            else if (OPERATION_TRANSMIT_CVLAN_VALUE == operationType || OPERATION_TRANSLATE_CVLAN_VALUE == operationType)
            {
                portTypeAtom2.setValue(PORT_TYPE_C_AWARE_VALUE);
            }
            else if (OPERATION_TRANSMIT_SVLAN_VALUE == operationType || OPERATION_TRANSLATE_SVLAN_VALUE == operationType || OPERATION_TRANSLATE_SVLANCVLAN_VALUE == operationType)
            {
                portTypeAtom2.setValue(PORT_TYPE_S_AWARE_VALUE);
            }
        }

        querySnkPortInfo();
    }
}

function querySnkPortInfo()
{
    var snkPortSelected = evplCT.getAttrValue("snkPort");
    
    var isMACPort = (0x8000 > snkPortSelected); 
    
    evplCT.getAtom("servSort").element.disabled = true;
    evplCT.getAtom("servDir").element.disabled = true;
    evplCT.getAtom("sourcePort").element.disabled = true;
    evplCT.getAtom("snkPort").element.disabled = true
    $("submitbtn").disabled = true;
    $("cancel").disabled = true;
    $("apply").disabled = true;
       
    var xmlData = queryPortAtrrXml(snkPortSelected);
    
    var URL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&flag=1&nmUser="+winurlobj["nmUser"];
    
    loadXMLdoc(URL, "POST", true,querySnkPortInfoBack, null, "inputdata=" + xmlData);
}

function getPortInfoTbodyNode()
{
    var portInfoTbodyNode = null;
    for (var i = 0, len = $("portAttribute").childNodes.length; i < len; i++)
    {
          if ("TBODY" == $("portAttribute").childNodes[i].tagName)
          {
              portInfoTbodyNode = $("portAttribute").childNodes[i];
          }
    }
    
    return portInfoTbodyNode;
}

/*
        
 */
function changeSrcPortType(srcPortTag)
{
    $("apply").disabled = false;
    if (PORT_TYPE_UNI_VALUE == portTypeAtom1.getValue())
    {
        tagAtom1.element.length = 0;
        tagAtom1.addOption(PORT_TAG_ACCESS, PORT_TAG_ACCESS_VALUE);
        tagAtom1.addOption(PORT_TAG_TAG_AWARE, PORT_TAG_TAG_AWARE_VALUE);
        tagAtom1.addOption(PORT_TAG_HYBRID, PORT_TAG_HYBRID_VALUE);
        
        tagAtom1.element.selectedIndex = 1;
        tagAtom1.element.disabled = false;
    }
    else
    {
        tagAtom1.element.length = 0;
        tagAtom1.addOption("-", INVALID_VALUE);
        tagAtom1.element.disabled = true; 
    }
}

/*
 *        
 */
function changeSnkPortType(snkPortTag)
{
    $("apply").disabled = false;
    
    if (PORT_TYPE_UNI_VALUE == portTypeAtom2.getValue())
    {
        tagAtom2.element.length = 0;
        tagAtom2.addOption(PORT_TAG_ACCESS, PORT_TAG_ACCESS_VALUE);
        tagAtom2.addOption(PORT_TAG_TAG_AWARE, PORT_TAG_TAG_AWARE_VALUE);
        tagAtom2.addOption(PORT_TAG_HYBRID, PORT_TAG_HYBRID_VALUE);
        
        tagAtom2.element.selectedIndex = 1;
        tagAtom2.element.disabled = false;
    }
    else
    {
        tagAtom2.element.length = 0;
        tagAtom2.addOption("-", INVALID_VALUE);
        tagAtom2.element.disabled = true; 
    }
}

    
/*
       
 */
function ServiceInfo()
{   
    this.neid=null;  
    this.soltID=null;     
    this.servType=null;     
    this.servDir=null;     
    this.oprType = null;     
    this.srcPort = null;     
    this.srcCVlan = null;     
    this.srcSVlan = null;  
    this.snkPort = null;     
    this.snkCVlan = null;    
    this.snkSVlan = null;    
    this.srcPortFlag = false;
    this.portType1 = null;
    this.portEnable1 = null;
    this.portTag1 = null;
    this.snkPortFlag = false;
    this.portType2 = null;
    this.portEnable2 = null;
    this.portTag2 = null;

    this.torowparamEPL=function()
    {
        var rowArry = new Array();
        var row = null;
        row = new tagElement("row-params");

        this.addParam(row,"neID",this.neid);
        this.addParam(row,"slotID",this.soltID);
        
        this.addParam(row,"direction", DIRECTION_UNILATERALISM_VALUE);
        
        this.addParam(row,"srcPort",this.srcPort);
        
        if (INVALID_VLAN_VALUE != this.srcCVlan)
        {
            this.addParam(row,"srcCVlan",this.srcCVlan);
        }
        
        this.addParam(row,"snkPort",this.snkPort);
        
        if (INVALID_VLAN_VALUE != this.snkCVlan)
        {
            this.addParam(row,"snkCVlan",this.snkCVlan);
        }
        rowArry.push(row);

        return rowArry;
    } 

    this.torowparamEVPL=function()
    {
        var rowArry = new Array();
        var cvlanPri = null;//c-vlan   
        var svlanPri = null;//s-vlan   
        
        var row = new tagElement("row-params");
                  
        this.addParam(row,"rowFlag","add");
        this.addParam(row,"neID",this.neid);
        this.addParam(row,"slotid",this.soltID);
        this.addParam(row,"srcPort",this.srcPort);
        
        if (INVALID_VLAN_VALUE != this.srcCVlan)
        {
            this.addParam(row,"srcCVlan",this.srcCVlan); 
        }
        if (INVALID_VLAN_VALUE != this.srcSVlan)
        {
            this.addParam(row,"srcSVlan",this.srcSVlan); 
        }

        this.addParam(row,"snkPort",this.snkPort);
        
        if (INVALID_VLAN_VALUE != this.snkCVlan)
        {
            this.addParam(row,"snkCVlan",this.snkCVlan);
        }
        if (INVALID_VLAN_VALUE != this.snkSVlan)
        {
            this.addParam(row,"snkSVlan",this.snkSVlan);
        }
        
        this.addParam(row,"direction", DIRECTION_UNILATERALISM_VALUE);
        
        if (TBEBoard == winurlobj.boardType)
        {
            cVlanPri = evplCT.getAttrValue("cvlanPri");
            if (null != cVlanPri && "-" != cVlanPri)
            {
                this.addParam(row,"cVlanPri", cVlanPri);
            }
            sVlanPri = evplCT.getAttrValue("svlanPri");
            if (null != sVlanPri && "-" != sVlanPri)
            {
                this.addParam(row,"sVlanPri",evplCT.getAttrValue("svlanPri"));
            }
        }  
        rowArry.push(row);
        return rowArry;     
    }   
    
     
    this.torowparamSrcPort=function()
    {
        var row = new tagElement("row-params");

        this.addParam(row,"neid",this.neid);
        this.addParam(row,"slotid",this.soltID);
        this.addParam(row,"boardType",winurlobj.boardType);
        this.addParam(row,"portid",this.srcPort);      
       
        if(isNeedSetPortType(this.srcPort, this.portType1))
    	{
    		 this.addParam(row,"PORTTYPE",this.portType1);
    	} 
        if ("" != this.portTag1 && INVALID_VALUE != this.portTag1)
        {
            this.addParam(row,"TAGTYPE",this.portTag1); 
        }  
        if (!portAbleAtom1.element.disabled)
        {
        	
        	  this.addParam(row,"PORTENABLE",this.portEnable1);             
        }      
       
        return row;
    }
     
    this.torowparamSnkPort=function()
    {
        var row = new tagElement("row-params");

        this.addParam(row,"neid",this.neid);
        this.addParam(row,"slotid",this.soltID);
        this.addParam(row,"boardType",winurlobj.boardType);
        this.addParam(row,"portid",this.snkPort);
        
       if(isNeedSetPortType(this.snkPort, this.portType2))
    	{
    		 this.addParam(row,"PORTTYPE",this.portType2);
    	} 
        if ("" != this.portTag2 && INVALID_VALUE != this.portTag2)
        {
            this.addParam(row,"TAGTYPE",this.portTag2); 
        }  
        if (!portAbleAtom2.element.disabled)
        {
        	 this.addParam(row,"PORTENABLE",this.portEnable2);           
        }      
       
        return row;
    }

    this.addParam=function(row,name,value)
    {
        var param=new tagElement("param");
        param.setAttribute("name",name);
        param.setAttribute("value",value);
        row.appendChild(param);         
    }
}


function isNeedSetPortType(/* String */ portID, /* String */ portType)
{
	for(var i = 0, len = portAttrTable.getDataRowLength(); i < len; i++)
	{
		if( portID == portAttrTable.getCellStoreValue(i,"portID", "port") &&
			portType == portAttrTable.getCellStoreValue(i,"portType", "portType")	)
		{
			return false;
		}
	}
	
	return true;
	
}

function getCvlanRange(cvlanInfo)
{
    var cvlanRange = new Array();
    var cvlanText = evplCT.getAttrValue(cvlanInfo);
    if ("" == cvlanText || "-" == cvlanText)
    {
          return null;
    }
    return cvlanText;
}

function getCvlanArray(cvlanInfo)
{
    var cvlanRange = new Array();
    var cvlanText = evplCT.getAttrValue(cvlanInfo);
    if ("" == cvlanText || "-" == cvlanText)
    {
          return null;
    }
    var str = cvlanText.split(",");
    for(var i = 0, len = str.length ; i < len; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);
           for(var j=rangeStart; j<=rangeEnd;j++)
           {
                cvlanRange.push(""+j);
           }
        }
        else
        {
            cvlanRange.push(str[i]);
        }
    }
    return cvlanRange;
}
    
/*
                
 */
function createServiceList()
{
    var servInfo = new ServiceInfo();     
    servInfo.neid = winurlobj["neID"];
    servInfo.soltID = winurlobj["slotID"];
    servInfo.servType = evplCT.getAttrValue("servSort");     
    servInfo.servDir = evplCT.getAttrValue("servDir");    
    servInfo.srcPort = evplCT.getAttrValue("sourcePort");
    servInfo.srcCVlan = getCvlanRange("srcCVlan"); 
    servInfo.snkPort = evplCT.getAttrValue("snkPort");    
    servInfo.snkCVlan = getCvlanRange("snkCVlan"); 

    if (null == servInfo.srcCVlan)    
    {
          servInfo.srcCVlan = INVALID_VLAN_VALUE;
    }         
    if (null == servInfo.snkCVlan)    
    {
        servInfo.snkCVlan = INVALID_VLAN_VALUE;
    } 

    if (SERVICE_TYPE_EVPL_VALUE == servInfo.servType )
    {           
        servInfo.oprType = evplCT.getAttrValue("oprType");
        servInfo.srcSVlan = evplCT.getAttrValue("srcSVlan"); 
        if (null == servInfo.srcSVlan || "-" == servInfo.srcSVlan)    
        {
              servInfo.srcSVlan = INVALID_VLAN_VALUE;
        }       
        servInfo.snkSVlan = evplCT.getAttrValue("snkSVlan"); 
        if (null == servInfo.snkSVlan || "-" == servInfo.snkSVlan)    
        {
              servInfo.snkSVlan = INVALID_VLAN_VALUE;
        }           
    }

    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowArry = null;
    if (SERVICE_TYPE_EPL_VALUE == servInfo.servType)
    {
        rowArry = servInfo.torowparamEPL();    
    }
    else if (SERVICE_TYPE_EVPL_VALUE == servInfo.servType)
    {
        rowArry = servInfo.torowparamEVPL();
    }
    for (var i = 0, len = rowArry.length ; i < len; i++)
    {
          bussiness.appendChild(rowArry[i]);
    }     
    root.getRoot().appendChild(bussiness);
    var xml = root.toString();

    return xml;     
}

/*
                   
 */
function createServiceListSrc()
{    
    var servInfo = new ServiceInfo();     
    servInfo.neid = winurlobj["neID"];
    servInfo.soltID = winurlobj["slotID"];
    servInfo.srcPort = evplCT.getAttrValue("sourcePort");  
    servInfo.portType1 = portTypeAtom1.getValue();
    servInfo.portEnable1 = portAbleAtom1.getValue();
    servInfo.portTag1 = tagAtom1.getValue(); 
     
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");   
    bussiness.appendChild(servInfo.torowparamSrcPort());
    root.getRoot().appendChild(bussiness);
    var xml = root.toString();

    return xml; 
}  

/*
                   
 */
function createServiceListSnk()
{    
    var servInfo = new ServiceInfo();     
    servInfo.neid=winurlobj["neID"];
    servInfo.soltID = winurlobj["slotID"];     
    servInfo.snkPort = evplCT.getAttrValue("snkPort");  
    servInfo.portType2 = portTypeAtom2.getValue();
    servInfo.portEnable2 = portAbleAtom2.getValue();
    servInfo.portTag2 = tagAtom2.getValue(); 
     
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");   
    bussiness.appendChild(servInfo.torowparamSnkPort());
    root.getRoot().appendChild(bussiness);
    var xml = root.toString();

    return xml; 
}  

/*
 *       
 * createLineService    
 *       sendRequestParam(element)      
 */
function validateForm()
{
    var srcPort = evplCT.getAttrValue("sourcePort");//       
    var snkPort = evplCT.getAttrValue("snkPort");//   
    var srcCVlanText = evplCT.getAttrValue("srcCVlan");// CVlan     
    var snkCVlanText = evplCT.getAttrValue("snkCVlan");// CVlan
    var srcSVlanText = null;// S-VLAN
    var snkSVlanText = null;// S-VLAN
    
    if (srcPort == snkPort)
    {
          alert(RESOURCE["srcPortSnk"]);
          return false;
    }
    
    if(!isValidateVlan("srcCVlan"))
    {
        return false;
    }

    if(!isValidateVlan("snkCVlan"))
    {
        return false;
    }
    
    if (SERVICE_TYPE_EPL_VALUE == evplCT.getAttrValue("servSort"))
    { 
    	var srcCVlanvar = evplCT.getAttrValue("srcCVlan");
    	var sinkCVlanvar = evplCT.getAttrValue("snkCVlan");
    	
    	if (srcCVlanvar == "" && sinkCVlanvar !="" && sinkCVlanvar != null && sinkCVlanvar != undefined)
    	{
    		alert(RESOURCE["srcCVlanBlank"]);
    		return;
    	}
    	
    	if (sinkCVlanvar == "" && srcCVlanvar !="" && srcCVlanvar != null && srcCVlanvar != undefined)
    	{
    		alert(RESOURCE["snkCVlanBlank"]);
    		return;
    	}
    }
    
    if (SERVICE_TYPE_EVPL_VALUE == evplCT.getAttrValue("servSort"))
    {                         
        srcSVlanText = evplCT.getAttrValue("srcSVlan");// S-VLAN
        snkSVlanText = evplCT.getAttrValue("snkSVlan");// SVlan  
        
        if(!srcSVlanText)
        {    
            alert(RESOURCE["srcSVlanBlank"]);
            return false;
        }

        if(!snkSVlanText)
        {    
            alert(RESOURCE["snkSVlanBlank"]);
            return false;
        }    
        
        if (OPERATION_ADD_SVAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            if (srcCVlanText != snkCVlanText)
            {
                alert(RESOURCE["srcCVlansnkMustSame"]);
                return false;
            }
        }
        
        if (OPERATION_Add_SVLAN_CVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            if (snkCVlanText == null || snkCVlanText == "")
            {
                alert(RESOURCE["snkCVlanBlank"]);
                return false;
            }
        }
        
        if (OPERATION_STRIP_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            if (srcCVlanText != snkCVlanText)
            {
                alert(RESOURCE["srcCVlansnkMustSame"]);
                return false;
            }
        }   
        
        if (OPERATION_STRIP_SVLAN_CVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            if (srcCVlanText == null)
            {
                alert(RESOURCE["srcCVlanBlank"]);
                return false;
            }
        }
        
        if (OPERATION_TRANSMIT_CVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            if (srcCVlanText != snkCVlanText)
            {
                alert(RESOURCE["srcCVlansnkMustSame"]);
                return false;
            }
        }
  
        if (OPERATION_TRANSMIT_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            if (srcSVlanText != snkSVlanText)
            {
                alert(RESOURCE["srcSVlansnkMustSame"]);
                return false;
            }
        }
        
        if (OPERATION_TRANSLATE_SVLAN_VALUE == evplCT.getAttrValue("oprType"))
        {
            if (srcSVlanText == snkSVlanText)
            {
                alert(RESOURCE["srcSVlansnk"]);
                return false;
            }
        }
    }   
    
    var cvlanArray = getCvlanArray("srcCVlan");
    if (null != cvlanArray && MAX_SERVICE_COUNT["TBE"] < cvlanArray.length)
    {
          alert(RESOURCE["maxCount2048"]);
          return null;
    }  
    if(cvlanArray!=null&&cvlanArray.length>32)
    {
    	if(!confirm(RESOURCE["confirmActivate"]))
    	{
    		return null;	
    	}
    }
         
    return true;
}    
/*
         
 */
function isPortAttri()
{
      if ("" == tagAtom1.getValue())
      {       
          return false;
      }
      if (tagAtom2 && "" == tagAtom2.getValue())
      {       
          return false;
      }
      return true;
}

/*
 *        ,    
 *      sendRequestParam(element)  
 */
function createLineService(element)
{   	
    window.actionid = element.id;
    
    if(window.actionid == "submitbtn" && true == $("apply").disabled)
    {
        xcloseDialog();
        return;
    }
    
    if(!validateForm())
    {         
        return;
    }

    var xml = createServiceList();
    if (null == xml)
    {
          return;
    }

    if(ECOMBoard == winurlobj.boardType)
    {
        sendXmlData(xml);
    }
    else
    {
        isPortModifySucc = true;
    
        var xmlSrc = createServiceListSrc();
        sendXmlDataPort(xmlSrc);
     
        if (isPortModifySucc)
        {
            var xmlSnk = createServiceListSnk();
            sendXmlDataPort(xmlSnk);
            
            if (isPortModifySucc)
            {
                sendXmlData(xml); 
            }
        }
    }
}

/*
       
 */
function createTable(winEplData)
{
    var boardList = [];
    boardList["boardName"] = winEplData.getDataRowParam(0, "boardName");
    
    evplCT = new CTable();
    
    evplCT.addHead(RESOURCE["colName1"],RESOURCE["colName2"]);
    
    var brdAtom = new Atom("span");
    brdAtom.setValue(winEplData.getDataRowParam(0, "shelfName") + "-" + boardList["boardName"]);
    
    evplCT.addAttrRow("board", RESOURCE["board"], brdAtom);

    addServiceTypeRow(evplCT);

    addServDirRow(evplCT);
    
    portList = getSupportPort(winEplData);

    addSourcePortRow(evplCT);
           
    addSrcCVlanRow(evplCT);

    addSnkPortRow(evplCT);

    addSnkCVlanRow(evplCT); 
    
    document.body.insertBefore(evplCT.getTable(), document.body.firstChild);
    
    if(ECOMBoard == winurlobj.boardType)
    {
        changePage(evplCT.getAtom("servSort").element);
        changeDirection(evplCT.getAtom("servDir").element);
    }
    else
    {
        addPortInfoTable();
    }
    
    var portNo = evplCT.getAttrValue("sourcePort");
    if ("" == portNo)
    {
        alert(RESOURCE["portEmpty"]);
        return;
    }

    if(ECOMBoard != winurlobj.boardType)
    {
        querySrcPortInfo();
    }  
}

function addServiceTypeRow(evplCT)
{
    var serviceTypeAtom  = new Atom("select");

    if(ECOMBoard == winurlobj.boardType)//ECOM       QinQ,    QinQ
    {
    	disabledShowShared();
    }
    else
    {
    	serviceTypeAtom.addOption(SERVICE_TYPE_EPL, SERVICE_TYPE_EPL_VALUE);
    }

    if (true == parentWin.document.getElementById("showShared").checked)
    {
        serviceTypeAtom.addOption(SERVICE_TYPE_EVPL, SERVICE_TYPE_EVPL_VALUE);
    }
    serviceTypeAtom.element.onchange = changePage;
    evplCT.addAttrRow("servSort", RESOURCE["servSort"], serviceTypeAtom);
}

function addServDirRow(evplCT)
{
    var servDirAtom = new Atom("select");
    
    
    servDirAtom.addOption(DIRECTION_UNILATERALISM, DIRECTION_UNILATERALISM_VALUE);
    
    servDirAtom.element.onchange = changeDirection;
    
    evplCT.addAttrRow("servDir",RESOURCE["servDir"], servDirAtom);
}

function addSnkCVlanRow(evplCT)
{
    var snkCVlanAtom = new Atom("text");
    snkCVlanAtom.element["onblur"]= isValidateSnkCVlan;
    snkCVlanAtom.element["onkeypress"] = function()
    {
         var code = event.keyCode!=0?event.keyCode:event.charCode;
        var codeValue = String.fromCharCode(code);   
        var index = digitalTag_getPos(this);   
        var lastValue2 = this.value;

    	var thisValue2 = this.value.substring(0,index) + codeValue + this.value.substring(index);	

        var rep2 = /-/gi;
        var value2 = thisValue2.replace(rep2,",");
        var values2 = value2.split(",");
        for(i = 0; i < values2.length; i++)
        {                        
            if(0 == values2[i].indexOf("0"))
            {               
                this.value = lastValue2;
                return false;                
            }
        }
        
    	var bol2 = chkCVlan(this,event,"snkCVlan");    	
        
        if(bol2)
        {
            lastValue2 = thisValue2;
        }
        return bol2;
    }    
      snkCVlanAtom.element.onpaste = function()
      {
      }
      snkCVlanAtom.element.onchange = function()
	  {	     	      
	     $("apply").disabled = false;
	  }

      if (true == parentWin.document.getElementById("showShared").checked)
    {
          evplCT.addAttrRow("snkCVlan",RESOURCE["snkC-VLAN"] , snkCVlanAtom);
    }
    else
    {
          evplCT.addAttrRow("snkCVlan",RESOURCE["snkVLAN"] , snkCVlanAtom);
    }
}

function addSnkPortRow(evplCT)
{
    var snkPortAtom = new Atom("select");
    for(var i = 0, len1 = portList.length;i < len1; i++)
    {
        snkPortAtom.addOption(portList[i].portName, portList[i].portno);
    }     
    snkPortAtom.element.onchange = changeSnkPort;
    evplCT.addAttrRow("snkPort",RESOURCE["snkPort"] , snkPortAtom);
}

function addSrcCVlanRow(evplCT)
{
    var srcCVlanAtom = new Atom("text");
    srcCVlanAtom.element["onblur"]= isValidateSrcCVlan;
    srcCVlanAtom.element["onkeypress"] = function()
    {
        var code = event.keyCode!=0?event.keyCode:event.charCode;
        var codeValue = String.fromCharCode(code);   
        var index = digitalTag_getPos(this);   
        var lastValue1 = this.value;

        var thisValue1 = this.value.substring(0,index) + codeValue + this.value.substring(index);

        var rep1 = /-/gi;
        var value1 = thisValue1.replace(rep1,",");
        var values1 = value1.split(",");
        for(i = 0; i < values1.length; i++)
        {                        
            if(0 == values1[i].indexOf("0"))
            {               
                this.value = lastValue1;
                return false;                
            }
        }
        
        var bol1 = chkCVlan(this,event,"srcCVlan");    	
        if(bol1)
        {
            lastValue1 = thisValue1;
        }
        return bol1;
    }    
    srcCVlanAtom.element.onpaste = function()
    {
    }
    srcCVlanAtom.element.onchange = function()
	{	     	      
	    $("apply").disabled = false;
	}

    if (true == parentWin.document.getElementById("showShared").checked)
    {
        evplCT.addAttrRow("srcCVlan",RESOURCE["sourceC-VLAN"] , srcCVlanAtom);
    }
    else
    {
        evplCT.addAttrRow("srcCVlan",RESOURCE["sourceVLAN"] , srcCVlanAtom);
    }
}

function addSourcePortRow(evplCT)
{
    var sourcePortAtom = new Atom("select");
    for(var i = 0, len1 = portList.length;i < len1; i++)
    {
        sourcePortAtom.addOption(portList[i].portName, portList[i].portno); 
    } 
    
    sourcePortAtom.element.onchange = changeSrcPort;
    evplCT.addAttrRow("sourcePort",RESOURCE["sourcePort"] , sourcePortAtom);
} 

function addPortInfoTable()
{    
    portTypeAtom1 = new Atom("select");
    portTypeAtom1.addOption(PORT_TYPE_UNI, PORT_TYPE_UNI_VALUE);
   
    var tmptype = evplCT.getAttrValue("servSort");
    if (tmptype != "EPL")
    {
    	portTypeAtom1.addOption(PORT_TYPE_C_AWARE, PORT_TYPE_C_AWARE_VALUE);
        portTypeAtom1.addOption(PORT_TYPE_S_AWARE, PORT_TYPE_S_AWARE_VALUE);
        portTypeAtom1.element.disabled = true;
    }
    portTypeAtom1.element.onchange = changeSrcPortType;
    $("portType1").appendChild(portTypeAtom1.element);
             
    portAbleAtom1 = new Atom("select");
    portAbleAtom1.addOption(RESOURCE[PortEnable["Y"]], PORT_ENABLE_Y_VALUE);
    portAbleAtom1.addOption(RESOURCE[PortEnable["N"]], PORT_ENABLE_N_VALUE);
    $("portEnable1").appendChild(portAbleAtom1.element);
             
    tagAtom1 = new Atom("select");
    tagAtom1.addOption(PORT_TAG_ACCESS, PORT_TAG_ACCESS_VALUE);
    tagAtom1.addOption(PORT_TAG_TAG_AWARE, PORT_TAG_TAG_AWARE_VALUE);
    tagAtom1.addOption(PORT_TAG_HYBRID, PORT_TAG_HYBRID_VALUE);
    $("tagSign1").appendChild(tagAtom1.element);
}

function querySrcPortInfo()
{
    evplCT.getAtom("servSort").element.disabled = true;
    evplCT.getAtom("servDir").element.disabled = true;
    evplCT.getAtom("sourcePort").element.disabled = true;
    evplCT.getAtom("snkPort").element.disabled = true;
    $("submitbtn").disabled = true;
    $("cancel").disabled = true;
    $("apply").disabled = true;   
    
    var sourcePortID = evplCT.getAttrValue("sourcePort"); 
    
    var isMACPort = (0x8000 > sourcePortID);

    var xmlData = queryPortAtrrXml(sourcePortID);
    
    var URL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&flag=1&nmUser="+winurlobj["nmUser"];
    
    loadXMLdoc(URL, "POST", true, querySrcPortInfoBack, null, "inputdata="+xmlData);
}

function chkCVlan(obj,event,Vlan,chkValue)
{
    var code=(event.keyCode!=0?event.keyCode:event.charCode);
    var ch = String.fromCharCode(code);
    if(code == 8 || code == 46 || code == 37 || code == 39)
    {
        return true;   //DEL   
    }
      if (document.getElementById("apply").disabled)
      {
          document.getElementById("apply").disabled = false;
      }
    if(!restrict(obj, event, "0123456789,-"))
    {
        return false;
    }
     
    var value=obj.value;
    pos=digitalTag_getPos(obj);                 //        

    if((value.length == 0) && (pos==0) ){
        return true;
    }
    
    if(event.type == "keydown")
    {
        if(pos == 0 && value.length > 0 && (code == 48 || code == 96) && selectionLen(obj) != value.length)
        { 
            return false;
        }
    }
    else
    {
        if(pos == 0 && value.length > 0 && code == 48 && selectionLen(obj) != value.length)
        { 
            return false;
        }
    }
    if(value=='0' && pos>0)
    {
        return false;
    }
    
    var newVal = value.substring(0,pos) + ch + value.substring(pos+selectionLen(obj));

    if(!isCVlan(Vlan,newVal))
    {
        return false;
    }
    return true;

}

/*
               
 */
function isCVlan(Vlan,newVal)
{
    
   
    var text= newVal;
    
    if(!text || "-" == text)
    {
        return true;
    }
    var str=text.split(",");
    
    var limitHigh = MAXINPUT;
    var limitLow = MININPUT;
    for(var i=0; i<str.length; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);

            if((rangeStart>limitHigh) || (rangeEnd>limitHigh)
                ||(rangeStart<limitLow) ||(rangeEnd<limitLow))
            {
       	        alert(RESOURCE["numberLimit2"]);
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>limitHigh || parseInt(str[i])<limitLow)
           {
           	    alert(RESOURCE["numberLimit2"]);
                return false;
           }
        }
    }
    return true;
}


/*
 *        
 * @param doc        
 *       function getPortAtrr(doc)  
 */
function querySrcPortInfoBack(doc)
{
    evplCT.getAtom("servSort").element.disabled = false;
    evplCT.getAtom("servDir").element.disabled = false;
    evplCT.getAtom("sourcePort").element.disabled = false;
    evplCT.getAtom("snkPort").element.disabled = false;
    $("submitbtn").disabled = false;
    $("cancel").disabled = false;
    $("apply").disabled = false;     
    
    var portAttrData = EncapsulateData(doc);
    
    if (OPRSUCC != portAttrData.getSErrorCode()) 
    {
        showErrorDialog(portAttrData);
        return;
    }
    
    var portType = null;
    var portEnable = null;
    var srcPortTag = null;
    var strPortID = null;
    var isMACPort = null;

    srcPortID = portAttrData.getDataRowParam(0,"port"); 
    isMACPort = (srcPortID < 0x8000);//   MAC 
          
    if (isMACPort)
    {
        portType = portAttrData.getDataRowParam(0,"PORTTYPE");
        portEnable = portAttrData.getDataRowParam(0,"PORTENABLE"); 
        srcPortTag = portAttrData.getDataRowParam(0,"TAGTYPE");         
    }    
    else
    {
        portType = portAttrData.getDataRowParam(0,"PORTTYPE");  
        srcPortTag = portAttrData.getDataRowParam(0,"TAGTYPE");         
    } 
    
    if (isMACPort)
    {
        $("portName1").innerHTML = "PORT" + srcPortID;
    }
    else
    {
        $("portName1").innerHTML = "VCTRUNK" + (srcPortID - 0x8000);
    }    
    
    if (!isMACPort || null == portEnable)
    {
        portAbleAtom1.element.options.length=0;
        portAbleAtom1.addOption("-", "-");
        portAbleAtom1.element.disabled = true;
    }
    else
    {
        portAbleAtom1.element.options.length=0;
        portAbleAtom1.addOption(RESOURCE[PortEnable["Y"]], PORT_ENABLE_Y_VALUE);
        portAbleAtom1.addOption(RESOURCE[PortEnable["N"]], PORT_ENABLE_N_VALUE);
        portAbleAtom1.setValue(portEnable);
        portAbleAtom1.element.disabled = false;
    }
    
    if (null != srcPortTag)
    {
        changeSrcPortType(srcPortTag);
    }
    else
    {
        tagAtom1.setValue(PORT_TAG_UNVAID_VALUE);
        tagAtom1.element.disabled = true;        
    }
}

/*
 *         
 *@param doc        
 *      getsnkPortAtrr(doc)  
 */
function querySnkPortInfoBack(doc)
{
    evplCT.getAtom("servSort").element.disabled = false;
    evplCT.getAtom("servDir").element.disabled = false;
    evplCT.getAtom("sourcePort").element.disabled = false;
    evplCT.getAtom("snkPort").element.disabled = false;
    $("submitbtn").disabled = false;
    $("cancel").disabled = false;
    $("apply").disabled = false;   
    
    var portType = null;
    var portEnable = null;
    var snkPortTag = null;
    var snkPortID = null;
    var isMACPort = null;
    
    var portAttrData = EncapsulateData(doc);
    
    if (OPRSUCC == portAttrData.getError().getGlobleECode()
        && null != portAttrData 
        && 0 < portAttrData.getDataRowLength()) 
    {   
        snkPortID = portAttrData.getDataRowParam(0,"port");   
        isMACPort = (snkPortID < 0x8000);//   MAC  
        
        if (isMACPort)
        {
            portType = portAttrData.getDataRowParam(0, "PORTTYPE");
            
            portEnable = portAttrData.getDataRowParam(0, "PORTENABLE"); 
            
            snkPortTag = portAttrData.getDataRowParam(0, "TAGTYPE");         
        }    
        else
        {
            portType = portAttrData.getDataRowParam(0, "PORTTYPE"); 
            
            snkPortTag = portAttrData.getDataRowParam(0, "TAGTYPE");         
        }
    }
    else
    {
        showErrorDialog(portAttrData);
        portType = null;
        portEnable = null; 
        snkPortTag = null; 
    }       
    if (isMACPort)
    {
        snkPortNameTD.innerHTML = "PORT" + snkPortID;
    }
    else
    {
        snkPortNameTD.innerHTML = "VCTRUNK" + (snkPortID - 0x8000);
    }  
    
    if (!isMACPort || null == portEnable)
    {
        portAbleAtom2.element.options.length=0;
        portAbleAtom2.addOption("-", "-");
        portAbleAtom2.element.disabled = true;
    }
    else
    {
        portAbleAtom2.element.options.length=0;
        portAbleAtom2.addOption(RESOURCE[PortEnable["Y"]], PORT_ENABLE_Y_VALUE);
        portAbleAtom2.addOption(RESOURCE[PortEnable["N"]], PORT_ENABLE_N_VALUE);
        portAbleAtom2.setValue(portEnable);
        portAbleAtom2.element.disabled = false;
    }
    
    if (null != snkPortTag)
    {
        changeSnkPortType(snkPortTag);
    }
    else
    {
        tagAtom2.setValue(PORT_TAG_UNVAID_VALUE);
        tagAtom2.element.disabled = true;        
    }
}

/*
         
 */
function queryPortAtrrXml(portID)
{
    var root =new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row=new tagElement("row-params");

    var param=new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj["neID"]);
    row.appendChild(param);
    
    var param=new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",winurlobj["slotID"]);
    row.appendChild(param);
    
    var param=new tagElement("param");
    param.setAttribute("name","boardType");
    param.setAttribute("value",winurlobj["boardType"]);
    row.appendChild(param);
        
    var param=new tagElement("param");
    param.setAttribute("name","portid");
    param.setAttribute("value",portID);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function doCancel()
{
    xcloseDialog();
}

function disabledShowShared()
{
   var showShared = win.document.getElementById("showShared");
   showShared.checked = true;
   showShared.disabled = true;   
}
