
var language = SYSTEMCONF.getLanguage();
var st = new SortTable();
var st1 = new SortTable();
var showCouple = true;
var rowIndex = 0;
var winobj = getNeProperty(parent);
if(winobj == null)
{
	winobj = getNeProperty(self);
}
var nmUser = winobj["nmUser"];
var neID = winobj.neid;
var slotID = winobj.slotid;
var boardtype = winobj.boardType;
var btnRightArr = new Object();
var deleteRight = false;
var convertRight = false;
var applyRight = false;
var sharedFlag = true;
var oprSucc = 0;
var oprFail = 2;
var ports = null;

var TIMEOUT = 41020008;
var TBEBoard = TN11TBE;
var ECOMBoard = "1095";
var QINQ_ADD_TAG = 6;
var BIDIRECTION = 1;

var EPL_SERVICE = 0;
var ADD_SERVICE = 6;
var STRIP_SERVICE = 8;
var TRANSLAT_SERVICE = 10;
var INVALID_VALUE = "255";
var INVALID_VALUE_VLAN = "65535";

/*
 * ??????tab?????????
 */
function tabSelectHandler()
{

      if(btnRightArr.querybtn.right)
      {
	        doQuery(true);
      }
}

/*
 * ?????????????????????
 */        
function createjsDOMenu()
{	
	  removejsDOMmenu();
	  var isSelected = false;
	  
	  for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	  {
	  	  if(st.getRowSelFlag(i))
	  	  {
	  	  	  isSelected = true;
	  	  	  break;
	  	  }
	  }
    var cursorMenu = new jsDOMenu(160); //?????????140
   
    if(ECOMBoard != boardtype)
    {
    	cursorMenu.addMenuItem(new menuItem(RESOURCE["cnvtsncpbutton"], "",convertSNCP, "", isSelected));
    }
    cursorMenu.addMenuItem(new menuItem(RESOURCE["deletebtn"], "",delLink, "", isSelected));
    
    setPopUpMenu(cursorMenu);
}

/*
 * ???????????????????????????????????????
 */
function rightClickEvent()
{
	  createjsDOMenu();
	  rightClickHandler();
}


/**
 * if show shared checkbox on evplbtns.html is checked
 */
function showShared()
{
    return document.getElementById("showShared").checked;
}

/**
 * create query XML request
 */
function createQueryRequest(showCouple, fromNE)
{
    var root = new inputxml("datainterface");
    
	  var pageparamrow = new tagElement("page-params");
    var pageparam = new tagElement("param");
    pageparam.setAttribute("name", "pageNum");
    if("" != $("pagenum").value)
    {
        pageparam.setAttribute("value", $("pagenum").value);
    }
    else
    {
        pageparam.setAttribute("value", "1");
    }
    pageparamrow.appendChild(pageparam);//            
    
    pageparam = new tagElement("param");
    pageparam.setAttribute("name", "resultNumPerPage");
    pageparam.setAttribute("value", $("columnnum").value);
    pageparamrow.appendChild(pageparam);//            
    
    pageparam = new tagElement("param");
    pageparam.setAttribute("name", "sortParam");
    pageparam.setAttribute("value", "vlanid");
    pageparamrow.appendChild(pageparam);//            
    
    pageparam = new tagElement("param");
    pageparam.setAttribute("name", "sortby");
    pageparam.setAttribute("value", "asc");
    pageparamrow.appendChild(pageparam);//            
    root.getRoot().appendChild(pageparamrow);
    
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", neID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", slotID);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "boardtype");
    param.setAttribute("value", boardtype);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "linkID");
    param.setAttribute("value", 0);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "showCouple");
    if (showCouple)
    {
        param.setAttribute("value", 1);
    }
    else
    {
        param.setAttribute("value", 0);
    }
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "showShared");
    if (showShared())
    {
        param.setAttribute("value", 1);
    }
    else
    {
        param.setAttribute("value", 0);
    }
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "fromNE");
    if (fromNE)
    {
        param.setAttribute("value", 1);
    }
    else
    {
        param.setAttribute("value", 0);
    }
    row.appendChild(param);

    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processQueryResponse(doc)
{

    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "slotID";
    var size = dinterface.getBErrLength();
    var boardName = "TBE";
    if(boardtype == ECOMBoard)
    {
    	boardName = "ECOM";
    }
    for(var i = 0;i < size;i++)
    {
	      var tempObj = dinterface.getError().rowErrors[i].errorObj;
  	    tempObj["slotID"] = slotID + "-" + boardName + "-"+ RESOURCE["querybtn"] + RESOURCE["evpltabtitle"];
		}
		if (oprSucc != dinterface.getError().getGlobleECode()) 
    { 
    	  var flag = true;
    	  var len = dinterface.errObj.rowErrors.length
    	  for (var i = 0; i < len; i++)
    	  {
    	  	  if ("41316" != dinterface.errObj.rowErrors[i].error.code)
    	  	  {
    	  	  	  flag = false;
    	  	  	  break;
    	  	  }
    	  }
    	  if (flag && TIMEOUT != dinterface.errObj.s_error.code)
    	  {
    	  	  dinterface.errObj.s_error.code = oprSucc;
    	  }
    }
    openErrPage("../../../../../../page/", dinterface.getError(), errArr);
   
    if (oprFail == dinterface.getError().getGlobleECode() 
        || TIMEOUT == dinterface.getError().getGlobleECode()) 
    {
    	  $("querybtn").disabled = !btnRightArr.querybtn.right;	
        $("createbtn").disabled = !btnRightArr.createbtn.right;
        if (!$("querybtn").disabled && (boardtype != ECOMBoard))
        {
        	  $("showShared").disabled = false;
        }		
        
    	  return;
    }
    
    var totalRecord = dinterface.getPageParam("totalResultNum").value;//         
    var totalPage = dinterface.getPageParam("totalPageNum").value;//     
    var currpage = dinterface.getPageParam("pageNum").value;//    
    var countsPerPage = dinterface.getPageParam("resultNumPerPage").value;//       
    
    $("pagestatus").innerHTML = currpage + "/" + totalPage;
    
    $("pagenum").options.length = 0;
    
    for(var i = 0; i < totalPage; i++)
    {
    	$("pagenum").options[i] = new Option(i+1, i+1);
    }
    
    $("pagenum").value = currpage;
    
    if (currpage > 1)
    {
        $("previouspage").innerHTML = "<a href='javascript:pageup();'><u>" + RESOURCE["previouspage"] + "</u></a>";
        $("firstpage").innerHTML = "<a href='javascript:firstpage();'><u>" + RESOURCE["firstpage"] + "</u></a>";
    }
    else
    {
        $("previouspage").innerHTML = RESOURCE["previouspage"];
        $("firstpage").innerHTML = RESOURCE["firstpage"];
    }
    
    if (currpage != totalPage)
    {
    	  $("nextpage").innerHTML = "<a href='javascript:pagedown();'><u>" + RESOURCE["nextpage"] + "</u></a>";
        $("lastpage").innerHTML = "<a href='javascript:lastpage();'><u>" + RESOURCE["lastpage"] + "</u></a>";
    }
    else
    {
        $("nextpage").innerHTML = RESOURCE["nextpage"];
        $("lastpage").innerHTML = RESOURCE["lastpage"];
    }
    
    if(countsPerPage != 20 && countsPerPage != 40 && countsPerPage != 60 &&
    		countsPerPage != 80 && countsPerPage != 100)
    {
    	  $("columnnum").value = 0;
    }
    else
    {
    	  $("columnnum").value = countsPerPage;
    }
    
    clearTable();

    for(var i = 0, len = dinterface.getDataRowLength(); i < len; i++)
	  {
	  	  var diobj = dinterface.rows[i];
    	  var ptag = null;
	  	  if (0x8000 > dinterface.getDataRowParam(i,"srcPort"))
	  	  {
    	      ptag = new ParamTag();
    	      ptag.value = "PORT" + dinterface.getDataRowParam(i, "srcPort");
    	      diobj["srcPort"]=ptag;
	  	  }
        else
        {
        	  ptag = new ParamTag();
    	      ptag.value = "VCTRUNK" + (dinterface.getDataRowParam(i, "srcPort") - 0x8000);
    	      diobj["srcPort"]=ptag;
        }
        if (0xFFFF == dinterface.getDataRowParam(i,"srcVlan"))
        {
    	  
    	      ptag = new ParamTag();
    	      ptag.value = "-";
    	      diobj["srcVlan"]=ptag;
        }
        if (0xFFFF == dinterface.getDataRowParam(i,"srcSVlan"))
        {
    	  
    	      ptag = new ParamTag();
    	      ptag.value = "-";
    	      diobj["srcSVlan"]=ptag;
        }
        if (0x8000 > dinterface.getDataRowParam(i,"snkPort"))
	  	  {
    	      ptag = new ParamTag();
    	      ptag.value = "PORT" + dinterface.getDataRowParam(i, "snkPort");
    	      diobj["snkPort"]=ptag;
	  	  }
        else
        {
        	  ptag = new ParamTag();
    	      ptag.value = "VCTRUNK" + (dinterface.getDataRowParam(i, "snkPort") - 0x8000);
    	      diobj["snkPort"]=ptag;
        }
        if (0xFFFF == dinterface.getDataRowParam(i,"snkVlan"))
        {
    	  
    	      ptag = new ParamTag();
    	      ptag.value = "-";
    	      diobj["snkVlan"]=ptag;
        }
        if (0xFFFF == dinterface.getDataRowParam(i,"snkSVlan"))
        {
    	  
    	      ptag = new ParamTag();
    	      ptag.value = "-";
    	      diobj["snkSVlan"]=ptag;
        }
        if (QINQ_ADD_TAG != dinterface.getDataRowParam(i,"linkType"))
        {
    	  
    	      ptag = new ParamTag();
    	      ptag.value = "inavailable";
    	      diobj["cVlanPri"]=ptag;
    	      
    	      ptag = new ParamTag();
    	      ptag.value = "inavailable";
    	      diobj["sVlanPri"]=ptag;
        }
	  }   
	  createGenCfgTableBody(st, window.tableconf[0], dinterface);
	  for(var i = st.getDataRowLength() - 1; i >= 0; i--)
	  {
	  	  if ("VCTRUNK32767" == st.getCellCurrentValue(i,"srcPort", "srcPort")
	  	      || "VCTRUNK32767" == st.getCellCurrentValue(i,"snkPort", "snkPort"))

	  	  {
	  	  	  st.deleteRow(i);
	  	  }    
	  }
	  st.adjustDataRows();
	  
	  for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	  {
	  	  if (!showShared())
        {
        	  st.getCell(i,"srcSVlan").element.style.display = "none";
        	  st.getCell(i,"snkSVlan").element.style.display = "none";
        	  st.getCell(i,"cVlanPri").element.style.display = "none";
        	  st.getCell(i,"sVlanPri").element.style.display = "none";          	  
        }
        if ((TBEBoard != boardtype) && (ECOMBoard != boardtype))
        {
            st.getCell(i,"cVlanPri").element.style.display = "none";
        	  st.getCell(i,"sVlanPri").element.style.display = "none";     	
        }
      	if (INVALID_VALUE == st.getCellStoreValue(i,"oamEN", "oamEN"))
	  	  {
	  	  	  st.setCellIsEdit(st.getCell(i,"oamEN"),0);
	  	  }
	  	  if ("inavailable" == st.getCellStoreValue(i,"cVlanPri", "cVlanPri"))
	  	  {
	  	  	  st.setCellIsEdit(st.getCell(i,"cVlanPri"),0);
	  	  	  
	  	  	  st.setCellIsEdit(st.getCell(i,"sVlanPri"),0);
	  	  }
	  	  if(ECOMBoard == boardtype)
	  	  {
	  	  	st.getCell(i,"oamEN").element.style.display = "none"; 
	  	  }
	  }

    st.getHeadCell("upLinkID").element.style.display = "none";
    st.getHeadCell("downLinkID").element.style.display = "none";
    if (!showShared())
    {
        st.getHeadCell("srcSVlan").element.style.display = "none";
        st.getHeadCell("snkSVlan").element.style.display = "none";
        st.getHeadCell("cVlanPri").element.style.display = "none";
        st.getHeadCell("sVlanPri").element.style.display = "none";
        st.getHeadCell("srcVlan").element.innerHTML = RESOURCE["srcVlan"];
        st.getHeadCell("snkVlan").element.innerHTML = RESOURCE["snkVlan"];
    }
    else
    {
        st.getHeadCell("srcSVlan").element.style.display = "";
        st.getHeadCell("snkSVlan").element.style.display = "";
        if (TBEBoard == boardtype)
        {
            st.getHeadCell("cVlanPri").element.style.display = "";
            st.getHeadCell("sVlanPri").element.style.display = "";       	
        }
        st.getHeadCell("srcVlan").element.innerHTML = RESOURCE["srcCVlan"];
        st.getHeadCell("snkVlan").element.innerHTML = RESOURCE["snkCVlan"];
    }
   
	  if(0 != st.getDataRowLength())
	  {
        st.getRow(0).element.style.backgroundColor = "#6f99a5";
        st.getRow(0).element.selectFlag = true;
        ports = [];
        ports[ports.length] = st.getCellStoreValue(0, "srcPort", "srcPort");
        ports[ports.length] = st.getCellStoreValue(0, "snkPort", "snkPort");
        refreshPorts(ports[0]);
    }
    else
    {
    	  $("querybtn").disabled = !btnRightArr.querybtn.right;	
        $("createbtn").disabled = !btnRightArr.createbtn.right;
        if (!$("querybtn").disabled && (ECOMBoard != boardtype))
        {
        	  $("showShared").disabled = false;
        }		
    }
	  refreshCountDiv(); 
	  if(!st.element.colsArray.selectedId)
	  {
	  	 st.element.colsArray.selectedId = "linkType";
	  	 st.element.colsArray.imgflag = 1;
	  }
	  var td=st.element.headRow.element.cols[st.element.colsArray.selectedId].element; 
	  st.sortRows(td,st.element.colsArray.imgflag);
}

/*
* Create sort table body
* st SortTable Object
* tc TableConf Object
* di DataInterface Object
* res RESOUCE object
*/
function createTableST(st, tc, di, res)
{
	  for(var i = 0; i < di.getDataRowLength(); i++)
    {
        var row = st.createRow();
        for(var j = 0; j < tc.getColsLength(); j++)
        {            
            var cell = st.createCell(tc.getColWidth(j));
            cell.colid=tc.getColId(j);
            st.setCellIsEdit(cell, tc.getIsEdit(j));
            var atom = st.createAtom(tc.getColShowType(j))
            var options = tc.getColShowOptions(j);
            if(null != options && "" != options)
            {
                for(var k = 0; k < options.length; k++)
                {
                    atom.addOption(options[k].getName(), options[k].getValue());
                }
                atom.element.disabled = true;
            } 
            var showvalue = "";
            if(tc.getColKeyArray(j).length > 0)
            {   
                for(var k = 0; k <tc.getColKeyArray(j).length; k++)
                {
                    if(di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()))
                    {
                        st.setCellValue(cell, tc.getColKeyArray(j)[k].getName(), di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()));
                        if(tc.getColKeyArray(j)[k].getConvert())
                        {
                            showvalue += convertMsg(res, eval(tc.getColKeyArray(j)[k].getConvert()), 
                                                        di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()))+"-";
                        }
                        else
                        {
                            showvalue += di.getDataRowParam(i, tc.getColKeyArray(j)[k].getName()) + "-";
                        }   
                    }
                }
            }
            
            if(showvalue && showvalue.length > 0)
            {
                atom.setValue(showvalue.substring(0, showvalue.length-1));
            }
            else
            {
                atom.setValue("-");
            }
            var cellID = tc.getColId(j);
            if(("oamEN" == cellID && "-" == atom.getValue())
            ||("cVlanPri" == cellID && "-" == atom.getValue())
            ||("sVlanPri" == cellID && "-" == atom.getValue()))
            {
                st.setCellIsEdit(cell, 0);    
            }
            st.addCellShow(cell, atom);
            
            if(tc.getIsEdit(j) == 1)
            {
                var ops = di.getDataRowOptions(i, tc.getColKeyArray(j)[0].getName());
                var atom = st.createAtom(tc.getColEditType(j));
                var options = tc.getColEditOptions(j)
                if(options.length > 0)
                {
                    for(var k = 0; k < options.length; k++)
                    {
                        atom.addOption(options[k].getName(), options[k].getValue());
                    }
                }  
                else if(ops)
                {
                    var convert = tc.getColKeyArray(j)[0].getConvert(); 
                    if(convert)
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            var conv = eval(convert);
                            atom.addOption(convertMsg(res, conv, ops[k]), ops[k]); 
                        }
                    }
                    else
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(ops[k], ops[k]); 
                        }
                    }   
                }
                st.addCellEdit(cell, atom);                    
            }
            else if(tc.hasEditElement(j))
            {
                var convert = tc.getColKeyArray(j)[0].getConvert();                 
                var atom = st.createAtom(tc.getColEditType(j));
                var ops = di.getDataRowOptions(i, tc.getColKeyArray(j)[0].getName()); 
                if(ops)
                {
                    if(convert)
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(convertMsg(res, eval(convert), ops[k]), ops[k]); 
                        }
                    }
                    else
                    {
                        for(var k = 0; k <ops.length; k++)
                        {
                            atom.addOption(ops[k], ops[k]); 
                        }
                    }   
                }
                st.addCellEdit(cell, atom);     
            }            
            st.addCell(row, tc.getColId(j), cell);
            var cellwidth = tc.getColWidth(j);
            if(cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%")
            {
                cell.element.style.display = "none";    
            }
        }
        st.addRow(row)
    }
}

/**
 * parse query XML response to linkList
 */
function toTableRow(rowData, st, tc)
{
    var row = st.createRow();

    var showValue = "";
    createCell(st, tc, row, "upLinkID", "", rowData.upLinkID.value, true);
    createCell(st, tc, row, "downLinkID", "", rowData.downLinkID.value, true);
    createCell(st, tc, row, "linkType", LinkType[rowData.linkType.value], rowData.linkType.value);
    createCell(st, tc, row, "direction", Direction[rowData.direction.value], rowData.direction.value);
    if (0 == rowData.linkType.value)
    {
        createCell(st, tc, row, "OAMEnable", PortEnable[rowData.oamEN.value], rowData.oamEN.value);
    }
    else
    {
    	  createCell(st, tc, row, "OAMEnable", "-", 0);
    }
    
    if (rowData.srcPort.value < 0x8000)
    {
        showValue = "PORT" + rowData.srcPort.value;
    }
    else
    {
        showValue = "VCTRUNK" + (rowData.srcPort.value - 0x8000);
    }
    createCell(st, tc, row, "srcPort", showValue, rowData.srcPort.value);
    if (rowData.srcVlan.value == 0xFFFF)
    {
        showValue = "-";
    }
    else
    {
        showValue = rowData.srcVlan.value;
    }
    createCell(st, tc, row, "srcVlan", showValue, rowData.srcVlan.value);
    if (rowData.srcSVlan.value == 0xFFFF)
    {
        showValue = "-";
    }
    else
    {
        showValue = rowData.srcSVlan.value;
    }
    createCell(st, tc, row, "srcSVlan", showValue, rowData.srcSVlan.value, !showShared());

    if (rowData.snkPort.value < 0x8000)
    {
        showValue = "PORT" + rowData.snkPort.value;
    }
    else
    {
        showValue = "VCTRUNK" + (rowData.snkPort.value - 0x8000);
    }
    createCell(st, tc, row, "snkPort", showValue, rowData.snkPort.value);
    if (rowData.snkVlan.value == 0xFFFF)
    {
        showValue = "-";
    }
    else
    {
        showValue = rowData.snkVlan.value;
    }
    createCell(st, tc, row, "snkVlan", showValue, rowData.snkVlan.value);
    if (rowData.snkSVlan.value == 0xFFFF)
    {
        showValue = "-";
    }
    else
    {
        showValue = rowData.snkSVlan.value;
    }
    createCell(st, tc, row, "snkSVlan", showValue, rowData.snkSVlan.value, !showShared());
    if (rowData.cVlanPri.value == 0xFF)
    {
        showValue = "-";
    }
    else
    {
        showValue = rowData.cVlanPri.value;
    }
    createCell(st, tc, row, "cVlanPri", showValue, rowData.cVlanPri.value, !showShared());
    if (rowData.sVlanPri.value == 0xFF)
    {
        showValue = "-";
    }
    else
    {
        showValue = rowData.sVlanPri.value;
    }
    createCell(st, tc, row, "sVlanPri", showValue, rowData.sVlanPri.value, !showShared());
    return row;
}

/**
 * remove all the table rows
 */
function clearTable()
{
    for(var i=0; i< st.getDataRowLength(); ++i)
    {
        st.deleteRow(i);
    }
    st.adjustDataRows();
    for(var i=0; i< st1.getDataRowLength(); ++i)
    {
        st1.deleteRow(i);
    }
    st1.adjustDataRows();
}

/**
 * do the query
 */
function doQuery(fromNE)
{
    var xml = createQueryRequest(showCouple, fromNE);
    document.getElementById("applybtn").disabled = true;
    document.getElementById("convertbtn").disabled = true;
    document.getElementById("querybtn").disabled = true;
    document.getElementById("createbtn").disabled = true;
    document.getElementById("deletebtn").disabled = true;
    document.getElementById("showShared").disabled = true;
    document.getElementById("couplebtn").disabled = true;
    var URL = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_EVPL_QUERY+"&flag=1&nmUser="+winobj["nmUser"];
    loadXMLdoc(URL,"POST", false, processQueryResponse, null, "inputdata="+xml);
}
/**
 * do OAM Enable or forbid
 */
function OAMEnable()
{
	  hideMenu();
	  document.getElementById("applybtn").disabled = true;
    var xml = createOAMEnable();  
    var URL = "../../../../../../neExlorerServlet?sfid="+TE_IP_VLAN_OAMENABLE+"&flag=1&nmUser="+winobj["nmUser"];
    loadXMLdoc(URL,"POST", true, processOAMEnable, null, "inputdata="+xml);
}

/**
 * callback function
 */
function processOAMEnable(doc)
{
    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    var size = dinterface.getBErrLength();
    for(var i = 0;i < size;i++)
    {
	      var tempObj = dinterface.getError().rowErrors[i].errorObj;
  	    tempObj["slotid"] = slotID;
		}
    openErrPage("../../../../../../page/", dinterface.getError(), errArr);

    if (0 == dinterface.getError().getGlobleECode())
    {
    	  doQuery(true);
    }    
}

function constructOamEnRow(rowindex, linkIdStr, direction)
{
		var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", neID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotID);
    row.appendChild(param);
		
    param = new tagElement("param");
    param.setAttribute("name", "linkID");
    param.setAttribute("value", st.getCellStoreValue(rowindex, linkIdStr, linkIdStr));//"upLinkID"
    row.appendChild(param);
	
    if ("0" == direction && (st.getCellModify(rowindex, "cVlanPri") || st.getCellModify(rowindex, "sVlanPri")))
    {
    	  param = new tagElement("param");    
  	    param.setAttribute("name","cVlanPri");
  	    param.setAttribute("value",st.getCellStoreValue(rowindex,"cVlanPri","cVlanPri"));
  	    row.appendChild(param);
  	    
    	  param = new tagElement("param");    
  	    param.setAttribute("name","sVlanPri");
  	    param.setAttribute("value",st.getCellStoreValue(rowindex,"sVlanPri","sVlanPri"));
  	    row.appendChild(param);
    }
	
    if (st.getCellModify(rowindex, "oamEN"))
    {
    	  param = new tagElement("param");    
  	    param.setAttribute("name","oamEN");
  	    param.setAttribute("value",st.getCellStoreValue(rowindex,"oamEN","oamEN"));
  	    row.appendChild(param);
    }
    
    return row;
}

/**
 * create OAMEnable XML request
 */
function createOAMEnable()
{
	  var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for(var rowindex = 0,rowlen = st.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	  if(!st.getModify(rowindex))
    	  {
    	  	  continue;
    	  }
    	  
    	  var row = constructOamEnRow(rowindex, "upLinkID", "0");
    	  bussiness.appendChild(row);
    	  
    	  if(ECOMBoard != boardtype)
    	  {
    	  	var direction = st.getCellStoreValue(rowindex, "direction", "direction");
    	  	if (direction == "1")
    	  	{
    	  		row = constructOamEnRow(rowindex, "downLinkID", "1");
    	  			bussiness.appendChild(row);
    	  	}
    	  }
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 * create table cell
 */
function createCell(st, tc, row, colName, showValue, storeValue, hide)
{
    if (!tc[colName])
    {
        return;
    }
    var cell = st.createCell(tc[colName].width);
    st.setCellIsEdit(cell, tc[colName].cell.isEdit);
    var atom = st.createAtom(tc[colName].cell.showElement.type);
    if (showValue)
    {
        atom.setValue(showValue);
    }
    else
    {
        atom.setValue("-");
    }
    if (storeValue)
    {
        st.setCellValue(cell, colName, storeValue);
    }
    else
    {
        st.setCellValue(cell, colName, atom.getValue());
    }
    if (hide)
    {
        cell.element.style.display = "none";
    }
    else
    {
        cell.element.style.display = "";
    }
    st.addCellShow(cell, atom);
    st.addCell(row, tc[colName].id, cell);
    return cell;
}

/**
 * refresh the count label
 */
function refreshCountDiv()
{
    document.getElementById("count").innerHTML = RESOURCE["total"] +  "  " +st.getDataRowLength()
             +  "  " +RESOURCE["row"] + "  " + RESOURCE["selected"] +  "  " +st.getSelectedRowCount() 
             +  "  " +RESOURCE["row"] + "</br>";
    if ("en" == language)
    {
    	   document.getElementById("count").innerHTML = RESOURCE["total"] +  ":" +st.getDataRowLength()
             +  "&nbsp;&nbsp;" + RESOURCE["selected"] +  ":" +st.getSelectedRowCount() + "</br>";
    }
}
var portFlag = true;
/**
 * table selection change
 */
function rowSelected(rows)
{
    if (deleteRight)
    {
        document.getElementById("deletebtn").disabled = false;
    }
    if (convertRight) 
    {
    	  document.getElementById("convertbtn").disabled = false;
    } 
    refreshCountDiv();
    if(ECOMBoard == boardtype)//ECOM                 
    {
    	return;
    }
    
    ports = [];
    if(null == rows || 0 >= rows.length)
    {
    	  document.getElementById("deletebtn").disabled = true;
    	  document.getElementById("convertbtn").disabled = true;
    	  document.getElementById("applybtn").disabled = true;
        for(var i=0; i< st1.getDataRowLength(); ++i)
        {
            st1.deleteRow(i);
        }
        st1.adjustDataRows();
    	  return;
    }
    ports[ports.length] = st.getCellStoreValue(st.getSelectedRows()[0], "srcPort", "srcPort");
    ports[ports.length] = st.getCellStoreValue(st.getSelectedRows()[0], "snkPort", "snkPort");
	  refreshPorts(ports[0]);
}

/**
 * do the delete
 */
function doDelete()
{
    if (st.getSelectedRowCount() <= 0)
    {
        alert(RESOURCE["noselect"]);
        return;
    }
    if (!confirm(RESOURCE["Delete_Hint"]))
    {
        return;
    }
    if (!confirm(RESOURCE["Delete_HintSecond"]))
    {
        return;
    }
    var xml = createDeleteRequest();
    document.getElementById("deletebtn").disabled = true;
    var URL = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_EVPL_DELETE+"&flag=1&nmUser="+winobj["nmUser"];
    loadXMLdoc(URL,"POST", true, processDeleteResponse, null, "inputdata="+xml);
}

/**
 * create delete XML request
 */
function createDeleteRequest()
{
    var links = [];
    var selRows = st.getSelectedRows();
    for (var i = 0; i < selRows.length; ++i)
    {
        links[links.length] = st.getCellStoreValue(selRows[i], "upLinkID", "upLinkID");
        if (1 == st.getCellStoreValue(selRows[i], "direction", "direction"))
        {
            links[links.length] = st.getCellStoreValue(selRows[i], "downLinkID", "downLinkID");
        }
    }

    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    for (var i = 0; i < links.length; ++i)
    {
        var row = new tagElement("row-params");

        var param = new tagElement("param");
        param.setAttribute("name", "neID");
        param.setAttribute("value", neID);
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "slotID");
        param.setAttribute("value", slotID);
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "linkID");
        param.setAttribute("value", links[i]);
        row.appendChild(param);

        business.appendChild(row);
    }
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processDeleteResponse(doc)
{
    if (deleteRight)
    {
        document.getElementById("deletebtn").disabled = false;
    }  
    if (convertRight)
    {
    	  document.getElementById("convertbtn").disabled = false;
    }

    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotID";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", dinterface.getError(), errArr);

    doQuery(true);
}

/**
 * create query XML request
 */
function createQueryPortRequest(portNO)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
        var row = new tagElement("row-params");

        var param = new tagElement("param");
        param.setAttribute("name", "neID");
        param.setAttribute("value", neID);
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", slotID);
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", portNO);
        row.appendChild(param);
        
        if (0x8000 > portNO)
        {
       	    param=new tagElement("param");
       	    param.setAttribute("name","attrid");
       	    param.setAttribute("value","ATTR_ETHOVERSDH_MAC_PE_TYPE");
       	    row.appendChild(param);    
   
       	    param=new tagElement("param");
            param.setAttribute("name","attrid");
            param.setAttribute("value","ATTR_ETHOVERSDH_MAC_ENABLE");
            row.appendChild(param);
        
            param=new tagElement("param");
            param.setAttribute("name","attrid");
            param.setAttribute("value","ATTR_ETHOVERSDH_MAC_TAG");
            row.appendChild(param);
        }
        else
        {
       		  param=new tagElement("param");
        		param.setAttribute("name","attrid");
       		  param.setAttribute("value","ATTR_ETHOVERSDH_VCG_PE_TYPE");
       		  row.appendChild(param);
        
        		param=new tagElement("param");
       		  param.setAttribute("name","attrid");
       	    param.setAttribute("value","ATTR_ETHOVERSDH_VCG_TAG");
       		  row.appendChild(param);
        }

        business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processQueryPortResponse(doc)
{
    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotID";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", dinterface.getError(), errArr);
    if (oprSucc != dinterface.getError().getGlobleECode()) 
    {
    	  $("querybtn").disabled = !btnRightArr.querybtn.right;	
        $("createbtn").disabled = !btnRightArr.createbtn.right; 
        $("couplebtn").disabled = false;
        if (!$("querybtn").disabled &&(boardtype != ECOMBoard))
        {
    	      $("showShared").disabled = false;
        }		
        if (deleteRight)
        {
        	  document.getElementById("deletebtn").disabled = false;
        } 
        if (convertRight)
        {
        	  document.getElementById("convertbtn").disabled = false;
        } 
    	  return;
    }
    queryPortAttr(ports[1],dinterface);
}

function addTableData(dinterface)
{
    var length = st1.getDataRowLength();
	  if (0 < length)
	  {
	      for(var i = length -1; i >= 0; i--)
        {
            st1.deleteRow(i);
        }
        st1.adjustDataRows();
    }
    
    for (var i = 0; i < dinterface.rows.length; ++i)
    {
        if (dinterface.rows[i].port.value < 0x8000)
        {
        	  var ptagName = new ParamTag();
        	  ptagName.value = "PORT" + (dinterface.rows[i].port.value);
            dinterface.rows[i]["port"] = ptagName;
            var ptagType = new ParamTag();
            ptagType.value = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_PE_TYPE")];
            dinterface.rows[i]["portType"] = ptagType;
            var ptagEnable = new ParamTag();
            if ("en" == language)
            {
    	          ptagEnable.value = PortEnableEN[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")];
            }
            else
            {
            	  ptagEnable.value = PortEnable[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")];
            }
            dinterface.rows[i]["portEnable"] = ptagEnable;
            var ptagTag = new ParamTag();
            ptagTag.value = PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_TAG")];
	    var portTypeAttr = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_PE_TYPE")];
            if(portTypeAttr != "UNI")
            {
		ptagTag.value="-";
            }
            dinterface.rows[i]["portTag"] = ptagTag;
        }
        else
        {
        	  var ptagName = new ParamTag();
        	  ptagName.value = "VCTRUNK" + (dinterface.rows[i].port.value - 0x8000);
            dinterface.rows[i]["port"] = ptagName;
            var ptagType = new ParamTag();
            ptagType.value = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_PE_TYPE")];
            dinterface.rows[i]["portType"] = ptagType;
            var ptagEnable = new ParamTag();
            ptagEnable.value = PortEnable["255"];
            dinterface.rows[i]["portEnable"] = ptagEnable;
            var ptagTag = new ParamTag();
            ptagTag.value = PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_TAG")];
	    var portTypeAttr = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_PE_TYPE")];
            if(portTypeAttr != "UNI")
            {
		ptagTag.value="-";
            }
            dinterface.rows[i]["portTag"] = ptagTag;
        }
        
    }
    createTableBody(st1, window.tableconf[1], dinterface, RESOURCE);
    if(!st1.element.colsArray.selectedId)
	  {
	  	 st1.element.colsArray.selectedId = "port";
	  	 st1.element.colsArray.imgflag = 1;
	  }
	  var td=st1.element.headRow.element.cols[st1.element.colsArray.selectedId].element; 
	  st1.sortRows(td,st1.element.colsArray.imgflag);
    
}

function processQueryPortAttrResponse(doc,dainterface)
{
	  $("querybtn").disabled = !btnRightArr.querybtn.right;	
    $("createbtn").disabled = !btnRightArr.createbtn.right; 
    $("couplebtn").disabled = false;
    if (!$("querybtn").disabled)
    {
    	  $("showShared").disabled = false;
    }		
    if (deleteRight)
    {
    	  document.getElementById("deletebtn").disabled = false;
    } 
    if (convertRight)
    {
    	  document.getElementById("convertbtn").disabled = false;
    } 
        
    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotID";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", dinterface.getError(), errArr);
    if (oprSucc != dinterface.getError().getGlobleECode()) 
    {
    	  return;
    }
    addTableData(dainterface);
    for (var i = 0; i < dinterface.rows.length; ++i)
    {
        if (dinterface.rows[i].port.value < 0x8000)
        {
        	  var ptagName = new ParamTag();
        	  ptagName.value = "PORT" + (dinterface.rows[i].port.value);
            dinterface.rows[i]["port"] = ptagName;
            var ptagType = new ParamTag();
            ptagType.value = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_PE_TYPE")];
            dinterface.rows[i]["portType"] = ptagType;
            var ptagEnable = new ParamTag();
            if ("en" == language)
            {
    	          ptagEnable.value = PortEnableEN[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")];
            }
            else
            {
            	  ptagEnable.value = PortEnable[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")];
            }
            dinterface.rows[i]["portEnable"] = ptagEnable;
            var ptagTag = new ParamTag();
            ptagTag.value = PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_TAG")];
 	    var portTypeAttr = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_PE_TYPE")];
            if(portTypeAttr !="UNI")
            {
		ptagTag.value="-";
            }
            dinterface.rows[i]["portTag"] = ptagTag;
        }
        else
        {
        	  var ptagName = new ParamTag();
        	  ptagName.value = "VCTRUNK" + (dinterface.rows[i].port.value - 0x8000);
            dinterface.rows[i]["port"] = ptagName;
            var ptagType = new ParamTag();
            ptagType.value = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_PE_TYPE")];
            dinterface.rows[i]["portType"] = ptagType;
            var ptagEnable = new ParamTag();
            ptagEnable.value = PortEnable["255"];
            dinterface.rows[i]["portEnable"] = ptagEnable;
            var ptagTag = new ParamTag();
            ptagTag.value = PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_TAG")];
            var portTypeAttr = PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_PE_TYPE")];
            if(portTypeAttr !="UNI")
            {
		ptagTag.value="-";
            }
            dinterface.rows[i]["portTag"] = ptagTag;
        }
        
    }
    createTableBody(st1, window.tableconf[1], dinterface, RESOURCE);
}

function processRefreshPort(doc)
{
    var dinterface = EncapsulateData(doc);

    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotID";
    errArr[2] = "boardname";
    openErrPage("../../../../../../page/", dinterface.getError(), errArr);

    for (var i = 0; i < dinterface.rows.length; ++i)
    {
        if (dinterface.rows[i].port.value < 0x8000)
        {            
            st1.getCellShow(rowIndex, "port").setValue("PORT" + (dinterface.rows[i].port.value));
            st1.getCellShow(rowIndex, "portType").setValue(PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_PE_TYPE")]);
            if ("en" == language)
            {
    	          st1.getCellShow(rowIndex, "portEnable").setValue(PortEnableEN[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")]);
            }
            else
            {
                st1.getCellShow(rowIndex, "portEnable").setValue(PortEnable[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_ENABLE")]);
            }
            st1.getCellShow(rowIndex, "portTag").setValue(PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_MAC_TAG")]);
        }
        else
        {
        	  st1.getCellShow(rowIndex, "port").setValue("VCTRUNK" + (dinterface.rows[i].port.value- 0x8000));
            st1.getCellShow(rowIndex, "portType").setValue(PortType[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_PE_TYPE")]);
            st1.getCellShow(rowIndex, "portEnable").setValue(PortEnable["255"]);
            st1.getCellShow(rowIndex, "portTag").setValue(PortTag[dinterface.getDataRowParam(i,"ATTR_ETHOVERSDH_VCG_TAG")]);            
        }       
    }
    if (0 == rowIndex)
    {
    	  rowIndex = 1;
    }
    else
    {
    	  rowIndex = 0;
    }
}

function refreshPorts(port)
{   
	if(ECOMBoard == boardtype)
	{
    	  $("querybtn").disabled = !btnRightArr.querybtn.right;	
        $("createbtn").disabled = !btnRightArr.createbtn.right; 
        $("couplebtn").disabled = false;
        if (deleteRight)
        {
        	  document.getElementById("deletebtn").disabled = false;
        } 
    	  return;
	}
    if (port)
    {
        if (-1 != port.indexOf("PORT"))
        {
        	  port = port.substring(4);
        }
        else
        {
        	  port = 0x8000 + parseInt(port.substring(7));
        }
        var xml = createQueryPortRequest(port);
        var URL = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&flag=1&nmUser="+winobj["nmUser"];
    	  loadXMLdoc(URL,"POST", false, processQueryPortResponse, null, "inputdata="+xml);                     
    }
    else
    {
        for(var i=0; i< st1.getDataRowLength(); ++i)
        {
            st1.deleteRow(i);
        }
        st1.adjustDataRows();
    }
}

function queryPortAttr(port,dinterface)
{
    if (port)
    {
        if (-1 != port.indexOf("PORT"))
        {
        	  port = port.substring(4);
        }
        else
        {
        	  port = 0x8000 + parseInt(port.substring(7));
        }
        var xml = createQueryPortRequest(port);
        var URL = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_PORTATTRI+"&flag=1&nmUser="+winobj["nmUser"];
    	  loadXMLdoc(URL,"POST", false, processQueryPortAttrResponse, dinterface, "inputdata="+xml);                     
    }
    else
    {
        for(var i=0; i< st1.getDataRowLength(); ++i)
        {
            st1.deleteRow(i);
        }
        st1.adjustDataRows();
    }
}
 
function init()
{    
    $("firstpage").innerHTML = RESOURCE["firstpage"];
    $("previouspage").innerHTML = RESOURCE["previouspage"];
    $("nextpage").innerHTML = RESOURCE["nextpage"];
    $("lastpage").innerHTML = RESOURCE["lastpage"];
    $("goto").innerHTML = RESOURCE["goto"];
    $("column").innerHTML = RESOURCE["everypage"];
    
    st.setOnRowSelectHandler(rowSelected);
    st.setImage("../../../../../../images/");
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
		if(ECOMBoard == boardtype)//ECOM       OAM   
		{
       st.getHeadCell("oamEN").element.style.display = "none";
    } 
    document.getElementById("tablecomponent").appendChild(st.getTable());
    if(ECOMBoard != boardtype)
    {
    	 st.setBodyHeight(getTableHeight($("tablecomponent"),st)*0.74+"px");    
    	 
    	 loadXMLdoc("../../../../conf/board_attribute/ip/ipservice/evplportattrtabletbe_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);
    	 st1.setBodyHeight(60);
    	 st1.setImage("../../../../../../images/");
    	 createTableHead(st1, window.tableconf[1]);
    	 document.body.insertBefore(st1.getTable(), document.getElementById("showSharedDiv"));
       $("showShared").disabled = true;
    }
    initButton();
    
    document.getElementById("tablecomponent").oncontextmenu=popupMenuHandler;
	     
	if(btnRightArr.querybtn.right)
	{
		doQuery(true);
	}  
	if(btnRightArr.convertbtn.right)
	{
    	document.getElementById("tablecomponent").firstChild.childNodes[1].oncontextmenu = rightClickEvent; 
	}
}

/**
 * ??????????????????????????????????????????
 * @param ???
 * @return ???
 */
function cellEditHandler()
{
	if(applyRight)
	{
		$("applybtn").disabled = false; 
	}
}

function showShareChanged()
{
	  sharedFlag = false;
    doQuery(false);
}

function queryLink(fromNE)
{
    doQuery(fromNE);
}

function coupleBtnClicked()
{
    showCouple = !showCouple;
    resetCoupleBtnText();
    queryLink(false);
}

function resetCoupleBtnText()
{
    if (!showCouple)
    {
        document.getElementById("couplebtn").value=RESOURCE["showCouple"];
    }
    else
    {
        document.getElementById("couplebtn").value=RESOURCE["showUni"];
    }
}

function delLink()
{
	  hideMenu();
    doDelete();
}

/*
 * ??????EPL???????????????SNCP?????? 
 */
function convertSNCP()
{	
	hideMenu();
	var count = 0;
	
	var row;
	
	for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		if(st.getRowSelFlag(i))
		{
			count++;
			row = i;
		}
	}
	
	if(1 == count)
	{
		var linkType = st.getCellStoreValue(row, "linkType", "linkType");
		var srcVlan = st.getCellStoreValue(row, "srcVlan", "srcVlan");
		var sinkVlan = st.getCellStoreValue(row, "snkVlan", "snkVlan");
		var direction = st.getCellStoreValue(row, "direction", "direction");

		if(-1 == linkType || EPL_SERVICE == linkType)
		{
			if((srcVlan != "-") && (srcVlan == sinkVlan))
			{
		      xshowModalDialog("../sncp_tbe/vlansncpconvert.html", RESOURCE["converttosncptitle"], 600, 440, "../../../../../../images/");
		  }
		  else
		  {
		      alert(RESOURCE["novlansncp"]);
		  }
		}
		else
		{			
			  if (ADD_SERVICE == linkType && ("-" == srcVlan || BIDIRECTION == direction))
			  {
			  	  alert(RESOURCE["novlansncp"]);
			  	  return;
			  }
			  if (STRIP_SERVICE == linkType &&  BIDIRECTION == direction)
			  {
			  	  alert(RESOURCE["novlansncp"]);
			  	  return;
			  }
				xshowModalDialog("../sncp_tbe/vlansncpconvert.html", RESOURCE["converttosncptitle"], 600, 440, "../../../../../../images/");		
		}
	}
	else
	{
	    alert(RESOURCE["onlyselectone"]);
	}
}
/*
 * ??????????????? 
 */
function initButton()
{
	if(boardtype == ECOMBoard)
	{
		document.getElementById("convertbtn").style.display = "none";
	}
	  document.getElementById("applybtn").value=RESOURCE["applybtn"];
  	document.getElementById("convertbtn").value=RESOURCE["cnvtsncpbutton"];
    document.getElementById("querybtn").value=RESOURCE["querybtn"];
    document.getElementById("createbtn").value=RESOURCE["createbtn"];
    document.getElementById("deletebtn").value=RESOURCE["deletebtn"];
    resetCoupleBtnText();
	  
	  btnRightArr.applybtn = new BtnRightObj("applybtn",TE_IP_VLAN_OAMENABLE);
    btnRightArr.convertbtn = new BtnRightObj("convertbtn",TE_IP_NORMALSNCP_CONVERT);    
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_IP_EVPL_QUERY);    
    btnRightArr.createbtn = new BtnRightObj("createbtn",TECMDCODE_IP_EVPL_CREATE);    
    btnRightArr.deletebtn = new BtnRightObj("deletebtn",TECMDCODE_IP_EVPL_DELETE); 
    sendRightInfo(btnRightArr);  
    initBtnStatue();      
}

/**
 * ?????????????????????
 * @param btnId?????????????????????ID??? sfid???????????????????????????????????????ID
 * @return ???
 */ 
function BtnRightObj(btnId,sfid)
{
	  if(null != btnId)
	  {
	    	this.btnId = btnId;
	  }
	  else
	  {
	    	this.btnId = "";
  	}
	
  	if(isNaN(parseInt(sfid)))
	  {
	    	this.sfid = -1;
	  }
	  else
	  {
		    this.sfid = sfid;
	  }
	  this.right = true;
}
/**
 * ??????????????????????????????XML
 * @param ???
 * @return ???
 */ 
function createRightXML()
{
	  var root = new inputxml("datainterface");//Create the root of a xml file
	  var firstlevel = new tagElement("bussiness-params");
	
	  var secondlevel=null;;
	  var thirdlevel=null;
	
    for(var btnrightobj in btnRightArr)
	  {
		    secondlevel = new tagElement("row-params"); //bean???????????????????????????	
		
		    thirdlevel = new tagElement("param");
		    thirdlevel.setAttribute("name","btnID");
		    thirdlevel.setAttribute("value",btnRightArr[btnrightobj].btnId);
		    secondlevel.appendChild(thirdlevel);
		
		    thirdlevel = new tagElement("param");	
		    thirdlevel.setAttribute("name","sfid");
		    thirdlevel.setAttribute("value",btnRightArr[btnrightobj].sfid);
		    secondlevel.appendChild(thirdlevel);
		
		    firstlevel.appendChild(secondlevel);
	  }
	  root.getRoot().appendChild(firstlevel);
	  return root.toString();
}
/**
 * ??????????????????
 * @param ???
 * @return ???
 */ 
function sendRightInfo()
{
	  var url = "../../../../../../securityServlet?neID="+winobj["neid"]+"&nmUser="+winobj["nmUser"];
	  loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}
/**
 * ??????????????????????????????
 * @param ???
 * @return ???
 */ 
function rightHandleBack(doc)
{
	  var data = EncapsulateData(doc);
    
	  for(var i = 0; i < data.getDataRowLength(); i++)  //?????????????????????
    {
      	var right = data.getDataRowParam(i,"right");
    	
      	if(0 == right)
    	  {
    	    	btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
    	  } 
      	else
    	  {
    	    	btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
    	  }        
    }   
}
/**
 * ????????????????????????
 * @param ???
 * @return ???
 */
function initBtnStatue()
{	
	  $("convertbtn").disabled = !btnRightArr.convertbtn.right;	
    $("querybtn").disabled = !btnRightArr.querybtn.right;	
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;	
    deleteRight = btnRightArr.deletebtn.right;
    convertRight = btnRightArr.convertbtn.right;
    applyRight = btnRightArr.applybtn.right;
    if ($("querybtn").disabled)
    {
    	  $("showShared").disabled = true;
    	  $("couplebtn").disabled = true;
    }		
}
window.onresize=function()
{
	  st.setBodyHeight(getTableHeight($("tablecomponent"),st)*1.05+"px");
}

/***********                                              
 *                
************/
function firstpage()
{
    $("pagenum").value = 1;
    doQuery(true);
}

/*************                                             
 *                 
**************/
function pagedown()
{
    $("pagenum").value = parseInt($("pagenum").value) + 1;
    doQuery(true);
}

/*************                                             
 *                 
**************/
function pageup()
{
    $("pagenum").value = parseInt($("pagenum").value) - 1;
    doQuery(true);
}

/*************                                             
 *                  
**************/
function lastpage()
{
    var str = $("pagestatus").innerHTML;
    $("pagenum").value = str.split("/")[1];
    doQuery(true);
}

function createAction()
{
	if(boardtype == TBEBoard)
	{
		xshowModalDialog("createethernetoperationtbe.html", RESOURCE["servCrea"], 460, 400, "../../../../../../images/");
	}
	else if(boardtype == ECOMBoard)
	{
		xshowModalDialog("createecomevpl.html", RESOURCE["servCrea"], 460, 400, "../../../../../../images/")
	}
}
