 /************
 *     
*************/
var BOARD_TYPE_TBE = TN11TBE;
var PORT_3 = 3;
var VBNAME_LEN = 16;//vb         16  
var VCTRUNC_FLG = 32768;//>0x8000  VCTrunk 
var VBPORT_FLG = 28672;//>0x7000 <0x8000 VB    
var MAXVLANID = 4094;//vlanid   
var MAXVLANIDLEM24 = 4095;//vlanid   
var NA_VALUE = 65535;
var CAWARE = "CAWARE";
var SAWARE = "SAWARE";

var PARAM_VALUE_ALL = "ALL";

var PORTTYPE_UNI = "UNI";
var PORT_ENABLED_Y = "Y";

var vbTypeConvert = new Object();
vbTypeConvert[0] = "802.1q";//0
vbTypeConvert[1] = "802.1d";//1
vbTypeConvert[2] = "802.1ad";//2

var VBTYPE_VALUE = [];
VBTYPE_VALUE["8021q"] = 0;
VBTYPE_VALUE["8021d"] = 1;
VBTYPE_VALUE["8021ad"] = 2;

var vbModeConvert = new Object();
vbModeConvert[1] = "vbmode1";//IVL/ENABLE
vbModeConvert[2] = "vbmode2";//IVL/DISABLE
vbModeConvert[3] = "vbmode3";//SVL/ENABLE
vbModeConvert[4] = "vbmode4";//SVL/DISABLE

var VBMODE_VALUE = [];
VBMODE_VALUE["IVL"] = "IVL";
VBMODE_VALUE["SVL"] = "SVL";

var FLTREN_VALUE = [];
FLTREN_VALUE["Y"] = "Y";
FLTREN_VALUE["N"] = "N";

var vbLearnModeConvert = new Object();
vbLearnModeConvert["SVL"] = "SVL";
vbLearnModeConvert["IVL"] = "IVL";

var portTypeArr = new Object();
portTypeArr["UNI"] = "UNI";
portTypeArr["CAWARE"] = "C-Aware";
portTypeArr["SAWARE"] = "S-Aware";
portTypeArr["-"] = "-";

var PORT_TYPE_ARR_VALUE = [];
PORT_TYPE_ARR_VALUE["UNI"] = "UNI";//2
PORT_TYPE_ARR_VALUE["CAWARE"] = "CAWARE";//5
PORT_TYPE_ARR_VALUE["SAWARE"] = "SAWARE";//6
PORT_TYPE_ARR_VALUE["-"] = "-";//

var tagFlag = new Object();
tagFlag["ACCESS"] = "Access";//  acess  
tagFlag["TAGAWARE"] = "Tag Aware";//  tag-aware  
tagFlag["HYBRID"] = "Hybrid";//      HYBRID
tagFlag["-"] = "-";

var TAGTYPE_VALUE = [];
TAGTYPE_VALUE["ACCESS"] = "ACCESS";//0
TAGTYPE_VALUE["TAGAWARE"] = "TAGAWARE";//1
TAGTYPE_VALUE["HYBRID"] = "HYBRID";//2
TAGTYPE_VALUE["-"] = "-";//

var Direction = new Object();
Direction["2WAY"] = "bidirectional";

var DIRECTION_BIDIRECTION = "bidirectional";
var DIRECTION_UNILATERALISM = "Unilateralism";

var DIRECTION_BIDIRECTION_VALUE = "2WAY";
var DIRECTION_UNILATERALISM_VALUE = "1WAY";

var PORTENABLE = [];
PORTENABLE["N"] = RESOURCE["forbid"];//0
PORTENABLE["Y"] = RESOURCE["enable"];//1

var PORTENABLE_VALUE = [];
PORTENABLE_VALUE["N"] = "N";//0
PORTENABLE_VALUE["Y"] = "Y";//1


var hubAttrConvert = new Object();
hubAttrConvert["HUB"] = "Hub";//0
hubAttrConvert["SPOKEN"] = "Spoken";//1

var portEnabled = new Object();
portEnabled["N"] = "ID_DISABLE2";//0
portEnabled["Y"] = "ID_ENABLE";//1

var oldStatus = new Object();
oldStatus["STATIC"] = "staticStatus";
oldStatus["DYNAMIC"] = "dynamic";
oldStatus["STATIC-END"] = "STATIC-END";
oldStatus["DYNAMIC-END"] = "DYNAMIC-END";

var boundPothLevel = new Object();
boundPothLevel[1] = "VC4-xv";
boundPothLevel[2] = "VC3-xv";
boundPothLevel[3] = "VC12-xv";
boundPothLevel[33] = "VC4-xc";
boundPothLevel[34] = "VC3-xc";
boundPothLevel[129] = "GE";//ODUG    

var boundPathDirection = new Object();
boundPathDirection[0] = "bidirectional";

var operTypeConvert = new Object();
operTypeConvert[0] = RESOURCE["opertype0"];
operTypeConvert[1] = RESOURCE["opertype1"];
operTypeConvert[2] = RESOURCE["opertype2"];
operTypeConvert[3] = RESOURCE["opertype3"];

/*
          
     :      AUTO
         AUTO
         HALF10M
         FULL10M
         HALF100M
         FULL100M
         HALF1000M
         FULL1000M
         7   10G   LAN
         8   10G   WAN
  Ge    
            AUTO
            FULL1000M
    10Ge    
            7   10G   LAN
            8   10G   WAN
    FE     
            AUTO
            HALF10M
            FULL10M
            HALF100M
            FULL100M
    FE    :
            FULL1000M
*/
var workMode = new Object();
workMode["AUTO"] = RESOURCE["MAC_WORKMODE_auto"];//0
workMode["HALF10M"] = RESOURCE["MAC_WORKMODE_10mhalf"];//1
workMode["FULL10M"] = RESOURCE["MAC_WORKMODE_10mfull"];//2
workMode["HALF100M"] = RESOURCE["MAC_WORKMODE_100mhalf"];//3
workMode["FULL100M"] = RESOURCE["MAC_WORKMODE_100mfull"];//4
workMode["HALF1000M"] = RESOURCE["MAC_WORKMODE_1000mhalf"];//5
workMode["FULL1000M"] = RESOURCE["MAC_WORKMODE_1000mfull"];//6
workMode["10GFULLLAN"] = RESOURCE["MAC_WORKMODE_10GLAN"];//7
workMode["10GFULLWAN"] = RESOURCE["MAC_WORKMODE_10GWAN"];//8
workMode[255] = RESOURCE["negotiating"];
workMode["-"] = "-";

var WORKMODE_VALUE = [];
WORKMODE_VALUE["AUTO"] = "AUTO";
WORKMODE_VALUE["HALF10M"] = "HALF10M";
WORKMODE_VALUE["FULL10M"] = "FULL10M";
WORKMODE_VALUE["HALF100M"] = "HALF100M";
WORKMODE_VALUE["FULL100M"] = "FULL100M";
WORKMODE_VALUE["HALF1000M"] = "HALF1000M";
WORKMODE_VALUE["FULL1000M"] = "FULL1000M";
WORKMODE_VALUE["10GFULLLAN"] = "10GFULLLAN";
WORKMODE_VALUE["10GFULLWAN"] = "10GFULLWAN";
WORKMODE_VALUE[255] = "255";

/**********************
 * portArr      
***********************/
function comparison_portNo(portObj1, portObj2)
{
    var value1 = parseInt(portObj1.portNo);
    var value2 = parseInt(portObj2.portNo);
    if(value1 < value2)
    {
        return -1;
    }
    else if(value1 > value2)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

/*********************************************
 *   VLAN id
 *     1 3-6       1 3 4 5 6
**********************************************/
function getVlanIdArr(vlanStr)
{
    var vlanArr = vlanStr.split(",");
    var tempArr = new Array();
    var resultVlanArr = new Array();
    var len = 0;
    for(var i = 0, arrlen = vlanArr.length; i < arrlen; i++)
    {
        if(-1 == vlanArr[i].indexOf("-"))
        {
            resultVlanArr[resultVlanArr.length] = vlanArr[i];
            continue;
        }
        tempArr = vlanArr[i].split("-");
        resultVlanArr[resultVlanArr.length] = tempArr[0];
        len = parseInt(tempArr[1]) - parseInt(tempArr[0]);
        for(var j = 0; j < len; j++)
        {
            resultVlanArr[resultVlanArr.length] = parseInt(resultVlanArr[resultVlanArr.length - 1]) + 1;
        }
    }
    return resultVlanArr;
}

/*****************************************
 *       vb         
 *        
 *      1,3,4,5       1 3-6                 
******************************************/
function getVlanIdStr(cvtvalue)
{
    var vlanidArr = cvtvalue.split(",");
    var vlanidStr = vlanidArr[0];
    var tempvlanid = vlanidStr;
    for(var i = 1, len = vlanidArr.length; i < len; i++)
    {
        if(parseInt(vlanidArr[i]) - parseInt(tempvlanid) > 1)
        {
            
            if(vlanidStr.substring(vlanidStr.length - 1) == "-")
            {
                vlanidStr += tempvlanid;
            }
            tempvlanid = vlanidArr[i];
            vlanidStr += "," + tempvlanid;
        }
        else if(parseInt(vlanidArr[i]) - parseInt(tempvlanid) == 1)
        {
            tempvlanid = vlanidArr[i];
            if(vlanidStr.substring(vlanidStr.length - 1) != "-")
            {
                vlanidStr += "-";
            }
        }
    }
    if(vlanidStr.substring(vlanidStr.length - 1) == "-")
    {
        vlanidStr += tempvlanid;
    }
    return vlanidStr;
}

/**********************************
 *       convertMsg   
 *                                
***********************************/
function convertMsg(resobj,	cvtobj,	cvtvalue)
{
		if("function" == typeof cvtobj)
		{
		    return cvtobj(cvtvalue);
		}
		if(cvtvalue == "-")
		{
	      return cvtvalue;
		}
		return resobj[cvtobj[cvtvalue]];
}

/*
               
 */
function isValidateSrcCVlan()
{
    var text = $("vlanid");
    if(!text)
    {
        return;
    }    
    if(!isValidateVlan("srcCVlan"))
    {
        return;
    }
}

/*
               
 */
function isValidateVlan(Vlan)
{         
    var text = $("vlanid").value;
    if(!text)
    {
        alert(RESOURCE["vlanidempty"]);
        return false;
    }
    if("-" == text)
    {
        alert(RESOURCE["vlanFormat"]);
        return false;
    }
    var str=text.split(",");
    var pattern1=new RegExp("^\\d+$","i");
    var pattern2=new RegExp("^\\d+-\\d+$","i");

    for(var i=0; i<str.length; i++)
    {        
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            if( !pattern2.test(str[i]))
            {    
            	  alert(RESOURCE["vlanFormat"]);
                return false;
            }
        }
        else
        {
            if(!pattern1.test(str[i]))
            {
            	  alert(RESOURCE["vlanFormat"]);
                return false;
            }
         }
    }
    var limitHigh = 4095;
    var limitLow = 1;
    for(var i=0; i<str.length; i++)
    {
        var b=str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);
    
            if((rangeStart>limitHigh) || (rangeEnd>limitHigh)
                ||(rangeStart<limitLow) ||(rangeEnd<limitLow))
            {
       	        alert(RESOURCE["numberLimit"]);
                return false;
            }
            if (rangeEnd <rangeStart)
            {
            	  alert(RESOURCE["startEnd"]);
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>limitHigh || parseInt(str[i])<limitLow)
           {
           	    alert(RESOURCE["numberLimit"]);
                return false;
           }
        }
    }
    return true;
}

function chkCVlan(obj,event,Vlan)
{
	  var code = (event.keyCode!=0?event.keyCode:event.charCode);
	  var ch = String.fromCharCode(code);
	  if(code == 8 || code == 46 || code == 37 || code == 39)
    {
    	  return true;   //DEL   
    }

	  if ($("applybtn") && $("applybtn").disabled)
	  {
	  	  $("applybtn").disabled = false;
	  }
    if(!restrict(obj, event, "0123456789,-"))
    {
        return false;
    }
    if(!isCVlan(Vlan))
    {
        return false;
    }
    return true;
}

/*
               
 */
function isCVlan(Vlan)
{
	  var key,keychar;   
    if(window.event)
    {
       key = window.event.keyCode;
    }  
    keychar = String.fromCharCode(key);  
    var code = (event.keyCode!=0?event.keyCode:event.charCode);
	  keychar = String.fromCharCode(code); 
    var text = $("vlanid").value + keychar;
    if(!text || "-" == text)
    {
        return true;
    }
    var str=text.split(",");
    
    var limitHigh = 4095;
    var limitLow = 1;
    for(var i=0; i<str.length; i++)
    {
        var b=str[i].indexOf("-") != -1;
        if(b)
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);

            if((rangeStart>limitHigh) || (rangeEnd>limitHigh)
                ||(rangeStart<limitLow) ||(rangeEnd<limitLow))
            {
       	        alert(RESOURCE["numberLimit"]);
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>limitHigh || parseInt(str[i])<limitLow)
           {
           	    alert(RESOURCE["numberLimit"]);
                return false;
           }
        }
    }
    return true;
}

/****************************
 * MAC                           
*****************************/
function checkMACFormat(obj)
{
	  obj.style.imeMode = "disabled";
	  obj.maxLength = "17";
	  
	  obj.onpaste = returnFalse;
    
    obj.onkeypress = function()
    {
        return validateMACAddr(obj);    	
    }
}

/**********************
 * MAC                        
***********************/
function validateMACAddr(obj)
{
	  var code=(event.keyCode!=0?event.keyCode:event.charCode);

    var ch = String.fromCharCode(code);
	
	  if(code == 13)
	  {
	  	  return false;
    }
    
    if (code == 8 || code == 127)
    {
    	  return false;
    }
    
    if(event.ctrlKey)
    {
        if(ch == 'X' || ch == 'C' || ch == 'A')
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    	
	  if (code == 45)
	  {
	  	  return true;
	  }
	
	  if(code < 48 || (code > 57 && code < 65) || (code > 70 && code < 97) || code > 102)
	  {
	  	  return false;
	  }    
	
    var value = obj.value;					
    pos = digitalTag_getPos(obj);
	  if(pos <= 16)
	  {
	  	  var ach = value.substring(pos, pos + 1);
	  	  if(ach == "-")
	  	  {
	  	  	  if(isIE)
	  	  	  {
	  	  	  	  var rng = document.selection.createRange();					
	  	  	  	  if(selectionLen(obj) > 0)
	  	  	  	  {
	  	  	  	  	rng.moveEnd('character', -(selectionLen(obj) - 2));
	  	  	  	  	rng.text = "-" + ch;
	  	  	  	  	rng.select();						
	  	  	  	  }
	  	  	  	  else
	  	  	  	  {
	      	  	  		rng.moveEnd('character', 1);
	      	  	  		rng.text = "-";
	      	  	  }
	  	  	  }
	  	  	  else
	  	  	  {
	  	  	  	  obj.selectionStart = pos + 1;
	  	  	  }
	  	  }
	  	  else
	  	  {
	  	  	  var newVal = "";
	  	  	  newVal = value.substring(0, pos) + ch + value.substring(pos + 1);
	  	  	  if (isIE)
	  	  	  {
	  	  	  	  var rng = document.selection.createRange();					
	  	  	  	  if (selectionLen(obj) > 0)
	  	  	  	  {
	  	  	  	  	  rng.moveEnd('character', -(selectionLen(obj) - 1));
	  	  	  	  	  rng.text = "";
	  	  	  	  	  rng.select();						
	  	  	  	  }
	  	  	  	  else
	  	  	  	  {
	      	  	  		rng.moveEnd('character',1);
	      	  	  		rng.text = "";
	      	  	  }		
	  	  	  }
	  	  	  else
	  	  	  {
	  	  	  	  var newVal = value.substring(0,pos) + ch + value.substring(pos + 1);
	  	  	  	  obj.value = newVal;
	  	  	  	  obj.selectionEnd = pos + 1;
	  	  	  }
	  	  }
	  }
}

function blurFormat(obj)
{
	var pattern = /^[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]-[a-f,A-Z,0-9][a-f,A-Z,0-9]$/;
   	var checker = pattern.test(obj.value);
   	if(!checker)
   	{
       	alert(RESOURCE["format"]);
       	obj.value = "00-00-00-00-00-01";
       	obj.focus();
       	return false;
   	}
   	else
   	{
       	if(obj.value == "00-00-00-00-00-00")
       	{
       	    alert(RESOURCE["macaddrerror0"]);
       	    return false;
       	}
       	var val = obj.value.substring(1, 2);
       	var pattern0 = /^[a-f,A-Z]$/;
       	if(pattern0.test(val))
       	{
       	    switch(val.toLowerCase())
       	    {
       	        case "a": val = 10;
       	                  break;
       	        case "b": val = 11;
       	                  break;
       	        case "c": val = 12;
       	                  break;
       	        case "d": val = 13;
       	                  break;
       	        case "e": val = 14;
       	                  break;
       	        case "f": val = 15;
       	                  break;
       	        default:;
       	    }
       	}

       	if(parseInt(val) % 2 != 0)
       	{
       	    alert(RESOURCE["macaddrerror1"]);
       	    return false;   
       	}
       	return true;
   	}
}

function convertVlanID(vlanid)
{
    if(vlanid == 65534)
    {
        return "-";
    }
    return vlanid;
}

function convertMacAddr(macAddrStr)
{
	  var showMACStr = "";
    for(var i = 0, len = 12; i < len;)
    {
        if(showMACStr != "")
        {
            showMACStr += "-";
        }
        showMACStr += macAddrStr.substring(i, i+2);
        i += 2; 
    }
    return showMACStr;
}

/****************************
 *   VCTrunk                        
*****************************/
function convertVCtrunk(cvtvalue)
{
    return "VCTRUNK" + (parseInt(cvtvalue) - VCTRUNC_FLG);
}

/**************************
 *                             
***************************/
function convertLevel(cvtvalue)
{
    return boundPothLevel[cvtvalue];
}

/*********************************************
 *   VB               VB                   
**********************************************/
function convertVBPort(cvtvalue)
{
    return cvtvalue - VBPORT_FLG;
}

/*********************************************
 *                                       
**********************************************/
function convertPortType(cvtvalue)
{
      return portTypeArr[cvtvalue];
}

/**************************************
 *                                   
****************************************/
function portidToName(portid)
{
    if(Number(portid) > VCTRUNC_FLG)
    {
        return "VCTRUNK" + (Number(portid) - VCTRUNC_FLG);
    }
    
    if(Number(portid) < VBPORT_FLG)
    {
        return "PORT" + portid;
    }
    
    return Number(portid) - VBPORT_FLG;
}

/**************************************
 *   TAG           TAG                     
****************************************/
function convertTagFlag(tag)
{
	return tagFlag[tag];
}

/**************************************
 *                                       
****************************************/
function convertWorkMode(mode)
{
	return workMode[mode];
}

/**************************
 *   cvlan svlan                    
***************************/
function convertCSvlanID(cvtvalue)
{
    if(Number(cvtvalue) == NA_VALUE || cvtvalue == "-" || cvtvalue == "")
    {
        return "-";
    }
    return cvtvalue;
}
