var tagFlag = [];
tagFlag["ACCESS"] = "Access";
tagFlag["TAGAWARE"] = "Tag Aware";
tagFlag["HYBRID"] = "Hybrid";

/*
          
     :      AUTO
         AUTO
         HALF10M
         FULL10M
         HALF100M
         FULL100M
         HALF1000M
         FULL1000M
         7   10G   LAN
         8   10G   WAN
  Ge    
            AUTO
            FULL1000M
    10Ge    
            7   10G   LAN
            8   10G   WAN
    FE     
            AUTO
            HALF10M
            FULL10M
            HALF100M
            FULL100M
    FE    :
            FULL1000M
*/
var workMode = [];
workMode["AUTO"] = RESOURCE["MAC_WORKMODE_auto"];//0
workMode["HALF10M"] = RESOURCE["MAC_WORKMODE_10mhalf"];//1
workMode["FULL10M"] = RESOURCE["MAC_WORKMODE_10mfull"];//2
workMode["HALF100M"] = RESOURCE["MAC_WORKMODE_100mhalf"];//3
workMode["FULL100M"] = RESOURCE["MAC_WORKMODE_100mfull"];//4
workMode["HALF1000M"] = RESOURCE["MAC_WORKMODE_1000mhalf"];//5
workMode["FULL1000M"] = RESOURCE["MAC_WORKMODE_1000mfull"];//6
workMode["10GFULLLAN"] = RESOURCE["MAC_WORKMODE_10GLAN"];//7
workMode["10GFULLWAN"] = RESOURCE["MAC_WORKMODE_10GWAN"];//8
workMode[255] = RESOURCE["negotiating"];
workMode["-"] = "-";

var WORKMODE_VALUE = [];
WORKMODE_VALUE["AUTO"] = "AUTO";
WORKMODE_VALUE["HALF10M"] = "HALF10M";
WORKMODE_VALUE["FULL10M"] = "FULL10M";
WORKMODE_VALUE["HALF100M"] = "HALF100M";
WORKMODE_VALUE["FULL100M"] = "FULL100M";
WORKMODE_VALUE["HALF1000M"] = "HALF1000M";
WORKMODE_VALUE["FULL1000M"] = "FULL1000M";
WORKMODE_VALUE["10GFULLLAN"] = "10GFULLLAN";
WORKMODE_VALUE["10GFULLWAN"] = "10GFULLWAN";
WORKMODE_VALUE[255] = "255";

var unAutoSensingFlowControlMode = [];
unAutoSensingFlowControlMode["DISABLE"] = RESOURCE["Disable_Flow_Control"];
unAutoSensingFlowControlMode["ENABLE"] = RESOURCE["Enable_Symmetric_Flow_Control"];
unAutoSensingFlowControlMode["SEND"] = RESOURCE["Send_Only"];
unAutoSensingFlowControlMode["RECV"] = RESOURCE["Receive_Only"];

var autoSensingFlowControlMode = [];
autoSensingFlowControlMode["DISABLE"] = RESOURCE["Disable_Flow_Control"];
autoSensingFlowControlMode["ASYM"] = RESOURCE["Enable_Dissymmetric_Flow_Control"];
autoSensingFlowControlMode["SYM"] = RESOURCE["Enable_Symmetric_Flow_Control"];
autoSensingFlowControlMode["BOTH"] = RESOURCE["Enable_Symmetric_Dissymmetric_Flow_Control"];

var actualFlowControlMode = [];
actualFlowControlMode["DISABLE"] = RESOURCE["Disable_PORT_Flow_Control"];
actualFlowControlMode["ENABLE"] = RESOURCE["Enable_Symmetric_Flow_Control"];
actualFlowControlMode["SEND"] = RESOURCE["Send_Only"];
actualFlowControlMode["RECV"] = RESOURCE["Receive_Only"];

var enableFlag = [];
enableFlag["DISABLE"] = RESOURCE["disabled"];
enableFlag["ENABLE"] = RESOURCE["enable"];

var yFlag = [];
yFlag["N"] = RESOURCE["disabled"];
yFlag["Y"] = RESOURCE["enable"];

var portAttribute = [];
portAttribute[0] = "PE";
portAttribute[1] = "P";
portAttribute[2] = "UNI";
portAttribute[3] = "N-UNI";
portAttribute["UNI"] = "UNI";
portAttribute["NNI"] = "NNI";
portAttribute["CAWARE"] = "C-Aware";
portAttribute["SAWARE"] = "S-Aware";
var pPortEncType = [];
pPortEncType[0] = "MartinioE";
pPortEncType[1] = "CCCoE";
pPortEncType[2] = "VMANoE";
pPortEncType[3] = "MartinioP";

var macLoopMode = [];
var curBoardType = getNeProperty(self).boardType;
macLoopMode["NOLB"] = RESOURCE["MAC_LAYER_NOLOOPBACK"];//0
macLoopMode["NOLOOP"] = RESOURCE["MAC_LAYER_NOLOOPBACK"];//0
macLoopMode["FACILITY"] = RESOURCE["MAC_LAYER_INLOOPBACK"];//1
macLoopMode["TERMINAL"] = RESOURCE["MAC_LAYER_OUTLOOPBACK"];	//2	

var phyLoopMode = [];
phyLoopMode["NOLB"] = RESOURCE["PHY_LAYER_NOLOOPBACK"];//0
phyLoopMode["NOLOOP"] = RESOURCE["PHY_LAYER_NOLOOPBACK"];//0
phyLoopMode["FACILITY"] = RESOURCE["PHY_LAYER_INLOOPBACK"];//1
phyLoopMode["TERMINAL"] = RESOURCE["PHY_LAYER_OUTLOOPBACK"];//2

var loopBackMode = [];
loopBackMode["NOLB"] = RESOURCE["NOLOOPBACK"];//0
loopBackMode["NOLOOP"] = RESOURCE["NOLOOPBACK"];//0;0
loopBackMode["FACILITY"] = RESOURCE["INLOOPBACK"];//1
loopBackMode["TERMINAL"] = RESOURCE["OUTLOOPBACK"];//2

var LOOP_BACK_MODE_VALUE = [];
if (curBoardType == BOARD_TYPE["LEM18"])
{
	  LOOP_BACK_MODE_VALUE["NOLB"] = "NOLOOP";//0
}
else
{
	  LOOP_BACK_MODE_VALUE["NOLB"] = "NOLB";//0
}
LOOP_BACK_MODE_VALUE["FACILITY"] = "FACILITY";//1
LOOP_BACK_MODE_VALUE["TERMINAL"] = "TERMINAL";//2

var portEnable = [];
portEnable["N"] = RESOURCE["PORT"] + RESOURCE["disabled"];
portEnable["Y"] = RESOURCE["PORT"] + RESOURCE["enable"];

var broardcastenable = [];
broardcastenable["N"] = RESOURCE["disabled"];
broardcastenable["Y"] = RESOURCE["enable"];

var broadcastlimit = [];
broadcastlimit[1] = RESOURCE["limit1"];
broadcastlimit[2] = RESOURCE["limit2"];
broadcastlimit[3] = RESOURCE["limit3"];
broadcastlimit[4] = RESOURCE["limit4"];
broadcastlimit[5] = RESOURCE["limit5"];
broadcastlimit[6] = RESOURCE["limit6"];
broadcastlimit[7] = RESOURCE["limit7"];
broadcastlimit[8] = RESOURCE["limit8"];
broadcastlimit[9] = RESOURCE["limit9"];
broadcastlimit[10] = RESOURCE["limit10"];

var broardcastth = [];
broardcastth[1] = "10%";
broardcastth[2] = "20%";
broardcastth[3] = "30%";
broardcastth[4] = "40%";
broardcastth[5] = "50%";
broardcastth[6] = "60%";
broardcastth[7] = "70%";
broardcastth[8] = "80%";
broardcastth[9] = "90%";
broardcastth[10] = "100%";

var convertScramble = [];
convertScramble["DISABLE"] = RESOURCE["Unscrambled"];
convertScramble["X43"] = RESOURCE["scramblingMode43"];
convertScramble["X48"] = RESOURCE["scramblingMode48"];

var convertFlag = [];
convertFlag["N"] = "No";
convertFlag["Y"] = "Yes";

var convertEndian = [];
convertEndian["BIG"] = RESOURCE["bigEndian"];
convertEndian["LITTLE"] = RESOURCE["littleEndian"];

var convertFcs = [];
convertFcs["FCS32"] = RESOURCE["FCS32"];
convertFcs["FCS16"] = RESOURCE["FCS16"];
convertFcs["NONE"] = RESOURCE["NONE"];

function portToPortName(port)
{
	if(port > 32768)
	{
		return "VCTRUNK" + (port - 32768);
	}
	else
	{
		return "PORT" + port;
	}
}	

function splitBit(hexValue)
{
	for(var i = hexValue.length-2; i >0; i-=2)
	{
		hexValue = hexValue.substring(0,i) + " " + hexValue.substring(i);
	}
	return hexValue;
}
