/**
 *  ERPS       js  
 *   :     00104334
 *   : 2009-01-14
 */
 
var winurlobj = getNeProperty(self);
var win = getParentWindow();

var btnRight = null;

var erpsTable = null;

document.title = RESOURCE["createERPS"];

/**
 *      
 */
function initPage()
{
    initTable();
    initButton();
    initPort();
}

/**
 *      
 */
function initTable()
{
    erpsTable = new CTable();
    
    erpsTable.addHead(RESOURCE["ATTR"],RESOURCE["VALUE"]);
    
    var cTableAtom = null;
    
    var cTableAtomEle = null;
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 

    if (win.winurlobj["boardType"] == "2272") //LEM18  1-4
    {
    	ERPS_ID_MAX = "4";
    }
    checkText(cTableAtomEle, ERPS_ID_MIN, ERPS_ID_MAX);
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    erpsTable.addAttrRow("erpsid", RESOURCE["erpsid"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
        initRPLPort();
    }
    erpsTable.addAttrRow("eastPortId", RESOURCE["eastPortId"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
        initRPLPort();
    }
    erpsTable.addAttrRow("westPortId", RESOURCE["westPortId"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    cTableAtom.addOption(RESOURCE["IsNotRPLOwnerTL1"], RESOURCE["IsNotRPLOwnerTL1"]);
    cTableAtom.addOption(RESOURCE["IsRPLOwnerTL1"], RESOURCE["IsRPLOwnerTL1"]);
    cTableAtomEle = cTableAtom.element; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
        if (RESOURCE["IsRPLOwnerTL1"] == this.value)
        {
            initRPLPort();
            erpsTable.getAtom("rplPortId").element.disabled = false;
        }
        else
        {
            erpsTable.getAtom("rplPortId").element.options.length = 0;
            erpsTable.getAtom("rplPortId").element.disabled = true;
        }
    }
    erpsTable.addAttrRow("isRPLOwnerFlag", RESOURCE["isRPLOwnerFlag"], cTableAtom); 
    
    cTableAtom = new Atom("select");
    cTableAtomEle = cTableAtom.element; 
    cTableAtomEle.disabled = true;
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    erpsTable.addAttrRow("rplPortId", RESOURCE["rplPortId"], cTableAtom); 

    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element; 
    checkText(cTableAtomEle, CTRL_VLAN_MIN, CTRL_VLAN_MAX);
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    erpsTable.addAttrRow("ctrlVlan", RESOURCE["ctrlVlan"], cTableAtom); 
    
    cTableAtom = new Atom("text");
    cTableAtomEle = cTableAtom.element;
    cTableAtomEle.value = DES_MAC_ADDR_DEFALT_VALUE; 
    
    cTableAtomEle.onchange = function ()
    {
        $("okbtn").disabled = false;
        $("applybtn").disabled = false;
    }
    cTableAtomEle.disabled = true;
    erpsTable.addAttrRow("desMacAddr", RESOURCE["desMacAddr"], cTableAtom); 
    
    $("erpsTableDiv").appendChild(erpsTable.getTable());
}

/**
 *      
 */
function initButton()
{
	$("okbtn").value =  RESOURCE["okbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	
	$("cancelbtn").onclick = doCancel;
}

/**
 *        
 */
function initPort()
{
    getPortList();
}

/**
 *   ERPS
 */
function createERPS(okFlag)
{
    if (okFlag && $("applybtn").disabled)
    {
        xcloseDialog();
        return;
    }
    else
    {
        var eastPortId = erpsTable.getAttrValue("eastPortId");
        var westPortId = erpsTable.getAttrValue("westPortId");
        var result = validateOnSubmit(erpsTable.getAtom("erpsid").element, ERPS_ID_MIN, ERPS_ID_MAX);
        if (!result)
        {
        	  alert(RESOURCE["inputerror"]);
            return;
        }
        
        if (null == eastPortId || null == westPortId)
        {
            return;
        }
        
        result = validateOnSubmit(erpsTable.getAtom("ctrlVlan").element, CTRL_VLAN_MIN, CTRL_VLAN_MAX);
        if (!result)
        {
            return;
        }
        
        setBtnDisabled(true);
        
        var xml = createERPSXML();
        
        var sfid = TECMDCODE_ERPS_CRT_ENTITY;
        
        var URL = "../../../../../../tl1NEExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
       loadXMLdoc(URL, "POST", false, createERPSBack, okFlag, "inputdata=" + xml);
    
    }
}

/**
 *     ERPS XML  
 */
function createERPSXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var erpsid = erpsTable.getAttrValue("erpsid");
    var eastPortId = erpsTable.getAttrValue("eastPortId");
    var westPortId = erpsTable.getAttrValue("westPortId");
    var isRPLOwnerFlag = erpsTable.getAttrValue("isRPLOwnerFlag");
    var rplPortId = null;
    
    var ctrlVlan = erpsTable.getAttrValue("ctrlVlan");
    var desMacAddr = erpsTable.getAttrValue("desMacAddr");
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "erpsid");
    param.setAttribute("value", erpsid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "eastPortId");
    param.setAttribute("value", eastPortId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "westPortId");
    param.setAttribute("value", westPortId);
    row.appendChild(param);

    if (RESOURCE["IsRPLOwnerTL1"] == isRPLOwnerFlag)
    {
    	rplPortId = erpsTable.getAttrValue("rplPortId");
    }
    else
    {
    	rplPortId = "NULL"
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "rplPortId");
    param.setAttribute("value", rplPortId);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "isRPLOwnerFlag");
    param.setAttribute("value", isRPLOwnerFlag);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ctrlVlan");
    param.setAttribute("value", ctrlVlan);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "desMacAddr");
    param.setAttribute("value", desMacAddr);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *   ERPS
 */

function createERPSBack(doc, okFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        setBtnDisabled(false);
    }
    else
    {
        fillTableData(data);
        $("okbtn").disabled = false;
        $("cancelbtn").disabled = false;
        $("applybtn").disabled = true;
        if (okFlag)
        {
            xcloseDialog();
            return;
        }
    }
}

/**
 *         
 * @param data:      
 * @return  
 */
function fillTableData(data)
{
    var erpsid = erpsTable.getAttrValue("erpsid");
    var eastPortId = erpsTable.getAttrValue("eastPortId");
    eastPortId = convertPort(eastPortId);
    var westPortId = erpsTable.getAttrValue("westPortId");
    westPortId = convertPort(westPortId);
    var isRPLOwnerFlag = erpsTable.getAttrValue("isRPLOwnerFlag");
    var rplPortId = null;
    if (RESOURCE["IsRPLOwnerTL1"] == isRPLOwnerFlag)
    {
        rplPortId = erpsTable.getAttrValue("rplPortId");
        
        rplPortId = convertPort(rplPortId);
    }
    else
    {
        rplPortId = "-";
    }
    var ctrlVlan = erpsTable.getAttrValue("ctrlVlan");
    var desMacAddr = erpsTable.getAttrValue("desMacAddr");
    
    var dataInterface = new DataInterface();
    var obj = new Object();
    var ptag = null;
    var alarmMessage = null;
    var selectedRows = null;
    var AID = null;
    var severity = null;
    var alarmType = null;
    var alarmMessage = null;
    
    ptag = new ParamTag();
    ptag.value = erpsid;  
    obj["erpsid"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = eastPortId;  
    obj["eastPortId"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = westPortId; 
    obj["westPortId"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = isRPLOwnerFlag;  
    obj["isRPLOwnerFlag"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = rplPortId;  
    obj["rplPortId"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = ctrlVlan;  
    obj["ctrlVlan"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = desMacAddr;  
    obj["desMacAddr"] = ptag;
    
    dataInterface.rows.append(obj);
    
    createTableBody(win.erpsListTable, win.window.tableconf[0], dataInterface, RESOURCE);
    win.erpsListTable.adjustDataRows();
    
    win.adjustToCurrSortStatus();  
    
    if (0 == win.erpsListTable.getSelectedRowCount() && 0 != win.erpsListTable.getDataRowLength())
    {
        win.erpsListTable.setRowSelect(0);
        win.rowSelectHandler();
    }
    else
    {
        win.setBtnStatusOnRowSelect();
    }   
}

/**
 *       
 */
function getPortList(portFlag)
{
    setBtnDisabled(true);
    
    var xml = getPortListXML();
    
    var sfid = TECMDCODE_ERPS_GET_PORT_LIST;
    
    var URL = "../../../../../../tl1NEExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(URL, "POST", false, getPortListBack, portFlag, "inputdata=" + xml);

}

/**
 *        XML
 */
function getPortListXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    
    row = new tagElement("row-params");
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", winurlobj["slotid"]);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/**
 *           
 */
function getPortListBack(doc, portFlag)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    var portid = null;
    var portname = null;
    var portAtom = null;
    
    if (OPERATE_SUCCESS == smallErrorCode)
    {
        for (var i = 0, len = data.getDataRowLength(); i < len; i ++)
        {
            portid = data.getDataRowParam(i, "portid", "portid");
            portname = data.getDataRowParam(i, "portname", "portname");
            
            if (null != arguments[1])
            {
                portAtom = erpsTable.getAtom(portFlag);
                portAtom.addOption(portname, portid);
            }
            else
            {
                portAtom = erpsTable.getAtom("eastPortId");
                portAtom.addOption(portname, portid);
                
                portAtom = erpsTable.getAtom("westPortId");
                portAtom.addOption(portname, portid);
            }
        }
    }
    
    setBtnDisabled(false);
}

/**
 *    RPL    
 */
function initRPLPort()
{
    if (RESOURCE["IsNotRPLOwnerTL1"] == erpsTable.getAttrValue("isRPLOwnerFlag"))
    {
        return;
    }
    var selectAtom = erpsTable.getAtom("rplPortId");
    var eastPortId = erpsTable.getAttrValue("eastPortId");
    var westPortId = erpsTable.getAttrValue("westPortId");
    
    selectAtom.element.options.length = 0;
    if (null != eastPortId)
    {
        selectAtom.addOption(convertPort(eastPortId), eastPortId);
    }
    if (null != westPortId)
    {
        selectAtom.addOption(convertPort(westPortId), westPortId);
    }
}

/**
 *     
 */
function doCancel()
{
    xcloseDialog();
}

/**
 *         
 */
function setBtnDisabled(flag)
{
    $("okbtn").disabled = flag;
    $("applybtn").disabled = flag;
    $("cancelbtn").disabled = flag
}

/**
 *        
 */
function showErrorDialog(data, errArr)
{
    var errorArray = null;
    if (null == errArr)
    {
        errorArray = new Array();
        errorArray.push("nename");
    }
    else
    {
        errorArray = errArr;
    }
    openErrPage("../../../../../../page/", data.getError(), errorArray); 
}
