/**************
 *     
***************/
var QINQ_LEN = 5;

var qinqTable;
var qinqTblConf;
var mainPageUrl = getNeProperty(self);
var neid = mainPageUrl["neid"];
var slotid = mainPageUrl["slotid"];
var nmUser = mainPageUrl["nmUser"];
var btnRightArr = new Object();
var doingFlg = false;

document.oncontextmenu = returnFalse;

window.onload = initPage;

function initPage()
{   
    initTable();
    initButton();
    if(btnRightArr.querybtn.right)
    {
        doQuery();
    }
}

function initTable()
{
    loadXMLdoc("../../../../conf/board_attribute/ip/advanceattr/bdqinqtable_"+SYSTEMCONF.getLanguage()+".xml", "GET", false, EncapsulateTable);
    qinqTblConf = window.tableconf[0];
    qinqTable = new SortTable();
    qinqTable.setImage("../../../../../../images/");
    createTableHead(qinqTable, qinqTblConf);
    $("tablecontainer").appendChild(qinqTable.getTable());
    qinqTable.setBodyHeight(getComponetHeight($("tablecontainer"), 100)+"px");
    qinqTable.setOnCellEditHandler(cellDbclickHandler);
}

function initButton()
{
    $("querybtn").value = RESOURCE["ID_QUERY"];
    $("applybtn").value = RESOURCE["apply"];
    
    btnRightArr.querybtn = new BtnRightObj("querybtn",TECMDCODE_QUERY_BOARD_QINQTYPE);
    btnRightArr.applybtn = new BtnRightObj("applybtn",TECMDCODE_SET_BOARD_QINQTYPE);
    
    sendRightInfo(btnRightArr);
}

function sendRightInfo()
{
    var xmldata = createRightXML();
    var url = "../../../../../../securityServlet?neID=" + neid + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + xmldata);
}

function createRightXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel, thirdlevel;
    for(var btnrightobj in btnRightArr)
    {
	      secondlevel = new tagElement("row-params");
	      
	      thirdlevel = new tagElement("param"); 
	      thirdlevel.setAttribute("name", "btnID");
	      thirdlevel.setAttribute("value", btnRightArr[btnrightobj].btnId);
	      secondlevel.appendChild(thirdlevel); 
	      
	      thirdlevel = new tagElement("param"); 
	      thirdlevel.setAttribute("name", "sfid");
	      thirdlevel.setAttribute("value", btnRightArr[btnrightobj].sfid);
	      secondlevel.appendChild(thirdlevel); 
	      
	      firstlevel.appendChild(secondlevel); 
    }
	  root.getRoot().appendChild(firstlevel);
	  return root.toString();
}

function rightHandleBack (doc)
{
    var data = EncapsulateData(doc);
    for(var i = 0, datalen = data.getDataRowLength(); i < datalen; i++)
    {
        var right = data.getDataRowParam(i,"right");
        if(1 == right)
        {
            btnRightArr[data.getDataRowParam(i,"btnID")].right = true;
        }
        else
        {
            btnRightArr[data.getDataRowParam(i,"btnID")].right = false;
        }
    }
}

function initBtnStatue()
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    doingFlg = false;
}

function doQuery()
{   
    disableAllBtn();
    var xmldata = createQueryXMLData();
    var url = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_QUERY_BOARD_QINQTYPE+"&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, handleQueryData, null, "inputdata=" + xmldata);
}

function createQueryXMLData()
{
    var root = new inputxml("datainterface");
        
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");
	thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", slotid);
    secondlevel.appendChild(thirdlevel);
    	  
	  firstlevel.appendChild(secondlevel);
	  root.getRoot().appendChild(firstlevel);
	  return root.toString();
}

function handleQueryData(doc)
{
    var data = EncapsulateData(doc);
    if(0 == data.getSErrorCode())
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neid,false);
        qinqTable.clearTableData();
        createTableBody(qinqTable, qinqTblConf, data, RESOURCE);
        qinqTable.sortRows(qinqTable.getHeadCell("board").element, 1);    
    }
    handleErrInfo(data);
    initBtnStatue();
}

function handleErrInfo(data)
{
    var errArr = [];
    errArr.push("nename");
	errArr.push("boardname");
	openErrPage("../../../../../../page/", data.getError(), errArr);
}

function disableAllBtn()
{
    doingFlg = true;
    for(var btnid in btnRightArr)
    {
        if($(btnid))
        {
            $(btnid).disabled = true;
        }
    }
}

function convertMsg(resobj,	cvtobj,	cvtvalue)
{
		if("function" == typeof cvtobj)
		{
		    return cvtobj(cvtvalue);
		}
		if(cvtvalue == "-")
		{
	      return cvtvalue;
		}
		return resobj[cvtobj[cvtvalue]];
}

function splitBit(hexValue)
{
    for(var i = hexValue.length - 2; i > 0; i -= 2)
    {
        hexValue = hexValue.substring(0, i) + " " + hexValue.substring(i);
    }
    return hexValue;
}

function checkHexData(obj,minvalue,maxvalue)
{
	var minold = "0x0600";
	var maxold = "0xFFFF";
	  var value = parseInt(obj);
	  if("" == value)
	  {
	  	  value = 0;
	  }
	  value = removeSpace(value);
	  value = parseInt(value,16);
	  
	  maxvalue = parseInt(maxvalue,16)
	  minvalue = parseInt(minvalue,16)

	  if(value > maxvalue || value < minvalue)
	  {
	  	  var alertStr = RESOURCE["wrong1"] + minold + RESOURCE["wrong2"] + maxold + RESOURCE["wrong3"];
	  	  alert(alertStr);
	  	  return false;
	  }
	  
	  if(value < 0x1000 && obj.value.length < 4)
	  {
	  	  obj.value = obj.value + 0;
	  }
	  return true;
}

function cellDbclickHandler(param)
{
    if((param.colid == "ATTR_ETHOVERSDH_QINQ_TYPE") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
	  {
		    var qtpArr = getQinQTypeArr();
		    var dm = qinqTable.getCellEdit(param.rowindex, param.colid).element.parent;
		    dm.selview.options.length = 0;
		    dm.initComboBox(qtpArr,"dm",0,false);
		    var textview = qinqTable.getCellEdit(i, "ATTR_ETHOVERSDH_QINQ_TYPE").element.parent.txtview;
		    hexCellEvent(textview);
		    textview.style.imeMode = "disabled";
		    textview.onblur = onblurHandler;
		    textview.onpaste = function()
	      {
		      return false;
	      }
		    textview.maxLength = QINQ_LEN;
	  }
	  
	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neid,true);
	  
    if(btnRightArr.applybtn.right)
    {
        $("applybtn").disabled = false;
    }  
}

function doApply()
{
    var xmldata = createApplyXMLData();
    
    if (xmldata == false)
    {
    	return;
    }
    
    disableAllBtn();
    
    var url = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_SET_BOARD_QINQTYPE+"&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, handleApplyData, null, "inputdata=" + xmldata);
}

function createApplyXMLData()                                                      
{                                                                                   
    var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	  
    var secondlevel, thirdlevel;
    
	for(var i = 0, selectlen = qinqTable.getDataRowLength(); i < selectlen; i++)                                      
    {
    	  if(false == qinqTable.getModify(i))
    	  {
    	      continue;
    	  }
        
        if(true == qinqTable.getModify(i))                          
        {
        	var qinqType = qinqTable.getAtomValue(qinqTable.getCellShow(i, "ATTR_ETHOVERSDH_QINQ_TYPE"));
        	var qinqvar = qinqType.substring(0,2) + qinqType.substring(3);
        	if (!checkHexData("0x"+qinqvar,0x0600,0xFFFF))
        	{
        		continue;
        	}
        	
            secondlevel = new tagElement("row-params");
    	    
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "neid");
            thirdlevel.setAttribute("value", neid);
            secondlevel.appendChild(thirdlevel);
                
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "slotid");
            thirdlevel.setAttribute("value", slotid);
            secondlevel.appendChild(thirdlevel);
            
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "SVTPID");
            thirdlevel.setAttribute("value", qinqvar);
            secondlevel.appendChild(thirdlevel);
        }  
        firstlevel.appendChild(secondlevel);      
    }
                                                                                                                                      
	root.getRoot().appendChild(firstlevel);    //
	
	if (root.toString().indexOf("row-params") < 0)
	{
		return false;
	}
	  
    return root.toString(); 
}

function handleApplyData(doc)
{
    var data = EncapsulateData(doc);
    refreshTableState(qinqTable, qinqTblConf, data);
    handleErrInfo(data);
    initBtnStatue();
    if(data.getSErrorCode() != 0)
    {
       $("applybtn").disabled = false;        
    }
    else
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neid,false);
    }
    
}

function getQinQTypeArr()
{
	var qtpArr = new Array();
	qtpArr[0] = new Option("81 00", "81 00");
	qtpArr[1] = new Option("88 A8", "88 a8");
	qtpArr[2] = new Option("91 00", "91 00");
	return qtpArr;	
}

function onblurHandler(event)
{
	if (!event)
	{
		event = window.event;
	}	
	var numobj = event.target ? event.target : event.srcElement;//st.getCellCurrentValue(i,"cir","cir");
  if(numobj.value == "")
   {		   
       numobj.value = "81 00";
       return;
   }			
}

window.onunload=function()
{
    if(typeof(qinqTable)!='undefined' && qinqTable instanceof SortTable)
    {
		clearSortTable(qinqTable);
	}
}
