var winurlobj = getNeProperty(self);
var st, upst;
var neid = winurlobj["neid"];
var bdType = winurlobj["boardType"];

var isBoardModelChanged = false;

var boardModeIntValue;
var OPRSUCC = 0;
var PARTSUCC = 1;

var boardModeOptions;
var portModeOptions = [];
var BDTYPE_TNF1ELOM = 1620;

window.onresize = function()
{
	st.setBodyHeight(getComponetHeight($("tabletemp"),100)+"px");
	upst.setBodyHeight(getComponetHeight($("tablecomponent"), 70) + "px");
}

function init()
{	
	initUpSortTable();	
	initDownSortTable();	
    document.getElementById("stateBtn").value = RESOURCE["statebutton"];
	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	hideUpSortTable();
	queryBoard();
	
}

function initUpSortTable()
{
	$("boardModelField").appendChild(document.createTextNode(RESOURCE["boardworkmodel"]));
	upst = new SortTable();
	upst.setImage("../../../../../../images/");
	createTableHead(upst, window.tableconf[0]);
	upst.setOnCellEditHandler(cellEditHandler);
	upst.setBodyHeight(getComponetHeight($("boardtablecomponent"),100) + "px");
	$("boardtablecomponent").appendChild(upst.getTable());
}

function initDownSortTable()
{
	$("portworkmodelField").appendChild(document.createTextNode(RESOURCE["portworkmodel"]));
	st = new SortTable();
	st.setImage("../../../../../../images/");
	createTableHead(st, window.tableconf[1]);
	st.setOnCellEditHandler(cellEditHandler);
	st.setBodyHeight(getComponetHeight($("tabletemp"),100)+"px");
	$("tablecomponent").appendChild(st.getTable());
}

function showUpSortTable()
{
	$("boardmodeldiv").style.display = "";
}

function hideUpSortTable()
{
	$("boardmodeldiv").style.display = "none";
}

function hideDownSortTable()
{
	$("tabletemp").style.display = "none";
}

function showDownSortTable()
{
	$("tabletemp").style.display = "";
}

function queryBoard()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;

	var xmlstr = createBoardQueryXML();
	var urlreq = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_OTN_QUERY_BOARDMODE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, handleBackBoardQuery, "",
			"inputdata=" + xmlstr);
}

function createBoardQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", winurlobj["slotid"]);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackBoardQuery(doc, param)
{
	var data = EncapsulateData(doc);
	if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode())
	{
		var boardMode = data.getDataRowParam(0, "workmode");	
		boardModeIntValue = data.getDataRowParam(0, "boardModeIntValue");			
		
		if (boardMode!="")
		{	
			showUpSortTable();												
		}
		
		var portMode = 	data.getDataRowParam(0, "isSupportPortMode");	
		if (portMode=="true")
		{						
			queryPort(boardMode);
		}
		else
		{	
			hideDownSortTable();
		}
	}
	
    boardModeOptions = data.getDataRowOptions(0,"workmode");   	
	upst.clearTableData();
	createTableBody(upst, window.tableconf[0], data, RESOURCE);
	addListener();
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	openErrPage("../../../../../../page/", data.getError(), errArr);
	$("querybtn").disabled = false;
}

function modify()
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	var isModifyBaord = false;
	for ( var rowindex = 0, length = upst.getDataRowLength(); rowindex < length; rowindex++)
	{
		if (upst.getModify(rowindex))
		{
			isModifyBaord = true;
			break;
		}
	}
	if (isModifyBaord)
	{
		var xmlstr = createBoardSetXML();
		var urlreq = "../../../../../../tl1NEExlorerServlet?sfid="
				+ TECMDCODE_OTN_SET_BOARDMODE + "&nmUser="
				+ winurlobj["nmUser"];
		loadXMLdoc(urlreq, "POST", true, handleBackBoardSet, true,
				"inputdata=" + xmlstr);
	}
	else
	{
		var xmlstr = createPortSetXML();
		var urlreq = "../../../../../../tl1NEExlorerServlet?sfid="
				+ TECMDCODE_OTN_SET_PORTMODE + "&nmUser=" + winurlobj["nmUser"];
		loadXMLdoc(urlreq, "POST", true, handleBackPortSet, null, "inputdata="
				+ xmlstr);
	}

}

function createBoardSetXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", winurlobj["slotid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "AID");
	param.setAttribute("value", upst.getCellStoreValue(0, "AID", "AID"));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "workmode");
	param.setAttribute("value", upst.getCellStoreValue(0, "workmode",
			"workmode"));
	row.appendChild(param);
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackBoardSet(doc)
{
	var data = EncapsulateData(doc);
	if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode())
	{
		var boardMode = upst.getCellStoreValue(upst.getSelectedRows()[0],
				"workmode", "workmode");
		queryBoard();
		var modeCell = upst.getCell(upst.getSelectedRows()[0], "workmode");
		modeCell.element.modify = false;
		modeCell.element.parentNode.modify = false;
		modeCell.element.style.backgroundColor = "#ffffff";
	}
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	openErrPage("../../../../../../page/", data.getError(), errArr);
	$("querybtn").disabled = false;
}

function createPortSetXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	for ( var i = st.getDataRowLength()-1; 0 <= i; i--)
	{
		if (!st.getModify(i))
		{
			continue;
		}
		var row = new tagElement("row-params");

		var param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winurlobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param.setAttribute("value", winurlobj["slotid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "AID");
		param.setAttribute("value", st.getCellStoreValue(i, "AID", "AID"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "workmode");
		param.setAttribute("value", st.getCellStoreValue(i, "portworkmodel",
				"portworkmodel"));
		row.appendChild(param);
		
		if (BDTYPE_TNF1ELOM == bdType)
		{
			param = new tagElement("param");
			param.setAttribute("name", "mod2");
			param.setAttribute("value", st.getCellStoreValue(i, "mod2", "mod2"));
			row.appendChild(param);
		}

		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackPortSet(doc)
{
	var data = EncapsulateData(doc);
	if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode())
	{
		for ( var i = 0, n = st.getDataRowLength(); i < n; i++)
		{
			if(data.getError().rowErrors.length==0)
			{
				var modeCell = st.getCell(i, "portworkmodel");
				modeCell.element.modify = false;
				modeCell.element.parentNode.modify = false;
				modeCell.element.style.backgroundColor = "#ffffff";
			}
			else
			{
				for ( var j = 0, m = data.getError().rowErrors.length; j < m; j++)
				{
					var aid = data.getError().rowErrors[j].errorObj.AID;
					var modeCell = st.getCell(i, "portworkmodel");
					var aidCellValue = st.getCellStoreValue(i, "AID", "AID");
					if (aidCellValue != aid)
					{
						modeCell.element.modify = false;
						modeCell.element.parentNode.modify = false;
						modeCell.element.style.backgroundColor = "#ffffff";
					}
				}
			}

		}
	}
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	openErrPage("../../../../../../page/", data.getError(), errArr);
	$("querybtn").disabled = false;

	if (BDTYPE_TNF1ELOM == bdType && (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode()))
	{
		var boardMode = upst.getCellStoreValue(0, "workmode", "workmode");
		queryPort(boardMode);
	}
}

function queryPort(boardMode)
{
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;

	var xmlstr = createPortQueryXML(boardMode);
	var urlreq = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_OTN_QUERY_PORTMODE + "&nmUser=" + winurlobj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, handleBackPortQuery, null, "inputdata="
			+ xmlstr);
}
function createPortQueryXML(boardMode)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winurlobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", winurlobj["slotid"]);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "boardMode");
	param.setAttribute("value", boardMode);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function handleBackPortQuery(doc)
{
	var data = EncapsulateData(doc);
	if (OPRSUCC == data.getSErrorCode() || PARTSUCC == data.getSErrorCode())
	{
       showDownSortTable();
	}
	for (var i=0,len = data.getDataRowLength();i<len;i++)
	{
		var options = data.getDataRowOptions(i,"portworkmodel");
		var portid = data.getDataRowParam(i, "portid");
		portModeOptions[portid] = options;			
	}
	st.clearTableData();
	createTableBody(st, window.tableconf[1], data, RESOURCE);	
	
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	openErrPage("../../../../../../page/", data.getError(), errArr);
	$("querybtn").disabled = false;
}

function addListener()
{
	if (boardModeOptions == null || boardModeOptions.length == 0)
	{
		return;
	}

	var portModeCell = upst.getCellEdit(0, "workmode");
	if (portModeCell != null)
	{
		portModeCell.clearOptions();
		for (var i=0,len= boardModeOptions.length;i<len;i++)
	    {
			var value = boardModeOptions[i];
			var resource = "boardmode_"+value;
			portModeCell.addOptionObj(new Option(RESOURCE[resource], value));
	    }
	}
	
}

function cellEditHandler(param)
{
	var colid = param.colid;
	var st = param.st;
	var rowindex = param.rowindex;
	if ((param.stage == TABLE_CONSTANT.BEFOREEDIT) && (colid == "portworkmodel"))
	{
		
		var portid = st.getCellStoreValue(param.rowindex, "portid", "portid");
		var portModeCell = st.getCellEdit(param.rowindex, "portworkmodel");

		portModeCellAddOption(boardModeIntValue, portid, portModeCell);
	}
	$("applybtn").disabled = false;
}

function portworkmodel(paramData)
{
	if (paramData == "65535")
	{
		return RESOURCE["WOKRMODE_65535"];
	}
	if (boardModeIntValue == -1)
	{
		boardModeIntValue = "";
	}
	return RESOURCE["WOKRMODE" + boardModeIntValue + "_" + paramData];
}

function boardworlmodel(paramData)
{	
	return RESOURCE["boardmode" + "_" + boardModeIntValue];
}

function portModeCellAddOption(boardModel, portid, portModeCell)
{
	var options = portModeOptions[portid];
	if (options == null)
	{
		return;
	}
	portModeCell.clearOptions();
	if (boardModel == -1)
	{
		boardModel = "";
	}

	for (var i=0,len=options.length;i<len;i++)
	{		
		var portValue = options[i];
		var resource = "WOKRMODE" + boardModel + "_" + portValue;
		portModeCell.addOptionObj(new Option(RESOURCE[resource], portValue));
	}
}

function createjsDOMenu(menuType)

{
	removejsDOMmenu();

	var cursorMenu1 = new jsDOMenu(150);

	if (menuType == 0)
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["STATE_IS"], "",
				setState, "IS"));

		cursorMenu1.addMenuItem(new menuItem(RESOURCE["STATE_OOS"], "",
				setState, "OOS"));

		cursorMenu1.addMenuItem(new menuItem(RESOURCE["STATE_AINS"], "",
				setState, "AINS"));
	}
	else
	{
		cursorMenu1
				.addMenuItem(new menuItem(RESOURCE["unkown"], "", null, null));
	}

	setPopUpMenu(cursorMenu1);
}

function setState(state)
{
	var state = state;
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", getNeProperty(top).neid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotID");
	var slotid = upst.getCellCurrentValue(0, "boardName", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "AID");
	param.setAttribute("value", upst.getCellCurrentValue(0, "AID", "AID"));
	row.appendChild(param);

	param = new tagElement("param");
	param = new tagElement("param");
	if (state == "IS" || state == "OOS")
	{
		param.setAttribute("name", "PST");
		param.setAttribute("value", state);
	}
	else if (state == "AINS")
	{
		param.setAttribute("name", "SST");
		param.setAttribute("value", state);
	}
	row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	urlreq = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_SONET_SET_BOARD_ATTRIB + "&nmUser="
			+ winurlobj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, bdStateCallback, null, "inputdata="
			+ di.toString());
}

function bdStateCallback(doc)
{
	var result = EncapsulateData(doc);
	var verString = "";
	if (0 != result.getError().getGlobleECode())
	{
		var oArray = new Array();
		oArray[0] = "nename";
		oArray[1] = "slotID";
		oArray[2] = "boardname";
		openErrPage("../../../../../../page/", result.getError(), oArray);
		return;
	}
	else
	{
		queryBoard();
	}
}


