loadXMLdoc("../../../../../../conf/system.xml","GET",false,EncapsulateSConf);
language = SYSTEMCONF.getLanguage();

loadXMLdoc("../../../../conf/ne_attribute/config/stdntpkeymgr/createntpkeymgrtable_"+language+".xml", "GET", false,EncapsulateTable);

getResourse("../../../../../../res/loginres_"+ language +".xml")
getResourse("../../../../../../res/configres_" + language + ".xml");
getResourse("../../../../../../res/commonres_" + language + ".xml");
getResourse("../../../../../../res/necommres_" + language + ".xml");
getResourse("../../../../../../res/neinformationres_" + language + ".xml");
getResourse("../../../../../../res/securityres_" + language + ".xml");
getResourse("../../../../res/config/stdntpkeymgr/stdntpkeymgr_" + language + ".xml");

var neid = getNeProperty(self)["neid"];
var neName = getNeProperty(self)["neName"];
var parentWin = getParentWindow();

var tableTop = new CTable();
var tableBottom = new SortTable();
var keyAtom;
var pwdAtom;
var repwdAtom;
var validAtom;

var isValidOption = new Object();
isValidOption.PERIT = RESOURCE["RES_PERMIT"];
isValidOption.NOTPERMIT = RESOURCE["RES_NOTPERMIT"];
isValidOption.PERIT_ID = "1";
isValidOption.NOTPERMIT_ID = "0";

document.title = RESOURCE["RES_CREATEINSTANCE"];

var pwdMinLength = 6;
var pwdMaxLength = 16;

var SpecialCode = "`~!@#$%^&*()-_=+\\|[{}];:'\",<.>/? ";

function init()
{
	tableTop.addHead(RESOURCE["attribute"], RESOURCE["getvalue"]);

	keyAtom = new Atom("text");
	keyAtom.setValue("1");   
	keyAtom.element.style.width="100%";
	tableTop.addAttrRow("key",RESOURCE["RES_KEY"],keyAtom);
	validateNum(keyAtom.element,1,1024,4);

	pwdAtom = new Atom("password");
	pwdAtom.setValue("1");   
	pwdAtom.element.style.width="100%";
	tableTop.addAttrRow("pwd",RESOURCE["RES_PWD"],pwdAtom);
	pwdAtom.element.maxLength = 16;
	
	repwdAtom = new Atom("password");
	repwdAtom.setValue("1");   
	repwdAtom.element.style.width="100%";
	tableTop.addAttrRow("repwd",RESOURCE["affirmpwd"],repwdAtom);
	repwdAtom.element.maxLength = 16;

	validAtom = new Atom("select");
	validAtom.addOption("Y", "Y");
	validAtom.addOption("N", "N");
	validAtom.element.style.width="100%";
	tableTop.addAttrRow("valid",RESOURCE["RES_VALID"],validAtom);

	document.getElementById("table").appendChild(tableTop.getTable());

	tableBottom = new SortTable();
	tableBottom.setImage("../../../../../../images/");
	tableBottom.setBodyHeight(0);
	createTableHead(tableBottom, window.tableconf[0]);
	document.getElementById("table").appendChild(tableBottom.getTable());
	setDataInBottomTable("This is-ne_name");

	$("confirmBtn").value=RESOURCE["okbutton"];
	$("cancelBtn").value=RESOURCE["cancelbutton"];
}

function setDataInBottomTable(m_NeName)
{
	var prtTable = tableBottom.getTable();
	prtTable.insertRow(prtTable.rows.length);
	var curRow = prtTable.insertRow(prtTable.rows.length);
	var m_Cell = curRow.insertCell(curRow.cells.length);
	m_Cell.innerHTML = "<div align='center'>" + neName + "</div>";
}

function confirmByBtn()
{
	applyByBtn();
}

function applyByBtn()
{

	$("confirmBtn").disabled = true;
		
	if( pwdAtom.getValue() == "" || pwdAtom.getValue() == "" )
	{
		alert(RESOURCE["RES_PLZINPUTPWD"]);
		$("confirmBtn").disabled = false;
		return;
	}
	
	if(pwdAtom.getValue().length < pwdMinLength)
	{
		alert(RESOURCE["pswlenminerror1"] + pwdMinLength + RESOURCE["pswlenminerror2"]);
		$("confirmBtn").disabled = false;
		return false;
	}
	
	if(pwdAtom.getValue() != repwdAtom.getValue())
	{
		alert(RESOURCE["bothpsw"]);
		$("confirmBtn").disabled = false;
		return false;
	}
	
	if(!isExistLower(pwdAtom.getValue()))
	{
		alert(RESOURCE["pswlowererror"]);
		$("confirmBtn").disabled = false;
		return false;
	}
	if(!isExistSuper(pwdAtom.getValue()))
	{
		alert(RESOURCE["pswsupererror"]);
		$("confirmBtn").disabled = false;
		return false;
	}
	if(!isExistNumber(pwdAtom.getValue()))
	{
		alert(RESOURCE["pswnumbererror"]);
		$("confirmBtn").disabled = false;
		return false;
	}
	if(!isExistSpecial(pwdAtom.getValue()))
	{
		alert(RESOURCE["pswspecialerror1"] + SpecialCode + RESOURCE["pswspecialerror2"]);
		$("confirmBtn").disabled = false;
		return false;
	}

	var xml = generateCreationXml();
	var serverURL = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_ADDNTPKEYINFO+"&flag=1"; 
	loadXMLdoc(serverURL,"POST",true,callbackCreate,null,"inputdata="+xml);	
}

function callbackCreate(doc)
{
   	var dinterface  = EncapsulateData(doc);

	if(0 != dinterface.getSErrorCode()) 
	{
		showErrorDialog(dinterface);
		$("confirmBtn").disabled = false;
		return ;
	}
	
	parentWin.doQry();
	xcloseDialog();
}

/******************************************************/


function generateCreationXml()
{
	var root = new inputxml("datainterface");
	var bussinessLevel = new tagElement("bussiness-params");
	var rowParaLevel;
	var param;

	rowParaLevel = new tagElement("row-params");

	param = new tagElement("param");
	param.setAttribute("name","neid");
	param.setAttribute("value",neid);
	rowParaLevel.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name","key");
	param.setAttribute("value",keyAtom.getValue());
	rowParaLevel.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name","pwd");
	param.setAttribute("value",EncryptUtils.encrypt(pwdAtom.getValue()));
	rowParaLevel.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name","validType");
	param.setAttribute("value","0");	//md5
	rowParaLevel.appendChild(param);	

	param = new tagElement("param");
	param.setAttribute("name","isValid");
	param.setAttribute("value",validAtom.getValue());
	rowParaLevel.appendChild(param);


	bussinessLevel.appendChild(rowParaLevel);

	root.getRoot().appendChild(bussinessLevel);
	return root.toString();
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "key";
    openErrPage("../../../../../../page/", data.getError(), errArr);
    errArr = null;
}
/**
 *       
 */
function isExistNumber(pwd)
{
	for(var i = 0,len = pwd.length;i < len;i++)
	{
		var code = pwd.charCodeAt(i);
		if(code >= 48 && code <= 57)
		{
			return true;
		}
	}
	return false;
}
/**
 *         
 */
function isExistLower(pwd)
{
	for(var i = 0,len = pwd.length;i < len;i++)
	{
		var code = pwd.charCodeAt(i);
		if(code >= 97 && code <= 122)
		{
			return true;
		}
	}
	return false;
}
/**
 *         
 */
function isExistSuper(pwd)
{
	for(var i = 0,len = pwd.length;i < len;i++)
	{
		var code = pwd.charCodeAt(i);
		if(code >= 65 && code <= 90)
		{
			return true;
		}
	}
	return false;
}

/**
 *         
 */
function isExistSpecial(pwd)
{
	for(var i = 0,len = pwd.length;i < len;i++)
	{
		var code = pwd.charAt(i);
		if(SpecialCode.indexOf(code) >= 0)
		{
			return true;
		}
	}
	return false;
}
