var winurlobj = getParentWindow();
var neid = winurlobj.neid;
var OPRSUCC = 0;
var OPRPART = 1;
var FAIL = 2;
var bridgeTable;
var portTable;
var EMPTYRESULT = 38662;
var TIMEOUT = 131080;
var BRIDGE_MIN_PRIORITY = "0";
var BRIDGE_MAX_PRIORITY = "61440";
var PORT_MIN_PRIORITY = "0";
var PORT_MAX_PRIORITY = "240";
var BRIDGEPRI_STEPLENGTH = "4096";
var PORTPRI_STEPLENGTH = "16";
var QUERY_PROTOCOL = TECMDCODE_QUERY_STP_PORTPARA;
var RAPID_ENABLE = TECMDCODE_RSTP_RAPID_ENABLE;
var LOGIC_PORT = 0x7000;
var VCTRUNK_PORT = 0x8000;
var bridgeChangeFlag = false;
var portChangeFlag = false;
var bridgeData;
var portData;
var bridgeDataObj;

var enable = new Object();
enable["N"] = "disable";
enable["Y"] = "enable";

var protocolType = new Object();
protocolType["STP"] = "STP";
protocolType["RSTP"] = "RSTP";

function initPage()
{
	  
	  initTable();
	  initButton();
}

function initTable()
{
	  bridgeTable = new SortTable();
	  bridgeTable.setImage("../../../../../../images/");
	  createTableHead(bridgeTable, window.tableconf[0]);
      bridgeTable.setOnCellEditHandler(cellEditHandlerByBridge);
      bridgeTable.setBodyHeight(getComponetHeight($("bridgetable"),500)+"px");
	  document.getElementById("bridgetable").appendChild(bridgeTable.getTable());    
      document.getElementById("bridgetable").oncontextmenu = popupMenuHandler;
      
      portTable = new SortTable();
	  portTable.setImage("../../../../../../images/");
	  createTableHead(portTable, window.tableconf[1]);
      portTable.setOnCellEditHandler(cellEditHandlerByPort);
      portTable.setBodyHeight(getComponetHeight($("porttable"),50)+"px");
	  document.getElementById("porttable").appendChild(portTable.getTable());    
      document.getElementById("porttable").oncontextmenu = popupMenuHandler;
}

function cellEditHandlerByBridge()
{ 
	bridgeChangeFlag = true;
	$("okbtn").disabled = false;
}

function cellEditHandlerByPort()
{
	portChangeFlag = true;
	$("okbtn").disabled = false;
}

function initButton()
{
	  $("okbtn").value = RESOURCE["submit"];
	  $("cancelbtn").value = RESOURCE["cancelbutton"];
	  $("okbtn").disabled = true;
	  
	  createTableData();
      createTableBody(bridgeTable, window.tableconf[0], bridgeData, RESOURCE);    
      addBridgeCellEvent();
      
	  sendQueryInfo();
}

function sendQueryInfo()
{
	$("okbtn").disabled = true;
	$("cancelbtn").disabled = true;
	
    var xmlstr = createQueryXML();
	var urlreq ="../../../../../../tl1NEExlorerServlet?sfid="+QUERY_PROTOCOL+"&nmUser="+winurlobj.winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackQuery,null,"inputdata="+xmlstr);
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",winurlobj["slotid"]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","vbid");
    param.setAttribute("value",winurlobj.vbid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","port");
    param.setAttribute("value","ALL");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackQuery(doc)
{	
	$("cancelbtn").disabled = false;  
	var data = EncapsulateData(doc);
    portData = data;
    if (OPRSUCC == data.getError().getGlobleECode() || OPRPART == data.getError().getGlobleECode() ) 
    {	  	  	     
    	for (var i = 0, len = data.getDataRowLength() ; i < len; i++)
    	{
    	  	var ptag = new ParamTag();
    	  	var obj = data.rows[i];
            ptag.value = winurlobj.vbname;
            obj["vbname"] = ptag;
            
            var portid = obj["port"].value;
            ptag = new ParamTag();
            ptag.value = convertPort(parseInt(portid));
            obj["portname"] = ptag;           
    	}

	    portTable.clearTableData();
        createTableBody(portTable, window.tableconf[1], data, RESOURCE); 
        addPortCellEvent();
    }
}

function createTableData()
{
	  var bridgeTable1 = winurlobj.st;
	  var selectedRowID = winurlobj.selectedRowID;
	  var obj = new Object();
	  bridgeData = new DataInterface();

	  var ptag = new ParamTag();
      ptag.value = bridgeTable1.getCellStoreValue(selectedRowID,"vb","vbid");
      obj["vbid"] = ptag;
	  
	  ptag = new ParamTag();
      ptag.value = bridgeTable1.getCellStoreValue(selectedRowID,"vb","vbname");
      obj["vbname"] = ptag;
	  
	  ptag = new ParamTag();
      ptag.value = bridgeTable1.getCellStoreValue(selectedRowID,"protocolType","protocolType");
      obj["protocolType"] = ptag;
	  
	  ptag = new ParamTag();
      ptag.value = bridgeTable1.getCellStoreValue(selectedRowID,"protocolEneble","protocolEneble");
      obj["protocolEneble"] = ptag;

	  ptag = new ParamTag();
      ptag.value = bridgeTable1.getCellStoreValue(selectedRowID,"priority","priority");
      obj["priority"] = ptag;
    
      bridgeData.rows[0] = obj;
}

function addBridgeCellEvent()
{
	  var cell = null;
	  for(var i = 0,len = bridgeTable.getDataRowLength();i<len;i++)
	  {	  	  	      
	  	  cell = bridgeTable.getCellElement(i,"priority");
	  	  textCheckWithStepLen(cell.editElement.element,BRIDGE_MIN_PRIORITY,BRIDGE_MAX_PRIORITY,BRIDGEPRI_STEPLENGTH);
	  }
}

function addPortCellEvent()
{
	var cell = null;
	for(var i = 0,len = portTable.getDataRowLength();i<len;i++)
	{	  	  	      
		cell = portTable.getCellElement(i,"priority");
	  	textCheckWithStepLen(cell.editElement.element,PORT_MIN_PRIORITY,PORT_MAX_PRIORITY,PORTPRI_STEPLENGTH);
	}
}

function convertPort(portid)
{
	return "LP" + portid;
}

function convertPortid(portName)
{
	  var portid;
	  portName += "";
	  if(-1 != portName.indexOf("LP"))
	  {
	  	 portid = portName.substring(2);
	  }
	  else if (-1 != portName.indexOf("PORT"))
	  {
	  	  portid = portName.substring(4);
	  }	
	  else if (-1 != portName.indexOf("VCTRUNK"))
	  {
	  	  portid = portName.substring(7);
	  }	
	  else
	  {
	  	  portid = parseInt(portName) + LOGIC_PORT;
	  }
	  return portid;
}

function submit()
{	  
    var xmlstr = createSubmitXML();
	if (null != xmlstr)
	{   
    	urlreq ="../../../../../../tl1NEExlorerServlet?sfid="+RAPID_ENABLE+"&nmUser="+winurlobj.winurlobj["nmUser"];
    	loadXMLdoc(urlreq, "POST",true,handleBackSubmit,null,"inputdata="+xmlstr);
    }
}

function createSubmitXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row;
    var param;
    if (bridgeChangeFlag || portChangeFlag)
    {
		if (bridgeChangeFlag)
		{
			bridgeDataObj = new Object();
			row = new tagElement("row-params");
			param = new tagElement("param");    
			param.setAttribute("name","neid");
            param.setAttribute("value",winurlobj["neid"]);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","slotid");
            param.setAttribute("value",winurlobj["slotid"]);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name","vbid");
            param.setAttribute("value",bridgeTable.getCellStoreValue(0,"vb","vbid"));
            row.appendChild(param);
            
            param = new tagElement("param");    
      	    param.setAttribute("name","protocolEneble");
      	    var protocolEnable = bridgeTable.getCellStoreValue(0,"protocolEneble","protocolEneble");
      	    bridgeDataObj["protocolEneble"] = protocolEnable;
      	    param.setAttribute("value", protocolEnable);
      	    if (bridgeTable.getCellModify(0, "protocolEneble"))
	        {
	        	param.setAttribute("modifyFlag",true);
	        }
	        else
	        {
	        	param.setAttribute("modifyFlag",false);
	        }
	        
      	    row.appendChild(param);
            param = new tagElement("param");    
      	    param.setAttribute("name","protocolType");
      	    var protocolType = bridgeTable.getCellStoreValue(0,"protocolType","protocolType");
      	    bridgeDataObj["protocolType"] = protocolType;
      	    param.setAttribute("value", protocolType);
      	    if (bridgeTable.getCellModify(0, "protocolType"))
	        {
	        	param.setAttribute("modifyFlag",true);
	        }
	        else
	        {
	        	param.setAttribute("modifyFlag",false);
	        }
      	    row.appendChild(param);                        
            param = new tagElement("param");    
      	    param.setAttribute("name","priority");
      	    var priority = bridgeTable.getCellStoreValue(0,"priority","priority");
      	    bridgeDataObj["priority"] = priority;
      	    param.setAttribute("value", priority);
      	    if (bridgeTable.getCellModify(0, "priority"))
	        {
	        	param.setAttribute("modifyFlag",true);
	        }
	        else
	        {
	        	param.setAttribute("modifyFlag",false);
	        }
      	    row.appendChild(param);
      	    
      	    param = new tagElement("param");    
      	    param.setAttribute("name","code");
      	    param.setAttribute("value", "RTRV-STP-VB");
      	    row.appendChild(param);
                    
			bussiness.appendChild(row);
		}
		if (portChangeFlag)
		{
			for (var i = 0, len = portTable.getDataRowLength(); i < len; i++)
			{
				if (portTable.getModify(i))
	            {
    	          	row = new tagElement("row-params");
                
	              	param = new tagElement("param");    
                  	param.setAttribute("name","neid");
                	param.setAttribute("value",neid);
                	row.appendChild(param);
                
                	param = new tagElement("param");
                	param.setAttribute("name","slotid");
                	param.setAttribute("value",winurlobj["slotid"]);
                	row.appendChild(param);
                
                	param = new tagElement("param");
                	param.setAttribute("name","vbid");
                	param.setAttribute("value",portTable.getCellStoreValue(i,"vb","vbid"));
                	row.appendChild(param);
                	param = new tagElement("param");
                	param.setAttribute("name","port");
                	var portid = convertPortid(portTable.getCellStoreValue(i,"portname","portname"));
                	param.setAttribute("value", portid);
                	row.appendChild(param);
                	param = new tagElement("param");
                	param.setAttribute("name","portpriority");
                	param.setAttribute("value", portTable.getCellStoreValue(i,"priority","priority"));
                	if (portTable.getCellModify(i, "priority"))
			        {
			        	param.setAttribute("modifyFlag",true);
			        }
			        else
			        {
			        	param.setAttribute("modifyFlag",false);
			        }
                	row.appendChild(param);
                	param = new tagElement("param");    
		      	    param.setAttribute("name","code");
		      	    param.setAttribute("value", "RTRV-STP-VBLP");
		      	    row.appendChild(param);
                        
    	          	bussiness.appendChild(row);
				}
			}
		}
    }
    else
    {
    	  return null;
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackSubmit(doc)
{	  
	var data = EncapsulateData(doc);
	   
	if (OPRSUCC != data.getError().getGlobleECode()) 
  {     
		for(var i = 0;i < data.getBErrLength();i++)
		{
			var tempObj = data.getError().rowErrors[i].errorObj;
			tempObj["operateObj"] = tempObj["vbid"] + "-" + bridgeTable.getCellStoreValue(0,"vb","vbname");
			
			if (null != tempObj["port"])
			{
			    tempObj["operateObj"] += "-" + (parseInt(tempObj["port"]) - LOGIC_PORT);
			}
		}	
	}
		
	var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "boardname";
    openErrPage("../../../../../../page/", data.getError(), errArr);  

    if (OPRSUCC == data.getError().getGlobleECode())
    {
        if (bridgeChangeFlag)
        {
            var selectedRowID = winurlobj.selectedRowID;
    	  
    	      var proEn = bridgeDataObj["protocolEneble"];
	  	      winurlobj.st.getCellShow(selectedRowID,"protocolEneble").setValue(RESOURCE[enable[proEn]]);
	  	      winurlobj.st.setCellValue(winurlobj.st.getCell(selectedRowID,"protocolEneble"),"protocolEneble",proEn);
	  	          	  
    	      var proType = bridgeDataObj["protocolType"];
	  	      winurlobj.st.getCellShow(selectedRowID,"protocolType").setValue(RESOURCE[protocolType[proType]]);
	  	      winurlobj.st.setCellValue(winurlobj.st.getCell(selectedRowID,"protocolType"),"protocolType",proType);
    	      
    	      var proPriority = bridgeDataObj["priority"];
	  	      winurlobj.st.setCellValue(winurlobj.st.getCell(selectedRowID,"priority"),"priority",proPriority);	  	  
        }
    	  
	  	  xcloseDialog();
    }
}
