    /**
    *        
    */
    loadXMLdoc("../../../../../../conf/system.xml", "GET",false, EncapsulateSConf);
    language = SYSTEMCONF.getLanguage();
    getResourse("../../../../../../res/commonres_"+ language +".xml");
    
    getResourse("../../../../res/config/portprotection/portprotectionres_"+ language +".xml");
    
    document.title = RESOURCE["modifyportprotectiongroup"];
    
    var UNSUPPORTED = "-";
    
    var MINDELAYTIME = "0";
    
    var MAXDELAYTIME = "100";
    
    var REVERTIVWTRTIME = "5";
    
    var MAXVALUE = "12";
    
    var MINVALUE = "5";
    
    var MAXLEN = "64";
    
    var workingDelayTime = "";
    
    var protectionDelayTime = "";
    
    var win = getParentWindow();
	var neverflg = getNeProperty(win)["neversion"].split(".")[2];
	var neType = getNeProperty(win)["neType"]
    
    var selectLines = win.protectionGroupSTable.getSelectedRows();
    var selectLine = selectLines[0];
var selectLineDown = win.pathStatusSTable.getSelectedRows()[0];
    var isSuccess = false;
    
    var selectParams = [];
    var selectParam = new Object();
    selectParams[0] = selectParam;
    
var isSupportSwitchTypeAndAPSFlag = false;

var nename = getNeProperty(win)["nename"];

var switchDectTimeAtom = null;
var BDTYPE_TN12SC1 = 1275;
var BDTYPE_TN12SC2 = 1262;

var SINGLE_MODE = "0"; //     
var DUAL_MODE = "1"; //     
var usableBoardArr = new Array(); //          
var channelNEAtom = null;
var channelBoardAtom = null;
var channelPortAtom = null;
var switchModeAtom = null;

    /**
    *      
    */
    function init()
    {
        ct = new CTable();
        ct.addHead(RESOURCE["attr"],RESOURCE["value"]);
        protectionGroupNameAtom = new Atom("select");
        

        protectionTypeAtom = new Atom("select");
        protectionTypeValue = win.protectionGroupSTable.getCellStoreValue(selectLine,"protectiontype", "protectionType");
        var protectionType = win.protectionGroupSTable.getCellShow(selectLine,"protectiontype").getValue();
        
        protectionTypeAtom.element.options[protectionTypeAtom.element.options.length] = new Option(protectionType,0);
        ct.addAttrRow(RESOURCE["attr"],RESOURCE["protectiontype"],protectionTypeAtom);
        protectionTypeAtom.element.style.width="100%";
        protectionTypeAtom.element.disabled = true;
        protectionTypeAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
        
        neWithWorkingUnitAtom = new Atom("select");
        neWithWorkingUnitAtom.element.style.width="100%";
        var neWorking = win.pathStatusSTable.getCellStoreValue(selectLineDown,"workingunit", "wnename");
        neWithWorkingUnitAtom.element.options[neWithWorkingUnitAtom.element.options.length] = new Option(neWorking,0);
        neWithWorkingUnitAtom.element.disabled = true;
        ct.addAttrRow("neWithWorkingUnit", RESOURCE["newithworkingunit"], neWithWorkingUnitAtom);
         neWithWorkingUnitAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		}        
        workPortId = win.pathStatusSTable.getCellStoreValue(selectLineDown,"workingunit", "wshowSlot");
        var bdWorking = workPortId + "-" + win.pathStatusSTable.getCellStoreValue(selectLineDown,"workingunit", "wboardName");
        var boardWithWorkingUnitAtom = new Atom("select");
        boardWithWorkingUnitAtom.element.style.width="100%";
        boardWithWorkingUnitAtom.element.options[boardWithWorkingUnitAtom.element.options.length] = new Option(bdWorking,0);
        boardWithWorkingUnitAtom.element.disabled = true;
        ct.addAttrRow("boardWithWorkingUnit", RESOURCE["boardwithworkingunit"], boardWithWorkingUnitAtom);
         boardWithWorkingUnitAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
        portWorking = win.pathStatusSTable.getCellStoreValue(selectLineDown,"workingunit", "wportName"); 
        var workingUnitAtom = new Atom("select");
        workingUnitAtom.element.style.width="100%";
        workingUnitAtom.element.options[workingUnitAtom.element.options.length] = new Option(portWorking,0);
        workingUnitAtom.element.disabled = true;
        ct.addAttrRow("workingUnit", RESOURCE["workingunit"], workingUnitAtom);
         workingUnitAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
         
        var otherDeviceFlag = false;
	    if(win.pathStatusSTable.getCellStoreValue(selectLine ,"protectionunitShow", "protectionunitShow") == "otherdevice")
	    {
	    	otherDeviceFlag = true;
	    }
        var neProtection = win.pathStatusSTable.getCellStoreValue(selectLineDown, "protectionunit", "pnename");
        var neWithProtectionUnitAtom = new Atom("select");
        neWithProtectionUnitAtom.element.style.width="100%";
        if (otherDeviceFlag)
        {
        	neWithProtectionUnitAtom.element.options[neWithProtectionUnitAtom.element.options.length] = new Option(RESOURCE["otherdevice"],0);
        }
        else
        {
        	neWithProtectionUnitAtom.element.options[neWithProtectionUnitAtom.element.options.length] = new Option(neProtection,0);
        }
        neWithProtectionUnitAtom.element.disabled = true;
        ct.addAttrRow("neWithProtectionUnit", RESOURCE["newithprotectionunit"], neWithProtectionUnitAtom);
         neWithProtectionUnitAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
        protectPortId = win.pathStatusSTable.getCellStoreValue(selectLineDown, "protectionunit", "pshowSlot");
        var bdPortection = protectPortId + "-" + win.pathStatusSTable.getCellStoreValue(selectLineDown, "protectionunit", "pboardName")
        var boardWithProtectionUnitAtom = new Atom("select");
        boardWithProtectionUnitAtom.element.style.width="100%";
        if (otherDeviceFlag)
        {
        	boardWithProtectionUnitAtom.element.options[boardWithProtectionUnitAtom.element.options.length] = new Option("-",0);
        }
        else
        {
        	boardWithProtectionUnitAtom.element.options[boardWithProtectionUnitAtom.element.options.length] = new Option(bdPortection,0);
        }
        boardWithProtectionUnitAtom.element.disabled = true;
        ct.addAttrRow("boardWithProtectionUnit", RESOURCE["boardwithprotectionunit"], boardWithProtectionUnitAtom);
         boardWithProtectionUnitAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
        portPortection = win.pathStatusSTable.getCellStoreValue(selectLineDown, "protectionunit", "pportName");
        var protectionUnitAtom = new Atom("select");
        protectionUnitAtom.element.style.width="100%";
        if (otherDeviceFlag)
        {
        	protectionUnitAtom.element.options[protectionUnitAtom.element.options.length] = new Option("-",0);
        }
        else
        {
        	protectionUnitAtom.element.options[protectionUnitAtom.element.options.length] = new Option(portPortection,0);
        }
        protectionUnitAtom.element.options[protectionUnitAtom.element.options.length] = new Option(portPortection,0);
        protectionUnitAtom.element.disabled = true;
        ct.addAttrRow("protectionUnit", RESOURCE["protectionunit"], protectionUnitAtom);
		protectionUnitAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
        var neCtrl = win.pathStatusSTable.getCellStoreValue(selectLineDown, "controlunitworkingpathShow", "controlunitworkingpathShow");
        var neCrlShow = "-";
        var bdCtrl = win.pathStatusSTable.getCellStoreValue(selectLineDown, "controlunitworkingpath", "cwslotId");
        if(neCtrl == "otherdevice")
        {
        	neCrlShow = RESOURCE["otherdevice"];
        	bdCtrl = "-";
        }
        else
        {
        	if (neCtrl!=null)
        	{
        		neCrlShow = neCtrl;
        	}
        	
            if (bdCtrl != undefined)
            {
            	bdCtrl += "-" + win.pathStatusSTable.getCellStoreValue(selectLineDown, "controlunitworkingpath", "cwboardName");
            }
            else
            {
            	bdCtrl = "-";
            }
        }
	    var neCtrlValue = win.pathStatusSTable.getCellStoreValue(selectLineDown, "controlunitworkingpath", "cwnename");
	    if (neCtrlValue == undefined) 
	    {
	        neCtrlValue = "";
	    }
	       

        var neWithControlUnitAtom = new Atom("select");
        neWithControlUnitAtom.element.style.width="100%";
        neWithControlUnitAtom.element.options[neWithControlUnitAtom.element.options.length] = new Option(neCrlShow,0);
        neWithControlUnitAtom.element.disabled = true;
        ct.addAttrRow("neWithControlUnit", RESOURCE["newithcontrolunit"], neWithControlUnitAtom);
		neWithControlUnitAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 		
        var bdCtrl = win.pathStatusSTable.getCellStoreValue(selectLineDown, "controlunitworkingpath", "cwshowSlot");
        if (bdCtrl != undefined && neCtrl != "otherdevice")
        {
        	bdCtrl += "-" + win.pathStatusSTable.getCellStoreValue(selectLineDown, "controlunitworkingpath", "cwboardName");
        }
        else
        {
        	bdCtrl = "-";
        }
        var boradWithControlUnitAtom = new Atom("select");
        boradWithControlUnitAtom.element.style.width="100%";
        boradWithControlUnitAtom.element.options[boradWithControlUnitAtom.element.options.length] = new Option(bdCtrl,0);   
        boradWithControlUnitAtom.element.disabled = true;
        ct.addAttrRow("boardWithControlUnit", RESOURCE["boradwithcontrolunit"], boradWithControlUnitAtom);
		boradWithControlUnitAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
        var wportCtrl = win.pathStatusSTable.getCellStoreValue(selectLineDown, "controlunitworkingpath", "cwportName");
        if (wportCtrl == undefined || neCtrl == "otherdevice")
        {
        	wportCtrl = "-";
        }
        var controlUnitWorkingPathAtom = new Atom("select");
        controlUnitWorkingPathAtom.element.style.width="100%";
        controlUnitWorkingPathAtom.element.options[controlUnitWorkingPathAtom.element.options.length] = new Option(wportCtrl,0);
        controlUnitWorkingPathAtom.element.disabled = true;
        ct.addAttrRow("controlUnitWorkingPath", RESOURCE["controlunitworkingpath"], controlUnitWorkingPathAtom);
		controlUnitWorkingPathAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
        workingDelayTime = RESOURCE["workingunitdelaytime"];
        protectionDelayTime = RESOURCE["protectionunitdelaytime"];
        
        workingPath = win.pathStatusSTable.getCellShow(selectLineDown,"workingunit").getValue();        
        protectionPath = win.pathStatusSTable.getCellShow(selectLineDown,"protectionunit").getValue();        
        cworkingPath = win.pathStatusSTable.getCellShow(selectLineDown,"controlunitworkingpath").getValue();
        
        workingUnitDelayTimeAtom = new Atom("text");
        var workingDelayTimeValue = win.pathStatusSTable.getCellShow(selectLineDown,"workingunitdelaytime").getValue();
        workingUnitDelayTimeAtom.setValue(workingDelayTimeValue);
        ct.addAttrRow(workingDelayTime,workingDelayTime,workingUnitDelayTimeAtom)
        workingUnitDelayTimeAtom.element.style.width = "100%";
        workingUnitDelayTimeAtom.element.style.imeMode = "disabled";
        checkText(workingUnitDelayTimeAtom.element, MINDELAYTIME, MAXDELAYTIME);
		workingUnitDelayTimeAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
        protecionUnitDelayTimeAtom = new Atom("text");
        var protectionDelayTimeValue = win.pathStatusSTable.getCellShow(selectLineDown,"protectionunitdelaytime").getValue();
        protecionUnitDelayTimeAtom.setValue(protectionDelayTimeValue);
        ct.addAttrRow(protectionDelayTime,protectionDelayTime,protecionUnitDelayTimeAtom)
        protecionUnitDelayTimeAtom.element.style.width = "100%";
        protecionUnitDelayTimeAtom.element.style.imeMode = "disabled";
        checkText(protecionUnitDelayTimeAtom.element, MINDELAYTIME, MAXDELAYTIME); 
		protecionUnitDelayTimeAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		}          
		if (otherDeviceFlag)
		{
			protecionUnitDelayTimeAtom.element.disabled = true;
		}
		ctrlUnitDelayTimeAtom = new Atom("text");
		var wbname =  win.pathStatusSTable.getCellStoreValue(selectLineDown,"workingunit", "wboardName")
		if(neType==66&&protectionType=="Intra-Board 1+1 Protection"&&wbname=="OLP")//  1800A     1+1  
	    {
	    	
		    var ctrlDelayTimeValue = win.pathStatusSTable.getCellShow(selectLineDown,"ctrlunitdelaytime").getValue();
		    ctrlUnitDelayTimeAtom.setValue(ctrlDelayTimeValue); 
		    ctrlUnitDelayTimeAtom.element.style.width = "100%";
		    ctrlUnitDelayTimeAtom.element.style.imeMode = "disabled"; 
		    ct.addAttrRow("crtlUnitDelayTime",RESOURCE["crtlunitdelaytime"],ctrlUnitDelayTimeAtom)      
	    	checkText(ctrlUnitDelayTimeAtom.element, MINDELAYTIME, MAXDELAYTIME);
	 	    ctrlUnitDelayTimeAtom.element.onchange = function()
			{
				$("applyBtn").disabled = false;
			}
			protecionUnitDelayTimeAtom.element.disabled = true;
			workingUnitDelayTimeAtom.element.disabled = true;
	    }
    	revertiveModeAtom = new Atom("select");
        ct.addAttrRow("revertivemode",RESOURCE["revertivemode"],revertiveModeAtom);
        revertiveModeAtom.element.style.width = "100%";
        if(neCtrl == "otherdevice")
        {
        	revertiveModeAtom.element.disabled = true;
        }
        
        
 		revertiveModeAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		} 
        wtrTimeAtom = new Atom("select");
        ct.addAttrRow("wtrtime",RESOURCE["wtrtime"],wtrTimeAtom);
        wtrTimeAtom.element.style.width = "100%";
   		wtrTimeAtom.element.onchange = function()
		{
			$("applyBtn").disabled = false;
		}      
        var revertiveModeValue = win.protectionGroupSTable.getCellStoreValue(selectLine,"revertivemode","revertiveMode");
        if (revertiveModeValue != undefined)
        {        
        	selectParam.selectType = "revertivemode";
        	selectParam.selectAtom = revertiveModeAtom;
        	loadXMLdoc("../../../../conf/ne_attribute/config/portprotection/select_"+language+".xml", "GET", false,selectXMLParse,selectParams);  //            
        	for(var i = 0, len = revertiveModeAtom.element.options.length; i < len; i++)
        	{
        	    if(revertiveModeAtom.element.options[i].value == revertiveModeValue)
        	    {
        	        revertiveModeAtom.element.selectedIndex = i;
        	        break;
        	    }
        	}
        	revertiveModeAtom.element.disabled = false;
        
        	var wtrTimeValue = win.protectionGroupSTable.getCellStoreValue(selectLine,"wtrtime","wtrTime");
        	wtrTimeAtom.setValue(wtrTimeValue);
        	if(wtrTimeValue == 0)
        	{
        	  	wtrTimeAtom.clearOptions();
        	  	wtrTimeAtom.element.options[wtrTimeAtom.element.options.length] = new Option("-", 0);
        	  	wtrTimeAtom.setValue(NONREVERTIVWTRTIME);
        	}
       		else
        	{
        	    wtrTimeAtom.clearOptions();
        	 	wtrTimeAtom.element.options[wtrTimeAtom.element.options.length] = new Option("05:00", 5);
                wtrTimeAtom.element.options[wtrTimeAtom.element.options.length] = new Option("06:00", 6);
                wtrTimeAtom.element.options[wtrTimeAtom.element.options.length] = new Option("07:00", 7);
                wtrTimeAtom.element.options[wtrTimeAtom.element.options.length] = new Option("08:00", 8);
                wtrTimeAtom.element.options[wtrTimeAtom.element.options.length] = new Option("09:00", 9);
                wtrTimeAtom.element.options[wtrTimeAtom.element.options.length] = new Option("10:00", 10);
                wtrTimeAtom.element.options[wtrTimeAtom.element.options.length] = new Option("11:00", 11);
                wtrTimeAtom.element.options[wtrTimeAtom.element.options.length] = new Option("12:00", 12);
                wtrTimeAtom.setValue(wtrTimeValue);
        	}
            if(neType!= 66 && protectionTypeValue=="INNER1+1" && win.pathStatusSTable.getCellStoreValue(selectLine,"workingunit", "wboardName").indexOf("OLP")!=-1)
		   	{
		   		if(win.pathStatusSTable.getCellStoreValue(selectLine,"controlunitworkingpathShow", "controlunitworkingpathShow")!="NULL")
		   		{
		   			revertiveModeAtom.element.disabled=true;  
		   		}
		   		else
		   		{
		   			revertiveModeAtom.element.disabled=false;  
		   		}
		   		
		   	}
		   	else if (protectionTypeValue=="CLIENT1+1" && neCtrl == "otherdevice")
		   	{
		   		revertiveModeAtom.element.disabled=true; 
		   	}
	        else
	        {
				revertiveModeAtom.element.disabled=false;  
	        }
            wtrTimeAtom.element["onchange"] = function ()
            {
                $("applyBtn").disabled = false;
            }
            
        	revertiveModeAtom.element["onchange"] = function()
        	{
    	     	changeRevertiveMode(this,wtrTimeAtom);
    	     	$("applyBtn").disabled = false;
    	     	isSuccess = false;
        	}
        	checkText(wtrTimeAtom.element, MINVALUE, MAXVALUE); 
        }
        else
        {
        	revertiveModeAtom.element.options[revertiveModeAtom.element.options.length] = new Option("-",255);
        	revertiveModeAtom.element.disabled = true;
        	
        	wtrTimeAtom.setValue("-");
        } 
        
        if (revertiveModeAtom.getValue() == "Y")
        {
        	wtrTimeAtom.element.disabled = false;
        }
        else
        {
        	wtrTimeAtom.element.disabled = true;
        } 

        sdTriggerFlagAtom = new Atom("select");
        ct.addAttrRow("sdtriggerflag",RESOURCE["sdtriggerflag"],sdTriggerFlagAtom);
        selectParam.selectType = "sdtriggerflag";
        selectParam.selectAtom = sdTriggerFlagAtom;
        loadXMLdoc("../../../../conf/ne_attribute/config/portprotection/select_"+language+".xml", "GET", false,selectXMLParse,selectParams); // SD    
        var sdTriggerFlag = win.protectionGroupSTable.getCellStoreValue(selectLine,"sdtriggerflag","sdEnable");
        for(var i = 0, len = sdTriggerFlagAtom.element.options.length; i < len; i++)
        {
            if(sdTriggerFlagAtom.element.options[i].value == sdTriggerFlag)
            {
                sdTriggerFlagAtom.element.selectedIndex = i;
                break;
            }
        }

        sdTriggerFlagAtom.element.style.width="100%";
        sdTriggerFlagAtom.element.disabled = false;
         sdTriggerFlagAtom.element["onchange"] = function()
        {
    	     $("applyBtn").disabled = false;
    	     isSuccess = false;
        }   
        
    
        
	    var switchDectTime =  win.pathStatusSTable.getCellShow(selectLineDown, "switchDectTime").getValue();
	    var switchDectTimeAtom = new Atom("text");
	    switchDectTimeAtom.element.style.width = "100%";
	    switchDectTimeAtom.setValue(switchDectTime);
		if (switchDectTime == "-")
		{
	        switchDectTimeAtom.element.disabled = true;
		}
		else
		{
	        switchDectTimeAtom.element.disabled = false;
		}
		checkText(switchDectTimeAtom.element, "0", "1000");
		ct.addAttrRow("switchDectTime", RESOURCE["switchDectTime"], switchDectTimeAtom);
        
        remarksAtom = new Atom("text");
        remarksAtom.element.style.width = "100%";
        var remarkvalue = win.protectionGroupSTable.getCellStoreValue(selectLine,"MARK","MARK");
        if(remarkvalue == undefined)
        {
            remarkvalue = "";
        }
        remarksAtom.setValue(remarkvalue);
        remarksAtom.element.onkeyup = function()
        {
          return calStrSinoLen(this, MAXLEN);
        }
        ct.addAttrRow("remarks",RESOURCE["remarks"],remarksAtom);
		remarksAtom.element.onpaste = function()
		{
			return false;
		}  
        remarksAtom.element.onkeypress = function()
		{
			 if (!restrictByAllow(this,window.event,"\"\\=,:;?"))
	        {
	        	return false;
	        }
	        else
	        {
	        	$("applyBtn").disabled = false;
    	     isSuccess = false;
	        }
		}

        document.body.appendChild(ct.getTable());

        var tempatom = ct.getAtom(RESOURCE["attr"]);
	    if (tempatom.element.innerText == "Optical Line Protection")
	    {
	    	ct.getAtom("sdtriggerflag").element.disabled = true;
			ct.getAtom("sdtriggerflag").setValue("DISABLE");
	    }
	    
		isSupportSwitchTypeAndAPSFlag = isSupportSwitchTypeAndAPS(protectionTypeValue);
	    if(isSupportSwitchTypeAndAPSFlag)
	    {
	        var switchTypeAtom = new Atom("select");
	        var switchTypeValue = win.protectionGroupSTable.getCellStoreValue(selectLine, "switchType", "switchType");
	        switchTypeAtom.element.options[switchTypeAtom.element.options.length] = new Option(RESOURCE["APS_MODE_0"], 0);
	        switchTypeAtom.element.options[switchTypeAtom.element.options.length] = new Option(RESOURCE["APS_MODE_1"], 1);
	        switchTypeAtom.element.value = switchTypeValue;
	        if(neCtrlValue == "")
	        {
	            switchTypeAtom.element.disabled = true;
	        }
	        else
	        {
	            switchTypeAtom.element.disabled = false;
	        }
	        switchTypeAtom.element.style.width = "100%";
	        ct.addAttrRow("switchType", RESOURCE["switchType"], switchTypeAtom);
			
	        var apsChannelAtom = new Atom("text");
	        var apsChannel = win.protectionGroupSTable.getCellCurrentValue(selectLine, "apsChannel","apsChannel");
	        apsChannelAtom.setValue(apsChannel);
	        if(win.apsSwitchType.unidirectional == switchTypeValue || switchTypeAtom.element.disabled)
	        {
	            apsChannelAtom.element.disabled = true;
	            apsChannelAtom.setValue("-");
	        }
	        else
	        {
	            apsChannelAtom.element.disabled = false;
	        }
	        apsChannelAtom.element.style.width = "100%";
	        ct.addAttrRow("apsChannel", RESOURCE["apsChannel"], apsChannelAtom);
	    }
	    var switchMode =  win.protectionGroupSTable.getCellStoreValue(selectLine, "switchType", "switchType");
	    if (protectionTypeValue == win.protection.LINEPROTECTION && switchMode != undefined && switchMode != "-")
	    {
	    	sendGetAvailableResourceInfo();
	    	switchModeAtom = new Atom("select");
	    	switchModeAtom.addOptionObj(new Option(RESOURCE["APS_MODE_0"], 0));
	    	switchModeAtom.addOptionObj(new Option(RESOURCE["APS_MODE_1"], 1));
	    	switchModeAtom.element.style.width = "100%";
	    	
	    	ct.addAttrRow("switchMode", RESOURCE["switchMode"], switchModeAtom);
	    	switchModeAtom.setValue(switchMode);
	    	
	    	if (usableBoardArr.length == 0) //        
	    	{
	    		switchModeAtom.element.disabled = true;
	    	}
	    	switchModeAtom.element.onchange = switchModeChange;
	    	channelNEAtom = new Atom("select");
	    	channelNEAtom.element.style.width = "100%";
	    	channelNEAtom.element.disabled = true;
	        ct.addAttrRow("channelNE", RESOURCE["ATTRIBUTE_MONITOR_NE"], channelNEAtom);
	        if (switchMode == SINGLE_MODE) //        
	        {
	        	ct.getAttrRow("channelNE").style.display = "none";
	        }
	        else
	        {
	        	var channelNE = win.pathStatusSTable.getCellStoreValue(selectLineDown, "workingunit", "wnename");
	        	channelNEAtom.element.options[channelNEAtom.element.options.length] = new Option(channelNE, 0);
	        }
	        
	        channelBoardAtom = new Atom("select");
	        channelBoardAtom.element.style.width = "100%";
	        ct.addAttrRow("channelBoard", RESOURCE["ATTRIBUTE_MONITOR_BOARD"], channelBoardAtom);
	        var cslotId = 0;
	        if (switchMode == SINGLE_MODE) //        
	        {
	        	ct.getAttrRow("channelBoard").style.display = "none";
	        }
	        else
	        {
	        	for (var i = 0, len = usableBoardArr.length; i < len; i++) 
	        	{
	        		channelBoardAtom.addOption(usableBoardArr[i].toString(), usableBoardArr[i].key);
	        	}
	        	cslotId = win.protectionGroupSTable.getCellStoreValue(selectLine, "channelHiddenUnit", "cslotId");
	        	channelBoardAtom.setValue(cslotId);
	        }
	        channelBoardAtom.element.onchange = channelBoardChange;
	        
	        channelPortAtom = new Atom("select");
	        channelPortAtom.element.style.width = "100%";
	        ct.addAttrRow("channelPort", RESOURCE["ATTRIBUTE_MONITOR_PORT"], channelPortAtom);
	        if (switchMode == SINGLE_MODE) //        
	        {
	        	ct.getAttrRow("channelPort").style.display = "none";
	        }
	        else
	        {
	        	var portId = win.protectionGroupSTable.getCellStoreValue(selectLine, "channelHiddenUnit", "cportId");
	        	for (var i = 0, len = usableBoardArr.length; i < len; i++) 
	        	{
	        		if (usableBoardArr[i].slotId == cslotId)
	        		{
	        			for (var j = 0, size = usableBoardArr[i].portArr.length; j < size; j++)
	        			{
	        				var portNameTemp = usableBoardArr[i].portArr[j];
	        				channelPortAtom.element.options[channelPortAtom.element.options.length] = new Option(portNameTemp, getPortID(portNameTemp));
	        			}
	        			break;
	        		}
	        	}
	        	channelPortAtom.setValue(portId);
	        }
        channelPortAtom.element.onchange = function()
        {
        	$("applyBtn").disabled = false;
        	isSuccess = false;
        }
    }     
	    addInitListener();
	    
    }
    
/**
 *               
 */
function addInitListener()
{
    var atom = null;
	
    if(isSupportSwitchTypeAndAPSFlag)
    {
        atom = ct.getAtom("switchType");
        atom.element["onchange"] = function()
        {
            $("applyBtn").disabled = false;
            return changeswitchType(this.value);
        }
	
        atom = ct.getAtom("apsChannel");
        checkText(atom.element, "0", "7");
    }
}

/**
 *             APS          
 */
function changeswitchType(selectValue)
{
    var atom = ct.getAtom("apsChannel");
    if(selectValue == win.apsSwitchType.unidirectional)
    {
        atom.element.disabled = true;
        atom.setValue("-");
    }
    else if(selectValue == win.apsSwitchType.bidirectional)
    {
        atom.element.disabled = false;
        atom.setValue("7");
    }
}

/**
 * 5.51.09.10                APS              1+1  
 * @return
 */
function isSupportSwitchTypeAndAPS(protectionTypeValue)
{
    if(protectionTypeValue != win.protection.BOARDPROTECTION)
    {
        return false;
    }
    return SpecialAttrMgr.isNESupport(win.neIdValue, "TE_FUNC_CFG_PORT_PROTCTION", "OTN_ATTR_SUPPORT_PORT_PROTCTION_SWITCHTYPE_APS");
}

/**
 *         
 * @return
 */
function switchModeChange()
{
	$("applyBtn").disabled = false;
	isSuccess = false;
	if (this.value == SINGLE_MODE) //     
	{
		ct.getAttrRow("channelNE").style.display = "none";
		ct.getAttrRow("channelBoard").style.display = "none";
		ct.getAttrRow("channelPort").style.display = "none";
	}
	else
	{
		ct.getAttrRow("channelNE").style.display = "";
		ct.getAttrRow("channelBoard").style.display = "";
		ct.getAttrRow("channelPort").style.display = "";
		if (win.protectionGroupSTable.getCellStoreValue(selectLine, "switchType", "switchType") == SINGLE_MODE)
		{
			var channelNE = win.pathStatusSTable.getCellStoreValue(selectLineDown, "workingunit", "wnename");
        	channelNEAtom.element.options[channelNEAtom.element.options.length] = new Option(channelNE, 0);
			for (var i = 0, len = usableBoardArr.length; i < len; i++) 
        	{
        		channelBoardAtom.addOption(usableBoardArr[i].toString(), usableBoardArr[i].key);
        	}
			channelBoardChange();
		}
	}
}

/**
 *         
 * @return
 */
function channelBoardChange()
{
	$("applyBtn").disabled = false;
	isSuccess = false;
	var slotId = channelBoardAtom.element.value;
	channelPortAtom.element.options.length = 0;
	for (var i = 0, len = usableBoardArr.length; i < len; i++) 
	{
		if (usableBoardArr[i].slotId == slotId)
		{
			for (var j = 0, size = usableBoardArr[i].portArr.length; j < size; j++)
			{
				var portNameTemp = usableBoardArr[i].portArr[j];
				channelPortAtom.element.options[channelPortAtom.element.options.length] = new Option(portNameTemp, getPortID(portNameTemp));
			}
			break;
		}
	}
}

/**
 *           ID
 */
function getPortID(portName)
{
    var portID = 0;
    var index = portName.indexOf("(");
    return portName.substring(0, index);
}
    function checkText(obj,min,max)
	{	
		obj.style.imeMode = "disabled";
	
		obj.onpaste = function()
		{
			return false;
		}
	
    	obj.onblur = function()
		{
			blurValidate(obj,min,max);
    	}
    
    	obj.onkeypress = function()
    	{
    		$("applyBtn").disabled = false;
          	isSuccess = false;
		    var evt= EventUtil.getEvent();
        	return digitalCheck(obj, min, max, null, null, evt);    	
    	}
	}
    
    /**
    *      
    */
    function initBtn()
    {
    	document.getElementById("okBtn").value = RESOURCE["okbutton"];
        document.getElementById("cancelBtn").value = RESOURCE["cancelbutton"];
        document.getElementById("applyBtn").value = RESOURCE["applybutton"];
        $("applyBtn").disabled = true;
    }
    
    /**
    *         
    */
    function sendConfirmInfo()
    {
   	    if(isSuccess)
    	{
    	  	window.close();
    	}
    	else
    	{
    	  	sendApplyInfo();
    	  	if(isSuccess)
    	  	{
    	  		window.close();
    	  	}  	
    	}        
    }
/**
 *              
 */
function sendGetAvailableResourceInfo()
{
	var xmlstr = createGetAvailableResourceXML();
	var urlreq = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_WDM_OPPG_GETSOURCE + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, refreshGetAvailableResource, null,
			"inputdata=" + xmlstr);
}
/**
 *             
 */
function createGetAvailableResourceXML()
{
    var obj = getNeProperty(win.self);
    neIdValue = obj["neid"];
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neId");
    param.setAttribute("value", neIdValue);//        ID    ID
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "groupId");
    param.setAttribute("value", win.ALLGROUP);
    row.appendChild(param);
    
    param = new tagElement("param");
	param.setAttribute("name", "AID");
	param.setAttribute("value", "ALL");
	row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}
    /**
    *         
    */
    function sendApplyInfo()
    {
    	if((revertiveModeAtom.getValue() != 255 && wtrTimeAtom.getValue() == UNSUPPORTED)
    	  || workingUnitDelayTimeAtom.getValue() == UNSUPPORTED
    	  || protecionUnitDelayTimeAtom == UNSUPPORTED)
    	{
    		alert(RESOURCE["inputerror"]);
    	    return; 
    	}
    	
    	xmlstr = createModifyPortProtectionXML (); //       
    	if(xmlstr == null)
    	{
    		return;
    	}
        var urlreq ="../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_WDM_OPPG_MODIFY+"&flag=1";
        loadXMLdoc(urlreq, "POST",false,openModifyErrDlg,null,"inputdata="+xmlstr);
    }
    
    /**
    *             
    */
    function createModifyPortProtectionXML()
    {
        var di = new inputxml("datainterface");
        var bussiness = new tagElement("bussiness-params");
        
        var row = new tagElement("row-params");
        var param = new tagElement("param");
        param.setAttribute("name","neId");
        
        var neIdValue = win.neIdValue;
        
        param.setAttribute("value",neIdValue);//        ID    ID
        row.appendChild(param);
        
        
        param = new tagElement("param");
        param.setAttribute("name","protectionType");
        param.setAttribute("value",protectionTypeValue);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name","slotid");
        param.setAttribute("value",win.pathStatusSTable.getCellStoreValue(selectLine,"protectionunit", "pslotId"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name","wslotid");
        param.setAttribute("value",win.pathStatusSTable.getCellStoreValue(selectLine,"workingunit", "wslotId"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name","AID");
        var aid = null;
        if (win.pathStatusSTable.getCellStoreValue(selectLine ,"protectionunitShow", "protectionunitShow") == "otherdevice")
        {
        	param.setAttribute("value",win.pathStatusSTable.getCellStoreValue(selectLine,"WORK", "WORK"));
        }
        else
        {
        	param.setAttribute("value",win.pathStatusSTable.getCellStoreValue(selectLine,"PROTECT", "PROTECT"));
        }
        row.appendChild(param);
	    var dectTimeAtom = ct.getAtom("switchDectTime");
	    if (dectTimeAtom != null && dectTimeAtom.getValue() != "-")
	    {
	    	param = new tagElement("param");
	        param.setAttribute("name", "switchDectTime");
	        param.setAttribute("value", dectTimeAtom.getValue());
	        row.appendChild(param);
	    }
    
        param = new tagElement("param");
        param.setAttribute("name","WORK");
        param.setAttribute("value", win.protectionGroupSTable.getCellStoreValue(selectLine,"WORK", "WORK"));
        row.appendChild(param);
        
        if(win.protectionGroupSTable.getCellStoreValue(selectLine,"DETECT", "DETECT"))
        {
        	param = new tagElement("param");
	        param.setAttribute("name","DETECT");
	        param.setAttribute("value", win.protectionGroupSTable.getCellStoreValue(selectLine,"DETECT", "DETECT"));
	        row.appendChild(param);
        }
  
        if(win.protectionGroupSTable.getCellStoreValue(selectLine,"CRTL", "CRTL"))
        {
        	param = new tagElement("param");
	        param.setAttribute("name","CRTL");
	        param.setAttribute("value", win.protectionGroupSTable.getCellStoreValue(selectLine,"CRTL", "CRTL"));
	        row.appendChild(param);
        }
        
        var tempneCtrl = win.pathStatusSTable.getCellStoreValue(selectLine, "controlunitworkingpathShow", "controlunitworkingpathShow");
        var tempprotectionTypeValue = win.protectionGroupSTable.getCellStoreValue(selectLine,"protectiontype", "protectionType");
        
        if (tempprotectionTypeValue == "CLIENT1+1" && tempneCtrl == "otherdevice")
        {
        }
        else
        {
        	var revertiveModeValue = revertiveModeAtom.getValue();//      
	        if (revertiveModeValue != 255)
	        {
	        	param = new tagElement("param");
	        	param.setAttribute("name","revertiveMode");        
	        	param.setAttribute("value",revertiveModeValue);
	        	row.appendChild(param);
	        	
	        	param = new tagElement("param");
	        	param.setAttribute("name","wtrTime");
	        	var wtrTimeValue = wtrTimeAtom.getValue();//      
	        	if(isNaN(Number(wtrTimeValue)))
	        	{ 
	        		wtrTimeAtom.element.select();
	        		alert(RESOURCE["wrong1"] + MINVALUE + RESOURCE["wrong2"] + MAXVALUE + RESOURCE["wrong3"]);
	        		return null;
	        	}
	        	param.setAttribute("value",wtrTimeValue);
	        	row.appendChild(param);
        	}
        }
        
        param = new tagElement("param");
        param.setAttribute("name","wdelayTime");
        var workingUnitDelayTimeValue = workingUnitDelayTimeAtom.getValue();//          
        if(isNaN(Number(workingUnitDelayTimeValue)))
        { 
        	workingUnitDelayTimeAtom.element.select();
        	alert(RESOURCE["wrong1"] + MINDELAYTIME + RESOURCE["wrong2"] + MAXDELAYTIME + RESOURCE["wrong3"]);
        	return null;
        }
        if(workingUnitDelayTimeAtom.element.disabled!=true)
        {
	        param.setAttribute("value",workingUnitDelayTimeValue);
	        row.appendChild(param);
        }
        param = new tagElement("param");
        param.setAttribute("name","pdelayTime");
        var protecionUnitDelayTimeValue = protecionUnitDelayTimeAtom.getValue();//          
        if(isNaN(Number(protecionUnitDelayTimeValue)))
        { 
        	protecionUnitDelayTimeAtom.element.select();
        	alert(RESOURCE["wrong1"] + MINDELAYTIME + RESOURCE["wrong2"] + MAXDELAYTIME + RESOURCE["wrong3"]);
        	return null;
        }
        
        if(protecionUnitDelayTimeAtom.element.disabled!=true)
        {
        	param.setAttribute("value",protecionUnitDelayTimeValue);
        	row.appendChild(param);
        }
		var wbname =  win.pathStatusSTable.getCellStoreValue(selectLine,"workingunit", "wboardName")
        var protectionType = win.protectionGroupSTable.getCellShow(selectLine,"protectiontype").getValue();
        if(neType==66&&protectionType=="Intra-Board 1+1 Protection"&&wbname=="OLP")
	    {
	    	param = new tagElement("param");
		    param.setAttribute("name","cdelaytime");
		    var crtlUnitDelayTimeValue = ct.getAttrValue("crtlUnitDelayTime");//          
	    	if(isNaN(Number(crtlUnitDelayTimeValue)))
		    { 
		        ct.getAtom("crtlUnitDelayTime").element.select();
		        alert(RESOURCE["wrong1"] + MINDELAYTIME + RESOURCE["wrong2"] + MAXVALUE + RESOURCE["wrong3"]);
		        return null;
		    }
		    param.setAttribute("value",crtlUnitDelayTimeValue);
		    row.appendChild(param);
	    }
	    
	    if(isSupportSwitchTypeAndAPSFlag && (protectionTypeValue == win.protection.BOARDPROTECTION))
	    {
	        var atom = ct.getAtom("switchType");
	        if (!atom.element.disabled) 
	        {
	            var switchType = ct.getAtom("switchType").getValue();
	    	    param = new tagElement("param");
	            param.setAttribute("name", "switchType");
	            param.setAttribute("value", switchType);
	            row.appendChild(param);
				
	            var apsChannel = ct.getAtom("apsChannel").getValue();
	            if (apsChannel != "-") 
	            {
	                param = new tagElement("param");
	                param.setAttribute("name", "apsChannel");
	                param.setAttribute("value", apsChannel);
	                row.appendChild(param);
	            }
	        }
	    }
	    
	if (switchModeAtom)
    {
    	param = new tagElement("param");
        param.setAttribute("name", "switchType");
        param.setAttribute("value", switchModeAtom.getValue());
        row.appendChild(param);
        
    	if (switchModeAtom.getValue() == DUAL_MODE)
    	{    	
    		param = new tagElement("param");
            param.setAttribute("name", "apsslotId");
            param.setAttribute("value", channelBoardAtom.getValue());
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "apsport");
            param.setAttribute("value", channelPortAtom.getValue());
            row.appendChild(param);                      
    	}
    }
	    
        
        if (protectionType != "Optical Line Protection")
        {
	        param = new tagElement("param");
	        param.setAttribute("name","sdEnable");
	        var sdTriggerFlagValue = sdTriggerFlagAtom.getValue();//      
	        param.setAttribute("value",sdTriggerFlagValue);
	        row.appendChild(param);
        }
        
        param = new tagElement("param");
        param.setAttribute("name","MARK");
        var protecionUnitRemarksValue = ct.getAttrValue("remarks");//        
        param.setAttribute("value","\"" + protecionUnitRemarksValue + "\"");
        row.appendChild(param);
        
        bussiness.appendChild(row);
        di.getRoot().appendChild(bussiness);
        return di.toString();
    }
    
    /**
    *            
    */
    function openModifyErrDlg(doc)
    {
    	var data = EncapsulateData(doc);
        showErrorDialog(data);
        if(0 == data.getSErrorCode())
        {
        	isSuccess = true;
        	$("applyBtn").disabled = true;
       	    refresh();
        }
        else
        {
        	isSuccess = false;
        }
    }
    
    /**
    *        
    */
    function showErrorDialog(data)
    {
        var errArr = [];
        errArr[0] = "nename";
        errArr[1] = "groupId";
        openErrPage("../../../../../../page/", data.getError(), errArr);
    }

    function refresh()
    {
    	win.refresh();
    }
    
    /**
      *                  
    */
	function refreshGetAvailableResource(doc)
	{
	    var dinterface = EncapsulateData(doc);
	    showErrorDialog(dinterface);
	    var wslotId = win.pathStatusSTable.getCellStoreValue(selectLineDown, "workingunit", "wslotId");
	    var	groupShelfId = getSubrackIDFromSlot(wslotId);
	    if (0 == dinterface.getSErrorCode()) 
	    {
	        for (var i = 0, len1 = dinterface.getDataRowLength(); i < len1; i++) 
	        {
	            var usableBd = null;//        
	            var obj = dinterface.rows[i];
	            
	            var boardType = obj.boardType.value;
	            var shelfId = obj.shelfId.value;
	            if ((boardType != BDTYPE_TN12SC1 && boardType != BDTYPE_TN12SC2)
	            		|| shelfId != groupShelfId)
	            {
	            	continue;
	            }
	            var portName = obj.portName.value;
	            var portNameOptions = obj.portName.options;
	            
	            var portList = [];
	            portList.push(portName);
	            if (portNameOptions != null) //       
	            {
	            	for (var j = 0, size = portNameOptions.length; j < size; j++)
	                {
	                	portList.push(portNameOptions[j]);
	                }
	            }
	            
	            usableBd = new TEUsableBoard();
	            usableBd.neId = obj.neId.value;
	            usableBd.neName = obj.neName.value;
	            usableBd.shelfName = obj.subrackName.value;
	            usableBd.slotId = obj.slotId.value;
	            usableBd.key = obj.slotId.value;
	            usableBd.boardType = obj.boardType.value;
	            usableBd.boardName = obj.boardName.value;
	            usableBd.linkSlot = obj.linkSlot.value;
	            usableBd.linkPort = obj.linkPort.value;
	            usableBd.portArr = portList;
	            
	            usableBoardArr.push(usableBd);
	        }
	        sortResource();
	    }
	}

	/*       */
	function sortResource()
	{
	    var temp;
	    for (var i = 0, len1 = usableBoardArr.length - 1; i < len1; i++) 
	    {
	        for (var j = i + 1, len2 = usableBoardArr.length; j < len2; j++) 
	        {
	            if (parseInt(usableBoardArr[i].slotId) > parseInt(usableBoardArr[j].slotId)) 
	            {
	                temp = usableBoardArr[j];
	                usableBoardArr[j] = usableBoardArr[i];
	                usableBoardArr[i] = temp;
	            }
	        }
	    }
	}
	
	/**
 *              
 */
function TEUsableBoard()
{
    this.key = null;
    this.neId = null;
    this.neName = null;
    this.protectionType = null;
    this.shelfName = null;
    this.slotId = null;
    this.boardType = null;
    this.boardName = null;
    this.linkSlot = null;
    this.linkPort = null;
    this.portName = null;//     
    this.portArr = null;//           
}

TEUsableBoard.prototype.toString = function()
{
    var resultStr = this.slotId + "-" + this.boardName;
    if (this.shelfName != null && this.shelfName != "") 
    {
        resultStr = this.shelfName + "-" + getSlotIDFromSlot(this.slotId) + "-" + this.boardName;
    }
    return resultStr;
}
