	
loadXMLdoc("../../../../../../conf/system.xml", "GET", false,EncapsulateSConf);
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../../../res/commonres_"+ SYSTEMCONF.getLanguage() +".xml"); 

var TECMDCODE_QUERY_INPUTALARMTHRDRANGE = 201005251;

var cfpiopBdTypes = new Array(2313, 2308, 2576, 2836, 2875);
var boardType = getNeProperty(self)["boardType"];
var BOARD_TYPE_RAU1 = 2318;
var BDTYPE_TNF1LEM18 = 2272;
var BDTYPE_TN11TBE_TL1 = 60031;
var	BDTYPE_TN11L4G_TL1 = 60010;
var MIN_INPUT = '-60.0';
var MAX_INPUT = '50.0';
loadXMLdoc("../../../../conf/board_attribute/config/opticalpower_u2000v1r6c00/opticalpowertable_"+ SYSTEMCONF.getLanguage() +".xml", "GET", false, EncapsulateTable);

var oopBdTypes = [2281,2309,2317,2296,1537,1381,1152,1573,2279,2280];

var inputalmtharr = [];

function popupMenuHandler(evt)
{
	if(!evt){
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null&&elem.blur)
    {
    	elem.blur();	  	
    }
   
   while(elem!=null)
	 {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   } 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		  return;
	}  
	
	var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    
    var colid = elem.colid;
    if (rows.length > 1)
    {
    	return;
    }
    if(rows.contains(rowid))
    {   
    	for(var i = 0; i < rows.length; i++)
    	{
    		var tmpElem = elem.parent.getCell(rows[i],colid);
    		if(null != tmpElem.element.editElement && tmpElem.element.isEdit == 1)
    		{
    			 createClearPopupMenu(tmpElem,evt); 
    			 return;
    		}
    	}	
    }    
}

function createClearPopupMenu(tmpElem,evt)
{
     createjsDOMenu(tmpElem);
     showMenu(evt); 	
}

function createjsDOMenu(tmpElem)
{	
	  removejsDOMmenu();
	  var isSelected = false;
	
    var cursorMenu = new jsDOMenu(200); //   140
    
    if (tmpElem.colid == "DWDMTL1_ATTROPTPWR_EXPOPR") 
    {
    	 cursorMenu.addMenuItem(new menuItem(RESOURCE["copyinputpower"], "",copyInputOperation, tmpElem, true));
    	 isSelected  = true;   
    }
    if (tmpElem.colid == "DWDMTL1_ATTROPTPWR_EXPOPT")
    {
    	 cursorMenu.addMenuItem(new menuItem(RESOURCE["copyoutputpower"], "",copyOutputOperation, tmpElem, true)); 
    	 isSelected  = true;  
    }
    if (tmpElem.colid != "DWDMTL1_ATTROPTPWR_INPUTDOWNTH" && tmpElem.colid != "DWDMTL1_ATTROPTPWR_INPUTUPTH")
    {
       cursorMenu.addMenuItem(new menuItem(RESOURCE["clearopticalpower"], "",sendClearOperation, tmpElem, true));
       isSelected  = true; 
    }
    if (isSelected)
    {
	    setPopUpMenu(cursorMenu);
    }
    
    
}

function sendClearOperation(tmpElem)
{
	tmpElem.element.showElement.setValue("/");
    tmpElem.element.style.backgroundColor="#d0f946";
    tmpElem.element.modify = true;
    tmpElem.element.parentNode.modify = true;
	st.setCellValue(tmpElem,tmpElem.colid,"/");
	tmpElem.element.showElement.element.style.display	=	"";
	handleCellEdit(tmpElem.element,TABLE_CONSTANT.AFTEREDIT); 
}

function copyInputOperation(tmpElem)
{
	var selectRow = st.getSelectedRows()[0];
	var inputvalue = st.getCellStoreValue(selectRow,"DWDMTL1_ATTROPTPWR_INPWR","DWDMTL1_ATTROPTPWR_INPWR");
	if (inputvalue == "/" || inputvalue == "-")
	{
		removejsDOMmenu();
		alert(RESOURCE["copypowerinvalid"]);
		return;
	}	
	tmpElem.element.showElement.setValue(inputvalue);
    tmpElem.element.style.backgroundColor="#d0f946";
    tmpElem.element.modify = true;
    tmpElem.element.parentNode.modify = true;
	st.setCellValue(tmpElem,tmpElem.colid,inputvalue);
	tmpElem.element.showElement.element.style.display	=	"";
	handleCellEdit(tmpElem.element,TABLE_CONSTANT.AFTEREDIT); 
}

function copyOutputOperation(tmpElem)
{
	var selectRow = st.getSelectedRows()[0];
	var outputvalue = st.getCellStoreValue(selectRow,"DWDMTL1_ATTROPTPWR_OUTPWR","DWDMTL1_ATTROPTPWR_OUTPWR");
	if (outputvalue == "/" || outputvalue == "-")
	{
		removejsDOMmenu();
		alert(RESOURCE["copypowerinvalid"]);
		return;
	}	
	tmpElem.element.showElement.setValue(outputvalue);
    tmpElem.element.style.backgroundColor="#d0f946";
    tmpElem.element.modify = true;
    tmpElem.element.parentNode.modify = true;
	st.setCellValue(tmpElem,tmpElem.colid,outputvalue);
	tmpElem.element.showElement.element.style.display	=	"";
	handleCellEdit(tmpElem.element,TABLE_CONSTANT.AFTEREDIT); 
}
function initBody()
{
	initTable();		
	query();
    st.setOnCellEditHandler(cellEditHandler);
	$("applybtn").disabled = true;
	 document.getElementById("tablecomponent").firstChild.childNodes[1].oncontextmenu = popupMenuHandler;
}
function query()
{
	queryinputalmthrange();
	
	var winurlobj = new Object();
	winurlobj = getNeProperty(self);
	$("querybtn").disabled = true;
	var neid = winurlobj["neid"];
    var slotid = winurlobj["slotid"];
    var urlStr = decodeURI(self.location.search);
	var xmlstr = createQuerySupportAttrXML(neid,slotid);
    urlreq ="../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_QUERY_POWER_FROM_NE;
    loadXMLdoc(urlreq, "POST",true,callQueryBack,[gencfg,urlStr],"inputdata="+xmlstr);
    winurlobj = null;
}

/**
 *   OTU                           
 *                         js        
 */
function queryinputalmthrange()
{
	var winurlobj = new Object();
	winurlobj = getNeProperty(self);
	$("querybtn").disabled = true;
	var neid = winurlobj["neid"];
    var slotid = winurlobj["slotid"];
    var urlStr = decodeURI(self.location.search);
	var xmlstr = createQueryXML(neid,slotid);
    urlreq ="../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_QUERY_INPUTALARMTHRDRANGE;
    loadXMLdoc(urlreq, "POST",false ,callalmthQueryBack,null,"inputdata="+xmlstr);
    winurlobj = null;
}

/**
 *               xml
 */
function createQueryXML(neid,slotid)
{
	var di = new inputxml("datainterface");	
	var bussiness = new tagElement("bussiness-params");
	var rowparam = new tagElement("row-params");
	
	var param = new tagElement("param");
	param.setAttribute("name","neid");
	param.setAttribute("value",neid);
	rowparam.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name","slotid");
	param.setAttribute("value",slotid);		
	rowparam.appendChild(param);
	
	bussiness.appendChild(rowparam);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *                              
 */
function callalmthQueryBack(doc)
{
	inputalmtharr = [];
	var data = EncapsulateData(doc);
	var winurlobj = getNeProperty(self);
	var datalen = data.getDataRowLength();
    var upthmax;
    var upthmin;
    var downthmax;
    var downthmin;
    
    var cfpupthmax;
    var cfpupthmin;
    var cfpdownthmax;
    var cfpdownthmin;
    
	for (var i = 0; i < datalen; i++)
	{	
		var almthinput = new AlmInputTH();
		almthinput.aid = data.getDataRowParam(i, "AID");
		
		upthmax = data.getDataRowParam(i, "UPTHMaxValue");
		upthmin = data.getDataRowParam(i, "UPTHMinValue");
		if (upthmax != null && upthmin != null)
		{		
			almthinput.upthvalueedit = true;
			almthinput.upthmaxvalue = upthmax;
			almthinput.upthminvalue = upthmin;
		}
		else
		{
			almthinput.upthvalueedit = false;
			almthinput.upthmaxvalue = "-";
			almthinput.upthminvalue = "-";
		}
						
		downthmax = data.getDataRowParam(i, "DOWNTHMaxValue");
		downthmin = data.getDataRowParam(i, "DOWNTHMinValue");
		if (downthmax != null && downthmin != null)
		{		
			almthinput.downthvalueedit = true;
			almthinput.downthmaxvalue = downthmax;		
			almthinput.downthminvalue = downthmin;
		}
		else
		{
			almthinput.downthvalueedit = false;
			almthinput.downthmaxvalue = "-";		
			almthinput.downthminvalue = "-";
		}
		cfpupthmax = data.getDataRowParam(i, "CFPUPTHMaxValue");
		cfpupthmin = data.getDataRowParam(i, "CFPUPTHMinValue");
		if (cfpupthmax != null && cfpupthmin != null)
		{		
			almthinput.cfpupthvalueedit = true;
			almthinput.cfpupthmaxvalue = cfpupthmax;
			almthinput.cfpupthminvalue = cfpupthmin;
		}
		else
		{
			almthinput.cfpupthvalueedit = false;
			almthinput.cfpupthmaxvalue = "/";
			almthinput.cfpupthminvalue = "/";
		}
						
		cfpdownthmax = data.getDataRowParam(i, "CFPDOWNTHMaxValue");
		cfpdownthmin = data.getDataRowParam(i, "CFPDOWNTHMinValue");
		if (cfpdownthmax != null && cfpdownthmin != null)
		{	
			almthinput.cfpdownthvalueedit = true;
			almthinput.cfpdownthmaxvalue = cfpdownthmax;		
			almthinput.cfpdownthminvalue = cfpdownthmin;
		}
		else
		{
			almthinput.cfpdownthvalueedit = false;
			almthinput.cfpdownthmaxvalue = "/";		
			almthinput.cfpdownthminvalue = "/";
		}
		inputalmtharr[i] = almthinput;		
	}
}


function initTable()
{
	st = new SortTable();
    st.setImage("../../../../../../images/");
    var nepara = getNeProperty(self);
    if(!isNewNEVersion(nepara))//  8800A     testmode
    {	   	
    	window.tableconf[0].colArray[10].width = "0%";
    	window.tableconf[0].colArray[11].width = "0%";
    	window.tableconf[0].colArray[12].width = "0%";
    	window.tableconf[0].colArray[19].width = "0%";
    	window.tableconf[0].colArray[20].width = "0%";
    	window.tableconf[0].colArray[21].width = "0%";
    }
    $("querybtn").value=RESOURCE["querybutton"];
    if (cfpiopBdTypes.contains(boardType))
    {
    	tc = window.tableconf[0];
    }
    else
    {
    	tc = window.tableconf[1];
    	if (oopBdTypes.contains(boardType)) //             
    	{
    		tc.colArray[21].cell.isEdit = 1;
    		tc.colArray[22].cell.isEdit = 1;
    	}
    }
    createTableHead(st, tc);
    st.setBodyHeight(getComponetHeight($("tablecomponent"),100)+"px");
    st.setBodyWidth(tc.width,tc.percent,0);
    
    $("tablecomponent").appendChild(st.getTable());    
}

function isNewNEVersion(nepara)
{
	if(nepara["neType"] == "70")
	{
		if(compare(nepara["neversion"],"5.51.06.10") >= 0&&compare(nepara["neversion"],"5.51.99.99")<0)
		{
			return true;
		}
		else if(compare(nepara["neversion"],"5.70.01.19") >= 0)
		{
			return true
		}
		else 
		{
			return false;	
		}
	}
	else if (nepara["neType"] == 71)
	{
		if(compare(nepara["neversion"],"5.51.06.10") >= 0&&compare(nepara["neversion"],"5.51.99.99")<0)
		{
			return true;
		}
		else if(compare(nepara["neversion"],"5.71.01.19") >= 0)
		{
			return true
		}
		else 
		{
			return false;	
		}
	}
	return true;
}


function callQueryBack(doc)
{
	var data = EncapsulateData(doc);
	var winurlobj = getNeProperty(self);
	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+winurlobj["neid"],false);
	st.clearTableData();	
	createTableBody(st, tc, data, RESOURCE);
	addListener();
	if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(data);
    }
	$("querybtn").disabled = false;
	
}
function addListener()
{
	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{
		var inputExportUpth = st.getCell(i,"DWDMTL1_ATTROPTPWR_EXPOPR_UPTH");	
		var inputExportUpthShow = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_EXPOPR_UPTH","DWDMTL1_ATTROPTPWR_EXPOPR_UPTH");	
		if(inputExportUpthShow=="-")
		{
			
			st.setCellIsEdit(inputExportUpth,0);
			inputExportUpth.element.ondblclick = null;
			inputExportUpth.element.modify =false;
	  	    inputExportUpth.element.parentNode.modify = false;
		}
		else
		{
			var inputExportEdit = st.getCellEdit(i,"DWDMTL1_ATTROPTPWR_EXPOPR_UPTH");
			textCheck(inputExportEdit.element,"-60.0","60.0");

		}
		
		var inputExportDownth = st.getCell(i,"DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH");	
		var inputExportDownthShow = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_EXPOPR_DOWN","DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH");	
		if(inputExportUpthShow=="-")
		{
			
			st.setCellIsEdit(inputExportDownth,0);
			inputExportDownth.element.ondblclick = null;
			inputExportDownth.element.modify =false;
	  	    inputExportDownth.element.parentNode.modify = false;
		}
		else
		{
			textCheck(inputExportDownth.element.editElement.element,"-60.0","60.0");
		}
		
		
		var outputExportUpth = st.getCell(i,"DWDMTL1_ATTROPTPWR_EXPOPT_UPTH");	
		var outputExportUpthShow = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_EXPOPT_UPTH","DWDMTL1_ATTROPTPWR_EXPOPT_UPTH");	
		if(outputExportUpthShow=="-")
		{
			
			st.setCellIsEdit(outputExportUpth,0);
			outputExportUpth.element.ondblclick = null;
			outputExportUpth.element.modify =false;
	  	    outputExportUpth.element.parentNode.modify = false;
		}	
		else
		{
			textCheck(outputExportUpth.element.editElement.element,"-60.0","60.0");
		}	
			
		var outputExportDownth = st.getCell(i,"DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH");	
		var outputExportDownthShow = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH","DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH");	
		if(outputExportDownthShow=="-")
		{
			
			st.setCellIsEdit(outputExportDownth,0);
			outputExportDownth.element.ondblclick = null;
			outputExportDownth.element.modify =false;
	  	    outputExportDownth.element.parentNode.modify = false;
		}		
		else
		{
			textCheck(outputExportDownth.element.editElement.element,"-60.0","60.0");
		}	
			
		var outputExpopt = st.getCell(i,"DWDMTL1_ATTROPTPWR_EXPOPT");	
		var outputExpoptShow = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_EXPOPT","DWDMTL1_ATTROPTPWR_EXPOPT");	
		if(outputExpoptShow=="-")
		{
			
			st.setCellIsEdit(outputExpopt,0);
			outputExpopt.element.ondblclick = null;
			outputExpopt.element.modify =false;
	  	    outputExpopt.element.parentNode.modify = false;
		}	
		else
		{
			outputExpopt.element.modify = false;
			st.setCellIsEdit(outputExpopt,"1");
			outputExpopt.element.ondblclick = cellondbclick;
		}
						
		var outputExpopr = st.getCell(i,"DWDMTL1_ATTROPTPWR_EXPOPR");	
		var outputExpoprShow = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_EXPOPR","DWDMTL1_ATTROPTPWR_EXPOPR");	
		if(outputExpoprShow=="-")
		{
			
			st.setCellIsEdit(outputExpopr,0);
			outputExpopr.element.ondblclick = null;
			outputExpopr.element.modify =false;
	  	    outputExpopr.element.parentNode.modify = false;
		}	
		else
		{
			outputExpopr.element.modify = false;
			st.setCellIsEdit(outputExpopr,"1");
			outputExpopr.element.ondblclick = cellondbclick;
		}	
		var outputDownTH = st.getCell(i,"DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH");	
		var outputDownTHShow = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH","DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH");	
		var portname = st.getCellStoreValue(i,"portPath","portname");
		if(outputDownTHShow == "-" || portname.indexOf("IN") != -1 
			|| BDTYPE_TN11TBE_TL1 == boardType || BDTYPE_TN11L4G_TL1 == boardType) // IN/OUT                        
		{
			st.setCellIsEdit(outputDownTH,0);
			outputDownTH.element.ondblclick = null;
			outputDownTH.element.modify =false;
			outputDownTH.element.parentNode.modify = false;
		}	
		else if (BDTYPE_TNF1LEM18 != boardType)
		{
			outputDownTH.element.modify = false;
			st.setCellIsEdit(outputDownTH,"1");
			textCheck(outputDownTH.element.editElement.element,"-60.0","60.0");
		}
		var outputUpTH = st.getCell(i,"DWDMTL1_ATTROPTPWR_OUTPUTUPTH");	
		var outputUpTHShow = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_OUTPUTUPTH","DWDMTL1_ATTROPTPWR_OUTPUTUPTH");	
		if(outputUpTHShow == "-" || portname.indexOf("IN") != -1
			|| BDTYPE_TN11TBE_TL1 == boardType || BDTYPE_TN11L4G_TL1 == boardType)
		{
			st.setCellIsEdit(outputUpTH,0);
			outputUpTH.element.ondblclick = null;
			outputUpTH.element.modify =false;
			outputUpTH.element.parentNode.modify = false;
		}	
		else if (BDTYPE_TNF1LEM18 != boardType)
		{
			outputUpTH.element.modify = false;
			st.setCellIsEdit(outputUpTH,"1");
			textCheck(outputUpTH.element.editElement.element,"-60.0","60.0");
		}
		if (cfpiopBdTypes.contains(boardType))
		{
			var aid = st.getCellStoreValue(i, "AID", "AID");
			var supportFlag = false;
			for (var j = 0, size = inputalmtharr.length; j < size; j++)
			{
				if (aid == inputalmtharr[j].aid)
				{
					st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPMININPUTDOWNTH").element.showElement.setValue(inputalmtharr[j].cfpdownthminvalue);
					st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPMAXINPUTDOWNTH").element.showElement.setValue(inputalmtharr[j].cfpdownthmaxvalue);
					st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPMININPUTUPTH").element.showElement.setValue(inputalmtharr[j].cfpupthminvalue);
					st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPMAXINPUTUPTH").element.showElement.setValue(inputalmtharr[j].cfpupthmaxvalue);
					supportFlag = true;
					break;
				}
			}
			if (!supportFlag)
			{
				var cfpinputUpth = st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH");	
				var cfpinputDownth = st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPINPUTUPTH");
				st.setCellIsEdit(cfpinputUpth,0);
				cfpinputUpth.element.modify = false;
				cfpinputUpth.element.ondblclick = null;
				
				st.setCellIsEdit(cfpinputDownth,0);
				cfpinputDownth.element.modify = false;
				cfpinputDownth.element.ondblclick = null;
				st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPMININPUTDOWNTH").element.showElement.setValue("-");
				st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPMAXINPUTDOWNTH").element.showElement.setValue("-");
				st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPMININPUTUPTH").element.showElement.setValue("-");
				st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPMAXINPUTUPTH").element.showElement.setValue("-");
			}
		}
	}
	
	addinputalmthHandler();
}
function addinputalmthHandler()
{
	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{
		var aid = st.getCellStoreValue(i,"AID","AID");	
		var inputUpth = st.getCell(i,"DWDMTL1_ATTROPTPWR_INPUTUPTH");	
		var inputDownth = st.getCell(i,"DWDMTL1_ATTROPTPWR_INPUTDOWNTH");
		if (inputUpth == null || inputDownth == null)
		{	
			continue;
		}
		if (BOARD_TYPE_RAU1 == boardType || 2878 == boardType)
		{
			var inUpThValue = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_INPUTUPTH","DWDMTL1_ATTROPTPWR_INPUTUPTH");
			var inDownThValue = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_INPUTDOWNTH","DWDMTL1_ATTROPTPWR_INPUTDOWNTH");
			if (inUpThValue != "-")
			{
				inputUpth.element.modify = false;
		        st.setCellIsEdit(inputUpth,"1");
		        inputUpth.element.ondblclick = cellondbclick;
		        textCheck(inputUpth.element.editElement.element, "-60.0", "50.0");
			}
			if (inDownThValue != "-")
			{
				inputDownth.element.modify = false;
		        st.setCellIsEdit(inputDownth,"1");
		        inputDownth.element.ondblclick = cellondbclick;		
		        textCheck(inputDownth.element.editElement.element, "-60.0", "50.0");
			}
			continue;
		}
		
		if (BDTYPE_TNF1LEM18 == boardType)
		{
			var portID = st.getCellStoreValue(i, 'port', 'port');
			var inUpThValue = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_INPUTUPTH","DWDMTL1_ATTROPTPWR_INPUTUPTH");
			var inDownThValue = st.getCellStoreValue(i,"DWDMTL1_ATTROPTPWR_INPUTDOWNTH","DWDMTL1_ATTROPTPWR_INPUTDOWNTH");
			if (portID == 3 || portID == 4)
			{
				st.setCellIsEdit(inputUpth,"0");
				st.setCellIsEdit(inputDownth,"0");
			}
			else
			{
				st.setCellIsEdit(inputUpth,"1");
				st.setCellIsEdit(inputDownth,"1");
			}
		}
		var inputalmth;
		for (var j=0,size = inputalmtharr.length;j<size;j++)
		{
			inputalmth = inputalmtharr[j];
			if (aid == inputalmth.aid)
			{
				if (inputalmth.upthvalueedit && !cfpiopBdTypes.contains(boardType))
				{
					inputUpth.element.modify = false;
			        st.setCellIsEdit(inputUpth,"1");
					st.getCell(i,"DWDMTL1_ATTROPTPWR_OPR_UPRANGEL").element.showElement.setValue(inputalmth.upthminvalue);
					st.getCell(i,"DWDMTL1_ATTROPTPWR_OPR_UPRANGEH").element.showElement.setValue(inputalmth.upthmaxvalue);
				}
				else
				{
					st.getCell(i,"DWDMTL1_ATTROPTPWR_OPR_UPRANGEL").element.showElement.setValue("-");
					st.getCell(i,"DWDMTL1_ATTROPTPWR_OPR_UPRANGEH").element.showElement.setValue("-");
					st.setCellIsEdit(inputUpth,0);
					inputUpth.element.modify = false;
			        inputUpth.element.ondblclick = null;
				}
				
				if (inputalmth.downthvalueedit && !cfpiopBdTypes.contains(boardType))
				{
					inputDownth.element.modify = false;
			        st.setCellIsEdit(inputDownth,"1");
			        st.getCell(i,"DWDMTL1_ATTROPTPWR_OPR_DNRANGEL").element.showElement.setValue(inputalmth.downthminvalue);
					st.getCell(i,"DWDMTL1_ATTROPTPWR_OPR_DNRANGEH").element.showElement.setValue(inputalmth.downthmaxvalue);
				}
				else
				{
					st.getCell(i,"DWDMTL1_ATTROPTPWR_OPR_UPRANGEL").element.showElement.setValue("-");
					st.getCell(i,"DWDMTL1_ATTROPTPWR_OPR_UPRANGEH").element.showElement.setValue("-");
					st.setCellIsEdit(inputDownth,0);
					inputDownth.element.modify = false;
			        inputDownth.element.ondblclick = null;
				}
				if (cfpiopBdTypes.contains(boardType))
				{
					var cfpinputUpth = st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPINPUTUPTH");	
					var cfpinputDownth = st.getCell(i,"DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH");
					if (inputalmth.cfpupthvalueedit)
					{
						cfpinputUpth.element.modify = false;
				        st.setCellIsEdit(cfpinputUpth,"1");
				        cfpinputUpth.element.ondblclick = cellondbclick;		
					}
					else
					{
						st.setCellIsEdit(cfpinputUpth,0);
						cfpinputUpth.element.modify = false;
						cfpinputUpth.element.ondblclick = null;
					}
					
					if (inputalmth.cfpdownthvalueedit)
					{
						cfpinputDownth.element.modify = false;
				        st.setCellIsEdit(cfpinputDownth,"1");
				        cfpinputDownth.element.ondblclick = cellondbclick;			       
					}
					else
					{
						st.setCellIsEdit(cfpinputDownth,0);
						cfpinputDownth.element.modify = false;
						cfpinputDownth.element.ondblclick = null;	
					}
				}
			}
		}
	}
}

function cellEditHandler(param)
{
	var winurlobj = new Object();
	var st = param.st;
	var rowindex = param.rowindex;
	if (param.colid == "DWDMTL1_ATTROPTPWR_EXPOPR")
	{
		var tempValue = st.getAtomValue(st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR"));
		var expoprEdit = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR");
		expoprEdit.element.onpaste = function()
		{
			return false;
		}
		expoprEdit.element.onblur = function ()
		{
			numCellOnBlur(expoprEdit.element,"-60.0","60.0");
			var value = st.getAtomValue(st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR"));
			var upValue = st.getCellStoreValue(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR_UPTH","DWDMTL1_ATTROPTPWR_EXPOPR_UPTH");
			var downValue =st.getCellStoreValue(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH","DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH"); 
			if((value!="/"&&value!="-"||value!="/")&&(upValue=="/"&&downValue=="/"))
			{
				value = parseFloat(value);
				var downCell = st.getCellShow(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH");
				var upCell = st.getCellShow(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR_UPTH");
		        st.setAtomValue(st.getCellShow(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH"), getAlmValue(value,"down"));
	       		st.setCellValue(st.getCell(rowindex, "DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH"), "DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH",getAlmValue(value,"down"));
				st.setAtomValue(st.getCellShow(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR_UPTH"), getAlmValue(value,"up"));
	       		st.setCellValue(st.getCell(rowindex, "DWDMTL1_ATTROPTPWR_EXPOPR_UPTH"), "DWDMTL1_ATTROPTPWR_EXPOPR_UPTH",getAlmValue(value,"up"));
				var downCellEdit = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH");
				downCellEdit.element.modify = true;
				st.setCellIsEdit(downCellEdit,"1");
				downCell.element.parentElement.style.backgroundColor = "#d0f946";
				
				var upCellEdit = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPR_UPTH");
				upCellEdit.element.modify = true;
				st.setCellIsEdit(upCellEdit,"1");
				upCell.element.parentElement.style.backgroundColor = "#d0f946";
				
			}
		}
		expoprEdit.element.onkeypress = function()
	    {
		    var evt= EventUtil.getEvent();
	        return digitalCheck(expoprEdit.element, "-60.0", "60.0", null, null, evt);    	
	    }
	}
	
	if (param.colid == "DWDMTL1_ATTROPTPWR_EXPOPT")
	{
		var tempValue = st.getAtomValue(st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT"));
		var expoptEdit = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT");
		expoptEdit.element.onpaste = function()
		{
			return false;
		}
		expoptEdit.element.onblur = function ()
		{
			numCellOnBlur(expoptEdit.element,"-60.0","60.0");
			var value = st.getAtomValue(st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT"));
			var upValue = st.getCellStoreValue(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT_UPTH","DWDMTL1_ATTROPTPWR_EXPOPT_UPTH");
			var downValue = st.getCellStoreValue(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH","DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH");
			if((value!="/"&&value!="-"||value!="")&&(upValue=="/"&&downValue=="/"))
			{
				value = parseFloat(value);
				var downCell = st.getCellShow(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH");
				var upCell = st.getCellShow(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT_UPTH");
		        st.setAtomValue(st.getCellShow(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH"), getAlmValue(value,"down"));
	       		st.setCellValue(st.getCell(rowindex, "DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH"), "DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH",getAlmValue(value,"down"));
				st.setAtomValue(st.getCellShow(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT_UPTH"), getAlmValue(value,"up"));
	       		st.setCellValue(st.getCell(rowindex, "DWDMTL1_ATTROPTPWR_EXPOPT_UPTH"), "DWDMTL1_ATTROPTPWR_EXPOPT_UPTH",getAlmValue(value,"up"));
				var downCellEdit = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH");
				downCellEdit.element.modify = true;
				st.setCellIsEdit(downCellEdit,"1");
				downCell.element.parentElement.style.backgroundColor = "#d0f946";
				
				var upCellEdit = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_EXPOPT_UPTH");
				upCellEdit.element.modify = true;
				st.setCellIsEdit(upCellEdit,"1");
				upCell.element.parentElement.style.backgroundColor = "#d0f946";
				
			}
		}
		expoptEdit.element.onkeypress = function()
	    {
		    var evt= EventUtil.getEvent();
	        return digitalCheck(expoptEdit.element, "-60.0", "60.0", null, null, evt);    	
	    }
	}
	
	if (param.colid == "DWDMTL1_ATTROPTPWR_INPUTUPTH")
	{
		var aid = st.getCellStoreValue(rowindex,"AID","AID");
		var inputUpth = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_INPUTUPTH");	
		for (var j=0,size = inputalmtharr.length;j<size;j++)
		{
			inputalmth = inputalmtharr[j];
			if (aid == inputalmth.aid)
			{
				if (inputalmth.upthvalueedit)
				{		
					if (inputalmth.upthminvalue == "/")
			        {
			        	textCheck(inputUpth.element,"-60.0", "50.0");
			        }
			        else
			        {
			        	textCheck(inputUpth.element,inputalmth.upthminvalue,inputalmth.upthmaxvalue);
			        }
				}			
			}
		}
	}
	if (param.colid == "DWDMTL1_ATTROPTPWR_INPUTDOWNTH")
	{
		var aid = st.getCellStoreValue(rowindex,"AID","AID");
		var inputDownth = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_INPUTDOWNTH");
		for (var j=0,size = inputalmtharr.length;j<size;j++)
		{
			inputalmth = inputalmtharr[j];
			if (aid == inputalmth.aid)
			{	
				if (inputalmth.downthvalueedit)
				{		
					if (inputalmth.upthvalueedit)
					{		
						if (inputalmth.upthminvalue == "/")
				        {
				        	textCheck(inputDownth.element,"-60.0", "50.0");
				        }
				        else
				        {
				        	textCheck(inputDownth.element,inputalmth.downthminvalue,inputalmth.downthmaxvalue);
				        }
					}
				}				
			}
		}
	}
	if (param.colid == "DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH")
	{
		var aid = st.getCellStoreValue(rowindex,"AID","AID");
		var inputDownth = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH");
		for (var j=0,size = inputalmtharr.length;j<size;j++)
		{
			inputalmth = inputalmtharr[j];
			if (aid == inputalmth.aid)
			{								
				if (inputalmth.cfpdownthvalueedit)
				{				
					if (inputalmth.cfpdownthminvalue == "/")
			        {
			        	textCheck(inputDownth.element,"-60.0", "50.0");
			        }
					else
					{
						textCheck(inputDownth.element,inputalmth.cfpdownthminvalue,inputalmth.cfpdownthmaxvalue);
					}
				}				
			}
		}
	}
	if (param.colid == "DWDMTL1_ATTROPTPWR_CFPINPUTUPTH")
	{
		var aid = st.getCellStoreValue(rowindex,"AID","AID");
		var inputUpth = st.getCellEdit(rowindex,"DWDMTL1_ATTROPTPWR_CFPINPUTUPTH");
		for (var j=0,size = inputalmtharr.length;j<size;j++)
		{
			inputalmth = inputalmtharr[j];
			if (aid == inputalmth.aid)
			{								
				if (inputalmth.cfpupthvalueedit)
				{		
					if (inputalmth.cfpupthminvalue == "/")
			        {
			        	textCheck(inputUpth.element,"-60.0", "50.0");
			        }
					else
					{
						textCheck(inputUpth.element,inputalmth.cfpupthminvalue,inputalmth.cfpupthmaxvalue);
					}
				}			
			}
		}
	}
	winurlobj = getNeProperty(self);
	$("applybtn").disabled = false;
	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+winurlobj["neid"],true);
}
function getAlmValue(value , almType)
{
	if(almType=="up")
	{
		if(value+3.0<60)
		{
			value = value+3.0;
		}
		else 
		{
			value=60.0;
		}
	}
	if(almType=="down")
	{
		if(value-5>-60)
		{
			value = value-5.0;
		}
		else 
		{
			value=-60.0;
		}
	}
	var temp = value.toString();
	if(temp.indexOf(".") == -1)
	{
		temp = temp+".0";
	}
	return temp;
}
function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "boardname";
    errArr[1] = "portname";
    openErrPage("../../../../../../page/", data.getError(), errArr); 
}

function set()
{
	var winurlobj = new Object();
	winurlobj = getNeProperty(self);
	var xml = getSetXml();
	if (xml == null)
    {
        return;
    }
    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + TE_GET_OPTIX_POWER + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", true, callSetBack, null, "inputdata=" + xml);
}
function getSetXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{
	    if(!st.getModify(i))
        {
            continue;
    	}
    	var winurlobj = new Object();
		winurlobj = getNeProperty(self);
    	var row = new tagElement("row-params");
	    var param = new tagElement("param");
	    param.setAttribute("name","neid");
		param.setAttribute("value",winurlobj["neid"]); 
		row.appendChild(param);	
	    var param = new tagElement("param");
	    param.setAttribute("name","slotid");
		param.setAttribute("value",winurlobj["slotid"]); 
		row.appendChild(param);	
		
        var AID = st.getCellStoreValue(i, "AID", "AID");
        var param = new tagElement("param");
        param.setAttribute("name", "AID");
        param.setAttribute("value", AID);
        row.appendChild(param);
        
        var mod2 = st.getCellStoreValue(i, "mod2", "mod2");
        var param = new tagElement("param");
        param.setAttribute("name", "mod2");
        param.setAttribute("value", mod2);
        row.appendChild(param);
        if(st.getCellModify(i,"DWDMTL1_ATTROPTPWR_EXPOPR"))
        {
        	var inputExpopr = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPR", "DWDMTL1_ATTROPTPWR_EXPOPR");
	        inputExpopr = (inputExpopr == "/") ? "INVALID" : inputExpopr;		
	        var param = new tagElement("param");
	        param.setAttribute("name", "inputExpopr");
	        param.setAttribute("value", inputExpopr);
	        row.appendChild(param);	
	        
	        var inputExportUpth = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPR_UPTH", "DWDMTL1_ATTROPTPWR_EXPOPR_UPTH");
	        inputExportUpth = (inputExportUpth == "/") ? "INVALID" : inputExportUpth;
	        var param = new tagElement("param");
	        param.setAttribute("name", "inputExportUpth");
	        param.setAttribute("value", inputExportUpth);
	        row.appendChild(param);	

        	var inputExportDownth = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH", "DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH");
	        inputExportDownth = (inputExportDownth == "/") ? "INVALID" : inputExportDownth;
	        var param = new tagElement("param");
	        param.setAttribute("name", "inputExportDownth");
	        param.setAttribute("value", inputExportDownth);
	        row.appendChild(param);
	        
	        if(!isValidValue(inputExpopr,inputExportDownth,inputExportUpth))
	        {
	        	return null;
	        }
        }
        else if(st.getCellModify(i,"DWDMTL1_ATTROPTPWR_EXPOPR_UPTH")||st.getCellModify(i,"DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH"))
        {
        	var inputExportUpth = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPR_UPTH", "DWDMTL1_ATTROPTPWR_EXPOPR_UPTH");
	        inputExportUpth = (inputExportUpth == "/") ? "INVALID" : inputExportUpth;
	        var param = new tagElement("param");
	        param.setAttribute("name", "inputExportUpth");
	        param.setAttribute("value", inputExportUpth);
	        row.appendChild(param);	

        	var inputExportDownth = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH", "DWDMTL1_ATTROPTPWR_EXPOPR_DOWNTH");
	        inputExportDownth = (inputExportDownth == "/") ? "INVALID" : inputExportDownth;
	        var param = new tagElement("param");
	        param.setAttribute("name", "inputExportDownth");
	        param.setAttribute("value", inputExportDownth);
	        row.appendChild(param);	
	        if(!isValidValue(null,inputExportDownth,inputExportUpth))
	        {
	        	return null;
	        }
        }
        
        if(st.getCellModify(i,"DWDMTL1_ATTROPTPWR_EXPOPT"))
        {
        	var outputExpopt = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPT", "DWDMTL1_ATTROPTPWR_EXPOPT");
	        outputExpopt = (outputExpopt == "/") ? "INVALID" : outputExpopt;
	        var param = new tagElement("param");
	        param.setAttribute("name", "outputExpopt");
	        param.setAttribute("value", outputExpopt);
	        row.appendChild(param);	
	        
	        var outputExportUpth = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPT_UPTH", "DWDMTL1_ATTROPTPWR_EXPOPT_UPTH");
	        outputExportUpth = (outputExportUpth == "/") ? "INVALID" : outputExportUpth;
	        var param = new tagElement("param");
	        param.setAttribute("name", "outputExportUpth");
	        param.setAttribute("value", outputExportUpth);
	        row.appendChild(param);	
        	var outputExportDownth = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH", "DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH");
	        outputExportDownth = (outputExportDownth == "/") ? "INVALID" : outputExportDownth;
	        var param = new tagElement("param");
	        param.setAttribute("name", "outputExportDownth");
	        param.setAttribute("value", outputExportDownth);
	        row.appendChild(param);	
	        if(!isValidValue(outputExpopt,outputExportDownth,outputExportUpth))
	        {
	        	return null;
	        }
        }
        else if(st.getCellModify(i,"DWDMTL1_ATTROPTPWR_EXPOPT_UPTH")||st.getCellModify(i,"DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH"))
        {
        	var outputExportUpth = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPT_UPTH", "DWDMTL1_ATTROPTPWR_EXPOPT_UPTH");
	        outputExportUpth = (outputExportUpth == "/") ? "INVALID" : outputExportUpth;
	        var param = new tagElement("param");
	        param.setAttribute("name", "outputExportUpth");
	        param.setAttribute("value", outputExportUpth);
	        row.appendChild(param);	
        	var outputExportDownth = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH", "DWDMTL1_ATTROPTPWR_EXPOPT_DOWNTH");
	        outputExportDownth = (outputExportDownth == "/") ? "INVALID" : outputExportDownth;
	        var param = new tagElement("param");
	        param.setAttribute("name", "outputExportDownth");
	        param.setAttribute("value", outputExportDownth);
	        row.appendChild(param);	
	        if(!isValidValue(null,outputExportDownth,outputExportUpth))
	       	{
	        	return null;
	        }
        }
        
        if(st.getCellModify(i,"DWDMTL1_ATTROPTPWR_INPUTUPTH") || st.getCellModify(i,"DWDMTL1_ATTROPTPWR_INPUTDOWNTH"))
        {
        	var inputAlmUPTH = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_INPUTUPTH", "DWDMTL1_ATTROPTPWR_INPUTUPTH");
	        inputAlmUPTH = (inputAlmUPTH == "/") ? "INVALID" : inputAlmUPTH;
	        var param = new tagElement("param");
	        param.setAttribute("name", "inputALMUPTH");
	        param.setAttribute("value", inputAlmUPTH);
	        row.appendChild(param);	
	        
	        var inputAlmDNTH = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_INPUTDOWNTH", "DWDMTL1_ATTROPTPWR_INPUTDOWNTH");
	        inputAlmDNTH = (inputAlmDNTH == "/") ? "INVALID" : inputAlmDNTH;
	        var param = new tagElement("param");
	        param.setAttribute("name", "inputALMDownTH");
	        param.setAttribute("value", inputAlmDNTH);
	        row.appendChild(param);	
        }
        
        if(st.getCellModify(i,"DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH") || st.getCellModify(i,"DWDMTL1_ATTROPTPWR_OUTPUTUPTH"))
        {
        	var outputAlmDownTH = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH", "DWDMTL1_ATTROPTPWR_OUTPUTDOWNTH");
        	outputAlmDownTH = (outputAlmDownTH == "/") ? "INVALID" : outputAlmDownTH;
	        var param = new tagElement("param");
	        param.setAttribute("name", "outputALMDownTH");
	        param.setAttribute("value", outputAlmDownTH);
	        row.appendChild(param);	
	        
	        var outputAlmUpTH = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_OUTPUTUPTH", "DWDMTL1_ATTROPTPWR_OUTPUTUPTH");
	        outputAlmUpTH = (outputAlmUpTH == "/") ? "INVALID" : outputAlmUpTH;
	        var param = new tagElement("param");
	        param.setAttribute("name", "outputAlmUpTH");
	        param.setAttribute("value", outputAlmUpTH);
	        row.appendChild(param);	
        }
        
        if (null != st.getCell(i, "DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH") || null != st.getCell(i, "DWDMTL1_ATTROPTPWR_CFPINPUTUPTH"))
        {
            if(st.getCellModify(i,"DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH") || st.getCellModify(i,"DWDMTL1_ATTROPTPWR_CFPINPUTUPTH"))
            {
            	var inputAlmUPTH = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_CFPINPUTUPTH", "DWDMTL1_ATTROPTPWR_CFPINPUTUPTH");
    	        inputAlmUPTH = (inputAlmUPTH == "/") ? "INVALID" : inputAlmUPTH;
    	        var param = new tagElement("param");
    	        param.setAttribute("name", "inputALMUPTH");
    	        param.setAttribute("value", inputAlmUPTH);
    	        row.appendChild(param);	
    	        
    	        var inputAlmDNTH = st.getCellStoreValue(i, "DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH", "DWDMTL1_ATTROPTPWR_CFPINPUTDOWNTH");
    	        inputAlmDNTH = (inputAlmDNTH == "/") ? "INVALID" : inputAlmDNTH;
    	        var param = new tagElement("param");
    	        param.setAttribute("name", "inputALMDownTH");
    	        param.setAttribute("value", inputAlmDNTH);
    	        row.appendChild(param);	
            }
        }
        bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);
    return di.toString();
}




function isValidValue(value,down,up)
{
	if (value == "INVALID" || down == "INVALID" || up == "INVALID")
	{
		return true;
	}
	if(value==null&&(parseFloat(down)!="/"||parseFloat(up)!="/"))
	{
		if(parseFloat(down)<parseFloat(up))
		{
			return true;
		}
		else 
		{
			alert(RESOURCE["thresholderror"]);
			return false;
		}
	}
	else if(value!="/"&&(down!="/"||up!="/"))
	{
		if(parseFloat(down)==parseFloat(up))
		{
			alert(RESOURCE["thresholderror"]);
			return false;
		}
		else if(parseFloat(value)<=parseFloat(up)&&parseFloat(down)<=parseFloat(value))
		{
			return true
		}
		else
		{
			alert(RESOURCE["opticpowerwarn"]);
			return false;
		}
	}

}

function compareOprObject(str1,str2)
{
	var port1;
	var port2;
	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{
		var portPath = st.getCellStoreValue(i, "portPath", "portname");
		if (portPath == str1)
		{
		    port1 = st.getCellStoreValue(i, "port", "port");
		    continue;
		}
		if (portPath == str2)
		{
		    port2 = st.getCellStoreValue(i, "port", "port");
		    continue;
		}
	}
	return compareNum(port1, port2);
}

function callSetBack(doc)
{
		var winurlobj = new Object();
	winurlobj = getNeProperty(self);
    var data = EncapsulateData(doc);
	var errArr = [];
    errArr[0] = "neid";
    showErrorDialog(data, errArr);  
    
    if (data.getSErrorCode() < 2)
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+winurlobj["neid"],false);
    	$("applybtn").disabled = true;
    	query();
	}
    else
    {
    	$("applybtn").disabled = false;
    } 
      
}

function AlmInputTH()
{
	this.aid = "";
	this.upthmaxvalue = -32767;
	this.upthminvalue = -32767;
	this.downthmaxvalue = -32767;
	this.downthminvalue = -32767;
	this.upthvalueedit = false;
	this.downthvalueedit = false;
}
