 /**
 *      
 * @param sfid:   ID
 * @return  
 */
function initBody(sfidArr,nofiltercols,hiddenCols,ophLevel)
{
	this.ophLevel = ophLevel;
	if(ophLevel == "opu")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn/opuophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	else if(ophLevel == "tcm")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn/tcmophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	else if(ophLevel == "pm")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn_nar5c01/pmophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	else if(ophLevel == "sm")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn_nar5c01/smophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	else if(ophLevel == "ftfl")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn/ftflophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	
	$("querybtn").value=RESOURCE["querybutton"];
	if($("stateBtn") != null)
	{
		$("stateBtn").value=RESOURCE["statebutton"];
	}
	if($("maintenanceBtn") != null)
	{
    		$("maintenanceBtn").value=RESOURCE["maintenancebutton"];
    	}
    	$("applybtn").value=RESOURCE["applybutton"]; 
    
    if(ophLevel == "tcm")
    {
    	$("maintenanceBtn").disabled= true;
    }
    
    if (ophLevel == "opu")
    {
    	$("maintenanceBtn").disabled= true;
    }
    
    winurlobj = getNeProperty(self);

    
    netype = getNeProperty(top)["neType"];
    
    neid = winurlobj["neid"];
    
    slotid = winurlobj["slotid"];
    
	st = new SortTable();
	
    st.setImage("../../../../../../../images/");
	 

    tableconfObj = window.tableconf[0];
    
    
    var attrArr = winurlobj["supportAttr"].split(",");
    
    filterAttrCol(tableconfObj,attrArr,nofiltercols);
    
    if(null != hiddenCols)
    {
    	for(var i = 0, len = hiddenCols.length; i < len; i++)
    	{
    		var cell = tableconfObj.getColFromColId(hiddenCols[i]);
    		if(null != cell)
    		{
    			cell.width = "0";
    		}
    	}
    }
    
    var boardType = winurlobj["boardType"];

    if(ophLevel == "pm")
	{
		if (boardType == TN11L4G || boardType == BDTYPE_TN11LQG)
		{
			var celldegth = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_DEGTH");
			if (celldegth != null)
			{
				celldegth.cell.isEdit = 0;
			}
			
			var celldegtime = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_DEGTIME");
			if (celldegtime != null)
			{
				celldegtime.cell.isEdit = 0;
			}
		}
		
		if (boardType == 1279)//boardType == BDTYPE_TN11LSXR || 
		{
			var cellttisapi = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_TTISAPI");
			if (cellttisapi != null)
			{
				cellttisapi.cell.isEdit = 0;
			}
			
			var cellttidapi = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_TTIDAPI");
			if (cellttidapi != null)
			{
				cellttidapi.cell.isEdit = 0;
			}
		}
		
		if (boardType == 1196 || boardType == BDTYPE_TN11TQX
		 || boardType == TN11L4G || boardType == BDTYPE_TN11LQG || boardType == TN11LOG
		 || boardType == TN11LOM || boardType == BDTYPE_TN11TSXL)
		{
			var cellnonintrmon = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_NONINTRMON");
			if (cellnonintrmon != null)
			{
				cellnonintrmon.cell.isEdit = 0;
			}
		}
		
		if (boardType == BDTYPE_TN11LSXR || boardType == 1279)
		{
			var cellplm2ais = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_PLM2AIS");
			if (cellplm2ais != null)
			{
				cellplm2ais.cell.isEdit = 0;
			}
			
			var cellmsim2ais = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_MSIM2AIS");
			if (cellmsim2ais != null)
			{
				cellmsim2ais.cell.isEdit = 0;
			}
		}
		
		if (boardType != BDTYPE_TN11TSXL)
		{
			var cellvcplm2ais = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_VCPLM2AIS");
			if (cellvcplm2ais != null)
			{
				cellvcplm2ais.cell.isEdit = 0;
			}
		}
	}
    else if(ophLevel == "opu")
    {
    	if (boardType == 1193 || boardType == BDTYPE_TN11LSXR || boardType == 1279)
    	{
    		var cellexppt = tableconfObj.getColFromColId("DWDMTL1_ATTROPU_EXPPT");
			if (cellexppt != null)
			{
				cellexppt.cell.isEdit = 0;
			}
    	}
    }
    
    st.setOnCellEditHandler(cellEditHandler);
    
    addPTOption(); 
    
    createTableHead(st, tableconfObj);   
     
    var hc = st.getHeadCell("operaObj");
	st.setHCAttribute(hc, 1, 2, comparePortPath);
    
	document.getElementById("tablecomponent").appendChild(st.getTable());	
	
	
	 st.setBodyHeight(getComponetHeight($("tablecomponent"),110)+"px");
	
	window.onresize=function()
	{
		st.setBodyHeight(getComponetHeight($("tablecomponent"),110)+"px");
		adjustTableLayout(st,tableconfObj);
	}	
	
	$("tablecomponent").oncontextmenu=popupMenuHandler;	
	st.setBodyWidth(tableconfObj.width,tableconfObj.percent,0);
	var querySfid = sfidArr[0];
	var setSfid = sfidArr[1];
	sendQueryRightReq(querySfid,setSfid);
}

function comparePortPath(str1, str2)
{
	var portpath1 = str1.split("&");
	var port1 = portpath1[0];
	var path1 = portpath1[1];
	
	var portpath2 = str2.split("&");
	var port2 = portpath2[0];
	var path2 = portpath2[1];
	
	
    if (parseInt(port1) > parseInt(port2)) 
    {
        return 1;
    }
    else if (parseInt(port1) < parseInt(port2)) 
    {
        return -1;       
    }
    path1 = (path1 == 65537?1:path1);
    path2 = (path2 == 65537?1:path2);
    if (parseInt(path1) > parseInt(path2)) 
    {
        return 1;
    }
    else if (parseInt(path1) < parseInt(path2)) 
    {
        return -1;
    }
    else 
    {
        return 0;
    }
}
