var winurlobj;
var tableconfObj;
var st;
var neid;
var slotid;
var curCellEle;
var curCellkeyArray;

var hasQueryRight = true;
var hasApplyRight = true;

var netype;

var wintopobj = getNeProperty(self);

var neversion = wintopobj.neversion;

var OSN_1800_A = 66; // 1800A
var ophLevel;
var QUERY_TCM_CMD = TE_FUNC_CFG_TCM_OVERHEAD;
var SET_TCM_CMD = TE_FUNC_SFG_TCM_OVERHEAD;
var QUERY_SM_CMD = TE_FUNC_CFG_SM_OVERHEAD;
var SET_SM_CMD = TE_FUNC_SFG_SM_OVERHEAD;

var ttiCols = [];
ttiCols.push("OTN_TCM_ST_TTI");
ttiCols.push("OTN_TCM_SR_TTI");
ttiCols.push("OTN_PM_ST_TTI");
ttiCols.push("OTN_PM_SR_TTI");
ttiCols.push("OTN_SM_ST_TTI");
ttiCols.push("OTN_SM_SR_TTI");

var TL1TTICols = [];//TL1      TTI            
TL1TTICols.push("DWDMTL1_ATTRTCM_EXPTTISAPI");
TL1TTICols.push("DWDMTL1_ATTRTCM_EXPTTIDAPI");
TL1TTICols.push("DWDMTL1_ATTRTCM_TTISAPI");
TL1TTICols.push("DWDMTL1_ATTRTCM_TTIDAPI");
TL1TTICols.push("DWDMTL1_ATTRTCM_TTIOPER");

TL1TTICols.push("DWDMTL1_ATTRSM_EXPTTISAPI");
TL1TTICols.push("DWDMTL1_ATTRSM_EXPTTIDAPI");
TL1TTICols.push("DWDMTL1_ATTRSM_TTISAPI");
TL1TTICols.push("DWDMTL1_ATTRSM_TTIDAPI");
TL1TTICols.push("DWDMTL1_ATTRSM_TTIOPER");
TL1TTICols.push("DWDMTL1_ATTRSM_INCTTISAPI");
TL1TTICols.push("DWDMTL1_ATTRSM_INCTTIDAPI");
TL1TTICols.push("DWDMTL1_ATTRSM_INCTTIOPER");

TL1TTICols.push("DWDMTL1_ATTRPM_EXPTTISAPI");
TL1TTICols.push("DWDMTL1_ATTRPM_EXPTTIDAPI");
TL1TTICols.push("DWDMTL1_ATTRPM_TTISAPI");
TL1TTICols.push("DWDMTL1_ATTRPM_TTIDAPI");
TL1TTICols.push("DWDMTL1_ATTRPM_TTIOPER");
TL1TTICols.push("DWDMTL1_ATTRPM_INCTTISAPI");
TL1TTICols.push("DWDMTL1_ATTRPM_INCTTIDAPI");
TL1TTICols.push("DWDMTL1_ATTRPM_INCTTIOPER");

TL1TTICols.push("DWDMTL1_ATTRFTFL_FTFLOPER");

var maxDegNumCols = [];
maxDegNumCols[1] = "20421";
maxDegNumCols[2] = "40842";
maxDegNumCols[3] = "82026";
maxDegNumCols[4] = "329492";

var language = SYSTEMCONF.getLanguage();

var supportBrustBoard = [BDTYPE_TN11NS3,1152,1196,1279,BDTYPE_TN11LSXR,1199,1278,BDTYPE_TN11TMX,TN11LOM,TN11LOG,BDTYPE_TN11TQX,1277
				,BDTYPE_TN11ND2,BDTYPE_TN12ND2,BDTYPE_TN12TMX,BDTYPE_TN13LSX,BDTYPE_TN12LDX
				,BDTYPE_TN12LOG,BDTYPE_TN52NS2,BDTYPE_TN52ND2,BDTYPE_TN12LOM,BDTYPE_TN52NS3
				,BDTYPE_TN52NQ2,BDTYPE_TN52TQX,BDTYPE_TN12ELQX,BDTYPE_TN52TDX,1572,1542,1573,2212,2213,2109,2110,2211
				,2272,2430,2424,2425,2426,2427,2428,2297,2308,2309,2310,2311,2313,2317,2479,2480,2330,2578,2511,2279,2280,2481,2482
				,2552,2553,2376,2576,2370,2294,2295,2293,2855];

/*
 *  1 - 2.5g(odu1)  2 - 10g(odu2)  3 - 40g(odu3)  4 - odu5g  5 - 1.25g(odu0)  6 - 100g(odu4)
 *  DEGTH = {1,0,20420},{2,0,82025},{3,0,329491},{4,0,41012},{5,0,10167},{6,0,856387}
 */
var MIN_DEGTH = "0";
var MIN_DEGTIMES = "2";
if (isR6C01NEVersion(neversion))
{
	MIN_DEGTH = "1";
	MIN_DEGTIMES = "1";
}
var MAX_DEGTH0 = "10167";
var MAX_DEGTH1 = "20420";
var MAX_DEGTH2 = "82025";
var MAX_DEGTH3 = "329491";
var MAX_DEGTH4 = "856387"; 
var MAX_DEGTH5G = "41012";
var MAX_DEGTHODUFlex = "66086";
var MAX_DEGTH0_1800A = "10168";
var MAX_DEGTH1_1800A = "20421";
var MAX_DEGTH2_1800A = "82026";
var MAX_DEGTH5G_1800A = "40842";

var MaxLengthForOper = 32;
var MaxLengthForTTI = 15;
var MaxLengthForFtfloper = 118;

var currentSFID = null;

var modifyRowArray = new Array();

var changedRows = [];
var queryData = null;

/**
 *       
 * @param  
 * @return  
 */
function initMainPage(filename)
{
	loadXMLdoc("../../../../../conf/gencfg/"+filename+".xml", "GET", false,EncapsulateGenCfg);
	
    var win = new Object();
    win = getNeProperty(self);
    var neid = win["neid"];
    var slotid = win["slotid"];
    var boardType = win["boardType"];
    var urlStr = decodeURI(self.location.search);

    var xmlstr = createQuerySupportAttrXML(neid,slotid,boardType);
    urlreq ="../../../../../../../tl1NEExlorerServlet?sfid=" + TECMDCODE_NTF_CREATECIRCUITPACK;

    loadXMLdoc(urlreq, "POST",true,initGenCfgPage,[gencfg,urlStr],"inputdata="+xmlstr);
    win = null;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "boardname";
    errArr[2] = "portid";
    openErrPage("../../../../../../../page/", data.getError(), errArr);
}

/**
 *      
 * @param sfid:   ID
 * @return  
 */
function initBody(sfidArr,nofiltercols,hiddenCols,ophLevel)
{
	this.ophLevel = ophLevel;
	if(ophLevel == "opu")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn/opuophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	else if(ophLevel == "tcm")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn/tcmophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	else if(ophLevel == "pm")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn/pmophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	else if(ophLevel == "sm")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn/smophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	else if(ophLevel == "ftfl")
	{
		loadXMLdoc("../../../../../conf/board_attribute/config/ophbyte/otn/ftflophbytetable_"+SYSTEMCONF.getLanguage() +".xml", "GET", false,EncapsulateTable);
	}
	
	$("querybtn").value=RESOURCE["querybutton"];
	if($("stateBtn") != null)
	{
		$("stateBtn").value=RESOURCE["statebutton"];
	}
	if($("maintenanceBtn") != null)
	{
    		$("maintenanceBtn").value=RESOURCE["maintenancebutton"];
    	}
    	$("applybtn").value=RESOURCE["applybutton"]; 
    
    if(ophLevel == "tcm")
    {
    	$("maintenanceBtn").disabled= true;
    }
    
    if (ophLevel == "opu")
    {
    	$("maintenanceBtn").disabled= true;
    }
    
    winurlobj = getNeProperty(self);

    
    netype = getNeProperty(top)["neType"];
    
    neid = winurlobj["neid"];
    
    slotid = winurlobj["slotid"];
    
	st = new SortTable();
	
    st.setImage("../../../../../../../images/");
	 

    tableconfObj = window.tableconf[0];
    
    
    var attrArr = winurlobj["supportAttr"].split(",");
    
    filterAttrCol(tableconfObj,attrArr,nofiltercols);
    
    if(null != hiddenCols)
    {
    	for(var i = 0, len = hiddenCols.length; i < len; i++)
    	{
    		var cell = tableconfObj.getColFromColId(hiddenCols[i]);
    		if(null != cell)
    		{
    			cell.width = "0";
    		}
    	}
    }
    
    var boardType = winurlobj["boardType"];

    if(ophLevel == "pm")
	{
		if (boardType == TN11L4G || boardType == BDTYPE_TN11LQG)
		{
			var celldegth = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_DEGTH");
			if (celldegth != null)
			{
				celldegth.cell.isEdit = 0;
			}
			
			var celldegtime = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_DEGTIME");
			if (celldegtime != null)
			{
				celldegtime.cell.isEdit = 0;
			}
		}
		
		if (boardType == 1279)//boardType == BDTYPE_TN11LSXR || 
		{
			var cellttisapi = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_TTISAPI");
			if (cellttisapi != null)
			{
				cellttisapi.cell.isEdit = 0;
			}
			
			var cellttidapi = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_TTIDAPI");
			if (cellttidapi != null)
			{
				cellttidapi.cell.isEdit = 0;
			}
		}
		
		if (boardType == 1196 || boardType == BDTYPE_TN11TQX
		 || boardType == TN11L4G || boardType == BDTYPE_TN11LQG || boardType == TN11LOG
		 || boardType == TN11LOM || boardType == BDTYPE_TN11TSXL)
		{
			var cellnonintrmon = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_NONINTRMON");
			if (cellnonintrmon != null)
			{
				cellnonintrmon.cell.isEdit = 0;
			}
		}
		
		if (boardType == BDTYPE_TN11LSXR || boardType == 1279)
		{
			var cellplm2ais = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_PLM2AIS");
			if (cellplm2ais != null)
			{
				cellplm2ais.cell.isEdit = 0;
			}
			
			var cellmsim2ais = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_MSIM2AIS");
			if (cellmsim2ais != null)
			{
				cellmsim2ais.cell.isEdit = 0;
			}
		}
		
		if (boardType != BDTYPE_TN11TSXL)
		{
			var cellvcplm2ais = tableconfObj.getColFromColId("DWDMTL1_ATTRPM_VCPLM2AIS");
			if (cellvcplm2ais != null)
			{
				cellvcplm2ais.cell.isEdit = 0;
			}
		}
	}
    else if(ophLevel == "opu")
    {
    	if (boardType == 1193 || boardType == BDTYPE_TN11LSXR || boardType == 1279)
    	{
    		var cellexppt = tableconfObj.getColFromColId("DWDMTL1_ATTROPU_EXPPT");
			if (cellexppt != null)
			{
				cellexppt.cell.isEdit = 0;
			}
    	}
    }
    
    st.setOnCellEditHandler(cellEditHandler);
    
    addPTOption(); 
    
    createTableHead(st, tableconfObj);   
    
    var hc = st.getHeadCell("operaObj");
	st.setHCAttribute(hc, 1, 2, comparePortPath);
    
	document.getElementById("tablecomponent").appendChild(st.getTable());	
	
	
	 st.setBodyHeight(getComponetHeight($("tablecomponent"),110)+"px");
	
	window.onresize=function()
	{
		st.setBodyHeight(getComponetHeight($("tablecomponent"),110)+"px");
		adjustTableLayout(st,tableconfObj);
	}	
	
	$("tablecomponent").oncontextmenu=popupMenuHandler;	
	st.setBodyWidth(tableconfObj.width,tableconfObj.percent,0);
	var querySfid = sfidArr[0];
	var setSfid = sfidArr[1];
	sendQueryRightReq(querySfid,setSfid);
	
}

function comparePortPath(str1, str2)
{
	var portpath1 = str1.split("&");
	var port1 = portpath1[0];
	var path1 = portpath1[1];
	
	var portpath2 = str2.split("&");
	var port2 = portpath2[0];
	var path2 = portpath2[1];
	
	
    if (parseInt(port1) > parseInt(port2)) 
    {
        return 1;
    }
    else if (parseInt(port1) < parseInt(port2)) 
    {
        return -1;       
    }
    path1 = (path1 == 65537?1:path1);
    path2 = (path2 == 65537?1:path2);
    if (parseInt(path1) > parseInt(path2)) 
    {
        return 1;
    }
    else if (parseInt(path1) < parseInt(path2)) 
    {
        return -1;
    }
    else 
    {
        return 0;
    }
}

/**
 *     PT   
 * @param  
 * @return  
 */
function addPTOption()
{
    if( null != tableconfObj.getColFromColId("DWDMTL1_ATTROPU_EXPPT"))
    {
        addPTOptions("DWDMTL1_ATTROPU_EXPPT");
    }

    if (null != tableconfObj.getColFromColId("DWDMTL1_ATTROPU_STPT")) 
    {
        addPTOptions("DWDMTL1_ATTROPU_STPT");
    }
}

/**
 *     PT     
 * @param  
 * @return  
 */
function addPTOptions(colId)
{
    var ptCellEle = tableconfObj.getColFromColId(colId).cell.editElement;

    for (var ptValue = 1; ptValue < 255; ptValue++) 
    {
        if (ptValue == 85 || ptValue == 102 || ptValue == 255) 
        {
            continue;
        }
        var opobj = new OPTag();
        ptValue = "0X" + toHex(ptValue);
        opobj.name = getPTShowValue(ptValue);
        opobj.value = ptValue;
        ptCellEle.options[ptCellEle.options.length] = opobj;
    } 
}


function getIDs()
{
	var ids = new Array();
	for(var i=0,len=tableconfObj.getColsLength();i<len;i++)
	{
		ids[ids.length] = tableconfObj.getColId(i);
	}
	return ids;
}


/**
 *    TTI         
 * @param  
 * @return  
 */
function addListerner()
{
	var cell = null;
	var rowindex = 0;
	var grade = 1;
	var cellEdit = null;
	var ids = getIDs();
	for(var i = 0,len = st.getDataRowLength();i<len;i++)
	{
		rowindex = i;
		grade = st.getCellStoreValue(i,"operaObj","grade")
		cell = st.getCell(i,"OTN_TCM_ST_TTI");
		if(null != cell&&cell.element.isEdit == "1")
		{
			cell.element["ondblclick"] = function()
			{	
				showTTIMgrDialog(this,"OTN_TCM_ST_TTI",["ST_SRC_FLAG","ST_SINK_FLAG","ST_USER_FLAG"]);	
			}
		}
        cell = st.getCell(i,"OTN_TCM_SR_TTI");
        if(null != cell&&cell.element.isEdit == "1")
        {
			cell.element["ondblclick"] = function()
			{			
				showTTIMgrDialog(this,"OTN_TCM_SR_TTI",["SR_SRC_FLAG","SR_SINK_FLAG","SR_USER_FLAG"]);	
			}	
        }
        
        cell = st.getCell(i,"OTN_PM_ST_TTI");
		if(null != cell&&cell.element.isEdit == "1")
		{
			cell.element["ondblclick"] = function()
			{	
				showTTIMgrDialog(this,"OTN_PM_ST_TTI",["ST_SRC_FLAG","ST_SINK_FLAG","ST_USER_FLAG"]);	
			}
		}
        cell = st.getCell(i,"OTN_PM_SR_TTI");
        if(null != cell&&cell.element.isEdit == "1")
        {
			cell.element["ondblclick"] = function()
			{			
				showTTIMgrDialog(this,"OTN_PM_SR_TTI",["SR_SRC_FLAG","SR_SINK_FLAG","SR_USER_FLAG"]);	
			}	
        }
		if(ids.contains("DWDMTL1_ATTRFTFL_FTFLOPER"))
		{
			var portNameEdit = st.getCellEdit(i,"DWDMTL1_ATTRFTFL_FTFLOPER");
			portNameEdit.element["onkeydown"] = function()
			{
				return calStrSinoLen(this,MaxLengthForFtfloper);
			}
			portNameEdit.element["onkeyup"] = function()
			{
				return calStrSinoLen(this,MaxLengthForFtfloper);
			}
			
			portNameEdit.element.onkeypress=function(e)
			{
				return blockChars(e,"~!#$%+^*|[]{}<>\"\\=,:;?'");
			}
			portNameEdit.element.onblur = function()
			{

				calStrSinoLenCheck(this,MaxLengthForFtfloper);
				
				this.style.position="static";
		        this.style.border="1px solid #999999";
		        this.style.width=this.parentNode.offsetWidth;    
				var rows= this.parentNode.parent.getSelectedRows();
				for(var j=0; j<rows.length; j++)
		        {
			          var cell=  this.parentNode.parent.getCell(rows[j],this.parentNode.colid);	
			          if(null == cell.element.editElement || cell.element.isEdit == 0)
			          {
			          	continue;
			          }	  	
			          cell.element.showElement.setValue(this.value);
			          
			          cell.element.modify = true;
			          cell.element.parentNode.modify = true;
			          cell.element.style.backgroundColor="#d0f946";
			          cell.element.parent.setTdCellValue(cell.element, this.parentNode.colid, this.value);          
			          cell.element.showElement.element.style.display	=	"";
			          handleCellEdit(cell.element,TABLE_CONSTANT.AFTEREDIT); 
			    }
			    
			    var pnode = this.parentNode;
			    pnode.removeChild(pnode.lastChild);
			    
			    pnode.showElement.element.style.display	=	"";
                	    handleCellEdit(pnode,TABLE_CONSTANT.AFTEREDIT); 
		    }
		}
        cell = st.getCell(i,"OTN_SM_ST_TTI");
		if(null != cell&&cell.element.isEdit == "1")
		{
			cell.element["ondblclick"] = function()
			{	
				showTTIMgrDialog(this,"OTN_SM_ST_TTI",["ST_SRC_FLAG","ST_SINK_FLAG","ST_USER_FLAG"]);	
			}
		}
        cell = st.getCell(i,"OTN_SM_SR_TTI");
        if(null != cell&&cell.element.isEdit == "1")
        {
			cell.element["ondblclick"] = function()
			{			
				showTTIMgrDialog(this,"OTN_SM_SR_TTI",["SR_SRC_FLAG","SR_SINK_FLAG","SR_USER_FLAG"]);	
			}	
        }
        
        cell = st.getCell(i,"OTN_TCM_DEG_TH");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,0,maxDegNumCols[grade]);
		}
        cell = st.getCell(i,"OTN_TCM_DEG_TIMES");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,2,10,6);
		}
        cell = st.getCell(i,"OTN_PM_DEG_TH");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,0,maxDegNumCols[grade]);
		}
        cell = st.getCell(i,"OTN_PM_DEG_TIMES");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,2,10,6);
		}
        cell = st.getCell(i,"OTN_SM_DEG_TH");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,0,maxDegNumCols[grade]);
		}
        cell = st.getCell(i,"OTN_SM_DEG_TIMES");
        if(null != cell&&cell.element.isEdit == "1")
		{
			checkDataCellEvent(cell.element.editElement.element,2,10,6);
		}
		
		handleTTITextEvent(i, TL1TTICols);
		
		
		
		cell = st.getCell(i,"OTN_TCM_BIP8_MODE");
		if(null != cell)
		{
			cellEdit = st.getCellEdit(i,"OTN_TCM_BIP8_MODE");
		}else if(null != st.getCell(i,"OTN_PM_BIP8_MODE"))
		{
			cellEdit = st.getCellEdit(i,"OTN_PM_BIP8_MODE");
		}else if(null != st.getCell(i,"OTN_SM_BIP8_MODE"))
		{
			cellEdit = st.getCellEdit(i,"OTN_SM_BIP8_MODE");
		}
		

		if(null != cellEdit)
		{
			var bdType = winurlobj["boardType"];
			if(bdType == 922||bdType == BDTYPE_TN11LSXR||bdType == 915 
				|| bdType == TN11LOM || bdType == TN11LOG ||bdType == 1085 
				|| bdType == 1086 || bdType == BDTYPE_TN11TMX || bdType == 1152 
				|| bdType == 1199 || bdType == BDTYPE_TN11ND2 )
			{
				cellEdit.clearOptions();
				cellEdit.addOption(RESOURCE["Bursty"],2);
			}
			else if (bdType != BDTYPE_TN11TSXL)
			{
				cellEdit.clearOptions();
				cellEdit.addOption(RESOURCE["Poisson"],1);				
			}
		}		
		cellEdit = null;
		if(ids.contains("DWDMTL1_ATTRSM_BIP8MODE"))
		{
		    var bip8SMCell = st.getCellEdit(rowindex, "DWDMTL1_ATTRSM_BIP8MODE").element;	
			bip8SMCell.onchange = function()
			{			
				handleSMBip8(this.value);
			}	
		}
		
		if(ids.contains("DWDMTL1_ATTRPM_BIP8MODE"))
		{
			var bip8PMCell = st.getCellEdit(rowindex, "DWDMTL1_ATTRPM_BIP8MODE").element;	
			bip8PMCell.onchange = function()
			{				
				handlePMBip8(this.value);
			}	
		}
		
		if(ids.contains("DWDMTL1_ATTRTCM_BIP8MODE"))
		{
			var bip8TCMCell = st.getCellEdit(rowindex, "DWDMTL1_ATTRTCM_BIP8MODE").element;	
			bip8TCMCell.onchange = function()
			{					
				handleTCMBip8(this.value);
			}		
		}					
	}	
}


/**
 * TTI       
 * @param row:  
 * @param colIds:      
 * @return  
 */
function handleTTITextEvent(row, colIds)
{
	for(var i = 0; i < colIds.length; i++)
	{
		var cell = st.getCell(row, colIds[i]);
		if(null == cell || cell.element.isEdit != "1")
		{
			continue;
		}
		
		var obj = cell.element.editElement.element;
		
		obj.style.imeMode = "disabled";
		
		var maxLength = MaxLengthForTTI;
		if (colIds[i].indexOf("OPER") != -1 && colIds[i] != "DWDMTL1_ATTRFTFL_FTFLOPER")
		{
			maxLength = MaxLengthForOper;
		}
		else if (colIds[i] == "DWDMTL1_ATTRFTFL_FTFLOPER")
		{
			maxLength = MaxLengthForFtfloper;
		}
		
		obj.maxLength = maxLength;
		
		if(isIE)
		{
			obj.onkeypress = function(e)
			{
				var event = EventUtil.getEvent();
				var code = event.keyCode;
		    if(code > 255)
		    {
		    	event.returnValue = false;
		    	return false;
		    }
		    if(code == 13)
		    {
		    	event.srcElement.blur();
		    	return false;
		    }
		    return blockChars(e,"~!#$%+^*|[]{}<>\"\\=,:;?'");
			}
  		}
  		else
  		{
			obj.onkeypress = function(e)
			{
				var event = EventUtil.getEvent();
				var code = event.keyCode;
				return blockChars(e,"~!#$%+^*|[]{}<>\"\\=,:;?'");
		  }
  		}
  }
}

var queryUsedSfid;
/**
 *     OTN    
 * @param  sfid:   ID
 * @return  
 */
function sendQueryOTNReq(sfid)
{
	getAvailableRes(neid, slotid, tableconfObj);
	currentSFID = sfid;
	
	if(!hasQueryRight)
	{
		return;
	}
	
	
    var querySfid = sfid;
    
    
    if(sfid == TE_FUNC_SFG_SM_OVERHEAD)
    {
    	querySfid = TE_FUNC_CFG_SM_OVERHEAD;
    }
    else if(sfid == TE_FUNC_SFG_TCM_OVERHEAD)
    {
    	querySfid = TE_FUNC_CFG_TCM_OVERHEAD;
    }
    else if(sfid == TE_FUNC_SFG_OPU_OVERHEAD)
    {
    	querySfid = TE_FUNC_CFG_OPU_OVERHEAD;
    }
    else if(sfid == TE_FUNC_SFG_PM_OVERHEAD)
    {
    	querySfid = TE_FUNC_CFG_PM_OVERHEAD;
    }
    else if(sfid == TECMDCODE_SET_FTFL_OVERHEAD)
    {
    	querySfid = TECMDCODE_GET_FTFL_OVERHEAD;
    }
    queryUsedSfid = querySfid;
    if (needOpenFilterDialog == "true")
    {
    	xshowModalDialog("otnoverheadfilter.html",RESOURCE["filtercondition"] ,750, 500, "../../../../../images/");
    }
    else
    {   
    	queryData = null;
	    changedRows = [];
 	
	    var urlreq ="../../../../../../../tl1NEExlorerServlet?sfid="+querySfid+"&nmUser="+winurlobj["nmUser"];	
	
	    var inputData = createQueryXML(neid,slotid,tableconfObj);
	    if(inputData == null)
		{
			st.clearTableData();
			return;
		}
	    $("querybtn").disabled = true;
	    $("applybtn").disabled = true; 
	
	    showLoadProcess();
	    loadXMLdoc(urlreq,"POST",true, handleQueryOTNRsp,querySfid ,"inputdata="+inputData);
    }
	
}

function getAvailableRes(neid,slotid,tableconf)
{
	var urlreq = "../../../../../../../tl1NEExlorerServlet?sfid=" + TECMDCODE_OTN_QUERY_AVALABLERES;
	
	var xml = createQueryAvailableXML(neid,slotid,tableconf);
	
	loadXMLdoc(urlreq, "POST", false, getAvailableResHandler, null, "inputdata=" + xml);
}

function createQueryAvailableXML(neid,slotid,tableconf)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	param = new tagElement("param");
    param.setAttribute("name", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);
	
	var colids = "";
	var sp = "";
    for (var i = 1; i < tableconf.getColsLength(); i++) 
    {
        colid = tableconf.getColId(i);
        colids = colids + sp + colid;
        sp = ",";
    }
    param = new tagElement("param");
    param.setAttribute("name", "attrNames");
    param.setAttribute("value", colids);
    row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
    return di.toString();
}
var currentFilterRes = [];
var needOpenFilterDialog;
function getAvailableResHandler(doc)
{
    var data = EncapsulateData(doc);
    if(0 == data.getSErrorCode())
    {
    	currentFilterRes = [];
	    needOpenFilterDialog = data.getDataRowParam(0, "isSupportFilter");
		for (var index = 1, len = data.getDataRowLength(); index < len; index++) 
	    {
	    	var port =  data.getDataRowParam(index, "port");
	    	var portname =  data.getDataRowParam(index, "portname");
	    	var fbtype = data.getDataRowParam(index, "fbtype");
			var gradepath = data.getDataRowParam(index, "gradepath");
			var availableres =  new OTNAvailableRes(port,portname,fbtype.split(","));
			availableres.parseGradePath(gradepath);
	        currentFilterRes[currentFilterRes.length] = availableres;
	    }
    }
}

function doFilter(ports,grades,tcmlevels,isfilterexc)
{
	refreshFilterCondition(ports,grades,tcmlevels);
	
	queryData = null;
	changedRows = [];
	 var urlreq ="../../../../../../../tl1NEExlorerServlet?sfid="+queryUsedSfid+"&nmUser="+winurlobj["nmUser"];
	
    var inputData = createQueryXML(neid, slotid, tableconfObj);
	if(inputData == null)
	{
		st.clearTableData();
		return;
	}
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;

    showLoadProcess();
    loadXMLdoc(urlreq, "POST", true, handleQueryOTNRsp, queryUsedSfid, "inputdata=" + inputData);

}

function OTNAvailableRes(port,portName,fbtypeList)
{
	this.port = port;
	this.portName = portName
	if (typeof(fbtypeList) != "undefined") 
	{
		this.fbtypeList = fbtypeList;
	}
	this.gradepathList = [];
}
/**
 *          fbpath  ,grade[path,path];grade[path,path].....
 *        824[1,2,3,4];825[1,2,3,4]....
 */
OTNAvailableRes.prototype.parseGradePath = function(gradepath)
{
	if(typeof(gradepath) != "undefined" && gradepath != "")
	{
		var gradepaths = gradepath.split(";");
		for(var i = 0,len = gradepaths.length;i < len;i++)
		{
			var gradepathtmp = gradepaths[i];
			var firstIndex = gradepathtmp.indexOf("[");
			if(firstIndex > 0)
			{
				var grade = gradepathtmp.substring(0,firstIndex);
				var path = gradepathtmp.substring(firstIndex + 1,gradepathtmp.length - 1);
				this.gradepathList[grade] = path.split(",");
			}
			else
			{
				this.gradepathList[gradepathtmp] = [];
			}
		}
	}
}

/**
 *     OTN    
 * @param sfid:   ID
 * @return  
 */
function sendSetOTNReq(sfid)
{	
	var urlreq ="../../../../../../../tl1NEExlorerServlet?sfid="+sfid+"&nmUser="+winurlobj["nmUser"];
	
    var inputData = createSetXML(neid,st,tableconfObj,sfid); 
    
    if(null != inputData) 
    {
	    $("querybtn").disabled = true;
    	$("applybtn").disabled = true; 
	    
		loadXMLdoc(urlreq,"POST",true, handleSetOTNRsp,sfid ,"inputdata="+inputData);
    }
}

/**
 *          
 * @param doc:       
 * @return  
 */
function handleQueryOTNRsp(doc,sfid)
{
	removeLoadProcess();
	var data = EncapsulateData(doc);

	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{	
		setTIDOnchangeModify("../../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neid,false);
		
		if(queryData !=null && data.getDataRowLength() !=queryData.getDataRowLength())
        	{
        		for(var i= 0,iLength =data.getDataRowLength();i<iLength;i++)
        		{
        			for(var j=0,jLength = queryData.getDataRowLength();j<jLength;j++)
        			{
    
        				if(data.getDataRowParam(i,"port") == queryData.getDataRowParam(j,"port") 
        				    && data.getDataRowParam(i,"path") == queryData.getDataRowParam(j,"path"))
        				{
        					 	queryData.rows[j] = data.rows[i];
        				}
        			}
        		}
        	}
       	 	else
        	{
        		queryData = data;
        	}

		
		
		handleReturnData(data,sfid);
		
		createGenCfgTableBody(st, tableconfObj, data);	
		
		addCellEvent(sfid);		
	}
	
	$("querybtn").disabled = false;
	showErrorPage(data,"query",sfid);	
	
	addListerner();		
}

function onlySupportBrust(bdType)
{
	return supportBrustBoard.contains(bdType);
}


function addCellEvent(sfid)
{
    var bdType = winurlobj["boardType"];
    var ids = getIDs();

	if (sfid == 2105853)
	{	
		for (var i = 0; i < st.getDataRowLength(); i++)
		{
			var mod2ofrowarr = st.getCellStoreValue(i,"mode2","mode2");
		    if (ids.contains("DWDMTL1_ATTRPM_BIP8MODE"))
		    {
				var bip8ModeCell = st.getCellEdit(i,"DWDMTL1_ATTRPM_BIP8MODE");
				if(onlySupportBrust(bdType))
				{
					bip8ModeCell.clearOptions();
					bip8ModeCell.addOption("BURST","BURST");				
				}
		
				if(bdType == TN11L4G || bdType == BDTYPE_TN11LQG)
				{
					bip8ModeCell.clearOptions();
					bip8ModeCell.addOption("POISSON","POISSON");			
				}
		    }	

			var clntpayloadofrow = st.getCellStoreValue(i,"CLNTPLDTYPE","CLNTPLDTYPE");
			var mode2Arr = mod2ofrowarr.split(",");
			var mod2ofrow = mode2Arr[2];
			
			var currentOdun = mode2Arr[mode2Arr.length - 1];
			
			if (bdType == 1193)
			{
				if (mod2ofrow.indexOf("CLNT") != -1)
				{
				    var nonintrmoncell1PM = st.getCellStoreValue(i,"DWDMTL1_ATTRPM_NONINTRMON","DWDMTL1_ATTRPM_NONINTRMON");
				    if (nonintrmoncell1PM != undefined && nonintrmoncell1PM != "" && nonintrmoncell1PM != null)
				    {
				    	var ttisapicell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTISAPI");
						var ttisapicellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTISAPI","DWDMTL1_ATTRPM_TTISAPI");
						if (ttisapicell1PM != undefined && ttisapicell1PM != null)
						{
							setCellDisable(ttisapicell1PM,ttisapicellshow1PM);
						}
						var ttidapicell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTIDAPI");
						var ttidapicellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTIDAPI","DWDMTL1_ATTRPM_TTIDAPI");
						if (ttidapicell1PM != undefined && ttidapicell1PM != null)
						{
							setCellDisable(ttidapicell1PM,ttidapicellshow1PM);
						}
						var ttiopercell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTIOPER");
						var ttiopercellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTIOPER","DWDMTL1_ATTRPM_TTIOPER");
						if (ttiopercell1PM != undefined && ttiopercell1PM != null)
						{
							setCellDisable(ttiopercell1PM,ttiopercellshow1PM);
						}
				    }
				}
			}
			
			if (bdType == 1309)//TNF1LQM
			{
				if (mod2ofrowarr.indexOf("FAC-1-1-3") != -1)//  OTU1       TTI
				{
					refreshTTIState();
				}
			}
			
			if (bdType == BDTYPE_TN11TOM)//TOM 
			{
				if (mod2ofrow.indexOf("CLNT") != -1)
				{
					if (clntpayloadofrow.indexOf("OTU") != -1)
					{
						var ttisapicell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTISAPI");
						var ttisapicellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTISAPI","DWDMTL1_ATTRPM_TTISAPI");
						if (ttisapicell1PM != undefined && ttisapicell1PM != null)
						{
							setCellDisable(ttisapicell1PM,ttisapicellshow1PM);
						}
						var ttidapicell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTIDAPI");
						var ttidapicellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTIDAPI","DWDMTL1_ATTRPM_TTIDAPI");
						if (ttidapicell1PM != undefined && ttidapicell1PM != null)
						{
							setCellDisable(ttidapicell1PM,ttidapicellshow1PM);
						}
						var ttiopercell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTIOPER");
						var ttiopercellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTIOPER","DWDMTL1_ATTRPM_TTIOPER");
						if (ttiopercell1PM != undefined && ttiopercell1PM != null)
						{
							setCellDisable(ttiopercell1PM,ttiopercellshow1PM);
						}
					}
				}
			}
			
			if (bdType == 1186)
			{
				if (mod2ofrow.indexOf("SRV") != -1)
				{
					
				}
				else if (mod2ofrow.indexOf("CLNT") != -1)
				{
	
					if (clntpayloadofrow.indexOf("OTU") != -1)
					{
	
						var ttisapicell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTISAPI");
						var ttisapicellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTISAPI","DWDMTL1_ATTRPM_TTISAPI");
						if (ttisapicell1PM != undefined && ttisapicell1PM != null)
						{
							setCellDisable(ttisapicell1PM,ttisapicellshow1PM);
						}
						var ttidapicell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTIDAPI");
						var ttidapicellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTIDAPI","DWDMTL1_ATTRPM_TTIDAPI");
						if (ttidapicell1PM != undefined && ttidapicell1PM != null)
						{
							setCellDisable(ttidapicell1PM,ttidapicellshow1PM);
						}
						var ttiopercell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTIOPER");
						var ttiopercellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTIOPER","DWDMTL1_ATTRPM_TTIOPER");
						if (ttiopercell1PM != undefined && ttiopercell1PM != null)
						{
							setCellDisable(ttiopercell1PM,ttiopercellshow1PM);
						}
						var plm2aiscell1PM = st.getCell(i,"DWDMTL1_ATTRPM_PLM2AIS");
						var plm2aiscellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_PLM2AIS","DWDMTL1_ATTRPM_PLM2AIS");
						if (plm2aiscell1PM != undefined && plm2aiscell1PM != null)
						{
							setCellDisable(plm2aiscell1PM,plm2aiscellshow1PM);
						}
					}
					else
					{
	                    if (ids.contains("DWDMTL1_ATTRPM_NONINTRMON"))
	                    {
						   var nonintrmoncell1PM = st.getCell(i,"DWDMTL1_ATTRPM_NONINTRMON");					
						   var nonintrmoncellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_NONINTRMON","DWDMTL1_ATTRPM_NONINTRMON");	
						   if (nonintrmoncell1PM != undefined && nonintrmoncell1PM != null)
							{
							   setCellDisable(nonintrmoncell1PM,nonintrmoncellshow1PM);	
							}								
						}
						
					}
				}
			}	
			
			if ((st.getCell(i,"DWDMTL1_ATTRPM_DEGTH") == undefined)
				|| (st.getCell(i,"DWDMTL1_ATTRPM_DEGTIME") == undefined))
			{
				continue;
			}
			
			var cellbip8modePM = st.getCell(i,"DWDMTL1_ATTRPM_BIP8MODE");
			
			var degthcell1PM = st.getCell(i,"DWDMTL1_ATTRPM_DEGTH");
			var degthcellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_DEGTH","DWDMTL1_ATTRPM_DEGTH");
			
			var degtimecell1PM = st.getCell(i,"DWDMTL1_ATTRPM_DEGTIME");
			var degtimecellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_DEGTIME","DWDMTL1_ATTRPM_DEGTIME");
			
			var bip8modevarPM = st.getCellStoreValue(i,"DWDMTL1_ATTRPM_BIP8MODE","DWDMTL1_ATTRPM_BIP8MODE");

			if (bip8modevarPM == "POISSON")
			{
				setCellDisable(degthcell1PM,degthcellshow1PM);
				setCellDisable(degtimecell1PM,degtimecellshow1PM);
			}		
		}
	}
	if (sfid == 2105851)
	{
		for (var i = 0; i < st.getDataRowLength(); i++)
		{
		   if (ids.contains("DWDMTL1_ATTRSM_BIP8MODE"))
		   {
			var bip8ModeCell = st.getCellEdit(i,"DWDMTL1_ATTRSM_BIP8MODE");

			if(onlySupportBrust(bdType))
			{
				bip8ModeCell.clearOptions();
				bip8ModeCell.addOption("BURST","BURST");				
			}
			if(bdType == TN11L4G || bdType == BDTYPE_TN11LQG)
			{
				bip8ModeCell.clearOptions();
				bip8ModeCell.addOption("POISSON","POISSON");			
			}
		   }	
		   
			if ((st.getCell(i,"DWDMTL1_ATTRSM_DEGTH") == undefined)
				|| (st.getCell(i,"DWDMTL1_ATTRSM_DEGTIME") == undefined))
			{
				continue;
			}
			
			var cellbip8modeSM = st.getCell(i,"DWDMTL1_ATTRSM_BIP8MODE");
			
			var degthcell1SM = st.getCell(i,"DWDMTL1_ATTRSM_DEGTH");
			var degthcellshow1SM = st.getCellShow(i,"DWDMTL1_ATTRSM_DEGTH","DWDMTL1_ATTRSM_DEGTH");
			
			var degtimecell1SM = st.getCell(i,"DWDMTL1_ATTRSM_DEGTIME");
			var degtimecellshow1SM = st.getCellShow(i,"DWDMTL1_ATTRSM_DEGTIME","DWDMTL1_ATTRSM_DEGTIME");
			
			var bip8modevarSM = st.getCellStoreValue(i,"DWDMTL1_ATTRSM_BIP8MODE","DWDMTL1_ATTRSM_BIP8MODE");

			if (bip8modevarSM == "POISSON")
			{
				setCellDisable(degthcell1SM,degthcellshow1SM);
				setCellDisable(degtimecell1SM,degtimecellshow1SM);
			}
		}
	}
	if (sfid == 2105847)
	{
		for (var i = 0; i < st.getDataRowLength(); i++)
		{
		    if (ids.contains("DWDMTL1_ATTRTCM_BIP8MODE"))
		   {
			var bip8ModeCell = st.getCellEdit(i,"DWDMTL1_ATTRTCM_BIP8MODE");

			if(onlySupportBrust(bdType))
			{
				bip8ModeCell.clearOptions();
				bip8ModeCell.addOption("BURST","BURST");				
			}
			if(bdType == TN11L4G || bdType == BDTYPE_TN11LQG)
			{
				bip8ModeCell.clearOptions();
				bip8ModeCell.addOption("POISSON","POISSON");			
			}
		   }	
		   
		   
			if ((st.getCell(i,"DWDMTL1_ATTRTCM_DEGTH") == undefined)
				|| (st.getCell(i,"DWDMTL1_ATTRTCM_DEGTIME") == undefined))
			{
				continue;
			}
			var cellbip8modeTCM = st.getCell(i,"DWDMTL1_ATTRTCM_BIP8MODE");
			var degthcell1TCM = st.getCell(i,"DWDMTL1_ATTRTCM_DEGTH");
			var degthcellshow1TCM = st.getCellShow(i,"DWDMTL1_ATTRTCM_DEGTH","DWDMTL1_ATTRTCM_DEGTH");
			
			var degtimecell1TCM = st.getCell(i,"DWDMTL1_ATTRTCM_DEGTIME");
			var degtimecellshow1TCM = st.getCellShow(i,"DWDMTL1_ATTRTCM_DEGTIME","DWDMTL1_ATTRTCM_DEGTIME");
			
			var bip8modevarTCM = st.getCellStoreValue(i,"DWDMTL1_ATTRTCM_BIP8MODE","DWDMTL1_ATTRTCM_BIP8MODE");
			
			if (cellbip8modeTCM != undefined && (bip8modevarTCM == "POISSON" 
			     || ((bip8modevarTCM != "POISSON") && (bip8modevarTCM != "BURST"))))
			{
				setCellDisable(degthcell1TCM,degthcellshow1TCM);
				setCellDisable(degtimecell1TCM,degtimecellshow1TCM);
			}
		}
	}
}

function refreshTTIState()
{
	for (var i = 0; i < st.getDataRowLength(); i++)
	{
		var ttisapicell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTISAPI");
		var ttisapicellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTISAPI","DWDMTL1_ATTRPM_TTISAPI");
		if (ttisapicell1PM != undefined && ttisapicell1PM != null)
		{
			setCellDisable(ttisapicell1PM,ttisapicellshow1PM);
		}
		var ttidapicell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTIDAPI");
		var ttidapicellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTIDAPI","DWDMTL1_ATTRPM_TTIDAPI");
		if (ttidapicell1PM != undefined && ttidapicell1PM != null)
		{
			setCellDisable(ttidapicell1PM,ttidapicellshow1PM);
		}
		var ttiopercell1PM = st.getCell(i,"DWDMTL1_ATTRPM_TTIOPER");
		var ttiopercellshow1PM = st.getCellShow(i,"DWDMTL1_ATTRPM_TTIOPER","DWDMTL1_ATTRPM_TTIOPER");
		if (ttiopercell1PM != undefined && ttiopercell1PM != null)
		{
			setCellDisable(ttiopercell1PM,ttiopercellshow1PM);
		}
	}
}

function setCellDisable(cell,cellShow)
{
	st.setCellIsEdit(cell,"0");
	cell.element.style.backgroundColor = "";
	cell.element.ondblclick = null;
	cell.element.style.cursor = "";
	cellShow.setValue("-");
}

function setCellStatus(cell,cellShow,isEdit,cellflag,curLevel)
{
	var curLevel = curLevel.toLowerCase();
	if (isEdit == "0")
	{
		cell.element.modify = false;
		st.setCellIsEdit(cell,"0");
		cell.element.style.backgroundColor = "";
		cell.element.ondblclick = null;
		cell.element.style.cursor = "";
		cellShow.setValue("-");
	}
	else
	{
		if (cell.element.isEdit == "0")
		{
			cell.element.modify = false;
			cell.element.parentNode.modify = true;
			st.setCellIsEdit(cell,"1");
			cell.element.style.backgroundColor = "#ffffff";
			cell.element.ondblclick = cellondbclick;
			if (cellflag == 5)
			{
				var defaultvar = 3064;
				if (curLevel.indexOf("odu1") != -1 || curLevel.indexOf("otu1") != -1)
				{
					defaultvar = 3064;
				}
				else if (curLevel.indexOf("odu5g") != -1 || curLevel.indexOf("otu5g") != -1)
				{
					defaultvar = 6127;
				}
				else if (curLevel.indexOf("odu2") != -1 || curLevel.indexOf("otu2") != -1)
				{
					defaultvar = 12304;
				}
				else if (curLevel.indexOf("odu3") != -1 || curLevel.indexOf("otu3") != -1)
				{
					defaultvar = 49424;
				}
				cellShow.setValue(defaultvar);
			}
			else if (cellflag == 6)
			{
				cellShow.setValue("7");
			}
			else if (cellflag == 7)
			{
				cellShow.setValue("1E-3");
			}
			else if (cellflag == 8)
			{
				cellShow.setValue("1E-6");
			}
			else if (cellflag == 9)
			{
				cellShow.setValue("1000");
			}
				
		}
	}
}

/**
 *     OTN    
 * @param doc         sfid:   ID
 * @return  
 */
function handleSetOTNRsp(doc,sfid)
{
	var data = EncapsulateData(doc);	
	
	$("querybtn").disabled = false;
	if(0 != data.getSErrorCode())
	{	
		$("applybtn").disabled = !hasApplyRight; 
	}
	else
	{
		setTIDOnchangeModify("../../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neid,false);
	}
	  
	refreshTableStateForOTN(st, tableconfObj, data);	
	
	showApplyErrorPage(data);
	
}

/**
 *       , TTI      00    
 * @param doc        
 * @return  
 */
function handleReturnData(data,sfid)
{
	var convertDataValue;
	var bdType = winurlobj["boardType"];
	var convertKeys = ['ST_SRC_FLAG','ST_SINK_FLAG','ST_USER_FLAG','SR_SRC_FLAG','SR_SINK_FLAG','SR_USER_FLAG','R_SRC_FLAG','R_SINK_FLAG','R_USER_FLAG'];
	
	if (sfid == 2105849)
	{
		for(var indexopu = data.getDataRowLength()-1; indexopu >= 0; indexopu--)
		{
			if (bdType == BDTYPE_TN11TOM)
			{
				var clntPayload = data.rows[indexopu]["CLNTPLDTYPE"].value;
				if (clntPayload.indexOf("OTU") != -1)
				{
					data.rows.removeAt(indexopu);
					continue;
				}
			}
			
		}
	}
	
	if (sfid == 2106554)
	{
		if (bdType == 1278)
		{
			for(var indexftfl = data.getDataRowLength()-1; indexftfl >= 0; indexftfl--)
			{			
				var clntpayload = data.rows[indexftfl]["CLNTPLDTYPE"].value;
				if (clntpayload.indexOf("OTU") != -1)
				{
					data.rows.removeAt(indexftfl);
				}
				
			}
		}
	}

	for(var index = data.getDataRowLength()-1; index >= 0; index--)
	{
	}
}

/**
 *   TTI  ,        00  
 * @param ttivalue      TTI  
 * @return TTI  
 */
function convertTTIValue(ttivalue)
{
	while(ttivalue.length >= 2)
	{
	   if("00" == ttivalue.substring(ttivalue.length-2,ttivalue.length))
	   {
	   		ttivalue = ttivalue.substring(0,ttivalue.length-2);
	   }
	   else
	   {
	   		break;
	   }
	}
	return ttivalue;
}

/**
 *   TTI  
 * @param cellEle:      colid  ID key:key
 * @return  
 */
function showTTIMgrDialog(cellEle,colid,keyArray)
{
	
	var value = [];
	for(var i = 0,len = keyArray.length; i < len; i++)
	{
		value[i] = cellEle.storeValue[keyArray[i]];
	}
	curCellEle = cellEle;
	curCellkeyArray = keyArray;
	xshowModalDialog("ttimgrdialog.html?srcflag="+value[0]+"&sinkflag="+value[1]+"&userflag="+value[2],RESOURCE["title"],450,300,"../../../../../../../../images/");
}

/**
 *        
 * @param key:key value: 
 * @return  
 */
function refreshCellValue(srcFlag,sinkFlag,userFlag)
{
	var colid = curCellEle.colid;
	var rows = st.getSelectedRows();
	var tmpEle;
	var tempsrcFlag = srcFlag;
	var tempsinkFlag = sinkFlag;
	var tempuserFlag = userFlag;
	var storeSrcFlag = removeSpace(text2Hex(tempsrcFlag));
	var storeSinkFlag = removeSpace(text2Hex(tempsinkFlag));
	var storeUserFlag = removeSpace(text2Hex(tempuserFlag));
	
	for(var i = 0; i < rows.length; i++)
	{
		tmpEle = st.getCellElement(rows[i],colid);
		if(tmpEle.isEdit != 1)
		{
			continue;
		}
		st.setAtomValue(tmpEle.showElement,srcFlag+"-"+sinkFlag+"-"+userFlag);		
		
		tmpEle.currentValue[curCellkeyArray[0]] = storeSrcFlag;
		tmpEle.storeValue[curCellkeyArray[0]] = storeSrcFlag;
		tmpEle.currentValue[curCellkeyArray[1]] = storeSinkFlag;
		tmpEle.storeValue[curCellkeyArray[1]] = storeSinkFlag;
		tmpEle.currentValue[curCellkeyArray[2]] = storeUserFlag;
		tmpEle.storeValue[curCellkeyArray[2]] = storeUserFlag;
		tmpEle.modify = true;
		tmpEle.style.background = "#d0f946";
		tmpEle.parentNode.modify = true;				
	}	
	cellEditHandler();
}

/**
 *               
 * @param  
 * @return  
 */
function cellEditHandler(param)
{	
	if(param.colid.indexOf("BIP8MODE") >0)
	{
		var indexPM =param.rowindex;
		var bip8PM = st.getCellEdit(indexPM, param.colid);
		var bdType = winurlobj["boardType"];
		if (bdType == 2426 || bdType == 2295)
		{
			bip8PM.clearOptions();
			bip8PM.addOption("BURST","BURST");
		}
	}
	
	if (((param.colid == "DWDMTL1_ATTRPM_BIP8MODE") && (param.stage == TABLE_CONSTANT.BEFOREEDIT)))
	{		
		var indexPM =param.rowindex;
		var bip8PM = st.getCellEdit(indexPM, param.colid);
		var mod2ofrowarr = st.getCellStoreValue(indexPM,"mode2","mode2");
		var aidstrr = parseMod2Str(mod2ofrowarr,"AID");
		var mode2Arr = mod2ofrowarr.split(",");
		var mod2ofrow = mode2Arr[2];
			
		var currentOdun = mode2Arr[mode2Arr.length - 1];
		var bdType = winurlobj["boardType"];
		if (bdType == 1318)
		{
			if(aidstrr.indexOf("CLNT") != -1)
			{
				bip8PM.clearOptions();
				bip8PM.addOption("BURST","BURST");
			}
			else
			{
				bip8PM.clearOptions();
				bip8PM.addOption("POISSON","POISSON");
				bip8PM.addOption("BURST","BURST");
			}
		}
		else if (bdType == 1620) //F1ELOM ODU0         
		{
			if (currentOdun.indexOf("ODU0")!=-1)
			{
				bip8PM.clearOptions();
			    bip8PM.addOption("BURST","BURST");		
			}
			else
			{
				bip8PM.clearOptions();
				bip8PM.addOption("BURST","BURST");
				bip8PM.addOption("POISSON","POISSON");			
			}
		}
		else if (bdType == 2415)
		{
			if (currentOdun.indexOf("ODUFLEX")!=-1)
			{
				bip8PM.clearOptions();
			    	bip8PM.addOption("BURST","BURST");		
			}
			else
			{
				bip8PM.clearOptions();
				bip8PM.addOption("BURST","BURST");
				bip8PM.addOption("POISSON","POISSON");			
			}
		}

	}
	
	
	if (((param.colid == "DWDMTL1_ATTRPM_DEGTIME") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
		|| ((param.colid == "DWDMTL1_ATTRSM_DEGTIME") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
		|| ((param.colid == "DWDMTL1_ATTRTCM_DEGTIME") && (param.stage == TABLE_CONSTANT.BEFOREEDIT)))
	{
		var degtime = st.getCellEdit(param.rowindex, param.colid).element;
		
		degtime.style.imeMode = "disabled";
		
		
		degtime.onkeypress = function()
	    {
            var evt= EventUtil.getEvent();
	        return digitalCheck(degtime, MIN_DEGTIMES, "10", null, null, evt);        		
	    }
		
		degtime.onblur = function()
	    {
	    	return numCellOnBlur(degtime,MIN_DEGTIMES,"10");
	    }
	}
	
	if (((param.colid == "DWDMTL1_ATTRSM_DEGTH") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
		|| ((param.colid == "DWDMTL1_ATTRPM_DEGTH") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
		|| ((param.colid == "DWDMTL1_ATTRTCM_DEGTH") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
		)
	{
		var degth = st.getCellEdit(param.rowindex, param.colid).element;
		
		var mod2var = st.getCellStoreValue(param.rowindex,"mode2","mode2");
		
		var degIntervalCellValue = null;
		var degIntervalCell = null;
		if (param.colid == "DWDMTL1_ATTRSM_DEGTH" && null != st.getCell(param.rowindex, "DWDMTL1_ATTRSM_DEGINTERVAL"))
		{
			degIntervalCellValue = st.getCellStoreValue(param.rowindex, "DWDMTL1_ATTRSM_DEGINTERVAL", "DWDMTL1_ATTRSM_DEGINTERVAL");
		}
		else if (param.colid == "DWDMTL1_ATTRPM_DEGTH" && null != st.getCell(param.rowindex, "DWDMTL1_ATTRPM_DEGINTERVAL"))
		{
			degIntervalCellValue = st.getCellStoreValue(param.rowindex, "DWDMTL1_ATTRPM_DEGINTERVAL", "DWDMTL1_ATTRPM_DEGINTERVAL");
		}
		else if(param.colid == "DWDMTL1_ATTRTCM_DEGTH" && null != st.getCell(param.rowindex, "DWDMTL1_ATTRTCM_DEGINTERVAL"))
		{
			degIntervalCellValue = st.getCellStoreValue(param.rowindex, "DWDMTL1_ATTRTCM_DEGINTERVAL", "DWDMTL1_ATTRTCM_DEGINTERVAL");
		}

		var mod2 = parseMode2Str(mod2var, "OTNMODE2");

		degth.style.imeMode = "disabled";
		
		var max_degthValue = 0;
		if ((mod2.indexOf("OTU0") != -1) || (mod2.indexOf("ODU0") != -1))
		{
			if (netype == 66)
			{
				degth.onkeypress = function()
			    {
		            var evt= EventUtil.getEvent();
			        return digitalCheck(degth, MIN_DEGTH, MAX_DEGTH0_1800A, null, null, evt);    	
			    }
			    
			    degth.onblur = function()
			    {
			    	return numCellOnBlur(degth,MIN_DEGTH,MAX_DEGTH0_1800A);
			    }
			}
			else
			{
				if (null != degIntervalCellValue)
				{
					if (degIntervalCellValue == 1000)
					{
						max_degthValue = "10167";
					}
					else if (degIntervalCellValue == 100)
					{
						max_degthValue = "1016";
					}
					else
					{
						max_degthValue = "101";
					}
				}
				else
				{
					max_degthValue = MAX_DEGTH0;
				}
				degth.onkeypress = function()
			    {
		            var evt= EventUtil.getEvent();
			        return digitalCheck(degth, MIN_DEGTH, max_degthValue, null, null, evt);    	
			    }
			    
			    degth.onblur = function()
			    {
			    	return numCellOnBlur(degth,MIN_DEGTH,max_degthValue);
			    }
			}
		}
		else if ((mod2.indexOf("OTU1") != -1) || (mod2.indexOf("ODU1") != -1))
		{
			if (netype == 66)
			{
				degth.onkeypress = function()
			    {
		            var evt= EventUtil.getEvent();
			        return digitalCheck(degth, MIN_DEGTH, MAX_DEGTH1_1800A, null, null, evt);    	
			    }
			    
			    degth.onblur = function()
			    {
			    	return numCellOnBlur(degth,MIN_DEGTH,MAX_DEGTH1_1800A);
			    }
			}
			else
			{
				if (null != degIntervalCellValue)
				{
					if (degIntervalCellValue == 1000)
					{
						max_degthValue = "20420";
					}
					else if (degIntervalCellValue == 100)
					{
						max_degthValue = "2042";
					}
					else
					{
						max_degthValue = "204";
					}
				}
				else
				{
					max_degthValue = MAX_DEGTH1;
				}
				degth.onkeypress = function()
			    {
		            var evt= EventUtil.getEvent();
			        return digitalCheck(degth, MIN_DEGTH, max_degthValue, null, null, evt);    	
			    }
			    
			    degth.onblur = function()
			    {
			    	return numCellOnBlur(degth,MIN_DEGTH,max_degthValue);
			    }
			}
		}
		else if ((mod2.indexOf("OTU2") != -1) || (mod2.indexOf("ODU2") != -1))
		{
			if (netype == 66)
			{
				degth.onkeypress = function()
			    {
		            var evt= EventUtil.getEvent();
			        return digitalCheck(degth, MIN_DEGTH, MAX_DEGTH2_1800A, null, null, evt);    	
			    }
			    
			    degth.onblur = function()
			    {
			    	return numCellOnBlur(degth,MIN_DEGTH,MAX_DEGTH2_1800A);
			    }
			}
			else
			{
				if (null != degIntervalCellValue)
				{
					if (degIntervalCellValue == 1000)
					{
						max_degthValue = "82025";
					}
					else if (degIntervalCellValue == 100)
					{
						max_degthValue = "8202";
					}
					else
					{
						max_degthValue = "820";
					}
				}
				else
				{
					max_degthValue = MAX_DEGTH2;
				}
				degth.onkeypress = function()
			    {
		            var evt= EventUtil.getEvent();
			        return digitalCheck(degth, MIN_DEGTH, max_degthValue, null, null, evt);    	
			    }
			    
			    degth.onblur = function()
			    {
			    	return numCellOnBlur(degth,MIN_DEGTH,max_degthValue);
			    }
			}
		}
		else if ((mod2.indexOf("OTU3") != -1) || (mod2.indexOf("ODU3") != -1))
		{
			if (null != degIntervalCellValue)
			{
				if (degIntervalCellValue == 1000)
				{
					max_degthValue = "329491";
				}
				else if (degIntervalCellValue == 100)
				{
					max_degthValue = "32949";
				}
				else
				{
					max_degthValue = "3294";
				}
			}
			else
			{
				max_degthValue = MAX_DEGTH3;
			}
			degth.onkeypress = function()
		    {
		        var evt= EventUtil.getEvent();
		        return digitalCheck(degth, MIN_DEGTH, max_degthValue, null, null, evt);    	
		    }
		    
		    degth.onblur = function()
		    {
		    	return numCellOnBlur(degth,MIN_DEGTH,max_degthValue);
		    }
		}
		else if ((mod2.indexOf("OTU4") != -1) || (mod2.indexOf("ODU4") != -1))
		{
			if (null != degIntervalCellValue)
			{
				if (degIntervalCellValue == 1000)
				{
					max_degthValue = "856387";
				}
				else if (degIntervalCellValue == 100)
				{
					max_degthValue = "85638";
				}
				else
				{
					max_degthValue = "8563";
				}
			}
			else
			{
				max_degthValue = MAX_DEGTH4;
			}
			degth.onkeypress = function()
		    {
		        var evt= EventUtil.getEvent();
		        return digitalCheck(degth, MIN_DEGTH, max_degthValue, null, null, evt);    	
		    }
		    
		    degth.onblur = function()
		    {
		    	return numCellOnBlur(degth,MIN_DEGTH,max_degthValue);
		    }
		}
		else if ((mod2.indexOf("OTU5G") != -1) || (mod2.indexOf("ODU5G") != -1))
		{
			if (netype == 66)
			{
				degth.onkeypress = function()
			    {
		            var evt= EventUtil.getEvent();
			        return digitalCheck(degth, MIN_DEGTH, MAX_DEGTH5G_1800A, null, null, evt);    	
			    }
			    
			    degth.onblur = function()
			    {
			    	return numCellOnBlur(degth,MIN_DEGTH, MAX_DEGTH5G_1800A);
			    }
			}
			else
			{
				if (null != degIntervalCellValue)
				{
					if (degIntervalCellValue == 1000)
					{
						max_degthValue = "41012";
					}
					else if (degIntervalCellValue == 100)
					{
						max_degthValue = "4101";
					}
					else
					{
						max_degthValue = "410";
					}
				}
				else
				{
					max_degthValue = MAX_DEGTH5G;
				}
				degth.onkeypress = function()
			    {
		            var evt= EventUtil.getEvent();
			        return digitalCheck(degth, MIN_DEGTH, max_degthValue, null, null, evt);    	
			    }
			    
			    degth.onblur = function()
			    {
			    	return numCellOnBlur(degth,MIN_DEGTH,max_degthValue);
			    }
			}
		}
		else if ((mod2.indexOf("ODUFLEX") != -1))
		{		
			if (null != degIntervalCellValue)
			{
				if (degIntervalCellValue == 1000)
				{
					max_degthValue = "66086";
				}
				else if (degIntervalCellValue == 100)
				{
					max_degthValue = "6608";
				}
				else
				{
					max_degthValue = "660";
				}
			}
			else
			{
				max_degthValue = MAX_DEGTHODUFlex;
			}
			degth.onkeypress = function()
		    {
	            var evt= EventUtil.getEvent();
		        return digitalCheck(degth, MIN_DEGTH, max_degthValue, null, null, evt);    	
		    }
		    
		    degth.onblur = function()
		    {
		    	return numCellOnBlur(degth,MIN_DEGTH,max_degthValue);
		    }
			
		}
	}
	
	if (netype == 66 && !isNewNEVersion(wintopobj))
	{
		if ((param.colid == "DWDMTL1_ATTRSM_TIMMODE") && (param.stage == TABLE_CONSTANT.BEFOREEDIT)
		    || (param.colid == "DWDMTL1_ATTRPM_TIMMODE") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
		{
			var cellEdit = st.getCellEdit(i, param.colid);
			cellEdit.clearOptions();
			cellEdit.addOption("SAPI","SAPI");
			cellEdit.addOption("DAPI","DAPI");
			cellEdit.addOption("BOTH","BOTH");
		}
	}
	
	
	
	if(hasApplyRight)
	{
		$("applybtn").disabled = !hasApplyRight; 
	}
	
	if (param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		setTIDOnchangeModify("../../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+neid,true);
	}
	
}

function parseMode2Str(mode2Str, attrID)
{
	var mod2arr = mode2Str.split(",");
	
	if (mod2arr.length == 1)
	{
		return mode2Str;
	}
		
	for (var i = 0; i < mode2Str.length; i++)
	{
		if (mod2arr[i] == attrID)
		{
			return mod2arr[i+1];
		}
	}
}

/**
 *         
 */
function showApplyErrorPage(data)
{
    var attrId = null;
    for(var i = data.getBErrLength() - 1; i >= 0; i--)
	{		   
		attrId = data.getBErrParam(i, "attrId");
		
		if (null != attrId && "" != attrId)    	
    	{   	   
    	    var str = attrId.split(",");
    	    var operobj;
    	    if (getAttrName(tableconfObj, str[0]))
    	    {
    	        operobj = getAttrName(tableconfObj, str[0]);
    	    }
    	    else
    	    {
    	        operobj = str[0];
    	    }
    	    for (var j=1,len = str.length;j<len;j++)
    	    {
	    	    if (getAttrName(tableconfObj, str[j]))
	    	    {
	    	        operobj += "," + getAttrName(tableconfObj, str[j]);
	    	    }
	    	    else
	    	    {
	    	        operobj += "," + str[j];
	    	    }
    	    }
    	    
    	     data.errObj.rowErrors[i].errorObj.attrId = operobj;
    	}		
	
	}
	var errArr = [];
    errArr.push("neObj");
    errArr.push("attrId");
    
    openErrPage("../../../../../../../page/", data.getError(), errArr);
}

/**
 *         
 * @param doc        
 * @return  
 */
function showErrorPage(data,flag,sfid)
{
	var errArr = [];
	var errStrArr = new Array();
	var temperrObj;
	var temperrStr;
	for(var i = data.getBErrLength() - 1; i >= 0; i--)
	{	
		var attrName = getAttrName(tableconfObj,data.getError().getRowKey(i,"attrId"));
		if(attrName == "srcdesflag")
		{
			data.getError().rowErrors.splice(i,1);
			continue;
		}
		
		if (sfid == QUERY_SM_CMD || sfid == SET_SM_CMD)
		{
			data.getError().rowErrors[i].errorObj["grade"] = otuGrade[data.getError().rowErrors[i].errorObj["grade"]];
		}
		else
		{
			data.getError().rowErrors[i].errorObj["grade"] = oduGrade[data.getError().rowErrors[i].errorObj["grade"]];
		}
		
		if(sfid == QUERY_TCM_CMD || sfid == SET_TCM_CMD)
		{
			data.getError().rowErrors[i].errorObj["level"] = otnOphLevel[data.getError().rowErrors[i].errorObj["level"]];
		}
		
		if(language == "zh"){
			data.getError().rowErrors[i].errorObj["attrId"] = RESOURCE[flag] + attrName;
		}
		else{
			data.getError().rowErrors[i].errorObj["attrId"] = RESOURCE[flag] + " " + attrName;
		}
		temperrObj = data.getError().rowErrors[i].errorObj;
		temperrStr = temperrObj["portname"] + temperrObj["grade"] + temperrObj["path"] + temperrObj["attrId"] + data.getBErrorCode(i);
		if(errStrArr.contains(temperrStr))
		{
		    data.getError().rowErrors.splice(i, 1);
		}
		else
		{
		    errStrArr[errStrArr.length] = temperrStr;
		}
	}
	errArr.push("nename");
	errArr.push("slotid");
	errArr.push("boardname");
	errArr.push("portname");
	errArr.push("grade");
	errArr.push("path");
	if(sfid == QUERY_TCM_CMD || sfid == SET_TCM_CMD)
	{
		errArr.push("level");
	}
	errArr.push("attrId");
	openErrPage("../../../../../../../page/",data.getError(),errArr);
}

/**
 *         
 * @param   
 * @return  
 */
function sendQueryRightReq(querySfid,applySfid)
{
	var url = "../../../../../../../securityServlet?neID="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
	loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML(querySfid,applySfid));
}

/**
 *           
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
    
	for(var i = 0; i < data.getDataRowLength(); i++)  //       
    {
    	if(0 == data.getDataRowParam(i,"right"))
    	{
    		if(data.getDataRowParam(i,"type") == "query")
    		{
    			hasQueryRight = false;    			
    		}
    		else
    		{
    			hasApplyRight = false;
    		}   		   		
    	}     	    
    } 
    $("querybtn").disabled = !hasQueryRight;
    $("stateBtn").disabled = !hasApplyRight;
    $("applybtn").disabled = true; 
}
 
/**
 *           XML
 * @param  
 * @return  
 */ 
function createRightXML(querySfid,applySfid)
{
	var root = new inputxml("datainterface");//Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	secondlevel = new tagElement("row-params"); //bean         	
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","type");
	thirdlevel.setAttribute("value","query");
	secondlevel.appendChild(thirdlevel);	
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",querySfid);
	secondlevel.appendChild(thirdlevel);	
	firstlevel.appendChild(secondlevel);
	
	secondlevel = new tagElement("row-params"); //bean         
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","type");
	thirdlevel.setAttribute("value","apply");
	secondlevel.appendChild(thirdlevel);	
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",applySfid);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function popupMenuHandler(evt)
{
  	if(!evt)
  	{
  	  evt= window.event;	
  	}
  	 
    var elem = (evt.target) ? evt.target : evt.srcElement;   

    if(elem!= null&&elem.blur)
    {
    	elem.blur();	  	
    }
   
   while(elem!=null)
	 {
	    if(elem.tagName == 'TD')
	    {
	        break;	
	    }
	    else
	    {
		    elem =elem.parentNode;	  	
	    }	
   } 
  
	if(elem == null || elem.tagName != 'TD' || null == elem.parent || elem.editElement == null)
	{
		  return;
	}  
	var bdType = winurlobj["boardType"];
	var rowid= elem.parentNode.rowIndex;
    var rows =elem.parent.getSelectedRows();
    var colid = elem.colid;
    if(rows.contains(rowid))
    {
    	if (colid == "DWDMTL1_ATTRSM_DEGTH" || colid == "DWDMTL1_ATTRPM_DEGTH" || colid == "DWDMTL1_ATTRTCM_DEGTH")
    	{
    		if (rows.length > 1)
    		{
    			return;
    		}
    	}
    	
    	if (colid == "DWDMTL1_ATTRPM_BIP8MODE")
    	{
			var bip8PM = st.getCellEdit(rowid, colid);
			var mod2ofrowarr = st.getCellStoreValue(rowid,"mode2","mode2");
			var aidstrr = parseMod2Str(mod2ofrowarr,"AID");
			var mode2Arr = mod2ofrowarr.split(",");
			var mod2ofrow = mode2Arr[2];
				
			var currentOdun = mode2Arr[mode2Arr.length - 1];
			var bdType = winurlobj["boardType"];
			if (bdType == 1318)
			{
				if (rows.length > 1)
	    		{
	    			return;
	    		}
				if(aidstrr.indexOf("CLNT") != -1)
				{
					bip8PM.clearOptions();
					bip8PM.addOption("BURST","BURST");
				}
				else
				{
					bip8PM.clearOptions();
					bip8PM.addOption("POISSON","POISSON");
					bip8PM.addOption("BURST","BURST");
				}
			}
			else if (bdType == 1620) //F1ELOM ODU0         
			{
				if (rows.length > 1)
	    		{
	    			return;
	    		}
				if (currentOdun.indexOf("ODU0")!=-1)
				{
					bip8PM.clearOptions();
				    bip8PM.addOption("BURST","BURST");		
				}
				else
				{
					bip8PM.clearOptions();
					bip8PM.addOption("BURST","BURST");
					bip8PM.addOption("POISSON","POISSON");			
				}
			}
    	}

    	if(null != elem.editElement && elem.isEdit == 1)
    	{
    		  if(ttiCols.contains(colid))
    			{
    				elem.ondblclick();
    			}
    			else
    			{
    			  createTablePopupMenu(elem,evt);
    			}
    			return;
    	}
    	
    	for(var i = 0; i < rows.length; i++)
    	{
    		var tmpElem = elem.parent.getCellElement(rows[i],colid);
    		if(null != tmpElem.editElement && tmpElem.isEdit == 1)
    		{
    			 if(ttiCols.contains(colid))
    			 {
    				  tmpElem.ondblclick();
    			 }
    			else
    			{
    			   createTablePopupMenu(tmpElem,evt);
    			}
    			 return;
    		}
    	}
    }    
}

function createjsDOMenu(menuType)
{
    selectedRows = st.getSelectedRows();
    if (selectedRows.length < 1)
    {
        alert(RESOURCE["UnSelectData"]);
        return;
    }
    removejsDOMmenu();

    var cursorMenu1 = new jsDOMenu(150); 

    if(menuType == 0)
	{
	    cursorMenu1.addMenuItem(new menuItem(RESOURCE["STATE_IS"],"",setState,"IS"));         

        cursorMenu1.addMenuItem(new menuItem(RESOURCE["STATE_OOS"],"",setState,"OOS"));
    
        /**
         * DTS2012051102162
         * 68,88 OTN     AINS     ,18    
         */
        if (wintopobj['neType'] == OSN_1800_A)
        {
        	cursorMenu1.addMenuItem(new menuItem(RESOURCE["STATE_AINS"],"",setState,"AINS"));
        }
	}
	else if(menuType == 1)
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["MAINTENANCE_RMV"],"",setMaintenance,"Remove")); 

        cursorMenu1.addMenuItem(new menuItem(RESOURCE["MAINTENANCE_RST"],"",setMaintenance,"Restore"));
	}
	else
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["unkown"],"",null,null)); 
	}

    setPopUpMenu(cursorMenu1);
}

/**
 *          XML  
 * @param neid:  ID slotid:  ID tc:        
 * @return String:       XML  
 */
function createSetXML(neid,st,tc,sfid)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var rowData = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    var lckflag = false;
    for(var rowindex = 0,rowlen = st.getDataRowLength();rowindex<rowlen;rowindex++)
    {
    	if(!st.getModify(rowindex))
    	{
    		continue;
    	}
        rowData = st.getRow();
    	row = new tagElement("row-params");
    	param = new tagElement("param");
		param.setAttribute("name","neid");
		param.setAttribute("value",neid); 
		row.appendChild(param);	
		
		if (sfid == TE_FUNC_SFG_PM_OVERHEAD)//PM  
		{
			var sfberpm = st.getCellStoreValue(rowindex,"DWDMTL1_ATTRPM_SFBER","DWDMTL1_ATTRPM_SFBER");
			var sdberpm = st.getCellStoreValue(rowindex,"DWDMTL1_ATTRPM_SDBER","DWDMTL1_ATTRPM_SDBER");
			if (sfberpm != null && sfberpm != undefined && sdberpm != null && sdberpm != undefined)
			{
				sfberpm = sfberpm.split("-")[1];
				sdberpm = sdberpm.split("-")[1];
				if (sfberpm >= sdberpm)
				{
					alert(RESOURCE["def_lt_cro"]);
					return null;
				}
			}
		}
		
		if (sfid == TE_FUNC_SFG_SM_OVERHEAD)//SM  
		{
			var sfberpm = st.getCellStoreValue(rowindex,"DWDMTL1_ATTRSM_SFBER","DWDMTL1_ATTRSM_SFBER");
			var sdberpm = st.getCellStoreValue(rowindex,"DWDMTL1_ATTRSM_SDBER","DWDMTL1_ATTRSM_SDBER");
			if (sfberpm != null && sfberpm != undefined && sdberpm != null && sdberpm != undefined)
			{
				sfberpm = sfberpm.split("-")[1];
				sdberpm = sdberpm.split("-")[1];
				if (sfberpm >= sdberpm)
				{
					alert(RESOURCE["def_lt_cro"]);
					return null;
				}
			}
		}
		
		if (sfid == TE_FUNC_SFG_TCM_OVERHEAD)//TCM  
		{
			var sfberpm = st.getCellStoreValue(rowindex,"DWDMTL1_ATTRTCM_SFBER","DWDMTL1_ATTRTCM_SFBER");
			var sdberpm = st.getCellStoreValue(rowindex,"DWDMTL1_ATTRTCM_SDBER","DWDMTL1_ATTRTCM_SDBER");
			if (sfberpm != null && sfberpm != undefined && sdberpm != null && sdberpm != undefined)
			{
				sfberpm = sfberpm.split("-")[1];
				sdberpm = sdberpm.split("-")[1];
				if (sfberpm >= sdberpm)
				{
					alert(RESOURCE["def_lt_cro"]);
					return null;
				}
			}
		}
		
    	for(var colindex = 0,collen = st.getColumnCount();colindex<collen;colindex++)
    	{
    		colid = tc.getColId(colindex);
   			if(!lckflag && (colid == "DWDMTL1_ATTRPM_LCKEN" || colid == "DWDMTL1_ATTRTCM_LCKEN"))
   			{
   				var curValue = st.getCellStoreValue(rowindex, colid, colid);    				
	   			if(curValue == "ENABLE" && st.getCellModify(rowindex, colid))
	   			{
	   				var flag = confirm(RESOURCE["LCK_ALARM"]);
	   				if(!flag)
	   				{
	   				  	return ;
	   				}	
	   				else
	   				{
	   					lckflag = true;		
	   				}
	   			}  
   			}     		
    		cellModifyFlag = st.getCellModify(rowindex,colid);
    		colkeyarray = tc.getColKeyArray(colindex);
    		for(var keyindex = 0,keylen = colkeyarray.length;keyindex<keylen;keyindex++)
    		{
    			param = new tagElement("param");
    			key = colkeyarray[keyindex].name;
    			param.setAttribute("name",key);
    			if ("DWDMTL1_ATTRTCM_TTISAPI" == key || "DWDMTL1_ATTRTCM_TTIDAPI" == key
    				|| "DWDMTL1_ATTRTCM_TTIOPER" == key || "DWDMTL1_ATTRTCM_EXPTTISAPI" == key
    				|| "DWDMTL1_ATTRTCM_EXPTTIDAPI" == key
    			    ||"DWDMTL1_ATTRPM_TTISAPI" == key || "DWDMTL1_ATTRPM_TTIDAPI" == key
    				|| "DWDMTL1_ATTRPM_TTIOPER" == key || "DWDMTL1_ATTRPM_EXPTTISAPI" == key
    				|| "DWDMTL1_ATTRPM_EXPTTIDAPI" == key
    			    ||"DWDMTL1_ATTRSM_TTISAPI" == key || "DWDMTL1_ATTRSM_TTIDAPI" == key
    				|| "DWDMTL1_ATTRSM_TTIOPER" == key || "DWDMTL1_ATTRSM_EXPTTISAPI" == key
    				|| "DWDMTL1_ATTRSM_EXPTTIDAPI" == key || "DWDMTL1_ATTRFTFL_FTFLOPER" == key)
  				{
  					param.setAttribute("value","\""+st.getCellStoreValue(rowindex,colid,key)+"\"");
  				}
  				else
    			{
    				param.setAttribute("value",st.getCellStoreValue(rowindex,colid,key));
    			}
    			param.setAttribute("modifyFlag",cellModifyFlag); 
    			
    			 if(cellModifyFlag)
    			 {
                		changedRows.push(rowindex);
    			 }

    			row.appendChild(param);		
    		}    		
    	}
    	bussiness.appendChild(row);
    } 
    if(0 == bussiness.childNodes.length)
    {
    	alert(RESOURCE["osinochange"]);
    	return null;
    }  
     di.getRoot().appendChild(bussiness);
     return di.toString();
}

function getPST()
{
	var pstStr;
	if(ophLevel=="pm")
	{
		pstStr="DWDMTL1_ATTRPM_PST";
	}
		if (ophLevel=="ftfl")
	{
		pstStr="DWDMTL1_ATTRFTFL_PST";
	}
	if (ophLevel=="opu")
	{
		pstStr="DWDMTL1_ATTROPU_PST";
	}
	if(ophLevel=="sm")
	{
		pstStr="DWDMTL1_ATTRSM_PST";
	}
	if(ophLevel=="tcm")
	{
		pstStr="DWDMTL1_ATTRTCM_PST";
	}
	return pstStr;
}

function getSST()
{
	var sstStr;	
	if(ophLevel=="pm")
	{
		sstStr="DWDMTL1_ATTRPM_SST";
	}
	if (ophLevel=="ftfl")
	{
		sstStr="DWDMTL1_ATTRFTFL_SST";
	}
	if(ophLevel=="opu")
	{
		sstStr="DWDMTL1_ATTROPU_SST";
	}
	if(ophLevel=="sm")
	{
		sstStr="DWDMTL1_ATTRSM_SST";
	}
	if(ophLevel=="tcm")
	{
		sstStr="DWDMTL1_ATTRPM_SST";
	}
	return sstStr;
}
function setState(state)
{
	var state = state;
	modifyRowArray.clear();
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var selectrows = st.getSelectedRows();
    for (var i = 0; i < selectrows.length; i++)
    {
	    var row = new tagElement("row-params");
	    var param = new tagElement("param");
	    param.setAttribute("name", "neid");
	    param.setAttribute("value", getNeProperty(top).neid);
	    row.appendChild(param);
        
	    var mode2Str = st.getCellCurrentValue(selectrows[i],"mode2","mode2");
	    if(mode2Str != null)
	    {
	    param = new tagElement("param");
	    param.setAttribute("name","mode2");
	    param.setAttribute("value",mode2Str);
	    row.appendChild(param);
		    modifyRowArray[i] = mode2Str;
	    }
	    
	    param = new tagElement("param");
		param = new tagElement("param");
	    if(state=="IS"||state=="OOS")
	    {
	    	param.setAttribute("name", getPST());
	    	param.setAttribute("value", state);
	    }
	    else if(state == "AINS")
	    {
	    	param.setAttribute("name", getSST());
	    	param.setAttribute("value", state);
	    }
	    row.appendChild(param);
	    bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    if(ophLevel == "ftfl")
    {
    	sfid = TECMDCODE_SET_FTFL_OVERHEAD;    //2106555
    }
    else if (ophLevel == "opu")
    {
    	sfid = TE_FUNC_SFG_OPU_OVERHEAD;
    }
    else
    {
    	sfid = TE_FUNC_SFG_SM_OVERHEAD;
    }
    urlreq ="../../../../../../../tl1NEExlorerServlet?sfid="+sfid+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",false,stateCallback,null,"inputdata="+di.toString());
}

function stateCallback(doc)
{
	
	var result = EncapsulateData(doc);
	var verString = "";
    if(0 != result.getError().getGlobleECode())
    {
    	for(var i = 0, len = result.getBErrLength(); i < len; i++)
			{		
				result.getError().rowErrors[i].errorObj["attrId"] = RESOURCE["statebutton"];
			}
 		var oArray = new Array();
        oArray[0]= "nename";
        oArray[1]= "slotID";
        oArray[2]= "boardname";
        oArray[3]= "portname";
        oArray[4]= "attrId";
        openErrPage("../../../../../../../page/",result.getError(),oArray);
        return;
    }
    else
    {
    	sendQueryPortState();
    }
}
/**
 *       
 */
function sendQueryPortState()
{
	var urlreq ="../../../../../../../tl1NEExlorerServlet?sfid="+currentSFID+"&nmUser="+winurlobj["nmUser"];	

  var inputData = createPortPathQueryXML(neid,slotid,tableconfObj);
    
	loadXMLdoc(urlreq,"POST",true, queryPortStateCallBack,currentSFID ,"inputdata="+inputData);
}

function queryPortStateCallBack(doc)
{
	var data = EncapsulateData(doc);
  var len = data.getDataRowLength();
  var diobj = null;

  for(var i = len -1; i >= 0; i--)
  {
  	diobj = data.rows[i];
  	var aid = diobj["AID"].value;
  	if(null != diobj["DWDMTL1_ATTRSM_PST"])
  	{
  		setPortStateStr(aid,"DWDMTL1_ATTRSM_PST",diobj["DWDMTL1_ATTRSM_PST"].value);
  	}
  	else if (currentSFID == 2106554)//FTFL  
  	{
  		if (null != diobj["DWDMTL1_ATTRFTFL_PST"])
  		{
  			setPortStateStr(aid,"DWDMTL1_ATTRFTFL_PST",diobj["DWDMTL1_ATTRFTFL_PST"].value);
  		}
  	}
  	else if(null != diobj["DWDMTL1_ATTRPM_PST"])
  	{
  		setPortStateStr(aid,"DWDMTL1_ATTRPM_PST",diobj["DWDMTL1_ATTRPM_PST"].value);
  	}
  	else if(null != diobj["DWDMTL1_ATTRTCM_PST"])
  	{
  		if (null != diobj["level"])
  		{
  			setPortStateStrForTCM(aid,"DWDMTL1_ATTRTCM_PST",diobj["DWDMTL1_ATTRTCM_PST"].value,diobj["level"].value);
  		}
  	}
  	else if(null != diobj["DWDMTL1_ATTROPU_PST"])
  	{
  		setPortStateStr(aid,"DWDMTL1_ATTROPU_PST",diobj["DWDMTL1_ATTROPU_PST"].value);
  	}
  }
}

function setPortStateStrForTCM(obj,name,value,level)
{
	var templevel = getTCMLevel(level);
	var selectrows = st.getSelectedRows();
	for (var i = 0; i < selectrows.length; i++)
    {
	  	var aid = st.getCellShow(selectrows[i],"operaObj").getValue();
	  	var stlevel = st.getCellShow(selectrows[i],"level").getValue();

	  	if(aid == obj && stlevel == templevel)
	  	{
	  		st.setAtomValue(st.getCellShow(selectrows[i],name),value);
	  		break;
	  	}
	}
}

function setPortStateStr(obj,name,value)
{
	var selectrows = st.getSelectedRows();
	for (var i = 0; i < selectrows.length; i++)
  {
  	var aid = st.getCellShow(selectrows[i],"operaObj").getValue();
  	if(aid == obj)
  	{
  		st.setAtomValue(st.getCellShow(selectrows[i],name),value);
  		break;
  	}
	}
}
function setMaintenance(mntn)
{
	var mntn = mntn;
	modifyRowArray.clear();
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var selectrows = st.getSelectedRows();
    for (var i = 0; i < selectrows.length; i++)
    {
	    var row = new tagElement("row-params");
	    var param = new tagElement("param");
	    param.setAttribute("name", "neid");
	    param.setAttribute("value", getNeProperty(top).neid);
	    row.appendChild(param);
	    
	    var mode2Str = st.getCellCurrentValue(selectrows[i],"mode2","mode2");
	    
	    var specmode2 = parseMode2Str(mod2var, "OTNMODE2");
	    	    

        modifyRowArray[i] = mode2Str;
	    
	    param = new tagElement("param");
	    param.setAttribute("name","mode2");
	    param.setAttribute("value",mode2Str);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name","specmode2");
	    param.setAttribute("value",specmode2);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
		param = new tagElement("param");
	    if(mntn=="Remove")
        {
    	    param.setAttribute("name", "DWDMTL_ATTRPORT_RMV");
    	    param.setAttribute("value", mntn);
        }
        else if(mntn == "Restore")
        {
    	    param.setAttribute("name", "DWDMTL_ATTRPORT_RST");
    	    param.setAttribute("value", mntn);
        }
	    row.appendChild(param);
	    bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    urlreq ="../../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_SET_W32PORTATTRIB+"&nmUser="+winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST",false,maintenanceCallback,null,"inputdata="+di.toString());
}

function maintenanceCallback(doc)
{
	var result = EncapsulateData(doc);
	var verString = "";
    if(0 != result.getError().getGlobleECode())
    {
    	for(var i = 0, len = result.getBErrLength(); i < len; i++)
			{		
				result.getError().rowErrors[i].errorObj["attrId"] = RESOURCE["maintenancebutton"];
			}
 		var oArray = new Array();
        oArray[0]= "AID";
        oArray[1]= "attrId";
        openErrPage("../../../../../../../page/",result.getError(),oArray);
        return;
    }
}

function createPortPathQueryXML(neid,slotid,tableconf)
{

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    if(null != slotid && "" != slotid)
     {
     	  param = new tagElement("param");
          param.setAttribute("name","slotid");
          param.setAttribute("value",slotid);
          row.appendChild(param);
          param = new tagElement("param");
          param.setAttribute("name","srcObjType");
          param.setAttribute("value","ID_OBJECT_TYPE_NE_BOARD");
          row.appendChild(param);          
     }
     else
     {
     	param = new tagElement("param");
     	param.setAttribute("name","srcObjType");
        param.setAttribute("value","ID_OBJECT_TYPE_NE");
        row.appendChild(param);
     }
     var colid ;
     for(var i = 1; i < tableconf.getColsLength();i++)
     {
         colid = tableconf.getColId(i);
      
         param = new tagElement("param");
         param.setAttribute("name","attrId");
         param.setAttribute("value",colid);
         row.appendChild(param);       
     }
     
      
      for (var i=0,len = modifyRowArray.length;i<len;i++)
      {
      
            var currMod2 = parseMode2Str(modifyRowArray[i],"OTNMODE2");            
            
            var param = new tagElement("param");
            var facAid = parseMode2Str(modifyRowArray[i],"AID");
            param.setAttribute("name","FACAID");
            param.setAttribute("value",facAid + ":" + currMod2);           
            row.appendChild(param);          
           
      }  
      
     bussiness.appendChild(row); 

     di.getRoot().appendChild(bussiness);
     return di.toString();
}


function digitalCheckWithoutVar1(obj, min, max, decimalCount)
{	
   var code=(event.keyCode!=0?event.keyCode:event.charCode);

   var ch = String.fromCharCode(code);
	
	if(code==13)
	{
		event.srcElement.blur();
		return false;
    }
    
    if(code == 8 || code == 127)
    {
    	return true;   //DEL   
    }
    
    if(event.ctrlKey)
    {
        if(ch == 'X' || ch == 'C' || ch == 'A')
        {  //X C A
            return true;
        }
        else
        {
            return false;
        }
    }
    if(event.shiftKey)
    {
        return false;
    }
    

    var value=obj.value;
    pos=digitalTag_getPos(obj);
    
    if(code == 46)//    
	{
		if(min.indexOf(".") == -1&&max.indexOf(".") == -1)//          ,         
		{
			return false;
		}
		
		if(pos == 0)//           
		{
			return false;
		}
		
		if(value.indexOf(".") == -1)//         ,       
		{
			return true;
		}
		else
		{
			return false;
		}
		
		if(pos == 1)
		{
			if(value.charAt(0) == "-")//      ,           
			{
				return false;
			}
			else
			{
				return true;
			}
		}
	
	}
	
    if((value.charAt(0) == "0")&&(pos == 1))//    0    ,          
	{
		if(code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	if((value.charAt(0) == "-")&&(value.charAt(1) == "0")&&(pos == 2))//    -0,         
	{
		if(code == 46)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	if((value.charAt(0) == "-") && (pos == 0) && (selectionLen(obj) == 0))
	{
	    return false;
	}
	if(decimalCount == null)
	{
		  decimalCount = 1;
	}
	if(value.charAt(pos-decimalCount-1) == ".")//           
	{
		return false;
	}
	var dotPos = value.indexOf(".");
	if(dotPos != -1)
	{
	    var valueSubstr = value.substring(dotPos + 1);
	    
	    if(dotPos < pos && valueSubstr.length >= decimalCount && selectionLen(obj) == 0)
	    {
	        return false;
	    }
  }
	
	if(code == 45)//  
	{
		if(min>=0)
		{
			return false;
		}
		
		if(pos == 0&&(value.indexOf("-") == -1) || selectionLen(obj) == value.length)//           
		{
			return true;
		}
		else
		{
			return false;
		}
	}


	if(code < 48 || code > 57 )
	{
		return false;  //      
	}

	if(code < 58)
	{
	   ch = '' + code - 48
	}
	else
	{
		ch = '' + code - 96
	}
	
    var newVal = value.substring(0,pos) + ch + value.substring(pos+selectionLen(obj));

    var len;
    var newValLength = newVal.replace(".","").length;
    if(min > 0)
    {
    	len = max.replace(".","").length;
    }
    else if(max <0)
    {
    	len = min.replace(".","").length;
    }
    if(newValLength < len)
    {
    	return true;
    }

    var tempValue;
	if(newVal.indexOf(".") == -1)
	{
		tempValue = parseInt(newVal,10);
	}else
	{
		tempValue = parseFloat(newVal,10);
	}
	
	if(tempValue > max)
	{
		obj.value = max;
	}
	else if(tempValue<min)
	{
		obj.value = min;
	}
	else
	{
		return true;
	}
	obj.blur();
	
	return alertDialog(min,max);
}

function handleSMBip8(bip8Value)
{
    var index = st.getSelectedRows();
    for (var i = 0, len = index.length; i < len; i++)
    {
    	var indexSM = index[i];
		var mod2ofrowarr = st.getCellStoreValue(indexSM,"mode2","mode2");
		var mode2Arr = mod2ofrowarr.split(",");
		var currentOdun = mode2Arr[mode2Arr.length - 1];//          
		
		var degthcellSM = st.getCell(indexSM,"DWDMTL1_ATTRSM_DEGTH");
		var degthcellshowSM = null;
		if (degthcellSM != undefined && degthcellSM != null)
		{
			degthcellshowSM = st.getCellShow(indexSM,"DWDMTL1_ATTRSM_DEGTH","DWDMTL1_ATTRSM_DEGTH");
		}
		
		var degtimecellSM = st.getCell(indexSM,"DWDMTL1_ATTRSM_DEGTIME");
		var degtimecellshowSM = null;
		if (degtimecellSM != undefined && degtimecellSM != null)
		{
			degtimecellshowSM = st.getCellShow(indexSM,"DWDMTL1_ATTRSM_DEGTIME","DWDMTL1_ATTRSM_DEGTIME");
		}
		
		var degIntevalcellSM = st.getCell(indexSM,"DWDMTL1_ATTRSM_DEGINTERVAL");
		var degIntevalcellshowSM = null;
		if (degIntevalcellSM != undefined && degIntevalcellSM != null)
		{
			degIntevalcellshowSM = st.getCellShow(indexSM,"DWDMTL1_ATTRSM_DEGINTERVAL","DWDMTL1_ATTRSM_DEGINTERVAL");
		}
		
		
		var sfbercell = st.getCell(indexSM,"DWDMTL1_ATTRSM_SFBER");
		var sfbercellshow = null;
		if (sfbercell != undefined && sfbercell != null)
		{
			sfbercellshow = st.getCellShow(indexSM,"DWDMTL1_ATTRSM_SFBER","DWDMTL1_ATTRSM_SFBER");
		}
		
		var sdbercell = st.getCell(indexSM,"DWDMTL1_ATTRSM_SDBER");
		var sdbercellshow = null;
		if (sdbercell != undefined && sdbercell != null)
		{
			sdbercellshow = st.getCellShow(indexSM,"DWDMTL1_ATTRSM_SDBER","DWDMTL1_ATTRSM_SDBER");
		}
			
		if (bip8Value == "BURST")
		{
			if (degthcellSM != undefined && degthcellSM != null)
			{
				setCellStatus(degthcellSM,degthcellshowSM,"1",5,currentOdun);
			}
			
			if (degtimecellSM != undefined && degtimecellSM != null)
			{
				setCellStatus(degtimecellSM,degtimecellshowSM,"1",6,currentOdun);
			}
			
			if (degIntevalcellSM != undefined && degIntevalcellSM != null)
			{
				setCellStatus(degIntevalcellSM,degIntevalcellshowSM,"1",9,currentOdun);
			}
			
			if (sfbercell != undefined && sfbercell != null)
			{
				setCellStatus(sfbercell,sfbercellshow,"0",7,currentOdun);
			}
			
			if (sdbercell != undefined && sdbercell != null)
			{
				setCellStatus(sdbercell,sdbercellshow,"0",8,currentOdun);
			}
		}
		else if (bip8Value == "POISSON")
		{
			if (degthcellSM != undefined && degthcellSM != null)
			{
				setCellStatus(degthcellSM,degthcellshowSM,"0",5,currentOdun);
			}
			
			if (degtimecellSM != undefined && degtimecellSM != null)
			{
				setCellStatus(degtimecellSM,degtimecellshowSM,"0",6,currentOdun);
			}
			
			if (degIntevalcellSM != undefined && degIntevalcellSM != null)
			{
				setCellStatus(degIntevalcellSM,degIntevalcellshowSM,"0",9,currentOdun);
			}
			
			if (sfbercell != undefined && sfbercell != null)
			{
				setCellStatus(sfbercell,sfbercellshow,"1",7,currentOdun);
			}
			
			if (sdbercell != undefined && sdbercell != null)
			{
				setCellStatus(sdbercell,sdbercellshow,"1",8,currentOdun);
			}
	    }
    }
}

function handlePMBip8(bip8Value)
{
	var index = st.getSelectedRows();
    for (var i = 0, len = index.length; i < len; i++)
    {
    	var indexPM = index[i];
		var mod2ofrowarr = st.getCellStoreValue(indexPM,"mode2","mode2");
		var mode2Arr = mod2ofrowarr.split(",");
		var currentOdun = mode2Arr[mode2Arr.length - 1];//          
		
		var degthcellPM = st.getCell(indexPM,"DWDMTL1_ATTRPM_DEGTH");
		var degthcellshowPM = null;
		if (degthcellPM != undefined && degthcellPM != null)
		{
			degthcellshowPM = st.getCellShow(indexPM,"DWDMTL1_ATTRPM_DEGTH","DWDMTL1_ATTRPM_DEGTH");
		}
		
		var degtimecellPM = st.getCell(indexPM,"DWDMTL1_ATTRPM_DEGTIME");
		var degtimecellshowPM = null;
		if (degtimecellPM != undefined && degtimecellPM != null)
		{
			degtimecellshowPM = st.getCellShow(indexPM,"DWDMTL1_ATTRPM_DEGTIME","DWDMTL1_ATTRPM_DEGTIME");
		}
		
		var degIntevalcellPM = st.getCell(indexPM,"DWDMTL1_ATTRPM_DEGINTERVAL");
		var degIntevalcellshowPM = null;
		if (degIntevalcellPM != undefined && degIntevalcellPM != null)
		{
			degIntevalcellshowPM = st.getCellShow(indexPM,"DWDMTL1_ATTRPM_DEGINTERVAL","DWDMTL1_ATTRPM_DEGINTERVAL");
		}
		
		var sfbercell = st.getCell(indexPM,"DWDMTL1_ATTRPM_SFBER");
		var sfbercellshow = null;
		if (sfbercell != undefined && sfbercell != null)
		{
			sfbercellshow = st.getCellShow(indexPM,"DWDMTL1_ATTRPM_SFBER","DWDMTL1_ATTRPM_SFBER");
		}
		
		var sdbercell = st.getCell(indexPM,"DWDMTL1_ATTRPM_SDBER");
		var sdbercellshow = null;
		if (sdbercell != undefined && sdbercell != null)
		{
			sdbercellshow = st.getCellShow(indexPM,"DWDMTL1_ATTRPM_SDBER","DWDMTL1_ATTRPM_SDBER");
		}
		
		if (bip8Value == "BURST")
		{
			if (degthcellPM != undefined && degthcellPM != null )
			{
				setCellStatus(degthcellPM,degthcellshowPM,"1",5,currentOdun);
			}
			
			if (degtimecellPM != undefined && degtimecellPM != null )
			{
				setCellStatus(degtimecellPM,degtimecellshowPM,"1",6,currentOdun);
			}
			
			if (degIntevalcellPM != undefined && degIntevalcellPM != null)
			{
				setCellStatus(degIntevalcellPM,degIntevalcellshowPM,"1",9,currentOdun);
			}
			
			if (sfbercell != undefined && sfbercell != null )
			{
				setCellStatus(sfbercell,sfbercellshow,"0",7,currentOdun);
			}
			
			if (sdbercell != undefined && sdbercell != null )
			{
				setCellStatus(sdbercell,sdbercellshow,"0",8,currentOdun);
			}
		}
		else if (bip8Value == "POISSON")
		{
			if (degthcellPM != undefined && degthcellPM != null )
			{
				setCellStatus(degthcellPM,degthcellshowPM,"0",5,currentOdun);
			}
			
			if (degtimecellPM != undefined && degtimecellPM != null )
			{
				setCellStatus(degtimecellPM,degtimecellshowPM,"0",6,currentOdun);
			}
			
			if (degIntevalcellPM != undefined && degIntevalcellPM != null)
			{
				setCellStatus(degIntevalcellPM,degIntevalcellshowPM,"0",9,currentOdun);
			}
			
			if (sfbercell != undefined && sfbercell != null )
			{
				setCellStatus(sfbercell,sfbercellshow,"1",7,currentOdun);
			}
			
			if (sdbercell != undefined && sdbercell != null )
			{
				setCellStatus(sdbercell,sdbercellshow,"1",8,currentOdun);
			}
		}
    }
}

function parseMod2Str(mode2Str,attrID)
{
        var str = mode2Str.split(",");
        if (str.length == 1)
        {
            return mode2Str;
        }
        for (var i = 0, size = str.length - 1; i < size; i++)
        {
            if (str[i] == attrID)
            {
                return str[i + 1];
            }
        }

        return "";
}

function isNewNEVersion(nepara)
{
	if(getNeProperty(top)["neType"] == "66")
	{
		return compare(nepara["neversion"],"5.67.02.10") > 0;
	}

	return true;
}

function handleTCMBip8(bip8Value)
{
	var index = st.getSelectedRows();
    for (var i = 0, len = index.length; i < len; i++)
    {
    	var indexTCM = index[i];
		var mod2ofrowarr = st.getCellStoreValue(indexTCM,"mode2","mode2");
		var mode2Arr = mod2ofrowarr.split(",");
		var currentOdun = mode2Arr[mode2Arr.length - 1];//          
		
		var degthcellTCM = st.getCell(indexTCM,"DWDMTL1_ATTRTCM_DEGTH");
		var degthcellshowTCM = null;
		if (degthcellTCM != undefined && degthcellTCM != null)
		{
			degthcellshowTCM = st.getCellShow(indexTCM,"DWDMTL1_ATTRTCM_DEGTH","DWDMTL1_ATTRTCM_DEGTH");
		}
		
		var degtimecellTCM = st.getCell(indexTCM,"DWDMTL1_ATTRTCM_DEGTIME");
		var degtimecellshowTCM = null;
		if (degtimecellTCM != undefined && degtimecellTCM != null)
		{
			degtimecellshowTCM = st.getCellShow(indexTCM,"DWDMTL1_ATTRTCM_DEGTIME","DWDMTL1_ATTRTCM_DEGTIME");
		}
		
		var degIntevalcellTCM = st.getCell(indexTCM,"DWDMTL1_ATTRTCM_DEGINTERVAL");
		var degIntevalcellshowTCM = null;
		if (degIntevalcellTCM != undefined && degIntevalcellTCM != null)
		{
			degIntevalcellshowTCM = st.getCellShow(indexTCM,"DWDMTL1_ATTRTCM_DEGINTERVAL","DWDMTL1_ATTRTCM_DEGINTERVAL");
		}
		
		var sfbercell = st.getCell(indexTCM,"DWDMTL1_ATTRTCM_SFBER");
		var sfbercellshow = null;
		if (sfbercell != undefined && sfbercell != null)
		{
			sfbercellshow = st.getCellShow(indexTCM,"DWDMTL1_ATTRTCM_SFBER","DWDMTL1_ATTRTCM_SFBER");
		}
		
		var sdbercell = st.getCell(indexTCM,"DWDMTL1_ATTRTCM_SDBER");
		var sdbercellshow = null;
		if (sdbercell != undefined && sdbercell != null)
		{
			sdbercellshow = st.getCellShow(indexTCM,"DWDMTL1_ATTRTCM_SDBER","DWDMTL1_ATTRTCM_SDBER");
		}
		
		if (bip8Value == "BURST")
		{
			if (degthcellTCM != undefined && degthcellTCM != null)
			{
				setCellStatus(degthcellTCM,degthcellshowTCM,"1",5,currentOdun);
			}
			
			if (degtimecellTCM != undefined && degtimecellTCM != null)
			{
				setCellStatus(degtimecellTCM,degtimecellshowTCM,"1",6,currentOdun);
			}
			
			if (degIntevalcellTCM != undefined && degIntevalcellTCM != null)
			{
				setCellStatus(degIntevalcellTCM,degIntevalcellshowTCM,"1",9,currentOdun);
			}
			
			if (sfbercell != undefined && sfbercell != null)
			{
				setCellStatus(sfbercell,sfbercellshow,"0",7,currentOdun);
			}
			
			if (sdbercell != undefined && sdbercell != null)
			{
				setCellStatus(sdbercell,sdbercellshow,"0",8,currentOdun);
			}
		}
		else if (bip8Value == "POISSON")
		{
			if (degthcellTCM != undefined && degthcellTCM != null)
			{
				setCellStatus(degthcellTCM,degthcellshowTCM,"0",5,currentOdun);
			}
			
			if (degtimecellTCM != undefined && degtimecellTCM != null)
			{
				setCellStatus(degtimecellTCM,degtimecellshowTCM,"0",6,currentOdun);
			}
			
			if (degIntevalcellTCM != undefined && degIntevalcellTCM != null)
			{
				setCellStatus(degIntevalcellTCM,degIntevalcellshowTCM,"0",9,currentOdun);
			}
			
			if (sfbercell != undefined && sfbercell != null)
			{
				setCellStatus(sfbercell,sfbercellshow,"1",7,currentOdun);
			}
			
			if (sdbercell != undefined && sdbercell != null)
			{
				setCellStatus(sdbercell,sdbercellshow,"1",8,currentOdun);
			}
		}
    }
}

function isR6C01NEVersion(neversion)
{
	var ver = neversion.split(".");
	if(ver[1] == 51)
	{
		if ((ver[2] == "07" && ver[3] >= "30") || ver[2] > "07")
		{
			return true;
		}
	}
	return false;
}



function createCommonQueryRow(neid, tableconf,extendattr, isbyFun, queryflag)
{
    var row = new tagElement("row-params");
    if (null != queryflag) 
    {
        row.appendChild(new tagElement("param", "queryflag", queryflag));
    }
    row.appendChild(new tagElement("param", "neid", neid));
    if (typeof(isbyFun) != "undefined" && isbyFun != null && isbyFun) 
    {
        row.appendChild(new tagElement("param", "byFun", "true"));
    }
	var colid;
    for (var i = 1; i < tableconf.getColsLength(); i++) 
    {
        colid = tableconf.getColId(i);
        row.appendChild(new tagElement("param","attrId",colid));
    }
	if (typeof(extendattr) != "undefined" && extendattr != null) 
    {
        for (var j = 0; j < st.getDataRowLength(); j++) 
        {
            for (var k = 0; k < extendattr.length; k++) 
            {
                param = new tagElement("param");
                param.setAttribute("name", extendattr[k]);
                if (!st.getCell(j, extendattr[k])) 
                {
                    continue;
                }
                param.setAttribute("value", st.getCellStoreValue(j, extendattr[k], extendattr[k]));
                row.appendChild(param);
            }
        }
    }
	return row;
}

function getChangedPortPath()
{
    var portpath = new Object();
    for (var i = 0, iLength = changedRows.length; i < iLength; i++) 
    {
        var port = st.getCellStoreValue(changedRows[i], "port", "port");
        var path = st.getCellStoreValue(changedRows[i], "operaObj", "path");
        if (typeof(portpath[port]) == "undefined") 
        {
            portpath[port] = [];
        }
        portpath[port][portpath[port].length] = path;
    }
	return portpath;
}

function createQueryProcessXML(neid,slotid,tableconf, extendattr, isbyFun, queryflag)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
	if (changedRows.length > 0) 
	{
		var portpaths = getChangedPortPath();
		for (var portpathtmp in portpaths) 
		{
			var row = createCommonQueryRow(neid, tableconf, extendattr, isbyFun, queryflag);
			row.appendChild(new tagElement("param", "slotid", slotid));
			row.appendChild(new tagElement("param", "srcObjType", "ID_OBJECT_TYPE_NE_BOARD_PORT"));
			row.appendChild(new tagElement("param", "port", portpathtmp));
			row.appendChild(new tagElement("param", "pathlist",portpaths[portpathtmp].join(",")));
			bussiness.appendChild(row);
		}
	}
	if(bussiness.childNodes.length == 0)
	{
		return null;
	}

    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *          XML  
 * @param neid:  ID slotid:  ID tableconf:        
 * @return String:       XML  
 */
function createQueryXML(neid, slotid, tableconf, extendattr, isbyFun, queryflag)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var slotidArr = [];
    if (typeof slotid != "object") 
    {
        slotidArr.push(slotid);
    }
    else 
    {
        slotidArr = slotid;
    }
    
    for (var slotIdIndex = 0; slotIdIndex < slotidArr.length; slotIdIndex++) 
    {
    	var row = null;

        if (null != slotid && "" != slotid) 
        {
			var selectports = filterCondition.selectedPorts;
            if (selectports.length > 0) 
			{
				var selectgrades = filterCondition.selectedGrades.join(",");
                var selecttcmlevels = filterCondition.selectedTcmLevels.join(",");
                for (var j = 0, lenj = selectports.length; j < lenj; j++) 
				{
					row = createCommonQueryRow(neid, tableconf, extendattr, isbyFun, queryflag);
					row.appendChild(new tagElement("param", "slotid", slotidArr[slotIdIndex]));
					row.appendChild(new tagElement("param", "srcObjType", "ID_OBJECT_TYPE_NE_BOARD_PORT"));
					row.appendChild(new tagElement("param", "port", selectports[j].port));
					if (typeof(selectports[j].pathList) == "object") 
					{
						if (selectports[j].pathList.length == 0) 
						{
							continue;
						}
						row.appendChild(new tagElement("param", "pathlist", selectports[j].pathList.join(",")));
					}
					if (selectgrades.length > 0) 
                    {
                        row.appendChild(new tagElement("param", "tl1Grade", selectgrades));
                    }
                    if (selecttcmlevels.length != 0) 
                    {
                        row.appendChild(new tagElement("param", "tcmlevel", selecttcmlevels));
                    }
                    bussiness.appendChild(row);
				}
			}
			else 
            {
                row = createCommonQueryRow(neid, tableconf, extendattr, isbyFun, queryflag);
                row.appendChild(new tagElement("param", "slotid", slotidArr[slotIdIndex]));
                row.appendChild(new tagElement("param", "srcObjType", "ID_OBJECT_TYPE_NE_BOARD"));
                bussiness.appendChild(row);
            }
        }
        else 
        {
			row = createCommonQueryRow(neid, tableconf, extendattr,isbyFun, queryflag);
            row.appendChild(new tagElement("param","srcObjType","ID_OBJECT_TYPE_NE"));
			bussiness.appendChild(row);
        }
    }
    if(bussiness.childNodes.length == 0)
	{
		return null;
	}

    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function showLoadProcess()
{
	LoadingProcess.showWaitStatus("../../../../../../../images/");
}

function removeLoadProcess()
{
	LoadingProcess.removeWaitStatus();
}
var filterCondition = {selectedPorts:[],selectedGrades:[],selectedTcmLevels:[],isFilterExc:false};

function refreshFilterCondition(ports,grades,tcmlevels,isfilterexc)
{
	filterCondition.selectedPorts.clear();
	filterCondition.selectedGrades.clear();
	filterCondition.selectedTcmLevels.clear();
	for(var i = 0,len = ports.length;i< len;i++)
	{
		filterCondition.selectedPorts[i] = ports[i];
	}
	for(var i = 0,len = grades.length;i< len;i++)
	{
		filterCondition.selectedGrades[i] = grades[i];
	}
	for(var i = 0,len = tcmlevels.length;i< len;i++)
	{
		filterCondition.selectedTcmLevels[i] = tcmlevels[i];
	}
	filterCondition.isFilterExc = isfilterexc;
}


function setOptionValue(param)
{
	var showtext = param[0];
	var txtvalue = param[1];
	var elem = param[2];
	var colid = elem.colid;
	
	var bip8ModeFlag = false;
	if (colid == "DWDMTL1_ATTRPM_BIP8MODE" || colid == "DWDMTL1_ATTRSM_BIP8MODE" || colid == "DWDMTL1_ATTRTCM_BIP8MODE")
	{
		bip8ModeFlag = true;
	}
	var onchanegeEventFlag = false;
	var rows = elem.parent.getSelectedRows();
	for ( var i = 0; i < rows.length; i++)
	{
		var cell = elem.parent.getCell(rows[i], colid);
		if (cell.element.isEdit == 0)
		{
			continue;
		}
		var storeValue = cell.element.storeValue[colid];
		elem.parent.setCellValue(cell, colid, txtvalue);
		if (bip8ModeFlag && !onchanegeEventFlag && (storeValue != txtvalue))
		{
			onchanegeEventFlag = true;
		}
		var showElement = cell.element.showElement;
		cell.element.modify = true;
		cell.element.parentNode.modify = true;
		cell.element.style.backgroundColor = "#d0f946";
		handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
		if (showElement.type == 'span' || showElement.type == 'text')
		{
			showElement.element.innerText = showtext;
		}
		else if (showElement.type == 'select')
		{
			var options = showElement.element.options;
			for ( var j = 0; j < options.length; j++)
			{
				if (options[j].value == txtvalue)
				{
					showElement.element.selectedIndex = j;
					break;
				}
			}
		}
		if (cell.element.editElement.element.onchange)
		{
			cell.element.editElement.element.style.display = "none";
			cell.element.appendChild(cell.element.editElement.element);
			hideMenu();
			cell.element.editElement.element.value = txtvalue;
			if (bip8ModeFlag)
			{
				if (onchanegeEventFlag)
				{
					cell.element.editElement.element.onchange();
				}
			}
			else
			{
				cell.element.editElement.element.onchange();
			}
			cell.element.editElement.element.style.display = "";
			cell.element.removeChild(cell.element.lastChild);
		}
	}
}


