  //OTN    
otnOphLevel = [];
otnOphLevel[1] = "PM";
otnOphLevel[2] = "TCM1";
otnOphLevel[3] = "TCM2";
otnOphLevel[4] = "TCM3";
otnOphLevel[5] = "TCM4";
otnOphLevel[6] = "TCM5";
otnOphLevel[7] = "TCM6";
otnOphLevel[8] = "SM";

timModel = [];
timModel["SAPI"] = RESOURCE["only_sapi"];
timModel["DAPI"] = RESOURCE["only_dapi"];
timModel["BOTH"] = RESOURCE["sapi_dapi"];
timModel["OFF"] = RESOURCE["nocheck"];

tcmModel = [];
tcmModel[1] = RESOURCE["oper_mode"];
tcmModel[2] = RESOURCE["limpidity_mode"];
tcmModel[3] = RESOURCE["watch_mode"];

pfmExceedLevel = [];
pfmExceedLevel[5] = "1.0E-5";
pfmExceedLevel[6] = "1.0E-4";
pfmExceedLevel[7] = "1.0E-3";

pfmInferiorLevel = [];
pfmInferiorLevel[1] = "1.0E-9";
pfmInferiorLevel[2] = "1.0E-8";
pfmInferiorLevel[3] = "1.0E-7";
pfmInferiorLevel[4] = "1.0E-6";
pfmInferiorLevel[5] = "1.0E-5";

oduGrade = [];
oduGrade[1] = "ODU1";
oduGrade[2] = "ODU2";
oduGrade[3] = "ODU3";
oduGrade[4] = "ODU5g";

otuGrade = [];
otuGrade[1] = "OTU1";
otuGrade[2] = "OTU2";
otuGrade[3] = "OTU3";
otuGrade[4] = "OTU5g";

opuGrade = [];
opuGrade[1] = "OPU1";
opuGrade[2] = "OPU2";
opuGrade[3] = "OPU3";
opuGrade[4] = "OPU5g";

enableFlag = [];
enableFlag["DISABLE"] = RESOURCE["disabled"];
enableFlag["ENABLE"] = RESOURCE["enable"];

bip8Mode = [];
bip8Mode["POISSON"] = RESOURCE["Poisson"];
bip8Mode["BURST"] = RESOURCE["Bursty"];

tcmStat = [];
tcmStat[0] = RESOURCE["unused"];
tcmStat[1] = RESOURCE["used"];
tcmStat[2] = RESOURCE["used"];
tcmStat[3] = RESOURCE["reserved"];
tcmStat[4] = RESOURCE["reserved"];
tcmStat[5] = RESOURCE["lck"];
tcmStat[6] = RESOURCE["oci"];
tcmStat[7] = RESOURCE["ais"];
         
 /**
 *   PT    
 * @param ptValue      PT 
 * @return PT        
 */

/**
*   PT    
* @param ptValue      PT 
* @return PT        
*/
function getPTShowValue(ptValue)
{
	var ptShowValue = ptValue + "-";
	
	var ptValue = parseInt(ptValue, 16); 
	
	if(ptValue >= 1 && ptValue <= 17 || ptValue == 32 || ptValue == 33|| ptValue == 253 || ptValue == 254)
	{
		ptShowValue += RESOURCE["ID_OPU_PT"+ptValue];
	}
	else if (ptValue == 85 || ptValue == 102 || ptValue == 255)
	{
		ptShowValue += RESOURCE["ID_OPU_PT85"];
	}
	else if(ptValue >= 128 && ptValue <= 143)
	{
		ptShowValue += RESOURCE["ID_OPU_PT128"];
	}
	else if(ptValue > 1 &&  ptValue < 255)
	{
		ptShowValue += RESOURCE["ID_OPU_PT_UNKNOWN"];
	}
	else if (ptValue == 0)
	{
		ptShowValue += RESOURCE["ID_OPU_PT_UNKNOWN"];
	}
	else
	{
		ptShowValue = "/";
	}
	return ptShowValue;
}

function getTCMLevel(level)
{
	return level.substring(level.indexOf("TCM"), level.length);
}
