loadXMLdoc("../../../../conf/system.xml","GET",false,EncapsulateSConf);
language = SYSTEMCONF.getLanguage();

getResourse("../../../../res/configres_" + language + ".xml");
getResourse("../../../../res/commonres_" + language + ".xml");
getResourse("../../../../res/necommres_" + language + ".xml");
getResourse("../../../../res/neinformationres_" + language + ".xml");
getResourse("../../res/netimesyn/ntpserver_" + language + ".xml");

var neid2 = getNeProperty(self)["neid"];
var parentWin = getParentWindow();

var tableTop = new CTable();

var selAtom;
var neidAtom;
var ipAtom;
var keyAtom;

var neidMainAtom;
var neidExtendAtom;

var selectOption = new Object();
selectOption.NEID = RESOURCE["RES_NEID"];
selectOption.IP = RESOURCE["RES_IP"];

function initServerPage()
{
	tableTop.addHead(RESOURCE["attribute"], RESOURCE["getvalue"]);

	selAtom = new Atom("select");
	selAtom.addOption(selectOption.IP, "IP");
	selAtom.addOption(selectOption.NEID, "ID");
	selAtom.element.style.width="100%";
	tableTop.addAttrRow("ntp_select",RESOURCE["RES_Type"],selAtom);
	selAtom.element.onchange = doSelectChange;


	neidAtom = new Atom("text");
	neidAtom.setValue("0");   
	neidAtom.element.style.width="100%";
	tableTop.addAttrRow("ntp_neid",RESOURCE["RES_NEID"],neidAtom);

	neidMainAtom = new Atom("text");
	neidMainAtom.setValue("1");   
	neidMainAtom.element.style.width="100%";
	tableTop.addAttrRow("ntp_neid_main","MAIN",neidMainAtom);
	validateNum(neidMainAtom.element,1,19151,5);

	
	neidExtendAtom = new Atom("text");
	neidExtendAtom.setValue("1");   
	neidExtendAtom.element.style.width="100%";
	tableTop.addAttrRow("ntp_neid_extend","EXTEND",neidExtendAtom);
	validateNum(neidExtendAtom.element,1,254,3);


	ipAtom = new Atom("text");
	ipAtom.setValue("0");
	ipAtom.element.style.width="100%";
	tableTop.addAttrRow("ntp_ip",RESOURCE["RES_IP"],ipAtom);

	keyAtom = new Atom("text");
	keyAtom.setValue("1");
	keyAtom.element.style.width="100%";
	tableTop.addAttrRow("ntp_key",RESOURCE["RES_KEY"],keyAtom);
	validateNum(keyAtom.element,1,1024,4);

	document.getElementById("table").appendChild(tableTop.getTable());

	tableTop.getTable().rows[2].style.display = "none";		//NE_ID Hide
	
	tableTop.getTable().rows[3].style.display = "none";			//NEIDMAIN Hide
	tableTop.getTable().rows[4].style.display = "none";			//NE_IP Hide
	tableTop.getTable().rows[5].style.display = "";			//NE_IP Hide

	$("confirmBtn").value=RESOURCE["okbutton"];
	$("cancelBtn").value=RESOURCE["cancelbutton"];
}

function confirmByBtn()
{
	applyByBtn();
}

function applyByBtn()
{
	$("confirmBtn").disabled = true;

	if( selAtom.getValue() == "ID" )
	{
		if( neidMainAtom.getValue() == "" || neidExtendAtom.getValue() == "" )
		{
			$("confirmBtn").disabled = false;
			return;
		}
		var newValue = neidMainAtom.getValue() + "-" + neidExtendAtom.getValue();
		neidAtom.setValue(newValue);
		ipAtom.setValue("0.0.0.0");
	}

	if( selAtom.getValue() == "IP" )
	{
		if( !check_IPaddr(ipAtom.getValue()) )
		{
			$("confirmBtn").disabled = false;
			return;
		}
		
		neidAtom.setValue("0");
	}

	var xml = generateCreationXml();
	var serverURL = "../../../../neExlorerServlet?sfid="+TECMDCODE_ADDNTPSERVER+"&flag=1"; 
	loadXMLdoc(serverURL,"POST",true,callbackCreate,null,"inputdata="+xml);
}

function callbackCreate(doc)
{
   	var dinterface  = EncapsulateData(doc);

	if(0 != dinterface.getSErrorCode()) 
	{
		showErrorDialog(dinterface);
		$("confirmBtn").disabled = false;
		return ;
	}
	
	parentWin.doQry();
	xcloseDialog();
}

/******************************************************/


function generateCreationXml()
{
	var root = new inputxml("datainterface");
	var bussinessLevel = new tagElement("bussiness-params");

	var rowParamsLevel = new tagElement("row-params");
	var paramLevel;

	paramLevel = new tagElement("param");
	paramLevel.setAttribute("name","seltype");
	paramLevel.setAttribute("value",selAtom.getValue());
	rowParamsLevel.appendChild(paramLevel);

	paramLevel = new tagElement("param");
	paramLevel.setAttribute("name","neid");
	paramLevel.setAttribute("value",neid2);
	rowParamsLevel.appendChild(paramLevel);

	paramLevel = new tagElement("param");
	paramLevel.setAttribute("name","ne_id");
	paramLevel.setAttribute("value",neidAtom.getValue());
	rowParamsLevel.appendChild(paramLevel);

	paramLevel = new tagElement("param");
	paramLevel.setAttribute("name","ipaddress");
	paramLevel.setAttribute("value",ipAtom.getValue());
	rowParamsLevel.appendChild(paramLevel);
	
	paramLevel = new tagElement("param");
	paramLevel.setAttribute("name","nsapaddress");
	paramLevel.setAttribute("value","");
	rowParamsLevel.appendChild(paramLevel);
	
	paramLevel = new tagElement("param");
	paramLevel.setAttribute("name","ntpver");
	paramLevel.setAttribute("value","3");
	rowParamsLevel.appendChild(paramLevel);

	paramLevel = new tagElement("param");
	paramLevel.setAttribute("name","key");
	paramLevel.setAttribute("value",keyAtom.getValue());
	rowParamsLevel.appendChild(paramLevel);

	paramLevel = new tagElement("param");
	paramLevel.setAttribute("name","priority");
	paramLevel.setAttribute("value","1");
	rowParamsLevel.appendChild(paramLevel);	

	bussinessLevel.appendChild(rowParamsLevel);
	root.getRoot().appendChild(bussinessLevel);
	return root.toString();
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
    openErrPage("../../../../page/", data.getError(), errArr);
    errArr = null;
}
/*
function checkIPAddress(ipAddress)
{
	  var ipAddressArray = ipAddress.split(".");

	  var intIPAddressFirst = parseInt(ipAddressArray[0],10);
	  var intIPAddressLast = parseInt(ipAddressArray[3],10);
	  
	  if (0 == intIPAddressFirst || 127 == intIPAddressFirst || 224 <= intIPAddressFirst
	     ||0 == intIPAddressLast || 255 == intIPAddressLast)
	  {
	  	  alert(RESOURCE["wrongIPaddr"]);
	  	  return false;
	  }
	  
	  return true;
}*/

function doSelectChange()
{
	if( selAtom.getValue() == "ID" )
	{
		tableTop.getTable().rows[3].style.display = "";
		tableTop.getTable().rows[4].style.display = "";
		tableTop.getTable().rows[5].style.display = "none";
	}
	if( selAtom.getValue() == "IP" )
	{
		tableTop.getTable().rows[3].style.display = "none";
		tableTop.getTable().rows[4].style.display = "none";
		tableTop.getTable().rows[5].style.display = "";
	}

}
