 //  URL  
var winobj = getNeProperty(self);

var neversion = winobj.neversion;

var netype = neversion.split(".")[1];
var ipaTable;

var ipaTableConf;

var MAX_IPA_ID = 16;

var MIN_IPA_ID = 1;

var availableWPGID = [];

var useredWPGID = [];

var availableAlmPort = [];

var availableCntlPort = [];

var availableRamonBoard = [];

var almPort = [];

var cntlPort = [];

var ramonBoard = [];

var assistantCheckBoard = [];

var selectedAssisBoard = [];

var allUsedAssisBoard = [];

var isSupport14FIUAsAssisBoardFlag = true;

var isSupportRamanEnableFlag = SpecialAttrMgr.isNESupport(winobj["neid"], "TE_FUNC_CFG_IPA", "OTN_ATTR_SUPPORT_IPA_RAMON_ENABLE"); //            

var btnRightArr = new Object();

loadXMLdoc("../../../../../../conf/system.xml", "GET", false, EncapsulateSConf);

getResourse("../../../../../../res/commonres_" + SYSTEMCONF.getLanguage()
		+ ".xml");
getResourse("../../../../res/config/ipa/ipamgr_" + SYSTEMCONF.getLanguage()
		+ ".xml");

loadXMLdoc("../../../../conf/ne_attribute/config/ipa/ipamgrtable_"
		+ SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable);

/**
 *      
 * 
 * @param  
 * @return  
 */
function initPage()
{
	initMAX_IPA_ID();
	initTable();
	initButton();
	doQuery();
}


function initMAX_IPA_ID()
{

	if(winobj["neType"] == 73  || winobj["neType"] == 75 || winobj["neType"] == 85 || winobj["neType"] == 71)
	{
		var neversion = winobj["neversion"];
		MAX_IPA_ID = 32;
		
	}
}

/**
 *      
 * 
 * @param  
 * @return  
 */
function initTable()
{
	ipaTable = new SortTable();

	ipaTable.setImage("../../../../../../images/");

	ipaTable.setOnRowSelectHandler(rowSelectHandler);

	ipaTable.setOnCellEditHandler(cellEditHandler);

	ipaTableConf = window.tableconf[0];

	createTableHead(ipaTable, ipaTableConf);

	document.getElementById("tablecomponent").appendChild(ipaTable.getTable());

	ipaTable.setBodyHeight(getComponetHeight($("tablecomponent"), 100) + "px");
	ipaTable.setBodyWidth(ipaTableConf.width, ipaTableConf.percent, 0);

	if (netype == 70)
	{
		ipaTable.getHeadCell("ropCard").element.style.display = "none";
	}

	$("tablecomponent").oncontextmenu = popupMenuHandler;
}

/**
 *      
 * 
 * @param  
 * @return  
 */
function initButton()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("addipabtn").value = RESOURCE["addipabtn"];
	$("delipabtn").value = RESOURCE["delipabtn"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("restartbtn").value = RESOURCE["restartbtn"];
	$("testbtn").value = RESOURCE["testbtn"];
	$("relaytimebtn").value = RESOURCE["ID_Delay_Time"];
	$("checkbtn").value = RESOURCE["checkbtn"];
	
    if(isSupportRamanEnableFlag)
    {
    	$("ramanenablebtn").value = RESOURCE["ramanenablebtn"];
    }
    else
    {
        $("ramanenablebtn").style.display="none";
    }

	if (SYSTEMCONF.getLanguage() == "en")
	{
		$("delipabtn").style.width = "80px";
		$("restartbtn").style.width = "105px";
		$("testbtn").style.width = "90px";
		$("relaytimebtn").style.width = "115px";
		$("checkbtn").style.width = "170px";
	}

	btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_APSDPAIR);
	btnRightArr.addipabtn = new BtnRightObj("addipabtn",
			TECMDCODE_SET_APRCTRLPARA);
	btnRightArr.delipabtn = new BtnRightObj("delipabtn", TECMDCODE_DEL_APSDPAIR);
	btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_APSDPAIR);
	btnRightArr.restartbtn = new BtnRightObj("restartbtn",
			TECMDCODE_START_APSDPAIR);
	btnRightArr.testbtn = new BtnRightObj("testbtn", TECMDCODE_TEST_APSDPAIR);
	btnRightArr.relaytimebtn = new BtnRightObj("relaytimebtn",
			TECMDCODE_SET_APRALMDELAY);
	btnRightArr.checkbtn = new BtnRightObj("checkbtn",
			TECMD_CODE_SET_IPAMONPARA);

	sendRightInfo(btnRightArr);
}

/**
 *         
 * 
 * @param  
 * @return  
 */
function initBtnStatue()
{
	$("querybtn").disabled = !btnRightArr.querybtn.right;
	$("addipabtn").disabled = !btnRightArr.addipabtn.right;
	$("relaytimebtn").disabled = !btnRightArr.relaytimebtn.right;

	$("delipabtn").disabled = true;
	$("applybtn").disabled = true;
	$("restartbtn").disabled = true;
	$("testbtn").disabled = true;
	$("checkbtn").disabled = true;
}

/**
 *         
 * 
 * @param  
 * @return  
 */
function addCellEvent()
{
	var cell = null;
	for ( var i = 0, len = ipaTable.getDataRowLength(); i < len; i++)
	{
		cell = ipaTable.getCell(i, "offTimes");
		if (null != cell)
		{
			textCheck(cell.element.editElement.element, "100", "300", 2);
		}

		cell = ipaTable.getCell(i, "onTimes");
		if (null != cell)
		{
			textCheck(cell.element.editElement.element, "1.75", "45.00", 2);
		}

		cell = ipaTable.getCell(i, "testTimes");
		if (null != cell)
		{
			textCheck(cell.element.editElement.element, "80", "1000", 2);
		}

		cell = ipaTable.getCellEdit(i, "reBootType");
		cell.element["onchange"] = function()
		{
		    changeReBootType(ipaTable.getSelectedRows()[0], this.value);
			setRestartBtn();
		}

		/*
		 * cell = ipaTable.getCellEdit(i,"ramanLosTH");
		 * textCheck(cell.element,"-35.0","-14.0");
		 */

		/*
		 * if(ipaTable.getCellStoreValue(i,"raman","ramonSlotid") == 0) { var
		 * ramanLosTHCellEle = ipaTable.getCell(i,"ramanLosTH").element;
		 * ipaTable.setAtomValue(ramanLosTHCellEle.showElement,"-"); //        
		 * ramanLosTHCellEle.style.background = "#E3E8E6";
		 * ramanLosTHCellEle.isEdit = 0; //     onclick    
		 * ramanLosTHCellEle.ondblclick = null;
		 * 
		 * var ramanAlarmTHCellEle = ipaTable.getCell(i,"ramanAlarmTH").element;
		 * ipaTable.setAtomValue(ramanAlarmTHCellEle.showElement,"-");
		 * //         ramanAlarmTHCellEle.style.background = "#E3E8E6";
		 * ramanAlarmTHCellEle.isEdit = 0; //     onclick    
		 * ramanAlarmTHCellEle.ondblclick = null;
		 * 
		 * var ramanAlarmEnCellEle =
		 * ipaTable.getCell(i,"ramanAlarmEnable").element;
		 * ipaTable.setAtomValue(ramanAlarmEnCellEle.showElement,"-");
		 * //         ramanAlarmEnCellEle.style.background = "#E3E8E6";
		 * ramanAlarmEnCellEle.isEdit = 0; //     onclick    
		 * ramanAlarmEnCellEle.ondblclick = null; }
		 */

		cell = ipaTable.getCellEdit(i, "ipaEnable");
		cell.element["onchange"] = function()
		{
			setRestartBtn();
		}
		/*
		cell = ipaTable.getCellEdit(i, "enableAls");
		var isALSEnabled = ipaTable.getCellStoreValue(i, "enableAls", "enableAls"); 
		var aLSEnabledCell = ipaTable.getCell(i,"enableAls");
		var aLSEnabledCellShow = ipaTable.getCellShow(i,"enableAls","enableAls");
		if (isALSEnabled == "-")
		{
			setCellStatus(aLSEnabledCell,aLSEnabledCellShow,"0");
		}
		cell.element.onchange = function()
		{
			if (ipaTable.getSelectedRows().length == 1)	
			{
				handleEnableAls(ipaTable.getSelectedRows()[0],this.value);
			}
		}*/
			
		
		cell = ipaTable.getCellEdit(i, "ramanThreshold");
		var ramanThCell = ipaTable.getCell(i,"ramanThreshold");
		var ramanThCellShowValue = ipaTable.getCellShow(i,"ramanThreshold","ramanThreshold").getValue();
		if (ramanThCellShowValue == "-")
		{
			var ramanThCellShow = ipaTable.getCellShow(i,"ramanThreshold","ramanThreshold");
			setCellStatus(ramanThCell,ramanThCellShow,"0");
		}
		else
		{
			textCheck(cell.element, "-60.0", "0.0");
		}
		/*
		if (isALSEnabled != "Enabled")
		{
			setCellStatus(ramanThCell,ramanThCellShow,"0");
		}
		else
		{
			textCheck(cell.element, "-60.0", "0.0");
		}*/
		
		if (ipaTable.getCellStoreValue(i, "ramanBoard", "ramanBoard") == "NULL")
		{
		 
		    var ropCardCellEle = ipaTable.getCell(i,"ropCard");
		    ropCardCellEle.element.modify = false;
		    ipaTable.setCellIsEdit(ropCardCellEle,"0");
   		    ropCardCellEle.element.ondblclick = null;
		    ropCardCellEle.element.style.cursor = "";
    		 
	    }
		
		if (!ipaTable.getCellStoreValue(i, "RMNALMFLAG", "RMNALMFLAG"))
		{
			var rmcell = ipaTable.getCell(i, "RMNALMFLAG");
			rmcell.element.modify = false;
			ipaTable.setCellIsEdit(rmcell, "0");
			rmcell.element.ondblclick = null;
			rmcell.element.style.cursor = "";
			ipaTable.setAtomValue(ipaTable.getCellShow(i, "RMNALMFLAG"), "-");
		}

		if (!ipaTable.getCellStoreValue(i, "RXLOSTH", "RXLOSTH"))
		{
			var rxcell = ipaTable.getCell(i, "RXLOSTH");
			rxcell.element.modify = false;
			ipaTable.setCellIsEdit(rxcell, "0");
			rxcell.element.ondblclick = null;
			rxcell.element.style.cursor = "";
			ipaTable.setAtomValue(ipaTable.getCellShow(i, "RXLOSTH"), "-");
		}
		else
		{
			cellEdit = ipaTable.getCellEdit(i, "RXLOSTH");
			if (null != cell)
			{
				textCheckWithStepLen(cellEdit.element, "-35.0", "-14.0", "1.0");
			}
		}
		
		var auxDectectBoard = ipaTable.getCellShow(i, "auxDectectBoard").getValue();
		var auxiliaryRamanCard = ipaTable.getCell(i, "auxiliaryRamanCard");
		var ropCard = ipaTable.getCell(i, "ropCard");
		if (auxDectectBoard.indexOf("14FIU") != -1)
		{
			ipaTable.setCellIsEdit(auxiliaryRamanCard, 0);
			ipaTable.setCellIsEdit(ropCard, 0);
		}
		else
		{
			ipaTable.setCellIsEdit(auxiliaryRamanCard, 1);
			ipaTable.setCellIsEdit(ropCard, 1);
		}
	}
}

function changeReBootType(indexSM, rebootType)
{
    var degthcellSM = ipaTable.getCell(indexSM,"securityEnable");
	var degthcellshowSM = null;
	if (degthcellSM != undefined && degthcellSM != null)
	{
		degthcellshowSM = ipaTable.getCellShow(indexSM,"securityEnable","securityEnable");
	}
	
	if (rebootType == "AUTO")
	{
		if (degthcellSM != undefined && degthcellSM != null)
		{
			degthcellSM.element.modify = false;
    		ipaTable.setCellIsEdit(degthcellSM,"0");
    		degthcellSM.element.style.backgroundColor = "";
    		degthcellSM.element.ondblclick = null;
    		degthcellSM.element.style.cursor = "";
    		degthcellshowSM.setValue("On");
			ipaTable.setCellValue(degthcellSM, "securityEnable", "Y");
		}
	}
	else if (rebootType == "MAN")
	{
		if (degthcellSM != undefined && degthcellSM != null)
		{
			degthcellSM.element.modify = true;
			degthcellSM.element.parentNode.modify = true;
			ipaTable.setCellIsEdit(degthcellSM,"1");
			degthcellSM.element.style.backgroundColor = "#d0f946";
			degthcellSM.element.ondblclick = cellondbclick;
		}
	}
}

function setRestartBtn()
{
	var selectedRows = ipaTable.getSelectedRows();
	var enabledFlag = false;
	for ( var j = 0; j < selectedRows.length; j++)
	{
		var bootype = ipaTable.getCellCurrentValue(selectedRows[j],
				"reBootType", "reBootType");
		var ipaEnable = ipaTable.getCellCurrentValue(selectedRows[j],
				"ipaEnable", "ipaEnable");
		if ("MAN" == bootype && "Y" == ipaEnable)
		{
			enabledFlag = true;
			break;
		}
	}
	$("restartbtn").disabled = !enabledFlag
	$("testbtn").disabled = !enabledFlag;
}

/**
 *           
 * 
 * @param  
 * @return  
 */
function rowSelectHandler(rows)
{
	var btnDisabledStatus = true;

	if (rows.length == 1)
	{
		$("checkbtn").disabled = false;
	}
	else
	{
		$("checkbtn").disabled = true;
	}

	if (rows.length > 0)
	{
		$("delipabtn").disabled = false;
		setRestartBtn();
	}
	else
	{
		$("delipabtn").disabled = true;
		$("restartbtn").disabled = true;
		$("testbtn").disabled = true;
	}
}

/**
 *             
 * 
 * @param  
 * @return  
 */
function cellEditHandler(param)
{
	$("applybtn").disabled = false;
	setTIDOnchangeModify(
			"../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="
					+ winobj["neid"], true);
	var st = param.st;
	var rowindex = param.rowindex;

	var raman = st.getCellStoreValue(rowindex, "ramanBoard", "ramanBoard");
	if (raman == "NULL")
	{
		var edit = st.getCellEdit(rowindex, "auxiliaryRamanCard");
		edit.clearOptions();
		edit.addOption("NULL", "-");

		edit = st.getCellEdit(rowindex, "ropCard");
		edit.clearOptions();
		edit.addOption("NULL", "-");
		return;
	}
	var usedBoardList = getUsedBoard(st);
	if ((param.colid == "auxiliaryRamanCard")
			&& (param.stage == TABLE_CONSTANT.BEFOREEDIT))
	{
		var edit = st.getCellEdit(rowindex, param.colid);
		var value = st.getCellStoreValue(rowindex, param.colid, param.colid);
		edit.clearOptions();
		var auxValue = st.getCellStoreValue(rowindex, "auxRamanList",
				"auxRamanList");
		var auxList = auxValue.split(",");
		for ( var i = 0, n = auxList.length; i < n; i++)
		{
			var ramanText = auxList[i].substring(auxList[i].indexOf("-") + 1);
			if (!usedBoardList.contains(ramanText) && ramanText != "")
			{
				edit.addOption(ramanText, ramanText);
			}
		}
		if (value != "NULL" && value != "-")
		{
			edit.addOption(value, value);
		}
		edit.addOption("NULL", "-");
	}
	if ((param.colid == "ropCard")
			&& (param.stage == TABLE_CONSTANT.BEFOREEDIT))
	{
		var edit = st.getCellEdit(rowindex, param.colid);
		var value = st.getCellStoreValue(rowindex, param.colid, param.colid);
		edit.clearOptions();
		var ropValue = st.getCellStoreValue(rowindex, "ropRamanList",
				"ropRamanList");
		var ropList = "";
		if (ropValue != "undefined")
		{
			ropList = ropValue.split(",");
		}
		for ( var i = 0, n = ropList.length; i < n; i++)
		{
			var ramanText = ropList[i].substring(ropList[i].indexOf("-") + 1);
			if (!usedBoardList.contains(ramanText) && ramanText != "")
			{
				edit.addOption(ramanText, ramanText);
			}
		}
		if (value != "NULL" && value != "-")
		{
			edit.addOption(value, value);
		}
		edit.addOption("NULL", "-");
	}
	
	if ((param.colid == "enableAls")
			&& (param.stage == TABLE_CONSTANT.AFTEREDIT))
	{
		var bandCell = ipaTable.getCell(rowindex,"ramanThreshold");
		var isedit = ipaTable.getCellIsEdit(bandCell);
		if (isedit == "1")
		{
			bandCell.element.modify = true;
			bandCell.element.parentNode.modify = true;
			bandCell.element.style.backgroundColor = "#d0f946";
			bandCell.element.ondblclick = cellondbclick;
		}					       	      	           			    		
	}
	
	if ((param.colid == "enableAls")
			&& (param.stage == TABLE_CONSTANT.AFTEREDIT))
	{
		var enableals = ipaTable.getCellStoreValue(rowindex, "enableAls", "enableAls");	
				
	    handleEnableAls(rowindex,enableals);
	}

}

function handleEnableAls(indexSM,bip8Value)
{
	var degthcellSM = ipaTable.getCell(indexSM,"ramanThreshold");
	var degthcellshowSM = null;
	if (degthcellSM != undefined && degthcellSM != null)
	{
		degthcellshowSM = ipaTable.getCellShow(indexSM,"ramanThreshold","ramanThreshold");
	}
	
	if (bip8Value == "Disabled")
	{
		if (degthcellSM != undefined && degthcellSM != null)
		{
			setCellStatus(degthcellSM,degthcellshowSM,"0");
		}
	}
	else if (bip8Value == "Enabled")
	{
		if (degthcellSM != undefined && degthcellSM != null)
		{
			setCellStatus(degthcellSM,degthcellshowSM,"1");
		}
	}
}

function setCellStatus(cell,cellShow,isEdit)
{
	if (isEdit == "0")
	{
		cell.element.modify = false;
		ipaTable.setCellIsEdit(cell,"0");
		cell.element.style.backgroundColor = "";
		cell.element.ondblclick = null;
		cell.element.style.cursor = "";
		cellShow.setValue("-");
	}
	else
	{
		if (cell.element.isEdit == "0")
		{
			cell.element.modify = true;
			cell.element.parentNode.modify = true;
			ipaTable.setCellIsEdit(cell,"1");
			cell.element.style.backgroundColor = "#d0f946";
			cell.element.ondblclick = cellondbclick;
			cellShow.setValue("-60.0");
			ipaTable.setCellValue(cell, "ramanThreshold", "-60.0");
		}
	}
}

function getUsedBoard(st)
{
	var usedBoard = [];
	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{

		var raman = st.getCellStoreValue(i, "ramanBoard", "ramanBoard");
		if (raman != "NULL")
		{
			usedBoard.push(raman);
		}
		var ramanAux = st.getCellStoreValue(i, "auxiliaryRamanCard",
				"auxiliaryRamanCard");
		if (ramanAux != "NULL")
		{
			usedBoard.push(ramanAux);
		}
		var ramanRop = st.getCellStoreValue(i, "ropCard", "ropCard");
		if (ramanRop != "NULL")
		{
			usedBoard.push(ramanRop);
		}
	}
	return usedBoard;
}

/**
 *   IPA
 * 
 * @param  
 * @return  
 */
function doQuery(rowindex)
{
	if (btnRightArr.querybtn.right == false)
	{
		return;
	}
	setTIDOnchangeModify(
			"../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="
					+ winobj["neid"], false);
	setButtonState(true, [ "querybtn" ]);
	setButtonState(true, [ "addipabtn" ]);
	setButtonState(true, [ "relaytimebtn" ]);

	var xmlData = createQueryXmlInfo();
	var url = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_GET_APSDPAIR + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackQuery, rowindex, "inputdata=" + xmlData);
}

/**
 *   IPA     
 * 
 * @param doc:       
 * @return  
 */
function callbackQuery(doc, rowindex)
{
	var data = EncapsulateData(doc);

	if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		ipaTable.clearTableData();

		createTableBody(ipaTable, ipaTableConf, data, RESOURCE);

		getUsedRes(data);



		initBtnStatue();

		if (netype == 70)
		{
			for ( var i = 0; i < ipaTable.getDataRowLength(); i++)
			{
				ipaTable.getCell(i, "ropCard").element.style.display = "none";
			}
		}
	}
	else
	{
		setButtonState(false, [ "querybtn" ]);
		setButtonState(false, [ "addipabtn" ]);
		setButtonState(false, [ "relaytimebtn" ]);
	}

	addCellEvent();
	
	if (rowindex != undefined)
	{
		ipaTable.setRowSelect(rowindex);
		rowSelectHandler(ipaTable.getSelectedRows());
	}

	showErrorPage(data, "query");
}

/**
 *           
 * 
 * @param  
 * @return  
 */
function getUsedRes()
{
	almPort.clear();
	cntlPort.clear();
	ramonBoard.clear();

	for ( var i = 0, len = ipaTable.getDataRowLength(); i < len; i++)
	{
		useredWPGID.push(ipaTable.getCellStoreValue(i, "ipaID", "ipaID"));

		ipaPort = new IPAPort();

		ipaPort.type = "alarm";
		ipaPort.slotid = ipaTable.getCellStoreValue(i, "alarmBoard",
				"alarmSlotid");
		ipaPort.boardname = ipaTable.getCellStoreValue(i, "alarmBoard",
				"alarmBoardName");
		ipaPort.port = ipaTable.getCellStoreValue(i, "alarmPort", "alarmPort");
		ipaPort.portname = ipaTable.getCellStoreValue(i, "alarmBoard",
				"alarmPortName");

		almPort.push(ipaPort);

		ipaPort = new IPAPort();

		ipaPort.type = "control";
		ipaPort.slotid = ipaTable.getCellStoreValue(i, "ctlBoard", "ctlSlotid");
		ipaPort.boardname = ipaTable.getCellStoreValue(i, "ctlBoard",
				"ctlBoardName");
		ipaPort.port = ipaTable.getCellStoreValue(i, "ctlPort", "ctlPort");
		ipaPort.portname = ipaTable.getCellStoreValue(i, "ctlBoard",
				"ctlPortName");

		cntlPort.push(ipaPort);

		ipaPort = new IPAPort();
		ipaPort.type = "raman";
		ipaPort.neid = ipaTable.getCellStoreValue(i, "ramanID", "ramonNeid");
		ipaPort.nename = ipaTable.getCellStoreValue(i, "raman", "ramonNeName");
		ipaPort.slotid = ipaTable.getCellStoreValue(i, "raman", "ramonSlotid");
		ipaPort.boardname = ipaTable.getCellStoreValue(i, "raman",
				"ramonBoardName");

		ramonBoard.push(ipaPort);
	}

}

/**
 *       IPA XML  
 * 
 * @param  
 * @return  
 */
function createQueryXmlInfo()
{
	var di = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");

	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *   IPA    
 * 
 * @param  
 * @return  
 */
function doAddIPA()
{

	queryAvailabeRes();
	if (hasAvailabeRes)
	{
		showModalDialog(
				"ipacreate.html",
				window,
				"dialogHeight:500px;dialogWidth:620px;center:yes;help:no;resizable:Yes;status:No;");
	}
	else
	{
		alert(RESOURCE["ID_NOEMPTYBRD"]);
	}
}

/**
 *   IPA    
 * 
 * @param  
 * @return  
 */
function doDeleteIPA()
{
	hideMenu();
	if (0 == ipaTable.getSelectedRowCount())
	{
		alert(RESOURCE["ID_SELECT"]);
	}
	else
	{
		if (!confirm(RESOURCE["ID_APRDELPROMPT"]))
		{
			return;
		}

		setButtonState(true, [ "delipabtn" ]);

		var xmlData = createDeleteIPAXmlInfo();
		var url = "../../../../../../tl1NEExlorerServlet?sfid="
				+ TECMDCODE_DEL_APSDPAIR + "&nmUser=" + winobj["nmUser"];
		loadXMLdoc(url, "POST", true, callbackDeleteIPA, null, "inputdata="
				+ xmlData);
	}
}

/**
 *   IPA     
 * 
 * @param  
 * @return  
 */
function callbackDeleteIPA(doc)
{
	var dataInterface = EncapsulateData(doc);

	if (dataInterface.getSErrorCode() == 0)
	{
		setTIDOnchangeModify(
				"../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="
						+ winobj["neid"], false);
	}

	var faultIPAList = [];
	var faultIPAStr;

	for ( var i = 0, len = dataInterface.getBErrLength(); i < len; i++)
	{
		faultIPAStr = dataInterface.getBErrParam(i, "alarmSlotid")
				+ dataInterface.getBErrParam(i, "alarmPort")
				+ dataInterface.getBErrParam(i, "ctlSlotid")
				+ dataInterface.getBErrParam(i, "ctlPort");
		faultIPAList.push(faultIPAStr);
	}

	ipaTable.adjustDataRows();


	getUsedRes();

	showErrorPage(dataInterface);

	if (faultIPAList.length > 0)
	{
		setButtonState(false, [ "delipabtn" ]);
	}
	reSetButtonStatue();
	doQuery();
}

/**
 *       IPA XML  
 * 
 * @param  
 * @return  
 */
function createDeleteIPAXmlInfo()
{
	var di = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	var selectRows = ipaTable.getSelectedRows();

	for ( var i = 0, selectRowCount = ipaTable.getSelectedRowCount(); i < selectRowCount; i++)
	{
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "alarmSlotid");
		param.setAttribute("value", ipaTable.getCellStoreValue(selectRows[i],
				"alarmBoard", "alarmSlotid"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "alarmPort");
		param.setAttribute("value", ipaTable.getCellStoreValue(selectRows[i],
				"alarmPort", "alarmPort"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "ctlSlotid");
		param.setAttribute("value", ipaTable.getCellStoreValue(selectRows[i],
				"ctlBoard", "ctlSlotid"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "ctlPort");
		param.setAttribute("value", ipaTable.getCellStoreValue(selectRows[i],
				"ctlPort", "ctlPort"));
		row.appendChild(param);
		
		var ramanBoardSlot = ipaTable.getCellStoreValue(selectRows[i], "ramanBoardSlot", "ramanBoardSlot");
		if (ramanBoardSlot != "")
		{
			param = new tagElement("param");
			param.setAttribute("name", "ramonSlotid");
			param.setAttribute("value", ramanBoardSlot);
			row.appendChild(param);
		}

		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *        
 * 
 * @param  
 * @return  
 */
function doApply()
{
	var xmlData = createApplyXmlInfo();
	if (null == xmlData)
	{
		return;
	}

	setButtonState(true, [ "applybtn" ]);
	var url = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_SET_APSDPAIR + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackApply, null, "inputdata=" + xmlData);
}

/**
 *   IPA     
 * 
 * @param  
 * @return  
 */
function callbackApply(doc)
{
	var dataInterface = EncapsulateData(doc);

	if (0 != dataInterface.getSErrorCode())
	{
		$("applybtn").disabled = false;
	}

	if (dataInterface.getSErrorCode() == 0)
	{
		setTIDOnchangeModify(
				"../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="
						+ winobj["neid"], false);
	}

	refreshTableState(ipaTable, ipaTableConf, dataInterface);

	showErrorPage(dataInterface, "set");

	rowSelectHandler(ipaTable.getSelectedRows());
}

/**
 *        XML  
 * 
 * @param  
 * @return  
 */
function createApplyXmlInfo()
{

	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var colid = null;
	var key = null;
	var colkeyarray = null;
	var cellModifyFlag = false;

	for ( var rowindex = 0, rowlen = ipaTable.getDataRowLength(); rowindex < rowlen; rowindex++)
	{
		if (!ipaTable.getModify(rowindex))
		{
			continue;
		}

		row = new tagElement("row-params");

		param = new tagElement("param");

		param.setAttribute("name", "neid");

		param.setAttribute("value", winobj["neid"]);

		row.appendChild(param);

		for ( var colindex = 0, collen = ipaTable.getColumnCount(); colindex < collen; colindex++)
		{
			colid = ipaTableConf.getColId(colindex);

			cellModifyFlag = ipaTable.getCellModify(rowindex, colid);

			colkeyarray = ipaTableConf.getColKeyArray(colindex);

			for ( var keyindex = 0, keylen = colkeyarray.length; keyindex < keylen; keyindex++)
			{
				param = new tagElement("param");

				key = colkeyarray[keyindex].name;

				param.setAttribute("name", key);
				
				var storeValue = ipaTable.getCellStoreValue(rowindex, colid, key);

				if (colid == "ramanThreshold" && cellModifyFlag)
				{
					if (storeValue == "-60.0" || storeValue == "-60")
					{
						storeValue = "INVALID";
					}
				}
				param.setAttribute("value", storeValue);

				param.setAttribute("modifyFlag", cellModifyFlag);
				
				if (cellModifyFlag)
				{
					if (key == "ramanThreshold" && !confirm(RESOURCE["SET_RAMONTHRESHOLD_INFO"]))
					{
						return null;
					}
					if (key == "RXLOSTH" && !confirm(RESOURCE["SET_DECTBOARDTHRESHOLD_INFO"]))
					{
						return null;
					}
				}
				
				if(cellModifyFlag && storeValue == "N")
    		    {
    		        if(key == "ipaEnable" && !confirm(RESOURCE["IPA_ENABLE_FLAG_DISABLE"]))
    		        {
    		            return null;
    		        }
    		        else if(key == "securityEnable" && !confirm(RESOURCE["SECURITY_CONTROL_DISABLE"]))
    		        {
    		            return null;
    		        }
    		    }
				
				if(cellModifyFlag && key == "ipaEnable" && storeValue == "Y")
				{
					if (!confirm(RESOURCE["IPA_DISABLE_FLAG_ENABLE"]))
					{
						return null;
					}
					var alarmSlotid = ipaTable.getCellStoreValue(rowindex, "alarmBoard", "alarmSlotid");
					var auxDectectBoard = ipaTable.getCellShow(rowindex, "auxDectectBoard").getValue();
					if (alarmSlotid == 0 && auxDectectBoard == "")
					{
						alert(RESOURCE["ID_DECTECTBOARDLIMITIFENABLE"]);
						return null;
					}
				}
				/*
				if (colid == "enableAls" && cellModifyFlag && storeValue == "Disabled")
				{
					var cellValue = ipaTable.getCellStoreValue(rowindex,
							"ramanBoardSlot", "ramanBoardSlot");
					var slotParam = new tagElement("param");
					slotParam.setAttribute("name", "slotid");
					slotParam.setAttribute("value", cellValue);
					row.appendChild(slotParam);
					
					var ramanThreshold = new tagElement("param");
					ramanThreshold.setAttribute("name", "ramanThreshold");
					ramanThreshold.setAttribute("value", "INVALID");
					row.appendChild(ramanThreshold);
				}*/
				if (colid == "ipaEnable" && cellModifyFlag && storeValue == "N")
				{
					var cellValue = ipaTable.getCellStoreValue(rowindex,
							"ramanBoardSlot", "ramanBoardSlot");
					var slotParam = new tagElement("param");
					slotParam.setAttribute("name", "ramonSlotid");
					slotParam.setAttribute("value", cellValue);
					row.appendChild(slotParam);
				}
				
				if (colid == "ramanThreshold" && cellModifyFlag)
				{
					var cellValue = ipaTable.getCellStoreValue(rowindex,
							"ramanBoardSlot", "ramanBoardSlot");
					var slotParam = new tagElement("param");
					slotParam.setAttribute("name", "slotid");
					slotParam.setAttribute("value", cellValue);
					row.appendChild(slotParam);
				}
				if (colid == "auxiliaryRamanCard" && cellModifyFlag)
				{
					var auxParam = new tagElement("param");
					auxParam.setAttribute("name", "auxParam");
					auxParam.setAttribute("value", "NULL");
					row.appendChild(auxParam);
				}
				if (colid == "ropCard" && cellModifyFlag)
				{
					var ropParam = new tagElement("param");
					ropParam.setAttribute("name", "ropParam");
					ropParam.setAttribute("value", "NULL");
					row.appendChild(ropParam);
				}
				row.appendChild(param);

			}
		}

		bussiness.appendChild(row);
	}

	if (0 == bussiness.childNodes.length)
	{
		return null;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *             
 * 
 * @param  
 * @return  
 */
function doManualReBoot()
{
	hideMenu();
	if (0 == ipaTable.getSelectedRowCount())
	{
		alert(RESOURCE["ID_SELECT"]);
		return;
	}
	var xmlData = createBootIPAXmlInfo("MAN");

	if (null == xmlData)
	{
		return;
	}

	$("restartbtn").disabled = true;

	var url = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_START_APSDPAIR + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackManualReBoot, null, "inputdata="
			+ xmlData);
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function callbackManualReBoot(doc)
{
	$("restartbtn").disabled = false;

	var dataInterface = EncapsulateData(doc);

	showErrorPage(dataInterface);

}

/**
 *             
 * 
 * @param  
 * @return  
 */
function doTestBoot()
{
	hideMenu();
	if (0 == ipaTable.getSelectedRowCount())
	{
		alert(RESOURCE["ID_SELECT"]);
		return;
	}

	var xmlData = createBootIPAXmlInfo("TEST");
	if (null == xmlData)
	{
		return;
	}
	$("testbtn").disabled = true;

	var url = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_TEST_APSDPAIR + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackTestBoot, null, "inputdata="
			+ xmlData);
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function callbackTestBoot(doc)
{
	$("testbtn").disabled = false;

	var dataInterface = EncapsulateData(doc);

	showErrorPage(dataInterface);

}

/**
 *       IPA(           ) XML  
 * 
 * @param  
 * @return  
 */
function createBootIPAXmlInfo(flag)
{
	var di = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	var selectRows = ipaTable.getSelectedRows();

	for ( var i = 0, selectRowCount = ipaTable.getSelectedRowCount(); i < selectRowCount; i++)
	{
		if (ipaTable.getModify(selectRows[i]))
		{
			alert(RESOURCE["ID_SAVE"]);
			return null;
		}
		if ("Y" != ipaTable.getCellStoreValue(selectRows[i], "ipaEnable",
				"ipaEnable")
				|| "MAN" != ipaTable.getCellStoreValue(selectRows[i],
						"reBootType", "reBootType"))
		{
			continue;
		}

		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "alarmSlotid");
		param.setAttribute("value", ipaTable.getCellStoreValue(selectRows[i],
				"alarmBoard", "alarmSlotid"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "alarmPort");
		param.setAttribute("value", ipaTable.getCellStoreValue(selectRows[i],
				"alarmPort", "alarmPort"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "ctlSlotid");
		param.setAttribute("value", ipaTable.getCellStoreValue(selectRows[i],
				"ctlBoard", "ctlSlotid"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "ctlPort");
		param.setAttribute("value", ipaTable.getCellStoreValue(selectRows[i],
				"ctlPort", "ctlPort"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "FLAG");
		param.setAttribute("value", flag);
		row.appendChild(param);

		bussiness.appendChild(row);
	}

	if (0 == bussiness.childNodes.length)
	{
		return null;
	}

	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *             
 * 
 * @param  
 * @return  
 */
function doRelayTimeBoot()
{
	var xmlData = createQueryXmlInfo();

	$("relaytimebtn").disabled = true;

	var url = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_GET_APRALMDELAY + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, callbackRelayTime, null, "inputdata="
			+ xmlData);
}

/**
 *              
 * 
 * @param  
 * @return  
 */
function callbackRelayTime(doc)
{
	$("relaytimebtn").disabled = false;
	var data = EncapsulateData(doc);

	var delayTimes = 10;

	if (0 == data.getSErrorCode())
	{
		delayTimes = data.getDataRowParam(0, "delayTimes");
	}

	showModalDialog(
			"ipadelaytimesmgrdialog.html?neid=" + winobj["neid"]
					+ "&delayTimes=" + delayTimes,
			window,
			"dialogHeight:150px;dialogWidth:400px;center:yes;help:no;resizable:No;status:No;");
}



function doRamanEnable()
{
	$("ramanenablebtn").disabled = true;
	
	doRamanQuery();
}


function doRamanQuery()
{
    var xml = createRamanQueryXml();
    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + TECMDCODE_GET_RAMAN_ENABLE;
    loadXMLdoc(url, "POST", true, queryRamanCallback, null, "inputdata=" + xml);
}

function createRamanQueryXml()
{
    var di = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj["neid"]);
    row.appendChild(param);
	 
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryRamanCallback(doc)
{
    $("ramanenablebtn").disabled = false;
    var data = EncapsulateData(doc);
    var enable = null;
    if(0 == data.getSErrorCode())
    {		
        ramanStatus = data.getDataRowParam(0,"ramanStatus");
    }
    xshowModalDialog("ramanEnable.html?neid="+winobj["neid"]+"&ramanStatus="+ramanStatus,"","460px","115px","../../../../../images/");	
}


/**
 *              
 * 
 * @param  
 * @return  
 */
function doAssistantCheck()
{
	var selectRowCount = ipaTable.getSelectedRowCount();

	if (0 == selectRowCount)
	{
		alert(RESOURCE["ID_SELECT"]);
		return;
	}

	else if (selectRowCount > 1)
	{
		alert(RESOURCE["ID_ONCEAIPA"]);
		return;
	}

	queryAssisCheckBoard();
	
	var selectRowsIndex = ipaTable.getSelectedRows()[0];
	var alarmBoard = ipaTable.getCellStoreValue(selectRowsIndex, "alarmBoard", "alarmBoard");  //
	var ramanBoard = ipaTable.getCellShow(selectRowsIndex, "ramanBoard").getValue();  //
	var auxiliaryRamanCard = ipaTable.getCellStoreValue(selectRowsIndex, "auxiliaryRamanCard", "auxiliaryRamanCard");  //
	var ropCard = ipaTable.getCellStoreValue(selectRowsIndex, "ropCard", "ropCard");  //
	if (alarmBoard == undefined && ramanBoard.indexOf("11RAU1") != -1 && auxiliaryRamanCard == "NULL" && ropCard == "NULL")
	{
		isSupport14FIUAsAssisBoardFlag = true;
	}
	else
	{
		isSupport14FIUAsAssisBoardFlag = false;
	}

	showModalDialog(
			"assistantcheckboardmgr.html",
			window,
			"dialogHeight:450px;dialogWidth:600px;center:yes;help:no;resizable:Yes;status:No;");
}

/**
 *        
 * 
 * @param  
 * @return  
 */
function queryAssisCheckBoard()
{
	var xmlData = createQeryAssisCheckBoardXmlInfo();

	var url = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMD_CODE_QUERY_IPAMONPARA + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackQeryAssisCheckBoard, null,
			"inputdata=" + xmlData);
}

/**
 *             
 * 
 * @param  
 * @return  
 */
function callbackQeryAssisCheckBoard(doc)
{

	assistantCheckBoard.clear();
	selectedAssisBoard.clear();
	allUsedAssisBoard.clear();

	var dataInterface = EncapsulateData(doc);

	var ipaPort;
	for ( var i = 0, len = dataInterface.getDataRowLength(); i < len; i++)
	{
		ipaPort = new IPAPort();

		ipaPort.type = "assistant";
		ipaPort.neid = dataInterface.getDataRowParam(i, "neid");
		ipaPort.nename = dataInterface.getDataRowParam(i, "nename");
		ipaPort.slotid = dataInterface.getDataRowParam(i, "slotid");
		ipaPort.boardid = dataInterface.getDataRowParam(i, "boardid");
		ipaPort.boardname = dataInterface.getDataRowParam(i, "boardname");
		ipaPort.port = dataInterface.getDataRowParam(i, "port");
		ipaPort.portname = dataInterface.getDataRowParam(i, "portname");
		ipaPort.subrackName = dataInterface.getDataRowParam(i, "subrackName");
		ipaPort.wdmcptype = dataInterface.getDataRowParam(i,"wdmcptype");
		
		if (ipaPort.neid = dataInterface.getDataRowParam(i, "type") == "selected")
		{
			selectedAssisBoard.push(ipaPort);
			if (!allUsedAssisBoard.contains(ipaPort.toString()))
			{
				allUsedAssisBoard.push(ipaPort);
			}
		}
		else
		{
			assistantCheckBoard.push(ipaPort);
		}
	}

	if (ipaTable.getSelectedRowCount() == 1)
	{
		var rowIndex = ipaTable.getSelectedRows()[0];
		ipaTable.setAtomValue(ipaTable.getCellElement(rowIndex,
				"auxDectectBoard").showElement, selectedAssisBoard.toString());
	}
	assistantCheckBoard.sort(flexibleCompare);
	selectedAssisBoard.sort(flexibleCompare);
	allUsedAssisBoard.sort(flexibleCompare);
}

function updateUsedAssisBoard(dataInterface)
{
	for ( var i = 0, len = dataInterface.getDataRowLength(); i < len; i++)
	{
		var assisBoard = dataInterface.getDataRowParam(i, "auxDectectBoard");
		var neid = dataInterface.getDataRowParam(i, "neid");
		var nename = dataInterface.getDataRowParam(i, "nename");
		var ipaPortArr = convertAssisBoardDataToArray(assisBoard, neid, nename);
		for ( var j = 0, size = ipaPortArr.length; j < size; j++)
		{
			var ipaPort = ipaPortArr[j];

			if (!allUsedAssisBoard.contains(ipaPort.toString()))
			{
				allUsedAssisBoard.push(ipaPort);
			}

		}
	}
}

function convertAssisBoardDataToArray(assisBoardStr, neid, nename)
{
	var ipaPort = new Array();
	if (assisBoardStr == "")
	{
		return ipaPort;
	}
	var strArr = assisBoardStr.split(",");
	var struct;
	for ( var i = 0, len = strArr.length; i < len; i++)
	{
		struct = strArr[i];
		var structarr = struct.split("-");
		var ipaport = new IPAPort();
		ipaport.neid = neid;
		ipaport.nename = nename;
		ipaport.slotid = structarr[0];
		ipaport.boardname = structarr[1];
		ipaport.portname = structarr[2];
		ipaport.port = structarr[2].substring(0, structarr[2].indexOf("("));

		ipaPort.push(ipaport);
	}

	return ipaPort;
}

/**
 *             XML  
 * 
 * @param  
 * @return  
 */
function createQeryAssisCheckBoardXmlInfo()
{
	var di = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	var selectRows = ipaTable.getSelectedRows();

	for ( var i = 0, selectRowCount = ipaTable.getSelectedRowCount(); i < selectRowCount; i++)
	{
		var alarmSlotID = ipaTable.getCellStoreValue(selectRows[i],
				"alarmBoard", "alarmSlotid");
		var alarmPort = ipaTable.getCellStoreValue(selectRows[i],
				"alarmPort", "alarmPort");
		var ctlSlotid = ipaTable.getCellStoreValue(selectRows[i],
				"ctlBoard", "ctlSlotid");
		var ctlPort = ipaTable.getCellStoreValue(selectRows[i],
				"ctlPort", "ctlPort");
		var row = createDectectBoardParamRow(alarmSlotID,alarmPort,ctlSlotid,ctlPort);

		bussiness.appendChild(row);
	}
	if(bussiness.childNodes.length == 0)
    {
	    bussiness.appendChild(createDectectBoardParamRow(0,0,0,0));
    }

	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *              
 */
function createDectectBoardParamRow(alarmSlotID,alarmPort,ctlSlotID,ctlPort)
{
	row = new tagElement("row-params");

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "alarmSlotid");
	param.setAttribute("value", alarmSlotID);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "alarmPort");
	param.setAttribute("value", alarmPort);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "ctlSlotid");
	param.setAttribute("value", ctlSlotID);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "ctlPort");
	param.setAttribute("value", ctlPort);
	row.appendChild(param);
    
    return row;
}

/**
 *     IPA     
 * 
 * @param  
 * @return  
 */
function queryAvailabeRes()
{
	var xmlData = createQueryAvailabeResXML();
	var url = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_GET_APSD_SELECTABLEPORT + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", false, callbackQueryAvailabeRes, null, "inputdata="
			+ xmlData);
}

/**
 *     IPA          
 * 
 * @param  
 * @return  
 */
function callbackQueryAvailabeRes(doc)
{
	availableAlmPort.clear();
	availableCntlPort.clear();
	availableRamonBoard.clear();
	assistantCheckBoard.clear();

	var dataInterface = EncapsulateData(doc);
	var ipaPort;
	for ( var i = 0, len = dataInterface.getDataRowLength(); i < len; i++)
	{
		ipaPort = new IPAPort();

		ipaPort.type = dataInterface.getDataRowParam(i, "type");
		ipaPort.neid = dataInterface.getDataRowParam(i, "neid");
		ipaPort.nename = dataInterface.getDataRowParam(i, "nename");
		ipaPort.slotid = dataInterface.getDataRowParam(i, "slotid");
		ipaPort.boardid = dataInterface.getDataRowParam(i, "boardid");
		ipaPort.boardname = dataInterface.getDataRowParam(i, "boardname");
		ipaPort.port = dataInterface.getDataRowParam(i, "port");
		ipaPort.portname = dataInterface.getDataRowParam(i, "portname");
		ipaPort.subrackName = dataInterface.getDataRowParam(i, "subrackName");

		if (ipaPort.type == "alarm")
		{
			var flag = true;
			for ( var j = 0; j < almPort.length; j++)
			{
				if (almPort[j].toString() == ipaPort.toString())
				{
					flag = false;
					break;
				}
			}
			if (flag)
			{
				availableAlmPort.push(ipaPort);
			}
		}
		else if (ipaPort.type == "control") //    
		{
			var flag = true;
			for ( var j = 0; j < cntlPort.length; j++)
			{
				if (cntlPort[j].toString() == ipaPort.toString())
				{
					flag = false;
					break;
				}
			}
			if (flag)
			{
				availableCntlPort.push(ipaPort);
			}
		}
		else if (ipaPort.type == "assistant") //      
		{
			assistantCheckBoard.push(ipaPort);
		}
		else
		{
			var flag = true;
			for ( var j = 0; j < ramonBoard.length; j++)
			{
				if (ramonBoard[j].toString() == ipaPort.toString())
				{
					flag = false;
					break;
				}
			}
			if (flag)
			{
				availableRamonBoard.push(ipaPort);
			}
		}
	}
	availableAlmPort.sort(flexibleCompare);
	availableCntlPort.sort(flexibleCompare);
	assistantCheckBoard.sort(flexibleCompare);
	availableRamonBoard.sort(flexibleCompare);
	
	if (0 != availableCntlPort.length)
	{
		hasAvailabeRes = true;
	}
	else
	{
		hasAvailabeRes = false;
	}
}

/**
 *     IPA      XML  
 * 
 * @param  
 * @return  
 */
function createQueryAvailabeResXML()
{
	var di = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	row = new tagElement("row-params");

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *    IPA  ID
 * 
 * @param
 * @return Array    IPA  ID
 */
function getAvailableWPGID()
{
	var availableWPGIDLen = MAX_IPA_ID - ipaTable.getDataRowLength();

	availableWPGID = getRangeNumber(useredWPGID, MIN_IPA_ID, MAX_IPA_ID,
			availableWPGIDLen);
}

/**
 *         
 * 
 * @param doc
 *                   
 * @return  
 */
function showErrorPage(data, flag)
{
	var tmp = "";
	if (flag)
	{
		tmp = RESOURCE[flag];
	}

	var alarmBoard = getAttrName(ipaTableConf, "alarmBoard");
	var ctlBoard = getAttrName(ipaTableConf, "ctlBoard");
	var reobj;
	var errArridStr;

	var errArr = [];
	errArr.push("nename");
	openErrPage("../../../../../../page/", data.getError(), errArr);
}

/**
 *       
 * 
 * @param disabledState
 *                 btnIDArr:         ID  
 * @return  
 */
function setButtonState(disabledState, btnIDArr)
{
	if (null == btnIDArr || btnIDArr.length == 0)
	{
		btnIDArr = [];
		btnIDArr.push("querybtn");
		btnIDArr.push("addipabtn");
		btnIDArr.push("delipabtn");
		btnIDArr.push("applybtn");
		btnIDArr.push("restartbtn");
		btnIDArr.push("relaytimebtn");
		btnIDArr.push("checkbtn");
		btnIDArr.push("testbtn");
	}

	for ( var i = 0; i < btnIDArr.length; i++)
	{
		if (btnRightArr[btnIDArr[i]].right == true)
		{
			$(btnIDArr[i]).disabled = disabledState;
		}

	}
}

/*
 *   IPA        
 */
function reSetButtonStatue()
{
	if (ipaTable.getSelectedRowCount() > 0)
	{
		$("delipabtn").disabled = false;
		$("restartbtn").disabled = false;
		$("testbtn").disabled = false;
		if (ipaTable.getSelectedRowCount > 1)
		{
			$("checkbtn").disabled = true;
		}
		else
		{
			$("checkbtn").disabled = false;
		}
	}
	else
	{
		$("delipabtn").disabled = true;
		$("restartbtn").disabled = true;
		$("testbtn").disabled = true;
		$("checkbtn").disabled = true;
	}

	$("applybtn").disabled = true;

	for ( var i = 0; i < ipaTable.getDataRowLength(); i++)
	{
		if (ipaTable.getModify(i))
		{
			$("applybtn").disabled = false;
			break;
		}
	}

}

/**
 *   common.js               
 * 
 * @param res:    
 *            obj     /   key:     
 * @return String      
 */
function convertMsg(res, obj, key)
{
	if ("function" == (typeof obj))
	{
		return obj(key);
	}
	else
	{
		if (null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if (null == resValue)
		{
			resValue = key;
		}
		return resValue;
	}
}

/**
 * IPA    
 * 
 * @param  
 * @return  
 */
function IPAPort()
{
	this.type = "";
	this.neid = -1;
	this.nename = "";
	this.slotid = 0;
	this.boardid = 0;
	this.boardname = "";
	this.port = 0;
	this.portname = "";
	this.subrackName = "";
	this.wdmcptype = "";
}

/**
 * IPA       
 * 
 * @param  
 * @return  
 */
IPAPort.prototype.equals = function(obj)
{
	return (obj.type == this.type && obj.neid == this.neid
			&& obj.slotid == this.slotid && obj.port == this.port)
}

/**
 * IPA     toString  
 * 
 * @param  
 * @return String :IPA     String  
 */
IPAPort.prototype.toString = function()
{
	if (this.type.indexOf("raman") != -1)
	{
		if (this.subrackName != "")
		{
			return this.neid + "-" + this.nename + "-" + this.subrackName + "-"
					+ getSlotIDFromSlot(this.slotid) + "-" + this.boardname;
		}
		else
		{
			return this.neid + "-" + this.nename + "-" + this.slotid + "-"
					+ this.boardname;
		}
	}
	else
	{
		if (this.subrackName != "")
		{
			return this.subrackName + "-" + getSlotIDFromSlot(this.slotid)
					+ "-" + this.boardname + "-" + this.portname;
		}
		else
		{
			return this.slotid + "-" + this.boardname + "-" + this.portname;
		}
	}
}

/**
 *   IPA    value    100               value  100      
 * 
 * @param  
 * @return String :
 */
IPAPort.prototype.toStruct = function()
{
	if (this.type.indexOf("raman") != -1)
	{
		return this.neid + "-" + this.nename + "-" + this.slotid + "-"
				+ this.boardname;
	}
	else if (this.type.indexOf("assistant") != -1)
	{
		return this.slotid + "-"+ this.port + "-" + this.wdmcptype;
	}
	else
	{
		return this.slotid + "-" + this.boardname + "-" + this.portname;
	}
}

/*
 *        -  -    -    -          
 *                          
 */
function flexibleCompare(str1, str2)
{
    if(typeof(str1) == 'object')
    {
        str1 = str1.toStruct();
        str2 = str2.toStruct();
    }
    
    var arr1 = str1.split('-');
    var arr2 = str2.split('-');
    var a,b,result;
    
    for(var i = 0, len = arr1.length; i < len; i++)
    {
        if(isNaN(parseInt(arr1[i])))
        {
            a = arr1[i];
            b = arr2[i];
        } else {
            a = parseInt(arr1[i]);
            b = parseInt(arr2[i]);
        }

        result = compare(a, b);
        
        if( result == 0)
        {
            continue;
        } else {
            return result;
        }
    }
    
    return 0;
}
/**
 *       
 * 
 * @param  
 * @return  
 */
function sendRightInfo()
{
	var url = "../../../../../../securityServlet?neID=" + winobj["neid"]
			+ "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata="
			+ createRightXML());
}

/**
 *           
 * 
 * @param  
 * @return  
 */
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);

	for ( var i = 0; i < data.getDataRowLength(); i++) //        
	{
		var right = data.getDataRowParam(i, "right");

		if (0 == right)
		{
			btnRightArr[data.getDataRowParam(i, "btnID")].right = false;
		}
		else
		{
			btnRightArr[data.getDataRowParam(i, "btnID")].right = true;
		}
	}
	initBtnStatue();
}

/**
 *           XML
 * 
 * @param  
 * @return  
 */
function createRightXML()
{
	var root = new inputxml("datainterface");// Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");

	var secondlevel = null;
	;
	var thirdlevel = null;

	for ( var btnrightobj in btnRightArr)
	{
		secondlevel = new tagElement("row-params"); // bean         

		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "btnID");
		thirdlevel.setAttribute("value", btnRightArr[btnrightobj].btnId);
		secondlevel.appendChild(thirdlevel);

		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "sfid");
		thirdlevel.setAttribute("value", btnRightArr[btnrightobj].sfid);
		secondlevel.appendChild(thirdlevel);

		firstlevel.appendChild(secondlevel);
	}
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *        
 * 
 * @param btnId       ID 
 *            sfid             ID
 * @return  
 */
function BtnRightObj(btnId, sfid)
{
	if (null != btnId)
	{
		this.btnId = btnId;
	}
	else
	{
		this.btnId = "";
	}

	if (isNaN(parseInt(sfid)))
	{
		this.sfid = -1;
	}
	else
	{
		this.sfid = sfid;
	}
	this.right = true;
}

/**
 * BtnRightObj   toString  
 * 
 * @param  
 * @return String :IPA     String  
 */
BtnRightObj.prototype.toString = function()
{
	var str = "The button's Id = " + this.btnId + " sfid = " + this.sfid
			+ " right = " + this.right;
	return str;
}

window.onresize = function()
{
	ipaTable.setBodyHeight(getComponetHeight($("tablecomponent"), 100) + "px");
}

function popupMenuHandler(evt)
{
	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}

	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	if (rows.contains(rowid))
	{
		if (null != elem.editElement && elem.isEdit == 1)
		{
			createTablePopupMenu(elem, evt);
			return;
		}

		for ( var i = 0; i < rows.length; i++)
		{
			var tmpElem = elem.parent.getCellElement(rows[i], colid);
			if (null != tmpElem.editElement && tmpElem.isEdit == 1)
			{
				createTablePopupMenu(tmpElem, evt);
				return;
			}
		}
		createFuncPopupMenu(rows, evt);
	}
}

function createFuncPopupMenu(rows, evt)
{
	removejsDOMmenu();
	var isBootFlag = false; //        
	for ( var i = 0; i < rows.length; i++)
	{
		if ("Y" == ipaTable
				.getCellStoreValue(rows[i], "ipaEnable", "ipaEnable")
				&& "MAN" == ipaTable.getCellStoreValue(rows[i], "reBootType",
						"reBootType"))
		{
			isBootFlag = true;
			break;
		}
	}
	var cursorMenu1 = new jsDOMenu(150);
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["restartbtn"], "",
			doManualReBoot, null, isBootFlag));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["testbtn"], "", doTestBoot,
			null, isBootFlag));
	cursorMenu1.addMenuItem(new menuItem('-'));
	cursorMenu1
			.addMenuItem(new menuItem(RESOURCE["delipabtn"], "", doDeleteIPA));
	setPopUpMenu(cursorMenu1);
	showMenu(evt);

}
