
document.title = RESOURCE["configuretitle"]; 
var win = getParentWindow();  //     
var st = win.st;
var resource = win.resource;

function init()
{
	initTitle();
	initData();
}

function initTitle()
{	
	$("slotlabel").innerText = RESOURCE["slotlabel"];
	$("portlabel").innerText = RESOURCE["portlabel"];
	$("directionlabel").innerText = RESOURCE["directionlabel"];
	$("selectlabel").innerText = RESOURCE["selectlabel"];
	$("selectedlabel").innerText = RESOURCE["selectedlabel"];

	$("ok").value = RESOURCE["okbutton"];
	$("cancel").value = RESOURCE["cancelbutton"];
	$("apply").value = RESOURCE["applybutton"];
}

function initData()
{	
	var elem = $("direction");
	elem.options[elem.options.length] = new Option(RESOURCE["up"], "1");
	elem.options[elem.options.length] = new Option(RESOURCE["down"], "2");
	
    var length = resource.getDataRowLength();
    for (var i = 0; i < length; i++)
    {
    	var slotId = resource.getDataRowParam(i, "slotid");
    	var boardName = resource.getDataRowParam(i, "boardname");
    	$("slotid").options[$("slotid").options.length] = new Option(slotId + "-" + boardName, slotId);
    }
    var port = resource.getDataRowParam(0, "port");
    $("portid").options[$("portid").options.length] = new Option(port, port);
    var portOptions = resource.getDataRowOptions(0, "port");
    for (var j = 0, m = portOptions.length; j < m; j++)
    {
    	$("portid").options[$("portid").options.length] = new Option(portOptions[j], portOptions[j]);
    }
    	
    var serviceLevel = resource.getDataRowParam(0, "servicelevel");
    var pathOptions = resource.getDataRowOptions(0, "path");
    for (var k = 0, n = pathOptions.length; k < n; k++)
    {
    	var path = pathOptions[k];
    	var portid = path.substring(0, path.indexOf("-"));
    	if (port.substring(0, port.indexOf("(")) == portid)
    	{
    		var pathes = path.substring(path.indexOf("-") + 1).split(",");
    		setSeledtedOption(serviceLevel, pathes);
    		break;
    	}
    }
}

function setSeledtedOption(serviceLevel, pathes)
{
	var slotId = $("slotid").value;
	var port = $("portid").value;
	var portId = port.substring(0, port.indexOf("("));
	var direction = $("direction").value;
	
	var flag1 = true;
	for (var i = 0, n = st.getDataRowLength(); i < n; i++)
	{
		var oldSlotId = st.getCellStoreValue(i, "port", "slotid");
		var oldPort = st.getCellStoreValue(i, "port", "portname");
		var oldPortId = oldPort.substring(0, oldPort.indexOf("("));
		var oldDirection = st.getCellStoreValue(i, "direction", "direction");
		if (slotId == oldSlotId && portId == oldPortId && direction == oldDirection)
		{
			flag1 = false;
			var tmp = st.getCellStoreValue(i, "boundpath", "boundpath");
			var oldPathes = tmp.substring(tmp.indexOf("(") + 1, tmp.indexOf(")")).split(",");
			for (var j = 0, m = pathes.length; j < m; j++)
			{
				var flag2 = true;
				var tmpPath = pathes[j];
				for (var k = 0, mn = oldPathes.length; k < mn; k++)
				{
					if (tmpPath == oldPathes[k])
					{
						flag2 = false;
						$("selected").options[$("selected").options.length] = new Option(serviceLevel + "-" + tmpPath, tmpPath);
						break;
					}
				}
				if (flag2)
				{
					$("select").options[$("select").options.length] = new Option(serviceLevel + "-" + tmpPath, tmpPath);
				}
			}	
		}		
	}
	if (flag1)
	{
		$("selected").options[$("selected").options.length] = new Option(serviceLevel + "-" + pathes[0], pathes[0]);
    	for (var ii = 1, mm = pathes.length; ii < mm; ii++)
    	{
    		$("select").options[$("select").options.length] = new Option(serviceLevel + "-" + pathes[ii], pathes[ii]);
    	}
	} 
}

function linkageBySlot()
{
	clearSelect($("portid"));
	var oldSlotId = $("slotid").value;
	var length = resource.getDataRowLength();	
    for (var i = 0; i < length; i++)
    {
    	var slotId = resource.getDataRowParam(i, "slotid");
    	if (oldSlotId == slotId)
    	{    	
    		var port = resource.getDataRowParam(i, "port");
    		$("portid").options[$("portid").options.length] = new Option(port, port);
    		var portOptions = resource.getDataRowOptions(i, "port");
    		for (var j = 0, m = portOptions.length; j < m; j++)
    		{
    			$("portid").options[$("portid").options.length] = new Option(portOptions[j], portOptions[j]);
    		}
    		break;
    	}
    }
    linkageByPort();
}

function linkageByPort()
{
	$("direction").selectedIndex = 0;
	linkageByDirection();
}

function linkageByDirection()
{
	clearSelect($("select"));
	clearSelect($("selected"));
	
	var oldSlotId = $("slotid").value;
	var port = $("portid").value;
	
	var length = resource.getDataRowLength();	
    for (var i = 0; i < length; i++)
    {
    	var slotId = resource.getDataRowParam(i, "slotid");
    	if (oldSlotId == slotId)
    	{    	
    		var serviceLevel = resource.getDataRowParam(i, "servicelevel");
    		var pathOptions = resource.getDataRowOptions(i, "path");
    		for (var k = 0, n = pathOptions.length; k < n; k++)
    		{
    			var path = pathOptions[k];
    			var portid = path.substring(0, path.indexOf("-"));
    			if (port.substring(0, port.indexOf("(")) == portid)
    			{
    				var pathes = path.substring(path.indexOf("-") + 1).split(",");
    				setSeledtedOption(serviceLevel, pathes);
    				break;
    			}
    		}
    		break;
    	}
    }
}

function clearSelect(elem)
{
	for (var i = elem.options.length - 1; i >= 0; i--)
	{
		elem.options[i] = null;
	}
}

function right()
{
	selectFunc($("select"), $("selected"));
}

function left()
{
	var index = $("selected").selectedIndex;
	if (index > 0)
	{
		selectFunc($("selected"), $("select"));		
	}
}

function selectFunc(e1, e2)
{
	var option = e1.options[e1.selectedIndex];		
	var value = option.value;
	var text = option.innerText;
	e1.options[e1.selectedIndex] = null;
		
	var oOptions = new Array();	
	for (var i = e2.options.length - 1; i >= 0; i--)
	{
		var oOption = e2.options[i];
		var tmp = oOption.value;
		if (parseInt(value) <= parseInt(tmp))
		{
			oOptions.push(oOption);
			e2.options[i] = null;
		}
	}
		
	e2.options[e2.options.length] = new Option(text, value);
		
	for (var j = oOptions.length - 1; j >= 0; j--)
	{
		e2.options[e2.options.length] = oOptions[j];
		delete(oOptions[j]);
	}
}

function createBoundPathXML()
{
	var slotId = $("slotid").value;
	var portId = $("portid").value.substring(0, $("portid").value.indexOf("("));
	var direction = $("direction").value;
	var selected = $("selected").options;
	var boundPathNum = selected.length;
	var pathStr = "";
	var boundPath = "";
	var ODU1V = "ODU1V";
	var DIRECTION_UP_VALUE = 1;
    var DIRECTION_DOWN_VALUE = 2;
	
	for (var i = 0; i < boundPathNum; i++)
	{
		if (i > 0)
		{
		    boundPath += "&";
		}
		boundPath += selected[i].value;
	}
	
	var root = new inputxml("datainterface");      
  	var firstlevel = new tagElement("bussiness-params");
  			
	var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "neid");
   	thirdlevel.setAttribute("value", win.neid);
   	secondlevel.appendChild(thirdlevel);
   	
   	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "slotid");
   	thirdlevel.setAttribute("value", slotId);
   	secondlevel.appendChild(thirdlevel);
   	
   	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "port");
   	thirdlevel.setAttribute("value", portId);
   	secondlevel.appendChild(thirdlevel);
   	
   	thirdlevel = new tagElement("param");
  	thirdlevel.setAttribute("name", "PATHTYPE");
   	thirdlevel.setAttribute("value", ODU1V);
   	secondlevel.appendChild(thirdlevel);
   	
   	
   	
   	thirdlevel = new tagElement("param");
   	if (direction == DIRECTION_UP_VALUE)
   	{
      	thirdlevel.setAttribute("name", "UPPATH");
   	}
   	else
   	{
   	    thirdlevel.setAttribute("name", "DOWNPATH");
   	}
   	thirdlevel.setAttribute("value", boundPath);
    secondlevel.appendChild(thirdlevel);
       	
   	
   	
   		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);	
	return root.toString();
}

function configureBoundPath()
{
	var xml = createBoundPathXML()
	var url = "../../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_CONFIG_BOUND_PATH+"&nmUser=" + win.nmUser;
	loadXMLdoc(url, "POST", false, callBackHandler, null, "inputdata=" + xml);
}

function callBackHandler(doc)
{
	var data = EncapsulateData(doc);
	showErrorDialog(data);
    if (0 == data.getSErrorCode())
    {
    	refreshBoundPathTable();
    	if (submitflag)
       	{
       	    xcloseDialog();
       	}
    }
}

function refreshBoundPathTable()
{
	var mIndex = -1;
	var slotId = $("slotid").value;
	var portId = $("portid").value.substring(0, $("portid").value.indexOf("("));
	var direction = $("direction").value;
	
	var selectedIndexes = st.getSelectedRows();
	for (var i = 0, m = selectedIndexes.length; i < m; i++)
	{
		st.setRowNoneSelect(selectedIndexes[i]);
	}
	
	for (var k = 0, n = st.getDataRowLength(); k < n; k++)
	{
		var tslotId = st.getCellStoreValue(k, "port", "slotid");
		var tportName = st.getCellStoreValue(k, "port", "portname");
		var tportId = tportName.substring(0, tportName.indexOf("("));
		var tDirection = st.getCellStoreValue(k, "direction", "direction");
		if (tslotId == slotId && tportId == portId && tDirection == direction)
		{
			mIndex = k;
			break;
		}
	}	
	
	st.setRowSelect(mIndex);
	
	var selected = $("selected").options;
	var boundPathNum = selected.length;
	var text = selected[0].innerText;
	var level = text.substring(0, text.indexOf("-"));
	var boundPath = "(";
	for (var j = 0; j < (boundPathNum - 1); j++)
	{
		boundPath += selected[j].value + ",";
	}
	boundPath = level + boundPath + selected[boundPathNum - 1].value + ")";
	var cell = st.getCell(mIndex, "boundpath");
	st.setCellValue(cell, "boundpath", boundPath);
	cell.element.showElement.setValue(boundPath);
	
	cell = st.getCell(mIndex, "boundpathnum");
	st.setCellValue(cell, "boundpathnum", boundPathNum);
	cell.element.showElement.setValue(boundPathNum);
}

function showErrorDialog(dinterface)
{
   	var errArr = [];
	errArr[0] = "errObjStr";
	var oError = dinterface.getError();
    if(dinterface.getBErrLength() > 0)
    {
        for(var i = 0; i < dinterface.getBErrLength(); i++)
        {
            var tempErrObjStr = "";
            if(null != oError.getRowKey(i, "nename") && "" != oError.getRowKey(i, "nename"))
            {
                tempErrObjStr += oError.getRowKey(i, "nename");
            }
            if(null != oError.getRowKey(i, "slotid") && "" != oError.getRowKey(i, "slotid"))
            {
                tempErrObjStr += "-" + oError.getRowKey(i, "slotid");
            }
            if(null != oError.getRowKey(i, "boardname") && "" != oError.getRowKey(i, "boardname"))
            {
            	tempErrObjStr += "-" + oError.getRowKey(i, "boardname");
            }
            if(null != oError.getRowKey(i, "portname") && "" != oError.getRowKey(i, "portname"))
            {
            	tempErrObjStr += "-" + oError.getRowKey(i, "portname");
            }
            if(null != oError.getRowKey(i, "direction") && "" != oError.getRowKey(i, "direction"))
            {
            	var direction = parseInt(oError.getRowKey(i, "direction"));
            	if (direction == 1)
            	{
            		tempErrObjStr += "-" + RESOURCE["up"];
            	}
                else if (direction == 2)
                {
                	tempErrObjStr += "-" + RESOURCE["down"];
                }
            }
            oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        }
    }
	openErrPage("../../../../../../page/", dinterface.getError(), errArr);	  
}
