 /**
 * housekeeping js       
 *   :     00104334
 *   : 2008-07-05
 */

var OPERATE_SUCCESS = 0;
var OPERATE_PART_SUCCESS = 1;
var OPERATE_FAIL = 2;

var NTFCNCDE_VALUE = [];
NTFCNCDE_VALUE[0] = "CR";
NTFCNCDE_VALUE[1] = "MJ";
NTFCNCDE_VALUE[2] = "MN";

var NTFCNCDE_KEY = [];
NTFCNCDE_KEY["CR"] = "Critical";
NTFCNCDE_KEY["MJ"] = "Major";
NTFCNCDE_KEY["MN"] = "Minor";

var ALARM_MESSAGE_MAX_LENGTH = 63;

var DEFAULT_STATE_VALUE = [];
DEFAULT_STATE_VALUE[0] = "NO";
DEFAULT_STATE_VALUE[1] = "NC";

var DEFAULT_STATE_KEY = [];
DEFAULT_STATE_KEY["NO"] = "Open";
DEFAULT_STATE_KEY["NC"] = "Close";

var CONTROL_TYPE_VALUE = [];
CONTROL_TYPE_VALUE[0] = "CONT-AIRCOND";
CONTROL_TYPE_VALUE[1] = "CONT-ENGINE";
CONTROL_TYPE_VALUE[2] = "CONT-FAN";
CONTROL_TYPE_VALUE[3] = "CONT-GEN";
CONTROL_TYPE_VALUE[4] = "CONT-HEAT";
CONTROL_TYPE_VALUE[5] = "CONT-LIGHT";
CONTROL_TYPE_VALUE[6] = "CONT-MISC";
CONTROL_TYPE_VALUE[7] = "CONT-SPKLR";

var CONTROL_TYPE_VALUE_1800A = [];
CONTROL_TYPE_VALUE_1800A[0] = "CONT-AIRCOND";
CONTROL_TYPE_VALUE_1800A[1] = "CONT-FAN";

var CONTROL_TYPE_KEY = [];
CONTROL_TYPE_KEY["CONT-AIRCOND"] = "Air conditioning";
CONTROL_TYPE_KEY["CONT-ENGINE"] = "Engine";
CONTROL_TYPE_KEY["CONT-FAN"] = "Fan";
CONTROL_TYPE_KEY["CONT-GEN"] = "Generator";
CONTROL_TYPE_KEY["CONT-HEAT"] = "Heat";
CONTROL_TYPE_KEY["CONT-LIGHT"] = "Light";
CONTROL_TYPE_KEY["CONT-MISC"] = "Miscellaneous";
CONTROL_TYPE_KEY["CONT-SPKLR"] = "Sprinkler";

var CONTROL_STATE = [];
CONTROL_STATE["RLS"] = "Released";
CONTROL_STATE["OPER"] = "Operated";

var CONTROL_STATE_VALUE = [];
CONTROL_STATE_VALUE[0] = "RLS";
CONTROL_STATE_VALUE[1] = "OPER";

var CONTROL_STATE_KEY = [];
CONTROL_STATE_KEY["RLS"] = "Released";
CONTROL_STATE_KEY["OPER"] = "Operated";

var DEFAULTSTATE_VALUE = [];
DEFAULTSTATE_VALUE[0] = "NO";
DEFAULTSTATE_VALUE[1] = "NC";


var DEFAULTSTATE_KEY = [];
DEFAULTSTATE_KEY["NC"] = "Operated";
DEFAULTSTATE_KEY["NO"] = "Released";

var DEFAULTNORMALSTATE_KEY = [];
DEFAULTNORMALSTATE_KEY["NC"] = "Close";
DEFAULTNORMALSTATE_KEY["NO"] = "Open";


var ALARMTYPE_VALUE = [];
ALARMTYPE_VALUE[0] = "AIRCOMPR";
ALARMTYPE_VALUE[1] = "AIRCOND";
ALARMTYPE_VALUE[2] = "AIRDRYR";
ALARMTYPE_VALUE[3] = "BATDSCHRG";
ALARMTYPE_VALUE[4] = "BATTERY";
ALARMTYPE_VALUE[5] = "CLFAN";
ALARMTYPE_VALUE[6] = "CPMAJOR";
ALARMTYPE_VALUE[7] = "CPMINOR" ;
ALARMTYPE_VALUE[8] = "ENGINE";
ALARMTYPE_VALUE[9] = "ENGOPRG";
ALARMTYPE_VALUE[10] = "EXPLGS";
ALARMTYPE_VALUE[11] = "FIRDETR";
ALARMTYPE_VALUE[12] = "FIRE";
ALARMTYPE_VALUE[13] = "FLOOD";
ALARMTYPE_VALUE[14] = "FUSE";
ALARMTYPE_VALUE[15] = "GEN";
ALARMTYPE_VALUE[16] = "HIAIR";
ALARMTYPE_VALUE[17] = "HIHUM";
ALARMTYPE_VALUE[18] = "HITEMP";
ALARMTYPE_VALUE[19] = "HIWTR";
ALARMTYPE_VALUE[20] = "INTRUDER";
ALARMTYPE_VALUE[21] = "LWBATVG";
ALARMTYPE_VALUE[22] = "LWFUEL";
ALARMTYPE_VALUE[23] = "LWHUM";
ALARMTYPE_VALUE[24] = "LWPRES";
ALARMTYPE_VALUE[25] = "LWTEMP";
ALARMTYPE_VALUE[26] = "LWWTR";
ALARMTYPE_VALUE[27] = "MISC";
ALARMTYPE_VALUE[28] = "OPENDR";
ALARMTYPE_VALUE[29] = "POWER";
ALARMTYPE_VALUE[30] = "PUMP";
ALARMTYPE_VALUE[31] = "PWR-48";
ALARMTYPE_VALUE[32] = "RECT";
ALARMTYPE_VALUE[33] = "RECTHI";
ALARMTYPE_VALUE[34] = "RECTLO";
ALARMTYPE_VALUE[35] = "SMOKE";
ALARMTYPE_VALUE[36] = "TOXICGAS";
ALARMTYPE_VALUE[37] = "VENTN";

var ALARMTYPE_VALUE_1800A = [];
ALARMTYPE_VALUE_1800A[0] = "AIRCOND";
ALARMTYPE_VALUE_1800A[1] = "FIRE";

var ALARMTYPE_KEY = [];
ALARMTYPE_KEY["AIRCOMPR"] = "AIRCOMPR";
ALARMTYPE_KEY["AIRCOND"] = "AIRCOND";
ALARMTYPE_KEY["AIRDRYR"] = "AIRDRYR";
ALARMTYPE_KEY["BATDSCHRG"] = "BATDSCHRG";
ALARMTYPE_KEY["BATTERY"] = "BATTERY";
ALARMTYPE_KEY["CLFAN"] = "CLFAN";
ALARMTYPE_KEY["CPMAJOR"] = "CPMAJOR";
ALARMTYPE_KEY["CPMINOR"] = "CPMINOR" ;
ALARMTYPE_KEY["ENGINE"] = "ENGINE";
ALARMTYPE_KEY["ENGOPRG"] = "ENGOPRG";
ALARMTYPE_KEY["EXPLGS"] = "EXPLGS";
ALARMTYPE_KEY["FIRDETR"] = "FIRDETR";
ALARMTYPE_KEY["FIRE"] = "FIRE";
ALARMTYPE_KEY["FLOOD"] = "FLOOD";
ALARMTYPE_KEY["FUSE"] = "FUSE";
ALARMTYPE_KEY["GEN"] = "GEN";
ALARMTYPE_KEY["HIAIR"] = "HIAIR";
ALARMTYPE_KEY["HIHUM"] = "HIHUM";
ALARMTYPE_KEY["HITEMP"] = "HITEMP";
ALARMTYPE_KEY["HIWTR"] = "HIWTR";
ALARMTYPE_KEY["INTRUDER"] = "INTRUDER";
ALARMTYPE_KEY["LWBATVG"] = "LWBATVG";
ALARMTYPE_KEY["LWFUEL"] = "LWFUEL";
ALARMTYPE_KEY["LWHUM"] = "LWHUM";
ALARMTYPE_KEY["LWPRES"] = "LWPRES";
ALARMTYPE_KEY["LWTEMP"] = "LWTEMP";
ALARMTYPE_KEY["LWWTR"] = "LWWTR";
ALARMTYPE_KEY["MISC"] = "MISC";
ALARMTYPE_KEY["OPENDR"] = "OPENDR";
ALARMTYPE_KEY["POWER"] = "POWER";
ALARMTYPE_KEY["PUMP"] = "PUMP";
ALARMTYPE_KEY["PWR-48"] = "PWR-48";
ALARMTYPE_KEY["RECT"] = "RECT";
ALARMTYPE_KEY["RECTHI"] = "RECTHI";
ALARMTYPE_KEY["RECTLO"] = "RECTLO";
ALARMTYPE_KEY["SMOKE"] = "SMOKE";
ALARMTYPE_KEY["TOXICGAS"] = "TOXICGAS";
ALARMTYPE_KEY["VENTN"] = "VENTN";

var ALARM_MESSAGE = [];
ALARM_MESSAGE["AIRCOMPR"]  = "Air compressor failure";
ALARM_MESSAGE["AIRCOND"]   = "Air conditioning failure";
ALARM_MESSAGE["AIRDRYR"]   = "Air dryer failure";
ALARM_MESSAGE["BATDSCHRG"] = "Battery discharging";
ALARM_MESSAGE["BATTERY"]   = "Battery failure";
ALARM_MESSAGE["CLFAN"]     = "Cooling fan failure";
ALARM_MESSAGE["CPMAJOR"]   = "Major Centralized Power Alarm";
ALARM_MESSAGE["CPMINOR"]   = "Minor Centralized Power Alarm";
ALARM_MESSAGE["ENGINE"]    = "Engine failure";
ALARM_MESSAGE["ENGOPRG"]   = "Engine operating";
ALARM_MESSAGE["EXPLGS"]    = "Explosive gas";
ALARM_MESSAGE["FIRDETR"]   = "Fire detector failure";
ALARM_MESSAGE["FIRE"]      = "Fire";
ALARM_MESSAGE["FLOOD"]     = "Flood";
ALARM_MESSAGE["FUSE"]      = "Fuse failure";
ALARM_MESSAGE["GEN"]       = "Generator failure";
ALARM_MESSAGE["HIAIR"]     = "High airflow";
ALARM_MESSAGE["HIHUM"]     = "High humidity";
ALARM_MESSAGE["HITEMP"]    = "High temperature";
ALARM_MESSAGE["HIWTR"]     = "High water";
ALARM_MESSAGE["INTRUDER"]  = "Intrusion";
ALARM_MESSAGE["LWBATVG"]   = "Low battery voltage";
ALARM_MESSAGE["LWFUEL"]    = "Low fuel";
ALARM_MESSAGE["LWHUM"]     = "Low humidity";
ALARM_MESSAGE["LWPRES"]    = "Low cable pressure";
ALARM_MESSAGE["LWTEMP"]    = "Low temperature";
ALARM_MESSAGE["LWWTR"]     = "Low water";
ALARM_MESSAGE["MISC"]      = "Miscellaneous";
ALARM_MESSAGE["OPENDR"]    = "Open door";
ALARM_MESSAGE["POWER"]     = "Commercial power failure";
ALARM_MESSAGE["PUMP"]      = "Pump failure";
ALARM_MESSAGE["PWR-48"]    = "48 voltage power supply failure";
ALARM_MESSAGE["RECT"]      = "Rectifier failure";
ALARM_MESSAGE["RECTHI"]    = "Rectifier high voltage";
ALARM_MESSAGE["RECTLO"]    = "Rectifier low voltage";
ALARM_MESSAGE["SMOKE"]     = "Smoke";
ALARM_MESSAGE["TOXICGAS"]  = "Toxic gas";
ALARM_MESSAGE["VENTN"]     = "Ventilation system failure";

var aidArray = [];
aidArray[0] = "ENV-1";
aidArray[1] = "ENV-2";
aidArray[2] = "ENV-3";
aidArray[3] = "ENV-4";
aidArray[4] = "ENV-5";
aidArray[5] = "ENV-6";
aidArray[6] = "ENV-7";
aidArray[7] = "ENV-8";
aidArray[8] = "ENV-9";
aidArray[9] = "ENV-10";
aidArray[10] = "ENV-11";
aidArray[11] = "ENV-12";
aidArray[12] = "ENV-13";
aidArray[13] = "ENV-14";
aidArray[14] = "ENV-15";
aidArray[15] = "ENV-16";

var aidArray_3800A = [];
aidArray_3800A[0] = "ENV-1";
aidArray_3800A[1] = "ENV-2";
aidArray_3800A[2] = "ENV-3";
aidArray_3800A[3] = "ENV-4";
aidArray_3800A[4] = "ENV-5";
aidArray_3800A[5] = "ENV-6";

var aidArray_1800A = [];
aidArray_1800A[0] = "ENV-1";
aidArray_1800A[1] = "ENV-2";
aidArray_1800A[2] = "ENV-3";

var CONTROL_AID = [];
CONTROL_AID[0] = "CONT-7";
CONTROL_AID[1] = "CONT-8";

var CONTROL_AID_3800A = [];
CONTROL_AID_3800A[0] = "CONT-1";
CONTROL_AID_3800A[1] = "CONT-2";

var CONTROL_AID_1800A = [];
CONTROL_AID_1800A[0] = "CONT-1";

var DEFAULT_PERSISTENCE_TIME = 5000;

var DUR_CONTS = "CONTS";
var DUR_MILS = "MILS";

var PERSISTENCE_TIME_MIN = "300"; 
PERSISTENCE_TIME_MAX = "10000";
PERSISTENCE_TIME_STEP_LEN = 100;

var COLUMN_TIME = "TIME";
var ALARM_TYPE_ENV_ALL = "ENV-ALL";

/**
 *convert  
 */
function trimAlmMsg(alarmMessage)
{
    var almMsg = alarmMessage;
    if (almMsg.length != 0)
    {
        if (almMsg.length >= 2 && almMsg.substring(0, 2) == "\\\"")
        {
            almMsg = almMsg.substring(2);
        }
        if (almMsg.length >= 2 && almMsg.substring(almMsg.length - 2) == "\\\"")
        {
            almMsg = almMsg.substring(0, almMsg.length - 2);
        }
    }
    return almMsg;
}

function compareAIDNum(str1,str2)
{
	var tempArr1 = str1.split("-");
	var tempArr2 = str2.split("-");
    var value1=parseInt(tempArr1[1]);
    var value2=parseInt(tempArr2[1]);
    return compare(value1,value2);
}
	
