 /**
 *            js  
 *   :     00104334
 *   : 2008-07-5
 */
 
var winurlobj = getNeProperty(top);

var envTable = null;

var btnRight = null;

var selectedRows = 0;

var armMsg_LEN = 63;

/**
 *       
 */ 
 function initPage()
{
    initTable();
    
    initButton();
    
    adjustHeight();
    
    queryEnvInfo(); 
}
function initTable()
{
    envTable = new SortTable();
    
    envTable.setImage("../../../../../../images/");
    
    envTable.setBodyHeight(580);  
    
    envTable.setSingleChoiceFlg(false);
    
    createTableHead(envTable, window.tableconf[0]);
    
    envTable.setOnRowSelectHandler(btnStatus);
    
    envTable.setOnCellEditHandler(cellEditHandler);
    
    var hc=envTable.getHeadCell("AID");
    envTable.setHCAttribute(hc,1,0,compareAID);
    $("envTableDiv").oncontextmenu = popupMenuHandler;

    $("envTableDiv").appendChild(envTable.getTable());
}

function compareAID(str1, str2)
{
	var num1 = parseInt(str1.split("-")[1],10);
	var num2 = parseInt(str2.split("-")[1],10);
	if (num1 > num2)
	{
		return 1;
	}
	if (num1 < num2)
	{
		return -1;
	}
	return 0;
	
}

function initButton()
{
	$("queryBtn").value =  RESOURCE["Query"];
	$("createBtn").value = RESOURCE["New"];
	$("delBtn").value = RESOURCE["Delete"];
	$("applyBtn").value = RESOURCE["Apply"];
	
	$("queryBtn").onclick = queryEnvInfo;
	$("createBtn").onclick = showAddDialog;
	$("delBtn").onclick = delEnvProperty;
	$("applyBtn").onclick = applyEnvProperty;
	
	getAllBtnRight();
}

/**
 *       
 */
function setButtonDisabled(isDisabled)
{
	$("queryBtn").disabled = isDisabled;
    $("createBtn").disabled = isDisabled;
    $("delBtn").disabled = isDisabled;
    $("applyBtn").disabled = isDisabled;
}

/**
 *         
 */
function getAllBtnRight()
{
    btnRight = new Object;
    
    btnRight.queryBtn = new BtnRightObj("queryBtn", TECMDCODE_SONET_QUERY_ENV_ITEMS);    
    
    btnRight.createBtn = new BtnRightObj("createBtn", TECMDCODE_SONET_ADD_ENV_ITEMS);
    
    btnRight.delBtn = new BtnRightObj("delBtn", TECMDCODE_SONET_DEL_ENV_ITEMS);
    
    btnRight.applyBtn = new BtnRightObj("applyBtn", TECMDCODE_SONET_SET_ENV_ITEMS);
    
    getRightInfo(winurlobj, btnRight);      
    
    initrightbtn(btnRight);
}

function queryEnvInfo()
{
    setButtonDisabled(true);
    
    var xml = queryEnvInfoXML();
    
    var sfid = TECMDCODE_SONET_QUERY_ENV_ITEMS;
    
    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", true, queryEnvInfoBack, null, "inputdata=" + xml);
}
function queryEnvInfoXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = new tagElement("row-params");
    var param = null;
   
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    var AID = "ENV-ALL";
    param = new tagElement("param");
    param.setAttribute("name", "AID");
    param.setAttribute("value", AID);
    row.appendChild(param);

    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();     
}

function queryEnvInfoBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        btnStatus();
        return;
    }
    var AID = null;
    var ntfcncde = null;
    var almtype = null;
    var almmsg = "";
    var defaultState = null;
     
    for (var i = data.getDataRowLength() - 1; i >= 0; i --)
    {
        AID = data.getDataRowParam(i, "AID");
        if (AID == ALARM_TYPE_ENV_ALL)
        {
            data.rows.removeAt(i);
            break;
        }
        
        var diobj = data.rows[i];
        var renalarmmsg = data.getDataRowParam(i, "almmsg");
        renalarmmsg = trimAlmMsg(renalarmmsg);
        diobj["almmsg"].value = renalarmmsg;
    }
    
    setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+winurlobj["neid"],false);
    
    envTable.clearTableData();
    
    createTableBody(envTable, window.tableconf[0], data, RESOURCE);
    
    adjustToCurrSortStatus();    

    addCellListener();
    
    btnStatus();
}

function addCellListener()
{
	var cell = null;
	
	for(var i = 0, len = envTable.getDataRowLength(); i < len; i++)
	{
		cell = envTable.getCell(i, "almmsg");
		if (null == cell || cell.element.isEdit != "1")
		{
			continue;
		}
		
		var obj = cell.element.editElement.element;
		
		if(isIE)
		{
			obj.onkeypress = function(e)
			{
				var event = EventUtil.getEvent();
				var code = event.keyCode;
			    if(code > 255)
			    {
			    	event.returnValue = false;
			    	return false;
			    }
		    	return blockChars(e,"\"\\=,:;?");
			}
			obj.onpaste = function()
			{
				return false;
			}
  		}
  		else
  		{
			obj.onkeypress = function(e)
			{
				var event = EventUtil.getEvent();
				var code = event.keyCode;
				return blockChars(e,"\"\\=,:;?");
		    }
  		}				
	}
}

function delEnvProperty()
{
    if(!btnRight.delBtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    
    selectedRows = envTable.getSelectedRows();
    if (selectedRows.length < 1)
    {
        alert(RESOURCE["UnSelectData"]);
        return;
    }
    
    if(!confirm(RESOURCE["DeleteEnvConfirm"]))
    {
        return;
    }
    
    setButtonDisabled(true);
    
    var xml = delEnvPropertyXML();
    
    var sfid = TECMDCODE_SONET_DEL_ENV_ITEMS;
    
    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", true, delEnvPropertyBack, null, "inputdata=" + xml);
}

function delEnvPropertyXML()
{   
    selectedRows = envTable.getSelectedRows();
    
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = "";
    var ntfcncde = "";
    var almtype = "";
    var almmsg = "";
    var defaultstate = "";
    
    for(var i = 0; i < selectedRows.length; i ++)
    {
        row = new tagElement("row-params");
        param = null;
       
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        AID = envTable.getCellStoreValue(selectedRows[i], "AID", "AID");
        param.setAttribute("name", "AID");
        param.setAttribute("value", AID);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "ntfcncde");
        param.setAttribute("value", ntfcncde);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "almtype");
        param.setAttribute("value", almtype);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "almmsg");
        param.setAttribute("value", almmsg);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "defaultstate");
        param.setAttribute("value", defaultstate);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    return root.toString(); 
}

function delEnvPropertyBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
        return;
    }
    else
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+winurlobj["neid"],false);
    }
    
    for (var i = 0; i < selectedRows.length; i ++)
    {
        envTable.deleteRow(selectedRows[i]);
    }    
    envTable.adjustDataRows();
    
    btnStatus();
}

function applyEnvProperty()
{
    if(!btnRight.applyBtn.right)
    {
        alert(RESOURCE["RightUnvalid"]);
        return;
    }
    setButtonDisabled(true);
    
    var xml = applyEnvPropertyXML();
    
    if (null == xml)
    {
        btnStatus();
        return;
    }
    
    var sfid = TECMDCODE_SONET_SET_ENV_ITEMS;
    
    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];

    loadXMLdoc(url, "POST", true, applyEnvPropertyBack, null, "inputdata=" + xml);
}

function applyEnvPropertyXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = "";
    var ntfcncde = null;
    var almtype = null;
    var almmsg = "";
    var defaultstate = "";
    
	var isModified = false;
    
    for(var i = 0, len = envTable.getDataRowLength(); i < len; i ++)
    {
		if (!envTable.getModify(i))
		{
			continue;
		}
		isModified = true;
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", winurlobj["neid"]);
        row.appendChild(param);
        
        param = new tagElement("param");
        AID = envTable.getCellStoreValue(i, "AID", "AID");
        param.setAttribute("name", "AID");
        param.setAttribute("value", AID);
        row.appendChild(param);
        
        param = new tagElement("param");
        ntfcncde = envTable.getCellStoreValue(i, "ntfcncde", "ntfcncde");
        param.setAttribute("name", "ntfcncde");
        param.setAttribute("value", ntfcncde);
        row.appendChild(param);
        
        param = new tagElement("param");
        almtype = envTable.getCellStoreValue(i, "almtype", "almtype");
        param.setAttribute("name", "almtype");
        param.setAttribute("value", almtype);
        row.appendChild(param);
        
        param = new tagElement("param");
        almmsg = envTable.getCellStoreValue(i, "almmsg", "almmsg");
        param.setAttribute("name", "almmsg");
        param.setAttribute("value", "\""+almmsg+"\"");
        row.appendChild(param);
        
        param = new tagElement("param");
        defaultstate = envTable.getCellStoreValue(i, "defaultstate", "defaultstate");
        param.setAttribute("name", "defaultstate");
        param.setAttribute("value", defaultstate);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    if (!isModified)
    {
        return null;
    }
    root.getRoot().appendChild(business);
    return root.toString();
}

function applyEnvPropertyBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
    	setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+winurlobj["neid"],false);
        refreshTableState(envTable, window.tableconf[0], data);
    }
    btnStatus();
}

function showErrorDialog(data, errArr)
{
    var errorArray = null;
    if (null == errArr)
    {
        errorArray = new Array();
        errorArray.push("nename");
    }
    else
    {
        errorArray = errArr;
    }
    
    openErrPage("../../../../../../page/", data.getError(), errorArray); 
}

function showAddDialog()
{
    var url = "addenv.html?neid="+winurlobj["neid"]+"&nmUser="+winurlobj["nmUser"];
    
    setButtonDisabled(true);
    xshowModalDialog(url, RESOURCE["newEnvAlarmAttrTitle"], 500, 430, "../../../../../../images/");
    btnStatus();
}

function btnStatus()
{
    selectedRows = envTable.getSelectedRows();
    if (selectedRows.length > 0)
    {
        $("queryBtn").disabled =  !btnRight.queryBtn.right;
	    $("createBtn").disabled = !btnRight.createBtn.right;
	    $("delBtn").disabled = !btnRight.delBtn.right;
    } 
    else
    {
        $("queryBtn").disabled =  !btnRight.queryBtn.right;
	    $("createBtn").disabled = !btnRight.createBtn.right;
	    $("delBtn").disabled = true;
    }
    

	for (var i = 0, len = envTable.getDataRowLength(); i < len; i ++)
	{
		if (envTable.getModify(i))
		{
			$("applyBtn").disabled = !btnRight.applyBtn.right;
			break;
		}
	}
	
    $("selrows").innerHTML = selectedRows.length;
	$("totalrows").innerHTML = envTable.getDataRowLength();   
}

function cellEditHandler(param)
{
    $("applyBtn").disabled = !btnRight.applyBtn.right;
    setTIDOnchangeModify("../../../../../../isModifyTL1ExplorerServlet?type=setState&neid="+winurlobj["neid"],true);
    var netype = winurlobj["neType"];
    
    if((param.colid == "almmsg") && (param.stage == TABLE_CONSTANT.BEFOREEDIT))
	{
	  	var textview = envTable.getCellEdit(i,"almmsg").element;
	  	textview.style.imeMode = "disabled";
	  	textview.maxLength = armMsg_LEN;
	  	
	  	if(isIE)
		{
			textview.onkeypress = function(e)
			{
				var event = EventUtil.getEvent();
				var code = event.keyCode;
			    if(code > 255)
			    {
			    	event.returnValue = false;
			    	return false;
			    }
		    	return blockChars(e,"\"\\=,:;?");
			}
			
			textview.onpaste = function()
			{
				return false;
			}
		}
		else
		{
			textview.onkeypress = function(e)
			{
				var event = EventUtil.getEvent();
				var code = event.keyCode;
				return blockChars(e,"\"\\=,:;?");
		    }
		}
	}
	
	if (netype == 66)//1800A
	{
		if (param.colid == "almtype" && param.stage == TABLE_CONSTANT.BEFOREEDIT)
		{
			var cellEdit = envTable.getCellEdit(param.rowindex, param.colid);
			cellEdit.clearOptions();
			cellEdit.addOption("ENV-AIRCOND","AIRCOND");
			cellEdit.addOption("ENV-FIRE","FIRE");
		}
	}
	
	if((param.colid == "almtype") && (param.stage == TABLE_CONSTANT.AFTEREDIT))
	{		
		
		var msgCell = envTable.getCell(param.rowindex,"almmsg");					       	      	           			    		
		msgCell.element.modify = true;
		msgCell.element.parentNode.modify = true;
		envTable.setCellIsEdit(msgCell,"1");
		msgCell.element.style.backgroundColor = "#d0f946";
		msgCell.element.ondblclick = cellondbclick;
		var almtypeValue = envTable.getCellStoreValue(param.rowindex,"almtype","almtype");
		var msgValue = ALARM_MESSAGE[almtypeValue];
		if (msgValue)
		{
			envTable.setAtomValue(msgCell.element.showElement,msgValue);
		    envTable.setCellValue(msgCell,"almmsg",msgValue);			
		}				   
	}
}

/*
 *       
 */
function adjustHeight()
{
    envTable.setBodyHeight(getComponetHeight($("envTableDiv"),80)+"px");
}

window.onresize = adjustHeight;

function adjustToCurrSortStatus()
{
    if(!envTable.element.colsArray.selectedId)
    {
  	   envTable.element.colsArray.selectedId = "AID";
  	   envTable.element.colsArray.imgflag = 1;
    }
    
    var td = envTable.element.headRow.element.cols[envTable.element.colsArray.selectedId].element; 
    envTable.sortRows(td, envTable.element.colsArray.imgflag);
}

/*
remove sorttable after page unload
user may override this function
*/
window.onunload=function()
{
    if(typeof(envTable)!='undefined' && envTable instanceof SortTable)
    {
		clearSortTable(envTable);
	}
}
