 /**
 *       js  
 *   :     00104334
 *   : 2008-07-5
 */
 
 var aidTable = null;
 var severityTable = null;
 var alarmTypeTable = null;
var winurlobj = getNeProperty(self);

var parentWin = getParentWindow();
var winobjParent = parentWin.winurlobj;//"5.71.01.11" neversion

document.title = RESOURCE["newEnvAlarmAttrTitle"];
 
 function initPage()
{
    initTable();
    
    initButton();
    
    adjustHeight();
    
	addEnvPropertyListener();
}

function addEnvPropertyListener()
{
	if(isIE)
	{
		$("alarmMessageInput").onkeypress = function(e)
		{
			var event = EventUtil.getEvent();
			var code = event.keyCode;
		    if(code > 255)
		    {
		    	event.returnValue = false;
		    	return false;
		    }
	    	return blockChars(e,"\"\\=,:;?");
		}
		
		$("alarmMessageInput").onpaste = function()
		{
			return false;
		}
	}
	else
	{
		$("alarmMessageInput").onkeypress = function(e)
		{
			var event = EventUtil.getEvent();
			var code = event.keyCode;
			return blockChars(e,"\"\\=,:;?");
	    }
	}
}

function initTable()
{
    $("aidLabel").innerText = RESOURCE["AID"];
    $("severityLabel").innerText = RESOURCE["Severity"];
    $("alarmTypeLabel").innerText = RESOURCE["AlarmType"];
    $("alarmMessageLabel").innerText = RESOURCE["AlarmMessage"];

    aidTable = new SortTable();
    severityTable = new SortTable();
    alarmTypeTable = new SortTable();
    
    aidTable.setImage("../../../../../../images/");
    severityTable.setImage("../../../../../../images/");
    alarmTypeTable.setImage("../../../../../../images/");
    
    aidTable.setBodyHeight(210);
    severityTable.setBodyHeight(210);
    alarmTypeTable.setBodyHeight(210);
    
    aidTable.setSingleChoiceFlg(true);
    severityTable.setSingleChoiceFlg(true);
    alarmTypeTable.setSingleChoiceFlg(true);
    
    aidTable.isUsedForSelectList = true;
    severityTable.isUsedForSelectList = true;
    alarmTypeTable.isUsedForSelectList = true;
    
    createTableHead(aidTable, window.tableconf[0]);
    createTableHead(severityTable, window.tableconf[1]);
    createTableHead(alarmTypeTable, window.tableconf[2]);
    
    aidTable.setOnRowSelectHandler(btnStatus);
    severityTable.setOnRowSelectHandler(btnStatus);
    alarmTypeTable.setOnRowSelectHandler(btnStatus);

    $("aidTableDiv").appendChild(aidTable.getTable());
    $("severityTableDiv").appendChild(severityTable.getTable());
    $("alarmTypeTableDiv").appendChild(alarmTypeTable.getTable());

    initAIDTable();
    initSevirityTable();
    initAlarmTypeTable();
    btnStatus();
}

function getParentWinAIDArray()
{
    var parentAIDArray = [];
    var aid = null;
    for (var i = 0, len = parentWin.envTable.getDataRowLength(); i < len; i ++)
    {
        aid = parentWin.envTable.getCellStoreValue(i, "AID", "AID");
        parentAIDArray.push(aid);
    }
    
    return parentAIDArray;  
}

function initAIDTable()
{
    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;
    var parentAIDArray = getParentWinAIDArray();
    
    var netype = winobjParent["neType"];
    var aidForInterface = aidArray;
    if (netype == 71)
	{
		aidForInterface = aidArray;
	}
	else if (netype == 70)
	{
		aidForInterface = aidArray_3800A;
	}
	else if (netype == 66)
	{
		aidForInterface = aidArray_1800A;
	}

    for (var i = 0; i < aidForInterface.length; i ++)
    {
        if (parentAIDArray.contains(aidForInterface[i]))
        {
            continue;
        }
        
        obj = new Object();

        ptag = new ParamTag();        
        ptag.value = aidForInterface[i];  
        obj["AID"] = ptag;
        
        dataInterface.rows.append(obj);
    }

    createTableBody(aidTable, window.tableconf[0], dataInterface, RESOURCE); 
}
function initSevirityTable()
{
    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;
    
    for (var i = 0; i < NTFCNCDE_VALUE.length; i ++)
    {
        obj = new Object();
        
        ptag = new ParamTag();
        ptag.value = NTFCNCDE_VALUE[i];  
        obj["ntfcncde"] = ptag;
        
        dataInterface.rows.append(obj);
    }
    
    createTableBody(severityTable, window.tableconf[1], dataInterface, RESOURCE);
}

function initAlarmTypeTable()
{
    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;
    
    var netype = winobjParent["neType"];
    
    var alarmtype = ALARMTYPE_VALUE;
    if (netype == 66)
    {
    	alarmtype = ALARMTYPE_VALUE_1800A;
    }
    
    for (var i = 0; i < alarmtype.length; i ++)
    {
        obj = new Object();

        ptag = new ParamTag();
        ptag.value = alarmtype[i];  
        obj["almtype"] = ptag;
        
        dataInterface.rows.append(obj);
    }
    
    createTableBody(alarmTypeTable, window.tableconf[2], dataInterface, RESOURCE); 
}

function initButton()
{
	$("okBtn").value =  RESOURCE["OK"];
	$("cancelBtn").value = RESOURCE["Cancel"];
	$("applyBtn").value = RESOURCE["Apply"];
	
	$("okBtn").onclick = okToAddEnvProperty;
	$("cancelBtn").onclick = doCancel;
	$("applyBtn").onclick = applyEnvProperty;
}

/**
 *       
 */
function setButtonDisabled(isDisabled)
{
	$("okBtn").disabled = isDisabled;
    $("cancelBtn").disabled = isDisabled;
    $("applyBtn").disabled = isDisabled;
}

function applyEnvProperty()
{
    setButtonDisabled(true);
    
    var xml = applyEnvPropertyXML();
    
    var sfid = TECMDCODE_SONET_ADD_ENV_ITEMS;
    
    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", true, applyEnvPropertyBack, null, "inputdata=" + xml);
}

function applyEnvPropertyXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = null;
    var severity = null;
    var alarmType = null;
    var selectedRows = null;
    var defaultState = null;
    
    row = new tagElement("row-params");
   
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    selectedRows = aidTable.getSelectedRows();
    AID = aidTable.getCellStoreValue(selectedRows[0], "AID", "AID");
    param = new tagElement("param");
    param.setAttribute("name", "AID");
    param.setAttribute("value", AID);
    row.appendChild(param);
    
    selectedRows = severityTable.getSelectedRows();
    severity = severityTable.getCellStoreValue(selectedRows[0], "ntfcncde", "ntfcncde");
    param = new tagElement("param");
    param.setAttribute("name", "ntfcncde");
    param.setAttribute("value", severity);
    row.appendChild(param);
    
    selectedRows = alarmTypeTable.getSelectedRows();
    alarmType = alarmTypeTable.getCellStoreValue(selectedRows[0], "almtype", "almtype");
    param = new tagElement("param");
    param.setAttribute("name", "almtype");
    param.setAttribute("value", alarmType);
    row.appendChild(param);
    
    alarmMessage = $("alarmMessageInput").value;
    param = new tagElement("param");
    param.setAttribute("name", "almmsg");
    param.setAttribute("value", "\"" + alarmMessage + "\"");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "defaultstate");
    param.setAttribute("value", DEFAULT_STATE_VALUE[0]);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);

    return root.toString(); 
}

function applyEnvPropertyBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
        refreshParentWindow();
        
        var selectedRows = aidTable.getSelectedRows();
        for (var i = 0; i < selectedRows.length; i ++)
        {
            aidTable.deleteRow(selectedRows[i]);
        }    
        aidTable.adjustDataRows();
    }
    
    btnStatus();
}

function refreshParentWindow()
{
    var dataInterface = new DataInterface();
    var obj = new Object();
    var ptag = null;
    var alarmMessage = null;
    var selectedRows = null;
    var AID = null;
    var severity = null;
    var alarmType = null;
    var alarmMessage = null;
    
    selectedRows = aidTable.getSelectedRows();
    AID = aidTable.getCellStoreValue(selectedRows[0], "AID", "AID");
    ptag = new ParamTag();
    ptag.value = AID;  
    obj["AID"] = ptag;
    
    selectedRows = severityTable.getSelectedRows();
    severity = severityTable.getCellStoreValue(selectedRows[0], "ntfcncde", "ntfcncde");
    ptag = new ParamTag();
    ptag.value = severity;  
    obj["ntfcncde"] = ptag;
    
    selectedRows = alarmTypeTable.getSelectedRows();
    alarmType = alarmTypeTable.getCellStoreValue(selectedRows[0], "almtype", "almtype");
    ptag = new ParamTag();
    ptag.value = alarmType;  
    obj["almtype"] = ptag;
    
    alarmMessage = $("alarmMessageInput").value;
    ptag = new ParamTag();
    ptag.value = alarmMessage;  
    obj["almmsg"] = ptag;
    
    ptag = new ParamTag();
    ptag.value = DEFAULT_STATE_VALUE[0];  
    obj["defaultstate"] = ptag;

    dataInterface.rows.append(obj);

    createTableBody(parentWin.envTable, parentWin.window.tableconf[0], dataInterface, RESOURCE);
    parentWin.envTable.adjustDataRows();     
}

function okToAddEnvProperty()
{
    if ($("applyBtn").disabled)
    {
        xcloseDialog();
        return;
    }
    
    setButtonDisabled(true);
    
    var xml = okToAddEnvPropertyXML();
    
    var sfid = TECMDCODE_SONET_ADD_ENV_ITEMS;
    
    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", true, okToAddEnvPropertyBack, null, "inputdata=" + xml);
}

function okToAddEnvPropertyXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = null;
    var severity = null;
    var alarmType = null;
    var selectedRows = null;
    var defaultState = null;
    
    row = new tagElement("row-params");
   
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    selectedRows = aidTable.getSelectedRows();
    AID = aidTable.getCellStoreValue(selectedRows[0], "AID", "AID");
    param = new tagElement("param");
    param.setAttribute("name", "AID");
    param.setAttribute("value", AID);
    row.appendChild(param);
    
    selectedRows = severityTable.getSelectedRows();
    severity = severityTable.getCellStoreValue(selectedRows[0], "ntfcncde", "ntfcncde");
    param = new tagElement("param");
    param.setAttribute("name", "ntfcncde");
    param.setAttribute("value", severity);
    row.appendChild(param);
    
    selectedRows = alarmTypeTable.getSelectedRows();
    alarmType = alarmTypeTable.getCellStoreValue(selectedRows[0], "almtype", "almtype");
    param = new tagElement("param");
    param.setAttribute("name", "almtype");
    param.setAttribute("value", alarmType);
    row.appendChild(param);
    
    alarmMessage = $("alarmMessageInput").value;
    param = new tagElement("param");
    param.setAttribute("name", "almmsg");
    param.setAttribute("value", "\"" + alarmMessage + "\"");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "defaultstate");
    param.setAttribute("value", DEFAULT_STATE_VALUE[0]);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    
    return root.toString(); 
}

function okToAddEnvPropertyBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
        refreshParentWindow();
        xcloseDialog();
    }
    
    btnStatus();
}

function showErrorDialog(data, errArr)
{
    var errorArray = null;
    if (null == errArr)
    {
        errorArray = new Array();
        errorArray.push("nename");
    }
    else
    {
        errorArray = errArr;
    }
    
    openErrPage("../../../../../../page/", data.getError(), errorArray); 
}

function btnStatus()
{
    var aidTableSRows = aidTable.getSelectedRows();
    var severityTableSRows = severityTable.getSelectedRows();
    var alarmTypeTableSRows = alarmTypeTable.getSelectedRows();
    var alarmtype = null; 
    var alarmMessage  = "";
    
    if (aidTableSRows.length != 1 || severityTableSRows.length != 1 || alarmTypeTableSRows.length != 1)
    {
        $("applyBtn").disabled = true;
    }
    else
    {
        $("applyBtn").disabled = false;
    }
    $("okBtn").disabled = false;
    $("cancelBtn").disabled = false;
    
    if (alarmTypeTableSRows.length == 1)
    {
        alarmtype = alarmTypeTable.getCellStoreValue(alarmTypeTableSRows[0], "almtype", "almtype");
        $("alarmMessageInput").value = ALARM_MESSAGE[alarmtype];
    }
    
}

/*
 *       
 */
function adjustHeight()
{
	var totalHeight = getComponetHeight($("topcontainer"),130);
	var totalWidth = document.body.clientWidth - 80;
	aidTable.headPack.style.width = totalWidth * 0.34;
	aidTable.bodyPack.style.width = totalWidth * 0.34;
	aidTable.setPageWidth();
	severityTable.headPack.style.width = totalWidth * 0.33;
	severityTable.bodyPack.style.width = totalWidth * 0.33;
	severityTable.setPageWidth();
	alarmTypeTable.headPack.style.width = totalWidth * 0.33;
	alarmTypeTable.bodyPack.style.width = totalWidth * 0.33;
	alarmTypeTable.setPageWidth();
    aidTable.setBodyHeight(totalHeight+"px");
	
    severityTable.setBodyHeight(totalHeight+"px");
    
    alarmTypeTable.setBodyHeight(totalHeight+"px");
}

window.onresize = adjustHeight;

function justForTest()
{
    alert("justForTest");
}

function doCancel()
{
    xcloseDialog();
}

function alarmMsgCheck()
{
	var obj = document.getElementById("alarmMessageInput");
	var alarmvar = obj.value;
	
	if (alarmvar.length > 63)
	{
		obj.value = alarmvar.substring(0,63);
		
		alert(RESOURCE["alarmlen"]);
    	return false;
	}
}

/*
remove sorttable after page unload
user may override this function
*/
window.onunload=function()
{
    if(typeof(aidTable)!='undefined' && aidTable instanceof SortTable)
    {
		clearSortTable(aidTable);
	}
	
	if(typeof(severityTable)!='undefined' && severityTable instanceof SortTable)
    {
		clearSortTable(severityTable);
	}
	
	if(typeof(alarmTypeTable)!='undefined' && alarmTypeTable instanceof SortTable)
    {
		clearSortTable(alarmTypeTable);
	}
}
