 /**
 *       js  
 *   :     00104334
 *   : 2008-07-5
 */
 
var aidTable = null;
var controlType = null;
var winurlobj = getNeProperty(self);

var parentWin = getParentWindow();
var winobjParent = parentWin.winurlobj;//"5.71.01.11" neversion

document.title = RESOURCE["newCtrlAlarmAttr"];
 
 function initPage()
{
    initTable();
    
    initButton();
    
    adjustHeight();
}

function initTable()
{
    $("aidLabel").innerText = RESOURCE["AID"];
    $("controlTypeLabel").innerText = RESOURCE["ControlType"];
    $("stateLabel").innerText = RESOURCE["ControlState"];
    $("normalStateLabel").innerText = RESOURCE["NormalState"];
    
    aidTable = new SortTable();
    controlTypeTable = new SortTable();
    
    aidTable.setImage("../../../../../../images/");
    controlTypeTable.setImage("../../../../../../images/");
    
    aidTable.setBodyHeight(200);
    controlTypeTable.setBodyHeight(200);
    
    aidTable.setSingleChoiceFlg(true);
    controlTypeTable.setSingleChoiceFlg(true);
    
    aidTable.isUsedForSelectList = true;
    controlTypeTable.isUsedForSelectList = true;
    
    createTableHead(aidTable, window.tableconf[0]);
    createTableHead(controlTypeTable, window.tableconf[1]);
     
    aidTable.setOnRowSelectHandler(btnStatus);
    controlTypeTable.setOnRowSelectHandler(btnStatus);

    $("aidTableDiv").appendChild(aidTable.getTable());
    $("controlTypeTableDiv").appendChild(controlTypeTable.getTable());
    
    initAIDTable();
    initControlTable();

    for (var i = 0; i < DEFAULTSTATE_VALUE.length; i++)
    {
        addSelectOption($("stateSelect"), DEFAULTSTATE_KEY[DEFAULTSTATE_VALUE[i]], DEFAULTSTATE_VALUE[i]);
    }
    
    for (var j = 0; j < DEFAULTSTATE_VALUE.length; j++)
    {
    	addSelectOption($("normalStateSelect"), DEFAULTNORMALSTATE_KEY[DEFAULTSTATE_VALUE[j]], DEFAULTSTATE_VALUE[j]);
    }
    
     btnStatus();
}

function getParentWinAIDArray()
{
    var parentAIDArray = [];
    var aid = null;
    for (var i = 0, len = parentWin.ctrlTable.getDataRowLength(); i < len; i ++)
    {
        aid = parentWin.ctrlTable.getCellStoreValue(i, "AID", "AID");
        parentAIDArray.push(aid);
    }
    
    return parentAIDArray;  
}

function initAIDTable()
{
    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;
    var parentAIDArray = getParentWinAIDArray();
    
    var netype = winobjParent["neType"];

	var aidarr = CONTROL_AID;
	if (netype == 71)
	{
		aidarr = CONTROL_AID;
	}
	else if (netype == 70)
	{
		aidarr = CONTROL_AID_3800A;
	}
	else if (netype == 66)
	{
		aidarr = CONTROL_AID_1800A;
	}
	
    for (var i = 0; i < aidarr.length; i ++)
    {
        if (parentAIDArray.contains(aidarr[i]))
        {
            continue;
        }
        
        obj = new Object();
        
        ptag = new ParamTag();
        ptag.value = aidarr[i];  
        obj["AID"] = ptag;
        
        dataInterface.rows.append(obj);
    }
    
    createTableBody(aidTable, window.tableconf[0], dataInterface, RESOURCE);     
}

function initControlTable()
{
    var netype = winobjParent["neType"];
    
    var dataInterface = new DataInterface();
    var obj = null;
    var ptag = null;
    
    var controltype = CONTROL_TYPE_VALUE;
    if (netype == 66)
    {
    	controltype = CONTROL_TYPE_VALUE_1800A;
    }
    
    for (var i = 0; i < controltype.length; i ++)
    {
        obj = new Object();
        
        ptag = new ParamTag();
        ptag.value = controltype[i];  
        obj["controlType"] = ptag;
        
        dataInterface.rows.append(obj);
    }
    
    createTableBody(controlTypeTable, window.tableconf[1], dataInterface, RESOURCE);
}

function initButton()
{
	$("okBtn").value =  RESOURCE["OK"];
	$("cancelBtn").value = RESOURCE["Cancel"];
	$("applyBtn").value = RESOURCE["Apply"];
	
	$("okBtn").onclick = okToAddCtrlProperty;
	$("cancelBtn").onclick = doCancel;
	$("applyBtn").onclick = applyCtrlProperty;
}

/**
 *       
 */
function setButtonDisabled(isDisabled)
{
	$("okBtn").disabled = isDisabled;
    $("cancelBtn").disabled = isDisabled;
    $("applyBtn").disabled = isDisabled;
}

 function applyCtrlProperty()
{
    setButtonDisabled(true);
    
    var xml = applyCtrlPropertyXML();
    
    var sfid = TECMDCODE_SONET_ADD_CONT_ITEMS;
    
    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", true, applyCtrlPropertyBack, null, "inputdata=" + xml);
}

function applyCtrlPropertyXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = null;
    var controlType = null;
    var dur = null;
    var controlState = null;
    var persistenceTime = null;
    var selectedRows = null;
    var defaultState = null;
    row = new tagElement("row-params");
   
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    selectedRows = aidTable.getSelectedRows();
    AID = aidTable.getCellStoreValue(selectedRows[0], "AID", "AID");
    param = new tagElement("param");
    param.setAttribute("name", "AID");
    param.setAttribute("value", AID);
    row.appendChild(param);
    
    selectedRows = controlTypeTable.getSelectedRows();
    controlType = controlTypeTable.getCellStoreValue(selectedRows[0], "controlType", "controlType");
    param = new tagElement("param");
    param.setAttribute("name", "conttype");
    param.setAttribute("value", controlType);
    row.appendChild(param);
    
    dur = DUR_CONTS;
    param = new tagElement("param");
    param.setAttribute("name", "dur");
    param.setAttribute("value", dur);
    row.appendChild(param);
    
    controlState = $("normalStateSelect").value;
    param = new tagElement("param");
    param.setAttribute("name", "constate");
    param.setAttribute("value", controlState);
    row.appendChild(param);

    defaultState = $("stateSelect").value;
    param = new tagElement("param");
    param.setAttribute("name", "defaultstate");
    param.setAttribute("value", defaultState);
    row.appendChild(param);
    
    persistenceTime = DEFAULT_PERSISTENCE_TIME;
    param = new tagElement("param");
    param.setAttribute("name", "TIME");
    param.setAttribute("value", persistenceTime);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    
    return root.toString(); 
}

function applyCtrlPropertyBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
        parentWin.queryCtrlProperty();
        var selectedRows = aidTable.getSelectedRows();
        for (var i = 0; i < selectedRows.length; i ++)
        {
            aidTable.deleteRow(selectedRows[i]);
        }    
        aidTable.adjustDataRows();
    }
    
    btnStatus();
}

function refreshParentWindow()
{
    var dataInterface = new DataInterface();
    var obj = new Object();
    var ptag = null;
    
    selectedRows = aidTable.getSelectedRows();
    AID = aidTable.getCellStoreValue(selectedRows[0], "AID", "AID");
    ptag = new ParamTag();
    ptag.value = AID;  
    obj["AID"] = ptag;
    
    selectedRows = controlTypeTable.getSelectedRows();
    controlType = controlTypeTable.getCellStoreValue(selectedRows[0], "controlType", "controlType");
    ptag = new ParamTag();
    ptag.value = controlType;  
    obj["conttype"] = ptag;
    
    dur = DUR_CONTS;
    ptag = new ParamTag();
    ptag.value = dur;  
    obj["dur"] = ptag;
    
    controlState = $("stateSelect").value;
    if (controlState == "NO")
    {
    	controlState = "RLS";
    }
    else if (controlState == "NC")
    {
    	controlState = "OPER";
    }
    
    ptag = new ParamTag();
    ptag.value = controlState;
    obj["constate"] = ptag;
    
    defaultState = $("normalStateSelect").value;
    ptag = new ParamTag();
    ptag.value = defaultState;
    obj["defaultstate"] = ptag;
    
    persistenceTime = DEFAULT_PERSISTENCE_TIME;
    ptag = new ParamTag();
    ptag.value = persistenceTime;  
    obj["TIME"] = ptag;
    
    dataInterface.rows.append(obj);

    createTableBody(parentWin.ctrlTable, parentWin.window.tableconf[0], dataInterface, RESOURCE); 
    parentWin.ctrlTable.adjustDataRows();    
}


 function okToAddCtrlProperty()
{
    if ($("applyBtn").disabled)
    {
        xcloseDialog();
        return;
    }
    
    setButtonDisabled(true);
    
    var xml = okToAddCtrlPropertyXML();
    
    var sfid = TECMDCODE_SONET_ADD_CONT_ITEMS;
    
    var url = "../../../../../../tl1NEExlorerServlet?sfid=" + sfid +"&nmUser=" + winurlobj["nmUser"];
    
    loadXMLdoc(url, "POST", true, okToAddCtrlPropertyBack, null, "inputdata=" + xml);
}

function okToAddCtrlPropertyXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");   
    var row = null;
    var param = null;
    var AID = null;
    var controlType = null;
    var dur = null;
    var controlState = null;
    var persistenceTime = null;
    var defaultState = null;
    
    var selectedRows = null;
    row = new tagElement("row-params");
   
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", winurlobj["neid"]);
    row.appendChild(param);
    
    selectedRows = aidTable.getSelectedRows();
    AID = aidTable.getCellStoreValue(selectedRows[0], "AID", "AID");
    param = new tagElement("param");
    param.setAttribute("name", "AID");
    param.setAttribute("value", AID);
    row.appendChild(param);
    
    selectedRows = controlTypeTable.getSelectedRows();
    controlType = controlTypeTable.getCellStoreValue(selectedRows[0], "controlType", "controlType");
    param = new tagElement("param");
    param.setAttribute("name", "conttype");
    param.setAttribute("value", controlType);
    row.appendChild(param);
    
    dur = DUR_CONTS;
    param = new tagElement("param");
    param.setAttribute("name", "dur");
    param.setAttribute("value", dur);
    row.appendChild(param);
    
    
    controlState = $("normalStateSelect").value;
    param = new tagElement("param");
    param.setAttribute("name", "constate");
    param.setAttribute("value", controlState);
    row.appendChild(param);

    defaultState = $("stateSelect").value;
    param = new tagElement("param");
    param.setAttribute("name", "defaultstate");
    param.setAttribute("value", defaultState);
    row.appendChild(param);
    
    persistenceTime = DEFAULT_PERSISTENCE_TIME;
    param = new tagElement("param");
    param.setAttribute("name", "TIME");
    param.setAttribute("value", persistenceTime);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString(); 
}

function okToAddCtrlPropertyBack(doc)
{
    var data = EncapsulateData(doc);
    var smallErrorCode = data.getSErrorCode();
    
    if (OPERATE_SUCCESS != smallErrorCode)
    {
        showErrorDialog(data);
    }
    else
    {
        parentWin.queryCtrlProperty();
        xcloseDialog();
    }
    btnStatus();
}

function showErrorDialog(data, errArr)
{
    var errorArray = null;
    if (null == errArr)
    {
        errorArray = new Array();
        errorArray.push("nename");
    }
    else
    {
        errorArray = errArr;
    }
    
    openErrPage("../../../../../../page/", data.getError(), errorArray); 
}

function btnStatus()
{
    var aidTableSRows = aidTable.getSelectedRows();
    var controlTypeTableSRows = controlTypeTable.getSelectedRows();
    if (aidTableSRows.length != 1 || controlTypeTableSRows.length != 1)
    {
        $("applyBtn").disabled = true;
    }
    else
    {
        $("applyBtn").disabled = false;
    }
    $("okBtn").disabled = false;
    $("cancelBtn").disabled = false;
}

/*
 *       
 */
function adjustHeight()
{
	var totalHeight = getComponetHeight($("topcontainer"),100);
	var totalWidth = document.body.clientWidth - 40;
	aidTable.headPack.style.width = totalWidth * 0.5;
	aidTable.bodyPack.style.width = totalWidth * 0.5;
	aidTable.setPageWidth();
	controlTypeTable.headPack.style.width = totalWidth * 0.5;
	controlTypeTable.bodyPack.style.width = totalWidth * 0.5;
	controlTypeTable.setPageWidth();
	
    aidTable.setBodyHeight(totalHeight+"px");
    controlTypeTable.setBodyHeight(totalHeight+"px");    
}

window.onresize = adjustHeight;

function justForTest()
{
    alert("justForTest");
}

function doCancel()
{
    xcloseDialog();
}

/**
 *  select    option   
 */
function addSelectOption(oListbox, sName, sValue)
{
    var oOption = document.createElement("option"); 
    
    oOption.appendChild(document.createTextNode(sName));
    
    oOption.setAttribute("value",sValue);

    oListbox.appendChild(oOption);
}

/**
 *       
 */
function setButtonDisabled(isDisabled)
{
	$("okBtn").disabled = true;
	$("cancelBtn").disabled = true;
	$("applyBtn").disabled = true;
}

/*
remove sorttable after page unload
user may override this function
*/
window.onunload=function()
{
    if(typeof(aidTable)!='undefined' && aidTable instanceof SortTable)
    {
		clearSortTable(aidTable);
	}
	
	if(typeof(controlTypeTable)!='undefined' && controlTypeTable instanceof SortTable)
    {
		clearSortTable(controlTypeTable);
	}
}
