
var ODU0_RANGE = [{min:1,max:100},{min:4353,max:4453},{min:7169,max:7269},{min:7681,max:7781},{min:11265,max:11365},{min:12289,max:12389},{min:17921,max:18021}];

var ODU1_RANGE = [{min:1,max:100},{min:8705,max:8805},{min:14337,max:14537},{min:19969,max:20069},{min:1408,max:1535}];

var ODU2_RANGE = [{min:1,max:100},{min:14849,max:14949},{min:20481,max:20581},{min:1664,max:1791},{min:4097,max:4108}];

var ODU3_RANGE = [{min:1,max:100},{min:20993,max:21993},{min:2048,max:2175},{min:1921,max:2047}];

var ODU4_RANGE = [{min:1,max:100},{min:2176,max:2303}];

var ODUFLEX_RANGE = [{min:1,max:100}, {min:4609,max:4709},{min:8193,max:8293},{min:13313,max:13413},{min:18945,max:19045}];

/*          */
var ODU0_GRADE = "528";
var ODU1_GRADE = "529";
var ODU2_GRADE = "530";
var ODU3_GRADE = "531";
var ODU4_GRADE = "533";
var ODU5G_GRADE = "532";
var ODUFLEX_GRADE = "534";

var SIMPLE_PORT_CRITICAL = 61;

var SIMPLE_PATH_CRITICAL = 1000;
var pidBoardShowPath = [];
pidBoardShowPath[4097] = 1665;
pidBoardShowPath[4098] = 1666;
pidBoardShowPath[4099] = 1667;
pidBoardShowPath[4100] = 1668;
pidBoardShowPath[4101] = 1669;
pidBoardShowPath[4102] = 1670;
pidBoardShowPath[4103] = 1671;
pidBoardShowPath[4104] = 1672;
pidBoardShowPath[4105] = 1673;
pidBoardShowPath[4106] = 1674;
pidBoardShowPath[4107] = 1675;
pidBoardShowPath[4108] = 1676;

var sevTypeTimeSlot = [];
sevTypeTimeSlot["65281"] = 1; //custom
sevTypeTimeSlot["3841"] = 1; //packet
sevTypeTimeSlot["1284"] = 4; //fc400
sevTypeTimeSlot["1289"] = 7; //fc800
sevTypeTimeSlot["1795"] = 3;//3gsdi
sevTypeTimeSlot["1796"] = 3;//3gsdirbr
sevTypeTimeSlot["3073"] = 3; //InfiniBand 2.5G
sevTypeTimeSlot["3332"] = 3; //CPRI4
sevTypeTimeSlot["3333"] = 4; //CPRI5
sevTypeTimeSlot["3334"] = 5; //CPRI6
sevTypeTimeSlot["1539"] = 4; //FICON4G
sevTypeTimeSlot["1541"] = 7; //FICON8G

var sevTypeODURate = [];
sevTypeODURate["65281"] = 1249245570; //custom
sevTypeODURate["3841"] = 1249245570; //packet
sevTypeODURate["1284"] = 4267857143; //fc400
sevTypeODURate["1289"] = 8535714286; //fc800
sevTypeODURate["1795"] = 2982478992;//3gsdi
sevTypeODURate["1796"] = 2979499525;//3gsdirbr
sevTypeODURate["3073"] = 2510504202; //InfiniBand 2.5G
sevTypeODURate["3332"] = 3084907563; //CPRI4
sevTypeODURate["3333"] = 4935852101; //CPRI5
sevTypeODURate["3334"] = 6169815126; //CPRI6
sevTypeODURate["1539"] = 4267857143; //FICON4G
sevTypeODURate["1541"] = 8535714286; //FICON8G

var win = getParentWindow();
var nePro = getNeProperty(win.top);




function getCurrentGradeRange(grade)
{
	var result = [];
	if(grade == ODU0_GRADE)
	{
		result = ODU0_RANGE;
	}
	if(grade == ODU1_GRADE)
	{
		result = ODU1_RANGE;
	}
	if(grade == ODU2_GRADE)
	{
		result = ODU2_RANGE;
	}
	if(grade == ODU3_GRADE)
	{
		result = ODU3_RANGE;
	}
	if(grade == ODU4_GRADE)
	{
		result = ODU4_RANGE;
	}
	if(grade == ODUFLEX_GRADE)
	{
		result = ODUFLEX_RANGE;
	}
	return result;
}

/**
 *                     
 */
function getCurrentAllPath(grade,pathArray,portid)
{
	var gradeRange = getCurrentGradeRange(grade);
	var resultList = [];
	for(var i = 0,len = pathArray.length;i < len;i++)
	{
		var path = pathArray[i];
		if(isRange(gradeRange,path))
		{
			if((path >= SIMPLE_PATH_CRITICAL && (typeof(portid) != "undefined" && portid >= SIMPLE_PORT_CRITICAL))
				|| (path < SIMPLE_PATH_CRITICAL && (typeof(portid) != "undefined" && portid < SIMPLE_PORT_CRITICAL)))
			{
				continue;
			}
			var pathName = getSimpleShowPathName(path);
			if(typeof(pathName) == "undefined")
			{
				pathName = path;
			}
			addCurrentPath(resultList,pathName,path);
		}
	}
	return resultList;
}

function getSimpleShowPathName(path)
{
	if (path >=4097 && path <=4108)
	{
		return wdmSimplePath[pidBoardShowPath[path]];
	}
	else
	{
		return wdmSimplePath[path];;
	}
}


/**
 *               
 */
function getCurrentFirstPath(grade,pathArray,portid)
{
	var gradeRange = getCurrentGradeRange(grade);
	var resultList = [];
	for(var i = 0,len = pathArray.length;i < len;i++)
	{
		var path = pathArray[i];
		if(isRange(gradeRange,path))
		{
			if((path >= SIMPLE_PATH_CRITICAL && (typeof(portid) != "undefined" && portid >= SIMPLE_PORT_CRITICAL))
				|| (path < SIMPLE_PATH_CRITICAL && (typeof(portid) != "undefined" && portid < SIMPLE_PORT_CRITICAL)))
			{
				continue;
			}
			return path;
		}
	}
	return null;
}
/**
 *                    
 */
function addCurrentPath(/*array*/pathList,/*string*/pathName,/*int*/pathid)
{
	var index = pathName.indexOf("-");
	var ochName = "";
	var otherName = pathName;
	if(index >= 0)
	{
		ochName = pathName.substring(0,index);
		otherName = pathName.substr(index+1);
	}
	var pathObject = getOCHFromCurrentPath(pathList,ochName);
	if(pathObject == null)
	{
		pathObject = new PathObject();
		pathObject.ochName = ochName;
		pathObject.pathArray.push({name:otherName,value:pathid});
		pathList.push(pathObject);
	}
	else
	{
		pathObject.pathArray.push({name:otherName,value:pathid});
	}
}

/**
 *   OCH          
 */
function getOCHFromCurrentPath(/*Array*/pathList,/*string*/ochName)
{
	var pathObject = null;
	for(var i = 0,len = pathList.length;i < len;i++)
	{
		if(pathList[i].ochName == ochName)
		{
			pathObject = pathList[i];
			break;
		}
	}
	return pathObject
}

/**
 *              
 */
function isRange(/*Array*/gradeRange,/*int*/value)
{
	
	for(var i = 0,len = gradeRange.length;i < len;i++)
	{
		if(gradeRange[i].min <= value && gradeRange[i].max >= value)
		{
			return true
		}
	}
	return false;
}

function convertHex(value)
{
	if (isNaN(value) || value == "" || value == null || typeof(value) == "undefined" || parseInt(value) == 0)
	{
	     return "0";
	}
	
	var hexvalue = tenToHex(value);
	var hexvalueZero = "0000000000000000" + hexvalue;
	return hexvalueZero.substring(hexvalueZero.length -16 ,hexvalueZero.length);
}

function isSupportODUFlexVersion()
{
	if (nePro != null)
	{
		var never = nePro.neversion;
		if (compare(never,"5.51.07.33") >= 0)
		{
			return true;
		}
	}
	return false;
}


function getODUServRate(level)
{
	var Const_Cm = 15230;
	var Const_Odu2 = 10037273924;//unit: bit/s
	var odtu2 = (476* Const_Odu2)/3824;
	var odurate = (Const_Cm*odtu2*level)/15232.0;
	return Math.round(odurate);
}
