loadXMLdoc("../../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../res/config/clock/clockres_" + SYSTEMCONF.getLanguage()
		+ ".xml");
loadXMLdoc("../../../../conf/board_attribute/config/clock/clockprioritytable_"
		+ SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable,
		null);

var st;

var CLOCK_SLOT_ID = 65535;// NGWDM          0xffff
var clockslotno = CLOCK_SLOT_ID;

var outclockmode = new Object();
outclockmode[0] = "outclockmode0";
outclockmode[1] = "outclockmode1";
outclockmode[2] = "empty";

var s1byte = new Object();
s1byte[0] = "s1byte0";
s1byte[1] = "s1byte1";
s1byte[2] = "s1byte2";
s1byte[3] = "s1byte3";
s1byte[4] = "s1byte4";
s1byte[5] = "empty";

var LINE_SOURCE = -1;
var INNER_SOURCE = 0;
var OUTER_SOURCE = 2;

var btnRightArr = new Object();

var neobject = getNeProperty(self);
var netype = neobject.netype;

function init()
{
	document.getElementById("querybtn").value = RESOURCE["query"];
	document.getElementById("applybtn").value = RESOURCE["apply"];
	document.getElementById("newbtn").value = RESOURCE["new"];
	document.getElementById("delbtn").value = RESOURCE["del"];

	st = new SortTable();
	st.setImage("../../../../../../images/");
	createTableHead(st, window.tableconf[0]);
	st.setOnCellEditHandler(cellEditHandler);

	document.getElementById("autoacross").appendChild(st.getTable());
	st.setBodyHeight(getTableHeight($("autoacross"), st) + "px");
	st.setOnRowSelectHandler(stSelectFun);

	btnRightArr.querybtn = new BtnRightObj("querybtn",
			TECMDCODE_GET_SCC_CLOCK_FROM_NE);
	btnRightArr.newbtn = new BtnRightObj("newbtn", TECMDCODE_SET_SCC_CLOCK);
	btnRightArr.delbtn = new BtnRightObj("delbtn", TECMDCODE_SET_SCC_CLOCK);
	btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_SCC_CLOCK);

	getRightInfo(neobject, btnRightArr);
	initrightbtn(btnRightArr);

	$("newbtn").disabled = true;
	$("delbtn").disabled = true;
	$("applybtn").disabled = true;

	if (btnRightArr.applybtn.right)
	{
		$("autoacross").oncontextmenu = rightlist;// popupMenuHandler1;
	}
	else
	{
		document.getElementById("down").disabled = true;
		document.getElementById("up").disabled = true;
		document.getElementById("newbtn").disabled = true;
		document.getElementById("delbtn").disabled = true;
		document.getElementById("applybtn").disabled = true;
	}

	if (btnRightArr.querybtn.right)
	{
		query();
	}
}

function cellEditHandler(param)
{
	if (btnRightArr.applybtn.right)
	{
		$("applybtn").disabled = false;
	}
}
function query()
{// document.getElementById("querybtn").disabled = true;
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	$("newbtn").disabled = true;
	$("delbtn").disabled = true;
	document.getElementById("down").disabled = true;
	document.getElementById("up").disabled = true;
	var xmlstr = createQueryXML();
	var urlreq = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_GET_SCC_CLOCK_EX + "&timeStamp=" + new Date().getTime()
			+ "&nmUser=" + neobject["nmUser"];

	loadXMLdoc(urlreq, "POST", true, updatePG, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	var neidvalue = getNeProperty(top).neid;
	param.setAttribute("name", "neid");
	param.setAttribute("value", neidvalue);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "AID");
	param.setAttribute("value", neobject.slotid);
	row.appendChild(param);

	bussiness.appendChild(row);

	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function updatePG(doc)
{
	$("querybtn").disabled = false;

	var data = EncapsulateData(doc);

	if (0 != data.getSErrorCode())
	{
		showErrorDialog(data);
		if (1 != data.getSErrorCode())
		{
			return;
		}
	}

	for ( var i = 0; i < st.getDataRowLength(); i++)
	{
		st.deleteRow(i);
	}
	st.adjustDataRows();

	createTableBody(st, window.tableconf[0], data, RESOURCE);

	for ( var j = 0; j < st.getDataRowLength(); j++)
	{
		var clockSourceType = st.getCellStoreValue(j, "clockid",
				"clockSourceType");

		var clockname = st.getCellCurrentValue(j, "clockname", "clockname");

		var clockidhex = st.getCellCurrentValue(j, "clockid", "clockidhex");

		if (clockname == "0")
		{
			st.setAtomValue(st.getCell(j, "clockname").element.showElement,
					RESOURCE["innersource"]);
		}

		if (clockidhex == "00000005")
		{//          

			st.setAtomValue(st.getCell(j, "clockname").element.showElement,
					RESOURCE["outersource"]);

			var modevalue = st.getCellCurrentValue(j, "outclockmode",
					"outclockmode");

			if (modevalue == 1)
			{
				st.setAtomValue(st.getCell(j, "s1byte").element.showElement,
						"-");
				st.getCell(j, "s1byte").element.ondblclick = null;
			}

			var cell = st.getCell(j, "outclockmode");
			tagCellEvent(cell, j);

		}
	}

	if (st.getDataRowLength() <= 0)
	{
		document.getElementById("newbtn").disabled = true;
	}
	else
	{
		if (btnRightArr.newbtn.right)
		{
			$("newbtn").disabled = false;
		}
	}
}

/**
 *                
 */
function stSelectFun()
{

	if (btnRightArr.applybtn.right)
	{
		var selcount = st.getSelectedRowCount();

		if (selcount > 1)
		{

			document.getElementById("up").disabled = true;
			document.getElementById("down").disabled = true;
		}
		else
		{

			document.getElementById("up").disabled = false;
			document.getElementById("down").disabled = false;
		}

		var rowsize = st.getDataRowLength();

		if (selcount <= 0)
		{
			document.getElementById("delbtn").disabled = true;
			return;
		}

		if (st.getRowSelFlag(rowsize - 1))
		{

			document.getElementById("delbtn").disabled = true;
			return;
		}

		document.getElementById("delbtn").disabled = false;
	}
}

function tagCellEvent(cell)
{
	var atom = cell.element.editElement;
	atom.element["onchange"] = function()
	{
		var v = this.value;
		var rowindex = this.parentNode.parentNode.rowIndex;
		if (v == 1)
		{
			st.setAtomValue(st.getCell(rowindex, "s1byte").element.showElement,
					"-");
			st.getCell(rowindex, "s1byte").element.ondblclick = null;
		}
		else
		{
			st.setAtomValue(st.getCell(rowindex, "s1byte").element.showElement,
					RESOURCE["s1byte2"]);
			st.getCell(rowindex, "s1byte").element.ondblclick = cellondbclick;
			st.setCellValue(st.getCell(rowindex, "s1byte"), "s1byte", "2");

		}
	}
}

function testdata()
{
	var rowsize = st.getDataRowLength();
	for ( var j = 0; j < st.getDataRowLength(); j++)
	{
		if (st.getRowSelFlag(j))
		{
			var s = st.getCellCurrentValue(j, "outclockmode", "outclockmode");
			alert("outclockmode" + s);
			s = st.getCellCurrentValue(j, "s1byte", "s1byte");
			alert("s1byte" + s);
			s = st.getCellCurrentValue(j, "clockid", "clockid");
			alert("clockid" + s);
		}
	}

}

function setClockPriority()
{
	$("applybtn").disabled = true;

	var xmlstr = createSetXML();
	var urlreq = "../../../../../../tl1NEExlorerServlet?sfid="
			+ TECMDCODE_SET_SCC_CLOCK_EX + "&timeStamp=" + new Date().getTime()
			+ "&nmUser=" + neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, refreshWorkBoard, null, "inputdata="
			+ xmlstr);
}

function createSetXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = new tagElement("row-params");

	var param = new tagElement("param");
	var neidvalue = getNeProperty(top)["neid"];
	param.setAttribute("name", "neid");
	param.setAttribute("value", neidvalue);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", neobject.slotid);
	row.appendChild(param);
	
	var clockid = st.getCellStoreValue(0, "clockid", "clockport");
	for ( var i = 1; i < st.getDataRowLength(); i++)
	{
		clockid = clockid + "," + st.getCellStoreValue(i, "clockid", "clockport");
	}
	param = new tagElement("param");
	param.setAttribute("name", "clockid");
	param.setAttribute("value", clockid);
	row.appendChild(param);

	bussiness.appendChild(row);

	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function refreshWorkBoard(doc)
{
	var data = EncapsulateData(doc);

	if (0 != data.getSErrorCode())
	{
		document.getElementById("applybtn").disabled = false;
		showErrorDialog(data);
		return;
	}
	refreshTableState(st, window.tableconf[0], data);
}

function showErrorDialog(data)
{
	for ( var i = 0; i < data.getBErrLength(); i++)
	{
		var tempObj = data.getError().rowErrors[i].errorObj;
		tempObj["operateObj"] = RESOURCE["clocksourcepriority"];
	}
	var errArr = [];
	errArr[0] = "operateObj";

	openErrPage("../../../../../../page/", data.getError(), errArr);
}

function newClock()
{
	hideMenu();
	xshowModalDialog("newclockdiglog.html", RESOURCE["addclock"], 340, 400,
			"../../../../../../images/");
}

/*
 *      
 */
function upchangerow()
{
	var rowsize = st.getDataRowLength();

	if (rowsize == 1)
	{
		return;
	}

	for ( var i = 0; i < rowsize; i++)
	{
		if (st.getRowSelFlag(i))
		{
			if (i == 0 || i == (rowsize - 1))
			{
				return;
			}
			else
			{
				$("applybtn").disabled = false;
				swapTableRow(i, i - 1);
				break;

			}
		}

	}

}

/*
 *      
 */
function downchangerow()
{
	var rowsize = st.getDataRowLength();

	if (rowsize == 1)
	{
		return;
	}
	for ( var i = 0; i < rowsize; i++)
	{
		if (st.getRowSelFlag(i))
		{
			if (i == (rowsize - 2) || i == (rowsize - 1))
			{
				return;
			}
			else
			{
				$("applybtn").disabled = false;
				swapTableRow(i + 1, i);
				i = i + rowsize;
			}
		}

	}

}

/**
 *      
 */
function swapTableRow(src, des)
{
	var srcrow = st.getRow(src);

	var drow = st.getRow(des);

	st.element.datarows[des] = srcrow;
	st.element.datarows[src] = drow;

	srcrow.element.swapNode(drow.element);

}

/**
 *      
 */
function delclock()
{

	var rowsize = st.getDataRowLength();
	for ( var j = 0; j < st.getDataRowLength() - 1; j++)
	{
		if (st.getRowSelFlag(j))
		{
			st.deleteRow(j);
		}
	}
	st.adjustDataRows();

	$("applybtn").disabled = false;
	$("delbtn").disabled = true;

}

/**
 *         
 */
function addclock(data)
{
	var index = st.getDataRowLength();

	insertTableRowAt(st, window.tableconf[0], data, RESOURCE, index);

	index -= 1;
	var clockid = st.getCellStoreValue(index, "clockid", "clockid");

	var clockSourceType = st.getCellStoreValue(index, "clockid",
			"clockSourceType");

	if (clockSourceType == "0")
	{
		st.setAtomValue(st.getCell(index, "clockname").element.showElement,
				RESOURCE["innersource"]);
	}

	var clockname = st.getCellCurrentValue(index, "clockname", "clockname");
	if (clockSourceType == OUTER_SOURCE)
	{//          

		if (netype != 79)
		{
			st.setAtomValue(st.getCell(index, "clockname").element.showElement,
					RESOURCE["outersource"]
							+ "("
							+ st.getCellStoreValue(index, "clockid",
									"clockidhex") + ")");
		}
		else
		{
			st.setAtomValue(st.getCell(index, "clockname").element.showElement,
					RESOURCE["outersource"] + clockname);
		}
		var cell = st.getCell(index, "outclockmode");
		tagCellEvent(cell);

	}

	$("applybtn").disabled = false;
}

/**
 *       
 */
function rightlist()
{
	removejsDOMmenu();
	var cursorMenu1 = new jsDOMenu(120);

	cursorMenu1
			.addMenuItem(new menuItem(RESOURCE["addclock"], "", newClock, ""));

	var isSelected = false;
	var rowsize = st.getDataRowLength();
	for ( var i = 0; i < rowsize - 1; i++)
	{
		if (st.getRowSelFlag(i))
		{
			isSelected = true;
			break;
		}
	}

	if (st.getRowSelFlag(rowsize - 1))
	{
		isSelected = false;
	}

	if (isSelected)
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["delclock"], "",
				delclock, ""));
	}

	setPopUpMenu(cursorMenu1);
	rightClickHandler();
}

function createQuerySlotXML()
{
	di = new inputxml("datainterface");
	bussiness = new tagElement("bussiness-params");
	row = new tagElement("row-params");
	param = new tagElement("param");
	neidvalue = getNeProperty(top).neid;
	param.setAttribute("name", "neid");
	param.setAttribute("value", neidvalue);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();

}
